<?php

defined('ABSPATH') or die("No script kiddies please!");

$menu_enable_disable = isset($_POST['menu_enable_disable']) ? sanitize_text_field($_POST['menu_enable_disable']) : '0';
$menu_mobile_enable_disable = isset($_POST['mobile_menu_enable_disable']) ? sanitize_text_field($_POST['mobile_menu_enable_disable']) : '0';
$menu_tablets_enable_disable = isset($_POST['tablet_menu_enable_disable']) && !empty($_POST['tablet_menu_enable_disable']) ? sanitize_text_field($_POST['tablet_menu_enable_disable']) : '0';
$menu_bigger_screen_enable_disable = isset($_POST['bigger_screen_menu_enable_disable']) && !empty($_POST['bigger_screen_menu_enable_disable']) ? sanitize_text_field($_POST['bigger_screen_menu_enable_disable']) : '0';
$responsive_n_different_menu_enable_disable = isset($_POST['responsive_n_different_menu_enable_disable']) && !empty($_POST['responsive_n_different_menu_enable_disable']) ? sanitize_text_field($_POST['responsive_n_different_menu_enable_disable']) : '0';

$page_specific_category_enable_disable = isset($_POST['page_specific_category_enable_disable']) ? sanitize_text_field($_POST['page_specific_category_enable_disable']) : '0';
$menu_link_disable_fa = isset($_POST['menu_link_disable_fa']) ? sanitize_text_field($_POST['menu_link_disable_fa']) : '0';

//Sanitizing Menu for Desktop
$menu_select_middle_right = isset($_POST['menu_list_select_mr']) ? sanitize_text_field($_POST['menu_list_select_mr']) : 'default';
$menu_select_top_right = isset($_POST['menu_list_select_tr']) ? sanitize_text_field($_POST['menu_list_select_tr']) : 'default';
$menu_select_bottom_right = isset($_POST['menu_list_select_br']) ? sanitize_text_field($_POST['menu_list_select_br']) : 'default';
$menu_select_middle_left = isset($_POST['menu_list_select_ml']) ? sanitize_text_field($_POST['menu_list_select_ml']) : 'default';
$menu_select_top_left = isset($_POST['menu_list_select_tl']) ? sanitize_text_field($_POST['menu_list_select_tl']) : 'default';
$menu_select_bottom_left = isset($_POST['menu_list_select_bl']) ? sanitize_text_field($_POST['menu_list_select_bl']) : 'default';
$menu_select_bottom_center = isset($_POST['menu_list_select_bc']) ? sanitize_text_field($_POST['menu_list_select_bc']) : 'default';

//Sanitizing Menu for Responsive
$menu_select_resp_middle_right = isset($_POST['menu_list_select_resp_mr']) ? sanitize_text_field($_POST['menu_list_select_resp_mr']) : 'default';
$menu_select_resp_top_right = isset($_POST['menu_list_select_resp_tr']) ? sanitize_text_field($_POST['menu_list_select_resp_tr']) : 'default';
$menu_select_resp_bottom_right = isset($_POST['menu_list_select_resp_br']) ? sanitize_text_field($_POST['menu_list_select_resp_br']) : 'default';
$menu_select_resp_middle_left = isset($_POST['menu_list_select_resp_ml']) ? sanitize_text_field($_POST['menu_list_select_resp_ml']) : 'default';
$menu_select_resp_top_left = isset($_POST['menu_list_select_resp_tl']) ? sanitize_text_field($_POST['menu_list_select_resp_tl']) : 'default';
$menu_select_resp_bottom_left = isset($_POST['menu_list_select_resp_bl']) ? sanitize_text_field($_POST['menu_list_select_resp_bl']) : 'default';
$menu_select_resp_bottom_center = isset($_POST['menu_list_select_resp_bc']) ? sanitize_text_field($_POST['menu_list_select_resp_bc']) : 'default';

$menu_enable_offset_to_position = isset($_POST['menu_enable_offset_to_position']) ? sanitize_text_field($_POST['menu_enable_offset_to_position']) : '0';
$default_pages = isset($_POST['default_page']) ? array_map('sanitize_text_field', $_POST['default_page']) : '';

$default_pages = isset($default_pages) ? maybe_serialize($default_pages) : '-1';

$menu_show_hide_on = sanitize_text_field($_POST['menu_show_hide_on']);
$menu_link_add_nofollow = isset($_POST['menu_link_add_nofollow']) ? sanitize_text_field($_POST['menu_link_add_nofollow']) : '0';
if (isset($_POST['page_specific_display'])) {
    $menu_show_hide_page_specific = $_POST['page_specific_display'];
    if (isset($menu_show_hide_page_specific)) {
        $menu_show_hide_page_specific = $menu_show_hide_page_specific;
    } else {
        $menu_show_hide_page_specific = array();
    }
} else {
    $menu_show_hide_page_specific = array();
}
$floating_menu_settings = array();

$floating_menu_settings['menu_enable_disable'] = $menu_enable_disable;
$floating_menu_settings['mobile_menu_enable_disable'] = $menu_mobile_enable_disable;
$floating_menu_settings['tablet_menu_enable_disable'] = $menu_tablets_enable_disable;
$floating_menu_settings['bigger_screen_menu_enable_disable'] = $menu_bigger_screen_enable_disable;
$floating_menu_settings['menu_link_add_nofollow'] = $menu_link_add_nofollow;

//Storing Menu into option table for Desktop
$floating_menu_settings['menu_list_select_mr'] = $menu_select_middle_right;
$floating_menu_settings['menu_list_select_tr'] = $menu_select_top_right;
$floating_menu_settings['menu_list_select_br'] = $menu_select_bottom_right;
$floating_menu_settings['menu_list_select_ml'] = $menu_select_middle_left;
$floating_menu_settings['menu_list_select_tl'] = $menu_select_top_left;
$floating_menu_settings['menu_list_select_bl'] = $menu_select_bottom_left;
$floating_menu_settings['menu_list_select_bc'] = $menu_select_bottom_center;

//Storing Menu into option table for Reponsive
$floating_menu_settings['menu_list_select_resp_mr'] = $menu_select_resp_middle_right;
$floating_menu_settings['menu_list_select_resp_tr'] = $menu_select_resp_top_right;
$floating_menu_settings['menu_list_select_resp_br'] = $menu_select_resp_bottom_right;
$floating_menu_settings['menu_list_select_resp_ml'] = $menu_select_resp_middle_left;
$floating_menu_settings['menu_list_select_resp_tl'] = $menu_select_resp_top_left;
$floating_menu_settings['menu_list_select_resp_bl'] = $menu_select_resp_bottom_left;
$floating_menu_settings['menu_list_select_resp_bc'] = $menu_select_resp_bottom_center;

$floating_menu_settings['menu_show_hide_on'] = $menu_show_hide_on;
$floating_menu_settings['page_specific_display'] = $menu_show_hide_page_specific;
$floating_menu_settings['page_specific_category_enable_disable'] = $page_specific_category_enable_disable;
$floating_menu_settings['menu_link_disable_fa'] = $menu_link_disable_fa;

$floating_menu_settings['responsive_n_different_menu_enable_disable'] = $responsive_n_different_menu_enable_disable;

$floating_menu_settings['menu_enable_offset_to_position'] = $menu_enable_offset_to_position;

$floating_menu_settings['default_page'] = $default_pages;

update_option('wpfm-settings', $floating_menu_settings);
$_SESSION['wpfmp_message'] = __('Settings Saved', 'wp-floating-menu-pro');
wp_redirect(admin_url('admin.php?page=wpfm_menu_setting'));
exit();

