<?php

defined('ABSPATH') or die("No script kiddies please!");
global $wpdb;
$allowed_html = array(
    'a' => array(
        'href' => array(),
    ),
    'br' => array(),
);

if ((isset($_POST['wpfm_add_nonce_save_menu_fields']) && isset($_POST['wpfm_save_menu_fields']) && wp_verify_nonce($_POST['wpfm_add_nonce_save_menu_fields'], 'wpfm_nonce_save_menu_fields') && current_user_can('manage_options'))) {
    foreach ($_POST as $key => $val) {
        if ($key == 'menu_structure' || $key == 'menu_design') {
            $$key = $val;
        } else {
            $$key = sanitize_text_field($val);
        }
    }
    /** Sanitizing each form fields for Menu field added */
    $menu_structure_temp = array();
    foreach ($menu_structure as $key => $val) {
        $menu_structure_temp[$key] = array();
        foreach ($val as $k => $v) {
            if (!is_array($v)) {
                if ($k == 'wpfm_custom_mod_popup_content') {
                    $str = wp_kses($v, $allowed_html);
                    $menu_structure_temp[$key][$k] = $str;
                } else {
                    $menu_structure_temp[$key][$k] = sanitize_text_field($v);
                }
            } else {
                if ($k == 'wpfm_custom_mod_popup_content') {
                    $str = wp_kses($v, $allowed_html);
                } else if($k == 'wpfm_userrole'){
                 $menu_structure_temp[$key][$k] = array_map('sanitize_text_field',$v);
             }else {
                $menu_structure_temp[$key][$k] = array_map(wp_kses($v, $allowed_html), $v);
            }
        }
    }
}
    // var_dump($menu_structure_temp);
    //die();
$menu_structure = $menu_structure_temp;
$menu_settings = array();
$menu_settings = isset($menu_structure) ? $menu_structure : array();
$current_menu_name = sanitize_text_field($_POST['wpfm_save_menu_name']);
$current_menu_id = $_POST['current_menu_id'];
$table_name = $wpdb->prefix . "wp_floating_menu_details";
/** Condition to save current menu display setting values */
$menu_settings2 = array();
$menu_settings2['menu_design'] = array_map('sanitize_text_field', $menu_design);
$current_menu_id = $_POST['current_menu_id'];
$update = $wpdb->update(
    $table_name, array(
        'menu_name' => $current_menu_name,
        'menu_details' => maybe_serialize($menu_settings),
        'menu_display_setting_details' => maybe_serialize($menu_settings2)
    ), array(
        'ID' => $current_menu_id
    ), array(
        '%s',
        '%s',
        '%s'
    ), array(
        '%d'
    ));
if ($update) {
    $_SESSION['wpfmp_message'] = __('Menu Saved and Updated.', 'wp-floating-menu-pro');
    wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin&action=wpfmp-edit-menu&id=' . $current_menu_id);
} else {
    $_SESSION['wpfmp_message'] = __('No Changes Made.', 'wp-floating-menu-pro');
    wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin&action=wpfmp-edit-menu&id=' . $current_menu_id);
}
} else {
    die('No script kiddies please!');
}