<?php defined('ABSPATH') or die("No script kiddies please!"); ?>

<?php
$submit_field_data = sanitize_text_field($_POST['submit_field_data']);
if ($submit_field_data == 3) {
    $field_data = sanitize_text_field($_POST['field_data']);
    $page_data = sanitize_text_field($_POST['page_value']);
    $page_title = get_cat_name($page_data);
    $page_permalink = get_category_link($page_data);
} else if ($submit_field_data == 0 || $submit_field_data == 1) {
    $field_data = sanitize_text_field($_POST['field_data']);
    $page_data = get_page($page_id);
    $page_title = $page_data->post_title;
    $page_permalink = get_permalink($page_data);
} else if ($submit_field_data == 2) {
    $field_data = sanitize_text_field($_POST['custom_link_field_data']);
    $custom_link_name = sanitize_text_field($_POST['custom_link_name']);
    $custom_link_url = sanitize_text_field($_POST['custom_link_url']);
    $page_title = $custom_link_name;
    $page_permalink = $custom_link_url;
}
?>
<ul class="wpfm-menu ui-sortable" id="wpfm-menu-to-edit">
    <li id="wpfm-menu-item" class="wpfm-menu-item">
        <div class="wpfm-menu-item-bar">
            <div class="wpfm-menu-item-handle">
                <span class="wpfm-item-title">
                    <span class="wpfm-menu-item-title"><?php echo $page_title; ?></span> 
                </span>
                <span class="wpfm-item-type"><?php echo $field_data; ?></span>
                <span class="wpfm-ind-menu-toggle-icon"><i class="fa fa-sort-down"></i></span>                   
            </div>
        </div>
        <div class="wpfm-menu-item-settings" id="wpfm-menu-item-settings" style="display:none">
            <div class="wpfm-description wpfm-description-wide">
                <label class="wpfm-menu-label-controller" for="wpfm_menu_item_title"><?php _e('Navigation Label', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input type="text" id="wpfm-edit-menu-item-item-title" class="wpfm-edit-menu-item-title" name="menu_structure[menu_id][wpfm_menu_item_title]" value="<?php echo $page_title; ?>" data-field-name="menu_id" />
                </div>
            </div>

            <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                <label class="wpfm-menu-label-controller"><?php _e('Show Navigation Label', 'wp-floating-menu-pro'); ?></label>
                <label class="wpfm-menu-label-controller" for="wpfm-navigation-show-hide">                  
                    <input type="checkbox" id="wpfm-navigation-show-hide" value="1" name="menu_structure[menu_id][wpfm_title_show]" data-field-name="menu_id" /><?php _e('Show/Hide', 'wp-floating-menu-pro'); ?></label>
            </div>
            <div class="wpfm-description wpfm-description-wide">
                <label class="wpfm-menu-label-controller" for="wpfm_menu_item_title_attribute"><?php _e('Title Attribute', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input type="text" id="wpfm-edit-menu-title-attribute" class="wpfm-edit-menu-item-title-attribute" name="menu_structure[menu_id][wpfm_menu_item_title_attribute]" data-field-name="menu_id" />
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                <label class="wpfm-menu-label-controller"><?php _e('Show Tooltip Title', 'wp-floating-menu-pro'); ?></label>
                <label class="wpfm-menu-label-controller">           
                    <input type="checkbox" id="wpfm-tooltip-show-hide" value="1" name="menu_structure[menu_id][wpfm_tooltip_show]" data-field-name="menu_id"/>                       					
                    <?php _e('Show/Hide', 'wp-floating-menu-pro'); ?></label>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-edit-menu-tooltip-wrap" style="display:none;">
                <label class="wpfm-menu-tooltip-title" for="wpfm_menu_tooltip_title"><?php _e('Tooltip Title', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input type="text" id="wpfm-edit-menu-tooltip" class="wpfm-edit-menu-tooltip-title" name="menu_structure[menu_id][wpfm_menu_tooltip_title]" data-field-name="menu_id"/>
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-field-targer-link">
                <label for="wpfm_target_link_address"><?php _e('Target Link', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input type="text" id="wpfm-edit-menu-item-title" class="wpfm-edit-menu-item-title" name="menu_structure[menu_id][wpfm_target_link_address]"  data-field-name="menu_id" value="<?php echo $page_permalink; ?>"/>
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                <label class="wpfm-menu-label-controller"><?php _e('Open Link in New Tab', 'wp-floating-menu-pro'); ?></label>
                <label class="wpfm-menu-label-controller" for="wpfm-field-link-target">     
                    <input type="checkbox" class="wpfm-checkbox" id="wpfm-field-link-target" value="1" name="menu_structure[menu_id][wpfm_field_link_target]" data-field-name="menu_id" />                				
                    <?php _e('New Tab/Same Tab ', 'wp-floating-menu-pro'); ?>
                </label>			
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-field-targer-link">
                <label for="wpfm_custom_class"><?php _e('Custom Class', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input type="text" id="wpfm-edit-menu-item-class" class="wpfm-edit-menu-item-class" name="menu_structure[menu_id][wpfm_custom_class]"  data-field-name="menu_id" />
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-field-targer-link">
                <label for="wpfm-edit-menu-item-link-relation"><?php _e('Link Relationship (XFN)', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input type="text" id="wpfm-edit-menu-item-link-relation" class="wpfm-edit-menu-item-link-relation" name="menu_structure[menu_id][wpfm_xfn_relationship]"  data-field-name="menu_id" />
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                <label class="wpfm-menu-label-controller">
                    <?php _e('Modal Popup For This Menu', 'wp-floating-menu-pro'); ?>
                </label>
                <label class="wpfm-menu-label-controller">                        
                    <input type="checkbox" class="wpfm-checkbox" id="wpfm-field-modal-pp-target" value="1" name="menu_structure[menu_id][wpfm_field_enable_modal_pp]" data-field-name="menu_id" />                				
                    <?php _e('Enable/Disable', 'wp-floating-menu-pro'); ?></label>
                </label>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-popup-content-wrap" id="wpfm-menu-item-type-field" style="display:none;">
                <label for="wpfm_custom_mod_popup_content">
                    <?php _e('Modal Popup Content', 'wp-floating-menu-pro'); ?>
                </label>
                <div class="menu-inner-input-field">
                    <textarea id="wpfm-menu-popup-content" class="wpfm-edit-menu-item-class" name="menu_structure[menu_id][wpfm_custom_mod_popup_content]" placeholder="<?php _e('You can insert shortcode or basic text content here', 'wp-floating-menu-pro'); ?>" data-field-name="menu_id"></textarea>
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-type-field" id="wpfm-field-add-menu-type">
                <label for="wpfm_edit_menu_icons_type"><?php _e('Menu Icon Type', 'wp-floating-menu-pro'); ?></label>
                <select name="menu_structure[menu_id][icon_icon_type]"  data-field-name="menu_id" class="wpfm-icon-type">
                    <option value="default"><?php _e('Use Default Icon', 'wp-floating-menu-pro'); ?></option>
                    <option value="custom"><?php _e('Use Custom Icon', 'wp-floating-menu-pro'); ?></option>
                    <option value="image-icon"><?php _e('Use Image Icon', 'wp-floating-menu-pro'); ?></option>
                </select>	
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field" id="wpfm-field-add-menu-icons">
                <label for="wpfm_edit_menu_icons"><?php _e('Default Icon:', 'wp-floating-menu-pro'); ?></label>
                <span>
                    <input class="wpfm-icon-picker" type="hidden" id="wpfm-icon-picker-icon" name="menu_structure[menu_id][icon_picker_settings]" data-field-name="menu_id"/>
                    <div id="wpfm-menu-icon-div" data-target="#wpfm-icon-picker-icon" class="button icon-picker <?php
                    if (isset($options['icon'])) {
                        $v = explode('|', $options['icon']);
                        echo $v[0] . ' ' . $v[1];
                    }
                    ?>"><?php _e('Select Icon', 'wp-floating-menu-pro'); ?></div>
                </span>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field" id="wpfm-field-add-custom-menu-icons" style="display:none;">
                <label class="wpfm-menu-label-controller" for="icon_picker_custom"><?php _e('Custom Icon:', 'wp-floating-menu-pro'); ?></label>
                <div class="menu-inner-input-field">
                    <input class="wpfm-icon-custom" type="text" id="wpfm-icon-picker-custom" name="menu_structure[menu_id][icon_picker_custom]" data-field-name="menu_id" placeholder="<?php _e('Eg:-', 'wp-floating-menu-pro'); ?> fa fa-bars"/>
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field" id="wpfm-field-add-custom-image-icons" style="display:none">
                <label class="wpfm-menu-label-controller" for="icon_picker_image_custom">
                    <?php _e('Image Icon:', 'wp-floating-menu-pro'); ?>
                </label>
                <div class="menu-inner-input-field">
                    <span class="wpfm-image-preview"><img src="<?php echo WPFM_PRO_IMAGE_DIR . 'default-image-icon.png'; ?>" style="width:25px; height:25px; box-shadow: 2px 0px 10px 1px;"/></span>
                    <input class="wpfm-icon-image-custom" type="text" id="wpfm-icon-picker-image-custom" name="menu_structure[menu_id][icon_picker_image_custom]" data-field-name="menu_id"/>
                    <input class="wpfm-icon-image-custom-upload button button-primary" type="button" value="Upload Icon">
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field">
                <label class="wpfm-menu-label-controller" for="icon_color_type"><?php _e('Icon Color Type', 'wp-floating-menu-pro'); ?></label>
                <select name="menu_structure[menu_id][icon_color_type]"  data-field-name="menu_id" class="wpfm-icon-color-type">
                    <option value="default"><?php _e('Use Default', 'wp-floating-menu-pro'); ?></option>
                    <option value="custom"><?php _e('Use Custom Color', 'wp-floating-menu-pro'); ?></option>
                </select>					
            </div>
            <div class="wpfm-menu-icon-color-setting wpfm-menu-icon-field" id="wpfm-menu-icon-color-setting" style="display:none;">
                <div class="wpfm-description wpfm-description-wide">
                    <label class="wpfm-menu-label-controller" for="menu_icon_color">
                        <?php _e('Icon color', 'wp-floating-menu-pro'); ?>
                    </label>
                    <div class="menu-inner-input-field">
                        <input type="text" name="menu_structure[menu_id][menu_icon_color]" data-field-name="menu_id" id="menu-icon-color" class="wpfm-colorpicker-trigger" />
                    </div>
                </div>
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field">
                <label class="wpfm-menu-label-controller" for=""><?php _e('User Control', 'wp-floating-menu-pro'); ?></label>
                <select name="menu_structure[menu_id][check_user_log]"  data-field-name="menu_id" class="wpfm-icon-user-type">
                    <option value="all"><?php _e('All Users', 'wp-floating-menu-pro'); ?></option>
                    <option value="logged-in"><?php _e('Only Logged In User', 'wp-floating-menu-pro'); ?></option>
                </select>					
            </div>
            <div class="wpfm-description wpfm-description-wide wpfm-user-role-checkbox" style="display:none;">
                <label class="wpfm-menu-label-controller" for="wpfm_userrole">
                    <?php _e('User Role For Logged in', 'wp-floating-menu-pro'); ?>
                </label>
                <div class="wpfm-user-control-label-controller-input">
                    <?php
                    $wpfm_default_user_lists = $this->wpfm_get_default_user_list();
                    if (!empty($wpfm_default_user_lists)) {
                        foreach ($wpfm_default_user_lists as $wpb_add_menu_user_key => $wpb_add_menu_value):
                            ?>
                            <label class="wpfm-menu-label-inner-controller">
                                <input type="checkbox" class="wpfm-user-role" value="<?php echo esc_attr($wpb_add_menu_user_key); ?>" name="menu_structure[menu_id][wpfm_userrole][]" data-field-name="menu_id"/>
                                <?php echo esc_attr($wpb_add_menu_user_key); ?>
                            </label>					
                            <?php
                        endforeach;
                    }
                    ?>
                </div>
            </div>
            <div class="wpfm-field-remove">
                <a href="#" class="wpfm-remove-menu"><?php _e('Remove', 'wp-floating-menu-pro'); ?></a>
            </div>            
        </div><!-- .menu-item-settings-->

        <input type="hidden" name="menu_structure[menu_id][item_value]"  data-field-name="menu_id" value="<?php echo $page_title; ?>" />
        <input type="hidden" name="menu_structure[menu_id][field_data]"  data-field-name="menu_id" value="<?php echo $field_data; ?>" />
    </li>
</ul>