<?php

defined('ABSPATH') or die("No script kiddies please!");
global $wp_query, $post, $wpdb;

$wpfm_settings = get_option(WPFM_SETTINGS);
$enable_menu = esc_attr($wpfm_settings['menu_enable_disable']);

$enable_menu_on_mobile = isset($wpfm_settings['mobile_menu_enable_disable']) && $wpfm_settings['mobile_menu_enable_disable'] == 0 ? esc_attr($wpfm_settings['mobile_menu_enable_disable']) : 1; /* Enable Disable Menu for mobile version */
$enable_menu_on_tablets = isset($wpfm_settings['tablet_menu_enable_disable']) && $wpfm_settings['tablet_menu_enable_disable'] == 0 ? 0 : 1;
$enable_menu_on_big_screens = isset($wpfm_settings['bigger_screen_menu_enable_disable']) && $wpfm_settings['bigger_screen_menu_enable_disable'] == 0 ? 0 : 1;

$default_menu = isset($wpfm_settings['menu_list_selected']) && !empty($wpfm_settings['menu_list_selected']) ? esc_attr($wpfm_settings['menu_list_selected']) : ''; /* Menu value from option table */
$show_pages_wise_menu = esc_attr($wpfm_settings['menu_show_hide_on']); /* Display hide menu on specific page, home page or specific page */

$default_middle_right_menu = isset($wpfm_settings['menu_list_select_mr']) && !empty($wpfm_settings['menu_list_select_mr']) ? esc_attr($wpfm_settings['menu_list_select_mr']) : '';
$default_top_right_menu = isset($wpfm_settings['menu_list_select_tr']) && !empty($wpfm_settings['menu_list_select_tr']) ? esc_attr($wpfm_settings['menu_list_select_tr']) : '';
$default_bottom_right_menu = isset($wpfm_settings['menu_list_select_br']) && !empty($wpfm_settings['menu_list_select_br']) ? esc_attr($wpfm_settings['menu_list_select_br']) : '';
$default_middle_left_menu = isset($wpfm_settings['menu_list_select_ml']) && !empty($wpfm_settings['menu_list_select_ml']) ? esc_attr($wpfm_settings['menu_list_select_ml']) : '';
$default_top_left_menu = isset($wpfm_settings['menu_list_select_tl']) && !empty($wpfm_settings['menu_list_select_tl']) ? esc_attr($wpfm_settings['menu_list_select_tl']) : '';
$default_bottom_left_menu = isset($wpfm_settings['menu_list_select_bl']) && !empty($wpfm_settings['menu_list_select_bl']) ? esc_attr($wpfm_settings['menu_list_select_bl']) : '';
$default_bottom_center_menu = isset($wpfm_settings['menu_list_select_bc']) && !empty($wpfm_settings['menu_list_select_bc']) ? esc_attr($wpfm_settings['menu_list_select_bc']) : '';
$page_specific_category_enable_disable = isset($wpfm_settings['page_specific_category_enable_disable']) ? esc_attr($wpfm_settings['page_specific_category_enable_disable']) : '0';

if (!is_404()) {
    $current_page_id = $wp_query->post->ID;
    $page_wise_bar_id = $this->wpfm_get_page_base_menu($post->ID);
} else {
    $current_page_id = '';
    $page_wise_bar_id = '';
}
$categories = get_the_category();
if (!empty($categories)) {
    $category_id = $categories[0]->cat_ID;
} else {
    $category_id = '';
}
/**
 * Pull Page wise Meta Data 
 */
$popup_pagewise_datas = $this->wpfm_get_page_base_popup_data($current_page_id); /* Get all the values from individual page */

$page_wise_bar_id = !empty($post->ID) ? $this->wpfm_get_page_base_menu($post->ID) : '';
$page_wise_menu_middle_right = esc_attr($popup_pagewise_datas['menu_list_select_pwmr']); /* Pagewise Menu Middle Right */
$page_wise_menu_top_right = esc_attr($popup_pagewise_datas['menu_list_selected_pwtr']); /* Pagewise Menu Top Right */
$page_wise_menu_bottom_right = esc_attr($popup_pagewise_datas['menu_list_select_pwbr']); /* Pagewise Menu Bottom Right */
$page_wise_menu_middle_left = esc_attr($popup_pagewise_datas['menu_list_select_pwml']); /* Pagewise Menu Middle Left */
$page_wise_menu_top_left = esc_attr($popup_pagewise_datas['menu_list_select_pwtl']); /* Pagewise Menu Top Left */
$page_wise_menu_bottom_left = esc_attr($popup_pagewise_datas['menu_list_select_pwbl']); /* Pagewise Menu Bottom Left */
$page_wise_menu_bottom_center = esc_attr($popup_pagewise_datas['menu_list_select_pwbc']); /* Pagewise Menu Bottom Center */

/*
 * For Default Value from previous version
 */
if ($default_menu != "" && $default_menu != "default") {
    if (intval($page_wise_bar_id) && !empty($default_menu) && intval($default_menu)) {
        $ddefault_menu = $page_wise_bar_id;
        $show_hide_default_menu = "show_default_menu";
        $load_default_menu = 1;
    } else {
        if ($page_wise_bar_id == "default") {
            $ddefault_menu = $default_menu;
            $show_hide_default_menu = "show_default_menu";
            $load_default_menu = 1;
        } else if ($page_wise_bar_id == "disable") {
            $ddefault_menu = $default_menu;
            $show_hide_default_menu = "hide_default_menu";
            $load_default_menu = 0;
        } else if ($page_wise_bar_id == "" && isset($default_menu) && !empty($default_menu) && intval($default_menu)) {
            $ddefault_menu = $default_menu;
            $show_hide_default_menu = "show_default_menu";
            $load_default_menu = 1;
        } else if ($page_wise_bar_id == "" && $default_menu == "") {
            $ddefault_menu = $default_menu;
            $show_hide_default_menu = "hide_default_menu";
            $load_default_menu = 0;
        } else {
            $ddefault_menu = $page_wise_bar_id;
            $show_hide_default_menu = "hide_default_menu";
            $load_default_menu = 0;
        }
    }
} else {
    if (intval($page_wise_bar_id)) {
        $top_left_menu = $page_wise_bar_id;
        $show_hide_default_menu = 'hide_default_menu';
    } else {
        $show_hide_default_menu = "hide_default_menu";
    }
    $load_default_menu = 0;
}

/* For Middle Right Menu */
if ($default_middle_right_menu != "" && $default_middle_right_menu != "default") {
    if (intval($page_wise_menu_middle_right)) {
        $middle_right_menu = $page_wise_menu_middle_right;
        $show_hide_middle_right_menu = "show_middle_right_menu";
        $load_default_middle_right_menu = 1;
    } else {
        if ($page_wise_menu_middle_right == "default") {
            $middle_right_menu = $default_middle_right_menu;
            $show_hide_middle_right_menu = "show_middle_right_menu";
            $load_default_middle_right_menu = 1;
        } else if ($page_wise_menu_middle_right == "disable") {
            $middle_right_menu = $default_middle_right_menu;
            $show_hide_middle_right_menu = "hide_middle_right_menu";
            $load_default_middle_right_menu = 0;
        } else if ($page_wise_menu_middle_right == "" && isset($default_middle_right_menu) && !empty($default_middle_right_menu)) {
            $middle_right_menu = $default_middle_right_menu;
            $show_hide_middle_right_menu = "show_middle_right_menu";
            $load_default_middle_right_menu = 1;
        } else if ($page_wise_menu_middle_right == "" && $default_middle_right_menu == "") {
            $middle_right_menu = $default_middle_right_menu;
            $show_hide_middle_right_menu = "hide_middle_right_menu";
            $load_default_middle_right_menu = 0;
        } else {
            $middle_right_menu = $page_wise_menu_middle_right;
            $show_hide_middle_right_menu = "hide_middle_right_menu";
            $load_default_middle_right_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_middle_right)) {
        $middle_right_menu = $page_wise_menu_middle_right;
        $show_hide_middle_right_menu = 'hide_middle_right_menu';
    } else {
        $show_hide_middle_right_menu = "hide_middle_right_menu";
    }
    $load_default_middle_right_menu = 0;
}

/* For Top Right Menu */
if (($default_top_right_menu != "") && $default_top_right_menu != "default") {
    if (intval($page_wise_menu_top_right)) {
        $top_right_menu = $page_wise_menu_top_right;
        $show_hide_top_right_menu = "show_top_right_menu";
        $load_default_top_right_menu = 1;
    } else {
        if ($page_wise_menu_top_right == "default") {
            $top_right_menu = $default_top_right_menu;
            $show_hide_top_right_menu = "show_top_right_menu";
            $load_default_top_right_menu = 1;
        } else if ($page_wise_menu_top_right == "disable") {
            $top_right_menu = $default_top_right_menu;
            $show_hide_top_right_menu = "hide_top_right_menu";
            $load_default_top_right_menu = 0;
        } else if ($page_wise_menu_top_right == "" && isset($default_top_right_menu) && !empty($default_top_right_menu)) {
            $top_right_menu = $default_top_right_menu;
            $show_hide_top_right_menu = "show_top_right_menu";
            $load_default_top_right_menu = 1;
        } else if ($page_wise_menu_top_right == "" && $default_top_right_menu == "") {
            $top_right_menu = $default_top_right_menu;
            $show_hide_top_right_menu = "hide_top_right_menu";
            $load_default_top_right_menu = 0;
        } else {
            $top_right_menu = $page_wise_menu_top_right;
            $show_hide_top_right_menu = "hide_top_right_menu";
            $load_default_top_right_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_top_right)) {
        $top_right_menu = $page_wise_menu_top_right;
        $show_hide_top_right_menu = 'hide_top_right_menu';
    } else {
        $show_hide_top_right_menu = "hide_top_right_menu";
    }
    $load_default_top_right_menu = 0;
}

/* For Bottom Right Menu */

if ($default_bottom_right_menu != "" && $default_bottom_right_menu != "default") {
    if (intval($page_wise_menu_bottom_right)) {
        $bottom_right_menu = $page_wise_menu_bottom_right;
        $show_hide_bottom_right_menu = "show_bottom_right_menu";
        $load_default_bottom_right_menu = 1;
    } else {
        if ($page_wise_menu_bottom_right == "default") {
            $bottom_right_menu = $default_bottom_right_menu;
            $show_hide_bottom_right_menu = "show_bottom_right_menu";
            $load_default_bottom_right_menu = 1;
        } else if ($page_wise_menu_bottom_right == "disable") {
            $bottom_right_menu = $default_bottom_right_menu;
            $show_hide_bottom_right_menu = "hide_bottom_right_menu";
            $load_default_bottom_right_menu = 0;
        } else if ($page_wise_menu_bottom_right == "" && isset($default_bottom_right_menu) && !empty($default_bottom_right_menu)) {
            $bottom_right_menu = $default_bottom_right_menu;
            $show_hide_bottom_right_menu = "show_bottom_right_menu";
            $load_default_bottom_right_menu = 1;
        } else if ($page_wise_menu_bottom_right == "" && $default_bottom_right_menu == "") {
            $bottom_right_menu = $default_bottom_right_menu;
            $show_hide_bottom_right_menu = "hide_bottom_right_menu";
            $load_default_bottom_right_menu = 0;
        } else {
            $bottom_right_menu = $page_wise_menu_bottom_right;
            $show_hide_bottom_right_menu = "hide_bottom_right_menu";
            $load_default_bottom_right_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_bottom_right)) {
        $bottom_right_menu = $page_wise_menu_bottom_right;
        $show_hide_bottom_right_menu = 'hide_bottom_right_menu';
    } else {
        $show_hide_bottom_right_menu = "hide_bottom_right_menu";
    }
    $load_default_bottom_right_menu = 0;
}

/* For Middle Left Menu */
if (($default_middle_left_menu != "") && $default_middle_left_menu != "default") {
    if (intval($page_wise_menu_middle_left)) {
        $middle_left_menu = $page_wise_menu_middle_left;
        $show_hide_middle_left_menu = "show_middle_left_menu";
        $load_default_middle_left_menu = 1;
    } else {
        if ($page_wise_menu_middle_left == "default") {
            $middle_left_menu = $default_middle_left_menu;
            $show_hide_middle_left_menu = "show_middle_left_menu";
            $load_default_middle_left_menu = 1;
        } else if ($page_wise_menu_middle_left == "disable") {
            $middle_left_menu = $default_middle_left_menu;
            $show_hide_middle_left_menu = "hide_middle_left_menu";
            $load_default_middle_left_menu = 0;
        } else if ($page_wise_menu_middle_left == "" && isset($default_middle_left_menu) && !empty($default_middle_left_menu)) {
            $middle_left_menu = $default_middle_left_menu;
            $show_hide_middle_left_menu = "show_middle_left_menu";
            $load_default_middle_left_menu = 1;
        } else if ($page_wise_menu_middle_left == "" && $default_middle_left_menu == "") {
            $middle_left_menu = $default_middle_left_menu;
            $show_hide_middle_left_menu = "hide_middle_left_menu";
            $load_default_middle_left_menu = 0;
        } else {
            $middle_left_menu = $page_wise_menu_middle_left;
            $show_hide_middle_left_menu = "hide_middle_left_menu";
            $load_default_middle_left_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_middle_left)) {
        $middle_left_menu = $page_wise_menu_middle_left;
        $show_hide_middle_left_menu = 'hide_middle_left_menu';
    } else {
        $show_hide_middle_left_menu = "hide_middle_left_menu";
    }
    $load_default_middle_left_menu = 0;
}

/* For Top Left Menu */
if (($default_top_left_menu != "") && $default_top_left_menu != "default") {
    if (intval($page_wise_menu_top_left)) {
        $top_left_menu = $page_wise_menu_top_left;
        $show_hide_top_left_menu = "show_top_left_menu";
        $load_default_top_left_menu = 1;
    } else {
        if ($page_wise_menu_top_left == "default") {
            $top_left_menu = $default_top_left_menu;
            $show_hide_top_left_menu = "show_top_left_menu";
            $load_default_top_left_menu = 1;
        } else if ($page_wise_menu_top_left == "disable") {
            $top_left_menu = $default_top_left_menu;
            $show_hide_top_left_menu = "hide_top_left_menu";
            $load_default_top_left_menu = 0;
        } else if ($page_wise_menu_top_left == "" && isset($default_top_left_menu) && !empty($default_top_left_menu)) {
            $top_left_menu = $default_top_left_menu;
            $show_hide_top_left_menu = "show_top_left_menu";
            $load_default_top_left_menu = 1;
        } else if ($page_wise_menu_top_left == "" && $default_top_left_menu == "") {
            $top_left_menu = $default_top_left_menu;
            $show_hide_top_left_menu = "hide_top_left_menu";
            $load_default_top_left_menu = 0;
        } else {
            $top_left_menu = $page_wise_menu_top_left;
            $show_hide_top_left_menu = "hide_top_left_menu";
            $load_default_top_left_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_top_left)) {
        $top_left_menu = $page_wise_menu_top_left;
        $show_hide_top_left_menu = 'hide_top_left_menu';
    } else {
        $show_hide_top_left_menu = "hide_top_left_menu";
    }
    $load_default_top_left_menu = 0;
}

/* For Bottom Left Menu */
if (($default_bottom_left_menu != "") && $default_bottom_left_menu != "default") {
    if (intval($page_wise_menu_bottom_left)) {
        $bottom_left_menu = $page_wise_menu_bottom_left;
        $show_hide_bottom_left_menu = "show_bottom_left_menu";
        $load_default_bottom_left_menu = 1;
    } else {
        if ($page_wise_menu_bottom_left == "default") {
            $bottom_left_menu = $default_bottom_left_menu;
            $show_hide_bottom_left_menu = "show_bottom_left_menu";
            $load_default_bottom_left_menu = 1;
        } else if ($page_wise_menu_bottom_left == "disable") {
            $bottom_left_menu = $default_bottom_left_menu;
            $show_hide_bottom_left_menu = "hide_bottom_left_menu";
            $load_default_bottom_left_menu = 0;
        } else if ($page_wise_menu_bottom_left == "" && isset($default_bottom_left_menu) && !empty($default_bottom_left_menu)) {
            $bottom_left_menu = $default_bottom_left_menu;
            $show_hide_bottom_left_menu = "show_bottom_left_menu";
            $load_default_bottom_left_menu = 1;
        } else if ($page_wise_menu_bottom_left == "" && $default_bottom_left_menu == "") {
            $bottom_left_menu = $default_bottom_left_menu;
            $show_hide_bottom_left_menu = "hide_bottom_left_menu";
            $load_default_bottom_left_menu = 0;
        } else {
            $bottom_left_menu = $page_wise_menu_bottom_left;
            $show_hide_bottom_left_menu = "hide_bottom_left_menu";
            $load_default_bottom_left_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_bottom_left)) {
        $bottom_left_menu = $page_wise_menu_bottom_left;
        $show_hide_bottom_left_menu = 'hide_bottom_left_menu';
    } else {
        $show_hide_bottom_left_menu = "hide_bottom_left_menu";
    }
    $load_default_bottom_left_menu = 0;
}
/* For Bottom Center Menu */
if (($default_bottom_center_menu != "") && $default_bottom_center_menu != "default") {
    if (intval($page_wise_menu_bottom_center)) {
        $bottom_center_menu = $page_wise_menu_bottom_center;
        $show_hide_bottom_center_menu = "show_bottom_center_menu";
        $load_default_bottom_center_menu = 1;
    } else {
        if ($page_wise_menu_bottom_center == "default") {
            $bottom_center_menu = $default_bottom_center_menu;
            $show_hide_bottom_center_menu = "show_bottom_center_menu";
            $load_default_bottom_center_menu = 1;
        } else if ($page_wise_menu_bottom_center == "disable") {
            $bottom_center_menu = $default_bottom_center_menu;
            $show_hide_bottom_center_menu = "hide_bottom_center_menu";
            $load_default_bottom_center_menu = 0;
        } else if ($page_wise_menu_bottom_center == "" && isset($default_bottom_center_menu) && !empty($default_bottom_center_menu)) {
            $bottom_center_menu = $default_bottom_center_menu;
            $show_hide_bottom_center_menu = "show_bottom_center_menu";
            $load_default_bottom_center_menu = 1;
        } else if ($page_wise_menu_bottom_center == "" && $default_bottom_center_menu == "") {
            $bottom_center_menu = $default_bottom_center_menu;
            $show_hide_bottom_center_menu = "hide_bottom_center_menu";
            $load_default_bottom_center_menu = 0;
        } else {
            $bottom_center_menu = $page_wise_menu_bottom_center;
            $show_hide_bottom_center_menu = "hide_bottom_center_menu";
            $load_default_bottom_center_menu = 0;
        }
    }
} else {
    if (intval($page_wise_menu_bottom_center)) {
        $bottom_center_menu = $page_wise_menu_bottom_center;
        $show_hide_bottom_center_menu = 'hide_bottom_center_menu';
    } else {
        $show_hide_bottom_center_menu = "hide_bottom_center_menu";
    }
    $load_default_bottom_center_menu = 0;
}

if ($enable_menu == 1) {
    //if ($pagebar != 'disable') {
    if (!is_feed()) {
        ?>
        <?php

        if ($show_pages_wise_menu == "all-pages") {
            include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
        } else if ($show_pages_wise_menu == "home-page") {
            if (is_front_page()) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            } else {
                $disp_class_name = "show-no-menu";
                $get_data_from_table = array();
                $page_bar_id = '';
            }
        } else if ($show_pages_wise_menu == "page-specific") {
            $default_page = isset($wpfm_settings['default_page']) && !empty($wpfm_settings['default_page']) ? maybe_unserialize($wpfm_settings['default_page']) : array();
            if (isset($wpfm_settings['page_specific_display']) && is_array($wpfm_settings['page_specific_display'])) {
                $showpages_array = $wpfm_settings['page_specific_display'];
            } else {
                $showpages_array = array();
            }
            /** For page/post Specific */
            if ((in_array($current_page_id, $showpages_array)) || ($page_specific_category_enable_disable != 1 && in_array($category_id, $showpages_array))) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            }
            /** For 404 Page Check */
            if (in_array('404', $default_page) && is_404()) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            }
            /** For Archive Page Check */
            if (in_array('archive', $default_page) && (is_archive() || is_page('archives'))) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            }
            /** For Search Page Check */
            if (in_array('search', $default_page) && (is_search())) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            }
            /** Check if Home page if Blog */
            if (in_array('blog', $default_page) && is_home()) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            }

            /**  Check if Home page if Default Homepage  */
            if (in_array('default_home', $default_page) && is_front_page() && is_home()) {
                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/menu-filters.php';
            }
        }
        if (isset($enable_menu_on_mobile) && $enable_menu_on_mobile == 0) {
            ?>
            <style type="text/css">
                /* For Mobile version */
                @media only screen and (max-device-width: 480px){ .wpfm-floating-wh-wrapper{display:none; }}
            </style>
            <?php

        }
        if (isset($enable_menu_on_tablets) && $enable_menu_on_tablets == 0) {
            ?>
            <style type="text/css">
                /* For Tablet version */
                @media only screen and (min-device-width: 768px) and (max-device-width: 1023px) { .wpfm-floating-wh-wrapper{display:none; }}
            </style>
            <?php

        }
        if (isset($enable_menu_on_big_screens) && $enable_menu_on_big_screens == 0) {
            ?>
            <style type="text/css">
                /* For Bigger desktop screen version */
                @media only screen and (min-device-width: 1024px) { .wpfm-floating-wh-wrapper{display:none; }}
            </style>
        <?php } ?>

        <?php

    } /* Is feed check end */
    // } /* Page not disavled if end */
} /* Enable Menu check end if */
