<?php defined('ABSPATH') or die('No script kiddies please!'); ?>

<div class="wpfm-header-title"><?php _e('Add New Navigation Menu', 'wpfm-floating-menu-pro'); ?></div>   
<div class="form-body" id="wpfm-menu-add-wrapper">
    <div class="wpfm-form-body-left">
        <?php
        $pages = $this->get_all_page_lists();
        $posts = $this->get_all_post_lists();
        $categories = $this->get_categories();
        $args = array('public' => true, '_builtin' => false);
        $output = 'objects';
        $operator = 'and';
        $post_types = get_post_types($args, $output, $operator);
        $all_post_types = array();
        foreach ($post_types as $post_type) {
            $all_post_types[] = $post_type->name;
        }
        ?>        
        <form id="wpfm-update-nav-menu" class="wpfm-add-page-fields" method="post" enctype="multipart/form-data">
            <div class="wpfm-menu-list-field" id="wpfm-page-field">
                <div class="wpfm-field-header" id="wpfm-page-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Pages', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">        
                    <div id="wpfm-page-all" class="wpfm-field-listing">                                                   
                        <ul id="page-checklist" class="list-check-fields">
                            <?php
                            if (count($pages) > 0) {
                                $page_count = 0;
                                foreach ($pages as $key => $val) {
                                    if ($page_count < 6) {
                                        ?>
                                        <li>
                                            <input disabled="disabled" type="checkbox" field-data="<?php _e('Page', 'wp-floating-menu-pro'); ?>" id="wpfm-page-checkbox" class="wpfm-add-check" name="wpfm-add-check[]" id="wpfm-add-check-page" value="<?php echo $key; ?>" <?php
                                            if (!empty($showpages_array) && in_array($key, $showpages_array)) {
                                                echo "selected='selected'";
                                            }
                                            ?>/>
                                            <span class="pages"><?php echo $val; ?></span>
                                        </li>
                                        <?php
                                    } else {
                                        break;
                                    }
                                    $page_count++;
                                }
                            } else {
                                echo __('<span class="wpfm-no-content-error">No Pages</span>', 'wp-floating-menu-pro');
                            }
                            ?>
                        </ul>
                        <p class="button-controls wp-clearfix">
                            <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                            <span class="wpfm-add-to-menu">
                                <input disabled="disabled" type="submit" submit-field-val="0" class="button-secondary wpfm-submit-add-to-menu" id="wpfm-page-add-to-menu" value="Add to Menu" name="wpfm_add_post_type_page" />
                            </span>
                        </p>
                        <input type="hidden" name="page_id_values" id="page-id-values"/>
                    </div>
                </div>                                        
            </div><!-- #wpfm-page-field .wpfm-menu-list-field -->

            <div class="wpfm-menu-list-field" id="wpfm-post-field">
                <div class="wpfm-field-header" id="wpfm-post-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Posts', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">
                    <div id="wpfm-post-all" class="wpfm-field-listing">                                
                        <ul id="post-check-list" class="list-check-fields">
                            <?php
                            if (count($posts) > 0) {
                                $post_count = 0;
                                foreach ($posts as $key => $val) {
                                    if ($post_count < 6) {
                                        ?>                                  
                                        <li>
                                            <input disabled="disabled" type="checkbox" class="wpfm-add-check" field-data="<?php _e('Post', 'wp-floating-menu-pro'); ?>" name="wpfm-add-check[]" id="wpfm-add-check-post" value="<?php echo $key; ?>" <?php
                                            if (!empty($showpages_array) && in_array($key, $showpages_array)) {
                                                echo "selected='selected'";
                                            }
                                            ?>/>
                                            <span class="posts"><?php echo $val; ?></span>
                                        </li>
                                        <?php
                                    }
                                    $post_count++;
                                }
                            } else {
                                echo __('<span class="wpfm-no-content-error">No Post</span>', 'wp-floating-menu-pro');
                            }
                            ?>
                        </ul>
                        <p class="button-controls wp-clearfix">
                            <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                            <span class="wpfm-add-to-menu">
                                <input disabled="disabled" type="submit" id="wpfm-submit-posttype-post" submit-field-val="1" class="button-secondary wpfm-submit-add-to-menu" value="Add to Menu" name="wpfm_add_post_type_post" />
                            </span>                
                        </p>                                         
                    </div>
                </div>
            </div><!-- #wpfm-post-field .wpfm-menu-list-field -->
            <div class="wpfm-menu-list-field" id="wpfm-custom-link-field">
                <div class="wpfm-field-header" id="wpfm-custom-link-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Custom Links', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">
                    <div id="wpfm-custom-link-url" class="wpfm-custom-link">                                
                        <label for="wpfm_custom_link_url" class=""><?php _e('URL', 'wp-floating-menu-pro'); ?></label>
                        <div class="wpfm-input-field-wrapper">
                            <input type="url" disabled="disabled" name="wpfm_custom_link_url" id="wpfm-custom-link-url"/>
                        </div>                             
                    </div>
                    <div id="wpfm-custom-link-text" class="wpfm-custom-link">                                
                        <label for="wpfm_custom_link_text" class=""><?php _e('Link Text', 'wp-floating-menu-pro'); ?></label>
                        <div class="wpfm-input-field-wrapper">
                            <input type="text" disabled="disabled" name="wpfm_custom_link_text" id="wpfm-custom-link-text"/>
                        </div>                             
                    </div>
                    <p class="button-controls wp-clearfix">
                        <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                        <span class="wpfm-add-to-menu">
                            <input disabled="disabled" type="button" field-data="<?php _e('Custom Link', 'wp-floating-menu-pro'); ?>" submit-field-val="2" class="button-secondary wpfm-submit-add-to-menu"  id="wpfm-submit-posttype-custom-link" value="Add to Menu" name="wpfm_add_post_type_custom_link"/>
                        </span>                
                    </p>
                </div>
            </div><!-- #wpfm-custom-link-field .wpfm-menu-list-field -->
            <div class="wpfm-menu-list-field" id="wpfm-category-field">
                <div class="wpfm-field-header" id="wpfm-post-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Categories', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">
                    <div id="wpfm-page-all" class="wpfm-category-listing">                                
                        <ul id="category-check-list" class="list-check-fields">
                            <?php
                            if (count($categories) > 0) {
                                foreach ($categories as $key => $val) {
                                    ?>                       
                                    <li>
                                        <input disabled="disabled" type="checkbox" class="wpfm-add-check" field-data="<?php _e('Category', 'wp-floating-menu-pro'); ?>" name="wpfm-add-check[]" value="" <?php
                                        if (!empty($showpages_array) && in_array($key, $showpages_array)) {
                                            echo "selected='selected'";
                                        }
                                        ?>/>
                                        <span class="category"><?php echo $val; ?></span>
                                    </li>
                                    <?php
                                }
                            } else {
                                echo __('<span class="wpfm-no-content-error">No Category</span>', 'wp-floating-menu-pro');
                            }
                            ?>
                        </ul>
                        <p class="button-controls wp-clearfix">
                            <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                            <span class="wpfm-add-to-menu">
                                <input disabled="disabled" type="submit" submit-field-val="3" class="button-secondary wpfm-submit-add-to-menu" value="Add to Menu" name="wpfm_add_post_type_category" id="wpfm-submit-posttype-category" />
                            </span>                                                                   
                        </p>                                            
                    </div>
                </div>
            </div><!-- #wpfm-category-field .wpfm-menu-list-field -->            
        </form><!-- .wpfm-add-page-fields -->
    </div><!--wpfm-form-body-left -->

    <div class="wpfm-form-body-right">
        <form action="<?php echo admin_url() . 'admin-post.php' ?>" method='post' class="wpfm-menu-structure">
            <input type="hidden" name="action" value="wpfm_add_menu_field_options" />
            <?php wp_nonce_field('wpfm_nonce_add_menu_fields', 'wpfm_add_nonce_add_menu_fields'); ?>
            <div class="wpfm-upper-body-section">
                <div class="wpfm-add-new-form">
                    <label for="wpfm_save_menu_name" class="wpfm-input-field-controller"><?php _e('Menu Name', 'wp-floating-menu-pro'); ?></label>
                    <div class="wpfm-input-field-wrapper">
                        <input type="text" name="wpfm_save_menu_name" class="wpfm-menu-name" id="wpfm-menu-name-add"/>
                        <div class="menu-name-error" style="color:red; display:none;">
                            <?php _e('Please Enter Menu Name', 'wp-floating-menu-pro'); ?>
                        </div>
                    </div>
                </div>
                <div class="wpfm-publishing-action" id="wpfm-save-form-upper">
                    <input type="submit" name="wpfm_add_menu_fields" id="wpfm-add-menu-header" class="button button-primary wpfm-menu-field-add" value="Add Menu"/>
                </div>
            </div>
        </form><!-- #wpfm-update-nav-menu .wpfm-save-menu -->
    </div><!-- .wpfm-form-body-right -->
</div><!-- .Form-Body -->
