<?php
#######################################################################
#	PHP Whois Lookup Class
#	Script Url: http://99webtools/php-whois-script.php
#	Author: Sunny Verma
#	Email: er.sunny.verma@gmail.com
#	Website: http://99webtools.com
#	License: GPL 2.0, @see http://www.gnu.org/licenses/gpl-2.0.html
########################################################################
class wdcWhois{



public function whoislookup($domain)
{
	$args = array('user-agent'  => 'WordPress-WP-Domain-Checker','sslverify' => false); 
	$file = wp_remote_get(plugin_dir_url(__FILE__).'whois.json', $args);
	$file = wp_remote_retrieve_body($file);

	if(!$file){
			$file_dir = plugin_dir_path( __FILE__ ).'whois.json';
			$file_dir_open = fopen($file_dir,'r');
			$file = fread($file_dir_open, filesize($file_dir));
			fclose($file_dir_open);
		}

	$WHOIS_SERVERS = json_decode($file,true);
	$domain = trim($domain); //remove space from start and end of domain
	if(substr(strtolower($domain), 7) == "http://") $domain = substr($domain,7); // remove http:// if included
	if(substr(strtolower($domain), 4) == "www.") $domain = substr($domain,4);//remove www from domain
	if(preg_match("/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/",$domain))
		return $this->queryWhois("whois.lacnic.net",$domain);
	elseif(preg_match("/^([-a-z0-9]{2,100})\.([a-z\.]{2,12})$/i",$domain))
	{
		$domain_parts = explode(".", $domain,2);
		$tld = strtolower(array_pop($domain_parts));
		$server = $WHOIS_SERVERS[$tld][0];
		if(!$server) {
			return "Error: No appropriate Whois server found for $domain domain!";
		}
		$res=$this->queryWhois($server,$domain);
			// while(preg_match_all("/Whois Server: (.*)/", $res, $matches))
			// {
			// 	$server=array_pop($matches[1]);
			// 	$res=$this->queryWhois($server,$domain);
			// }
		return $res;
	}
	else
	return "Invalid Input";
}

private function queryWhois($server,$domain)
{
	$transient = get_transient( 'wdc_'.$domain );
	  
		  // Yep!  Just return it and we're done.
		  if( ! empty( $transient ) ) {
		    
		    // The function will return here every time after the first time it is run, until the transient expires.
		    return $transient;

		  // Nope!  We gotta make a call.
		}
	$fp = @fsockopen($server, 43, $errno, $errstr, 20) or die("Socket Error " . $errno . " - " . $errstr);
	if($server=="whois.verisign-grs.com")
		$domain="=".$domain;
		fputs($fp, $domain . "\r\n");
		$out = "";
		while(!feof($fp)){
			$out .= fgets($fp);
		}
	fclose($fp);
	return $out;
}
}
?>