<?php
/**
 * Plugin Name: WordPress Any Contact Us
 * Description: Increase your revenue by connecting with clients where they are :)
 * Plugin URI: http://wecreativez.com/
 * Author: پرشین اسکریپت
 * Author URI: http://www.persianscript.ir
 * Version: 1.0.2
 * License: GPL2
 * Text Domain: wp-any-contact-us
 * Domain Path: languages
 */

// Preventing to direct access
defined('ABSPATH') OR die('Direct access not acceptable!');

// Defined plugin path
if ( ! defined('WACU_PATH')) {
    define('WACU_PATH', plugin_dir_path(__FILE__));
}

// Defined plugin URL
if ( ! defined('WACU_URL')) {
    define('WACU_URL', plugin_dir_url(__FILE__));
}

if ( ! defined('WACU_VERSION')) {
    define('WACU_VERSION', '1.0.2');
}

// Core Init
if ( ! defined('WECREATIVEZ_CORE_PATH')) {
    require_once WACU_PATH . 'core/core-init.php';
}

/**
 * This function will run when plugin activate
 * @since 1.0
 */
if ( ! function_exists('wacu_plugin_activation')) {
    function wacu_plugin_activation() {
        require_once WACU_PATH . 'includes/class-wacu-activation.php';
        WACU_Activation::activate();
    }
    register_activation_hook(__FILE__, 'wacu_plugin_activation');
}

/**
 * Load plugin files
 * @since 1.0
 */
if ( ! function_exists('wacu_plugin_initialize')) {

    function wacu_plugin_initialize() {

        if ( ! class_exists('WACU_Init')) {

            require_once WACU_PATH . 'includes/class-wacu-init.php';

            $WACU_Init = new WACU_Init;
            $WACU_Init->init();
        }

    }
    add_action('plugins_loaded', 'wacu_plugin_initialize');
}

/**
 * Load plugin textdomain.
 * @since 1.0
 */
if ( ! function_exists('wacu_load_textdomain')) {
    function wacu_load_textdomain() {
        load_plugin_textdomain('wp-any-contact-us', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }
    add_action('init', 'wacu_load_textdomain');
}