<?php

// Preventing to direct access
defined( 'ABSPATH' ) OR die( 'Direct access not acceptable!' );

if ( ! class_exists( 'WWS_Product_Query' ) ) :

	/**
	 * WooCommerce Product Query
	 * @package WeCreativez/Classes
	 * @since 1.5
	 */
	class WWS_Product_Query extends WWS_Common {


		public function __construct() {

			if ( $this->_get_setting( 'status' ) != '1' )
				return false;

			if ( $this->_get_setting( 'btn_location' ) == 'woocommerce_before_add_to_cart_form' ) 
				add_action( 'woocommerce_before_add_to_cart_form', array( $this, 'product_query_button' ) );

			if ( $this->_get_setting( 'btn_location' ) == 'woocommerce_after_add_to_cart_button' )
				add_action( 'woocommerce_after_add_to_cart_button', array( $this, 'product_query_button' ) );

			add_shortcode( 'wws_product_url', array( $this, 'get_product_link' ) );
			add_shortcode( 'wws_product_title', array( $this, 'get_product_title' ) );

		}


		/**
		 * Get saved settings
		 * @param  string $setting value of the option
		 * @since 1.5
		 */
		private function _get_setting( $setting ) {
			$data = get_option( 'wws_product_query' );
			return $data[$setting];
		}


		public function product_query_button() {
			$btn_label 						= $this->_get_setting( 'btn_label' );
			$btn_bg_color 				= $this->_get_setting( 'btn_bg_color' );
			$btn_text_color				= $this->_get_setting( 'btn_text_color' );
			$support_person_img 	= $this->_get_setting( 'support_person_img' );
			$support_person_name 	= $this->_get_setting( 'support_person_name' );
			$support_person_title = $this->_get_setting( 'support_person_title' );
			$support_number			  = $this->_get_setting( 'support_number' );
			$support_pre_message	= do_shortcode( $this->_get_setting( 'support_pre_message' ) );

			echo "<style>
							a.wws-product-query-btn {
								display: inline-flex;
								width: auto;
						    align-items: center;
						    justify-content: center;
						    padding: 5px 8px;
						    border-radius: 6px;
						    position: relative;
						    text-decoration: none !important;
						    background-color: {$btn_bg_color};
						    color: {$btn_text_color};
						    margin: 5px 0;
							}
							.wws-product-query-btn__img {
								width: 50px;
								height: 50px;
							}
							.wws-product-query-btn__img img {
								width: 100%;
								height: 100%;
							}
							.wws-product-query-btn__text {
								margin-left: 10px;
								display: flex;
								flex-direction: column;
							}
							.wws-product-query-btn__text span {
								line-height: 20px;
								font-size: 15px;
							}
						</style>";
			if ( wp_is_mobile() )
				$html = "<a class='wws-product-query-btn' href='https://api.whatsapp.com/send?phone={$support_number}&text={$support_pre_message}' target='_blank' >";
			else
				$html = "<a class='wws-product-query-btn' href='https://web.whatsapp.com/send?phone={$support_number}&text={$support_pre_message}' target='_blank' >";
			
				if ( $support_person_img ) {
					$html .= "<span class='wws-product-query-btn__img' class=''>";
						$html .= "<img src='{$support_person_img}' alt='wws'>";
					$html .= "</span>";
				}
				$html .= "<span class='wws-product-query-btn__text'>";
				if ( $support_person_name && $support_person_title ) {
					$html .= "<span>{$support_person_name} / {$support_person_title}</span>";
				} else if ( $support_person_name ) {
					$html .= "<span>{$support_person_name}</span>";
				}
					
					$html .= "<span><strong>{$btn_label}</strong></span>";
				$html .= "</span>";
			$html .= "</a>";

			echo $html;
		}


		/**
		 * Get the current product link
		 * @since 1.5
		 */		
		public function get_product_link() {
			return get_the_permalink( get_the_ID() );
		}

		/**
		 * Get the current product title/name
		 * @since 1.5
		 */
		public function get_product_title() {
			return get_the_title( get_the_ID() );
		}



	} // .WWS_Product_Query

	new WWS_Product_Query;

endif;

