<?php

// Preventing to direct access
defined( 'ABSPATH' ) OR die( 'Direct access not acceptable!' );


if ( ! class_exists( 'WWS_Admin_Enqueue' ) ) :

	/**
	 * Enqueue all the resources for admin
	 * @package WeCreativez/Admin
	 * @author WeCreativez
	 * @since 1.2
	 */
	class WWS_Admin_Enqueue extends WWS_Common {


		public function __construct() {

			add_action( 'admin_enqueue_scripts', array( $this, 'enquque_scripts' ) );

		}

		/**
		 * Enqueue admin scripts
		 * @param  string $hook Current admin page slug
		 * @since 1.2
		 */
		public function enquque_scripts( $hook ) {

			//if ( $this->is_my_admin_page( $hook ) != true ) return;

			wp_enqueue_style('wp-color-picker');
      wp_enqueue_media();

			wp_enqueue_style( 'wws-timepicker-style', $this->plugin_url( 'assets/admin/css/wws-timepicker.css?v='.WWS_VERSION ) );
			wp_enqueue_script('wws-timepicker-script', $this->plugin_url( 'assets/admin/js/wws-admin-timepicker.js?v='.WWS_VERSION ), array('wp-color-picker'), false, true);

			wp_enqueue_style( 'wws-admin-select2', $this->plugin_url( 'assets/admin/css/wws-admin-select2.css?v='.WWS_VERSION ) );
			wp_enqueue_script('wws-admin-select2', $this->plugin_url( 'assets/admin/js/wws-admin-select2.js?v='.WWS_VERSION ), array(), false, true);

			wp_enqueue_style( 'wws-admin-datatable', $this->plugin_url( 'assets/admin/css/wws-admin-datatables.css?v='.WWS_VERSION ) );
			wp_enqueue_script('wws-admin-datatable', $this->plugin_url( 'assets/admin/js/wws-admin-datatable.js?v='.WWS_VERSION ), array(), false, true);

			wp_enqueue_style( 'wws-admin-style', $this->plugin_url( 'assets/admin/css/wws-admin-style.css?v='.WWS_VERSION ) );
			wp_enqueue_script('wws-admin-script', $this->plugin_url( 'assets/admin/js/wws-admin-script.js?v='.WWS_VERSION ), array('wp-color-picker'), false, true);
			
		}



		/**
		 * This method is for checking current admin page is this plugin page or not
		 * @param  string  $hook Current admin page slug
		 * @return boolean
		 * @since 1.2
		 */
		private function is_my_admin_page( $hook ) {

			if ( $hook == 'toplevel_page_wc-whatsapp-support'
				|| $hook == 'whatsapp-support_page_wc-whatsapp-support-shortcode'
				|| $hook == 'whatsapp-support_page_wc-whatsapp-support-support-page'
				|| $hook == 'whatsapp-support_page_wc-whatsapp-support-new-page'
				|| $hook == 'whatsapp-support_page_wc-whatsapp-support-analytics'
				|| $hook == 'whatsapp-support_page_wc-whatsapp-gdpr'
				|| $hook == 'whatsapp-support_page_wc-whatsapp-product-query' ) {

				return true;

			}

			return false;

		}


	} // .WWS_Admin_Enqueue

	new WWS_Admin_Enqueue;

endif;