jQuery(document).ready(function($) {

    $('.timepicker').timepicker({ 'disableTextInput': true, 'showDuration': true, });
    $('.datepair').datepair();

    function update() {
      $('.js-current-time').html(moment().format('Do MMMM YYYY H:mm:ss'));
    }

    setInterval(update, 1000);

    /*
    var hasBeenTrigged = false;
    if  ( (($(document).height() - $(window).height()) - $(window).scrollTop() < 250) && !hasBeenTrigged){
        $('#w3dev-save-ban-email-template,#w3dev-save-ban-user-settings,#w3dev-save-registration-ban-options').fadeIn();
        hasBeenTrigged = true;
    } else {
        $(window).scroll(function() {

            if ($(this).scrollTop() >= 150 && !hasBeenTrigged) { // if scroll is greater/equal then 100 and hasBeenTrigged is set to false.
                $('#w3dev-save-ban-email-template,#w3dev-save-ban-user-settings,#w3dev-save-registration-ban-options').fadeIn();
                hasBeenTrigged = true;
            }
            if ($(this).scrollTop() < 150) {
                $('#w3dev-save-ban-email-template,#w3dev-save-ban-user-settings,#w3dev-save-registration-ban-options').fadeOut();
                hasBeenTrigged = false;
            }
        });
    }
    */

    $('#w3dev-get-api-key').on('click', function(e) {

        // perform ajax request to store email address in table
        // --
        var data = {
            'action': 'w3dev_get_api_key'
        };

        $.post(ajaxurl, data, function(response) {

            $('#w3dev-get-api-key').remove();
            $('#input-api-key').val(response);

        }); 

    });

    $('#input-ip-api').on('change', function(e) {

        var _this       = $(this);
        var _option     = _this.val();
        var _api_key    = $('#input-api-key').val();

        if (_option == 'w3-ip.com') {
            if (!_api_key || 0 === _option.length) {
                alert('To use this API you will need to a FREE API Key; See Free API Key section above.');
            }
        }

    });

    /*
    $('#w3dev-save-registration-ban-options').on('click', function(e) {

        var _this = $(this);
        _this.html('<i class="fa fa-spinner fa-spin fa-fw"></i> Saving');

        // get input data
        // --
        var _enable_reg_ban_by_email                = $('#input-enable-reg-ban-by-email').is(':checked') ? 1 : 0;
        var _enable_login_ban_by_email              = $('#input-enable-login-ban-by-email').is(':checked') ? 1 : 0;
        var _enable_reg_ban_by_ip                   = $('#input-enable-reg-ban-by-ip').is(':checked') ? 1 : 0;
        var _enable_login_ban_by_ip                 = $('#input-enable-login-ban-by-ip').is(':checked') ? 1 : 0;
        var _enable_reg_ban_by_countrycode          = $('#input-enable-reg-ban-by-countrycode').is(':checked') ? 1 : 0;
        var _enable_login_ban_by_countrycode        = $('#input-enable-login-ban-by-countrycode').is(':checked') ? 1 : 0;
        var _enable_reg_ban_failed_country_check    = $('#input-enable-reg-ban-failed-country-checked').is(':checked') ? 1 : 0;

        var data = {
            'action':                               'w3dev_save_registration_ban_options',
            'enable_reg_ban_by_email':              _enable_reg_ban_by_email,
            'enable_login_ban_by_email':            _enable_login_ban_by_email,  
            'enable_reg_ban_by_ip':                 _enable_reg_ban_by_ip,
            'enable_login_ban_by_ip':               _enable_login_ban_by_ip,
            'enable_reg_ban_by_countrycode':        _enable_reg_ban_by_countrycode,
            'enable_login_ban_by_countrycode':      _enable_login_ban_by_countrycode,
            'enable_reg_ban_failed_country_check':  _enable_reg_ban_failed_country_check          
        };

        $.post(ajaxurl, data, function(response) {
            _this.html('Save Registration Options');
            $('#js-save-message').fadeIn().delay(2500).fadeOut();
        }); 

        e.preventDefault();

    });
    */

    $('#btn-ban-email-address').on('click', function(e) {

        var _this = $(this);
        var _input = $("#input-ban-email-address");
        var _email_address = $.trim(_input.val());
    
        // check to see if email already exists in table
        // --
        if (_email_address.length == 0) { 
            _this.notify(
            "Oops! Please enter a valid Email Address.",
            "error",
            { position:"right" }
            );
            return false;
        }

        if ($('#w3dev-table-banned-emails').find('td:contains("' + _email_address + '")').length > 0) {
            _this.notify(
            "Oops! Email Address already exists in table.",
            "error",
            { position:"right" }
            );
            return false;
        }

        // RegEx email/domain validation
        if (/^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))?@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(_email_address) ) {
                 
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth()+1; //January is 0!
            var yyyy = today.getFullYear();

            // perform ajax request to store email address in table
            // --
            var data = {
                'action':   'w3dev_save_banned_login',
                'method':   'ban_email',
                'value':    _email_address
            };

            $.post(ajaxurl, data, function(insert_id) {

                var table = $('#w3dev-table-banned-emails').DataTable();
                var row_node = table.row.add([
                        _email_address,
                        dd+'-'+mm+'-'+yyyy,
                        '<a data-id="'+insert_id+'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a>'
                    ]).draw().node();
                $(row_node).attr('id', 'row-'+insert_id); 
        
               _this.notify(
                "Email Address added.",
                "success",
                { position:"right" }
                );

                _input.val('').focus();

            }); 

        } else {
            _this.notify(
            "Oops! That Email Address doesn't appear to be valid.",
            "error",
            { position:"right" }
            );
            return false;
        }


    });

    $('#btn-ban-ip-address').on('click', function(e) {

        var _this = $(this);
        var _current_ip = _this.data('current-ip-address');
        var _input = $("#input-ban-ip-address");
        var _ip_address = $.trim(_input.val());

        if (_ip_address.length == 0) { 
            _this.notify(
            "Oops! Please enter a valid IP Address.",
            "error",
            { position:"right" }
            );
            return false;
        }
    
        // check to see if email already exists in table
        // --
        if ($('#w3dev-table-banned-ip-addresses').find('td:contains("' + _ip_address + '")').length > 0) {
            _this.notify(
            "Oops! IP Address already exists in table.",
            "error",
            { position:"right" }
            );
            return false;
        }

        if (_current_ip == _ip_address) {
            _this.notify(
            "Oops! You can't ban your own IP Address!",
            "error",
            { position:"right" }
            );
            return false;
        }

        if (/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(_ip_address)) {

            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth()+1; //January is 0!
            var yyyy = today.getFullYear();

            // perform ajax request to store email address in table
            // --
            var data = {
                'action':   'w3dev_save_banned_login',
                'method':   'ip_address',
                'value':    _ip_address
            };

            $.post(ajaxurl, data, function(insert_id) {

                var table = $('#w3dev-table-banned-ip-addresses').DataTable();
                var row_node = table.row.add([
                        _ip_address,
                        dd+'-'+mm+'-'+yyyy,
                        '<a data-id="'+insert_id+'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a>'
                    ]).draw().node();
                $(row_node).attr('id', 'row-'+insert_id);

                       _this.notify(
                        "IP Address added.",
                        "success",
                        { position:"right" }
                        );
                
                _input.val('').focus();

            }); 

        } else {
            _this.notify(
            "Oops! That IP Address doesn't appear to be valid.",
            "error",
            { position:"right" }
            );
            return false;
        }

    });

    $('#btn-ban-countrycode').on('click', function(e) {

        var _this = $(this);
        var _input = $("#input-ban-countrycode");
        var _countrycode = $.trim(_input.val());

        if (_countrycode.length < 2) { 
            _this.notify(
            "Oops! Please enter a valid Country Code.",
            "error",
            { position:"right" }
            );
            return false;
        }
    
        // check to see if email already exists in table
        // --
        if ($('#w3dev-table-banned-countrycodes').find('td:contains("' + _countrycode + '")').length > 0) {
            _this.notify(
            "Oops! Country Code already exists in table.",
            "error",
            { position:"right" }
            );
            return false;
        }

        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth()+1; //January is 0!
        var yyyy = today.getFullYear();

        // perform ajax request to store email address in table
        // --
        var data = {
            'action':   'w3dev_save_banned_login',
            'method':   'countrycode',
            'value':    _countrycode
        };

        $.post(ajaxurl, data, function(insert_id) {

            var table = $('#w3dev-table-banned-countrycodes').DataTable();
            var row_node = table.row.add([
                    _countrycode,
                    dd+'-'+mm+'-'+yyyy,
                    '<a data-id="'+insert_id+'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a>'
                ]).draw().node();
            $(row_node).attr('id', 'row-'+insert_id);

                   _this.notify(
                    "Country Code added.",
                    "success",
                    { position:"right" }
                    );
            
            _input.val('').focus();

        }); 

    });

});

function ban_email() {  
    var addresses = document.getElementById("input-registration-add-list").value.split(" ");

    var failure = "";

    for(var index = 0; index < addresses.length; index ++ ) {
        // RegEx email/domain validation
        if (/^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))?@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(addresses[index]) ) {
            var row = document.getElementById("w3dev_ban_list").insertRow(-1)
            row.insertCell(0).innerHTML = addresses[index];
            row.insertCell(1).innerHTML = '<i class="fa fa-times" aria-hidden="true" onClick="change_email_ban(this)"></i>';        
        }
        else
            failure += addresses[index] + "\n";
    }

    if(failure == "\n" || failure == "")
        document.getElementById("w3dev_failure_icon").hide;
    else { 
        document.getElementById("w3dev_failure_icon").title = "The following emails or domains were not valid: \n\n" + failure;
        document.getElementById("w3dev_failure_icon").show;
    }

    document.getElementById("input-registration-add-list").value = "";
}

function w3dev_datepicker(ID) { 
    document.getElementById("input-w3dev-unban-" + ID).focus(); 
}
