<?php
if ( ! defined('ABSPATH' ) ) exit;

/**
 * This function is used to save the email template content
 * 
 */
add_action( 'wp_ajax_w3dev_save_banned_login', 'w3dev_save_banned_login_callback' );
function w3dev_save_banned_login_callback() {

	global $wpdb;
	$action 	= trim( $_POST['action'] );
	$method 	= trim( $_POST['method'] );
	$value 		= trim( $_POST['value'] );
	$user_id 	= get_current_user_id();

    if (empty($method)) {
        echo '0';
        wp_die();
    }

	if ($method == 'ban_email') {

		$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
			$wpdb->insert( $db_table_name, 
		    array( 
		        'user_id'   	=> $user_id,
		        'active'    	=> 1,
		        'email_address' => $value,
		        'date_time'   	=> date('Y-m-d H:i:s')
		    ));
			$record_id = $wpdb->insert_id;

	} elseif ($method == 'ip_address') {

		$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
		$wpdb->insert( $db_table_name, 
	    array( 
	        'user_id'   	=> $user_id,
	        'active'    	=> 1,
	        'ip_address' 	=> ip2long($value),
	        'date_time'   	=> date('Y-m-d H:i:s')
	    ));
		$record_id = $wpdb->insert_id;

	} elseif ($method == 'countrycode') {

		$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
		$value = strtolower($value);
		$wpdb->insert( $db_table_name, 
	    array( 
	        'user_id'   	=> $user_id,
	        'active'    	=> 1,
	        'geodata' 		=> "countrycode:$value",
	        'date_time'   	=> date('Y-m-d H:i:s')
	    ));
		$record_id = $wpdb->insert_id;

	}

	echo !empty($record_id) ? $record_id : '1';
	wp_die(); // this is required to terminate immediately and return a proper response

}

/**
 * This function is used to save the email template content
 * 
 */
add_action( 'wp_ajax_w3dev_delete_banned_login', 'w3dev_delete_banned_login_callback' );
function w3dev_delete_banned_login_callback() {

	global $wpdb;
	$id = trim( $_POST['id'] );

	if (!empty($id)) {
		$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
		$wpdb->delete( $db_table_name, array('id' => intval($id)) );
	}

	echo '1';
	wp_die(); // this is required to terminate immediately and return a proper response

}


/**
 * This function is used to save the email template content
 * 
 */
add_action( 'wp_ajax_w3dev_get_api_key', 'w3dev_get_api_key_callback' );
function w3dev_get_api_key_callback() {

	$site_url = get_bloginfo( 'url' );

	$args = array('body' => array('url' => $site_url));
	$reply = wp_remote_post( 'https://api.banusers.com/api/get_api_key', $args );

	//print_r($reply);

	if (!empty($reply['response']['code']) && $reply['response']['code'] == 200) {

		$key = $reply['body'];
		update_option( 'w3dev_api_key_w3_ip', $key );

	}

	echo $key;
	wp_die(); // this is required to terminate immediately and return a proper response

}


add_action( 'wp_ajax_w3dev_save_registration_ban_options', 'w3dev_save_registration_ban_options_callback');
function w3dev_save_registration_ban_options_callback()
{

    $enable_reg_ban_by_email    			= !empty( $_POST['enable_reg_ban_by_email'] ) ? 1 : 0;
    $enable_login_ban_by_email  			= !empty( $_POST['enable_login_ban_by_email'] ) ? 1 : 0;
    $enable_reg_ban_by_ip       			= !empty( $_POST['enable_reg_ban_by_ip'] ) ? 1 : 0;
    $enable_login_ban_by_ip  				= !empty( $_POST['enable_login_ban_by_ip'] ) ? 1 : 0;
    $enable_reg_ban_by_countrycode      	= !empty( $_POST['enable_reg_ban_by_countrycode'] ) ? 1 : 0;
    $enable_login_ban_by_countrycode  		= !empty( $_POST['enable_login_ban_by_countrycode'] ) ? 1 : 0;
    $enable_reg_ban_failed_country_check  	= !empty( $_POST['enable_reg_ban_failed_country_check'] ) ? 1 : 0;

	$w3dev_registration_ban_options = array(
		'enable_reg_ban_by_email'				=> $enable_reg_ban_by_email,
		'enable_login_ban_by_email'				=> $enable_login_ban_by_email,
		'enable_reg_ban_by_ip'					=> $enable_reg_ban_by_ip,
		'enable_login_ban_by_ip'				=> $enable_login_ban_by_ip,
		'enable_reg_ban_by_countrycode'			=> $enable_reg_ban_by_countrycode,
		'enable_login_ban_by_countrycode'		=> $enable_login_ban_by_countrycode,
		'enable_reg_ban_failed_country_check'	=> $enable_reg_ban_failed_country_check
		);

	update_option( 'w3dev_ban_user_registration_options', $w3dev_registration_ban_options );

    echo '1';
    wp_die(); // this is required to terminate immediately and return a proper response

}


?>
