<?php
if ( ! defined('ABSPATH' ) ) exit;

function w3dev_ban_user_options_partial()
{

    global $wpdb;
    $db_table_name = $wpdb->prefix . 'w3dev_login_details';
    if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {

        // only alert on 2nd ip, so skip first insert/record
        // --
        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_time, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            //echo long2ip($row->ip_address)." ";
            $logins[] = $row->count;
            $dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

    }

    $db_table_name              = $wpdb->prefix . 'w3dev_ubu_events';
    $banned_user_totals         = $banned_user_dates = array();
    $user_warnings_totals       = $user_warnings_dates = array();
    $spam_prevention_totals     = $spam_prevention_dates = array();
    $failed_login_totals        = $failed_login_dates = array();
    $login_success_totals       = $login_success_dates = array();
    $failed_reg_totals          = $failed_reg_dates = array();

    if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {

        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." WHERE category IN ('user') AND action IN ('banned') GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            $banned_user_totals[] = $row->count;
            $banned_user_dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." WHERE category IN ('notification') AND action IN ('warn user') GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            $user_warnings_totals[] = $row->count;
            $user_warnings_dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." WHERE category IN ('login','register') AND action IN ('denied') AND label IN ('spam') GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            $spam_prevention_totals[] = $row->count;
            $spam_prevention_dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." WHERE category IN ('login') AND action IN ('denied') GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            $failed_login_totals[] = $row->count;
            $failed_login_dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." WHERE category IN ('login') AND action IN ('success') GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            $login_success_totals[] = $row->count;
            $login_success_dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." WHERE category IN ('register') AND action = 'denied' AND label IN ('spam','ip','email', 'ccode') GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            $failed_reg_totals[] = $row->count;
            $failed_reg_dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

    }

    $db_table_name = $wpdb->prefix . 'usermeta';

    if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {
        
        $banned_users = $wpdb->get_results( "
                SELECT ".$wpdb->prefix."users.ID as user_id, ".$wpdb->prefix."users.user_login as user_login, ".$wpdb->prefix."users.user_email as user_email, usermeta2.meta_value as date_banned, usermeta3.meta_value as reason FROM $db_table_name
                LEFT JOIN ".$wpdb->prefix."users ON ".$wpdb->prefix."users.ID = ".$db_table_name.".user_id
                LEFT JOIN ".$wpdb->prefix."usermeta as usermeta2 ON ".$wpdb->prefix."usermeta.user_id = usermeta2.user_id AND usermeta2.meta_key = '".$wpdb->prefix."w3dev_user_banned_date' 
                LEFT JOIN ".$wpdb->prefix."usermeta as usermeta3 ON ".$wpdb->prefix."usermeta.user_id = usermeta3.user_id AND usermeta3.meta_key = '".$wpdb->prefix."w3dev_user_banned_reason' 
                WHERE ".$wpdb->prefix."usermeta.meta_key = '".$wpdb->prefix."w3dev_user_banned' AND
                ".$wpdb->prefix."usermeta.meta_value = 1 
                ORDER BY user_id ASC");

    } 

    global $wp_roles;
    $roles = $wp_roles->get_names();

    $w3dev_ban_user_class       = W3DEV_BAN_USER_CLASS::get_instance();
    $settings                   = $w3dev_ban_user_class->get_options('settings');
    $notifications              = $w3dev_ban_user_class->get_options('notifications');
    $registration_ban_options   = $w3dev_ban_user_class->get_options('registration');
    $email_template             = $notifications['user_notification'];
    //delete_option('w3dev_api_key_w3_ip');
    $w3dev_api_key_w3_ip        = get_option('w3dev_api_key_w3_ip');

    // note to self, need to move into class
    // --
    $w3dev_ban_css_scipts_options   = get_option('w3dev_ban_css_scipts_options');
    $w3dev_banned_word_options      = get_option('w3dev_banned_word_options');
    $w3dev_banned_username_options  = get_option('w3dev_banned_username_options');
    $w3dev_banned_password_options  = get_option('w3dev_banned_password_options');

    $inc_header_css = !empty($w3dev_ban_css_scipts_options['inc_header_css']) ? 1 : 0;
    $inc_footer_js  = !empty($w3dev_ban_css_scipts_options['inc_footer_js']) ? 1 : 0;

    // set default values
    // --
    $default_ban_subject_title              = isset( $notifications['_defaults']['user_notification']['subject_title'] ) ? $notifications['_defaults']['user_notification']['subject_title'] : null;
    $default_ban_body                       = isset( $notifications['_defaults']['user_notification']['body'] ) ? $notifications['_defaults']['user_notification']['body'] : null;
    $default_unban_subject_title            = isset( $notifications['_defaults']['user_notification']['unban_subject_title'] ) ? $notifications['_defaults']['user_notification']['unban_subject_title'] : null;
    $default_unban_body                     = isset( $notifications['_defaults']['user_notification']['unban_body'] ) ? $notifications['_defaults']['user_notification']['unban_body'] : null;
    $default_unban_indefinite_date_tag      = isset( $notifications['_defaults']['user_notification']['unban_indefinite_date_tag'] ) ? $notifications['_defaults']['user_notification']['unban_indefinite_date_tag'] : null;
    $default_warn_subject_title             = isset( $notifications['_defaults']['user_notification']['warn_subject_title'] ) ? $notifications['_defaults']['user_notification']['warn_subject_title'] : null ;
    $default_warn_body                      = isset( $notifications['_defaults']['user_notification']['warn_body'] ) ? $notifications['_defaults']['user_notification']['warn_body'] : null ;

    // set saved values
    // --
    $ban_subject_title              = !empty( $email_template['subject_title'] ) ? $email_template['subject_title'] : $default_ban_subject_title;
    $ban_body                       = !empty( $email_template['body'] ) ? $email_template['body'] : $default_ban_body;
    $ban_cc_field                   = !empty( $email_template['ban_cc_field'] ) ? $email_template['ban_cc_field'] : null;
    $ban_bcc_field                  = !empty( $email_template['ban_bcc_field'] ) ? $email_template['ban_bcc_field'] : null;

    $unban_subject_title            = !empty( $email_template['unban_subject_title'] ) ? $email_template['unban_subject_title'] : $default_unban_subject_title;
    $unban_body                     = !empty( $email_template['unban_body'] ) ? $email_template['unban_body'] : $default_unban_body;
    $unban_indefinite_date_tag      = !empty( $email_template['unban_indefinite_date_tag'] ) ? $email_template['unban_indefinite_date_tag'] : $default_unban_indefinite_date_tag;
    $unban_cc_field                 = !empty( $email_template['unban_cc_field'] ) ? $email_template['unban_cc_field'] : null;
    $unban_bcc_field                = !empty( $email_template['unban_bcc_field'] ) ? $email_template['unban_bcc_field'] : null;

    $warn_subject_title             = !empty( $email_template['warn_subject_title'] ) ? $email_template['warn_subject_title'] : $default_warn_subject_title;
    $warn_body                      = !empty( $email_template['warn_body'] ) ? $email_template['warn_body'] : $default_warn_body ;
    $warn_cc_field                  = !empty( $email_template['warn_cc_field'] ) ? $email_template['warn_cc_field'] : null;
    $warn_bcc_field                 = !empty( $email_template['warn_bcc_field'] ) ? $email_template['warn_bcc_field'] : null;

    $admin_login_subject_title      = !empty( $email_template['admin_login_subject_title'] ) ? $email_template['admin_login_subject_title'] : null;
    $admin_login_body               = !empty( $email_template['admin_login_body'] ) ? $email_template['admin_login_body'] : null;

    ?>

    <div id="js-save-message" class="alert success" style="display: none;">
        <a class="close" href=""><i class="fa fa-2x fa-times" aria-hidden="true"></i></a>
        <i class="fa fa-check" aria-hidden="true"></i> Successfully Saved Changes
    </div>
    <style>
        #js-save-message { 
            background-color: #5db85b;color:#fff; border-radius: 0; margin-left: 0; margin-bottom: 0;
            position: fixed; left: 0; right: 0; top: 0; z-index: 2000; z-index: 110000;
            padding: 15px 30px; line-height: 2em; font-weight: bold;
        }
        #js-save-message a.close { float: right; color: #fff; }
    </style>

    <div id="ban-user-container">

        <div style="position:relative;background-image: url(https://ps.w.org/ban-users/assets/banner-772x250.png?rev=1455118); background-size: cover; background-position: center center; background-repeat: no-repeat;height: 200px;margin-left:-20px;margin-right: -20px;margin-top: -20px;margin-bottom: 20px;padding: 30px;">
            
            <div style="position:absolute;bottom: 30px;">
                <h1 class="animated fadeIn" style="letter-spacing:2px;margin-bottom:0;background-color:#111;background-color:rgba(0,0,0,0.8);display:inline-block;padding: 12px 20px;line-height:1em;color:#fff;border-radius: 4px;"><span style="color: #e5a238">Ultimate</span> BAN Users - <span style="letter-spacing:0;color:#e5a238;font-weight:300;">v<?php echo W3DEV_BAN_USERS_PLUGIN_VERSION; ?></span></h1> 
            </div>

        </div>

        <ul id="w3dev-tabs">
            <li><a class="active" data-tab="dashboard" href="javascript:void(0)">Charts</a></li>
            <!--<li><a data-tab="summary" href="javascript:void(0)">Dashboard</a></li>-->
            <li><a data-tab="banned-users" href="javascript:void(0)"><?php _e('Banned Users', 'ban-users'); ?> (<?php echo count($banned_users); ?>)</a></li>
            <li><a data-tab="event-log" href="javascript:void(0)"><?php _e('Event Log', 'ban-users'); ?></a></li>
            <li><a data-tab="settings" href="javascript:void(0)">Settings</a></li>
            <li><a data-tab="email-template" href="javascript:void(0)">Email Templates</a></li>
            <?php if (W3DEV_BAN_USERS_PREMIUM_VERSION) { ?>
                <li><a data-tab="registration-ban" href="javascript:void(0)">Registration Bans</a></li>
            <?php } ?>
            <li><a target="_blank" href="https://banusers.com">FAQs</a></li>
            <?php if (!W3DEV_BAN_USERS_PREMIUM_VERSION) { ?>
                <li class="go-pro"><a data-tab="go-pro" href="javascript:void(0)"><span>Go Pro!</span></a></li>
            <?php } ?>
        </ul>
        <div class="w3dev-tab active" id="tab-dashboard">

                <div class="cf" style="padding-top: 15px;">
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-right: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Denied logins<br /><span style="font-weight:normal;font-size:12px;">Users denied login access due to account restrictions</span></h3>
                            <canvas id="myChart" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$failed_login_dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$failed_login_totals); ?>"],
                                        borderColor: '#e22725',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }],
                                        yAxes: [{
                                           ticks: {
                                              min: 0,
                                              stepSize: 10,
                                          }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-left: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Successful logins<br /><span style="font-weight:normal;font-size:12px;">Users who have successfully logged in</span></h3>
                            <canvas id="myChart2" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart2");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$login_success_dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$login_success_totals); ?>"],
                                        borderColor: '#57a968',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }],
                                        yAxes: [{
                                           ticks: {
                                              min: 0,
                                              stepSize: <?php echo max($login_success_totals)/8; ?>,
                                          }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                </div>

                <div class="cf">
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-right: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Banned users<br /><span style="font-weight:normal;font-size:12px;">User accounts that have been banned</span></h3>
                            <canvas id="banned-users-chart" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("banned-users-chart");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$banned_user_dates); ?>"],
                                    datasets: [{
                                        label: '# of Users',
                                        data: ["<?php echo implode('","',$banned_user_totals); ?>"],
                                        borderColor: '#e22725',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }],
                                        yAxes: [{
                                           ticks: {
                                              min: 0,
                                              stepSize: <?php echo max($banned_user_totals)/8; ?>,
                                          }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-left: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">User warnings<br /><span style="font-weight:normal;font-size:12px;">Users who have been sent a warning notification</span></h3>
                            <canvas id="user-warnings-charts" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("user-warnings-charts");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$user_warnings_dates); ?>"],
                                    datasets: [{
                                        label: '# of Warnings',
                                        data: ["<?php echo implode('","',$user_warnings_totals); ?>"],
                                        borderColor: '#e5a238',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }],
                                        yAxes: [{
                                           ticks: {
                                              min: 0,
                                              stepSize: <?php echo max($user_warnings_totals)/8; ?>,
                                          }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                </div>

                <div class="cf">
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-right: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Denied registrations<br /><span style="font-weight:normal;font-size:12px;">New registrations blocked due to account restrictions</span></h3>
                            <canvas id="myChart5" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart5");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$failed_reg_dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$failed_reg_totals); ?>"],
                                        borderColor: '#e22725',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }],
                                        yAxes: [{
                                           ticks: {
                                              min: 0,
                                              stepSize: <?php echo max($failed_reg_totals)/8; ?>,
                                          }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>

                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-left: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Spam preventions<br /><span style="font-weight:normal;font-size:12px;">Logins and new registrations blocked by anti-spam measures</span></h3>
                            <canvas id="myChart6" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart6");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$spam_prevention_dates); ?>"],
                                    datasets: [{
                                        label: '# of Preventions',
                                        data: ["<?php echo implode('","',$spam_prevention_totals); ?>"],
                                        borderColor: '#e5a238',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }],
                                        yAxes: [{
                                           ticks: {
                                              min: 0,
                                              stepSize: <?php echo max($spam_prevention_totals)/8; ?>,
                                          }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                </div>
        
        </div>
        <!--
        <div class="w3dev-tab hidden" id="tab-summary">
            
            <div style="margin-top: 15px;" id="" class="w3dev-settings-section">
                <h3><i class="w3dev-icon fa fa-2x fa-cogs" aria-hidden="true"></i> Summary of Configuration</h3>

                
                <div class="w3dev-content">
                
                    <ul class="lined-list">
                        <li>Accessibility<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Ban / Unban Users<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-off" aria-hidden="true"></i></a></li>
                        <li>Warn users<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>IP / Geodata<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Users Table<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Notifications<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Security<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Banned keywords / Phrases<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>CSS / Scripts<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>3rd Party<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Conflict Management<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Registration<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Device Detection<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Event Logging<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                        <li>Restrict Logins<a class="toggle pull-right" href="javascript:void(0)"><i class="fa fa-2x fa-toggle-on" aria-hidden="true"></i></a></li>
                    </ul>

                    <style>
                        ul.lined-list li {
                            border-bottom: 1px solid #eee;
                            padding: 12px;
                            font-weight: 500;
                            font-size: 16px;
                        }
                        ul.lined-list li a.toggle { margin-top: -8px; }
                        .fa-toggle-on { color:#337ab7; }
                        .fa-toggle-off { color:#aaa; }
                    </style>

                </div>

            </div>

        </div>
        -->
        <div class="w3dev-tab hidden" id="tab-banned-users">

            <div style="margin-top: 15px;" class="w3dev-settings-section">

                <h3><i class="w3dev-icon fa fa-2x fa-ban" aria-hidden="true"></i> Banned <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <div style="margin-bottom: 60px;">
                <table id="w3dev-table-banned-users" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th><?php _e('User Login (ID)', 'ban-users'); ?></th>
                    <th><?php _e('Email', 'ban-users'); ?></th>
                    <th><?php _e('Ban reason', 'ban-users'); ?></th>
                    <th><?php _e('Date banned', 'ban-users'); ?></th>
                    <th><?php _e('Unban', 'ban-users'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php
                if ( !empty($banned_users) && is_array($banned_users) )
                    foreach ($banned_users as $banned_user)
                        echo '<tr id="row-'.$banned_user->user_id.'">
                                <td>'.$banned_user->user_login.' (<a href="'.get_edit_user_link( $banned_user->user_id ).'">'.$banned_user->user_id.'</a>)</td>
                                <td>'.$banned_user->user_email.'</td>
                                <td>'.$banned_user->reason.'</td>
                                <td>'.$banned_user->date_banned.'</td>
                                <td>
                                    <a class="js-unban-user" data-user-id="'.$banned_user->user_id.'" href="javascript:void(0)">
                                        <span class="fa-stack fa-lg" aria-hidden="true">
                                        <i class="fa fa-square fa-stack-2x" aria-hidden="true"></i>
                                        <i class="fa fa-ban fa-stack-1x fa-inverse" aria-hidden="true"></i>
                                        </span>
                                    </a>           
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body"><?php _e('Back to Top', 'ban-users'); ?></a>

            </div>
            
        </div>
        <div class="w3dev-tab hidden" id="tab-event-log">

            <div style="margin-top: 15px;" class="w3dev-settings-section">

                <h3><i class="w3dev-icon fa fa-2x fa-calendar-o" aria-hidden="true"></i> Event Log (Last 30 days)<a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">

                    <?php
                    $db_table_name = $wpdb->prefix . 'w3dev_ubu_events';
                    $event_log = array();
                    if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {
                        $event_log = $wpdb->get_results( "
                            SELECT *, DATE_FORMAT(date_created, '%Y/%m/%d') as date_time2 
                            FROM ".$db_table_name." 
                            LEFT JOIN ".$wpdb->prefix."users ON ".$wpdb->prefix."users.ID = ".$db_table_name.".user_id
                            WHERE category NOT IN ('api') 
                            AND date_created >= DATE_SUB(NOW(), INTERVAL 1 MONTH)
                            ORDER BY date_time2 ASC");

                        // LEFT OUTER JOIN ".$wpdb->prefix."w3dev_login_details ON ".$wpdb->prefix."w3dev_login_details.user_id = ".$wpdb->prefix."users.ID
                    }
                    ?>

                    <table class="data-table w3dev-compact-table" style="border:0;">
                        <thead>
                            <tr>
                                <th>Event</th>
                                <th>User Login (ID)</th>
                                <th>Action</th>
                                <th>Label</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <?php
                        if (!empty($event_log)) {
                        foreach ($event_log as $key => $row) { 

                            switch ($row->label) {
                                case 'email':
                                    $row->label = 'Banned email address';
                                    break;

                                case 'user':
                                    $row->label = 'Banned user';
                                    break;

                                case 'ccode':
                                    $row->label = 'Banned country code';
                                    break;

                                default:
                                    # code...
                                    break;
                            }

                            ?>

                            <tr>
                                <td><?php echo ucfirst($row->category); ?></td>
                                <td><?php if (!empty($row->user_id)) { ?><?php echo $row->user_login; ?> (<a href="<?php echo get_edit_user_link( $banned_user->user_id ); ?>"><?php echo $row->user_id; ?></a>)<?php } ?></td>
                                <td><?php echo ucfirst($row->action); ?></td>
                                <td><?php echo $row->label; ?></td>
                                <td><?php echo date('d-m-Y H:i:s', strtotime($row->date_created)); ?></td>
                            </tr>

                        <?php }} ?>

                    </table>

                </div>

            </div>
            
        </div>
        <div class="w3dev-tab hidden" id="tab-settings">

            <form style="padding-top: 15px;">

                <div id="w3dev-js-scrollto-section" class="w3dev-quick-links" style="margin-bottom:10px;">
                    <a href="#w3dev-accessibility-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-low-vision faa-pulse" aria-hidden="true"></i><span>Accessibility</span></a>
                    <a href="#w3dev-api-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-key faa-pulse" aria-hidden="true"></i><span>API Key</span></a>
                    <a href="#w3dev-general-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-cog faa-pulse" aria-hidden="true"></i><span>General</span></a>
                    <a href="#w3dev-login-registration-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-user-plus faa-pulse" aria-hidden="true"></i><span>Authentication</span></a>
                    <a href="#w3dev-ban-options-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-ban faa-pulse" aria-hidden="true"></i><span>Banning</span></a>
                    <a href="#w3dev-default-messages-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-bullhorn faa-pulse" aria-hidden="true"></i><span>Messages</span></a>
                    <a href="#w3dev-ipgeo-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-map-marker faa-pulse" aria-hidden="true"></i><span>IP/GEO</span></a>
                    <a href="#w3dev-device-detection-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-laptop faa-pulse" aria-hidden="true"></i><span>Device</span></a>
                    <a href="#w3dev-events-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-calendar-o faa-pulse" aria-hidden="true"></i><span>Event Logs</span></a>
                    <a href="#w3dev-restrict-login-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-clock-o faa-pulse" aria-hidden="true"></i><span>Restrict Login</span></a>
                    <a href="#w3dev-notification-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-flag faa-pulse" aria-hidden="true"></i><span>Notify</span></a>
                    <a href="#w3dev-users-table-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-table faa-pulse" aria-hidden="true"></i><span>Users</span></a>
                    <a href="#w3dev-warn-options-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-exclamation-triangle faa-pulse" aria-hidden="true"></i><span>Warn</span></a>
                    <a href="#w3dev-security-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-shield faa-pulse" aria-hidden="true"></i><span>Security</span></a>
                    <a href="#w3dev-banned-keywords-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-font faa-pulse" aria-hidden="true"></i><span>Keywords</span></a>

                    <a href="#w3dev-banned-usernames-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-user-circle-o faa-pulse" aria-hidden="true"></i><span>Usernames</span></a>
                    <!--<a href="#w3dev-banned-passwords-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-unlock-alt faa-pulse" aria-hidden="true"></i><span>Passwords</span></a>-->

                    <a href="#w3dev-3rdparty-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-plug faa-pulse" aria-hidden="true"></i><span>3rd Party</span></a>
                    <a href="#w3dev-css-scripts-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-code faa-pulse" aria-hidden="true"></i><span>CSS/Scripts</span></a>
                    <a href="#w3dev-shortcodes-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-wordpress faa-pulse" aria-hidden="true"></i><span>Shortcodes</span></a>
                    <a href="#w3dev-conflict-section" class="faa-parent animated-hover"><i class="fa fa-4x fa-bug faa-pulse" aria-hidden="true"></i><span>Conflict</span></a>
                </div>

                <style>
                    .w3dev-quick-links a {
                        margin-right: 10px;
                        border: 1px solid #ccc;
                        display: inline-block;
                        padding: 10px;
                        border-radius: 4px;
                        margin-bottom: 15px;
                        text-align: center;
                        width: 74px;
                        text-decoration: none;
                    }
                    .w3dev-quick-links a span {
                        display: block;
                        text-decoration: none;
                        padding-top: 5px;
                        font-size: 11px;
                    }
                    .w3dev-quick-links a:hover {
                        color:#8a6d3b;
                        background-color: #f9f9f9;
                    }
                    .w3dev-settings-section {
                        position: relative;
                    }
                    .w3dev-back-to-top {
                        position: absolute;
                        right: 10px;
                        bottom: 8px;
                        text-decoration: none;
                        color: #ccc;
                    }
                    .w3dev-settings-section.closed { padding-bottom: 0px; }
                    .w3dev-settings-section.closed a.w3dev-back-to-top { display: none; }
                    .w3dev-settings-section.closed h3 { margin-bottom: -1px; }

                    .w3dev-back-to-top:hover {
                        color: #347ab7;
                    }
                    /**
                     * For modern browsers
                     * 1. The space content is one way to avoid an Opera bug when the
                     *    contenteditable attribute is included anywhere else in the document.
                     *    Otherwise it causes space to appear at the top and bottom of elements
                     *    that are clearfixed.
                     * 2. The use of `table` rather than `block` is only necessary if using
                     *    `:before` to contain the top-margins of child elements.
                     */
                    .cf:before,
                    .cf:after {
                        content: " "; /* 1 */
                        display: table; /* 2 */
                    }

                    .cf:after {
                        clear: both;
                    }

                    /**
                     * For IE 6/7 only
                     * Include this rule to trigger hasLayout and contain floats.
                     */
                    .cf {
                        *zoom: 1;
                    }

                </style>

                <div id="w3dev-accessibility-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-low-vision" aria-hidden="true"></i> Accessibility Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-enable-accessibility" id="input-enable-accessibility" value="1" <?php echo (!empty($settings['enable_accessibility'])) ? 'checked' : null; ?> /> Optimise plugin for accessibility / screen readers
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/accessibility/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>
                   

                    <style>
                        .w3dev-settings-section.with-help { padding-bottom: 0; }
                        .w3dev-settings-section .w3dev-content { }
                        .w3dev-settings-section .w3dev-footer { margin-top: 20px; text-align:right; border-top: 1px solid #ddd; padding: 10px; margin-bottom: 0; margin-left: -20px; margin-right: -20px; }
                        .w3dev-settings-section .w3dev-footer .w3dev-back-to-top { position: initial; top: initial; right: initial; }
                        .w3dev-settings-section .w3dev-footer a { margin-left: 20px; }
                    </style>

                </div>

                <div id="w3dev-api-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-key" aria-hidden="true"></i> Free API Key <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Your API Key: 
                        <?php if (empty($w3dev_api_key_w3_ip)) { ?><a href="javascript:void(0);" id="w3dev-get-api-key">Click here to get your free API Key</a><?php } ?>
                        </label>
                        <input readonly type="text" class="form-control" name="input-api-key" id="input-api-key" value="<?php echo !empty($w3dev_api_key_w3_ip) ? $w3dev_api_key_w3_ip : null; ?>" placeholder="" />
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/ip-geodata/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

               <div id="w3dev-general-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-cog" aria-hidden="true"></i> General Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div id="js-custom-logout" style="margin-bottom: 10px;">
                        <input type="checkbox" name="input-close-panels" id="input-close-panels" value="1" <?php echo (!empty($settings['close_panels'])) ? 'checked' : null; ?> /> Close all setting panels by default
                    </div>
                    <div id="js-custom-logout" style="margin-bottom: 10px;">
                        <input type="checkbox" name="input-custom-logout" id="input-custom-logout" value="1" <?php echo (!empty($settings['custom_logout'])) ? 'checked' : null; ?> /> Set custom redirection url after forcing user to logout
                    </div>
                    <div id="js-custom-logout-url" style="margin-bottom:10px; <?php echo (!empty($settings['custom_logout'])) ? null : 'display:none;' ?>">
                        <input class="form-control" type="text" name="input-custom-logout-url" id="input-custom-logout-url" value="<?php echo esc_url(stripslashes($settings['custom_logout_url'])); ?>" placeholder="Custom logout URL" /> <span class="help-block" style="color:#999">(i.e. http://mywebsite.com or relative so /about-us)</span>
                    </div>

                    <div id="js-banned-login-message" style="margin-bottom: 10px; padding-top: 10px;">
                        <label style="margin-bottom:5px;display:block;">Set Date Format:</label>
                        <select class="SlectBox" name="input-date-format" id="input-date-format">
                            <option value="d-m-Y" <?php echo (empty($settings['date_format']) || $settings['date_format'] == 'd-m-Y') ? 'selected="selected"' : null; ?>>DD-MM-YYYY</option>
                            <option value="m-d-Y" <?php echo (!empty($settings['date_format']) && $settings['date_format'] == 'm-d-Y') ? 'selected="selected"' : null; ?>>MM-DD-YYYY</option>
                        </select>
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

               <div id="w3dev-login-registration-section"  class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-user-plus" aria-hidden="true"></i> Login &amp; Registration Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>
            
                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-reg-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_email']) ? 'checked' : null; ?> /> Block users registering with a banned Email Address
                    </div>
                    <div class="mb-20">
                        <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-login-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_login_ban_by_email']) ? 'checked' : null; ?> /> Prevent users logging in if Email Address has been banned
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-enable-reg-ban-by-ip" id="input-enable-reg-ban-by-ip" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_ip']) ? 'checked' : null; ?> /> Block users registering with a banned IP Address
                    </div>
                    <div class="mb-20">
                        <input type="checkbox" name="input-enable-login-ban-by-ip" id="input-enable-login-ban-by-ip" value="1" <?php echo !empty($registration_ban_options['enable_login_ban_by_ip']) ? 'checked' : null; ?> /> Prevent users logging in if IP Address has been banned
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-enable-reg-ban-by-countrycode" id="input-enable-reg-ban-by-countrycode" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_countrycode']) ? 'checked' : null; ?> /> Block users registering from a banned Country
                    </div>
                    <div class="mb-20">
                        <input type="checkbox" name="input-enable-login-ban-by-countrycode" id="input-enable-login-ban-by-countrycode" value="1" <?php echo !empty($registration_ban_options['enable_login_ban_by_countrycode']) ? 'checked' : null; ?> /> Prevent users logging in from a banned Country
                    </div>
                    <div class="mb-20">
                        <input type="checkbox" name="input-enable-reg-ban-failed-country-checked" id="input-enable-reg-ban-failed-country-checked" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_failed_country_check']) ? 'checked' : null; ?> /> Block users registering when Country field doesn't match GEO location. (Ultimate Member Plugin only) <?php $w3dev_ban_user_class->display_label('new'); ?>
                    </div>
                    <!--
                    <div style="margin-bottom: 10px;display:none;">
                        <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-reg-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_email']) ? 'checked' : null; ?> /> Share banned IP Addresses with remote BAN Users database (BETA)
                    </div>
                    <div style="margin-bottom: 30px;display:none;">
                        <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-reg-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_email']) ? 'checked' : null; ?> /> Share banned Email Addresses with remote BAN Users database (BETA)
                    </div>
                    -->
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-ban-options-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-ban" aria-hidden="true"></i> Ban &amp; Unban Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-on-ban-change-user-role" id="input-on-ban-change-user-role" value="1" <?php echo (!empty($settings['on_ban_change_user_role'])) ? 'checked' : null; ?> /><?php _e("Change the user's role when banned.", 'ban-users'); ?>
                    </div>
                    <div id="js-set-banned-user-role" style="margin-bottom:10px; padding-left: 30px; <?php echo (empty($settings['on_ban_change_user_role'])) ? 'display:none;' : null; ?>">
                    <?php
                    $roles = get_editable_roles();
                    echo '<select class="SlectBox" id="input-set-banned-user-role" name="input-set-banned-user-role">';
                    foreach ($roles as $key => $role) {
                        echo '<option '.($settings['set_banned_user_role'] == $key ? 'selected="selected"' : null).' value="' . $key . '">'.$key.'</option>';
                    }
                    echo '</select>';
                    ?>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-on-unban-change-user-role" id="input-on-unban-change-user-role" value="1" <?php echo (!empty($settings['on_unban_change_user_role'])) ? 'checked' : null; ?> /><?php _e("Change the user's role when unbanned.", 'ban-users'); ?>
                    </div>
                    <div id="js-set-unbanned-user-role" style="margin-bottom:10px; padding-left: 30px; <?php echo (empty($settings['on_unban_change_user_role'])) ? 'display:none;' : null; ?>">
                    <?php
                    $roles = get_editable_roles();
                    echo '<select class="SlectBox" id="input-set-unbanned-user-role" name="input-set-unbanned-user-role">';
                    foreach ($roles as $key => $role) {
                        echo '<option '.($settings['set_unbanned_user_role'] == $key ? 'selected="selected"' : null).' value="' . $key . '">'.$key.'</option>';
                    }
                    echo '</select>';
                    ?>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-change-status" id="input-change-status" value="1" <?php echo (!empty($settings['change_posts_status'])) ? 'checked' : null; ?> /> Change the user's posts status when banned
                    </div>
                    <div id="js-post-status" style="margin-bottom:10px; padding-left: 30px; <?php echo (empty($settings['change_posts_status'])) ? 'display:none;' : null; ?>">
                    <?php
                    $all_statuses = get_post_stati();
                    echo '<select id="input-post-status" name="input-post-status">';
                    echo '<option>Select status</option>';
                    foreach ($all_statuses as $key => $status) {
                        echo '<option '.($settings['post_status'] == $key ? 'selected="selected"' : null).' value="' . $key . '">'.$status.'</option>';
                    }
                    echo '</select>';
                    ?>
                    </div>

                    <div id="js-force-logout" class="mb-10">
                        <input type="radio" name="input-logged-in-options" id="input-force-logout" value="1" <?php echo (!empty($settings['force_logout'])) ? 'checked' : null; ?> /> If already logged in when banned, force logout.
                    </div>
                    <div id="js-display-message" class="mb-10">
                        <input type="radio" name="input-logged-in-options" id="input-display-message" value="1" <?php echo (!empty($settings['display_message'])) ? 'checked' : null; ?> /> If already logged in when banned, display message to user.
                    </div>
                    
                    <div id="js-display-message-extras" style="<?php echo (empty($settings['display_message'])) ? 'display:none;' : null; ?>">

                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" disabled="disabled" value="1" checked="checked" /> Display message in back end of website
                        </div>
                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" name="input-frontend-banned-notification" id="input-frontend-banned-notification" value="1" <?php echo (!empty($settings['frontend_banned_notification'])) ? 'checked' : null; ?> /> Display message on front end of website in a dialog box
                        </div>
                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" name="input-frontend-notification-force-logout" id="input-frontend-notification-force-logout" value="1" <?php echo (!empty($settings['frontend_notification_force_logout'])) ? 'checked' : null; ?> /> Force logout and redirect (after diplaying message in dialog box; when applicable)
                        </div>
                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" name="input-frontend-notification-hide" id="input-frontend-notification-hide" value="1" <?php echo (!empty($settings['frontend_notification_force_logout'])) ? 'disabled' : null; ?> <?php echo (!empty($settings['frontend_notification_hide'])) ? 'checked' : null; ?> /> Only show diaglog box once (uses cookie - set to 30days)
                        </div>

                    </div>
                    <div id="js-scramble-banned-users-password" class="mb-10">
                        <input type="checkbox" name="input-scramble-banned-users-password" id="input-scramble-banned-users-password" value="1" <?php echo (!empty($settings['scramble_banned_users_password'])) ? 'checked' : null; ?> /> <?php _e('Scramble banned user\'s password when banned.', 'ban-users'); ?>
                    </div>
                    <div id="js-set-spammer-option" class="mb-10">
                        <input type="checkbox" name="input-set-spammer-option" id="input-set-spammer-option" value="1" <?php echo (!empty($settings['set_spammer_option'])) ? 'checked' : null; ?> /> <?php _e('Set WordPress option \'Spammer\' for banned users.', 'ban-users'); ?>
                    </div>
                    <div id="js-unset-spammer-option" class="mb-10">
                        <input type="checkbox" name="input-unset-spammer-option" id="input-unset-spammer-option" value="1" <?php echo (!empty($settings['unset_spammer_option'])) ? 'checked' : null; ?> /> <?php _e('Remove WordPress option \'Spammer\' when unbanning users.', 'ban-users'); ?>
                    </div>
                    <div id="js-hide-banned-users-comments" class="mb-10">
                        <input type="checkbox" name="input-hide-banned-users-comments" id="input-hide-banned-users-comments" value="1" <?php echo (!empty($settings['hide_banned_users_comments'])) ? 'checked' : null; ?> /> <?php _e('Hide banned users\' comments on front end.', 'ban-users'); ?>
                    </div>
                    <div id="js-disable-password-reset-banned-users" class="mb-10">
                        <input type="checkbox" name="input-disable-password-reset-banned-users" id="input-disable-password-reset-banned-users" value="1" <?php echo (!empty($settings['disable_password_reset_banned_users'])) ? 'checked' : null; ?> /> <?php _e('Disable password reset for banned users.', 'ban-users'); ?>
                    </div>
                    <div id="js-ban-email" class="mb-10">
                        <input type="checkbox" name="input-ban-email" id="input-ban-email" value="1" <?php echo (!empty($settings['ban_email'])) ? 'checked' : null; ?> /> Enable email notifications when banning or unbanning users
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-always-unban-ipaddress" id="input-always-unban-ipaddress" value="1" <?php echo (!empty($settings['always_unban_ipaddress'])) ? 'checked' : null; ?> /> Always unban user's last known ip address when unbanning their account
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-default-ban-ipaddress" id="input-default-ban-ipaddress" value="1" <?php echo (!empty($settings['default_ban_ipaddress'])) ? 'checked' : null; ?> /> Set default to ban a user's last known ip address when banning their account
                    </div>
                    <div id="js-ban-email-default" class="mb-10">
                        <input type="checkbox" name="input-ban-email-default" id="input-ban-email-default" value="1" <?php echo (!empty($settings['ban_email_default'])) ? 'checked' : null; ?> /> Include option for custom message in email, and option to set ban duration when banning a user (i.e. date picker, day, week, month etc..)
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/ban-unban-users/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>


               <div id="w3dev-default-messages-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-bullhorn" aria-hidden="true"></i> Default Messages <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div id="js-ban-email-message" style="margin-bottom:10px; <?php echo (!empty($settings['ban_email_default'] )) ? 'display:none;' : null; ?>">
                        <label style="margin-bottom:5px;display:block;">Default reason for banning a user:</label>
                        <input type="text" class="form-control" name="input-ban-email-message" id="input-ban-email-message" value="<?php echo $settings['ban_email_default_message']; ?>" placeholder="Generic reason for ban" />
                    </div>
                    <div id="js-banned-login-message" class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display when a banned user attempts to login:</label>
                        <input class="form-control" type="text" name="input-banned-login-message" id="input-banned-login-message" value="<?php echo esc_html(stripslashes($settings['banned_login_message'])); ?>" placeholder="This user account has been banned" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display when user has been banned, whilst logged in, and attempts to access restricted content:</label>
                        <input class="form-control" type="text" name="input-custom-message" id="input-custom-message" value="<?php echo esc_html(stripslashes($settings['custom_message'])); ?>" placeholder="Message to banned user" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display if login/registration denied (see Spam Prevention setting):</label>
                        <?php $denied_login_message = !empty($settings['denied_login_message']) ? esc_html(stripslashes($settings['denied_login_message'])) : null; ?>
                        <input class="form-control" type="text" name="input-denied-login-message" id="input-denied-login-message" value="<?php echo $denied_login_message; ?>" placeholder="Access to our site is denied" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display to Bad Bots if not redirected:</label>
                        <?php $denied_bad_bot_message = !empty($settings['denied_bad_bot_message']) ? esc_html(stripslashes($settings['denied_bad_bot_message'])) : null; ?>
                        <input class="form-control" type="text" name="input-denied-bad_bot-message" id="input-denied-bad_bot-message" value="<?php echo $denied_bad_bot_message; ?>" placeholder="Access to our site is denied" />
                    </div>

                    <div id="js-default-ban-reason" class="mb-10" style="<?php echo (empty($settings['ban_email_default'] )) ? 'display:none;' : null; ?>">
                        <label style="margin-bottom:5px;display:block;"><?php _e("Default 'reason' for banning a user:", 'ban-users'); ?><br />
                        <span style="font-style: italic; color:#999"><strong><?php _e('Note:', 'ban-users'); echo ' </strong>'; _e('this default value will be inserted into the ban user modal/popup when sending a custom message', 'ban-users'); ?></span></label>
                        <input class="form-control" type="text" name="input-default-ban-reason" id="input-default-ban-reason" value="<?php echo !empty($settings['default_ban_reason']) ? esc_html(stripslashes($settings['default_ban_reason'])) : null; ?>" placeholder="<?php _e('i.e. Because you have broken our terms and conditions.', 'ban-users'); ?>" />
                    </div>

                    <div id="js-default-warn-reason" class="mb-10" style="<?php echo (empty($settings['warn_user'] )) ? 'display:none;' : null; ?>">
                        <label style="margin-bottom:5px;display:block;"><?php _e("Default 'reason' for warning a user:", 'ban-users'); ?><br />
                        <span style="font-style: italic; color:#999"><strong><?php _e('Note:', 'ban-users'); echo ' </strong>'; _e('this default value will be inserted into the warn user modal/popup when sending a custom message', 'ban-users'); ?></span></label>
                        <input class="form-control" type="text" name="input-default-warn-reason" id="input-default-warn-reason" value="<?php echo !empty($settings['default_warn_reason']) ? esc_html(stripslashes($settings['default_warn_reason'])) : null; ?>" placeholder="<?php _e('i.e. Failure to adhere to our terms and conditions will result in your immediate suspension. This is your first and final warning.', 'ban-users'); ?>" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display when non-admin user attempts to login when role restrictions apply:</label>
                        <?php $non_admin_role_restriction_message = !empty($settings['non_admin_role_restriction_message']) ? esc_html(stripslashes($settings['non_admin_role_restriction_message'])) : null; ?>
                        <input class="form-control" type="text" name="input-non-admin-role-restriction-message" id="input-non-admin-role-restriction-message" value="<?php echo $non_admin_role_restriction_message; ?>" placeholder="Access to our site is denied" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display when admin user attempts to login during restricted hours:</label>
                        <?php $admin_restricted_hours_message = !empty($settings['admin_restricted_hours_message']) ? esc_html(stripslashes($settings['admin_restricted_hours_message'])) : null; ?>
                        <input class="form-control" type="text" name="input-admin-restricted-hours-message" id="input-admin-restricted-hours-message" value="<?php echo $admin_restricted_hours_message; ?>" placeholder="Access to our site is denied" />
                    </div>

                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>


                <div id="w3dev-ipgeo-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-map-marker" aria-hidden="true"></i> IP/Geodata Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-capture-login-geoip-data" id="input-capture-login-geoip-data" value="1" <?php echo (!empty($settings['capture_login_geoip_data'])) ? 'checked' : null; ?> /> Capture IP/Geodata during user login
                    </div>
                    <div class="mb-10" style="margin-bottom: 20px;">
                        <input type="checkbox" name="input-users-tbl-geoip-data-column" id="input-users-tbl-geoip-data-column" value="1" <?php echo (!empty($settings['users_tbl_geoip_data_column'])) ? 'checked' : null; ?> /> Display IP/Geodata column in users table
                    </div>
                    <div class="mb-10" style="">
                        <label style="margin-bottom:5px;display:block;">Select preferred IP/Geodata API:</label>
                        <select class="SlectBox" name="input-ip-api" id="input-ip-api">
                            <option <?php echo (empty($settings['ip_api']) || (!empty($settings['ip_api']) && $settings['ip_api'] == 'ip-api.com')) ? 'selected="selected"' : null; ?> value="ip-api.com">ip-api.com</option>
                            <option <?php echo (!empty($settings['ip_api']) && $settings['ip_api'] == 'w3-ip.com') ? 'selected="selected"' : null; ?> value="w3-ip.com">Default</option>
                        </select>
                    </div>
                    <div class="mb-10" style="">
                        <label style="margin-bottom:5px;display:block;">Select API Request Method:</label>
                        <select class="SlectBox" name="input-ip-api-request-method" id="input-ip-api-request-method">
                            <option <?php echo empty($settings['ip_api_request_method']) ? 'selected="selected"' : null; ?> value="">auto-detect</option>
                            <option <?php echo (!empty($settings['ip_api_request_method']) && $settings['ip_api_request_method'] == 'file_get_contents') ? 'selected="selected"' : null; ?> value="file_get_contents">file_get_contents</option>
                            <option <?php echo (!empty($settings['ip_api_request_method']) && $settings['ip_api_request_method'] == 'curl') ? 'selected="selected"' : null; ?> value="curl">curl</option>
                        </select>
                    </div>
                    <div class="mb-10" style="">
                        <label style="margin-bottom:5px;display:block;">Select IP Resolution Method:</label>
                        <select class="SlectBox" name="input-ip-resolution-method" id="input-ip-resolution-method">
                            <option <?php echo empty($settings['ip_resolution_method']) ? 'selected="selected"' : null; ?> value="">auto-detect</option>
                            <option <?php echo (!empty($settings['ip_resolution_method']) && $settings['ip_resolution_method'] == 'ipify_api') ? 'selected="selected"' : null; ?> value="ipify_api">ipify API</option>
                        </select>
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/ip-geodata/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>


                <div id="w3dev-device-detection-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-laptop" aria-hidden="true"></i> Device Detection Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-device-detection-disabled" value="1" <?php echo !empty($settings['device_detection']['disabled']) ? 'checked' : null; ?> /> Disable device detection
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/device-detection/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>
                </div>

                <div id="w3dev-events-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-calendar-o" aria-hidden="true"></i> Event Logging Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-logging-denied-logins" value="1" <?php echo !empty($settings['logging']['denied_logins']) ? 'checked' : null; ?> /> Record denied logins
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-logging-successful-logins" value="1" <?php echo !empty($settings['logging']['successful_logins']) ? 'checked' : null; ?> /> Record successful logins 
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-logging-banned-users" value="1" <?php echo !empty($settings['logging']['banned_users']) ? 'checked' : null; ?> /> Record banned users 
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-logging-user-warnings" value="1" <?php echo !empty($settings['logging']['user_warnings']) ? 'checked' : null; ?> /> Record user warnings 
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-logging-denied-registrations" value="1" <?php echo !empty($settings['logging']['denied_registrations']) ? 'checked' : null; ?> /> Record denied registrations 
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-logging-spam-preventations" value="1" <?php echo !empty($settings['logging']['spam_preventations']) ? 'checked' : null; ?> /> Record spam preventions 
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/event-logging/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-restrict-login-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-clock-o" aria-hidden="true"></i> Restrict Login Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <?php
                    $timezone = (date_default_timezone_get()) ? 'The default date timezone is set to: <strong>' . date_default_timezone_get() . '</strong>. ' : null;
                    $timezone .= 'The current server time is: <strong><span class="js-current-time">'.date('d-m-Y H:i:s').'</span></strong>';
                    ?>
                    <p class="advisory">The times entered into the fields below will be applied based on the server's time and timezone not the time of the visitors local time. <?php echo $timezone; ?></p>
                        <h4>Restrict Administrator Logins</h4>
                        <ul class="ristrict-hours">
                            
                            <li class="datepair"><input name="input-restrict-admin-login-mon" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['mon']['enabled']) ? 'checked' : null; ?> /><span class="day">Monday</span><input name="input-admin-login-mon-start" placeholder="i.e. 08:00" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['mon']['start']) ? $settings['restrict']['admin']['mon']['start'] : null; ?>" /> to <input name="input-admin-login-mon-end" placeholder="i.e. 18:00pm" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['mon']['end']) ? $settings['restrict']['admin']['mon']['end'] : null; ?>" /></li>
                            
                            <li class="datepair"><input name="input-restrict-admin-login-tue" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['tue']['enabled']) ? 'checked' : null; ?> /><span class="day">Tuesday</span><input name="input-admin-login-tue-start" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['tue']['start']) ? $settings['restrict']['admin']['tue']['start'] : null; ?>" /> to <input name="input-admin-login-tue-end" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['tue']['end']) ? $settings['restrict']['admin']['tue']['end'] : null; ?>" /></li>
                            
                            <li class="datepair"><input name="input-restrict-admin-login-wed" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['wed']['enabled']) ? 'checked' : null; ?> /><span class="day">Wednesday</span><input name="input-admin-login-wed-start" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['wed']['start']) ? $settings['restrict']['admin']['wed']['start'] : null; ?>" /> to <input name="input-admin-login-wed-end" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['wed']['end']) ? $settings['restrict']['admin']['wed']['end'] : null; ?>" /></li>
                            
                            <li class="datepair"><input name="input-restrict-admin-login-thu" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['thu']['enabled']) ? 'checked' : null; ?> /><span class="day">Thursday</span><input name="input-admin-login-thu-start" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['thu']['start']) ? $settings['restrict']['admin']['thu']['start'] : null; ?>" /> to <input name="input-admin-login-thu-end" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['thu']['end']) ? $settings['restrict']['admin']['thu']['end'] : null; ?>" /></li>
                            
                            <li class="datepair"><input name="input-restrict-admin-login-fri" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['fri']['enabled']) ? 'checked' : null; ?> /><span class="day">Friday</span><input name="input-admin-login-fri-start" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['fri']['start']) ? $settings['restrict']['admin']['fri']['start'] : null; ?>" /> to <input name="input-admin-login-fri-end" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['fri']['end']) ? $settings['restrict']['admin']['fri']['end'] : null; ?>" /></li>
                            
                            <li class="datepair"><input name="input-restrict-admin-login-sat" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['sat']['enabled']) ? 'checked' : null; ?> /><span class="day">Saturday</span><input name="input-admin-login-sat-start" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['sat']['start']) ? $settings['restrict']['admin']['sat']['start'] : null; ?>" /> to <input name="input-admin-login-sat-end" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['sat']['end']) ? $settings['restrict']['admin']['sat']['end'] : null; ?>" /></li>
                            
                            <li class="datepair"><input name="input-restrict-admin-login-sun" type="checkbox" value="1" <?php echo !empty($settings['restrict']['admin']['sun']['enabled']) ? 'checked' : null; ?> /><span class="day">Sunday</span><input name="input-admin-login-sun-start" class="timepicker time start" type="text" value="<?php echo !empty($settings['restrict']['admin']['sun']['start']) ? $settings['restrict']['admin']['sun']['start'] : null; ?>" /> to <input name="input-admin-login-sun-end" class="timepicker time end" type="text" value="<?php echo !empty($settings['restrict']['admin']['sun']['end']) ? $settings['restrict']['admin']['sun']['end'] : null; ?>" /></li>

                        </ul>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/restrict-logins/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                    <style type="text/css">
                        ul.ristrict-hours,
                        ul.ristrict-hours li {
                            margin: 0;
                            padding: 0;
                        }
                        .ristrict-hours span.day { display: inline-block; width: 100px; margin-right: 10px; }
                        .ristrict-hours input.jmask-hhmm { width: 50px; }
                        .ristrict-hours input[type=checkbox] { margin-right: 10px; }

                        #w3dev-restrict-login-section h4 {
                            display: inline-block; 
                            border-bottom:1px solid #ccc;
                            padding-bottom: 5px;
                            margin-top: 0;
                        }

                    </style>

                </div>


                <div id="w3dev-notification-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-flag" aria-hidden="true"></i> Notification Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div id="js-send-notification-new-post" class="mb-10">
                        <input type="checkbox" name="input-send-notification-new-post" id="input-send-notification-new-post" value="1" <?php echo (!empty($settings['send_notification_new_post'])) ? 'checked' : null; ?> /> Send admin(s) an email notification when user publishes first post.
                    </div>
                    <div id="js-notification-email-addresses" class="mb-10">
                        <p style="margin:0;padding:0 0 10px 0;">Email addresss(es) to receive notification when user publishes first post:</p>
                        <select name="input-notification-emails" id="input-notification-emails" style="width:100%;" class="select2-email-tags" multiple="">
                            <?php 
                            if (!empty($settings['notification_emails'])) { 
                                $notification_emails = explode(',', $settings['notification_emails']);
                                foreach($notification_emails as $notification_email) { ?>
                                    <option value="<?php echo $notification_email; ?>" selected="selected"><?php echo $notification_email; ?></option>
                            <?php }} ?>
                        </select>

                        <!--
                        <textarea style="width: 350px;height: 60px;" name="input-notification-emails" id="input-notification-emails" placeholder="Comma seperated list of email addresses"><?php echo !empty($settings['notification_emails']) ? $settings['notification_emails'] : null; ?></textarea>-->

                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/notifications/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-users-table-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-table" aria-hidden="true"></i> Users Table Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-users-tbl-data-column" id="input-users-tbl-data-column" value="1" <?php echo (!empty($settings['users_tbl_data_column'])) ? 'checked' : null; ?> /> Display banned column in users table showing login status
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-users-tbl-row-highlighted" id="input-users-tbl-row-highlighted" value="1" <?php echo (!empty($settings['users_tbl_row_highlighted'])) ? 'checked' : null; ?> /> Highlight banned users in users table using red background colour
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-users-tbl-last-seen" id="input-users-tbl-last-seen" value="1" <?php echo (!empty($settings['users_tbl_last_seen'])) ? 'checked' : null; ?> /> Display date user last seen
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/users-table/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-warn-options-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-exclamation-triangle" aria-hidden="true"></i> Warn Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div id="js-warn-user" class="mb-10">
                        <input type="checkbox" name="input-warn-user" id="input-warn-user" value="1" <?php echo (!empty($settings['warn_user'])) ? 'checked' : null; ?> /> Enable warn user feature
                    </div>
                    <div id="js-warn-user-reason" style="margin-bottom: 10px; <?php echo (!empty($settings['warn_user'])) ? null : 'display:none;'; ?>">
                        <input type="checkbox" name="input-warn-user-reason" id="input-warn-user-reason" value="1" <?php echo (!empty($settings['warn_user_reason'])) ? 'checked' : null; ?> /> Include option for custom message in email when warning a user
                    </div> 
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/warn-users/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-security-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-shield" aria-hidden="true"></i> Security Settings <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <div class="mb-10">
                        <input type="checkbox" name="input-enable-admin-override" value="1" <?php echo (!empty($settings['security']['enable_admin_override'])) ? 'checked' : null; ?> /><?php _e("Always allow super admins/admins to perform ban/unban tasks regardless of any restrictions enabled below", 'ban-users'); ?>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-set-moderator-roles" value="1" <?php echo !empty($settings['security']['set_moderator_roles']) ? 'checked' : null;  echo '/>'; _e('Only allow users in the following roles to moderate other user accounts', 'ban-users'); ?>
                    </div>
                    <div class="mb-10" style="padding-left: 30px;">
                        <select class="SlectBox" multiple="multiple" name="input-security-moderator-roles">
                            <?php
                            $moderator_roles = !empty($settings['security']['moderator_roles']) ? $settings['security']['moderator_roles'] : array();
                            $roles = get_editable_roles();

                            if (!empty($roles)) {
                                foreach ($roles as $key => $value) {
                                    echo '<option '.(in_array($key, $moderator_roles)? 'selected' : null).' value="'.$key.'">'.ucfirst($key).'</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-set-moderated-roles" value="1" <?php echo (!empty($settings['security']['set_moderated_roles'])) ? 'checked' : null; ?> /><?php _e("Only allow the following roles to be moderated (i.e. can be banned)", 'ban-users'); ?>
                    </div>
                    <div style="margin-bottom:10px; padding-left: 30px;">
                        <select class="SlectBox" multiple="multiple" name="input-security-moderated-roles">
                            <?php
                            $moderated_role = !empty($settings['security']['moderated_roles']) ? $settings['security']['moderated_roles'] : array();
                            $roles = get_editable_roles();

                            if (!empty($roles)) {
                                foreach ($roles as $key => $value) {
                                    echo '<option '.(in_array($key, $moderated_role) ? 'selected' : null).' value="'.$key.'">'.ucfirst($key).'</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">ACCOUNT SECURITY</h4>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-auto-notify-new-ip" value="1" <?php echo !empty($settings['security']['auto_notify_new_ip']) ? 'checked' : null; ?> /> Enable automated notifications for successful user logins when accessed from a new IP Address
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-auto-notify-admin-login" value="1" <?php echo !empty($settings['security']['auto_notify_admin_login']) ? 'checked' : null; ?> /> Enable automated notifications for administrator logins
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-disable-non-admin-logins" value="1" <?php echo !empty($settings['security']['disable_non_admin_logins']) ? 'checked' : null; ?> /> Disable non-admin account logins <span style="font-style:italic;">(warning this will prevent anyone other than an admin from logging in)</span>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-disable-registrations" value="1" <?php echo !empty($settings['security']['disable_registrations']) ? 'checked' : null; ?> /> Disable new registrations
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-disable-comments" value="1" <?php echo !empty($settings['security']['disable_comments']) ? 'checked' : null; ?> /> Disable comments
                    </div>
                    <div class="mb-10">
                        <input type="checkbox"  id="input-security-hide-wp-login-messages" name="input-security-hide-wp-login-messages" value="1" <?php echo !empty($settings['security']['hide_wp_login_messages']) ? 'checked' : null; ?> /> Hide WordPress login error messages
                    </div>
                    <div class="mb-10" style="padding-left:30px;" id="js-security-ambiguous-error-messages" style="<?php echo !empty($settings['security']['hide_wp_login_messages']) ? null : 'display:none' ?>" >
                        <label style="margin-bottom:5px;display:block;">Generic login error message (Optional):</label>
                        <input class="form-control" type="text" name="input-security-ambiguous-error-messages" value="<?php echo !empty($settings['security']['ambiguous_error_messages']) ? $settings['security']['ambiguous_error_messages'] : ""; ?>" placeholder="i.e. Login failed, please try again" /> 
                   </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">SPAM PREVENTION</h4>
                    </div>

                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-reg-no-useragent" value="1" <?php echo !empty($settings['security']['deny_reg_no_useragent']) ? 'checked' : null; ?> /> Deny user registration if user agent can't be determined
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-reg-no-ipaddress" value="1" <?php echo !empty($settings['security']['deny_reg_no_ipaddress']) ? 'checked' : null; ?> /> Deny user registration if IP Address can't be determined
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-login-no-useragent" value="1" <?php echo !empty($settings['security']['deny_login_no_useragent']) ? 'checked' : null; ?> /> Deny login if user agent can't be determined
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-login-no-ipaddress" value="1" <?php echo !empty($settings['security']['deny_login_no_ipaddress']) ? 'checked' : null; ?> /> Deny login if IP Address can't be determined
                    </div>

                    <div style="display:none;border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">BOT MANAGEMENT</h4>
                    </div>
                    <div class="mb-10" style="display:none;">
                        <input type="checkbox" name="input-security-block-bad-bot" id="input-security-block-bad-bot" value="1" <?php echo !empty($settings['security']['block_bad_bot']) ? 'checked' : null; ?> /> Block Bad Bots
                    </div>
                    <div id="js-redirect-bad-bot" style="margin-bottom:10px; <?php echo (!empty($settings['security']['block_bad_bot'])) ? null : 'display:none' ?>">
                        <input class="form-control" type="text" name="input-security-redirect-bad-bot" id="input-security-redirect-bad-bot" value="<?php echo !empty($settings['security']['redirect_bad_bot']) ? esc_url(stripslashes($settings['security']['redirect_bad_bot'])) : null; ?>" placeholder="Redirect Bad Bots to this URL or leave blank to show default message" /> <span class="help-block" style="color:#999">(i.e. http://w3detect.com/im-a-bad-bot )</span>
                    </div>
                    <!--
                    <div class="mb-10">
                        <input type="checkbox" name="" value="1" /> Deny user registration if known BOT
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name=" value="1" /> Deny login if known BOT
                    </div>
                    -->
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/security/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-banned-keywords-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-file-text-o" aria-hidden="true"></i> Banned Keywords / Phrases <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>

                        <p class="advisory">With the introduction of banned keywords, you are now able to moderate users' posted content. The following settings allow you to automatically check the content posted by users, checking for keywords and phrases that you deem inappropriate for your target audience. This feature may trigger some false positives so we recommend you use this feature carefully and set a minimum of 3 occurances. To minimuse false positives we only search for whole word matches, not partials.</p>

                        <div class="mb-10">
                            <input type="checkbox" name="input-banned-content-title" id="input-banned-content-title" value="1" <?php echo !empty($w3dev_banned_word_options['banned_content_title']) ? 'checked' : null; ?> /> Check post title for banned keywords<br />
                        </div>
                        <div class="mb-10">
                            <input type="checkbox" name="input-banned-content" id="input-banned-content" value="1" <?php echo !empty($w3dev_banned_word_options['banned_content']) ? 'checked' : null; ?> /> Check post content for banned keywords<br />
                        </div>

                        <div id="js-banned-content-email" style="display:none;margin-bottom: 10px;">
                            <input type="checkbox" name="input-banned-content-email" id="input-banned-content-email" value="1" <?php echo !empty($w3dev_banned_word_options['banned_content_email']) ? 'checked' : null; ?> /> Send email notification to user warning them about banned content<br />
                        </div>
                        <div id="js-banned-content-occurances" style="margin-bottom: 10px;">
                            <input type="number" style="width:148px;" name="input-banned-content-occurances" id="input-banned-content-occurances" value="<?php echo !empty($w3dev_banned_word_options['banned_content_occurances']) ? $w3dev_banned_word_options['banned_content_occurances'] : "1" ?>" min="1" step="1" /> Minimum number of matched keywords/phrases found in post before banned (increase number to reduce false positives).<br />
                        </div>

                        <div id="js-banned-content-level" style="margin-bottom: 10px;">
                            Roles exempt from being checked <br />
                            <select name="input-banned-content-level" id="input-banned-content-level" style="width:100%;" class="select2-user-roles SlectBox" multiple="multiple">
                                <?php 
                                    $roles = $wp_roles->get_names();
                                    $w3dev_exempt_roles = !empty($w3dev_banned_word_options['banned_content_level']) ? $w3dev_banned_word_options['banned_content_level'] : array();

                                    foreach($roles as $role_id => $role_name) { ?>
                                        <option value="<?php echo $role_id; ?>" 
                                        <?php echo !empty(in_array($role_id, $w3dev_exempt_roles)) ? 'selected="selected"' : null; ?>><?php echo $role_name; ?></option>
                                    <?php } ?>
                             </select>
                        </div>

                        <div id="js-banned-content-level" style="margin-bottom: 10px;">
                            Select post type(s) <br />
                            <select name="input-banned-post-types" style="width:100%;" class="select2-user-roles SlectBox" multiple="multiple">
                            <?php
                            
                            $w3dev_post_types = !empty($w3dev_banned_word_options['banned_post_types']) ? explode('|', $w3dev_banned_word_options['banned_post_types']) : array();

                            foreach ( get_post_types( '', 'names' ) as $key => $post_type ) {
                               echo '<option value="' . $key . '" ' . ( !empty( in_array( $key, $w3dev_post_types ) ) ? 'selected="selected"' : null) . '>' . $post_type . '</option>';
                            }
                            ?>
                             </select>
                        </div>

                        <div id="js-banned-words-and-phrases" style="margin-bottom: 10px">
                            List of Banned words and Phrases <br />
                            <select name="input-banned-words-and-phrases" id="input-banned-words-and-phrases" style="width:100%;" class="select2-phrases-tags" multiple="">
                                <?php 
                                if (!empty($w3dev_banned_word_options['banned_words_and_phrases'])) { 
                                    $banned_words_and_phrases = explode('|', $w3dev_banned_word_options['banned_words_and_phrases']);
                                    foreach($banned_words_and_phrases as $banned_words_and_phrases ) { ?>
                                        <option value="<?php echo $banned_words_and_phrases; ?>" selected="selected"><?php echo $banned_words_and_phrases; ?></option>
                                <?php }} ?>
                        </select>
                        </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/banned-words/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>
                </div>

               <div id="w3dev-banned-usernames-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-user-circle-o" aria-hidden="true"></i> Banned Usernames <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                        <div id="js-banned-words-and-phrases" style="margin-bottom: 10px">
                            <p>List of Banned Usernames</p>
                            <select name="input-banned-usernames" id="input-banned-usernames" style="width:100%;" class="select2-phrases-tags" multiple="">
                                <?php 
                                if (!empty($w3dev_banned_username_options['banned_usernames'])) { 
                                    $banned_usernames = explode('|', $w3dev_banned_username_options['banned_usernames']);
                                    foreach($banned_usernames as $banned_username ) { ?>
                                        <option value="<?php echo $banned_username; ?>" selected="selected"><?php echo $banned_username; ?></option>
                                <?php }} ?>
                        </select>
                        </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>
                </div>


               <div style="display:none;" id="w3dev-banned-passwords-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-unlock-alt" aria-hidden="true"></i> Banned Passwords <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                        <div id="js-banned-words-and-phrases" style="margin-bottom: 10px">
                            <p>List of Banned Passwords</p>
                            <select name="input-banned-passwords" id="input-banned-passwords" style="width:100%;" class="select2-phrases-tags" multiple="">
                                <?php 
                                if (!empty($w3dev_banned_password_options['banned_passwords'])) { 
                                    $banned_passwords = explode('|', $w3dev_banned_password_options['banned_passwords']);
                                    foreach($banned_passwords as $banned_password ) { ?>
                                        <option value="<?php echo $banned_password; ?>" selected="selected"><?php echo $banned_password; ?></option>
                                <?php }} ?>
                        </select>
                        </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>
                </div>

                <div id="w3dev-3rdparty-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-plug" aria-hidden="true"></i> 3rd Party Plugin Support <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <p>There are a number of awesome plugins available which extend the membership capabilities of WordPress. If you use any of the following plugins please tick the checkboxes below to enable support for them.</p>

                    <div class="mb-10">
                        <input type="checkbox" name="input-ext-ultimate-member" id="input-ext-ultimate-member" value="1" <?php echo (!empty($settings['extensions']['ultimate_member'])) ? 'checked' : null; ?> /> Ultimate Member Plugin
                    </div>
                    <div class="mb-10">
                        <input disabled type="checkbox" name="input-ext-ultimate-member" id="input-ext-buddypress" value="1" /> BuddyPress Plugin (Coming Soon)
                    </div>
                    <div class="mb-10">
                        <input disabled type="checkbox" name="input-ext-s2member" id="input-ext-s2member" value="1" /> s2member Plugin (Coming Soon)
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="w3dev-css-scripts-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i> CSS / Scripts <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <p>Use the following text editors below to insert css and/or javascript into the header and footer of your website.</p>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <p style="padding-bottom: 0;margin-bottom: 0"><input <?php echo !empty($inc_header_css) ? 'checked' : null; ?> type="checkbox" name="input-include-header-css" id="input-include-header-css" value="1" /> <strong>Include Header CSS</strong></p>
                        <p style="padding-top: 5px;margin-top: 0">CSS entered below will be wrapped in &#60;style&#62; &#60;/style&#62; Tag and inserted into Head of document</p>
                    </div>
                    <div class="mb-10">
                        <pre id="editor-css"></pre>
                    </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <p style="padding-bottom: 0;margin-bottom: 0"><input <?php echo !empty($inc_footer_js) ? 'checked' : null; ?> type="checkbox" name="input-include-footer-js" id="input-include-footer-js" value="1" /> <strong>Include Footer JS</strong></p>
                        <p style="padding-top: 5px;margin-top: 0">JS entered below will be wrapped in &#60;script&#62; &#60;&#47;script&#62;<span> Tag and inserted into Foot of document</p>
                    </div>
                    <div class="mb-10">
                        <pre id="editor-js"></pre>
                    </div>

<style type="text/css" media="screen">
    #editor-css,#editor-js { 
        display: block;
        height: 200px;
    }
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.2.6/ace.js" integrity="sha256-xrr4HH5eSY+cFz4SH7ja/LaAi9qcEdjMpeMP49/iOLs=" crossorigin="anonymous"></script>
<script>
    var editor_css = ace.edit("editor-css");
    editor_css.setTheme("ace/theme/monokai");
    editor_css.getSession().setMode("ace/mode/css");
    <?php 
    $sample = "#some_example_css {
    color: #fff;
}";
    $html = !empty($w3dev_ban_css_scipts_options['editor_css']) ? $w3dev_ban_css_scipts_options['editor_css'] : $sample; 
    ?>
    editor_css.setValue(`<?php echo $html; ?>`);

    var editor_js = ace.edit("editor-js");
    editor_js.setTheme("ace/theme/monokai");
    editor_js.getSession().setMode("ace/mode/javascript");
    <?php 
    $sample = "(function($) {
    
    // some example jquery
    
})( jQuery );";
    $html = !empty($w3dev_ban_css_scipts_options['editor_js']) ? $w3dev_ban_css_scipts_options['editor_js'] : $sample; 
    ?>
    editor_js.setValue(`<?php echo $html; ?>`);
</script>

                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/css-and-scripts/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>
                </div>


               <div id="w3dev-shortcodes-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-wordpress" aria-hidden="true"></i> Plugin Shortcodes<a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>

                        <p class="advisory"><strong>Please note: These shortcodes are included for developers.</strong><br />They are provided to developers to help them integrate the features of this plugin into their own bespoke solution. They are not required for typical use of this plugin.</p>
                        <style>
                            .advisory {
                                background-color: #fcf8e3;
                                padding: 15px;
                                border-left: 4px solid #8a6d3b;
                                margin-bottom: 25px;
                            }
                        </style>

                    <div class="mb-10">
                        <code>[w3dev-is-user-banned user_id="0"]</code> <?php _e('Check if user is banned (by user id); if banned shortcode will output message', 'ban-users'); ?>
                        <?php //do_shortcode( '[w3dev-is-user-banned user_id="7"]' ); ?>
                    </div>
                    <div class="mb-10">
                        <code>[w3dev-is-user-banned email="me@myaddress.com"]</code> <?php _e('Check if user is banned (by email address); if banned shortcode will output message', 'ban-users'); ?>
                        <?php //do_shortcode( '[w3dev-is-user-banned user_id="7"]' ); ?>
                    </div>
                    <div class="mb-10">
                        <code>[w3dev-is-user-banned username="myusername"]</code> <?php _e('Check if user is banned (by username); if banned shortcode will output message', 'ban-users'); ?>
                        <?php //do_shortcode( '[w3dev-is-user-banned user_id="7"]' ); ?>
                    </div>
                    <div class="mb-10">
                        <code>[w3dev-get-user-ip user_id="0"]</code> Get user's last known ip address;
                        <?php //do_shortcode( '[w3dev-get-user-ip user_id="7"]' ); ?>
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>


                <div id="w3dev-conflict-section" class="w3dev-settings-section with-help <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                    <h3><i class="w3dev-icon fa fa-2x fa-bug" aria-hidden="true"></i> Conflict Management <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                    <p class="advisory">If you want to manually load any of the libraries required by this plugin then simply check the correspnding tick box(es) below to disable them from autoloading. But remember, the plugin won't function correctly if these libraries aren't all available. So I recommend you keep all tick boxes below unchecked unless you know what you are doing.</p>

                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-fa" id="input-autoload-fa" value="1" <?php echo (!empty($settings['disable_autoload']['fa'])) ? 'checked' : null; ?> /> Disable js/css autoload Font Awesome (ver 4.7.0)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-jq-confirm" id="input-autoload-jq-confirm" value="1" <?php echo (!empty($settings['disable_autoload']['jq_confirm'])) ? 'checked' : null; ?> /> Disable js/css autoload jQuery Confirm (ver 3.3.2)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-datatables" id="input-autoload-datatables" value="1" <?php echo (!empty($settings['disable_autoload']['datatables'])) ? 'checked' : null; ?> /> Disable js/css autoload DataTables (ver 1.10.19) <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span>
                    </div> 
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-notify" id="input-autoload-notify" value="1" <?php echo (!empty($settings['disable_autoload']['notify'])) ? 'checked' : null; ?> /> Disable js/css autoload Notify (ver 0.4.2)
                    </div> 
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-selectric" id="input-autoload-selectric" value="1" <?php echo (!empty($settings['disable_autoload']['selectric'])) ? 'checked' : null; ?> /> Disable js/css autoload Selectric (ver 1.11.0)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-flatpickr" id="input-autoload-flatpickr" value="1" <?php echo (!empty($settings['disable_autoload']['flatpickr'])) ? 'checked' : null; ?> /> Disable js/css autoload Flatpickr (ver 2.1.1)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-alertify" id="input-autoload-alertify" value="1" <?php echo (!empty($settings['disable_autoload']['alertify'])) ? 'checked' : null; ?> /> Disable js/css autoload Alertify (ver 1.8.0)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-select2" id="input-autoload-select2" value="1" <?php echo (!empty($settings['disable_autoload']['select2'])) ? 'checked' : null; ?> /> Disable js/css autoload Select2 (ver 4.0.5) <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-faanimation" id="input-autoload-faanimation" value="1" <?php echo (!empty($settings['disable_autoload']['faanimation'])) ? 'checked' : null; ?> /> Disable js/css autoload Font Awesome Animation (ver 0.0.10)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-momentjs" id="input-autoload-momentjs" value="1" <?php echo (!empty($settings['disable_autoload']['momentjs'])) ? 'checked' : null; ?> /> Disable js/css autoload MomentJS (ver 2.23.0) <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-chartjs" id="input-autoload-chartjs" value="1" <?php echo (!empty($settings['disable_autoload']['chartjs'])) ? 'checked' : null; ?> /> Disable js/css autoload Chart JS (ver 2.7.3) <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span>
                    </div>
                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">DEBUGGING</h4>
                    </div>

                    <div class="mb-10">
                        <input type="checkbox" name="input-debug-php" id="input-debug-php" value="1" <?php echo (!empty($settings['debug']['php'])) ? 'checked' : null; ?> /> Enable debug (PHP: display_errors, display_startup_errors, error_reporting)
                    </div>
                    <div class="w3dev-footer"><a href="http://banusers.wpress-plugins.com/features/conflict-management/" target="_blank" style="text-decoration: none;"><i class="fa fa-info-circle" aria-hidden="true"></i> Help?</a><a class="w3dev-back-to-top" href="body"><i class="fa fa-chevron-circle-up" aria-hidden="true"></i> Back to Top</a></div>
                    </div>

                </div>

                <div id="form-actions" style="margin-bottom: 10px;">
                    <a id="w3dev-save-ban-user-settings" class="btn btn-success" href="javascript:void(0)">Save Options</a>
                </div>
            </form>

            <style>
                .w3dev-settings-section { border:1px solid #ddd; padding: 20px; padding-top: 0; padding-bottom: 30px; margin-bottom: 20px; }
                .w3dev-settings-section h3 { 
                    margin-left: -20px;margin-right: -20px;padding: 20px!important;border-bottom: 1px solid #ddd;
                    background-color: #f9f9f9; margin-bottom: 20px;
                }
                .w3dev-settings-section h3 i.w3dev-icon { 
                    color:#8a6d3b;float:left;position:relative;top:-9px;margin-right: 10px; width: 40px;text-align: center
                }
                .mb-10 { margin-bottom: 10px; }
                .mb-20 { margin-bottom: 20px; }
            </style>

        </div>
        <div class="w3dev-tab hidden" id="tab-email-template">

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                <h3><i class="w3dev-icon fa fa-2x fa-cog" aria-hidden="true"></i> Email Options: <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <form>
                    <div id="js-banned-login-message" style="margin-bottom: 30px;">
                        <label style="margin-bottom:10px;display:block;">Default message to show if user banned indefinitely and %%unban_date%% tag included in 'BAN User email template':</label>
                        <input class="form-control" type="text" name="input-unban-indefinite-date-tag" id="input-unban-indefinite-date-tag" value="<?php echo $unban_indefinite_date_tag; ?>" />
                    </div>
                </form>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i> BAN User email template: <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>
                
                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <p>If user email notification is enabled, then this email template will be used when notifying users that they have been banned.</p>

<style>
    .tpl-tags {
        color: #ce4844;
        border: 2px solid #ddd;padding: 5px 12px;
        border-radius: 24px;
        margin-bottom: 10px;
        display: inline-block;
        margin-left: 0px;
        margin-right: 5px;
    }
</style>

                 <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-ban-user-subject-title" name="input-ban-user-subject-title" size="30" value="<?php echo $ban_subject_title ?>"/>
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Cc:', 'ban-users'); ?></label>
                    <select name="input-ban-user-cc-field" id="input-ban-user-cc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($ban_cc_field)) { 
                            $ban_user_cc = explode(',', $ban_cc_field);
                            foreach($ban_user_cc as $ban_user_cc) { ?>
                                 <option value="<?php echo $ban_user_cc; ?>" selected="selected"><?php echo $ban_user_cc; ?></option>
                        <?php }} ?>
                    </select>        
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Bcc:', 'ban-users'); ?></label>
                    <select name="input-ban-user-bcc-field" id="input-ban-user-bcc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($ban_bcc_field)) { 
                            $ban_user_bcc = explode(',', $ban_bcc_field);
                            foreach($ban_user_bcc as $ban_user_bcc) { ?>
                                 <option value="<?php echo $ban_user_bcc; ?>" selected="selected"><?php echo $ban_user_bcc; ?></option>
                        <?php }} ?>
                    </select>        

                <?php 
                wp_editor( $ban_body, 'ban_editor', array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    )); ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%reason%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%unban_date%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>'; 
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i><?php _e('UnBAN User email template:', 'ban-users'); ?><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <p><?php _e('If user email notification is enabled, then this email template will be used when notifying users that they have been unbanned.', 'ban-users'); ?></p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-unban-user-subject-title" name="input-unban-user-subject-title" size="30" value="<?php echo $unban_subject_title ?>"/>
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Cc:', 'ban-users'); ?></label>
                    <select name="input-unban-user-cc-field" id="input-unban-user-cc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($unban_cc_field)) { 
                            $unban_user_cc = explode(',', $unban_cc_field);
                            foreach($unban_user_cc as $unban_user_cc) { ?>
                                 <option value="<?php echo $unban_user_cc; ?>" selected="selected"><?php echo $unban_user_cc; ?></option>
                        <?php }} ?>
                    </select>     
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Bcc:', 'ban-users'); ?></label>
                    <select name="input-unban-user-bcc-field" id="input-unban-user-bcc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($unban_bcc_field)) { 
                            $unban_user_bcc = explode(',', $unban_bcc_field);
                            foreach($unban_user_bcc as $unban_user_bcc) { ?>
                                 <option value="<?php echo $unban_user_bcc; ?>" selected="selected"><?php echo $unban_user_bcc; ?></option>
                        <?php }} ?>
                    </select>     
                </p>

                <?php   
                wp_editor( $unban_body, 'unban_editor', array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    ));
                ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>'; 
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i><?php _e('Warn User email template:', 'ban-users'); ?><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <p><?php _e('This template will be used when sending a warning to users for a possible future ban.', 'ban-users'); ?></p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-warn-user-subject-title" name="input-warn-user-subject-title" size="30" value="<?php echo $warn_subject_title; ?>"/>
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Cc:', 'ban-users'); ?></label>
                    <select name="input-warn-user-cc-field" id="input-warn-user-cc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($warn_cc_field)) { 
                            $warn_user_cc = explode(',', $warn_cc_field);
                            foreach($warn_user_cc as $warn_user_cc) { ?>
                                 <option value="<?php echo $warn_user_cc; ?>" selected="selected"><?php echo $warn_user_cc; ?></option>
                        <?php }} ?>
                    </select>  
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Bcc:', 'ban-users'); ?></label>
                    <select name="input-warn-user-bcc-field" id="input-warn-user-bcc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($warn_bcc_field)) { 
                            $warn_user_bcc = explode(',', $warn_bcc_field);
                            foreach($warn_user_bcc as $warn_user_bcc) { ?>
                                 <option value="<?php echo $warn_user_bcc; ?>" selected="selected"><?php echo $warn_user_bcc; ?></option>
                        <?php }} ?>
                    </select>     
                </p>

                <?php   
                wp_editor( $warn_body, 'warn_editor', array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    ));
                ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%reason%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>'; 
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i><?php _e('Admin Login email template:', 'ban-users'); ?><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <p><?php _e('Alert the site about admin login.', 'ban-users'); ?></p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-admin-login-subject-title" name="input-admin-login-subject-title" size="30" value="<?php echo $admin_login_subject_title; ?>"/>
                </p>

                <?php   
                wp_editor( $admin_login_body, 'admin_login_editor', array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    ));
                ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>';
                    //echo '<span class="tpl-tags" style="color:#ce4844"> %%ip_address%% </span>';
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <a id="w3dev-save-ban-email-template" class="btn btn-success" href="javascript:void(0)">Save Template</a>

        </div>

        <div class="w3dev-tab hidden" id="tab-registration-ban">

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                <h3><i class="w3dev-icon fa fa-2x fa-envelope-o" aria-hidden="true"></i> BAN Email Address <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <div class="input-group" style="margin-bottom: 10px;">
                    <input type="text" name="input-ban-email-address" id="input-ban-email-address" placeholder="e.g. example@ban.com" value="" />
                    <input class="btn btn-danger" type="submit" value="Add" name="btn-ban-email-address" id="btn-ban-email-address" />
                </div>

                <div style="margin-bottom: 20px;">
                <table id="w3dev-table-banned-emails" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th>Banned Email Address</th>
                    <th>Date Banned</th>
                    <th>Remove </th>
                </tr>
                </thead>
                
                <?php
                global $wpdb;
                $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                
                if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) { ?>

                    <div style="margin-bottom: 25px;"><p><span style="color:#d8534f"><strong>ERROR: The required WordPress Table '<?php echo $db_table_name; ?>' does not exist.</strong></span><br />
                    Please deactivate and reactive this plugin and ensure your Wordpress database user has sufficient rights to create tables.</p></div>
                
                <?php
                } else {

                    $banned_emails = $wpdb->get_results( "
                        SELECT * FROM $db_table_name
                        WHERE email_address IS NOT NULL OR
                        email_address != '' 
                        ORDER BY email_address ASC");

                } ?>

                <tbody>
                <?php
                if ( !empty($banned_emails) && is_array($banned_emails) )
                    foreach ($banned_emails as $banned_email)
                        echo '<tr id="row-'.$banned_email->id.'">
                                <td class="banned-email-address">'.$banned_email->email_address.'</td>
                                <td>'.date('d-m-Y', strtotime($banned_email->date_time)).'</td>
                                <td><a data-id="'.$banned_email->id.'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a></i>
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>
            
            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                <h3><i class="w3dev-icon fa fa-2x fa-map-marker" aria-hidden="true"></i> BAN IP Address <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <div class="input-group" style="margin-bottom: 10px;">
                    <input type="text" name="input-ban-ip-address" id="input-ban-ip-address" placeholder="e.g. 10.10.10.10" value="" />
                    <input class="btn btn-danger" type="submit" value="Add" name="btn-ban-ip-address" id="btn-ban-ip-address" data-current-ip-address="<?php echo $_SERVER['REMOTE_ADDR']; ?>" />
                </div>

                <div style="margin-bottom: 60px;">
                <table id="w3dev-table-banned-ip-addresses" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th>Banned IP Address</th>
                    <th>Date Banned</th>
                    <th>Remove </th>
                </tr>
                </thead>
                
                <?php
                $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                
                if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) { ?>

                    <div style="margin-bottom: 25px;"><p><span style="color:#d8534f"><strong>ERROR: The required WordPress Table '<?php echo $db_table_name; ?>' does not exist.</strong></span><br />
                    Please deactivate and reactive this plugin and ensure your Wordpress database user has sufficient rights to create tables.</p></div>
                
                <?php
                } else {

                    $banned_ips = $wpdb->get_results( "
                        SELECT * FROM $db_table_name
                        WHERE ip_address IS NOT NULL OR
                        ip_address != 0 
                        ORDER BY email_address ASC");

                } ?>

                <tbody>
                <?php
                if ( !empty($banned_ips) && is_array($banned_ips) )
                    foreach ($banned_ips as $banned_ip)
                        echo '<tr id="row-'.$banned_ip->id.'">
                                <td>'.long2ip($banned_ip->ip_address).'</td>
                                <td>'.date('d-m-Y', strtotime($banned_ip->date_time)).'</td>
                                <td><a data-id="'.$banned_ip->id.'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a></i>
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>
                
            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section <?php echo (!empty($settings['close_panels'])) ? 'closed' : null; ?>">
                <h3><i class="w3dev-icon fa fa-2x fa-globe" aria-hidden="true"></i> BAN Country <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-<?php echo (!empty($settings['close_panels'])) ? 'up' : 'down'; ?>" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content" <?php echo (!empty($settings['close_panels'])) ? 'style="display:none;"' : null; ?>>
                <div class="input-group" style="margin-bottom: 10px;">
                    <input type="text" name="input-ban-countrycode" id="input-ban-countrycode" placeholder="e.g. GB" value="" />
                    <input class="btn btn-danger" type="submit" value="Add" name="btn-ban-countrycode" id="btn-ban-countrycode" />
                </div>

                <div style="margin-bottom: 60px;">
                <table id="w3dev-table-banned-countrycodes" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th>Banned Country Code</th>
                    <th>Date Banned</th>
                    <th>Remove </th>
                </tr>
                </thead>
                
                <?php
                $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                
                if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) { ?>

                    <div style="margin-bottom: 25px;"><p><span style="color:#d8534f"><strong>ERROR: The required WordPress Table '<?php echo $db_table_name; ?>' does not exist.</strong></span><br />
                    Please deactivate and reactive this plugin and ensure your Wordpress database user has sufficient rights to create tables.</p></div>
                
                <?php
                } else {

                    $banned_countrycodes = $wpdb->get_results( "
                        SELECT * FROM $db_table_name
                        WHERE geodata IS NOT NULL AND geodata LIKE 'countrycode:%'
                        ORDER BY geodata ASC");

                } ?>

                <tbody>
                <?php
                if ( !empty($banned_countrycodes) && is_array($banned_countrycodes) )
                    foreach ($banned_countrycodes as $banned_countrycode)
                        echo '<tr id="row-'.$banned_countrycode->id.'">
                                <td>'.str_ireplace('countrycode:', null, strtoupper($banned_countrycode->geodata)).'</td>
                                <td>'.date('d-m-Y', strtotime($banned_countrycode->date_time)).'</td>
                                <td><a data-id="'.$banned_countrycode->id.'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a></i>
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>
                
            </div>

            <style>
            table.dataTable {
                margin-bottom: 10px;
            }
            table.dataTable thead th, 
            table.dataTable thead td,
            table.dataTable tbody th, 
            table.dataTable tbody td {
                padding: 8px 0!important;
                text-align: left;
            }
            .dataTables_info { color: #aaa!important; }

            .w3dev-compact-table { border-collapse: collapse; }
            .w3dev-compact-table tr th,
            .w3dev-compact-table tr td {
                border-bottom: 1px solid #ccc;
            }
            .action-group { margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd; }
            .action-group.reversed { border-top: 0; margin-top:0; padding-top:0; margin-bottom: 30px; padding-bottom: 30px; border-bottom: 1px solid #ddd; }
            </style>

        </div>

        <?php if (!W3DEV_BAN_USERS_PREMIUM_VERSION) { ?>
            <div class="w3dev-tab hidden" id="tab-go-pro">

            <p><span class="text-primary " style="font-weight: bold; font-size: 1.4em;">The Ultimate BAN Users WordPress Plugin</span></p>

                <p><strong>The Ultimate BAN Users WordPress Plugin is the last plugin you�ll ever need for managing access to your WordPress site and removing users� content. Ban existing users, deny registrations based on banned ips/emails. Catpure IP/Geodata and much, much more�</strong>.</p>

                <p><a href="https://codecanyon.net/item/wp-ultimate-ban-users/17508338" target='_blank' rel="nofollow">Buy Premium Version</a></p>

                <p><span style="font-size:1.2em;font-weight:bold;text-decoration:underline">Ultimate BAN Users Features:</span></p>
                <ul>
                    <li>
                    <strong>Ban existing WordPress users</strong> from logging in</li>
                    <li>Ban users indefinately or until a specified date</li>
                    <li>
                    <strong>Deny visitors from registering</strong> based on email and/or ip address</li>
                    <li>Change the status of Ban users� posts (i.e. to draft)</li>
                    <li>Capture unqiue reason for banning users</li>
                    <li>Send <strong>custom email notifications</strong>
                    </li>
                    <li>Force banned users to logout, or redirect them</li>
                    <li>
                    <strong>Capture IP/Geodata</strong> during logins</li>
                    <li>Display IP/Geodata/banned details on users table</li>
                    <li>Easily manage banned users/ips/emails</li>
                    <li>Clearly <strong>highlight banned users</strong> in users table</li>
                    <li>Send notifications when users� publish first post</li>
                </ul>

            </div>
        <?php } ?>
    </div>

    <?php
}

add_action( 'edit_user_profile', 'w3dev_edit_user_profile' );
function w3dev_edit_user_profile( $user ) {

    if (!current_user_can( 'edit_users')) { return; }
    if (get_current_user_id() == $user->ID ) { return; } // Do not show on user's own edit screen
    
    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');

    $date = wp_next_scheduled('w3dev_unban_user', array( $user->ID ));  

    ?>
    <table class="form-table">
        <tr>
            <th scope="row">Ban User</th>
            <td>
            <label for="input-w3dev-ban-user">
                <input type="checkbox" name="input-w3dev-ban-user" id="input-w3dev-ban-user" <?php
                    checked( $w3dev_ban_user_class->is_user_banned( $user->ID ), TRUE )?> value="1">
                    Ban this user</label>
                <input name="w3dev-ban-reason" type="hidden" id="w3dev-ban-reason" value="">
                <input name="w3dev-ban-checked" type="hidden" id="w3dev-ban-checked" value="<?php echo (($settings['ban_email'] && $settings['ban_email_default']) ? "1" : "0") ?>"  />
            </td>
        </tr>
        <tr id="js-w3dev-unban-date" <?php if(!$w3dev_ban_user_class->is_user_banned( $user->ID )) echo 'style="display:none"'?> >
            <th scope="row">Unban Date</th>
            <td>
                <label for="input-w3dev-user-unban-date">
                    <input type="text" name="input-w3dev-user-unban-date" id="input-w3dev-user-unban-date" class="datepicker" data-date-format="<?php if (!empty($settings['date_format'])) echo $settings['date_format']; ?>" value="<?php echo ($date ? date($settings['date_format'], $date) : "Indefinent"); ?>" />
                </label>
            </td>
        </tr>
        <tr id="js-w3dev-hide-avatar" <?php if(!$w3dev_ban_user_class->is_user_banned($user->ID)) echo 'style="display:none"'?> >
            <th scope="row">Hide Avatar</th>
            <td>
                <label for="input-w3dev-user-hide-avatar">
                    <input type="checkbox" name="input-w3dev-user-hide-avatar" id="input-w3dev-user-hide-avatar" <?php
                        checked( $w3dev_ban_user_class->is_hide_avatar($user->ID), TRUE) ?> value="1">
                        Hide this user's avatar</label>
            </td>
        </tr>
    </table>
    <?php
}

add_action( 'edit_user_profile_update', 'w3dev_edit_user_profile_update' ); 
function w3dev_edit_user_profile_update( $user_id ) {

    if (!current_user_can( 'edit_users')) { return; }    // Is admin
    if (get_current_user_id() == $user_id ) { return; } // Do not show on user's own edit screen

    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    if (empty($_POST['input-w3dev-ban-user'])) {
        $w3dev_ban_user_class->unban_user(floatval($user_id)); // Unlock
    } else {
        $message = $_POST['w3dev-ban-reason'];
        $date = $_POST['input-w3dev-user-unban-date'];
        $hide_avatar = (!empty($_POST['input-w3dev-user-hide-avatar'])) ? 1 : 0;

        $w3dev_ban_user_class->ban_user(floatval($user_id), $message, $date, false, $hide_avatar);// Lock
    }
    
}
