<?php 

function w3dev_ban_confirm_country($country, $unban_date) {

	if (empty($unban_date)) {
		$unban_date = time() + (60 * 60 * 24 * 7);
    }
	
    global $wpdb;
    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $ip_address             = $w3dev_ban_user_class->get_ip_address();
    $geodata                = $w3dev_ban_user_class->get_geodata();

    $geodata = json_decode($geodata);
    if (empty($geodata))
        return 0;

    if( $country != $geodata->country && $country != $geodata->regionName )
        return 0;

    $w3dev_ban_user_class->ban_user($user_id, "entered a country differing from predicted country", $unban_date);

    ?>
    <script type="text/javascript">
    jQuery(function($){
            function ban_ip() {
                if (navigator.onLine) {
                    var data = {
                        'action': 'w3dev_save_banned_login',
                        'method': 'ip_address',
                        'value': '<?php echo $ip_address; ?>'
                    };
                    jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', data, function(response) { });
                }
            }
        });
        </script>
    <?php

    return 1;
}


function w3dev_ultimatemember_login_check( $args ){

	global $ultimatemember;

	if (!empty($ultimatemember)) {

		$user_id = ( isset( $ultimatemember->login->auth_id ) ) ? $ultimatemember->login->auth_id : '';

		include_once( W3DEV_BAN_USERS_PLUGIN_DIR_PATH. 'w3dev-ban-users-class.php' );
		$w3dev_ban_user_class 		= W3DEV_BAN_USER_CLASS::get_instance();
		$settings 					= $w3dev_ban_user_class->get_options('settings');
		$registration_ban_options   = $w3dev_ban_user_class->get_options('registration');
		$banned_login_message 		= !empty($settings['banned_login_message']) ? $settings['banned_login_message'] : $settings['_defaults']['banned_login_message'];
		$denied_login_message 		= !empty($settings['denied_login_message']) ? $settings['denied_login_message'] : $settings['_defaults']['denied_login_message'];
		$user_agent 				= $_SERVER['HTTP_USER_AGENT'];

		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		    $ip_address = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		    $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
		    $ip_address = $_SERVER['REMOTE_ADDR'];
		}

		// Return error if user agent and/or ip address can't be determined (where applicable)
		// --
	   	if (!empty($settings['security']['deny_login_no_useragent']) || 
	   		!empty($settings['security']['deny_login_no_ipaddress'])) {

	   		if (empty($ip_address) || empty($user_agent)) {
				$ultimatemember->form->errors[] = stripslashes($denied_login_message);
	   		}

	   	}

		if ($w3dev_ban_user_class->is_user_banned($user_id)) {
			if ( !empty($settings['display_message']) ) {
				$banned_login_message = $settings['banned_login_message'];
			} else {
				$banned_login_message = $settings['_defaults']['banned_login_message'];
			}
            $ultimatemember->form->errors[] = stripslashes($banned_login_message);
        }

	    // check if users email address has been banned
	    // --
	    global $wpdb;
	    $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
	    
	    if (!empty($registration_ban_options['enable_login_ban_by_email'])) {

	    	$users_data = get_userdata( $user_id ); 
	    	if (!empty($users_data->user_email)) {
			    $is_email_banned = $wpdb->get_results( $wpdb->prepare("
			        SELECT * FROM ". $wpdb->prefix ."w3dev_banned_logins
			        WHERE email_address = %s", $users_data->user_email)
			    );

			    if (!empty($is_email_banned)) { $ultimatemember->form->errors[] = stripslashes($banned_login_message); }
			}
		} 

		if (!empty($registration_ban_options['enable_login_ban_by_ip'])) {

		    // check if users ip address has been banned
		    // --
			if (!empty($ip_address)) {
			    $is_ip_banned = $wpdb->get_results( $wpdb->prepare("
			        SELECT * FROM ". $wpdb->prefix ."w3dev_banned_logins
			        WHERE ip_address = %d", ip2long($ip_address))
			    );

			    if (!empty($is_ip_banned)) { $ultimatemember->form->errors[] = stripslashes($banned_login_message); }
			}
		}

	}

}
add_filter( 'um_submit_form_errors_hook_logincheck', 'w3dev_ultimatemember_login_check' );

add_action( 'um_submit_form_errors_hook__registration', 'w3dev_ultimatemember_registration', 10, 1 );
function w3dev_ultimatemember_registration( $args ) {

	global $wpdb, $ultimatemember;

	include_once( W3DEV_BAN_USERS_PLUGIN_DIR_PATH. 'w3dev-ban-users-class.php' );
	$w3dev_ban_user_class 		= W3DEV_BAN_USER_CLASS::get_instance();
	$registration_ban_options   = $w3dev_ban_user_class->get_options('registration');
	
	if (!empty($registration_ban_options['enable_reg_ban_failed_country_check'])) {
	if (!empty($ultimatemember)) {

	    $ip_address             = $w3dev_ban_user_class->get_ip_address();
	    $geodata                = $w3dev_ban_user_class->get_geodata();
	    $geodata 				= json_decode($geodata);

	    if (!empty($geodata)) {
		    $geo_country 	= !empty($geodata->country_name) ? $geodata->country_name : (!empty($geodata->country) ? $geodata->country : false);
		    $form_country 	= !empty($args['submitted']['country']) ? $args['submitted']['country'] : false;
		    $geo_country 	= preg_replace('/\s+/', '', strtolower($geo_country));;
		    $form_country	= preg_replace('/\s+/', '', strtolower($form_country));

		    if ($geo_country !== $form_country) {
		    	//$ultimatemember->form->add_error[] = stripslashes('');
		    	$ultimatemember->classes['form']->add_error( 'country' , 'Selected country differs from your current location');
		    	//exit( wp_redirect( add_query_arg('err', 'Your submitted country differs from current location') ) );
		    }
		}
    
    }
	}
}
?>
