<?php 

function w3dev_ban_users_activation() {
	require_once( ABSPATH . '/wp-admin/includes/upgrade.php' );
	global $wpdb, $plugin;

	$db_table_name = $wpdb->prefix . 'w3dev_login_details';
	if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) {
		if ( ! empty( $wpdb->charset ) )
			$charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
		if ( ! empty( $wpdb->collate ) )
			$charset_collate .= " COLLATE $wpdb->collate";
 
		$sql = "CREATE TABLE " . $db_table_name . " (
			`id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			`user_id` int(11) NOT NULL,
			`ip_address` int(11) UNSIGNED,
			`user_agent` text,
			`geodata` text,
			`device` varchar(20),
			`date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
			PRIMARY KEY (`id`)
		) $charset_collate;";
		dbDelta( $sql );
	}

	$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
	if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) {
		if ( ! empty( $wpdb->charset ) )
			$charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
		if ( ! empty( $wpdb->collate ) )
			$charset_collate .= " COLLATE $wpdb->collate";
 
		$sql = "CREATE TABLE " . $db_table_name . " (
			`id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			`user_id` int(11) NOT NULL,
			`active` tinyint(4),
			`ip_address` int(11) UNSIGNED NULL,
			`email_address` varchar(255),
			`user_agent` text,
			`geodata` text,
			`date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
			`lift_date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
			PRIMARY KEY (`id`)
		) $charset_collate;";
		dbDelta( $sql );
	}

	$db_table_name = $wpdb->prefix . 'w3dev_logins_stats';
	if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) {
		if ( ! empty( $wpdb->charset ) )
			$charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
		if ( ! empty( $wpdb->collate ) )
			$charset_collate .= " COLLATE $wpdb->collate";
 
		$sql = "CREATE TABLE " . $db_table_name . " (
			`id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			`login_details_id` bigint(20) UNSIGNED NOT NULL,
			`success` tinyint(4),
			`date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
			PRIMARY KEY (`id`)
		) $charset_collate;";
		dbDelta( $sql );

	}

	$db_table_name = $wpdb->prefix . 'w3dev_ubu_events';
	if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) {
		if ( ! empty( $wpdb->charset ) )
			$charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
		if ( ! empty( $wpdb->collate ) )
			$charset_collate .= " COLLATE $wpdb->collate";
 
		$sql = "CREATE TABLE " . $db_table_name . " (
			`id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			`category` varchar(40),
			`action` varchar(40),
			`label` varchar(40),
			`value` decimal(8,3),
			`user_id` bigint(20) UNSIGNED,
			`date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
			PRIMARY KEY (`id`)
		) $charset_collate;";
		dbDelta( $sql );

	}

}
register_activation_hook(W3DEV_BAN_USERS_PLUGIN_FILE, 'w3dev_ban_users_activation');

?>