<?php
if ( ! defined('ABSPATH' ) ) exit;

add_action( 'wp_ajax_w3dev_quick_unban_user', 'w3dev_quick_unban_user_callback' );
function w3dev_quick_unban_user_callback() {

    $user_id = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    if (!empty($user_id)) {
        if ($w3dev_ban_user_class->is_user_banned($user_id)) {
            $w3dev_ban_user_class->unban_user( $user_id, array() );    
        }
        $action = 'unbanned'; // user has been unbanned
        echo $action;
    }
    
    wp_die();

}

add_action( 'wp_ajax_w3dev_toggle_ban_user', 'w3dev_toggle_ban_user_callback' );
function w3dev_toggle_ban_user_callback() {

    $user_id            = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $message            = isset($_POST['message']) ? trim($_POST['message']) : false;
    $date               = isset($_POST['unban_date']) ? trim($_POST['unban_date']) : false;
    $ban_duration       = isset($_POST['ban_duration']) ? trim($_POST['ban_duration']) : false;
    $ban_last_known_ip  = !empty($_POST['ban_last_known_ip']) ? 1 : 0;
    $ban_hide_avatar    = !empty($_POST['ban_hide_avatar']) ? TRUE : FALSE; 

    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    if (!empty($user_id)) {
        if ($w3dev_ban_user_class->is_user_banned($user_id)) {
            $w3dev_ban_user_class->unban_user( $user_id, array() );
            $action['ban'] = 'unbanned'; // user has been unbanned
            $action['src'] = get_avatar_url($user_id);
        } else {
            $w3dev_ban_user_class->ban_user( $user_id, $message, $date, $ban_duration, $ban_hide_avatar);
            if (!empty($ban_last_known_ip)) {

                if ($last_known_ip_address = $w3dev_ban_user_class->get_last_known_ip_address($user_id)) {
                   if (!$is_ip_address_banned = $w3dev_ban_user_class->is_ip_address_banned($last_known_ip_address)) {

                        global $wpdb;
                        $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                        $wpdb->insert( $db_table_name, 
                        array( 
                            'user_id'       => $user_id,
                            'active'        => 1,
                            'ip_address'    => ip2long($last_known_ip_address),
                            'date_time'     => date('Y-m-d H:i:s'),
                        ));
                        $record_id = $wpdb->insert_id;

                   }
                }

            }
            $action = 'banned'; // user has been banned
        }
         
        echo json_encode($action);
    }
    
    wp_die();

}


add_action( 'wp_ajax_w3dev_ban_user', 'w3dev_ban_user_callback' );
function w3dev_ban_user_callback() { 

    $user_id                = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');
    $last_known_ip_address  = $w3dev_ban_user_class->get_last_known_ip_address($user_id);
    $is_ip_address_banned   = $w3dev_ban_user_class->is_ip_address_banned($last_known_ip_address);

    $default_ban_reason     = isset($settings['default_ban_reason']) ? $settings['default_ban_reason'] : '';
    $default_warn_reason    = isset($settings['default_warn_reason']) ? $settings['default_warn_reason'] : '';
    $default_ban_ipaddress  = !empty($settings['default_ban_ipaddress']) ? 1 : 0;

    ?>

    <div id="jconfirm-ban-user">
        <div id="dtp-toggle-content">
            <p>Using the drop down menu below select the duration of the ban. Then in the textarea below, enter a brief message to send to the user that explains why they've been banned.</p>
            <select id="input-w3dev-ban-duration" class="selectric">
                <option value="indefinately">Ban indefinately</option>
                <option value="1 day">Ban for 1 day</option>
                <option value="1 week">Ban for 1 week</option>
                <option value="2 weeks">Ban for 2 weeks</option>
                <option value="1 month">Ban for 1 month</option>
                <option value="date picker">Ban using date picker</option>
            </select>
            <textarea name=""><?php echo $default_ban_reason; ?></textarea>
        </div>
        <div style="display:none;margin-top: -10px;margin-bottom: 15px;" id="w3dev-dtp-wrapper"><i class="fa fa-calendar" aria-hidden="true"></i><input type="text" id="input-w3dev-unban-date" value=""></div>
        <input type="checkbox" name="input-ban-hide-avatar" id="input-ban-hide-avatar" /> Hide User's avatar 
        </br>

        <?php if (!empty($last_known_ip_address)) { ?>
        <div style="margin-bottom: 5px;margin-top:0px;">

            <?php
            
            if (!empty($is_ip_address_banned)) {
                $checked_html = 'checked="checked" disabled="disabled"';
            } elseif ($default_ban_ipaddress) {
                $checked_html = 'checked="checked"';
            } else {
                $checked_html = null;
            }
            
            ?>
            <input type="checkbox" name="input-ban-last-known-ip" id="input-ban-last-known-ip" <?php echo $checked_html; ?>/> BAN User's last known IP Address: <?php echo $last_known_ip_address; ?>
    </div>
        <?php } ?>
    </div> 

    <style>
    .jconfirm-content{height:auto !important;}
    </style>
    
    <?php
    wp_die();

}


add_action( 'wp_ajax_w3dev_warn_user', 'w3dev_warn_user_callback' );
function w3dev_warn_user_callback() { 

    $user_id                = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');
    $default_warn_reason    = isset($settings['default_warn_reason']) ? $settings['default_warn_reason'] : '';
    ?>

    <div id="jconfirm-warn-user">
        <div id="dtp-toggle-content">
            <p>Enter a brief message below to send to the user that explains the reason for the warning.</p>
            <textarea name=""><?php echo $default_warn_reason; ?></textarea>
        </div>
    </div> 

    <style>
    .jconfirm-content{height:auto !important;}
    </style>
    
    <?php
    wp_die();

}


add_action( 'wp_ajax_w3dev_shared_accounts', 'w3dev_shared_accounts_callback' );
function w3dev_shared_accounts_callback() {

    $user_id = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();
    $results = $w3dev_ban_user_class->get_shared_accounts($user_id);
    ?>
    <p>The following accounts have been accessed from the same ip address.</p>
    <table id="w3dev-shared-accounts">
        <tr>
            <th>User ID</th>
            <th>IP Address</th>
            <th>Last Seen</th>
        </tr>
    <?php
    if (!empty($results) && count($results) > 1) { 

        $device_icon    = !empty($results[0]->device) ? $w3dev_ban_user_class->get_device_icon($results[0]->device) : null;
        $country_flag   = !empty($results[0]->geodata) ? $w3dev_ban_user_class->get_country_flag($results[0]->geodata) : null;

        $number = 0; foreach($results as $row) {
            echo '<tr class="'.($number % 2 == 0 ? 'alt' : null).'">';
            echo '  <td>' . $device_icon . '<a href="'.get_edit_user_link($row->user_id).'">'. $row->user_login . '</a></td>';
            echo '  <td>' . $country_flag['image'] . long2ip($row->ip_address) . '</td>';
            echo '  <td>' . $row->date_time . '</td>';
            echo '</tr>';
            $number++;
        }
    } else {
        echo '<tr class="alt"><td colspan="3">No shared account data found</td></tr>';
    }
    ?>
    </table>
    <style>
    .jconfirm-content{height:auto !important;}
    table#w3dev-shared-accounts { width: 100%; border-collapse: collapse; }
    table#w3dev-shared-accounts tr th { text-align: left; }
    table#w3dev-shared-accounts td,
    table#w3dev-shared-accounts th { padding: 10px; color: #666666; vertical-align:middle }
    table#w3dev-shared-accounts tr.alt { background-color: #f9f9f9 }
    </style>
    <?php
    wp_die();

}

add_action( 'wp_ajax_w3dev_user_history', 'w3dev_user_history_callback' );
function w3dev_user_history_callback() {

    $user_id = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();
    $results = $w3dev_ban_user_class->get_user_history($user_id);
    ?>
    <table id="w3dev-shared-accounts">
        <tr>
            <th>Device</th>
            <th>IP Address</th>
            <th>Login Date / Time</th>
        </tr>
    <?php
    if (!empty($results)) { 

        $device_icon    = !empty($results[0]->device) ? $w3dev_ban_user_class->get_device_icon($results[0]->device) : 'Unknown';
        $country_flag   = !empty($results[0]->geodata) ? $w3dev_ban_user_class->get_country_flag($results[0]->geodata) : null;

        $user_info  = get_userdata($user_id);

        ?>
        <!--<p>User: <?php echo $user_info->user_login.' ('.$user_id.')'; ?></p>-->

        <?php $number = 0; foreach($results as $row) {
            echo '<tr class="'.($number % 2 == 0 ? 'alt' : null).'">';
            echo '  <td>' . $device_icon . '</a></td>';
            echo '  <td>' . $country_flag['image'] . long2ip($row->ip_address) . '</td>';
            echo '  <td>' . $row->date_time . '</td>';
            echo '</tr>';
            $number++;
        }
    } else {
        echo '<tr class="alt"><td colspan="3">No login data found</td></tr>';
    }
    ?>
    </table>

    <style>
    .jconfirm-content{height:auto !important;}
    table#w3dev-shared-accounts { width: 100%; border-collapse: collapse; }
    table#w3dev-shared-accounts tr th { text-align: left; }
    table#w3dev-shared-accounts td,
    table#w3dev-shared-accounts th { padding: 10px; color: #666666; vertical-align:middle }
    table#w3dev-shared-accounts tr.alt { background-color: #f9f9f9 }
    </style>
    <?php
    wp_die();

}

add_action( 'wp_ajax_w3dev_banned_history', 'w3dev_banned_history_callback' );
function w3dev_banned_history_callback() {

    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();
    $user_id    = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $is_banned  = $w3dev_ban_user_class->is_user_banned($user_id);
    $user_info  = get_userdata($user_id);
    ?>

    <table id="w3dev-shared-accounts">
        <tr class="alt">
            <td style="text-align:center;width:40px"><i class="fa fa-user-circle-o fa-lg" aria-hidden="true"></i></td>
            <th style="width:140px;">User Login (ID)</th>
            <td><?php echo $user_info->user_login.' ('.$user_id.')'; ?></td>
        </tr>
        <tr>
            <td style="text-align:center;width:40px"><i class="fa fa-ban fa-lg" aria-hidden="true"></i></td>
            <th style="width:140px;">Currently banned</th>
            <td><?php echo $is_banned ? 'Yes' : 'No'; ?></td>
        </tr>
        <tr class="alt">
            <td style="text-align:center"><i class="fa fa-calendar-times-o fa-lg" aria-hidden="true"></i></td>
            <th>Date <?php echo $is_banned ? null : 'un'; ?>banned</th>
            <td><?php $banned_date = get_user_option( 'w3dev_user_banned_date',  $user_id ); echo !empty($banned_date) ? $banned_date : '--'; ?></td>
        </tr>
        <tr>
            <td style="text-align:center"><i class="fa fa-clock-o fa-lg" aria-hidden="true"></i></td>
            <th>Ban duration</th>
            <td>
                <?php if ($is_banned) {
                    $ban_expires = wp_next_scheduled('w3dev_unban_user', array( intval($user_id) ));
                    if (empty($ban_expires)) {
                        echo '--'; 
                    } else {
                        $date_a = new DateTime(date('Y-m-d', strtotime($banned_date)));
                        $date_b = new DateTime(date('Y-m-d', $ban_expires));
                        $interval = date_diff($date_a,$date_b);
                        echo $interval->format('%d').' days';
                    }
                } else { 
                    echo '--'; 
                }
                ?>
             </td>
        </tr>
        <tr class="alt">
            <td style="text-align:center"><i class="fa fa-calendar-check-o fa-lg" aria-hidden="true"></i></td>
            <th>Ban expires</th>
            <td>
                <?php 
                if ($is_banned) {
                    echo !empty($ban_expires) ? date('d-m-Y', $ban_expires) : 'Never'; //Indefinately
                } else {
                    echo '--';
                }
                ?>
            </td>
        </tr>
        <tr>
            <td style="text-align:center;vertical-align: top"><i class="fa fa-sticky-note-o fa-lg" aria-hidden="true"></i></td>
            <th style="vertical-align: top">Reason for <?php echo $is_banned ? null : 'last '; ?>ban</th>
            <td style="vertical-align: top">
                <?php 
                $banned_reason = get_user_option( 'w3dev_user_banned_reason',  $user_id );
                if (!empty($banned_reason)) {
                    echo $banned_reason;
                } else {
                    echo '--';
                }
                ?>
            </td>
        </tr>
    </table>
    <style>
    .jconfirm-content{height:auto !important;}
    table#w3dev-shared-accounts { width: 100%; border-collapse: collapse; }
    table#w3dev-shared-accounts tr th { text-align: left; }
    table#w3dev-shared-accounts td,
    table#w3dev-shared-accounts th { padding: 10px; color: #666666; vertical-align:middle }
    table#w3dev-shared-accounts tr.alt { background-color: #f9f9f9 }
    </style>

    <?php
    wp_die();

}

add_action( 'wp_ajax_w3dev_device_information', 'w3dev_device_information_callback' );
function w3dev_device_information_callback() {

    global $wpdb;
    $db_table_name = $wpdb->prefix . 'w3dev_login_details';
    $user_id = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;

    include_once( plugin_dir_path( __FILE__ ) . '../lib/browser-php/lib/Browser.php');

    $results = $wpdb->get_results( $wpdb->prepare("
        SELECT ip_address, user_agent, device, geodata, date_time FROM $db_table_name
        WHERE user_id = %d
        ORDER BY id DESC
        LIMIT 1
        ", $user_id
        ));

    if (!empty($results[0])) {

        $ip_address     = !empty($results[0]->ip_address) ? long2ip($results[0]->ip_address) : '--';
        $browser        = new Browser($results[0]->user_agent);
        $getbrowser     = $browser->getBrowser();
        $getPlatform    = $browser->getPlatform();
        $geodata        = $geodata  = !empty($results[0]->geodata) ? json_decode($results[0]->geodata, true) : null;
        $user_info      = get_userdata($user_id);

        $country_code = !empty($geodata['countryCode']) ? $geodata['countryCode'] : (!empty($geodata['country_code']) ? $geodata['country_code'] : null);
        $country_name = !empty($geodata['country']) ? $geodata['country'] : (!empty($geodata['country_name']) ? $geodata['country_name'] : null);

        $data = array();
        $html = '
            <div class="device-notes" style="display:none;">..</div>
            <div class="device-information">
            <p>The following information was obtained during the user\'s last login.</p>
            <table id="w3dev-device-information">
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-user-circle-o fa-lg" aria-hidden="true"></i></td>
                    <td>User Login (ID)</td>
                    <td>'.$user_info->user_login.' ('.$user_id.')</td>
                </tr>
                <tr style="background-color:#ffffff">
                    <td style="text-align:center"><i class="fa fa-globe fa-lg" aria-hidden="true"></i></td>
                    <td>IP Address</td>
                    <td>'.$ip_address.'</td>
                </tr>
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-clock-o fa-lg" aria-hidden="true"></i></td>
                    <td>Last Seen</td>
                    <td>'.date('d-m-Y H:i:s', strtotime($results[0]->date_time)).'</td>
                </tr>
                <tr style="background-color:#ffffff">
                    <td style="text-align:center"><i class="fa fa-laptop fa-lg" aria-hidden="true"></i></td>
                    <td>Device Type</td>
                    <td>'.ucfirst($results[0]->device).'</td>
                </tr>
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-window-maximize fa-lg" aria-hidden="true"></i></td>
                    <td>Operating System</td>
                    <td>'.$getPlatform.'</td>
                </tr>
                <tr style="background-color:#ffffff">
                    <td style="text-align:center"><i class="fa fa-list-alt fa-lg" aria-hidden="true"></i></td>
                    <td>Browser</td>
                    <td><img style="position:relative; bottom:-2px; margin-right: 5px;" src="https://cdnjs.cloudflare.com/ajax/libs/browser-logos/42.8.0/'.strtolower($getbrowser).'/'.strtolower($getbrowser).'_16x16.png" />'.ucfirst($getbrowser).'</td>
                </tr>';

        if (!empty($country_name)) {
            $html .= '
                    <tr style="background-color:#f9f9f9">
                        <td style="text-align:center"><i class="fa fa-location-arrow fa-lg" aria-hidden="true"></i></td>
                        <td>Location</td>
                        <td>'.$country_name . ' (' . $country_code .')</td>
                    </tr>';

            $html .= '
                <tr style="background-color:#ffffff">
                    <td style="text-align:center"><i class="fa fa-sticky-note-o fa-lg" aria-hidden="true"></i></td>
                    <td>Notes</td>
                    <td><a class="js-view-notes" href="javascript:void(0)">View notes</a></td>
                </tr>
            ';

        } else {

            $html .= '
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-sticky-note-o fa-lg" aria-hidden="true"></i></td>
                    <td>Notes</td>
                    <td><a class="js-view-notes" href="javascript:void(0)">View notes</a></td>
                </tr>
            ';

        }

        
        $html .= '
                </table>
                </div>

                <style>
                .jconfirm-content{height:auto !important;}
                #w3dev-device-information { width: 100%; border-collapse: collapse; }
                #w3dev-device-information td { padding: 10px; color: #666666; vertical-align:middle }
                </style>
                ';
  
    } else {

        $html = '
            <table id="w3dev-device-information">
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-globe fa-lg" aria-hidden="true"></i></td>
                    <td>IP Address</td>
                    <td>Not available</td>
                </tr>
                <tr style="background-color:#fff">
                    <td style="text-align:center"><i class="fa fa-clock-o fa-lg" aria-hidden="true"></i></td>
                    <td>Last Seen</td>
                    <td>Not available</td>
                </tr>
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-laptop fa-lg" aria-hidden="true"></i></td>
                    <td>Device Type</td>
                    <td>Not available</td>
                </tr>
                <tr style="background-color:#fff">
                    <td style="text-align:center"><i class="fa fa-window-maximize fa-lg" aria-hidden="true"></i></td>
                    <td>Operating System</td>
                    <td>Not available</td>
                </tr>
                <tr style="background-color:#f9f9f9">
                    <td style="text-align:center"><i class="fa fa-list-alt fa-lg" aria-hidden="true"></i></td>
                    <td>Browser</td>
                    <td>Not available</td>
                </tr>
                <tr style="background-color:#fff">
                    <td style="text-align:center"><i class="fa fa-location-arrow fa-lg" aria-hidden="true"></i></td>
                    <td>Location</td>
                    <td>Not available</td>
                </tr>
            </table>

            <style>
            .jconfirm-content{height:auto !important;}
            #w3dev-device-information { width: 100%; border-collapse: collapse; }
            #w3dev-device-information td { padding: 10px; color: #666666; vertical-align:middle }
            </style>
            ';

    }

    echo $html;
    wp_die();

}

add_action( 'wp_ajax_w3dev_warn_ban_user', 'w3dev_toggle_warn_user_callback' );
function w3dev_toggle_warn_user_callback() {

    $user_id    = isset($_POST['user_id']) ? floatval($_POST['user_id']) : false;
    $reason     = isset($_POST['reason']) ? trim($_POST['reason']) : false;

    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    if (!empty($user_id)) {

        $settings               = $w3dev_ban_user_class->get_options('settings');
        $notifications          = $w3dev_ban_user_class->get_options('notifications');
        $email_template         = $notifications['user_notification'];

        $user_info  = get_userdata($user_id);
        $user_email = $user_info->user_email;
        $user_email = filter_var($user_email, FILTER_SANITIZE_EMAIL);

        if (!empty($user_email)) {
    
            // next we need to get the template and replace the reason tag 
            // %%reason%% with the text provided in the options or popup window
            // --
            $subject_title      = !empty( $email_template['warn_subject_title'] ) ? $email_template['warn_subject_title'] : $notifications['_defaults']['user_notification']['warn_subject_title'];
            $body               = !empty( $email_template['warn_body'] ) ? $email_template['warn_body'] : $notifications['_defaults']['user_notification']['warn_body'];
            $find_reason_tag    = strpos( $body, '%%reason%%' );

            // Determine if the message sent as a parameter is empty
            // Replaces the empty message with a generic one
            // --
            if ( empty($message) ) { $message = $settings['ban_email_default_message']; }
            if ( $find_reason_tag !== false ) { 
                $reason = empty($reason) ? null : $reason;
                $body = str_replace('%%reason%%', $reason, $body);
            }

            $body = str_replace('%%username%%', $user_info->user_login, $body);
            $body = str_replace('%%first_name%%', $user_info->first_name, $body);
            $body = str_replace('%%last_name%%', $user_info->last_name, $body);
            // define headers
            // --
            $headers = array();
            $headers[] = "Content-Type: text/html; charset=utf-8\r\n";

            // include bcc and cc if applicable
            // --
            if (!empty($email_template['warn_cc_field'])) { $headers[] = 'Cc: '.$email_template['warn_cc_field']; }
            if (!empty($email_template['warn_bcc_field'])) { $headers[] = 'Bcc: '.$email_template['warn_bcc_field']; }
            // finally, a quick check to ensure the email is valid
            // before sending using wp_mail
            // --
            if (!filter_var($user_email, FILTER_VALIDATE_EMAIL) === false) {

                $user_id = !empty($user->ID) ? (int) $user->ID : 0; 
                $w3dev_ban_user_class->log_event(array('category' => 'notification', 'action' => 'warn user', 'user_id' => $user_id));

                wp_mail( $user_email, $subject_title, $body, $headers );            
            }
        }
        
        echo '<span style="color:#a00">Warn</span>';
    }
    
    wp_die();

}

add_action( 'wp_ajax_w3dev_save_ban_user_settings', 'w3dev_save_ban_user_settings_callback' );
function w3dev_save_ban_user_settings_callback() {

    global $wpdb;
    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    // validation
    // --
    
    // custom_logout_url can be relative (i.e. about-us.php, or /about-us.php) so does not necessarily need a prefix of http(s)://
    // post_status, display_message, force_logout, custom_logout will always be 0 or 1 so set with inval()
    // --    
    $post_status                            = isset( $_POST['post_status'] ) ? trim( $_POST['post_status'] ) : null;
    $custom_message                         = isset( $_POST['custom_message'] ) ? trim( $_POST['custom_message'] ) : null;
    $set_banned_user_role                   = isset( $_POST['set_banned_user_role'] ) ? trim( $_POST['set_banned_user_role'] ) : null;
    $set_unbanned_user_role                 = isset( $_POST['set_unbanned_user_role'] ) ? trim( $_POST['set_unbanned_user_role'] ) : null;
    $custom_logout_url                      = isset( $_POST['custom_logout_url'] ) ? trim( $_POST['custom_logout_url'] ) : null;
    $ban_email_default_message              = isset( $_POST['ban_email_default_message'] ) ? trim( $_POST['ban_email_default_message'] ) : null;
    $users_tbl_last_seen                    = !empty( $_POST['users_tbl_last_seen'] ) ? 1 : 0;
    $users_tbl_row_highlighted              = !empty( $_POST['users_tbl_row_highlighted'] ) ? 1 : 0;
    $users_tbl_data_column                  = !empty( $_POST['users_tbl_data_column'] ) ? 1 : 0;
    $users_tbl_geoip_data_column            = !empty( $_POST['users_tbl_geoip_data_column'] ) ? 1 : 0;
    $banned_login_message                   = isset( $_POST['banned_login_message'] ) ? trim( $_POST['banned_login_message'] ) : null;
    $denied_login_message                   = isset( $_POST['denied_login_message'] ) ? trim( $_POST['denied_login_message'] ) : null;
    $denied_bad_bot_message                 = isset( $_POST['denied_bad_bot_message'] ) ? trim( $_POST['denied_bad_bot_message'] ) : null;
    $non_admin_role_restriction_message     = isset( $_POST['non_admin_role_restriction_message'] ) ? trim( $_POST['non_admin_role_restriction_message'] ) : null;
    $admin_restricted_hours_message         = isset( $_POST['admin_restricted_hours_message'] ) ? trim( $_POST['admin_restricted_hours_message'] ) : null;

    $default_ban_reason                     = isset( $_POST['default_ban_reason'] ) ? trim( $_POST['default_ban_reason'] ) : null;
    $default_warn_reason                    = isset( $_POST['default_warn_reason'] ) ? trim( $_POST['default_warn_reason'] ) : null;

    $always_unban_ipaddress                 = !empty( $_POST['always_unban_ipaddress'] ) ? 1 : 0;
    $default_ban_ipaddress                  = !empty( $_POST['default_ban_ipaddress'] ) ? 1 : 0;
    $change_posts_status                    = intval( $_POST['change_posts_status'] );
    $post_status                            = !empty( $post_status ) ? preg_replace('/[^a-z_\-.0-9\s]/i', '', $post_status) : null;
    $on_ban_change_user_role                = intval( $_POST['on_ban_change_user_role'] );
    $set_banned_user_role                   = !empty( $set_banned_user_role ) ? preg_replace('/[^a-z_\-.0-9\s]/i', '', $set_banned_user_role) : null;
    $on_unban_change_user_role              = intval( $_POST['on_unban_change_user_role'] );
    $set_unbanned_user_role                 = !empty( $set_unbanned_user_role ) ? preg_replace('/[^a-z_\-.0-9\s]/i', '', $set_unbanned_user_role) : null;
    $display_message                        = intval( $_POST['display_message'] );
    $custom_message                         = !empty( $custom_message ) ? strip_tags($custom_message) : null;
    $force_logout                           = intval( $_POST['force_logout'] );
    $custom_logout                          = intval( $_POST['custom_logout'] );
    $custom_logout_url                      = !empty( $custom_logout_url ) ? preg_replace('/[^a-z_\\/:~%-.0-9\s|+]/i', '', $custom_logout_url) : null;
    $close_panels                           = !empty( $_POST['close_panels'] ) ? 1 : 0;
    $unban_date                             = intval( $_POST['unban_date'] );
    $ban_email                              = intval( $_POST['ban_email'] );
    $ban_email_default                      = intval( $_POST['ban_email_default'] );
    $ban_email_default_message              = !empty( $ban_email_default_message ) ? preg_replace('/[^a-z_\-.0-9\s]/i', '', $ban_email_default_message) : null;
    $banned_login_message                   = !empty( $banned_login_message ) ? strip_tags($banned_login_message) : null;
    $denied_login_message                   = !empty( $denied_login_message ) ? strip_tags($denied_login_message) : null;
    $date_format                            = !empty( $_POST['date_format'] ) ? $_POST['date_format'] : 'd-m-Y';
    $time_enable                            = !empty( $_POST['time_enable'] ) ? 1 : 0;
    $send_notification_new_post             = !empty( $_POST['send_notification_new_post'] ) ? 1 : 0;
    $warn_user                              = !empty( $_POST['warn_user'] ) ? 1 : 0;
    $notification_emails                    = !empty( $_POST['notification_emails'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['notification_emails']) ) : null;
    $warn_user_reason                       = !empty( $_POST['warn_user_reason'] ) ? 1 : 0;
    $capture_login_geoip_data               = !empty( $_POST['capture_login_geoip_data'] ) ? 1 : 0;
    $hide_banned_users_comments             = !empty( $_POST['hide_banned_users_comments'] ) ? 1 : 0;
    $scramble_banned_users_password         = !empty( $_POST['scramble_banned_users_password'] ) ? 1 : 0;
    $disable_password_reset_banned_users    = !empty( $_POST['disable_password_reset_banned_users'] ) ? 1 : 0;


    $set_spammer_option                     = !empty( $_POST['set_spammer_option'] ) ? 1 : 0;
    $unset_spammer_option                   = !empty( $_POST['unset_spammer_option'] ) ? 1 : 0;

    $frontend_banned_notification           = !empty( $_POST['frontend_banned_notification'] ) ? 1 : 0;
    $frontend_notification_force_logout     = !empty( $_POST['frontend_notification_force_logout'] ) ? 1 : 0;
    $frontend_notification_hide             = !empty( $_POST['frontend_notification_hide'] ) ? 1 : 0;

    $enable_accessibility                   = !empty( $_POST['enable_accessibility'] ) ? 1 : 0;
    $ip_api                                 = !empty( $_POST['ip_api'] ) ? $_POST['ip_api'] : null;
    $ip_api_request_method                  = !empty( $_POST['ip_api_request_method'] ) ? $_POST['ip_api_request_method'] : null;
    $ip_resolution_method                   = !empty( $_POST['ip_resolution_method'] ) ? $_POST['ip_resolution_method'] : null;

    $device_detection = array();
    $device_detection['disabled']           = !empty( $_POST['device_detection_disabled'] ) ? 1 : 0;

    $disable_autoload = array();
    $disable_autoload['fa']                 = !empty( $_POST['autoload_fa'] ) ? 1 : 0;
    $disable_autoload['jq_confirm']         = !empty( $_POST['autoload_jq_confirm'] ) ? 1 : 0;
    $disable_autoload['datatables']         = !empty( $_POST['autoload_datatables'] ) ? 1 : 0;
    $disable_autoload['notify']             = !empty( $_POST['autoload_notify'] ) ? 1 : 0;
    $disable_autoload['selectric']          = !empty( $_POST['autoload_selectric'] ) ? 1 : 0;
    $disable_autoload['flatpickr']          = !empty( $_POST['autoload_flatpickr'] ) ? 1 : 0;
    $disable_autoload['alertify']           = !empty( $_POST['autoload_alertify'] ) ? 1 : 0;
    $disable_autoload['select2']            = !empty( $_POST['autoload_select2'] ) ? 1 : 0;
    $disable_autoload['faanimation']        = !empty( $_POST['autoload_faanimation'] ) ? 1 : 0;
    $disable_autoload['momentjs']           = !empty( $_POST['autoload_momentjs'] ) ? 1 : 0;
    $disable_autoload['chartjs']            = !empty( $_POST['autoload_chartjs'] ) ? 1 : 0;


    $restrict['admin']['mon']['enabled']    = !empty( $_POST['restrict_admin_mon'] ) ? 1 : 0;
    $restrict['admin']['tue']['enabled']    = !empty( $_POST['restrict_admin_tue'] ) ? 1 : 0;
    $restrict['admin']['wed']['enabled']    = !empty( $_POST['restrict_admin_wed'] ) ? 1 : 0;
    $restrict['admin']['thu']['enabled']    = !empty( $_POST['restrict_admin_thu'] ) ? 1 : 0;
    $restrict['admin']['fri']['enabled']    = !empty( $_POST['restrict_admin_fri'] ) ? 1 : 0;
    $restrict['admin']['sat']['enabled']    = !empty( $_POST['restrict_admin_sat'] ) ? 1 : 0;
    $restrict['admin']['sun']['enabled']    = !empty( $_POST['restrict_admin_sun'] ) ? 1 : 0;

    $restrict['admin']['mon']['start']      = !empty( $_POST['restrict_admin_mon_start'] ) ? $_POST['restrict_admin_mon_start'] : null;
    $restrict['admin']['tue']['start']      = !empty( $_POST['restrict_admin_tue_start'] ) ? $_POST['restrict_admin_tue_start'] : null;
    $restrict['admin']['wed']['start']      = !empty( $_POST['restrict_admin_wed_start'] ) ? $_POST['restrict_admin_wed_start'] : null;
    $restrict['admin']['thu']['start']      = !empty( $_POST['restrict_admin_thu_start'] ) ? $_POST['restrict_admin_thu_start'] : null;
    $restrict['admin']['fri']['start']      = !empty( $_POST['restrict_admin_fri_start'] ) ? $_POST['restrict_admin_fri_start'] : null;
    $restrict['admin']['sat']['start']      = !empty( $_POST['restrict_admin_sat_start'] ) ? $_POST['restrict_admin_sat_start'] : null;
    $restrict['admin']['sun']['start']      = !empty( $_POST['restrict_admin_sun_start'] ) ? $_POST['restrict_admin_sun_start'] : null;

    $restrict['admin']['mon']['end']        = !empty( $_POST['restrict_admin_mon_end'] ) ? $_POST['restrict_admin_mon_end'] : null;
    $restrict['admin']['tue']['end']        = !empty( $_POST['restrict_admin_tue_end'] ) ? $_POST['restrict_admin_tue_end'] : null;
    $restrict['admin']['wed']['end']        = !empty( $_POST['restrict_admin_wed_end'] ) ? $_POST['restrict_admin_wed_end'] : null;
    $restrict['admin']['thu']['end']        = !empty( $_POST['restrict_admin_thu_end'] ) ? $_POST['restrict_admin_thu_end'] : null;
    $restrict['admin']['fri']['end']        = !empty( $_POST['restrict_admin_fri_end'] ) ? $_POST['restrict_admin_fri_end'] : null;
    $restrict['admin']['sat']['end']        = !empty( $_POST['restrict_admin_sat_end'] ) ? $_POST['restrict_admin_sat_end'] : null;
    $restrict['admin']['sun']['end']        = !empty( $_POST['restrict_admin_sun_end'] ) ? $_POST['restrict_admin_sun_end'] : null;

    $extentions = array();
    $extensions['ultimate_member']          = !empty( $_POST['ext_ultimate_member'] ) ? 1 : 0;

    $w3dev_banned_word_options = array();
    $w3dev_banned_word_options['banned_content']            = !empty( $_POST['banned_content'] ) ? 1 : 0;
    $w3dev_banned_word_options['banned_content_title']      = !empty( $_POST['banned_content_title'] ) ? 1 : 0;
    $w3dev_banned_word_options['banned_content_email']      = !empty( $_POST['banned_content_email'] ) ? 1 : 0;
    $w3dev_banned_word_options['banned_content_occurances'] = !empty( $_POST['banned_content_occurances'] ) ? $_POST['banned_content_occurances'] : null;
    $w3dev_banned_word_options['banned_content_level']      = !empty( $_POST['banned_content_level'] ) ? $_POST['banned_content_level'] : null;
    $w3dev_banned_word_options['banned_words_and_phrases']  = !empty( $_POST['banned_words_and_phrases'] ) ? implode( '|', $_POST['banned_words_and_phrases']) : null;
    $w3dev_banned_word_options['banned_post_types']         = !empty( $_POST['banned_post_types'] ) ? implode( '|', $_POST['banned_post_types']) : null;
    
    $w3dev_banned_username_options = array();
    $w3dev_banned_username_options['banned_usernames'] = !empty( $_POST['banned_usernames'] ) ? implode( '|', $_POST['banned_usernames']) : null;

    $w3dev_banned_password_options = array();
    $w3dev_banned_password_options['banned_passwords'] = !empty( $_POST['banned_passwords'] ) ? implode( '|', $_POST['banned_passwords']) : null;

    $security = array();
    $security['enable_admin_override']      = !empty( $_POST['security_enable_admin_override'] ) ? $_POST['security_enable_admin_override'] : 0;
    $security['set_moderator_roles']        = !empty( $_POST['security_set_moderator_roles'] ) ? $_POST['security_set_moderator_roles'] : 0;
    $security['moderator_roles']            = !empty( $_POST['security_moderator_roles'] ) ? $_POST['security_moderator_roles'] : 0;
    $security['set_moderated_roles']        = !empty( $_POST['security_set_moderated_roles'] ) ? $_POST['security_set_moderated_roles'] : 0;
    $security['moderated_roles']            = !empty( $_POST['security_moderated_roles'] ) ? $_POST['security_moderated_roles'] : 0;
    $security['deny_reg_no_useragent']      = !empty( $_POST['security_deny_reg_no_useragent'] ) ? $_POST['security_deny_reg_no_useragent'] : 0;
    $security['deny_reg_no_ipaddress']      = !empty( $_POST['security_deny_reg_no_ipaddress'] ) ? $_POST['security_deny_reg_no_ipaddress'] : 0;    
    $security['deny_login_no_useragent']    = !empty( $_POST['security_deny_login_no_useragent'] ) ? $_POST['security_deny_login_no_useragent'] : 0;
    $security['deny_login_no_ipaddress']    = !empty( $_POST['security_deny_login_no_ipaddress'] ) ? $_POST['security_deny_login_no_ipaddress'] : 0;
    $security['auto_notify_new_ip']         = !empty( $_POST['security_auto_notify_new_ip'] ) ? $_POST['security_auto_notify_new_ip'] : 0;
    $security['auto_notify_admin_login']    = !empty( $_POST['security_auto_notify_admin_login'] ) ? $_POST['security_auto_notify_admin_login'] : 0;
    $security['disable_non_admin_logins']   = !empty( $_POST['security_disable_non_admin_logins'] ) ? $_POST['security_disable_non_admin_logins'] : 0;
    $security['hide_wp_login_messages']     = !empty( $_POST['security_hide_wp_login_messages'] ) ? $_POST['security_hide_wp_login_messages'] : 0;
    $security['ambiguous_error_messages']   = !empty( $_POST['security_ambiguous_error_messages'] ) ? $_POST['security_ambiguous_error_messages'] : 0;
    $security['block_bad_bot']              = !empty( $_POST['security_block_bad_bot'] ) ? $_POST['security_block_bad_bot'] : 0;
    $security['redirect_bad_bot']           = !empty( $_POST['security_redirect_bad_bot'] ) ? $_POST['security_redirect_bad_bot'] : 0;
    $security['disable_registrations']      = !empty( $_POST['security_disable_registrations'] ) ? $_POST['security_disable_registrations'] : 0;
    $security['disable_comments']           = !empty( $_POST['security_disable_comments'] ) ? $_POST['security_disable_comments'] : 0;

    $logging['denied_logins']                = !empty( $_POST['logging_denied_logins'] ) ? $_POST['logging_denied_logins'] : 0;
    $logging['successful_logins']            = !empty( $_POST['logging_successful_logins'] ) ? $_POST['logging_successful_logins'] : 0;
    $logging['banned_users']                 = !empty( $_POST['logging_banned_users'] ) ? $_POST['logging_banned_users'] : 0;
    $logging['user_warnings']                = !empty( $_POST['logging_user_warnings'] ) ? $_POST['logging_user_warnings'] : 0;
    $logging['denied_registrations']         = !empty( $_POST['logging_denied_registrations'] ) ? $_POST['logging_denied_registrations'] : 0;
    $logging['spam_preventations']           = !empty( $_POST['logging_spam_preventations'] ) ? $_POST['logging_spam_preventations'] : 0;

    if ( $security['hide_wp_login_messages'] )
        add_filter('login_errors', 'return_null', 100);
     else
        remove_filter('login_errors', 'return_null', 100);


    $debug = array();
    $debug['php'] = !empty( $_POST['debug_php'] ) ? 1 : 0;

    // if set post_status is true, then check selected status is valid
    // --
    if (!empty($post_status)) {
    
        $stati = array('publish','future','draft','pending','private','trash','auto-draft','inherit');

        // if status is not in array, then set post_status back to false (0)
        // --
        $post_status = in_array($post_status,$stati) ? $post_status : 0;

    }

    $w3dev_ban_user_options = array(
        'post_status'                           => $post_status,
        'change_posts_status'                   => $change_posts_status,
        'on_ban_change_user_role'               => $on_ban_change_user_role,
        'set_banned_user_role'                  => $set_banned_user_role,
        'on_unban_change_user_role'             => $on_unban_change_user_role,
        'set_unbanned_user_role'                => $set_unbanned_user_role,
        'display_message'                       => $display_message,
        'custom_message'                        => sanitize_text_field($custom_message),
        'force_logout'                          => $force_logout,
        'custom_logout'                         => $custom_logout,
        'custom_logout_url'                     => $custom_logout_url,
        'always_unban_ipaddress'                => $always_unban_ipaddress,
        'default_ban_ipaddress'                 => $default_ban_ipaddress,
        'close_panels'                          => $close_panels,
        'unban_date'                            => $unban_date,
        'ban_email'                             => $ban_email,
        'ban_email_default'                     => $ban_email_default,
        'ban_email_default_message'             => $ban_email_default_message,
        'users_tbl_last_seen'                   => $users_tbl_last_seen,
        'users_tbl_row_highlighted'             => $users_tbl_row_highlighted,
        'users_tbl_data_column'                 => $users_tbl_data_column,
        'banned_login_message'                  => $banned_login_message,
        'denied_login_message'                  => $denied_login_message,
        'denied_bad_bot_message'                => $denied_bad_bot_message,
        'hide_banned_users_comments'            => $hide_banned_users_comments,
        'scramble_banned_users_password'        => $scramble_banned_users_password,
        'disable_password_reset_banned_users'   => $disable_password_reset_banned_users,
        'set_spammer_option'                    => $set_spammer_option,
        'unset_spammer_option'                  => $unset_spammer_option,
        'default_ban_reason'                    => $default_ban_reason,
        'default_warn_reason'                   => $default_warn_reason,
        'non_admin_role_restriction_message'    => $non_admin_role_restriction_message,
        'admin_restricted_hours_message'        => $admin_restricted_hours_message,
        'date_format'                           => $date_format,
        'time_enable'                           => $time_enable,
        'warn_user'                             => $warn_user,
        'send_notification_new_post'            => $send_notification_new_post,
        'notification_emails'                   => $notification_emails,
        'users_tbl_geoip_data_column'           => $users_tbl_geoip_data_column,
        'capture_login_geoip_data'              => $capture_login_geoip_data,
        'warn_user_reason'                      => $warn_user_reason,
        'frontend_banned_notification'          => $frontend_banned_notification,
        'frontend_notification_force_logout'    => $frontend_notification_force_logout,
        'frontend_notification_hide'            => $frontend_notification_hide,
        'enable_accessibility'                  => $enable_accessibility,
        'ip_api'                                => $ip_api,
        'ip_api_request_method'                 => $ip_api_request_method,
        'ip_resolution_method'                  => $ip_resolution_method,
        'device_detection'                      => $device_detection,
        'disable_autoload'                      => $disable_autoload,
        'restrict'                              => $restrict,
        'extensions'                            => $extensions,
        'security'                              => $security,
        'debug'                                 => $debug,
        'logging'                               => $logging
        );

    update_option( 'w3dev_ban_user_options', $w3dev_ban_user_options );
    
    $editor_css         = !empty( $_POST['editor_css'] ) ? $_POST['editor_css'] : null;
    $editor_js          = !empty( $_POST['editor_js'] ) ? $_POST['editor_js'] : null;

    $inc_header_css     = !empty( $_POST['inc_header_css'] ) ? 1 : 0;
    $inc_footer_js      = !empty( $_POST['inc_footer_js'] ) ? 1 : 0;

    $w3dev_ban_css_scipts_options = array(
        'editor_css'            => $editor_css,
        'editor_js'             => $editor_js,
        'inc_header_css'        => $inc_header_css,
        'inc_footer_js'         => $inc_footer_js
        );

    update_option( 'w3dev_ban_css_scipts_options', $w3dev_ban_css_scipts_options );

    update_option( 'w3dev_banned_word_options', $w3dev_banned_word_options );

    update_option( 'w3dev_banned_username_options', $w3dev_banned_username_options );

    update_option( 'w3dev_banned_password_options', $w3dev_banned_password_options );

    echo '1';
    wp_die(); // this is required to terminate immediately and return a proper response

}

/**
 * This function is used to save the email template content
 * 
 */
add_action( 'wp_ajax_w3dev_save_ban_email_template', 'w3dev_save_ban_email_template_callback' );
function w3dev_save_ban_email_template_callback() {

    $ban_subject_title = trim( $_POST['ban_subject_title'] );
    $ban_body = trim( $_POST['ban_body'] );

    $unban_subject_title            = trim( $_POST['unban_subject_title'] );
    $unban_body                     = trim( $_POST['unban_body'] );
    $unban_indefinite_date_tag      = trim( $_POST['unban_indefinite_date_tag'] );
    $warn_subject_title             = trim( $_POST['warn_subject_title'] );
    $warn_body                      = trim( $_POST['warn_body'] );
    $admin_login_subject_title      = trim( $_POST['admin_login_subject_title'] );
    $admin_login_body               = trim( $_POST['admin_login_body'] );

    $ban_cc_field                   = !empty( $_POST['ban_cc_field'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['ban_cc_field']) ) : null;
    $ban_bcc_field                  = !empty( $_POST['ban_bcc_field'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['ban_bcc_field']) ) : null;
    $unban_cc_field                 = !empty( $_POST['unban_cc_field'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['unban_cc_field']) ) : null;
    $unban_bcc_field                = !empty( $_POST['unban_bcc_field'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['unban_bcc_field']) ) : null;
    $warn_cc_field                  = !empty( $_POST['warn_cc_field'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['warn_cc_field']) ) : null;
    $warn_bcc_field                 = !empty( $_POST['warn_bcc_field'] ) ? implode( ',', preg_replace('/[^a-z_\-@.0-9\s]/i', '', $_POST['warn_bcc_field']) ) : null;

    $w3dev_ban_templates = array(
        'user_notification' => array(
            'subject_title'                 => $ban_subject_title,
            'body'                          => $ban_body, 
            'ban_cc_field'                  => $ban_cc_field,
            'ban_bcc_field'                 => $ban_bcc_field,
            'unban_subject_title'           => $unban_subject_title,
            'unban_body'                    => $unban_body,
            'unban_cc_field'                => $unban_cc_field,
            'unban_bcc_field'               => $unban_bcc_field,
            'unban_indefinite_date_tag'     => $unban_indefinite_date_tag,
            'warn_subject_title'            => $warn_subject_title,
            'warn_body'                     => $warn_body,
            'warn_cc_field'                 => $warn_cc_field,
            'warn_bcc_field'                => $warn_bcc_field,
            'admin_login_subject_title'     => $admin_login_subject_title,
            'admin_login_body'              => $admin_login_body,
            )
        );

    update_option( 'w3dev_ban_user_email_templates', $w3dev_ban_templates);

    echo '1';
    wp_die(); // this is required to terminate immediately and return a proper response

}

?>
