jQuery(document).ready(function($) {

    function validateEmail(email) {
      var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
      return re.test(email);
    }

    $('.select2').select2();
    $(".select2-email-tags").select2({
        tags: true,
        tokenSeparators: [',', ' '],
        placeholder: "Email Address",
        createTag: function (params) {
        // Don't offset to create a tag if there is no @ symbol
        if (!validateEmail(params.term)) {
          // Return null to disable tag creation
          return null;
        }

        return {
          id: params.term,
          text: params.term
        }
      }
    });

    $(".select2-phrases-tags").select2({
        tags: true,
        placeholder: "Word or phrase to be banned. Press enter to complete phrase.",

    });

    $('.data-table').DataTable();
    $('.data-table').on('click', 'a.remove', function(e) {

        var r = confirm("Are you sure you want to remove this entry?");
        if (r == true) {
            var _this   = $(this);
            var _id     = _this.data('id');
            var _row    = $('#row-'+_id);
            var _pre    = _row.prev('tr');
            var _tbl    = _row.parent().parent();
            var table   = _tbl.DataTable();
            
            var data = {
                'action': 'w3dev_delete_banned_login',
                'id': _id
            };

            $.post(ajaxurl, data, function(response) { 
                _this.notify(
                "Banned entry has been removed.",
                "success",
                { position:"left" }
                );
                _this.removeClass('remove');
                setTimeout(function(){ table.row(_row).remove().draw(); }, 3000);
            }); 

        }

    });

});
