jQuery(document).ready(function($) {

    $('.SlectBox').SumoSelect();

    $('.js-info-popup').on('click', function(e) {
        e.preventDefault();
        $.dialog({
            title: 'Plugin Information',
            content: `
            <h3 style="margin-bottom:10px;padding-bottom:0;line-height: 1.3em;">Accessibility Options</h3>
            <p style="font-size:14px;margin:0;padding:0;"><strong>Optimise plugin for accessibility / screen readers</strong> - Enable the Accessibility checkbox to improve support for screen readers. The plugin will default to text links instead of icons for improved accessibility.</p>
            <h3 style="margin-bottom:10px;padding-bottom:0;line-height: 1.3em;">Free API Key</h3>
            <p style="font-size:14px;margin:0;padding:0;"><strong>Your API Key</strong> - Why do I need an API Key? We've introduced an API Key in order to deliver enhanced services, such as our new W3-IP Lookup API.</p>
            <h3 style="margin-bottom:10px;padding-bottom:0;line-height: 1.3em;">General Options</h3>
            <p style="font-size:14px;margin:0;padding:0;"><strong>Set custom redirection url after forcing user to logout</strong> - When forcing a user to logout the custom redirection url allows you to set which url they should be redirect to. For instance to a notification page, or back to the site's main login url. This option is especially important if your WordPress setup doesn't use the default wp-login.php page.</p>
            <h3 style="margin-bottom:10px;padding-bottom:0;line-height: 1.3em;">Ban & Unban Options</h3>
            <p style="font-size:14px;margin:0;padding:0;"><strong>Change the user's posts status when banned</strong> - (i.e. select draft to hide posts from showing on blog)</p>

            <h3 style="margin-bottom:10px;padding-bottom:0;line-height: 1.3em;">Default Messages</h3>
            <p style="font-size:14px;margin:0;padding:0;"><strong>Message to display when a banned user attempts to login</strong> - Note: following tags can be used if required: %%reason%% and %%unban_date%%</p>
            <p style="font-size:14px;margin:0;padding:0;"><strong>Message to display when user has been banned, whilst logged in, and attempts to access restricted content</strong> - Note: following tags can be used if required: %%reason%% and %%unban_date%%</p>

            `,
            boxWidth: '500px',
            useBootstrap: false,
        });
    });

    $('#w3dev-table-banned-users').on('click', '.js-unban-user', function(e) {

        var _this = $(this);
        _this.addClass('success');
        var _user_id   = _this.data('user-id');

        _this.find('.fa-stack-1x').removeClass('fa-ban').addClass('fa-spinner fa-spin fa-fw');
       
        var _row    = $('#w3dev-table-banned-users').find('#row-'+_user_id);
        var _pre    = _row.prev('tr');
        var _tbl    = _row.parent().parent();
        var table   = _tbl.DataTable();

        var data = {
            'action': 'w3dev_quick_unban_user',
            'user_id': _user_id
        };

        $.post(ajaxurl, data, function(response) {

            setTimeout(function(){ 

                _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-check');
                setTimeout(function(){ table.row(_row).remove().draw(); }, 3000);

            }, 250);

        });
       
    });

    $('table.wp-list-table.users').on('click', '.js-w3dev-device-info', function(e) {
        e.preventDefault();
        var _user_id = $(this).data('user-id');
        if (_user_id) {
            $.dialog({
                title: 'Device Information',
                theme: 'material',
                scrollToPreviousElement: false,
                content: function () {
                    var self = this;

                    return $.ajax({
                        url: ajaxurl,
                        method: 'post',
                        data : {action: "w3dev_device_information", user_id: _user_id}
                    }).done(function (response) {

                        
/*
                        $('.js-view-notes').on('click', function(e) {
                            alert('hi');
                            e.preventDefault();
                            $('.device-notes').show();
                            $('.device-information').hide();
                        });
*/

                        //setTimeout(function(){ self.setContent(response); }, 250);
                        //self.setContentAppend('<br>Version: ');
                        //self.setTitle('Device Information');

                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                contentLoaded: function(data, status, xhr){
                    var self = this;
                    if (status == 'success') {
                        self.setContent(data);                           
                    }
                },
                onContentReady: function () {

                    var self = this;
                    var _test = self.$content.find('.js-view-notes');
                        _test.on('click', function(e) {
                            e.preventDefault();
                            $('.device-notes').show();
                            $('.device-information').hide();
                        });

                },
                boxWidth: '500px',
                useBootstrap: false,
            });
        }
    });

    $('table.wp-list-table.users').on('click', '.js-w3dev-user-history', function(e) {
        e.preventDefault();
        var _user_id = $(this).data('user-id');
        if (_user_id) {
            $.dialog({
                title: 'User Login History',
                theme: 'material',
                scrollToPreviousElement: false,
                content: function () {
                    var self = this;

                    return $.ajax({
                        url: ajaxurl,
                        method: 'post',
                        data : {action: "w3dev_user_history", user_id: _user_id}
                    }).done(function (response) {
                        
                        //setTimeout(function(){ self.setContent(response); }, 250);
                        //self.setContentAppend('<br>Version: ');
                        //self.setTitle('Device Information');

                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                contentLoaded: function(data, status, xhr){
                    var self = this;
                    if (status == 'success') {
                        self.setContent(data);                           
                    }
                },
                boxWidth: '500px',
                useBootstrap: false,
            });
        }
    });

    $('table.wp-list-table.users').on('click', '.js-w3dev-shared-accounts', function(e) {
        e.preventDefault();
        var _user_id = $(this).data('user-id');
        if (_user_id) {
            $.dialog({
                title: 'Shared Accounts',
                theme: 'material',
                scrollToPreviousElement: false,
                content: function () {
                    var self = this;

                    return $.ajax({
                        url: ajaxurl,
                        method: 'post',
                        data : {action: "w3dev_shared_accounts", user_id: _user_id}
                    }).done(function (response) {
                        
                        //setTimeout(function(){ self.setContent(response); }, 250);
                        //self.setContentAppend('<br>Version: ');
                        //self.setTitle('Device Information');

                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                contentLoaded: function(data, status, xhr){
                    var self = this;
                    if (status == 'success') {
                        self.setContent(data);                           
                    }
                },
                boxWidth: '500px',
                useBootstrap: false,
            });
        }
    });

    $('table.wp-list-table.users').on('click', '.js-w3dev-banned-history', function(e) {
        e.preventDefault();
        var _user_id = $(this).data('user-id');
        if (_user_id) {
            $.dialog({
                title: 'Banned History',
                theme: 'material',
                scrollToPreviousElement: false,
                content: function () {
                    var self = this;

                    return $.ajax({
                        url: ajaxurl,
                        method: 'post',
                        data : {action: "w3dev_banned_history", user_id: _user_id}
                    }).done(function (response) {
                        
                        //setTimeout(function(){ self.setContent(response); }, 250);
                        //self.setContentAppend('<br>Version: ');
                        //self.setTitle('Device Information');

                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                contentLoaded: function(data, status, xhr){
                    var self = this;
                    if (status == 'success') {
                        self.setContent(data);                           
                    }
                },
                boxWidth: '500px',
                useBootstrap: false,
            });
        }
    });


    $('.jmask-hhmm').mask('00:00');

    $('.w3dev-mjs-from-now').each(function (index, value) { 
      var _date = $(this).text();
      var _fromnow = moment(_date, "DD-MM-YYYY H:m:s").fromNow();
      $(this).text(_fromnow);
    });

    $('.w3dev-settings-section h3').on('click', function(e) {
        var _this = $(this);
        _this.find('.w3dev-toggle-content i').toggleClass('fa-caret-down fa-caret-up');
        
        var _parent = _this.parent();
        var _parent_child = _parent.find('.w3dev-content');
        
        if (_parent.hasClass('closed')) {
            _parent.removeClass('closed');
            _parent_child.css('visibility', 'visible');
        } else {
            _parent.addClass('closed');
            _parent_child.css('visibility', 'hidden');
        }
        _parent_child.slideToggle('fast');
    });

    var _users_table = $('table.wp-list-table.users');
    if (_users_table.length > 0) {
        var rows = _users_table.find('> tbody > tr');
        $.each( rows, function( index, value ){
            if ($(this).find('span.banned-user.row-highlight').length > 0) {
                $(this).addClass('w3dev-banned-user-row');
            }
        });
 
    }

    $("#w3dev-js-scrollto-section").on('click', 'a', function(e) {
        var _target = $(this).attr('href');

        $(_target).removeClass('closed');
        $(_target).find('.w3dev-content').css('visibility', 'visible').slideDown('fast')
        $(_target).find('.w3dev-toggle-content i').addClass('fa-caret-down').removeClass('fa-caret-up');

        e.preventDefault();
        $('html, body').animate({
            scrollTop: $(_target).offset().top-60
        }, 1000);
    });

    
    $(".w3dev-back-to-top").on('click', function(e) {
        var _target = $(this).attr('href');
        e.preventDefault();
        $('html, body').animate({
            scrollTop: $(_target).offset().top-60
        }, 1000);
    });

    $('.toggle-ban-user').on('click', function(e) {

        var _this           = $(this);
        var _user_ban       = _this.hasClass('active');
        var _user_id        = _this.data('user-id');
        var _custom_email   = _this.data('ban-email');
        var _now            = moment().format("DD-MM-YYYY");
        var _unban_date     = $('#input-w3dev-unban\\ ' + _user_id).val(); // Double slash to allow for space
        var _accessibility  = _this.hasClass('w3dev-accessibility');
        var _user_row       = $('#user-' + _user_id);
        
        _this.parent().parent().addClass('visible');

        var _flatpickr;

        if (typeof _user_ban === 'undefined') { 
            return;
        } else if(!_user_ban) {

            _this.addClass('active');
            if ( _custom_email != 0) {

                var jc = $.confirm({
                    title: '<i class="fa fa-ban"></i> Ban User',
                    theme: 'material',
                    scrollToPreviousElement: false,
                    content: function () {
                        var self = this;

                        return $.ajax({
                            url: ajaxurl,
                            method: 'post',
                            dataType: 'html',
                            data : {action: "w3dev_ban_user", user_id: _user_id}
                        }).done(function (response) {
                            
                            // setTimeout(function(){ self.setContent(response); }, 250);
                            //self.setContentAppend('<br>Version: ');
                            //self.setTitle('Device Information');

                        }).fail(function(){
                            self.setContent('Something went wrong.');
                        });
                    },
                    useBootstrap: false,
                    boxWidth: '400px',
                    contentLoaded: function(data, status, xhr){
                        var self = this;
                        if (status == 'success') {
                            self.setContent(data);                           
                        }
                    },
                    onContentReady: function () {
                        $('select.selectric').selectric();
                        $("#input-w3dev-unban-date").flatpickr({ enableTime: true, enable: [{ from: new Date().fp_incr(0), to: new Date().fp_incr(7 * 366 * 100) }], });
                        $('#input-w3dev-ban-duration').on('change', function(e) {
                            var _option = $(this).val();
                            if ( _option == 'date picker' ) {
                                $("#w3dev-dtp-wrapper").show();
                                //$('.jconfirm-buttons').find('.w3dev-bb-date-picker').removeClass('hide');
                            } else {
                                $("#w3dev-dtp-wrapper").hide();
                                //$('.jconfirm-buttons').find('.w3dev-bb-date-picker').addClass('hide');
                            }
                        });
                    },
                    buttons: {
                        calendar: {
                            text: '<i class="fa fa-calendar" aria-hidden="true"></i>',
                            btnClass: 'btn-blue pull-left w3dev-bb-date-picker hide datepicker',
                            action: function(){

                                return false;

                            }
                        },
                        cancel: {
                            text: 'Cancel',
                            action: function(){
                                _this.parent().parent().removeClass('visible');
                                _this.removeClass('active'); 
                            }
                        },
                        send: {
                            text: 'Send',
                            btnClass: 'btn-red',
                            action: function(){

                                var _this_btn = this.$$send;
                                _this_btn.prev('button').remove();
                                _this_btn.html('<i class="fa fa-spinner fa-spin fa-fw" aria-hidden="true"></i> SENDING');

                                var _message = $('#jconfirm-ban-user').find('textarea').val();
                                var _ban_duration = $('#input-w3dev-ban-duration').val();
                                if ($('#input-ban-last-known-ip:enabled').is(':checked')) {
                                    var _ban_last_known_ip = 1;
                                } else {
                                    var _ban_last_known_ip = 0;
                                }

                                if($('#input-ban-hide-avatar').is(':checked'))
                                    var _ban_hide_avatar = 1;
                                else
                                    var _ban_hide_avatar = 0;

                                if ( _ban_duration == "date picker") _unban_date = $('#input-w3dev-unban-date').val();
                                if ( _ban_hide_avatar )  $('#user-' + _user_id).find('.avatar').attr('src', '//:0');

                                _this.find('.fa-stack-1x').removeClass('fa-ban').addClass('fa-spinner fa-spin fa-fw');
                                var data = {
                                    'action': 'w3dev_toggle_ban_user',
                                    'user_id':              _user_id,
                                    'message':              _message,
                                    'ban_last_known_ip':    _ban_last_known_ip,
                                    'ban_hide_avatar':      _ban_hide_avatar,
                                    'unban_date':           _unban_date,
                                    'ban_duration':         _ban_duration
                                };

                                $.post(ajaxurl, data, function(response) {

                                    _this_btn.html('<i class="fa fa-check" aria-hidden="true"></i> SENT');
                                    var _class = (response == 'banned') ? 'active' : '';
                                    _user_row.find('.w3dev-banned-status').attr('data-balloon','Banned: ' + _now).addClass('active row-highlight');

                                    // check for accessibility
                                    // --
                                    if (_accessibility) {
                                        
                                        _this.removeClass('active').addClass(_class).html('UnBan User');
                                        _user_row.addClass('w3dev-banned-user-row');
                                        alert('User has been banned.')

                                    } else {

                                        _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-ban');
                                        _this.removeClass('active').addClass(_class);
                                        _user_row.addClass('w3dev-banned-user-row');
                                        _user_row.find('.warn-ban-user,.icon-ban-date-user').addClass('hide');
                                        
                                    }

                                    _this_btn.unbind('click');

                                    setTimeout(function(){ 
                                        _this.parent().parent().removeClass('visible');
                                        _this.addClass('active'); 
                                        jc.close(); 
                                    }, 1250);

                                }); 

                                return false;

                            }
                        }
                    }
                });

            } else {

                // check for accessibility
                // --
                if (!_accessibility) { 
                    _this.find('.fa-stack-1x').removeClass('fa-ban').addClass('fa-spinner fa-spin fa-fw');
                }

                var data = {
                    'action': 'w3dev_toggle_ban_user',
                    'user_id': _user_id,
                    'message': '',
                    'unban_date': _unban_date,
                };

                $.post(ajaxurl, data, function(response) {

                    _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-ban');
                    _this.removeClass('active');

                    var _user_row = $('#user-' + _user_id);
                    _user_row.addClass('w3dev-banned-user-row');
                    _user_row.find('.warn-ban-user,.icon-ban-date-user').addClass('hide');
                    _user_row.find('.w3dev-banned-status').attr('data-balloon','Banned: ' + _now).addClass('active row-highlight');

                    // check for accessibility
                    // --
                    if (_accessibility) { 
                        _this.addClass('active').html('UnBan User');
                        alert('User has been banned.');
                    } else {
                        _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-ban');
                        _this.addClass('active'); 
                    }

                    _this.parent().parent().removeClass('visible');

                }); 

            }

        } else {

            // check for accessibility
            // --
            if (!_accessibility) { 
                _this.find('.fa-stack-1x').removeClass('fa-ban').addClass('fa-spinner fa-spin fa-fw');
            }

            _this.removeClass('active');
            var data = {
                'action': 'w3dev_toggle_ban_user',
                'user_id': _user_id,
                'message': "",
                'unban_date': _unban_date,
            };

            $.post(ajaxurl, data, function(response) {
                response = JSON.parse(response);

                _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-ban');
                var _class = (response.ban == 'banned') ? 'active' : '';
                _this.removeClass('active').addClass(_class);
                _user_row.removeClass('w3dev-banned-user-row');
                _user_row.find('.warn-ban-user,.icon-ban-date-user').removeClass('hide');
                _user_row.find('.w3dev-banned-status').attr('data-balloon','Reinstated: ' + _now).removeClass('active row-highlight');

                //Show avatar
                $('#user-' + _user_id).find('.avatar').attr('src', response.src);

                // check for accessibility
                // --
                if (_accessibility) {
                    _this.removeClass('active').html('Ban User');
                    alert('User has been unbanned.');
                } else {
                    _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-ban');
                    _this.removeClass('active');
                }

                _this.parent().parent().removeClass('visible');

            });

        }

    });


    $('.warn-ban-user').on('click', function(e) {

        var _this           = $(this);
        var _user_id        = _this.data('user-id');
        var _reason         = _this.data('allow-reason');
        var _accessibility  = _this.hasClass('w3dev-accessibility');

        _this.addClass('active');
        _this.parent().parent().addClass('visible');

        if ( _reason != 0) {

            var jc = $.confirm({
                title: '<i class="fa fa-exclamation-triangle"></i> Warn User',
                scrollToPreviousElement: false,
                content: function () {
                    var self = this;

                    return $.ajax({
                        url: ajaxurl,
                        method: 'post',
                        dataType: 'html',
                        data : {action: "w3dev_warn_user", user_id: _user_id}
                    }).done(function (response) {
                        
                        // setTimeout(function(){ self.setContent(response); }, 250);
                        //self.setContentAppend('<br>Version: ');
                        //self.setTitle('Device Information');

                    }).fail(function(){
                        self.setContent('Something went wrong.');
                    });
                },
                useBootstrap: false,
                boxWidth: '400px',
                contentLoaded: function(data, status, xhr){
                    var self = this;
                    if (status == 'success') {
                        self.setContent(data);                           
                    }
                },
                buttons: {
                    cancel: {
                        text: 'Cancel',
                        action: function(){
                            _this.parent().parent().removeClass('visible');
                            _this.removeClass('active');
                        }
                    },
                    send: {
                        text: 'Send',
                        btnClass: 'btn-orange',
                        action: function(){

                            var _this_btn = this.$$send;
                            _this_btn.prev('button').remove();
                            _this_btn.html('<i class="fa fa-spinner fa-spin fa-fw" aria-hidden="true"></i> SENDING');

                            var _reason = $('#jconfirm-warn-user').find('textarea').val();
                            _this.find('.fa-stack-1x').removeClass('fa-exclamation-triangle').addClass('fa-spinner fa-spin fa-fw');
                            var data = {
                                'action': 'w3dev_warn_ban_user',
                                'user_id': _user_id,
                                'reason': _reason
                            };

                            $.post(ajaxurl, data, function(response) {
                                _this_btn.html('<i class="fa fa-check" aria-hidden="true"></i> SENT');

                                // check for accessibility
                                // --
                                if (!_accessibility) {
                                    _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-exclamation-triangle');
                                } else {
                                    alert('Email has been sent. User has been warned.');
                                }
 
                                setTimeout(function(){ 
                                    _this.parent().parent().removeClass('visible');
                                    _this.removeClass('active'); 
                                    jc.close(); 
                                }, 1250);

                            });

                            return false;

                        }
                    }
                }
            });

        } else {

            // check for accessibility
            // --
            if (!_accessibility) {
                _this.find('.fa-stack-1x').removeClass('fa-exclamation-triangle').addClass('fa-spinner fa-spin fa-fw');
            }

            var data = {
                'action': 'w3dev_warn_ban_user',
                'user_id': _user_id,
                'reason': _reason,
            };

            $.post(ajaxurl, data, function(response) {

                // check for accessibility
                // --
                if (!_accessibility) {
                    _this.find('.fa-stack-1x').removeClass('fa-spinner fa-spin fa-fw').addClass('fa-exclamation-triangle');
                } else {
                    alert('Email has been sent. User has been warned.');
                }

                _this.removeClass('active');
                _this.parent().parent().removeClass('visible');

            });

        }

    });

    $('.multi-user').on('click', function(e) {

        var _this               = $(this);
        var _user_id            = _this.data('user-id');
        var _textarea_content   = _this.data('textarea-content');
        var _accessibility      = _this.hasClass('w3dev-accessibility');

        _this.addClass('active');
        _this.parent().parent().addClass('visible');


        var jc = $.confirm({
            title: '<i class="fa fa-user-plus"></i> Shared account',
            scrollToPreviousElement: false,
            content: '<div id="jconfirm-warn-user"><p>This user account appears to be shared, as access has been aquired from multiple ip addresses, across multiple locations.</p><textarea name="">'+_textarea_content+'</textarea></div>',
            useBootstrap: false,
            boxWidth: '400px',
            buttons: {
                cancel: {
                    text: 'Close',
                    action: function(){
                        _this.parent().parent().removeClass('visible');
                        _this.removeClass('active');
                    }
                }
            }
        });

    });

    $('#input-w3dev-ban-user').on('change', function(e) {
        var _this       = $(this);
        if ( _this.is(':checked') && $('#w3dev-ban-checked').val() != 0 ) {
            var message = prompt("What is the reason for banning this user?", "");
            if( !Boolean(message) ) {
                _this.prop('checked', false);
                return; 
            }

            $('#w3dev-ban-reason').val(message);
         } else
            $('#w3dev-ban-reason').val("");

        if( _this.is(':checked') ) {
            $('#js-w3dev-unban-date').show();
            $('#js-w3dev-hide-avatar').show();
        } else {
            $('#js-w3dev-unban-date').hide();   
            $('#js-w3dev-hide-avatar').hide();
        }

        e.preventDefault();
    });

    /*
    $('#input-ban-email').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-ban-email-default').show();

            if ($('#input-ban-email-default').is(':checked'))
                $('#js-ban-email-message').hide();
            else
                $('#js-ban-email-message').show();

        } else {
            $('#js-ban-email-default').hide();
            $('#js-ban-email-message').hide();
        }
        e.preventDefault();
    });
    */
    $('#input-ban-email-default').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) 
            $('#js-ban-email-message').hide();
        else
            $('#js-ban-email-message').show();
        e.preventDefault();
    });

    $('#input-change-status').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-post-status').show();
        } else {
            $('#js-post-status').hide();
            $('#input-post-status').val('');
        }
        e.preventDefault();
    });
    $('#input-on-ban-change-user-role').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-set-banned-user-role').show();
        } else {
            $('#js-set-banned-user-role').hide();
            $('#input-set-banned-user-role').val('');
        }
        e.preventDefault();
    });
    $('#input-on-unban-change-user-role').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-set-unbanned-user-role').show();
        } else {
            $('#js-set-unbanned-user-role').hide();
            $('#input-set-unbanned-user-role').val('');
        }
        e.preventDefault();
    });
    $('#input-security-block-bad-bot').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-redirect-bad-bot').show();
        } else {
            $('#js-redirect-bad-bot').hide();
        }
        e.preventDefault();
    });

    $('#input-force-logout').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-display-message-extras').hide();
        } else {
            $('#js-display-message-extras').show();
        }
        e.preventDefault();
    });

    $('#input-display-message').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-display-message-extras').show();
        } else {
            $('#js-display-message-extras').hide();
        }
        e.preventDefault();
    });

    $('#input-custom-logout').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-custom-logout-url').show();
        } else {
            $('#js-custom-logout-url').hide();
        }
        e.preventDefault();
    });

    $('#input-warn-user').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-warn-user-reason').show();
        } else {
            $('#js-warn-user-reason').hide();
        }
        e.preventDefault();
    });

    $('#input-frontend-notification-force-logout').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#input-frontend-notification-hide').prop('checked', false).attr("disabled", true);
        } else {
            $('#input-frontend-notification-hide').removeAttr("disabled");
        }
        e.preventDefault();
    });

    $('#input-security-hide-wp-login-messages').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-security-ambiguous-error-messages').show();
        } else {
            $('#js-security-ambiguous-error-messages').hide();
        }
         
        e.preventDefault();
    });

    $('#input-banned-keywords').on('change', function(e) {
        var _this = $(this);
        if (_this.is(':checked')) {
            $('#js-banned-words-and-phrases').show();
            $('#js-banned-words-email').show();
        } else {
            $('#js-banned-words-and-phrases').hide();
            $('#js-banned-words-email').hide();
        }
         
        e.preventDefault();
    });

    $('#w3dev-save-ban-user-settings').on('click', function(e) {

        var _this = $(this);
        _this.html('<i class="fa fa-spinner fa-spin fa-fw" aria-hidden="true"></i> Saving')
        
        // get input data
        // --
        var _change_posts_status                    = $('#input-change-status').is(':checked') ? 1 : 0;
        var _post_status                            = $('#input-post-status').val();
        var _on_ban_change_user_role                = $('#input-on-ban-change-user-role').is(':checked') ? 1 : 0;
        var _set_banned_user_role                   = $('#input-set-banned-user-role').val();
        var _on_unban_change_user_role              = $('#input-on-unban-change-user-role').is(':checked') ? 1 : 0;
        var _set_unbanned_user_role                 = $('#input-set-unbanned-user-role').val();

        var _display_message                        = $('#input-display-message').is(':checked') ? 1 : 0;
        var _custom_message                         = $('#input-custom-message').val();
        var _force_logout                           = $('#input-force-logout').is(':checked') ? 1 : 0;
        var _custom_logout                          = $('#input-custom-logout').is(':checked') ? 1 : 0;
        var _custom_logout_url                      = $('#input-custom-logout-url').val();
        var _close_panels                           = $('#input-close-panels').is(':checked') ? 1 : 0;
        var _ban_email                              = $('#input-ban-email').is(':checked') ? 1 : 0;
        var _ban_email_default                      = $('#input-ban-email-default').is(':checked') ? 1 : 0;
        var _ban_email_message                      = $('#input-ban-email-message').val();
        var _always_unban_ipaddress                 = $('#input-always-unban-ipaddress').is(':checked') ? 1 : 0;
        var _default_ban_ipaddress                  = $('#input-default-ban-ipaddress').is(':checked') ? 1 : 0;
        var _hide_banned_users_comments             = $('#input-hide-banned-users-comments').is(':checked') ? 1 : 0;
        var _scramble_banned_users_password         = $('#input-scramble-banned-users-password').is(':checked') ? 1 : 0;
        var _disable_password_reset_banned_users    = $('#input-disable-password-reset-banned-users').is(':checked') ? 1 : 0;
        var _set_spammer_option                     = $('#input-set-spammer-option').is(':checked') ? 1 : 0;
        var _unset_spammer_option                   = $('#input-unset-spammer-option').is(':checked') ? 1 : 0;
        var _default_ban_reason                     = $('#input-default-ban-reason').val();
        var _default_warn_reason                    = $('#input-default-warn-reason').val();

        var _users_tbl_last_seen                    = $('#input-users-tbl-last-seen').is(':checked') ? 1 : 0;
        var _users_tbl_row_highlighted              = $('#input-users-tbl-row-highlighted').is(':checked') ? 1 : 0;
        var _users_tbl_data_column                  = $('#input-users-tbl-data-column').is(':checked') ? 1 : 0;
        var _banned_login_message                   = $('#input-banned-login-message').val();
        var _denied_login_message                   = $('input[name=input-denied-login-message]').val();
        var _denied_bad_bot_message                 = $('input[name=input-denied-bad_bot-message]').val();
        var _non_admin_role_restriction_message     = $('input[name=input-non-admin-role-restriction-message]').val();
        var _admin_restricted_hours_message         = $('input[name=input-admin-restricted-hours-message]').val();

        var _date_format                            = $('#input-date-format').val();
        var _time_enable                            = $('#input-time-enable').is(':checked') ? 1 : 0;
        var _send_notification_new_post             = $('#input-send-notification-new-post').is(':checked') ? 1 : 0;
        var _notification_emails                    = $('#input-notification-emails').val();
        var _users_tbl_geoip_data_column            = $('#input-users-tbl-geoip-data-column').is(':checked') ? 1 : 0;
        var _capture_login_geoip_data               = $('#input-capture-login-geoip-data').is(':checked') ? 1 : 0;
        var _warn_user                              = $('#input-warn-user').is(':checked') ? 1 : 0;
        var _send_notification_new_post             = $('#input-send-notification-new-post').is(':checked') ? 1 : 0;
        var _notification_emails                    = $('#input-notification-emails').val();
        var _users_tbl_geoip_data_column            = $('#input-users-tbl-geoip-data-column').is(':checked') ? 1 : 0;
        var _warn_user_reason                       = $('#input-warn-user-reason').is(':checked') ? 1 : 0;
        var _frontend_banned_notification           = $('#input-frontend-banned-notification').is(':checked') ? 1 : 0;
        var _frontend_notification_force_logout     = $('#input-frontend-notification-force-logout').is(':checked') ? 1 : 0;
        var _frontend_notification_hide             = $('#input-frontend-notification-hide').is(':checked') ? 1 : 0;
        var _enable_accessibility                   = $('#input-enable-accessibility').is(':checked') ? 1 : 0;
        var _ip_api                                 = $('select[name=input-ip-api]').val();
        var _ip_api_request_method                  = $('#input-ip-api-request-method').val();
        var _device_detection_disabled              = $('input[name=input-device-detection-disabled]').is(':checked') ? 1 : 0;
        
        /* banned keywords feature */
        var _banned_content                         = $('#input-banned-content').is(':checked') ? 1 : 0;
        var _banned_content_title                   = $('#input-banned-content-title').is(':checked') ? 1 : 0;
        var _banned_content_email                   = $('#input-banned-content-email').is(':checked') ? 1 : 0;
        var _banned_content_occurances              = $('#input-banned-content-occurances').val();
        var _banned_content_level                   = $('#input-banned-content-level').val();
        var _banned_words_and_phrases               = $('#input-banned-words-and-phrases').val();
        var _banned_post_types                      = $('select[name=input-banned-post-types]').val();
       
        var _banned_usernames                       = $('#input-banned-usernames').val();
        var _banned_passwords                       = $('#input-banned-passwords').val();

        var _security_enable_admin_override         = $('input[name=input-enable-admin-override]').is(':checked') ? 1 : 0;
        var _security_set_moderator_roles           = $('input[name=input-security-set-moderator-roles]').is(':checked') ? 1 : 0;
        var _security_moderator_roles               = $('select[name=input-security-moderator-roles]').val();
        var _security_set_moderated_roles           = $('input[name=input-security-set-moderated-roles]').is(':checked') ? 1 : 0;
        var _security_moderated_roles               = $('select[name=input-security-moderated-roles]').val();
        
        var _security_deny_reg_no_useragent         = $('input[name=input-security-deny-reg-no-useragent]').is(':checked') ? 1 : 0;
        var _security_deny_reg_no_ipaddress         = $('input[name=input-security-deny-reg-no-ipaddress]').is(':checked') ? 1 : 0;
        var _security_deny_login_no_useragent       = $('input[name=input-security-deny-login-no-useragent]').is(':checked') ? 1 : 0;
        var _security_deny_login_no_ipaddress       = $('input[name=input-security-deny-login-no-ipaddress]').is(':checked') ? 1 : 0;
        var _security_auto_notify_new_ip            = $('input[name=input-security-auto-notify-new-ip]').is(':checked') ? 1 : 0;
        var _security_auto_notify_admin_login       = $('input[name=input-security-auto-notify-admin-login]').is(':checked') ? 1 : 0;
        var _security_disable_non_admin_logins      = $('input[name=input-security-disable-non-admin-logins]').is(':checked') ? 1 : 0;
        var _security_hide_wp_login_messages        = $('input[name=input-security-hide-wp-login-messages]').is(':checked') ? 1 : 0;
        var _security_ambiguous_error_messages      = $('input[name=input-security-ambiguous-error-messages]').val();
        var _security_block_bad_bot                 = $('input[name=input-security-block-bad-bot]').is(':checked') ? 1 : 0;
        var _security_redirect_bad_bot              = $('input[name=input-security-redirect-bad-bot]').val();
        var _security_disable_registrations         = $('input[name=input-security-disable-registrations]').is(':checked') ? 1 : 0;
        var _security_disable_comments              = $('input[name=input-security-disable-comments]').is(':checked') ? 1 : 0;

        var _logging_denied_logins                  = $('input[name=input-logging-denied-logins]').is(':checked') ? 1 : 0;
        var _logging_successful_logins              = $('input[name=input-logging-successful-logins]').is(':checked') ? 1 : 0;
        var _logging_banned_users                   = $('input[name=input-logging-banned-users]').is(':checked') ? 1 : 0;
        var _logging_user_warnings                  = $('input[name=input-logging-user-warnings]').is(':checked') ? 1 : 0;
        var _logging_denied_registrations           = $('input[name=input-logging-denied-registrations]').is(':checked') ? 1 : 0;
        var _logging_spam_preventations             = $('input[name=input-logging-spam-preventations]').is(':checked') ? 1 : 0;

        var _include_header_css                     = $('#input-include-header-css').is(':checked') ? 1 : 0;
        var _include_footer_js                      = $('#input-include-footer-js').is(':checked') ? 1 : 0;
        var _editor_css                             = editor_css.getValue();
        var _editor_js                              = editor_js.getValue();

        // extensions
        // --
        var _ext_ultimate_member                   = $('#input-ext-ultimate-member').is(':checked') ? 1 : 0;
        

        // autoloaders
        // --
        var _autoload_fa                            = $('#input-autoload-fa').is(':checked') ? 1 : 0;
        var _autoload_jq_confirm                    = $('#input-autoload-jq-confirm').is(':checked') ? 1 : 0;
        var _autoload_datatables                    = $('#input-autoload-datatables').is(':checked') ? 1 : 0;
        var _autoload_notify                        = $('#input-autoload-notify').is(':checked') ? 1 : 0;
        var _autoload_selectric                     = $('#input-autoload-selectric').is(':checked') ? 1 : 0;
        var _autoload_flatpickr                     = $('#input-autoload-flatpickr').is(':checked') ? 1 : 0;
        var _autoload_alertify                      = $('#input-autoload-alertify').is(':checked') ? 1 : 0;
        var _autoload_select2                       = $('#input-autoload-select2').is(':checked') ? 1 : 0;
        var _autoload_faanimation                   = $('#input-autoload-faanimation').is(':checked') ? 1 : 0;
        var _autoload_momentjs                      = $('#input-autoload-momentjs').is(':checked') ? 1 : 0;
        var _autoload_chartjs                       = $('#input-autoload-chartjs').is(':checked') ? 1 : 0;


        // restrict admin logins
        // --
        var _restrict_admin_mon                     = $('input[name=input-restrict-admin-login-mon]').is(':checked') ? 1 : 0;
        var _restrict_admin_tue                     = $('input[name=input-restrict-admin-login-tue]').is(':checked') ? 1 : 0;
        var _restrict_admin_wed                     = $('input[name=input-restrict-admin-login-wed]').is(':checked') ? 1 : 0;
        var _restrict_admin_thu                     = $('input[name=input-restrict-admin-login-thu]').is(':checked') ? 1 : 0;
        var _restrict_admin_fri                     = $('input[name=input-restrict-admin-login-fri]').is(':checked') ? 1 : 0;
        var _restrict_admin_sat                     = $('input[name=input-restrict-admin-login-sat]').is(':checked') ? 1 : 0;
        var _restrict_admin_sun                     = $('input[name=input-restrict-admin-login-sun]').is(':checked') ? 1 : 0;

        var _restrict_admin_mon_start               = $('input[name=input-admin-login-mon-start]').val();
        var _restrict_admin_tue_start               = $('input[name=input-admin-login-tue-start]').val();
        var _restrict_admin_wed_start               = $('input[name=input-admin-login-wed-start]').val();
        var _restrict_admin_thu_start               = $('input[name=input-admin-login-thu-start]').val();
        var _restrict_admin_fri_start               = $('input[name=input-admin-login-fri-start]').val();
        var _restrict_admin_sat_start               = $('input[name=input-admin-login-sat-start]').val();
        var _restrict_admin_sun_start               = $('input[name=input-admin-login-sun-start]').val();

        var _restrict_admin_mon_end                 = $('input[name=input-admin-login-mon-end]').val();
        var _restrict_admin_tue_end                 = $('input[name=input-admin-login-tue-end]').val();
        var _restrict_admin_wed_end                 = $('input[name=input-admin-login-wed-end]').val();
        var _restrict_admin_thu_end                 = $('input[name=input-admin-login-thu-end]').val();
        var _restrict_admin_fri_end                 = $('input[name=input-admin-login-fri-end]').val();
        var _restrict_admin_sat_end                 = $('input[name=input-admin-login-sat-end]').val();
        var _restrict_admin_sun_end                 = $('input[name=input-admin-login-sun-end]').val();

        var _debug_php                              = $('input[name=input-debug-php]').is(':checked') ? 1 : 0;

        var data = {
            'action':                               'w3dev_save_ban_user_settings',
            'change_posts_status':                  _change_posts_status,
            'post_status':                          _post_status,
            'on_ban_change_user_role':              _on_ban_change_user_role,
            'set_banned_user_role':                 _set_banned_user_role,
            'on_unban_change_user_role':            _on_unban_change_user_role,
            'set_unbanned_user_role':               _set_unbanned_user_role,
            'display_message':                      _display_message,
            'custom_message':                       _custom_message,
            'force_logout':                         _force_logout,
            'custom_logout':                        _custom_logout,
            'custom_logout_url':                    _custom_logout_url,
            'close_panels':                         _close_panels,
            'always_unban_ipaddress':               _always_unban_ipaddress,
            'default_ban_ipaddress':                _default_ban_ipaddress,
            'unban_date':                           1,
            'ban_email':                            _ban_email,
            'ban_email_default':                    _ban_email_default,
            'ban_email_default_message':            _ban_email_message,
            'hide_banned_users_comments':           _hide_banned_users_comments,
            'scramble_banned_users_password':       _scramble_banned_users_password,
            'disable_password_reset_banned_users':  _disable_password_reset_banned_users,
            'set_spammer_option':                   _set_spammer_option,
            'unset_spammer_option':                 _unset_spammer_option, 
            'default_ban_reason':                   _default_ban_reason, 
            'default_warn_reason':                  _default_warn_reason,
            'users_tbl_last_seen':                  _users_tbl_last_seen,
            'users_tbl_row_highlighted':            _users_tbl_row_highlighted,
            'users_tbl_data_column':                _users_tbl_data_column,
            'banned_login_message':                 _banned_login_message,
            'denied_login_message':                 _denied_login_message,
            'denied_bad_bot_message':               _denied_bad_bot_message,
            'non_admin_role_restriction_message':   _non_admin_role_restriction_message,
            'admin_restricted_hours_message':       _admin_restricted_hours_message,
            'date_format':                          _date_format,
            'time_enable':                          _time_enable,
            'send_notification_new_post':           _send_notification_new_post,
            'notification_emails':                  _notification_emails,
            'users_tbl_geoip_data_column':          _users_tbl_geoip_data_column,
            'capture_login_geoip_data':             _capture_login_geoip_data,
            'warn_user':                            _warn_user,
            'warn_user_reason':                     _warn_user_reason,
            'frontend_banned_notification':         _frontend_banned_notification,
            'frontend_notification_force_logout':   _frontend_notification_force_logout,
            'frontend_notification_hide':           _frontend_notification_hide,
            'enable_accessibility':                 _enable_accessibility,
            'ip_api':                               _ip_api,
            'ip_api_request_method':                _ip_api_request_method,
            'device_detection_disabled':            _device_detection_disabled,
            'banned_content':                       _banned_content,
            'banned_content_title':                 _banned_content_title,
            'banned_content_email':                 _banned_content_email,
            'banned_content_occurances':            _banned_content_occurances,
            'banned_content_level':                 _banned_content_level,
            'banned_words_and_phrases':             _banned_words_and_phrases,
            'banned_usernames':                     _banned_usernames,
            'banned_passwords':                     _banned_passwords,
            'banned_post_types':                    _banned_post_types, 
            'security_enable_admin_override':       _security_enable_admin_override,
            'security_set_moderator_roles':         _security_set_moderator_roles,
            'security_moderator_roles':             _security_moderator_roles,
            'security_set_moderated_roles':         _security_set_moderated_roles,
            'security_moderated_roles':             _security_moderated_roles,
            'security_deny_reg_no_useragent':       _security_deny_reg_no_useragent,
            'security_deny_reg_no_ipaddress':       _security_deny_reg_no_ipaddress,    
            'security_deny_login_no_useragent':     _security_deny_login_no_useragent,
            'security_deny_login_no_ipaddress':     _security_deny_login_no_ipaddress,
            'security_auto_notify_new_ip':          _security_auto_notify_new_ip,
            'security_auto_notify_admin_login':     _security_auto_notify_admin_login,
            'security_disable_non_admin_logins':    _security_disable_non_admin_logins,
            'security_hide_wp_login_messages':      _security_hide_wp_login_messages,
            'security_ambiguous_error_messages':    _security_ambiguous_error_messages,
            'security_block_bad_bot':               _security_block_bad_bot,
            'security_redirect_bad_bot':            _security_redirect_bad_bot,
            'security_disable_registrations':       _security_disable_registrations,
            'security_disable_comments':            _security_disable_comments,
            'editor_css':                           _editor_css,
            'editor_js':                            _editor_js,
            'inc_header_css':                       _include_header_css,
            'inc_footer_js':                        _include_footer_js,
            'ext_ultimate_member':                  _ext_ultimate_member,
            'autoload_fa':                          _autoload_fa,
            'autoload_jq_confirm':                  _autoload_jq_confirm,
            'autoload_datatables':                  _autoload_datatables,
            'autoload_notify':                      _autoload_notify,
            'autoload_selectric':                   _autoload_selectric,
            'autoload_flatpickr':                   _autoload_flatpickr,
            'autoload_alertify':                    _autoload_alertify,
            'autoload_select2':                     _autoload_select2,
            'autoload_faanimation':                 _autoload_faanimation,
            'autoload_momentjs':                    _autoload_momentjs,
            'autoload_chartjs':                     _autoload_chartjs,
            'restrict_admin_mon':                   _restrict_admin_mon,
            'restrict_admin_tue':                   _restrict_admin_tue,
            'restrict_admin_wed':                   _restrict_admin_wed,
            'restrict_admin_thu':                   _restrict_admin_thu,
            'restrict_admin_fri':                   _restrict_admin_fri,
            'restrict_admin_sat':                   _restrict_admin_sat,
            'restrict_admin_sun':                   _restrict_admin_sun,

            'restrict_admin_mon_start':             _restrict_admin_mon_start,
            'restrict_admin_tue_start':             _restrict_admin_tue_start,
            'restrict_admin_wed_start':             _restrict_admin_wed_start,
            'restrict_admin_thu_start':             _restrict_admin_thu_start,
            'restrict_admin_fri_start':             _restrict_admin_fri_start,
            'restrict_admin_sat_start':             _restrict_admin_sat_start,
            'restrict_admin_sun_start':             _restrict_admin_sun_start,

            'restrict_admin_mon_end':               _restrict_admin_mon_end,
            'restrict_admin_tue_end':               _restrict_admin_tue_end,
            'restrict_admin_wed_end':               _restrict_admin_wed_end,
            'restrict_admin_thu_end':               _restrict_admin_thu_end,
            'restrict_admin_fri_end':               _restrict_admin_fri_end,
            'restrict_admin_sat_end':               _restrict_admin_sat_end,
            'restrict_admin_sun_end':               _restrict_admin_sun_end,

            'logging_denied_logins':                _logging_denied_logins,
            'logging_successful_logins':            _logging_successful_logins,
            'logging_banned_users':                 _logging_banned_users,
            'logging_user_warnings':                _logging_user_warnings,
            'logging_denied_registrations':         _logging_denied_registrations, 
            'logging_spam_preventations':           _logging_spam_preventations,

            'debug_php':                            _debug_php,

        };

        $.post(ajaxurl, data, function(response) {

            // get input data
            // --
            var _enable_reg_ban_by_email                = $('#input-enable-reg-ban-by-email').is(':checked') ? 1 : 0;
            var _enable_login_ban_by_email              = $('#input-enable-login-ban-by-email').is(':checked') ? 1 : 0;
            var _enable_reg_ban_by_ip                   = $('#input-enable-reg-ban-by-ip').is(':checked') ? 1 : 0;
            var _enable_login_ban_by_ip                 = $('#input-enable-login-ban-by-ip').is(':checked') ? 1 : 0;
            var _enable_reg_ban_by_countrycode          = $('#input-enable-reg-ban-by-countrycode').is(':checked') ? 1 : 0;
            var _enable_login_ban_by_countrycode        = $('#input-enable-login-ban-by-countrycode').is(':checked') ? 1 : 0;
            var _enable_reg_ban_failed_country_check    = $('#input-enable-reg-ban-failed-country-checked').is(':checked') ? 1 : 0;

            var data = {
                'action':                               'w3dev_save_registration_ban_options',
                'enable_reg_ban_by_email':              _enable_reg_ban_by_email,
                'enable_login_ban_by_email':            _enable_login_ban_by_email,  
                'enable_reg_ban_by_ip':                 _enable_reg_ban_by_ip,
                'enable_login_ban_by_ip':               _enable_login_ban_by_ip,
                'enable_reg_ban_by_countrycode':        _enable_reg_ban_by_countrycode,
                'enable_login_ban_by_countrycode':      _enable_login_ban_by_countrycode,
                'enable_reg_ban_failed_country_check':  _enable_reg_ban_failed_country_check          
            };

            $.post(ajaxurl, data, function(response) {
                _this.html('Save Settings');
                $('#js-save-message').fadeIn().delay(2500).fadeOut();
            }); 

        });

        e.preventDefault();

    });

    $('#js-save-message').find('a.close').on('click', function(e) {
        $('#js-save-message').stop().fadeOut();
        e.preventDefault();
    });

    $('#w3dev-save-ban-email-template').on('click', function(e) {

        var _this = $(this);
        _this.html('<i class="fa fa-spinner fa-spin fa-fw" aria-hidden="true"></i> Saving');

        var _w3dev_ban_subject_title            = $('#input-ban-user-subject-title').val();
        var _w3dev_ban_email_template           = tinyMCE.get('ban_editor').getContent();
        var _w3dev_ban_cc_field                 = $('#input-ban-user-cc-field').val();
        var _w3dev_ban_bcc_field                = $('#input-ban-user-bcc-field').val();

        var _w3dev_unban_subject_title          = $('#input-unban-user-subject-title').val();
        var _w3dev_unban_email_template         = tinyMCE.get('unban_editor').getContent();
        var _w3dev_unban_indefinite_date_tag    = $('#input-unban-indefinite-date-tag').val();
        var _w3dev_unban_cc_field               = $('#input-unban-user-cc-field').val();
        var _w3dev_unban_bcc_field              = $('#input-unban-user-bcc-field').val();

        var _w3dev_warn_subject_title           = $('#input-warn-user-subject-title').val();
        var _w3dev_warn_email_template          = tinyMCE.get('warn_editor').getContent();
        var _w3dev_warn_cc_field                = $('#input-warn-user-cc-field').val();
        var _w3dev_warn_bcc_field               = $('#input-warn-user-bcc-field').val();

        var _w3dev_admin_login_subject_title    = $('#input-admin-login-subject-title').val();
        var _w3dev_admin_login_email_template   = tinyMCE.get('admin_login_editor').getContent();

        var data = {
            'action':                       'w3dev_save_ban_email_template',
            'ban_subject_title':            _w3dev_ban_subject_title,
            'ban_body':                     _w3dev_ban_email_template,
            'ban_cc_field':                 _w3dev_ban_cc_field,
            'ban_bcc_field':                _w3dev_ban_bcc_field,

            'unban_subject_title':          _w3dev_unban_subject_title,
            'unban_body':                   _w3dev_unban_email_template,
            'unban_cc_field':               _w3dev_unban_cc_field,
            'unban_bcc_field':              _w3dev_unban_bcc_field,
            'unban_indefinite_date_tag':    _w3dev_unban_indefinite_date_tag,

            'warn_subject_title':           _w3dev_warn_subject_title,
            'warn_body':                    _w3dev_warn_email_template,
            'warn_cc_field':                _w3dev_warn_cc_field,
            'warn_bcc_field':               _w3dev_warn_bcc_field,

            'admin_login_subject_title':    _w3dev_admin_login_subject_title,
            'admin_login_body':             _w3dev_admin_login_email_template,
        };

        $.post(ajaxurl, data, function(response) {
            _this.html('Save Template');
            $('#js-save-message').fadeIn().delay(2500).fadeOut();
        }); 
        e.preventDefault();
    });

    $('#w3dev-tabs li a').on('click', function(e) {

        var _this = $(this);
        var _tab = _this.data('tab');

        // hide all tabs
        // --
        $('.w3dev-tab').hide();

        $('#w3dev-tabs').find('li a').removeClass('active');
        _this.addClass('active');

        // show the selected tab
        // --
        $('#tab-'+_tab).show();

    });


    $(".datepicker" ).flatpickr({
        enable: [{
                from: new Date().fp_incr(0),
                to: new Date().fp_incr(7 * 366 * 100) // 7 days from now
        }],                
        onOpen: function(dateObj, dateStr, instance){

        },
        onClose: function(dateObj, dateStr, instance){
            $('.row-actions').removeClass('sticky-actions');
        }
    });

    $('#input-w3dev-ban-user').on('change', function(e) {
        var _this = $(this);
        
        if ( _this.is(':checked') ) {
            $('#js-w3dev-unban-date').show();
        } else {
            $('#js-w3dev-unban-date').hide();      
        }
    });
    
    $('.datepicker').on('click', function(e) {
        $(this).parent().parent().addClass('sticky-actions');
    });

});

function w3dev_datepicker(ID) { 
    document.getElementById("input-w3dev-unban-" + ID).focus(); 
}
