<?php
/**
 * Super-simple, minimum abstraction MarketHero wrapper
 * MarketHero API: https://markethero2.docs.apiary.io/
 *
 * @author MyThemeShop
 * @version 1.0
 */
if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if( ! class_exists('MarketHero') ):

class MarketHero {

	private $api_key;
  private $api_lead = 'http://api.markethero.io/v1/api/tag-lead';
	private $api_tags = 'http://api.markethero.io/v1/api/tags?apiKey=';
	private $ch;

/**
 * Create a new instance
 * @param string $api_key Your MarketHero API key
 */
  public function __construct( $api_key ) {

		$this->api_key = $api_key;
    $this->api_tags  = $this->api_tags . $this->api_key;
		$this->ch = curl_init();

  }
	/**
	 * send the lead request
	 * @param   array array of arguments.
	 * @return  array results array
	 */
	public function tag_lead( $post_params = array() ) {

		curl_setopt($this->ch, CURLOPT_URL, $this->api_lead );
		curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, TRUE );
		curl_setopt($this->ch, CURLOPT_HEADER, FALSE );
		curl_setopt($this->ch, CURLOPT_POST, TRUE );
		curl_setopt($this->ch, CURLOPT_POSTFIELDS, json_encode( $post_params ) );
		curl_setopt($this->ch, CURLOPT_HTTPHEADER, array( "Content-Type: application/json" ));
		$subscription = curl_exec( $this->ch );
		$subscription_details = json_decode($subscription, 1);
		return $subscription_details;

	}
	/**
	 * send the lead request
	 * @param   array array of arguments.
	 * @return  array results array of tags
	 */
	public function tag_list() {

		curl_setopt( $this->ch, CURLOPT_URL, $this->api_tags );
		curl_setopt( $this->ch, CURLOPT_RETURNTRANSFER, TRUE );
		curl_setopt( $this->ch, CURLOPT_HEADER, FALSE );

		$response = curl_exec( $this->ch );
		$results = json_decode( $response );
		$this->curl_close();
		return $results;

	}
	public function curl_close() {
		curl_close( $this->ch );
	}
	public function curl_open() {
		$this->ch = curl_init();
	}

}
endif;
