<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace WPStaging\Vendor\Google\Service\Drive;

class DriveFileLinkShareMetadata extends \WPStaging\Vendor\Google\Model
{
    /**
     * @var bool
     */
    public $securityUpdateEligible;
    /**
     * @var bool
     */
    public $securityUpdateEnabled;
    /**
     * @param bool
     */
    public function setSecurityUpdateEligible($securityUpdateEligible)
    {
        $this->securityUpdateEligible = $securityUpdateEligible;
    }
    /**
     * @return bool
     */
    public function getSecurityUpdateEligible()
    {
        return $this->securityUpdateEligible;
    }
    /**
     * @param bool
     */
    public function setSecurityUpdateEnabled($securityUpdateEnabled)
    {
        $this->securityUpdateEnabled = $securityUpdateEnabled;
    }
    /**
     * @return bool
     */
    public function getSecurityUpdateEnabled()
    {
        return $this->securityUpdateEnabled;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\WPStaging\Vendor\Google\Service\Drive\DriveFileLinkShareMetadata::class, 'WPStaging\\Vendor\\Google_Service_Drive_DriveFileLinkShareMetadata');
