(function () {
  'use strict';

  function _regeneratorRuntime() {
    _regeneratorRuntime = function () {
      return exports;
    };
    var exports = {},
      Op = Object.prototype,
      hasOwn = Op.hasOwnProperty,
      defineProperty = Object.defineProperty || function (obj, key, desc) {
        obj[key] = desc.value;
      },
      $Symbol = "function" == typeof Symbol ? Symbol : {},
      iteratorSymbol = $Symbol.iterator || "@@iterator",
      asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
      toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
    function define(obj, key, value) {
      return Object.defineProperty(obj, key, {
        value: value,
        enumerable: !0,
        configurable: !0,
        writable: !0
      }), obj[key];
    }
    try {
      define({}, "");
    } catch (err) {
      define = function (obj, key, value) {
        return obj[key] = value;
      };
    }
    function wrap(innerFn, outerFn, self, tryLocsList) {
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
        generator = Object.create(protoGenerator.prototype),
        context = new Context(tryLocsList || []);
      return defineProperty(generator, "_invoke", {
        value: makeInvokeMethod(innerFn, self, context)
      }), generator;
    }
    function tryCatch(fn, obj, arg) {
      try {
        return {
          type: "normal",
          arg: fn.call(obj, arg)
        };
      } catch (err) {
        return {
          type: "throw",
          arg: err
        };
      }
    }
    exports.wrap = wrap;
    var ContinueSentinel = {};
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function () {
      return this;
    });
    var getProto = Object.getPrototypeOf,
      NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function (method) {
        define(prototype, method, function (arg) {
          return this._invoke(method, arg);
        });
      });
    }
    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if ("throw" !== record.type) {
          var result = record.arg,
            value = result.value;
          return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
            invoke("next", value, resolve, reject);
          }, function (err) {
            invoke("throw", err, resolve, reject);
          }) : PromiseImpl.resolve(value).then(function (unwrapped) {
            result.value = unwrapped, resolve(result);
          }, function (error) {
            return invoke("throw", error, resolve, reject);
          });
        }
        reject(record.arg);
      }
      var previousPromise;
      defineProperty(this, "_invoke", {
        value: function (method, arg) {
          function callInvokeWithMethodAndArg() {
            return new PromiseImpl(function (resolve, reject) {
              invoke(method, arg, resolve, reject);
            });
          }
          return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
        }
      });
    }
    function makeInvokeMethod(innerFn, self, context) {
      var state = "suspendedStart";
      return function (method, arg) {
        if ("executing" === state) throw new Error("Generator is already running");
        if ("completed" === state) {
          if ("throw" === method) throw arg;
          return doneResult();
        }
        for (context.method = method, context.arg = arg;;) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }
          if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
            if ("suspendedStart" === state) throw state = "completed", context.arg;
            context.dispatchException(context.arg);
          } else "return" === context.method && context.abrupt("return", context.arg);
          state = "executing";
          var record = tryCatch(innerFn, self, context);
          if ("normal" === record.type) {
            if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
            return {
              value: record.arg,
              done: context.done
            };
          }
          "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
        }
      };
    }
    function maybeInvokeDelegate(delegate, context) {
      var methodName = context.method,
        method = delegate.iterator[methodName];
      if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
      var record = tryCatch(method, delegate.iterator, context.arg);
      if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
      var info = record.arg;
      return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
    }
    function pushTryEntry(locs) {
      var entry = {
        tryLoc: locs[0]
      };
      1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
    }
    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal", delete record.arg, entry.completion = record;
    }
    function Context(tryLocsList) {
      this.tryEntries = [{
        tryLoc: "root"
      }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
    }
    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) return iteratorMethod.call(iterable);
        if ("function" == typeof iterable.next) return iterable;
        if (!isNaN(iterable.length)) {
          var i = -1,
            next = function next() {
              for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
              return next.value = undefined, next.done = !0, next;
            };
          return next.next = next;
        }
      }
      return {
        next: doneResult
      };
    }
    function doneResult() {
      return {
        value: undefined,
        done: !0
      };
    }
    return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
      value: GeneratorFunctionPrototype,
      configurable: !0
    }), defineProperty(GeneratorFunctionPrototype, "constructor", {
      value: GeneratorFunction,
      configurable: !0
    }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
      var ctor = "function" == typeof genFun && genFun.constructor;
      return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
    }, exports.mark = function (genFun) {
      return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
    }, exports.awrap = function (arg) {
      return {
        __await: arg
      };
    }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
      return this;
    }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      void 0 === PromiseImpl && (PromiseImpl = Promise);
      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
      return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
        return result.done ? result.value : iter.next();
      });
    }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
      return this;
    }), define(Gp, "toString", function () {
      return "[object Generator]";
    }), exports.keys = function (val) {
      var object = Object(val),
        keys = [];
      for (var key in object) keys.push(key);
      return keys.reverse(), function next() {
        for (; keys.length;) {
          var key = keys.pop();
          if (key in object) return next.value = key, next.done = !1, next;
        }
        return next.done = !0, next;
      };
    }, exports.values = values, Context.prototype = {
      constructor: Context,
      reset: function (skipTempReset) {
        if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
      },
      stop: function () {
        this.done = !0;
        var rootRecord = this.tryEntries[0].completion;
        if ("throw" === rootRecord.type) throw rootRecord.arg;
        return this.rval;
      },
      dispatchException: function (exception) {
        if (this.done) throw exception;
        var context = this;
        function handle(loc, caught) {
          return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
        }
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i],
            record = entry.completion;
          if ("root" === entry.tryLoc) return handle("end");
          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc"),
              hasFinally = hasOwn.call(entry, "finallyLoc");
            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            } else {
              if (!hasFinally) throw new Error("try statement without catch or finally");
              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
            }
          }
        }
      },
      abrupt: function (type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }
        finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
        var record = finallyEntry ? finallyEntry.completion : {};
        return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
      },
      complete: function (record, afterLoc) {
        if ("throw" === record.type) throw record.arg;
        return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
      },
      finish: function (finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
        }
      },
      catch: function (tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if ("throw" === record.type) {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }
        throw new Error("illegal catch attempt");
      },
      delegateYield: function (iterable, resultName, nextLoc) {
        return this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
      }
    }, exports;
  }
  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }
    if (info.done) {
      resolve(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }
  function _asyncToGenerator(fn) {
    return function () {
      var self = this,
        args = arguments;
      return new Promise(function (resolve, reject) {
        var gen = fn.apply(self, args);
        function _next(value) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
        }
        function _throw(err) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
        }
        _next(undefined);
      });
    };
  }
  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }
  function _createForOfIteratorHelperLoose(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
    if (it) return (it = it.call(o)).next.bind(it);
    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it) o = it;
      var i = 0;
      return function () {
        if (i >= o.length) return {
          done: true
        };
        return {
          done: false,
          value: o[i++]
        };
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  /**
   * Polyfills the `Element.prototype.closest` function if not available in the browser.
   *
   * @return {Function} A function that will return the closest element, by selector, to this element.
   */
  function polyfillClosest() {
    if (Element.prototype.closest) {
      if (!Element.prototype.matches) {
        Element.prototype.matches = Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
      }
      Element.prototype.closest = function (s) {
        var el = this;
        do {
          if (Element.prototype.matches.call(el, s)) return el;
          el = el.parentElement || el.parentNode;
        } while (el !== null && el.nodeType === 1);
        return null;
      };
    }
    return function (element, selector) {
      return element instanceof Element ? element.closest(selector) : null;
    };
  }
  polyfillClosest();

  /**
   * This is a namespaced port of https://github.com/tristen/hoverintent,
   * with slight modification to accept selector with dynamically added element in dom,
   * instead of just already present element.
   *
   * @param {HTMLElement} parent
   * @param {string} selector
   * @param {CallableFunction} onOver
   * @param {CallableFunction} onOut
   *
   * @return {object}
   */
  function wpstgHoverIntent (parent, selector, onOver, onOut) {
    var x;
    var y;
    var pX;
    var pY;
    var mouseOver = false;
    var focused = false;
    var h = {};
    var state = 0;
    var timer = 0;
    var options = {
      sensitivity: 7,
      interval: 100,
      timeout: 0,
      handleFocus: false
    };
    function delay(el, e) {
      if (timer) {
        timer = clearTimeout(timer);
      }
      state = 0;
      return focused ? undefined : onOut(el, e);
    }
    function tracker(e) {
      x = e.clientX;
      y = e.clientY;
    }
    function compare(el, e) {
      if (timer) timer = clearTimeout(timer);
      if (Math.abs(pX - x) + Math.abs(pY - y) < options.sensitivity) {
        state = 1;
        return focused ? undefined : onOver(el, e);
      } else {
        pX = x;
        pY = y;
        timer = setTimeout(function () {
          compare(el, e);
        }, options.interval);
      }
    }

    // Public methods
    h.options = function (opt) {
      var focusOptionChanged = opt.handleFocus !== options.handleFocus;
      options = Object.assign({}, options, opt);
      if (focusOptionChanged) {
        options.handleFocus ? addFocus() : removeFocus();
      }
      return h;
    };
    function dispatchOver(el, e) {
      mouseOver = true;
      if (timer) {
        timer = clearTimeout(timer);
      }
      el.removeEventListener('mousemove', tracker, false);
      if (state !== 1) {
        pX = e.clientX;
        pY = e.clientY;
        el.addEventListener('mousemove', tracker, false);
        timer = setTimeout(function () {
          compare(el, e);
        }, options.interval);
      }
      return this;
    }

    /**
     * Newly added method,
     * A wrapper around dispatchOver to support dynamically added elements to dom
     */
    function onMouseOver(event) {
      if (event.target.matches(selector + ', ' + selector + ' *')) {
        dispatchOver(event.target.closest(selector), event);
      }
    }
    function dispatchOut(el, e) {
      mouseOver = false;
      if (timer) {
        timer = clearTimeout(timer);
      }
      el.removeEventListener('mousemove', tracker, false);
      if (state === 1) {
        timer = setTimeout(function () {
          delay(el, e);
        }, options.timeout);
      }
      return this;
    }

    /**
     * Newly added method,
     * A wrapper around dispatchOut to support dynamically added elements to dom
     */
    function onMouseOut(event) {
      if (event.target.matches(selector + ', ' + selector + ' *')) {
        dispatchOut(event.target.closest(selector), event);
      }
    }
    function dispatchFocus(el, e) {
      if (!mouseOver) {
        focused = true;
        onOver(el, e);
      }
    }

    /**
     * Newly added method,
     * A wrapper around dispatchFocus to support dynamically added elements to dom
     */
    function onFocus(event) {
      if (event.target.matches(selector + ', ' + selector + ' *')) {
        dispatchFocus(event.target.closest(selector), event);
      }
    }
    function dispatchBlur(el, e) {
      if (!mouseOver && focused) {
        focused = false;
        onOut(el, e);
      }
    }

    /**
     * Newly added method,
     * A wrapper around dispatchBlur to support dynamically added elements to dom
     */
    function onBlur(event) {
      if (event.target.matches(selector + ', ' + selector + ' *')) {
        dispatchBlur(event.target.closest(selector), event);
      }
    }

    /**
     * Modified to support dynamically added element
     */
    function addFocus() {
      parent.addEventListener('focus', onFocus, false);
      parent.addEventListener('blur', onBlur, false);
    }

    /**
     * Modified to support dynamically added element
     */
    function removeFocus() {
      parent.removeEventListener('focus', onFocus, false);
      parent.removeEventListener('blur', onBlur, false);
    }

    /**
     * Modified to support dynamically added element
     */
    h.remove = function () {
      if (!parent) {
        return;
      }
      parent.removeEventListener('mouseover', onMouseOver, false);
      parent.removeEventListener('mouseout', onMouseOut, false);
      removeFocus();
    };

    /**
     * Modified to support dynamically added element
     */
    if (parent) {
      parent.addEventListener('mouseover', onMouseOver, false);
      parent.addEventListener('mouseout', onMouseOut, false);
    }
    return h;
  }

  /**
   * Detect memory exhaustion and show warning.
   */
  var WpstgDetectMemoryExhaust = /*#__PURE__*/function () {
    function WpstgDetectMemoryExhaust(wpstgObject) {
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.wpstgObject = wpstgObject;
    }
    var _proto = WpstgDetectMemoryExhaust.prototype;
    _proto.sendRequest = /*#__PURE__*/function () {
      var _sendRequest = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(requestType) {
        var response, data;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return fetch(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: new URLSearchParams({
                  action: 'wpstg--detect-memory-exhaust',
                  requestType: requestType,
                  accessToken: this.wpstgObject.accessToken,
                  nonce: this.wpstgObject.nonce
                }),
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                }
              });
            case 3:
              response = _context.sent;
              _context.next = 6;
              return response.json();
            case 6:
              data = _context.sent;
              if (!('undefined' !== typeof data.status && data.status && data.error)) {
                _context.next = 9;
                break;
              }
              return _context.abrupt("return", data);
            case 9:
              console.warn(data.message);
              _context.next = 15;
              break;
            case 12:
              _context.prev = 12;
              _context.t0 = _context["catch"](0);
              console.warn(this.wpstgObject.i18n['somethingWentWrong'], _context.t0);
            case 15:
              return _context.abrupt("return", false);
            case 16:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[0, 12]]);
      }));
      function sendRequest(_x) {
        return _sendRequest.apply(this, arguments);
      }
      return sendRequest;
    }();
    return WpstgDetectMemoryExhaust;
  }();

  var WPStagingCommon = (function ($) {
    var WPStagingCommon = {
      continueErrorHandle: true,
      retry: {
        currentDelay: 0,
        count: 0,
        max: wpstg.maxFailedRetries,
        retryOnErrors: [401, 403, 404, 429, 502, 503, 504],
        performingRequest: false,
        incrementRetry: function incrementRetry(incrementRatio) {
          if (incrementRatio === void 0) {
            incrementRatio = 1.25;
          }
          WPStagingCommon.retry.performingRequest = true;
          if (WPStagingCommon.retry.currentDelay === 0) {
            // start with a delay of 1sec
            WPStagingCommon.retry.currentDelay = 1000;
            WPStagingCommon.retry.count = 1;
          }
          WPStagingCommon.retry.currentDelay += 500 * WPStagingCommon.retry.count * incrementRatio;
          WPStagingCommon.retry.count++;
        },
        canRetry: function canRetry() {
          return WPStagingCommon.retry.count < WPStagingCommon.retry.max;
        },
        reset: function reset() {
          WPStagingCommon.retry.currentDelay = 0;
          WPStagingCommon.retry.count = 0;
          WPStagingCommon.retry.performingRequest = false;
        }
      },
      memoryExhaustArticleLink: 'https://wp-staging.com/docs/php-fatal-error-allowed-memory-size-of-134217728-bytes-exhausted/',
      cache: {
        elements: [],
        get: function get(selector) {
          // It is already cached!
          if ($.inArray(selector, this.elements) !== -1) {
            return this.elements[selector];
          }

          // Create cache and return
          this.elements[selector] = $(selector);
          return this.elements[selector];
        },
        refresh: function refresh(selector) {
          selector.elements[selector] = $(selector);
        }
      },
      setJobId: function setJobId(jobId) {
        localStorage.setItem('jobIdBeingProcessed', jobId);
      },
      getJobId: function getJobId() {
        return localStorage.getItem('jobIdBeingProcessed');
      },
      checkMemoryExhaustion: function checkMemoryExhaustion(requestType) {
        return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
          var detectMemoryExhaust, response;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                detectMemoryExhaust = new WpstgDetectMemoryExhaust();
                _context.next = 3;
                return detectMemoryExhaust.sendRequest(requestType);
              case 3:
                response = _context.sent;
                if (response) {
                  _context.next = 6;
                  break;
                }
                return _context.abrupt("return", false);
              case 6:
                return _context.abrupt("return", response);
              case 10:
              case "end":
                return _context.stop();
            }
          }, _callee);
        }))();
      },
      listenTooltip: function listenTooltip() {
        wpstgHoverIntent(document, '.wpstg--tooltip', function (target, event) {
          target.querySelector('.wpstg--tooltiptext').style.visibility = 'visible';
        }, function (target, event) {
          if (!event.target.closest('.wpstg--tooltiptext a')) {
            target.querySelector('.wpstg--tooltiptext').style.visibility = 'hidden';
          }
        });
      },
      // Get the custom themed Swal Modal for WP Staging
      // Easy to maintain now in one place now
      getSwalModal: function getSwalModal(isContentCentered, customClasses) {
        if (isContentCentered === void 0) {
          isContentCentered = false;
        }
        if (customClasses === void 0) {
          customClasses = {};
        }
        // common style for all swal modal used in WP Staging
        var defaultCustomClasses = {
          confirmButton: 'wpstg--btn--confirm wpstg-blue-primary wpstg-button wpstg-link-btn wpstg-100-width',
          cancelButton: 'wpstg--btn--cancel wpstg-blue-primary wpstg-link-btn wpstg-100-width',
          actions: 'wpstg--modal--actions',
          popup: isContentCentered ? 'wpstg-swal-popup wpstg-centered-modal' : 'wpstg-swal-popup'
        };

        // If an attribute exists in both default and additional attributes,
        // The class(es) of the additional attribute will overwrite the default one.
        var options = {
          customClass: Object.assign(defaultCustomClasses, customClasses),
          buttonsStyling: false,
          reverseButtons: true,
          showClass: {
            popup: 'wpstg--swal2-show wpstg-swal-show'
          }
        };
        return wpstgSwal.mixin(options);
      },
      showSuccessModal: function showSuccessModal(htmlContent) {
        this.getSwalModal().fire({
          showConfirmButton: false,
          showCancelButton: true,
          cancelButtonText: 'OK',
          icon: 'success',
          title: 'Success!',
          html: '<div class="wpstg--grey" style="text-align: left; margin-top: 8px;">' + htmlContent + '</div>'
        });
      },
      showWarningModal: function showWarningModal(htmlContent) {
        this.getSwalModal().fire({
          showConfirmButton: false,
          showCancelButton: true,
          cancelButtonText: 'OK',
          icon: 'warning',
          title: '',
          html: '<div class="wpstg--grey" style="text-align: left; margin-top: 8px;">' + htmlContent + '</div>'
        });
      },
      showErrorModal: function showErrorModal(htmlContent) {
        this.getSwalModal().fire({
          showConfirmButton: false,
          showCancelButton: true,
          cancelButtonText: 'OK',
          icon: 'error',
          title: 'Error!',
          html: '<div class="wpstg--grey" style="text-align: left; margin-top: 8px;">' + htmlContent + '</div>'
        });
      },
      getSwalContainer: function getSwalContainer() {
        return wpstgSwal.getContainer();
      },
      closeSwalModal: function closeSwalModal() {
        wpstgSwal.close();
      },
      /**
       * Treats a default response object generated by WordPress's
       * wp_send_json_success() or wp_send_json_error() functions in
       * PHP, parses it in JavaScript, and either throws if it's an error,
       * or returns the data if the response is successful.
       *
       * @param {object} response
       * @return {*}
       */
      getDataFromWordPressResponse: function getDataFromWordPressResponse(response) {
        if (typeof response !== 'object') {
          throw new Error('Unexpected response (ERR 1341)');
        }
        if (!response.hasOwnProperty('success')) {
          throw new Error('Unexpected response (ERR 1342)');
        }
        if (!response.hasOwnProperty('data')) {
          throw new Error('Unexpected response (ERR 1343)');
        }
        if (response.success === false) {
          if (response.data instanceof Array && response.data.length > 0) {
            throw new Error(response.data.shift());
          } else {
            throw new Error('Response was not successful');
          }
        } else {
          // Successful response. Return the data.
          return response.data;
        }
      },
      isLoading: function isLoading(_isLoading) {
        if (!_isLoading || _isLoading === false) {
          WPStagingCommon.cache.get('.wpstg-loader').hide();
        } else {
          WPStagingCommon.cache.get('.wpstg-loader').show();
        }
      },
      /**
       * Convert the given url to make it slug compatible
       * @param {string} url
       * @return {string}
       */
      slugify: function slugify(url) {
        return url.toString().toLowerCase().normalize('NFD').replace(/[\u0300-\u036f]/g, '').replace(/\s+/g, '-').replace(/&/g, '-and-').replace(/[^a-z0-9\-]/g, '').replace(/-+/g, '-').replace(/^-*/, '').replace(/-*$/, '');
      },
      sanitizeEventAttribute: function sanitizeEventAttribute(string) {
        if (string === null) {
          return string;
        }
        return string.toString().replace(/("|')\s+on([a-z]+)\s?=\s?([a-z0-9\)\(\"\';]+)/i, '');
      },
      htmlEntityQuotesDecode: function htmlEntityQuotesDecode(string) {
        if (string === null) {
          return string;
        }
        return string.toString().replace(/\\"/g, '&quot;').replace(/\\'/g, '&#039');
      },
      showAjaxFatalError: function showAjaxFatalError(response, prependMessage, appendMessage) {
        prependMessage = prependMessage ? prependMessage + '<br/><br/>' : 'Something went wrong! <br/><br/>';
        appendMessage = appendMessage ? appendMessage + '<br/><br/>' : '<br/><br/>Please try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.';
        if (response === false) {
          WPStagingCommon.showError(prependMessage + ' Error: No response.' + appendMessage);
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          return;
        }
        if (typeof response.error !== 'undefined' && response.error) {
          WPStagingCommon.showError(prependMessage + ' Error: ' + response.message + appendMessage);
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          return;
        }
      },
      handleFetchErrors: function handleFetchErrors(response) {
        if (!response.ok) {
          WPStagingCommon.showError('Error: ' + response.status + ' - ' + response.statusText + '. Please try again or contact support.');
        }
        return response;
      },
      showError: function showError(message) {
        // If retry request no need to show Error;
        if (WPStagingCommon.retry.performingRequest) {
          return;
        }
        WPStagingCommon.cache.get('#wpstg-try-again').css('display', 'inline-block');
        WPStagingCommon.cache.get('#wpstg-cancel-cloning').text('Reset');
        WPStagingCommon.cache.get('#wpstg-resume-cloning').show();
        WPStagingCommon.cache.get('#wpstg-error-wrapper').show();
        WPStagingCommon.cache.get('#wpstg-error-details').show().html(message);
        WPStagingCommon.cache.get('#wpstg-removing-clone').removeClass('loading');
        WPStagingCommon.cache.get('.wpstg-loader').hide();
        $('.wpstg--modal--process--generic-problem').show().html(message);
      },
      resetErrors: function resetErrors() {
        WPStagingCommon.cache.get('#wpstg-error-details').hide().html('');
      },
      /**
       * Ajax Requests
       * @param {Object} data
       * @param {Function} callback
       * @param {string} dataType
       * @param {bool} showErrors
       * @param {int} tryCount
       * @param {float} incrementRatio
       * @param {function} errorCallback
       */
      ajax: function ajax(data, callback, dataType, showErrors, tryCount, incrementRatio, errorCallback) {
        if (incrementRatio === void 0) {
          incrementRatio = null;
        }
        if (errorCallback === void 0) {
          errorCallback = null;
        }
        if ('undefined' === typeof dataType) {
          dataType = 'json';
        }
        if (false !== showErrors) {
          showErrors = true;
        }
        tryCount = 'undefined' === typeof tryCount ? 0 : tryCount;
        var retryLimit = wpstg.maxFailedRetries;
        var retryTimeout = 10000 * tryCount;
        incrementRatio = parseInt(incrementRatio);
        if (!isNaN(incrementRatio)) {
          retryTimeout *= incrementRatio;
        }
        $.ajax({
          url: ajaxurl + '?action=wpstg_processing&_=' + Date.now() / 1000,
          type: 'POST',
          dataType: dataType,
          cache: false,
          data: data,
          error: function error(xhr, textStatus, errorThrown) {
            console.log(xhr.status + ' ' + xhr.statusText + '---' + textStatus);
            if (typeof errorCallback === 'function') {
              // Custom error handler
              errorCallback(xhr, textStatus, errorThrown);
              if (!WPStagingCommon.continueErrorHandle) {
                // Reset state
                WPStagingCommon.continueErrorHandle = true;
                return;
              }
            }

            // Default error handler
            tryCount++;
            if (tryCount <= retryLimit) {
              setTimeout(function () {
                WPStagingCommon.ajax(data, callback, dataType, showErrors, tryCount, incrementRatio);
                return;
              }, retryTimeout);
            } else {
              var errorCode = 'undefined' === typeof xhr.status ? 'Unknown' : xhr.status;
              WPStagingCommon.showError('Fatal Error:  ' + errorCode + ' Please try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.');
            }
          },
          success: function success(data) {
            if ('function' === typeof callback) {
              callback(data);
            }
          },
          statusCode: {
            404: function _() {
              if (tryCount >= retryLimit) {
                WPStagingCommon.showError('Error 404 - Can\'t find ajax request URL! Please try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.');
              }
            },
            500: function _() {
              if (tryCount >= retryLimit) {
                WPStagingCommon.showError('Fatal Error 500 - Internal server error while processing the request! Please try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.');
              }
            },
            504: function _() {
              if (tryCount > retryLimit) {
                WPStagingCommon.showError('Error 504 - It looks like your server is rate limiting ajax requests. Please try to resume after a minute. If this still not works try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.\n\ ');
              }
            },
            502: function _() {
              if (tryCount >= retryLimit) {
                WPStagingCommon.showError('Error 502 - It looks like your server is rate limiting ajax requests. Please try to resume after a minute. If this still not works try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.\n\ ');
              }
            },
            503: function _() {
              if (tryCount >= retryLimit) {
                WPStagingCommon.showError('Error 503 - It looks like your server is rate limiting ajax requests. Please try to resume after a minute. If this still not works try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.\n\ ');
              }
            },
            429: function _() {
              if (tryCount >= retryLimit) {
                WPStagingCommon.showError('Error 429 - It looks like your server is rate limiting ajax requests. Please try to resume after a minute. If this still not works try the <a href=\'https://wp-staging.com/docs/wp-staging-settings-for-small-servers/\' target=\'_blank\'>WP Staging Small Server Settings</a> or submit an error report and contact us.\n\ ');
              }
            },
            403: function _() {
              if (tryCount >= retryLimit) {
                WPStagingCommon.showError('Refresh page or login again! The process should be finished successfully. \n\ ');
              }
            }
          }
        });
      }
    };
    return WPStagingCommon;
  })(jQuery);

  /**
   * WP STAGING basic jQuery replacement
   */

  /**
   * Shortcut for document.querySelector() or jQuery's $()
   * Return single element only
   */
  function qs(selector) {
    return document.querySelector(selector);
  }

  /**
   * Shortcut for document.querySelector() or jQuery's $()
   * Return collection of elements
   */
  function all(selector) {
    return document.querySelectorAll(selector);
  }

  /**
   * alternative of jQuery - $(parent).on(event, selector, handler)
   */
  function addEvent(parent, evt, selector, handler) {
    if (!parent instanceof Element) {
      return;
    }
    parent.addEventListener(evt, function (event) {
      if (event.target.matches(selector + ', ' + selector + ' *')) {
        handler(event.target.closest(selector), event);
      }
    }, false);
  }
  function slideDown(element, duration) {
    if (duration === void 0) {
      duration = 400;
    }
    element.style.display = 'block';
    element.style.overflow = 'hidden';
    var height = element.offsetHeight;
    element.style.height = '0px';
    element.style.transitionProperty = 'height';
    element.style.transitionDuration = duration + 'ms';
    setTimeout(function () {
      element.style.height = height + 'px';
      window.setTimeout(function () {
        element.style.removeProperty('height');
        element.style.removeProperty('overflow');
        element.style.removeProperty('transition-duration');
        element.style.removeProperty('transition-property');
      }, duration);
    }, 0);
  }
  function slideUp(element, duration) {
    if (duration === void 0) {
      duration = 400;
    }
    element.style.display = 'block';
    element.style.overflow = 'hidden';
    var height = element.offsetHeight;
    element.style.height = height + 'px';
    element.style.transitionProperty = 'height';
    element.style.transitionDuration = duration + 'ms';
    setTimeout(function () {
      element.style.height = '0px';
      window.setTimeout(function () {
        element.style.display = 'none';
        element.style.removeProperty('height');
        element.style.removeProperty('overflow');
        element.style.removeProperty('transition-duration');
        element.style.removeProperty('transition-property');
      }, duration);
    }, 0);
  }
  function fadeOut(element, duration) {
    if (duration === void 0) {
      duration = 300;
    }
    element.style.opacity = 1;
    element.style.transitionProperty = 'opacity';
    element.style.transitionDuration = duration + 'ms';
    setTimeout(function () {
      element.style.opacity = 0;
      window.setTimeout(function () {
        element.style.display = 'none';
        element.style.removeProperty('opacity');
        element.style.removeProperty('transition-duration');
        element.style.removeProperty('transition-property');
      }, duration);
    }, 0);
  }
  function getNextSibling(element, selector) {
    var sibling = element.nextElementSibling;
    while (sibling) {
      if (sibling.matches(selector)) {
        return sibling;
      }
      sibling = sibling.nextElementSibling;
    }
  }
  function getPreviousSibling(element, selector) {
    var sibling = element.previousElementSibling;
    while (sibling) {
      if (sibling.matches(selector)) {
        return sibling;
      }
      sibling = sibling.previousElementSibling;
    }
  }
  function getParents(element, selector) {
    var result = [];
    for (var parent = element && element.parentElement; parent; parent = parent.parentElement) {
      if (parent.matches(selector)) {
        result.push(parent);
      }
    }
    return result;
  }

  /**
   * A confirmation modal
   *
   * @param title
   * @param html
   * @param confirmText
   * @param confirmButtonClass
   * @return Promise
   */
  function confirmModal(title, html, confirmText, confirmButtonClass) {
    return WPStagingCommon.getSwalModal(false, {
      container: 'wpstg-swal-push-container',
      confirmButton: confirmButtonClass + ' wpstg--btn--confirm wpstg-blue-primary wpstg-button wpstg-link-btn'
    }).fire({
      title: title,
      icon: 'warning',
      html: html,
      width: '750px',
      focusConfirm: false,
      confirmButtonText: confirmText,
      showCancelButton: true
    });
  }

  /**
   * Hides elements in the DOM that match the given selector by setting their display style to 'none'.
   *
   * @param {string} selector - CSS selector for the elements to be hidden.
   * @return {void}
   */
  function hide(selector) {
    var elements = document.querySelectorAll(selector);
    elements.forEach(function (element) {
      element.style.display = 'none';
    });
  }

  /**
   * Displays elements in the DOM that match the given selector by setting their display style to 'block'.
   *
   * @param {string} selector - CSS selector for the elements to be displayed.
   * @return {void}
   */
  function show(selector) {
    var elements = document.querySelectorAll(selector);
    elements.forEach(function (element) {
      element.style.display = 'block';
    });
  }

  /**
   * Displays a notification message
   *
   * @param type
   * @param message
   */
  function notify(type, message) {
    var notyf = new Notyf({
      duration: 6000,
      position: {
        x: 'center',
        y: 'bottom'
      },
      dismissible: true,
      types: [{
        type: 'warning',
        background: 'orange',
        icon: true
      }]
    });
    notyf.open({
      type: type,
      message: message
    });
  }

  /**
   * @param visibility
   * @return {void}
   */
  function loadingBar(visibility) {
    if (visibility === void 0) {
      visibility = 'visible';
    }
    var loader = document.querySelectorAll('.wpstg-loading-bar-container');
    loader.forEach(function (element) {
      if (element) {
        element.style.visibility = visibility;
      }
    });
  }
  function isElementChecked(selector) {
    var element = qs(selector);
    if (!element) {
      return false;
    }
    return element.checked;
  }
  function getInputValue(selector, defaultValue) {
    if (defaultValue === void 0) {
      defaultValue = '';
    }
    var element = qs(selector);
    if (!element) {
      return defaultValue;
    }
    return element.value;
  }

  /**
   * @param visibility
   * @return {void}
   */
  function loadingPlaceholder(visibility) {
    if (visibility === void 0) {
      visibility = 'visible';
    }
    var loader = all('.wpstg-loading-placeholder-container');
    loader.forEach(function (element) {
      if (element) {
        element.style.visibility = visibility;
      }
    });
    var container = qs('.wpstg--tab--contents');
    if (visibility === 'visible') {
      loadingBar();
      container && (container.style.overflow = 'hidden');
      return;
    }
    loadingBar('hidden');
    container && (container.style.overflow = 'unset');
  }

  /**
   *
   * @param container
   * @return {Promise<void>}
   */
  function setLoadingPlaceholder(_x) {
    return _setLoadingPlaceholder.apply(this, arguments);
  }
  function _setLoadingPlaceholder() {
    _setLoadingPlaceholder = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(container) {
      var loadingPlaceholderContainer, loadingWrapper, _loadingWrapper$query, _loadingWrapper$query2, _loadingWrapper$first, _loadingWrapper$lastE, loadingLines;
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            if (container === void 0) {
              container = '';
            }
            if (container === '') {
              container = qs('.wpstg--tab--contents');
            }
            if (!(container === null)) {
              _context.next = 4;
              break;
            }
            return _context.abrupt("return");
          case 4:
            loadingPlaceholderContainer = container.querySelector('.wpstg-loading-placeholder-container');
            loadingWrapper = loadingPlaceholderContainer.querySelector('.wpstg-dom-loading-wrapper');
            if (loadingWrapper) {
              _context.next = 8;
              break;
            }
            return _context.abrupt("return");
          case 8:
            if (!(loadingWrapper.offsetHeight !== container.offsetHeight)) {
              _context.next = 19;
              break;
            }
            loadingLines = loadingWrapper.querySelectorAll('.wpstg-loading-lines-bar');
            loadingLines.forEach(function (line) {
              return line.remove();
            });
            (_loadingWrapper$query = loadingWrapper.querySelector('.wpstg-loading-line')) == null ? void 0 : _loadingWrapper$query.remove();
            (_loadingWrapper$query2 = loadingWrapper.querySelector('.wpstg-loading-last-line-bar')) == null ? void 0 : _loadingWrapper$query2.remove();
          case 13:
            loadingWrapper.insertAdjacentHTML('beforeend', '<div class="wpstg-loading-lines-bar"></div>');
            _context.next = 16;
            return new Promise(function (resolve) {
              return setTimeout(resolve, 0);
            });
          case 16:
            if (loadingWrapper.offsetHeight <= container.offsetHeight - 40) {
              _context.next = 13;
              break;
            }
          case 17:
            (_loadingWrapper$first = loadingWrapper.firstElementChild) == null ? void 0 : _loadingWrapper$first.classList.add('wpstg-loading-first-line-bar');
            (_loadingWrapper$lastE = loadingWrapper.lastElementChild) == null ? void 0 : _loadingWrapper$lastE.classList.add('wpstg-loading-last-line-bar');
          case 19:
            _context.next = 21;
            return new Promise(function (resolve) {
              return setTimeout(resolve, 0);
            });
          case 21:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return _setLoadingPlaceholder.apply(this, arguments);
  }

  var WpstgCloneEdit = /*#__PURE__*/function () {
    function WpstgCloneEdit(workflowSelector, wpstgObject, databaseCheckAction) {
      if (workflowSelector === void 0) {
        workflowSelector = '#wpstg-workflow';
      }
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      if (databaseCheckAction === void 0) {
        databaseCheckAction = 'wpstg_database_connect';
      }
      this.workflow = qs(workflowSelector);
      this.wpstgObject = wpstgObject;
      this.databaseCheckAction = databaseCheckAction;
      this.isDbConnected = false;
      this.dbConnectionTest = '#wpstg-test-db-connection';
      this.dbCheckCallStatus = false;
      this.init();
    }
    var _proto = WpstgCloneEdit.prototype;
    _proto.addEvents = function addEvents() {
      var _this = this;
      // early bail if workflow object not available.
      if (this.workflow === null) {
        return;
      }
      addEvent(this.workflow, 'click', this.dbConnectionTest, function () {
        if (!_this.dbCheckCallStatus) {
          _this.checkDatabase();
        }
      });
    };
    _proto.init = function init() {
      this.addEvents();
    };
    _proto.checkDatabase = function checkDatabase(resolve) {
      var _this2 = this;
      var idPrefix = '#wpstg-edit-clone-data-';
      var externalDBUser = qs(idPrefix + 'database-user').value;
      var externalDBPassword = qs(idPrefix + 'database-password').value;
      var externalDBDatabase = qs(idPrefix + 'database-database').value;
      var externalDBHost = qs(idPrefix + 'database-server').value;
      var externalDBPrefix = qs(idPrefix + 'database-prefix').value;
      var externalDBSsl = qs(idPrefix + 'database-ssl').checked;
      var dbPrefix = qs(idPrefix + 'prefix');
      if (dbPrefix.value === '' && externalDBUser === '' && externalDBDatabase === '' && externalDBPrefix === '') {
        dbPrefix.style.borderColor = 'red';
        notify('error', 'Warning: Database table prefix can not be empty!');
        return resolve ? resolve() : '';
      }
      dbPrefix.style.borderColor = '';
      if (externalDBUser === '' && externalDBPassword === '' && externalDBDatabase === '' && externalDBPrefix === '') {
        this.isDbConnected = true;
        return resolve ? resolve() : '';
      }
      resolve ? this.dbCheckCallStatus = true : this.setDbCallStatus();
      fetch(this.wpstgObject.ajaxUrl, {
        method: 'POST',
        credentials: 'same-origin',
        body: new URLSearchParams({
          action: this.databaseCheckAction,
          accessToken: this.wpstgObject.accessToken,
          nonce: this.wpstgObject.nonce,
          databaseUser: externalDBUser,
          databasePassword: externalDBPassword,
          databaseServer: externalDBHost,
          databaseDatabase: externalDBDatabase,
          databasePrefix: externalDBPrefix,
          databaseSsl: externalDBSsl,
          databaseEnsurePrefixTableExist: true
        }),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(function (response) {
        if (response.ok) {
          return response.json();
        }
        return Promise.reject(response);
      }).then(function (data) {
        _this2.isDbConnected = data.success === true;
        // early bail when save clone data clicked
        if (resolve) {
          _this2.dbCheckCallStatus = false;
          resolve();
          return;
        }
        _this2.setDbCallStatus(false);
        var message = '';
        if (data.data && data.data !== 'undefined' && data.data.message !== 'undefined') {
          message = data.data.message;
        }
        if (data.success) {
          notify('success', _this2.wpstgObject.i18n['dbConnectionSuccess']);
        } else {
          notify('error', _this2.wpstgObject.i18n['dbConnectionFailed'] + ' <br/> Error: ' + message);
        }
      })["catch"](function (error) {
        _this2.isDbConnected = false;
        _this2.setDbCallStatus(false);
        notify('warning', _this2.wpstgObject.i18n['somethingWentWrong']);
        console.warn(_this2.wpstgObject.i18n['somethingWentWrong'], error);
        return resolve ? resolve() : '';
      });
    }

    /**
     * @param status
     * @return {void}
     */;
    _proto.setDbCallStatus = function setDbCallStatus(status) {
      if (status === void 0) {
        status = true;
      }
      if (status) {
        hide(this.dbConnectionTest);
        show('#wpstg-db-connection-running');
        this.dbCheckCallStatus = true;
        return;
      }
      this.dbCheckCallStatus = false;
      hide('#wpstg-db-connection-running');
      show(this.dbConnectionTest);
    };
    return WpstgCloneEdit;
  }();

  /**
   * Push Table Selection
   */
  var WpstgPushTableSelection = /*#__PURE__*/function () {
    function WpstgPushTableSelection(workflowSelector, inputSelector, wpstgObject) {
      if (workflowSelector === void 0) {
        workflowSelector = '#wpstg-workflow';
      }
      if (inputSelector === void 0) {
        inputSelector = '#wpstg_select_tables_pushing';
      }
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.workflow = qs(workflowSelector);
      this.inputSelector = inputSelector;
      this.input = qs(inputSelector);
      this.wpstgObject = wpstgObject;
      this.cloneID = this.input.getAttribute('data-clone');
      this.tablePrefix = this.input.getAttribute('data-prefix');
      this.isNetwork = this.input.getAttribute('data-network') === 'true';
      this.areAllTablesChecked = true;
      this.init();
    }
    var _proto = WpstgPushTableSelection.prototype;
    _proto.addEvents = function addEvents() {
      var _this = this;
      addEvent(document.body, 'click', '.wpstg-button-show-tables', function (target) {
        _this.showAllTables();
      });
      addEvent(document.body, 'click', '.wpstg-button-db-prefix', function () {
        _this.selectDefaultTables();
      });
      addEvent(document.body, 'click', '.wpstg-button-unselect', function () {
        _this.toggleTableSelection();
      });
      addEvent(document.body, 'change', this.inputSelector, function () {
        _this.countSelectedTables();
      });
    };
    _proto.init = function init() {
      this.addEvents();
    };
    _proto.showAllTables = function showAllTables() {
      var _this2 = this;
      var includedTables = this.getIncludedTables();
      var excludedTables = this.getExcludedTables();
      if (includedTables.length > excludedTables.length) {
        includedTables = '';
      } else if (excludedTables.length > includedTables.length) {
        excludedTables = '';
      }
      fetch(this.wpstgObject.ajaxUrl, {
        method: 'POST',
        credentials: 'same-origin',
        body: new URLSearchParams({
          action: 'wpstg_push_tables',
          accessToken: this.wpstgObject.accessToken,
          nonce: this.wpstgObject.nonce,
          clone: this.cloneID,
          includedTables: includedTables,
          excludedTables: excludedTables,
          selectedTablesWithoutPrefix: this.getSelectedTablesWithoutPrefix()
        }),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(function (response) {
        if (response.ok) {
          return response.json();
        }
        return Promise.reject(response);
      }).then(function (data) {
        // Reload current page if successful.
        if ('undefined' !== typeof data.success && data.success) {
          _this2.input.innerHTML = data.content;
          fadeOut(qs('.wpstg-button-show-tables'), 300);
          _this2.countSelectedTables();
          return;
        }

        // There will be message probably in case of error
        if ('undefined' !== typeof data.message) {
          _this2.notyf.error(data.message);
          return;
        }
        _this2.notyf.error(_this2.wpstgObject.i18n['somethingWentWrong']);
      })["catch"](function (error) {
        console.warn(_this2.wpstgObject.i18n['somethingWentWrong'], error);
      });
    };
    _proto.getRegexPattern = function getRegexPattern() {
      var pattern = '^' + this.tablePrefix;
      if (this.wpstgObject.isMultisite === '1' && !this.isNetwork) {
        pattern += '([^0-9])_*';
      }
      return pattern;
    };
    _proto.selectDefaultTables = function selectDefaultTables() {
      var options = this.input.querySelectorAll('.wpstg-db-table');
      var pattern = this.getRegexPattern();
      options.forEach(function (option) {
        var name = option.getAttribute('name', '');
        var disabled = option.hasAttribute('disabled');
        if (name.match(pattern) && !disabled) {
          option.selected = true;
        } else {
          option.selected = false;
        }
      });
      this.countSelectedTables();
    };
    _proto.toggleTableSelection = function toggleTableSelection() {
      if (false === this.areAllTablesChecked) {
        this.input.querySelectorAll('.wpstg-db-table').forEach(function (option) {
          option.selected = true;
        });
        this.workflow.querySelector('.wpstg-button-unselect').innerHTML = 'Unselect All';
        this.areAllTablesChecked = true;
      } else {
        this.input.querySelectorAll('.wpstg-db-table').forEach(function (option) {
          option.selected = false;
        });
        this.workflow.querySelector('.wpstg-button-unselect').innerHTML = 'Select All';
        this.areAllTablesChecked = false;
      }
      this.countSelectedTables();
    };
    _proto.getSelectedTablesWithoutPrefix = function getSelectedTablesWithoutPrefix() {
      var selectedTablesWithoutPrefix = [];
      var regexPattern = this.getRegexPattern();
      this.input.querySelectorAll('option:checked').forEach(function (option) {
        var name = option.getAttribute('name', '');
        if (!name.match(regexPattern)) {
          selectedTablesWithoutPrefix.push(name);
        }
      });
      return selectedTablesWithoutPrefix.join(this.wpstgObject.settings.directorySeparator);
    };
    _proto.getIncludedTables = function getIncludedTables() {
      var tables = [];
      var regexPattern = this.getRegexPattern();
      this.input.querySelectorAll('option:checked').forEach(function (option) {
        var name = option.getAttribute('name', '');
        if (name.match(regexPattern)) {
          tables.push(name);
        }
      });
      return tables.join(this.wpstgObject.settings.directorySeparator);
    };
    _proto.getExcludedTables = function getExcludedTables() {
      var tables = [];
      var regexPattern = this.getRegexPattern();
      this.input.querySelectorAll('option:not(:checked)').forEach(function (option) {
        var name = option.getAttribute('name', '');
        if (name.match(regexPattern)) {
          tables.push(name);
        }
      });
      return tables.join(this.wpstgObject.settings.directorySeparator);
    };
    _proto.countSelectedTables = function countSelectedTables() {
      var tablesCount = this.input.querySelectorAll('option:checked').length;
      var tablesCountElement = qs('#wpstg-tables-count');
      if (tablesCount === 0) {
        tablesCountElement.classList.add('danger');
        tablesCountElement.innerHTML = this.wpstgObject.i18n['noTableSelected'];
      } else {
        tablesCountElement.classList.remove('danger');
        tablesCountElement.innerHTML = this.wpstgObject.i18n['tablesSelected'].replace('{d}', tablesCount);
      }
    };
    return WpstgPushTableSelection;
  }();

  /**
   * Push File Selection
   */
  var WpstgPushFileSelection = /*#__PURE__*/function () {
    function WpstgPushFileSelection(workflowSelector, filesTabSelector, dirSelector, wpstgObject) {
      if (workflowSelector === void 0) {
        workflowSelector = '#wpstg-workflow';
      }
      if (filesTabSelector === void 0) {
        filesTabSelector = '#wpstg-scanning-files';
      }
      if (dirSelector === void 0) {
        dirSelector = '.wpstg-check-dir';
      }
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.workflow = qs(workflowSelector);
      this.filesTabSelector = filesTabSelector;
      this.filesTab = qs(filesTabSelector);
      this.dirSelector = dirSelector;
      this.wpstgObject = wpstgObject;
      this.init();
    }
    var _proto = WpstgPushFileSelection.prototype;
    _proto.addEvents = function addEvents() {
      var _this = this;
      addEvent(this.workflow, 'change', this.filesTabSelector + ' ' + this.dirSelector, function (el) {
        _this.toggleChildren(el);
        _this.countSelectedFiles();
      });
    };
    _proto.init = function init() {
      this.addEvents();
    };
    _proto.toggleChildren = function toggleChildren(el) {
      var parent = getParents(el, '.wpstg-dir')[0];
      var checkboxes = parent.querySelectorAll('.wpstg-subdir>.wpstg-dir>.wpstg--checkbox-wrapper >' + this.dirSelector);
      checkboxes.forEach(function (cb) {
        cb.checked = el.checked;
      });
    };
    _proto.countSelectedFiles = function countSelectedFiles() {
      var _this2 = this;
      var filesCount = this.filesTab.querySelectorAll(this.dirSelector + ':checked').length;
      var filesCountElement = qs('#wpstg-files-count');
      if (filesCount === 0) {
        filesCountElement.classList.add('danger');
        filesCountElement.innerHTML = this.wpstgObject.i18n['noFileSelected'];
      } else {
        var themesCount = 0;
        var pluginsCount = 0;
        filesCountElement.classList.remove('danger');
        this.filesTab.querySelectorAll('.wpstg-dir:not(.wpstg-sub-dir)> .wpstg-push-expand-dirs').forEach(function (head) {
          if (head.innerHTML === 'plugins') {
            pluginsCount = head.nextSibling.querySelectorAll(_this2.dirSelector + ':checked').length;
          }
          if (head.innerHTML === 'themes') {
            themesCount = head.nextSibling.querySelectorAll(_this2.dirSelector + ':checked').length;
          }
        });
        filesCountElement.innerHTML = this.wpstgObject.i18n['filesSelected'].replace('{t}', themesCount).replace('{p}', pluginsCount);
      }
    };
    return WpstgPushFileSelection;
  }();

  /**
   * Loader Modal
   */
  var WpstgLoader = /*#__PURE__*/function () {
    function WpstgLoader(wpstgObject) {
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.wpstgObject = wpstgObject;
    }

    /**
     * Show Swal alert with loader and send ajax request to fetch content of alert.
     * @return Promise
     */
    var _proto = WpstgLoader.prototype;
    _proto.showModal = function showModal() {
      var swalPromise = this.loadModal();
      return swalPromise;
    };
    _proto.loadModal = function loadModal() {
      return WPStagingCommon.getSwalModal(false, {
        container: 'wpstg-swal2-container wpstg-swal2-loading wpstg-swal2-loading-sm'
      }).fire({
        title: '',
        icon: 'warning',
        html: this.getAjaxLoader(),
        width: '100px',
        focusConfirm: false,
        showConfirmButton: false,
        showCancelButton: false
      });
    };
    _proto.getAjaxLoader = function getAjaxLoader() {
      return '<div class="wpstg-swal2-ajax-loader"><img src="' + this.wpstgObject.wpstgIcon + '" /></div>';
    };
    return WpstgLoader;
  }();

  /**
   * Network class
   * Add all Network/HTTP related methods here
   */
  var WpstgNetwork = /*#__PURE__*/function () {
    function WpstgNetwork() {}
    var _proto = WpstgNetwork.prototype;
    /**
     *
     * @param resource URL
     * @param options
     * @return {Promise<Response>}
     */
    _proto.fetchWithTimeout =
    /*#__PURE__*/
    function () {
      var _fetchWithTimeout = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(resource, options) {
        var _options, _options$timeout, timeout, controller, id, response;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (options === void 0) {
                options = {};
              }
              _options = options, _options$timeout = _options.timeout, timeout = _options$timeout === void 0 ? 8000 : _options$timeout;
              controller = new AbortController();
              id = setTimeout(function () {
                return controller.abort();
              }, timeout);
              _context.next = 6;
              return fetch(resource, _extends({}, options, {
                signal: controller.signal
              }));
            case 6:
              response = _context.sent;
              clearTimeout(id);
              return _context.abrupt("return", response);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function fetchWithTimeout(_x, _x2) {
        return _fetchWithTimeout.apply(this, arguments);
      }
      return fetchWithTimeout;
    }();
    return WpstgNetwork;
  }();

  var WpstgRemoteStorage = /*#__PURE__*/function () {
    function WpstgRemoteStorage(revokeButtonSelector, revokeProviderFormSelector, revokeAction, saveSettingsButtonSelector, settingsFormSelector, settingsAction, authenticateButtonSelector, authenticateFormSelector, authenticateAction, testConnectionButtonSelector, testConnectionFieldsSelector, testConnectionAction, wpstgObject, deleteSettingsSelector) {
      if (revokeButtonSelector === void 0) {
        revokeButtonSelector = '#wpstg-btn-provider-revoke';
      }
      if (revokeProviderFormSelector === void 0) {
        revokeProviderFormSelector = '#wpstg-provider-revoke-form';
      }
      if (revokeAction === void 0) {
        revokeAction = 'wpstg-provider-revoke';
      }
      if (saveSettingsButtonSelector === void 0) {
        saveSettingsButtonSelector = '#wpstg-btn-save-provider-settings';
      }
      if (settingsFormSelector === void 0) {
        settingsFormSelector = '#wpstg-provider-settings-form';
      }
      if (settingsAction === void 0) {
        settingsAction = 'wpstg-provider-settings';
      }
      if (authenticateButtonSelector === void 0) {
        authenticateButtonSelector = '#wpstg-btn-provider-authenticate';
      }
      if (authenticateFormSelector === void 0) {
        authenticateFormSelector = '#wpstg-provider-authenticate-form';
      }
      if (authenticateAction === void 0) {
        authenticateAction = 'wpstg-provider-authenticate';
      }
      if (testConnectionButtonSelector === void 0) {
        testConnectionButtonSelector = '#wpstg-btn-provider-test-connection';
      }
      if (testConnectionFieldsSelector === void 0) {
        testConnectionFieldsSelector = '#wpstg-provider-test-connection-fields';
      }
      if (testConnectionAction === void 0) {
        testConnectionAction = 'wpstg-provider-test-connection';
      }
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      if (deleteSettingsSelector === void 0) {
        deleteSettingsSelector = '#wpstg-btn-delete-provider-settings';
      }
      this.network = new WpstgNetwork();
      this.revokeButtonSelector = revokeButtonSelector;
      this.revokeForm = qs(revokeProviderFormSelector);
      this.revokeAction = revokeAction;
      this.saveSettingsButtonSelector = saveSettingsButtonSelector;
      this.settingsForm = qs(settingsFormSelector);
      this.settingsAction = settingsAction;
      this.authenticateButtonSelector = authenticateButtonSelector;
      this.authenticateForm = qs(authenticateFormSelector);
      this.authenticateAction = authenticateAction;
      this.testConnectionButtonSelector = testConnectionButtonSelector;
      this.testConnectionFields = qs(testConnectionFieldsSelector);
      this.testConnectionAction = testConnectionAction;
      this.wpstgObject = wpstgObject;
      this.wpstgDeleteSettings = deleteSettingsSelector;
      this.notyf = new Notyf({
        duration: 5000,
        position: {
          x: 'center',
          y: 'bottom'
        },
        dismissible: true,
        types: [{
          type: 'warning',
          background: 'orange',
          icon: false
        }, {
          type: 'error',
          background: '#e01e5a',
          icon: true
        }]
      });
      this.init();
    }
    var _proto = WpstgRemoteStorage.prototype;
    _proto.addEvents = function addEvents() {
      var _this = this;
      addEvent(document.body, 'click', this.revokeButtonSelector, /*#__PURE__*/function () {
        var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(target) {
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return _this.sendRevokeRequest();
              case 2:
              case "end":
                return _context.stop();
            }
          }, _callee);
        }));
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      addEvent(document.body, 'click', this.saveSettingsButtonSelector, /*#__PURE__*/function () {
        var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(target) {
          return _regeneratorRuntime().wrap(function _callee2$(_context2) {
            while (1) switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return _this.sendSaveSettingsRequest();
              case 2:
              case "end":
                return _context2.stop();
            }
          }, _callee2);
        }));
        return function (_x2) {
          return _ref2.apply(this, arguments);
        };
      }());
      addEvent(document.body, 'click', this.authenticateButtonSelector, /*#__PURE__*/function () {
        var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(target) {
          return _regeneratorRuntime().wrap(function _callee3$(_context3) {
            while (1) switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return _this.sendAuthenticateRequest();
              case 2:
              case "end":
                return _context3.stop();
            }
          }, _callee3);
        }));
        return function (_x3) {
          return _ref3.apply(this, arguments);
        };
      }());
      addEvent(document.body, 'click', this.testConnectionButtonSelector, /*#__PURE__*/function () {
        var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(target) {
          return _regeneratorRuntime().wrap(function _callee4$(_context4) {
            while (1) switch (_context4.prev = _context4.next) {
              case 0:
                _context4.next = 2;
                return _this.sendTestConnectionRequest();
              case 2:
              case "end":
                return _context4.stop();
            }
          }, _callee4);
        }));
        return function (_x4) {
          return _ref4.apply(this, arguments);
        };
      }());
      addEvent(document.body, 'change', '[name=\'ftp_type\']', /*#__PURE__*/function () {
        var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee5(target) {
          return _regeneratorRuntime().wrap(function _callee5$(_context5) {
            while (1) switch (_context5.prev = _context5.next) {
              case 0:
                _context5.next = 2;
                return _this.toggleSftpFields();
              case 2:
              case "end":
                return _context5.stop();
            }
          }, _callee5);
        }));
        return function (_x5) {
          return _ref5.apply(this, arguments);
        };
      }());
      addEvent(document.body, 'change', '[name=\'s3_provider\']', /*#__PURE__*/function () {
        var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee6(target) {
          return _regeneratorRuntime().wrap(function _callee6$(_context6) {
            while (1) switch (_context6.prev = _context6.next) {
              case 0:
                _context6.next = 2;
                return _this.toggleS3GenericFields();
              case 2:
              case "end":
                return _context6.stop();
            }
          }, _callee6);
        }));
        return function (_x6) {
          return _ref6.apply(this, arguments);
        };
      }());
      addEvent(document.body, 'click', this.wpstgDeleteSettings, /*#__PURE__*/function () {
        var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee7(target) {
          return _regeneratorRuntime().wrap(function _callee7$(_context7) {
            while (1) switch (_context7.prev = _context7.next) {
              case 0:
                _context7.next = 2;
                return _this.deleteStorageProviderSettings();
              case 2:
              case "end":
                return _context7.stop();
            }
          }, _callee7);
        }));
        return function (_x7) {
          return _ref7.apply(this, arguments);
        };
      }());
    };
    _proto.init = function init() {
      this.addEvents();
    };
    _proto.sendRevokeRequest = /*#__PURE__*/function () {
      var _sendRevokeRequest = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee8() {
        var provider, response, data;
        return _regeneratorRuntime().wrap(function _callee8$(_context8) {
          while (1) switch (_context8.prev = _context8.next) {
            case 0:
              provider = this.revokeForm.querySelector('input[name="provider"]').value;
              _context8.prev = 1;
              _context8.next = 4;
              return fetch(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: new URLSearchParams({
                  action: this.revokeAction,
                  accessToken: this.wpstgObject.accessToken,
                  nonce: this.wpstgObject.nonce,
                  provider: provider
                }),
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                }
              });
            case 4:
              response = _context8.sent;
              if (!response.ok) {
                console.error("An error has occurred: " + response.status);
              }
              _context8.next = 8;
              return response.json();
            case 8:
              data = _context8.sent;
              if (!data.success) {
                _context8.next = 13;
                break;
              }
              this.notyf.success(data.message);
              setTimeout(function () {
                window.location.reload();
              }, 3000);
              return _context8.abrupt("return");
            case 13:
              this.notyf.error(data.message);
              _context8.next = 19;
              break;
            case 16:
              _context8.prev = 16;
              _context8.t0 = _context8["catch"](1);
              console.warn(_context8.t0);
            case 19:
            case "end":
              return _context8.stop();
          }
        }, _callee8, this, [[1, 16]]);
      }));
      function sendRevokeRequest() {
        return _sendRevokeRequest.apply(this, arguments);
      }
      return sendRevokeRequest;
    }();
    _proto.sendSaveSettingsRequest = /*#__PURE__*/function () {
      var _sendSaveSettingsRequest = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee9() {
        var loader, swal, formData, queryString, response, data, errorMessage;
        return _regeneratorRuntime().wrap(function _callee9$(_context9) {
          while (1) switch (_context9.prev = _context9.next) {
            case 0:
              loader = new WpstgLoader();
              swal = loader.showModal();
              formData = new FormData(this.settingsForm);
              formData.append('action', this.settingsAction);
              formData.append('accessToken', this.wpstgObject.accessToken);
              formData.append('nonce', this.wpstgObject.nonce);
              queryString = new URLSearchParams(formData);
              _context9.prev = 7;
              _context9.next = 10;
              return this.network.fetchWithTimeout(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: queryString,
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                },
                timeout: 8000
              });
            case 10:
              response = _context9.sent;
              if (!response.ok) {
                console.error("An error has occurred: " + response.status);
              }
              _context9.next = 14;
              return response.json();
            case 14:
              data = _context9.sent;
              if (!data.success) {
                this.notyf.error(data.message);
              }
              if (data.warning) {
                this.notyf.open({
                  type: 'warning',
                  message: data.message
                });
              } else {
                this.notyf.success(data.message);
              }
              setTimeout(function () {
                window.location.reload();
              }, 2000);
              _context9.next = 25;
              break;
            case 20:
              _context9.prev = 20;
              _context9.t0 = _context9["catch"](7);
              errorMessage = _context9.t0.name === 'AbortError' ? 'Could not save settings. Ensure SFTP credentials are correct! (Hostname, port...) Please try again!' : _context9.t0.message;
              this.notyf.error(errorMessage);
              console.warn(errorMessage);
            case 25:
              _context9.prev = 25;
              swal.close();
              return _context9.finish(25);
            case 28:
            case "end":
              return _context9.stop();
          }
        }, _callee9, this, [[7, 20, 25, 28]]);
      }));
      function sendSaveSettingsRequest() {
        return _sendSaveSettingsRequest.apply(this, arguments);
      }
      return sendSaveSettingsRequest;
    }();
    _proto.sendAuthenticateRequest = /*#__PURE__*/function () {
      var _sendAuthenticateRequest = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee10() {
        var formData, queryString, response, data;
        return _regeneratorRuntime().wrap(function _callee10$(_context10) {
          while (1) switch (_context10.prev = _context10.next) {
            case 0:
              formData = new FormData(this.authenticateForm);
              formData.append('action', this.authenticateAction);
              formData.append('accessToken', this.wpstgObject.accessToken);
              formData.append('nonce', this.wpstgObject.nonce);
              queryString = new URLSearchParams(formData);
              _context10.prev = 5;
              _context10.next = 8;
              return fetch(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: queryString,
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                }
              });
            case 8:
              response = _context10.sent;
              if (!response.ok) {
                console.error("An error has occurred: " + response.status);
              }
              _context10.next = 12;
              return response.json();
            case 12:
              data = _context10.sent;
              if (!data.success) {
                _context10.next = 17;
                break;
              }
              this.notyf.success(data.message);
              setTimeout(function () {
                window.location.reload();
              }, 2000);
              return _context10.abrupt("return");
            case 17:
              this.notyf.error(data.message);
              _context10.next = 23;
              break;
            case 20:
              _context10.prev = 20;
              _context10.t0 = _context10["catch"](5);
              console.warn(_context10.t0);
            case 23:
            case "end":
              return _context10.stop();
          }
        }, _callee10, this, [[5, 20]]);
      }));
      function sendAuthenticateRequest() {
        return _sendAuthenticateRequest.apply(this, arguments);
      }
      return sendAuthenticateRequest;
    }();
    _proto.sendTestConnectionRequest = /*#__PURE__*/function () {
      var _sendTestConnectionRequest = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee11() {
        var loader, swal, fields, formData, queryString, response, data, errorMessage;
        return _regeneratorRuntime().wrap(function _callee11$(_context11) {
          while (1) switch (_context11.prev = _context11.next) {
            case 0:
              loader = new WpstgLoader();
              swal = loader.showModal();
              fields = this.testConnectionFields.querySelectorAll('[name]');
              formData = new FormData();
              formData.append('action', this.testConnectionAction);
              formData.append('accessToken', this.wpstgObject.accessToken);
              formData.append('nonce', this.wpstgObject.nonce);
              fields.forEach(function (element) {
                if (element.type === 'check' || element.type === 'checkbox') {
                  formData.append(element.getAttribute('name'), element.checked);
                  return;
                }
                formData.append(element.getAttribute('name'), element.value);
              });
              queryString = new URLSearchParams(formData);
              _context11.prev = 9;
              _context11.next = 12;
              return this.network.fetchWithTimeout(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: queryString,
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                },
                timeout: 8000
              });
            case 12:
              response = _context11.sent;
              if (!response.ok) {
                console.error("An error has occurred: " + response.status);
              }
              _context11.next = 16;
              return response.json();
            case 16:
              data = _context11.sent;
              if (!data.success) {
                _context11.next = 20;
                break;
              }
              this.notyf.success(data.message);
              return _context11.abrupt("return");
            case 20:
              this.notyf.error(data.message);
              _context11.next = 27;
              break;
            case 23:
              _context11.prev = 23;
              _context11.t0 = _context11["catch"](9);
              errorMessage = _context11.t0.name === 'AbortError' ? 'No response from server! Ensure SFTP credentials are correct! (Hostname, port...) Please try again!' : _context11.t0.message;
              this.notyf.error(errorMessage);
            case 27:
              _context11.prev = 27;
              swal.close();
              return _context11.finish(27);
            case 30:
            case "end":
              return _context11.stop();
          }
        }, _callee11, this, [[9, 23, 27, 30]]);
      }));
      function sendTestConnectionRequest() {
        return _sendTestConnectionRequest.apply(this, arguments);
      }
      return sendTestConnectionRequest;
    }()
    /**
     * @return {Promise<void>}
     */
    ;
    _proto.deleteStorageProviderSettings =
    /*#__PURE__*/
    function () {
      var _deleteStorageProviderSettings = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee12() {
        var provider, loader, swal, response, data;
        return _regeneratorRuntime().wrap(function _callee12$(_context12) {
          while (1) switch (_context12.prev = _context12.next) {
            case 0:
              provider = this.settingsForm.querySelector('input[name="provider"]').value;
              loader = new WpstgLoader();
              if (!confirm('Are you sure you want to delete ' + provider + ' settings?')) {
                _context12.next = 25;
                break;
              }
              swal = loader.showModal();
              _context12.prev = 4;
              _context12.next = 7;
              return fetch(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: new URLSearchParams({
                  action: 'wpstg-provider-delete-settings',
                  accessToken: this.wpstgObject.accessToken,
                  nonce: this.wpstgObject.nonce,
                  provider: provider
                }),
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                }
              });
            case 7:
              response = _context12.sent;
              if (!response.ok) {
                notify('error', "An error has occurred: " + response.status);
              }
              _context12.next = 11;
              return response.json();
            case 11:
              data = _context12.sent;
              if (!data.success) {
                _context12.next = 16;
                break;
              }
              notify('success', data.message);
              setTimeout(function () {
                window.location.reload();
              }, 2000);
              return _context12.abrupt("return");
            case 16:
              notify('error', data.message);
              _context12.next = 22;
              break;
            case 19:
              _context12.prev = 19;
              _context12.t0 = _context12["catch"](4);
              console.warn(_context12.t0);
            case 22:
              _context12.prev = 22;
              swal.close();
              return _context12.finish(22);
            case 25:
            case "end":
              return _context12.stop();
          }
        }, _callee12, this, [[4, 19, 22, 25]]);
      }));
      function deleteStorageProviderSettings() {
        return _deleteStorageProviderSettings.apply(this, arguments);
      }
      return deleteStorageProviderSettings;
    }();
    _proto.toggleSftpFields = function toggleSftpFields() {
      var ftpType = document.querySelector('[name=\'ftp_type\']');
      var sftpElements = document.querySelectorAll('.wpstg-only-sftp');
      var ftpElements = document.querySelectorAll('.wpstg-only-ftp');
      if (ftpType.value === 'ftp') {
        if (sftpElements.length) {
          for (var _iterator = _createForOfIteratorHelperLoose(sftpElements), _step; !(_step = _iterator()).done;) {
            var el = _step.value;
            el.classList.add('hidden');
          }
        }
        if (ftpElements.length) {
          for (var _iterator2 = _createForOfIteratorHelperLoose(ftpElements), _step2; !(_step2 = _iterator2()).done;) {
            var _el = _step2.value;
            _el.classList.remove('hidden');
          }
        }
        return;
      }
      if (sftpElements.length) {
        for (var _iterator3 = _createForOfIteratorHelperLoose(sftpElements), _step3; !(_step3 = _iterator3()).done;) {
          var _el2 = _step3.value;
          _el2.classList.remove('hidden');
        }
      }
      if (ftpElements.length) {
        for (var _iterator4 = _createForOfIteratorHelperLoose(ftpElements), _step4; !(_step4 = _iterator4()).done;) {
          var _el3 = _step4.value;
          _el3.classList.add('hidden');
        }
      }
    };
    _proto.toggleS3GenericFields = function toggleS3GenericFields() {
      var s3Provider = document.querySelector('[name=\'s3_provider\']');
      var isCustomProvider = s3Provider.value === '';
      var customFieldsContainer = document.getElementById('wpstg-s3-custom-provider-fields');
      customFieldsContainer.style.display = isCustomProvider ? 'block' : 'none';
    };
    return WpstgRemoteStorage;
  }();

  /**
   * Fetch directory direct child directories
   */
  var WpstgDirectoryNavigation = /*#__PURE__*/function () {
    function WpstgDirectoryNavigation(directoryListingSelector, wpstgObject, notyf) {
      if (directoryListingSelector === void 0) {
        directoryListingSelector = '#wpstg-directories-listing';
      }
      if (wpstgObject === void 0) {
        wpstgObject = WPStagingCommon;
      }
      if (notyf === void 0) {
        notyf = null;
      }
      this.directoryListingContainer = qs(directoryListingSelector);
      this.wpstgObject = wpstgObject;
      this.dirCheckboxSelector = '.wpstg-check-dir';
      this.dirExpandSelector = '.wpstg-expand-dirs';
      this.unselectAllDirsSelector = '.wpstg-unselect-dirs';
      this.selectDefaultDirsSelector = '.wpstg-select-dirs-default';
      this.fetchChildrenAction = 'wpstg_fetch_dir_children';
      this.currentCheckboxElement = null;
      this.currentParentDiv = null;
      this.currentLoader = null;
      this.existingExcludes = [];
      this.excludedDirectories = [];
      this.isDefaultSelected = false;
      this.notyf = notyf;
      this.init();
    }
    var _proto = WpstgDirectoryNavigation.prototype;
    _proto.addEvents = function addEvents() {
      var _this = this;
      if (this.directoryListingContainer === null) {
        console.log('Error: Unable to add directory navigation events.');
        return;
      }
      addEvent(this.directoryListingContainer, 'change', this.dirCheckboxSelector, function (element, event) {
        event.preventDefault();
      });
      addEvent(this.directoryListingContainer, 'click', this.dirExpandSelector, function (element, event) {
        event.preventDefault();
        if (_this.toggleDirExpand(element)) {
          _this.sendRequest(_this.fetchChildrenAction, element);
        }
      });
      addEvent(this.directoryListingContainer, 'click', this.unselectAllDirsSelector, function () {
        _this.unselectAll();
      });
      addEvent(this.directoryListingContainer, 'click', this.selectDefaultDirsSelector, function () {
        _this.selectDefault();
      });
      addEvent(this.directoryListingContainer, 'click', '.wpstg-expand-dirs', function (target, event) {
        event.preventDefault();
        _this.toggleDirectoryNavigation(target);
      });
      addEvent(this.directoryListingContainer, 'change', 'input.wpstg-check-dir', function (target) {
        _this.updateDirectorySelection(target);
      });
    };
    _proto.init = function init() {
      this.addEvents();
      this.parseExcludes();
    }

    /**
     * Toggle Dir Expand,
     * Return true if children aren't fetched
     * @param {HTMLElement} element
     * @return {boolean}
     */;
    _proto.toggleDirExpand = function toggleDirExpand(element) {
      this.currentParentDiv = element.parentElement;
      var checkboxWrapper = getPreviousSibling(element, 'span');
      this.currentCheckboxElement = checkboxWrapper.querySelector('input[type="checkbox"]');
      this.currentLoader = this.currentParentDiv.querySelector('.wpstg-is-dir-loading');
      if (this.currentCheckboxElement.getAttribute('data-navigatable', 'false') === 'false') {
        return false;
      }
      if (this.currentCheckboxElement.getAttribute('data-scanned', 'false') === 'false') {
        return true;
      }
      return false;
    };
    _proto.sendRequest = function sendRequest(action) {
      var _this2 = this;
      if (this.currentLoader !== null) {
        this.currentLoader.style.display = 'inline-block';
      }
      var changed = this.currentCheckboxElement.getAttribute('data-changed');
      var path = this.currentCheckboxElement.getAttribute('data-path');
      var prefix = this.currentCheckboxElement.getAttribute('data-prefix');
      fetch(this.wpstgObject.ajaxUrl, {
        method: 'POST',
        credentials: 'same-origin',
        body: new URLSearchParams({
          action: action,
          accessToken: this.wpstgObject.accessToken,
          nonce: this.wpstgObject.nonce,
          dirPath: path,
          prefix: prefix,
          isChecked: this.currentCheckboxElement.checked,
          forceDefault: changed === 'true'
        }),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(function (response) {
        if (response.ok) {
          return response.json();
        }
        return Promise.reject(response);
      }).then(function (data) {
        if ('undefined' !== typeof data.success && data.success) {
          _this2.currentCheckboxElement.setAttribute('data-scanned', true);
          var dirContainer = document.createElement('div');
          dirContainer.classList.add('wpstg-dir');
          dirContainer.classList.add('wpstg-subdir');
          dirContainer.innerHTML = JSON.parse(data.directoryListing);
          _this2.currentParentDiv.appendChild(dirContainer);
          if (_this2.currentLoader !== null) {
            _this2.currentLoader.style.display = 'none';
          }
          slideDown(dirContainer);
          return;
        }
        if (_this2.notyf !== null) {
          _this2.notyf.error(_this2.wpstgObject.i18n['somethingWentWrong']);
        } else {
          alert('Error: ' + _this2.wpstgObject.i18n['somethingWentWrong']);
        }
      })["catch"](function (error) {
        console.warn(_this2.wpstgObject.i18n['somethingWentWrong'], error);
      });
    };
    _proto.getExcludedDirectories = function getExcludedDirectories() {
      var _this3 = this,
        _this$wpstgObject$set;
      this.excludedDirectories = [];
      this.directoryListingContainer.querySelectorAll('.wpstg-dir .wpstg--checkbox-wrapper input:not(:checked)').forEach(function (element) {
        if (!_this3.isParentExcluded(element.value)) {
          _this3.excludedDirectories.push(element.value);
        }
      });
      if (!this.existingExcludes) {
        this.existingExcludes = [];
      }
      this.existingExcludes.forEach(function (exclude) {
        if (!_this3.isParentExcluded(exclude) && !_this3.isScanned(exclude)) {
          _this3.excludedDirectories.push(exclude);
        }
      });
      return this.excludedDirectories.join((_this$wpstgObject$set = this.wpstgObject.settings) == null ? void 0 : _this$wpstgObject$set.directorySeparator);
    }

    /**
     * @param {string} path
     * @return {bool}
     */;
    _proto.isParentExcluded = function isParentExcluded(path) {
      var isParentAlreadyExcluded = false;
      this.excludedDirectories.forEach(function (dir) {
        if (path.startsWith(dir + '/')) {
          isParentAlreadyExcluded = true;
        }
      });
      return isParentAlreadyExcluded;
    };
    _proto.getExtraDirectoriesRootOnly = function getExtraDirectoriesRootOnly() {
      this.getExcludedDirectories();
      var extraDirectories = [];
      this.directoryListingContainer.querySelectorAll(':not(.wpstg-subdir)>.wpstg-dir .wpstg--checkbox-wrapper>input.wpstg-wp-non-core-dir:checked').forEach(function (element) {
        extraDirectories.push(element.value);
      });

      // Check if extra directories text area exists
      // TODO: remove extraCustomDirectories code if no one require extraCustomDirectories...
      var extraDirectoriesTextArea = qs('#wpstg_extraDirectories');
      if (extraDirectoriesTextArea === null || extraDirectoriesTextArea.value === '') {
        var _this$wpstgObject$set2;
        return extraDirectories.join((_this$wpstgObject$set2 = this.wpstgObject.settings) == null ? void 0 : _this$wpstgObject$set2.directorySeparator);
      }
      var extraCustomDirectories = extraDirectoriesTextArea.value.split(/\r?\n/);
      return extraDirectories.concat(extraCustomDirectories).join(this.wpstgObject.settings.directorySeparator);
    };
    _proto.unselectAll = function unselectAll() {
      this.directoryListingContainer.querySelectorAll('.wpstg-dir .wpstg--checkbox-wrapper input').forEach(function (element) {
        element.checked = false;
      });
      this.countSelectedFiles();
    };
    _proto.selectDefault = function selectDefault() {
      // unselect all checkboxes
      this.unselectAll();

      // only select those checkboxes whose class is wpstg-wp-core-dir
      this.directoryListingContainer.querySelectorAll('.wpstg-dir .wpstg--checkbox-wrapper input.wpstg-wp-core-dir').forEach(function (element) {
        element.checked = true;
      });

      // then unselect those checkboxes whose parent has wpstg extra checkbox
      this.directoryListingContainer.querySelectorAll('.wpstg-dir > .wpstg--checkbox-wrapper .wpstg-wp-non-core-dir').forEach(function (element) {
        element.parentElement.querySelectorAll('input.wpstg-wp-core-dir').forEach(function (element) {
          element.checked = false;
        });
      });
      this.isDefaultSelected = true;
      this.countSelectedFiles();
    };
    _proto.parseExcludes = function parseExcludes() {
      this.existingExcludes = this.directoryListingContainer.getAttribute('data-existing-excludes', []);
      if (typeof this.existingExcludes === 'undefined' || !this.existingExcludes) {
        this.existingExcludes = [];
        return;
      }
      if (this.existingExcludes.length === 0) {
        this.existingExcludes = [];
        return;
      }
      var existingExcludes = this.existingExcludes.split(',');
      this.existingExcludes = existingExcludes.map(function (exclude) {
        if (exclude.substr(0, 1) === '/') {
          return exclude.slice(1);
        }
        return exclude;
      });
    };
    _proto.isScanned = function isScanned(exclude) {
      var scanned = false;
      this.directoryListingContainer.querySelectorAll('.wpstg-dir> .wpstg--checkbox-wrapper>input').forEach(function (element) {
        if (element.value === exclude) {
          scanned = true;
        }
      });
      return scanned;
    };
    _proto.toggleDirectoryNavigation = function toggleDirectoryNavigation(element) {
      var checkboxWrapper = getPreviousSibling(element, 'span');
      var cbElement = checkboxWrapper.querySelector('input[type="checkbox"]');
      if (cbElement.getAttribute('data-navigatable', 'false') === 'false') {
        return;
      }
      if (cbElement.getAttribute('data-scanned', 'false') === 'false') {
        return;
      }
      var subDirectories = getNextSibling(checkboxWrapper, '.wpstg-subdir');
      if (subDirectories.style.display === 'none') {
        slideDown(subDirectories);
      } else {
        slideUp(subDirectories);
      }
    };
    _proto.updateDirectorySelection = function updateDirectorySelection(element) {
      var parent = element.parentElement.parentElement;
      element.setAttribute('data-changed', 'true');
      if (element.checked) {
        getParents(parent.parentElement, '.wpstg-dir').forEach(function (parElem) {
          for (var i = 0; i < parElem.children.length; i++) {
            if (parElem.children[i].matches('.wpstg--checkbox-wrapper')) {
              parElem.children[i].children[i].checked = true;
            }
          }
        });
        parent.parentElement.querySelectorAll('.wpstg-expand-dirs').forEach(function (x) {
          if (x.textContent === 'wp-admin' || x.textContent === 'wp-includes') {
            return;
          }
          x.classList.remove('disabled');
        });
        parent.querySelectorAll('.wpstg-subdir .wpstg-check-dir').forEach(function (x) {
          x.checked = true;
        });
      } else {
        parent.querySelectorAll('.wpstg-expand-dirs, .wpstg-check-subdirs').forEach(function (x) {
          x.classList.add('disabled');
        });
        parent.querySelectorAll('.wpstg-dir .wpstg-check-dir').forEach(function (x) {
          x.checked = false;
        });
      }
      this.countSelectedFiles();
    };
    _proto.countSelectedFiles = function countSelectedFiles() {
      var themesCount = this.directoryListingContainer.querySelectorAll('[data-dir-type="theme"]:checked').length;
      var pluginsCount = this.directoryListingContainer.querySelectorAll('[data-dir-type="plugin"]:checked').length;
      var filesCountElement = qs('#wpstg-files-count');
      if (themesCount === 0 && pluginsCount === 0) {
        filesCountElement.classList.add('danger');
        filesCountElement.innerHTML = this.wpstgObject.i18n['noFileSelected'];
      } else {
        filesCountElement.classList.remove('danger');
        filesCountElement.innerHTML = this.wpstgObject.i18n['filesSelected'].replace('{t}', themesCount).replace('{p}', pluginsCount);
      }
    };
    return WpstgDirectoryNavigation;
  }();

  var WpstgCloneGenerateLoginLink = /*#__PURE__*/function () {
    function WpstgCloneGenerateLoginLink() {
      this.generateLoginLink();
    }
    var _proto = WpstgCloneGenerateLoginLink.prototype;
    _proto.generateLoginLink = function generateLoginLink() {
      var notyfG = new Notyf({
        duration: 4000,
        position: {
          x: 'center',
          y: 'bottom'
        },
        dismissible: true
      });
      addEvent(document.body, 'click', '.wpstg-generate-login-link-action', function (element) {
        WPStaging.ajax({
          action: 'wpstg_render_login_link_user_interface',
          clone: element.getAttribute('data-clone'),
          cloneName: element.getAttribute('data-name'),
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce
        }, function (response) {
          qs('#wpstg-workflow').innerHTML = response;
        }, 'HTML');
      });
      addEvent(document.body, 'click', '#wpstg-generate-login-link', function (element) {
        var html = '<p class=\'wpstg-push-confirmation-message\'> ' + element.getAttribute('data-alert-body') + '</p>';
        confirmModal(element.getAttribute('data-alert-title'), html, element.getAttribute('data-confirm-btn-text'), 'wpstg-confirm-link-save').then(function (result) {
          if (result.value) {
            var idPrefix = '#wpstg-generate-login-link-';
            var cloneID = qs(idPrefix + 'clone-id').value;
            var role = qs(idPrefix + 'role').value;
            var minutes = qs(idPrefix + 'minutes').value;
            var hours = qs(idPrefix + 'hours').value;
            var days = qs(idPrefix + 'days').value;
            var url = qs(idPrefix + 'generated').getAttribute('data-url');
            var uniqueid = Date.now().toString();
            WPStaging.ajax({
              action: 'wpstg_save_generated_link_data',
              accessToken: wpstg.accessToken,
              nonce: wpstg.nonce,
              cloneID: cloneID,
              role: role,
              minutes: minutes,
              hours: hours,
              days: days,
              uniqueid: uniqueid
            }, function (response) {
              if (response.success) {
                qs('#wpstg-generate-login-link-head').style.display = 'contents';
                qs('#wpstg-generate-login-link-generated').innerText = url + uniqueid;
                notyfG.success(response.data.message);
              } else {
                notyfG.error(response.data.message);
              }
              return;
            }, 'json');
          }
        });
      });
      addEvent(document.body, 'mouseover', '#wpstg-generate-login-link-generated-container', function (e) {
        qs('#wpstg-generate-login-link-copy-text').innerText = qs('#wpstg-generate-login-link-copy-text').getAttribute('data-copy');
        qs('#wpstg-generate-login-link-copy-text').style.display = 'contents';
      });
      addEvent(document.body, 'mouseout', '#wpstg-generate-login-link-generated-container', function (e) {
        qs('#wpstg-generate-login-link-copy-text').style.display = 'none';
      });
      addEvent(document.body, 'click', '#wpstg-generate-login-link-generated-container', function (element) {
        navigator.clipboard.writeText(qs('#wpstg-generate-login-link-generated').innerText);
        qs('#wpstg-generate-login-link-copy-text').innerText = qs('#wpstg-generate-login-link-copy-text').getAttribute('data-copied');
      });
    };
    return WpstgCloneGenerateLoginLink;
  }();

  var WpstgSyncAccount = /*#__PURE__*/function () {
    function WpstgSyncAccount() {
      this.syncAccount();
    }
    var _proto = WpstgSyncAccount.prototype;
    _proto.syncAccount = function syncAccount() {
      var $that = this;
      addEvent(document.body, 'click', '.wpstg-sync-account', function (e) {
        var $this = qs('.wpstg-sync-account');
        var dataset = $this.dataset;
        var html = '<p class=\'wpstg-push-confirmation-message\'> ' + dataset.alertBody + '</p>';
        $that.confirmModal(dataset.alertTitle, html, dataset.confirmBtnText, 'wpstg-confirm-sync-account').then(function (result) {
          var cloneID = dataset.clone;
          if (result.value) {
            WPStaging.ajax({
              action: 'wpstg_sync_account',
              accessToken: wpstg.accessToken,
              nonce: wpstg.nonce,
              clone: cloneID
            }, function (response) {
              if (response.data.message) {
                if (response.success) {
                  WPStagingCommon.showSuccessModal(response.data.message);
                } else {
                  WPStagingCommon.showErrorModal(response.data.message);
                }
              }
            }, 'json', false);
            return;
          }
        });
      });
    };
    /**
     * A confirmation modal
     *
     * @param html
     * @param confirmText
     * @param confirmButtonClass
     * @return Promise
     */
    _proto.confirmModal = function confirmModal(title, html, confirmText, confirmButtonClass) {
      return WPStagingCommon.getSwalModal(false, {
        container: 'wpstg-swal-push-container',
        confirmButton: confirmButtonClass + ' wpstg--btn--confirm wpstg-blue-primary wpstg-button wpstg-link-btn'
      }).fire({
        title: title,
        icon: 'warning',
        html: html,
        width: '750px',
        focusConfirm: false,
        confirmButtonText: confirmText,
        showCancelButton: true
      });
    };
    return WpstgSyncAccount;
  }();

  /**
   * Copyright (c) 2014-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var runtime = (function (exports) {

    var Op = Object.prototype;
    var hasOwn = Op.hasOwnProperty;
    var defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; };
    var undefined$1; // More compressible than void 0.
    var $Symbol = typeof Symbol === "function" ? Symbol : {};
    var iteratorSymbol = $Symbol.iterator || "@@iterator";
    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

    function define(obj, key, value) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
      return obj[key];
    }
    try {
      // IE 8 has a broken Object.defineProperty that only works on DOM objects.
      define({}, "");
    } catch (err) {
      define = function(obj, key, value) {
        return obj[key] = value;
      };
    }

    function wrap(innerFn, outerFn, self, tryLocsList) {
      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
      var generator = Object.create(protoGenerator.prototype);
      var context = new Context(tryLocsList || []);

      // The ._invoke method unifies the implementations of the .next,
      // .throw, and .return methods.
      defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) });

      return generator;
    }
    exports.wrap = wrap;

    // Try/catch helper to minimize deoptimizations. Returns a completion
    // record like context.tryEntries[i].completion. This interface could
    // have been (and was previously) designed to take a closure to be
    // invoked without arguments, but in all the cases we care about we
    // already have an existing method we want to call, so there's no need
    // to create a new function object. We can even get away with assuming
    // the method takes exactly one argument, since that happens to be true
    // in every case, so we don't have to touch the arguments object. The
    // only additional allocation required is the completion record, which
    // has a stable shape and so hopefully should be cheap to allocate.
    function tryCatch(fn, obj, arg) {
      try {
        return { type: "normal", arg: fn.call(obj, arg) };
      } catch (err) {
        return { type: "throw", arg: err };
      }
    }

    var GenStateSuspendedStart = "suspendedStart";
    var GenStateSuspendedYield = "suspendedYield";
    var GenStateExecuting = "executing";
    var GenStateCompleted = "completed";

    // Returning this object from the innerFn has the same effect as
    // breaking out of the dispatch switch statement.
    var ContinueSentinel = {};

    // Dummy constructor functions that we use as the .constructor and
    // .constructor.prototype properties for functions that return Generator
    // objects. For full spec compliance, you may wish to configure your
    // minifier not to mangle the names of these two functions.
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}

    // This is a polyfill for %IteratorPrototype% for environments that
    // don't natively support it.
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function () {
      return this;
    });

    var getProto = Object.getPrototypeOf;
    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    if (NativeIteratorPrototype &&
        NativeIteratorPrototype !== Op &&
        hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
      // This environment has a native %IteratorPrototype%; use it instead
      // of the polyfill.
      IteratorPrototype = NativeIteratorPrototype;
    }

    var Gp = GeneratorFunctionPrototype.prototype =
      Generator.prototype = Object.create(IteratorPrototype);
    GeneratorFunction.prototype = GeneratorFunctionPrototype;
    defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: true });
    defineProperty(
      GeneratorFunctionPrototype,
      "constructor",
      { value: GeneratorFunction, configurable: true }
    );
    GeneratorFunction.displayName = define(
      GeneratorFunctionPrototype,
      toStringTagSymbol,
      "GeneratorFunction"
    );

    // Helper for defining the .next, .throw, and .return methods of the
    // Iterator interface in terms of a single ._invoke method.
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function(method) {
        define(prototype, method, function(arg) {
          return this._invoke(method, arg);
        });
      });
    }

    exports.isGeneratorFunction = function(genFun) {
      var ctor = typeof genFun === "function" && genFun.constructor;
      return ctor
        ? ctor === GeneratorFunction ||
          // For the native GeneratorFunction constructor, the best we can
          // do is to check its .name property.
          (ctor.displayName || ctor.name) === "GeneratorFunction"
        : false;
    };

    exports.mark = function(genFun) {
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
      } else {
        genFun.__proto__ = GeneratorFunctionPrototype;
        define(genFun, toStringTagSymbol, "GeneratorFunction");
      }
      genFun.prototype = Object.create(Gp);
      return genFun;
    };

    // Within the body of any async function, `await x` is transformed to
    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
    // `hasOwn.call(value, "__await")` to determine if the yielded value is
    // meant to be awaited.
    exports.awrap = function(arg) {
      return { __await: arg };
    };

    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if (record.type === "throw") {
          reject(record.arg);
        } else {
          var result = record.arg;
          var value = result.value;
          if (value &&
              typeof value === "object" &&
              hasOwn.call(value, "__await")) {
            return PromiseImpl.resolve(value.__await).then(function(value) {
              invoke("next", value, resolve, reject);
            }, function(err) {
              invoke("throw", err, resolve, reject);
            });
          }

          return PromiseImpl.resolve(value).then(function(unwrapped) {
            // When a yielded Promise is resolved, its final value becomes
            // the .value of the Promise<{value,done}> result for the
            // current iteration.
            result.value = unwrapped;
            resolve(result);
          }, function(error) {
            // If a rejected Promise was yielded, throw the rejection back
            // into the async generator function so it can be handled there.
            return invoke("throw", error, resolve, reject);
          });
        }
      }

      var previousPromise;

      function enqueue(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function(resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }

        return previousPromise =
          // If enqueue has been called before, then we want to wait until
          // all previous Promises have been resolved before calling invoke,
          // so that results are always delivered in the correct order. If
          // enqueue has not been called before, then it is important to
          // call invoke immediately, without waiting on a callback to fire,
          // so that the async generator function has the opportunity to do
          // any necessary setup in a predictable way. This predictability
          // is why the Promise constructor synchronously invokes its
          // executor callback, and why async functions synchronously
          // execute code before the first await. Since we implement simple
          // async functions in terms of async generators, it is especially
          // important to get this right, even though it requires care.
          previousPromise ? previousPromise.then(
            callInvokeWithMethodAndArg,
            // Avoid propagating failures to Promises returned by later
            // invocations of the iterator.
            callInvokeWithMethodAndArg
          ) : callInvokeWithMethodAndArg();
      }

      // Define the unified helper method that is used to implement .next,
      // .throw, and .return (see defineIteratorMethods).
      defineProperty(this, "_invoke", { value: enqueue });
    }

    defineIteratorMethods(AsyncIterator.prototype);
    define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
      return this;
    });
    exports.AsyncIterator = AsyncIterator;

    // Note that simple async functions are implemented on top of
    // AsyncIterator objects; they just return a Promise for the value of
    // the final result produced by the iterator.
    exports.async = function(innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      if (PromiseImpl === void 0) PromiseImpl = Promise;

      var iter = new AsyncIterator(
        wrap(innerFn, outerFn, self, tryLocsList),
        PromiseImpl
      );

      return exports.isGeneratorFunction(outerFn)
        ? iter // If outerFn is a generator, return the full iterator.
        : iter.next().then(function(result) {
            return result.done ? result.value : iter.next();
          });
    };

    function makeInvokeMethod(innerFn, self, context) {
      var state = GenStateSuspendedStart;

      return function invoke(method, arg) {
        if (state === GenStateExecuting) {
          throw new Error("Generator is already running");
        }

        if (state === GenStateCompleted) {
          if (method === "throw") {
            throw arg;
          }

          // Be forgiving, per 25.3.3.3.3 of the spec:
          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
          return doneResult();
        }

        context.method = method;
        context.arg = arg;

        while (true) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }

          if (context.method === "next") {
            // Setting context._sent for legacy support of Babel's
            // function.sent implementation.
            context.sent = context._sent = context.arg;

          } else if (context.method === "throw") {
            if (state === GenStateSuspendedStart) {
              state = GenStateCompleted;
              throw context.arg;
            }

            context.dispatchException(context.arg);

          } else if (context.method === "return") {
            context.abrupt("return", context.arg);
          }

          state = GenStateExecuting;

          var record = tryCatch(innerFn, self, context);
          if (record.type === "normal") {
            // If an exception is thrown from innerFn, we leave state ===
            // GenStateExecuting and loop back for another invocation.
            state = context.done
              ? GenStateCompleted
              : GenStateSuspendedYield;

            if (record.arg === ContinueSentinel) {
              continue;
            }

            return {
              value: record.arg,
              done: context.done
            };

          } else if (record.type === "throw") {
            state = GenStateCompleted;
            // Dispatch the exception by looping back around to the
            // context.dispatchException(context.arg) call above.
            context.method = "throw";
            context.arg = record.arg;
          }
        }
      };
    }

    // Call delegate.iterator[context.method](context.arg) and handle the
    // result, either by returning a { value, done } result from the
    // delegate iterator, or by modifying context.method and context.arg,
    // setting context.delegate to null, and returning the ContinueSentinel.
    function maybeInvokeDelegate(delegate, context) {
      var methodName = context.method;
      var method = delegate.iterator[methodName];
      if (method === undefined$1) {
        // A .throw or .return when the delegate iterator has no .throw
        // method, or a missing .next mehtod, always terminate the
        // yield* loop.
        context.delegate = null;

        // Note: ["return"] must be used for ES3 parsing compatibility.
        if (methodName === "throw" && delegate.iterator["return"]) {
          // If the delegate iterator has a return method, give it a
          // chance to clean up.
          context.method = "return";
          context.arg = undefined$1;
          maybeInvokeDelegate(delegate, context);

          if (context.method === "throw") {
            // If maybeInvokeDelegate(context) changed context.method from
            // "return" to "throw", let that override the TypeError below.
            return ContinueSentinel;
          }
        }
        if (methodName !== "return") {
          context.method = "throw";
          context.arg = new TypeError(
            "The iterator does not provide a '" + methodName + "' method");
        }

        return ContinueSentinel;
      }

      var record = tryCatch(method, delegate.iterator, context.arg);

      if (record.type === "throw") {
        context.method = "throw";
        context.arg = record.arg;
        context.delegate = null;
        return ContinueSentinel;
      }

      var info = record.arg;

      if (! info) {
        context.method = "throw";
        context.arg = new TypeError("iterator result is not an object");
        context.delegate = null;
        return ContinueSentinel;
      }

      if (info.done) {
        // Assign the result of the finished delegate to the temporary
        // variable specified by delegate.resultName (see delegateYield).
        context[delegate.resultName] = info.value;

        // Resume execution at the desired location (see delegateYield).
        context.next = delegate.nextLoc;

        // If context.method was "throw" but the delegate handled the
        // exception, let the outer generator proceed normally. If
        // context.method was "next", forget context.arg since it has been
        // "consumed" by the delegate iterator. If context.method was
        // "return", allow the original .return call to continue in the
        // outer generator.
        if (context.method !== "return") {
          context.method = "next";
          context.arg = undefined$1;
        }

      } else {
        // Re-yield the result returned by the delegate method.
        return info;
      }

      // The delegate iterator is finished, so forget it and continue with
      // the outer generator.
      context.delegate = null;
      return ContinueSentinel;
    }

    // Define Generator.prototype.{next,throw,return} in terms of the
    // unified ._invoke helper method.
    defineIteratorMethods(Gp);

    define(Gp, toStringTagSymbol, "Generator");

    // A Generator should always return itself as the iterator object when the
    // @@iterator function is called on it. Some browsers' implementations of the
    // iterator prototype chain incorrectly implement this, causing the Generator
    // object to not be returned from this call. This ensures that doesn't happen.
    // See https://github.com/facebook/regenerator/issues/274 for more details.
    define(Gp, iteratorSymbol, function() {
      return this;
    });

    define(Gp, "toString", function() {
      return "[object Generator]";
    });

    function pushTryEntry(locs) {
      var entry = { tryLoc: locs[0] };

      if (1 in locs) {
        entry.catchLoc = locs[1];
      }

      if (2 in locs) {
        entry.finallyLoc = locs[2];
        entry.afterLoc = locs[3];
      }

      this.tryEntries.push(entry);
    }

    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal";
      delete record.arg;
      entry.completion = record;
    }

    function Context(tryLocsList) {
      // The root entry object (effectively a try statement without a catch
      // or a finally block) gives us a place to store values thrown from
      // locations where there is no enclosing try statement.
      this.tryEntries = [{ tryLoc: "root" }];
      tryLocsList.forEach(pushTryEntry, this);
      this.reset(true);
    }

    exports.keys = function(val) {
      var object = Object(val);
      var keys = [];
      for (var key in object) {
        keys.push(key);
      }
      keys.reverse();

      // Rather than returning an object with a next method, we keep
      // things simple and return the next function itself.
      return function next() {
        while (keys.length) {
          var key = keys.pop();
          if (key in object) {
            next.value = key;
            next.done = false;
            return next;
          }
        }

        // To avoid creating an additional object, we just hang the .value
        // and .done properties off the next function object itself. This
        // also ensures that the minifier will not anonymize the function.
        next.done = true;
        return next;
      };
    };

    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) {
          return iteratorMethod.call(iterable);
        }

        if (typeof iterable.next === "function") {
          return iterable;
        }

        if (!isNaN(iterable.length)) {
          var i = -1, next = function next() {
            while (++i < iterable.length) {
              if (hasOwn.call(iterable, i)) {
                next.value = iterable[i];
                next.done = false;
                return next;
              }
            }

            next.value = undefined$1;
            next.done = true;

            return next;
          };

          return next.next = next;
        }
      }

      // Return an iterator with no values.
      return { next: doneResult };
    }
    exports.values = values;

    function doneResult() {
      return { value: undefined$1, done: true };
    }

    Context.prototype = {
      constructor: Context,

      reset: function(skipTempReset) {
        this.prev = 0;
        this.next = 0;
        // Resetting context._sent for legacy support of Babel's
        // function.sent implementation.
        this.sent = this._sent = undefined$1;
        this.done = false;
        this.delegate = null;

        this.method = "next";
        this.arg = undefined$1;

        this.tryEntries.forEach(resetTryEntry);

        if (!skipTempReset) {
          for (var name in this) {
            // Not sure about the optimal order of these conditions:
            if (name.charAt(0) === "t" &&
                hasOwn.call(this, name) &&
                !isNaN(+name.slice(1))) {
              this[name] = undefined$1;
            }
          }
        }
      },

      stop: function() {
        this.done = true;

        var rootEntry = this.tryEntries[0];
        var rootRecord = rootEntry.completion;
        if (rootRecord.type === "throw") {
          throw rootRecord.arg;
        }

        return this.rval;
      },

      dispatchException: function(exception) {
        if (this.done) {
          throw exception;
        }

        var context = this;
        function handle(loc, caught) {
          record.type = "throw";
          record.arg = exception;
          context.next = loc;

          if (caught) {
            // If the dispatched exception was caught by a catch block,
            // then let that catch block handle the exception normally.
            context.method = "next";
            context.arg = undefined$1;
          }

          return !! caught;
        }

        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          var record = entry.completion;

          if (entry.tryLoc === "root") {
            // Exception thrown outside of any try block that could handle
            // it, so set the completion value of the entire function to
            // throw the exception.
            return handle("end");
          }

          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc");
            var hasFinally = hasOwn.call(entry, "finallyLoc");

            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              } else if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }

            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              }

            } else if (hasFinally) {
              if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }

            } else {
              throw new Error("try statement without catch or finally");
            }
          }
        }
      },

      abrupt: function(type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev &&
              hasOwn.call(entry, "finallyLoc") &&
              this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }

        if (finallyEntry &&
            (type === "break" ||
             type === "continue") &&
            finallyEntry.tryLoc <= arg &&
            arg <= finallyEntry.finallyLoc) {
          // Ignore the finally entry if control is not jumping to a
          // location outside the try/catch block.
          finallyEntry = null;
        }

        var record = finallyEntry ? finallyEntry.completion : {};
        record.type = type;
        record.arg = arg;

        if (finallyEntry) {
          this.method = "next";
          this.next = finallyEntry.finallyLoc;
          return ContinueSentinel;
        }

        return this.complete(record);
      },

      complete: function(record, afterLoc) {
        if (record.type === "throw") {
          throw record.arg;
        }

        if (record.type === "break" ||
            record.type === "continue") {
          this.next = record.arg;
        } else if (record.type === "return") {
          this.rval = this.arg = record.arg;
          this.method = "return";
          this.next = "end";
        } else if (record.type === "normal" && afterLoc) {
          this.next = afterLoc;
        }

        return ContinueSentinel;
      },

      finish: function(finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) {
            this.complete(entry.completion, entry.afterLoc);
            resetTryEntry(entry);
            return ContinueSentinel;
          }
        }
      },

      "catch": function(tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if (record.type === "throw") {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }

        // The context.catch method must only be called with a location
        // argument that corresponds to a known catch block.
        throw new Error("illegal catch attempt");
      },

      delegateYield: function(iterable, resultName, nextLoc) {
        this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        };

        if (this.method === "next") {
          // Deliberately forget the last sent value so that we don't
          // accidentally pass it on to the delegate.
          this.arg = undefined$1;
        }

        return ContinueSentinel;
      }
    };

    // Regardless of whether this script is executing as a CommonJS module
    // or not, return the runtime object so that we can declare the variable
    // regeneratorRuntime in the outer scope, which allows this module to be
    // injected easily by `bin/regenerator --include-runtime script.js`.
    return exports;

  }(
    // If this script is executing as a CommonJS module, use module.exports
    // as the regeneratorRuntime namespace. Otherwise create a new empty
    // object. Either way, the resulting object will be used to initialize
    // the regeneratorRuntime variable at the top of this file.
    typeof module === "object" ? module.exports : {}
  ));

  try {
    regeneratorRuntime = runtime;
  } catch (accidentalStrictMode) {
    // This module should not be running in strict mode, so the above
    // assignment should always work unless something is misconfigured. Just
    // in case runtime.js accidentally runs in strict mode, in modern engines
    // we can explicitly access globalThis. In older engines we can escape
    // strict mode using a global Function call. This could conceivably fail
    // if a Content Security Policy forbids using Function, but in that case
    // the proper solution is to fix the accidental strict mode problem. If
    // you've misconfigured your bundler to force strict mode and applied a
    // CSP to forbid Function, and you're not willing to fix either of those
    // problems, please detail your unique predicament in a GitHub issue.
    if (typeof globalThis === "object") {
      globalThis.regeneratorRuntime = runtime;
    } else {
      Function("r", "regeneratorRuntime = r")(runtime);
    }
  }

  /**
   * Handle toggle of contact us modal
   */
  var WpstgContactUs = /*#__PURE__*/function () {
    function WpstgContactUs(modalType, wpstgObject) {
      if (modalType === void 0) {
        modalType = 'contact-us';
      }
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.wpstgObject = wpstgObject;
      this.characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
      this.currentDate = new Date();
      this.modalType = modalType;
      this.init();
    }
    var _proto = WpstgContactUs.prototype;
    _proto.init = function init() {
      this.contactUsModal = '#wpstg-' + this.modalType + '-modal';
      this.askInTheForumForm = this.contactUsModal + ' #wpstg-' + this.modalType + '-report-issue-form';
      this.contactUsSuccessPopup = this.contactUsModal + ' #wpstg-' + this.modalType + '-success-form';
      this.contactUsLoader = this.contactUsModal + ' #wpstg-' + this.modalType + '-report-issue-loader';
      this.contactUsSupport = this.contactUsModal + ' #wpstg-' + this.modalType + '-support-forum';
      this.contactUsButton = document.querySelector('#wpstg-' + this.modalType + '-button');
      this.contactUsButtonBackupTab = document.querySelector('#wpstg--tab--backup  #wpstg-' + this.modalType + '-button');
      this.reportIssueButton = document.querySelector('#wpstg-contact-us-report-issue');
      this.successForm = document.querySelector(this.contactUsModal + ' #wpstg-' + this.modalType + '-success-form');
      this.contactUsReportIssueBtn = document.querySelector(this.contactUsModal + ' #wpstg-' + this.modalType + '-report-issue-btn');
      this.contactUsCloseButton = document.querySelector(this.contactUsModal + ' #wpstg-modal-close');
      this.contactUsSuccessPopupClose = document.querySelector(this.contactUsModal + ' #wpstg-' + this.modalType + '-success-modal-close');
      this.debugCodeCopyButton = document.querySelector(this.contactUsModal + ' #wpstg-' + this.modalType + '-debug-code-copy');
      this.contactUsResponse = document.querySelector(this.contactUsModal + ' #wpstg-' + this.modalType + '-debug-response');
      this.contactUsDebugCodeField = document.querySelector(this.contactUsModal + ' #wpstg-' + this.modalType + '-debug-code');
      this.isDebugWindowOpened = false;
      this.addEvents();
      this.notyf = new Notyf({
        duration: 6000,
        position: {
          x: 'center',
          y: 'bottom'
        },
        dismissible: true,
        types: [{
          type: 'warning',
          background: 'orange',
          icon: true
        }]
      });
    };
    _proto.addEvents = function addEvents() {
      var _this = this;
      document.addEventListener('keydown', function (event) {
        if (event.key === 'Escape') {
          hide(_this.contactUsModal);
          hide(_this.askInTheForumForm);
          hide(_this.contactUsSuccessPopup);
          hide(_this.contactUsSupport);
          _this.isDebugWindowOpened = false;
        }
      });
      if (this.contactUsButton !== null) {
        this.contactUsButton.addEventListener('click', function () {
          show(_this.contactUsModal);
        });
      }
      if (this.contactUsButtonBackupTab !== null) {
        this.contactUsButtonBackupTab.addEventListener('click', function () {
          show(_this.contactUsModal);
        });
      }
      if (this.reportIssueButton !== null) {
        this.reportIssueButton.addEventListener('click', function () {
          if (_this.isDebugWindowOpened) {
            hide(_this.askInTheForumForm);
          } else {
            show(_this.askInTheForumForm);
          }
          _this.isDebugWindowOpened = !_this.isDebugWindowOpened;
        });
      }
      if (this.contactUsReportIssueBtn !== null) {
        this.contactUsReportIssueBtn.addEventListener('click', function () {
          _this.sendDebugInfo();
        });
      }
      if (this.contactUsSuccessPopupClose !== null) {
        this.contactUsSuccessPopupClose.addEventListener('click', function () {
          hide(_this.contactUsSuccessPopup);
        });
      }
      if (this.contactUsCloseButton !== null) {
        this.contactUsCloseButton.addEventListener('click', function () {
          hide(_this.contactUsModal);
          hide(_this.contactUsSupport);
          hide(_this.askInTheForumForm);
          _this.isDebugWindowOpened = false;
        });
      }
      if (this.debugCodeCopyButton !== null) {
        this.debugCodeCopyButton.addEventListener('click', function () {
          _this.copyDebugCode();
          _this.notyf.success('Debug code copied to clipboard');
        });
      }
    };
    _proto.copyDebugCode = function copyDebugCode() {
      this.contactUsDebugCodeField.select();
      this.contactUsDebugCodeField.setSelectionRange(0, 99999);
      navigator.clipboard.writeText(this.contactUsDebugCodeField.value);
    };
    _proto.generateDebugCode = function generateDebugCode(length) {
      var result = '';
      for (var i = 0; i < length; i++) {
        result += this.characters.charAt(Math.floor(Math.random() * this.characters.length));
      }
      return 'wpstg-' + result + '-' + this.currentDate.getHours() + this.currentDate.getMinutes() + this.currentDate.getSeconds();
    };
    _proto.sendDebugInfo = function sendDebugInfo() {
      var _this2 = this;
      show(this.contactUsLoader);
      this.contactUsReportIssueBtn.disabled = true;
      var debugCode = this.generateDebugCode(8);
      fetch(this.wpstgObject.ajaxUrl, {
        method: 'POST',
        credentials: 'same-origin',
        body: new URLSearchParams({
          action: 'wpstg_send_debug_log_report',
          accessToken: this.wpstgObject.accessToken,
          nonce: this.wpstgObject.nonce,
          debugCode: debugCode
        }),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(function (response) {
        _this2.contactUsReportIssueBtn.disabled = false;
        if (response.ok) {
          return response.json();
        }
      }).then(function (data) {
        if (data.response && data.response.sent === true) {
          _this2.contactUsDebugCodeField.value = debugCode;
          show(_this2.contactUsSuccessPopup);
          window.debugCode = debugCode;
        } else {
          _this2.contactUsDebugCodeField.value = window.debugCode === undefined ? debugCode : window.debugCode;
          show(_this2.contactUsSuccessPopup);
        }
        hide(_this2.contactUsLoader);
      })["catch"](function (error) {
        hide(_this2.contactUsLoader);
        show(_this2.contactUsSupport);
        console.warn(_this2.wpstgObject.i18n['somethingWentWrong'], error);
      });
    };
    return WpstgContactUs;
  }();

  var WpstgReAuth = /*#__PURE__*/function () {
    function WpstgReAuth() {
      this.wrap = '';
      this.tempHidden = '';
      this.tempHiddenTimeout = '';
    }

    /**
     * @return {void}
     */
    var _proto = WpstgReAuth.prototype;
    _proto.shows = function shows() {
      this.wrap = document.getElementById('wpstg-auth-check-wrap');
      this.parentElement = document.getElementById('wpstg-auth-check');
      this.formElement = document.getElementById('wpstg-auth-check-form');
      this.wrapElement = document.getElementById('wpstg-auth-check-wrap');
      this.noFrameElement = this.wrapElement.querySelector('.wpstg-auth-fallback-expired');
      this.iframeElement = '';
      this.isIframeLoaded = false;
      if (this.formElement) {
        this.addUnloadEvent();
        this.iframeElement = this.createIframeElement();
        this.formElement.appendChild(this.iframeElement);
      }
      this.openModal();
      if (this.iframeElement) {
        this.focusIframe();
        this.setIframeLoadTimeout();
      } else {
        this.focusFallbackElement();
      }
    }

    /**
     * @return {void}
     */;
    _proto.addUnloadEvent = function addUnloadEvent() {
      window.addEventListener('beforeunload', function (event) {
        event.returnValue = 'Your session has expired. You can log in again from this page or go to the login page.';
      });
    }

    /**
    * @return {void}
    */;
    _proto.createIframeElement = function createIframeElement() {
      var _this = this;
      this.iframeElement = document.createElement('iframe');
      this.iframeElement.id = 'wpstg-auth-check-frame';
      this.iframeElement.style.border = '0px';
      this.iframeElement.title = this.noFrameElement.textContent;
      this.iframeElement.onload = function () {
        return _this.handleIframeLoad();
      };
      this.iframeElement.src = this.formElement.dataset.src;
      return this.iframeElement;
    }

    /**
     * @return {void}
     */;
    _proto.handleIframeLoad = function handleIframeLoad() {
      var height;
      var body;
      this.isIframeLoaded = true;
      this.formElement.classList.remove('loading');
      try {
        body = this.iframeElement.contentDocument.querySelector('body');
        height = body.offsetHeight;
      } catch (er) {
        this.handleIframeLoadError();
        return;
      }
      if (!body || !height) {
        this.handleIframeLoadError();
        return;
      }
      if (!body.classList.contains('interim-login-success')) {
        this.parentElement.style.maxHeight = height + 40 + 'px';
        return;
      }
      this.hide();
    }

    /**
     * @return {void}
     */;
    _proto.handleIframeLoadError = function handleIframeLoadError() {
      this.wrapElement.classList.add('fallback');
      this.parentElement.style.maxHeight = '';
      this.formElement.remove();
      this.noFrameElement.focus();
    }

    /**
     * @return {void}
     */;
    _proto.openModal = function openModal() {
      document.body.classList.add('modal-open');
      this.wrapElement.classList.remove('hidden');
    }

    /**
     * @return {void}
     */;
    _proto.focusIframe = function focusIframe() {
      this.iframeElement.focus();
    }

    /**
     * @return {void}
     */;
    _proto.setIframeLoadTimeout = function setIframeLoadTimeout() {
      var _this2 = this;
      setTimeout(function () {
        if (!_this2.isIframeLoaded) {
          _this2.wrapElement.classList.add('fallback');
          _this2.formElement.remove();
          _this2.noFrameElement.focus();
        }
      }, 2000);
    }

    /**
     * @return {void}
     */;
    _proto.focusFallbackElement = function focusFallbackElement() {
      this.noFrameElement.focus();
    }

    /**
     * @return {void}
     */;
    _proto.hide = function hide() {
      window.removeEventListener('beforeunload', function (event) {
        event.returnValue = null;
      });
      fadeOut(this.wrap, 200);
      wpstgAuthCheck.checkUserAuthentication();
    };
    return WpstgReAuth;
  }();
  var wpstgReAuth = new WpstgReAuth();

  var WpstgAuthCheck = /*#__PURE__*/function () {
    function WpstgAuthCheck(wpstgObject) {
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.wpstgObject = wpstgObject;
      this.count = 0;
      this.status = true;
      this.isAuthenticated = true;
    }

    /**
     * Start checking user authentication
     *
     * @return {void}
     */
    var _proto = WpstgAuthCheck.prototype;
    _proto.start = function start() {
      var _this = this;
      if (this.status) {
        setTimeout(function () {
          _this.checkUserAuthentication();
        }, 1000);
      }
    }

    /**
     * @return {void}
     */;
    _proto.stop = function stop() {
      this.resetCount();
      this.status = false;
    }

    /**
     * @return {void}
     */;
    _proto.resetCount = function resetCount() {
      this.count = 0;
    }

    /**
    * @return {void}
    */;
    _proto.checkUserAuthentication =
    /*#__PURE__*/
    function () {
      var _checkUserAuthentication = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var _this2 = this;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              fetch(this.wpstgObject.ajaxUrl, {
                method: 'POST',
                credentials: 'same-origin',
                body: new URLSearchParams({
                  action: 'wpstg_check_user_is_authenticated',
                  accessToken: this.wpstgObject.accessToken,
                  nonce: this.wpstgObject.nonce
                }),
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                }
              }).then(function (response) {
                if (response.ok) {
                  return response.json();
                }
                return Promise.reject(response);
              }).then(function (data) {
                if (data.wpAuthCheck === false) {
                  _this2.count++;
                }
                _this2.isAuthenticated = data.wpAuthCheck;
                if (_this2.count === 2) {
                  _this2.stop();
                  _this2.createAuthCheckElements(data.redirectUrl);
                  return;
                }
                _this2.start();
              })["catch"](function (error) {
                console.error('Error:', error);
              });
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function checkUserAuthentication() {
        return _checkUserAuthentication.apply(this, arguments);
      }
      return checkUserAuthentication;
    }()
    /**
     * @param redirectUrl
     * @return {void}
     */
    ;
    _proto.createAuthCheckElements = function createAuthCheckElements(redirectUrl) {
      var isAlreadyAppended = document.getElementById('wpstg-auth-check-wrap') !== null;
      if (isAlreadyAppended) {
        document.getElementById('wpstg-auth-check-wrap').remove();
      }
      var wpAuthCheckWrap = document.createElement('div');
      wpAuthCheckWrap.id = 'wpstg-auth-check-wrap';
      wpAuthCheckWrap.classList.add('hidden');
      var wpAuthCheckBg = document.createElement('div');
      wpAuthCheckBg.id = 'wpstg-auth-check-bg';
      var wpAuthCheckDialog = document.createElement('div');
      wpAuthCheckDialog.id = 'wpstg-auth-check';
      var wpAuthCheckForm = document.createElement('div');
      wpAuthCheckForm.id = 'wpstg-auth-check-form';
      wpAuthCheckForm.classList.add('loading');
      wpAuthCheckForm.dataset.src = redirectUrl + '?interim-login=1&wp_lang=en_US';
      var wpAuthCheckFallback = document.createElement('div');
      wpAuthCheckFallback.classList.add('wpstg-auth-fallback');
      var wpAuthCheckExpired = document.createElement('p');
      wpAuthCheckExpired.innerHTML = '<b class="wpstg-auth-fallback-expired" tabindex="0">Session expired</b>';
      var wpAuthCheckLoginLink = document.createElement('p');
      wpAuthCheckLoginLink.innerHTML = "<a href=\"" + redirectUrl + "\" target=\"_blank\">Please log in again.</a> The login page will open in a new tab. After logging in you can close it and return to this page.";
      wpAuthCheckDialog.append(wpAuthCheckForm, wpAuthCheckFallback);
      wpAuthCheckFallback.append(wpAuthCheckExpired, wpAuthCheckLoginLink);
      wpAuthCheckWrap.append(wpAuthCheckBg, wpAuthCheckDialog);
      document.body.appendChild(wpAuthCheckWrap);
      wpstgReAuth.shows();
    };
    return WpstgAuthCheck;
  }();
  var wpstgAuthCheck = new WpstgAuthCheck();

  var WPStagingBackup;
  (function ($) {
    window.addEventListener('backups-tab', function () {
      var backupTab = qs('#wpstg--tab--backup');
      backupTab.style.minHeight = backupTab.offsetHeight;
      WPStagingBackup.fetchListing();
    });
    window.addEventListener('backupListingFinished', function () {
      fetch(ajaxurl + "?action=wpstg--backups--restore--file-list&_=" + Math.random() + "&withTemplate=true", {
        method: 'POST',
        credentials: 'same-origin',
        body: new URLSearchParams({
          action: 'wpstg--backups--restore--file-list',
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce
        }),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(WPStagingCommon.handleFetchErrors).then(function (res) {
        return res.json();
      }).then(function (res) {
        if (res.success !== undefined && res.success === false) {
          WPStagingCommon.showError('Error: ' + res.data);
        }
        var ul = document.querySelector('.wpstg-backup-list ul');
        if (ul) {
          ul.innerHTML = res;
        }
        loadingPlaceholder('hidden');
        var tabBackup = document.getElementById('wpstg--tab--backup');
        tabBackup.style.minHeight = 'max-content';
        addEvent(qs('#wpstg-existing-backups'), 'click', '.wpstg-tab-header', function (el, event) {
          var target = qs(el.getAttribute('data-id'));
          el.classList.toggle('expand');
          if (el.classList.contains('expand')) {
            el.querySelector('span').classList.add('wpstg-rotate-90');
            slideDown(target);
          } else {
            el.querySelector('span').classList.remove('wpstg-rotate-90');
            slideUp(target);
          }
          event.stopImmediatePropagation();
        });
      })["catch"](function (e) {
        return WPStagingCommon.showAjaxFatalError(e, '', 'Submit an error report.');
      });
    });
    window.addEventListener('finishedProcess', function () {
      window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
    });
    window.addEventListener('finishedProcessWithError', function () {
      window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
    });
    WPStagingBackup = {
      performingCancelRequest: false,
      isBackupSlowerThanUsual: false,
      isBackupSpeedModalDisplayed: false,
      isCancelled: false,
      isFinished: false,
      processInfo: {
        title: null,
        interval: null,
        isOnlySchedule: false
      },
      modal: {
        create: {
          html: null,
          confirmBtnTxt: null,
          hasBackupSchedule: null
        },
        process: {
          html: null,
          cancelBtnTxt: null,
          modal: null
        },
        download: {
          html: null,
          data: {
            indexFile: null,
            files: []
          }
        },
        upload: {
          html: null,
          confirmBtnTxt: null,
          retryCount: 0,
          data: {
            file: null // file path
          }
        },

        restore: {
          html: null,
          btnTxtNext: null,
          btnTxtConfirm: null,
          btnTxtCancel: null,
          searchReplaceForm: null,
          containerIntroduction: null,
          data: {
            file: null,
            // file path
            fileObject: null,
            // JS "File" class instance
            search: [],
            replace: [],
            backupMetadata: {}
          },
          baseDirectory: null
        }
      },
      messages: {
        WARNING: 'warning',
        ERROR: 'error',
        INFO: 'info',
        DEBUG: 'debug',
        CRITICAL: 'critical',
        data: {
          all: [],
          info: [],
          error: [],
          critical: [],
          warning: [],
          debug: []
        },
        shouldWarn: function shouldWarn() {
          return WPStagingBackup.messages.data.error.length > 0 || WPStagingBackup.messages.data.critical.length > 0;
        },
        countByType: function countByType(type) {
          if (type === void 0) {
            type = WPStagingBackup.messages.ERROR;
          }
          return WPStagingBackup.messages.data[type].length;
        },
        addMessage: function addMessage(message) {
          if (Array.isArray(message)) {
            message.forEach(function (item) {
              WPStagingBackup.messages.addMessage(item);
            });
            return;
          }
          var type = message.type.toLowerCase() || 'info';
          if (!WPStagingBackup.messages.data[type]) {
            WPStagingBackup.messages.data[type] = [];
          }
          WPStagingBackup.messages.data.all.push(message); // TODO RPoC
          WPStagingBackup.messages.data[type].push(message);
        },
        reset: function reset() {
          WPStagingBackup.messages.data = {
            all: [],
            info: [],
            error: [],
            critical: [],
            warning: [],
            debug: []
          };
        }
      },
      timer: {
        totalSeconds: 0,
        interval: null,
        start: function start() {
          if (null !== WPStagingBackup.timer.interval) {
            return;
          }
          var prettify = function prettify(seconds) {
            // If potentially anything can exceed 24h execution time than that;
            // const _seconds = parseInt(seconds, 10)
            // const hours = Math.floor(_seconds / 3600)
            // const minutes = Math.floor(_seconds / 60) % 60
            // seconds = _seconds % 60
            //
            // return [hours, minutes, seconds]
            //   .map(v => v < 10 ? '0' + v : v)
            //   .filter((v,i) => v !== '00' || i > 0)
            //   .join(':')
            // ;
            // Are we sure we won't create anything that exceeds 24h execution time? If not then this;
            return "" + new Date(seconds * 1000).toISOString().substr(11, 8);
          };
          WPStagingBackup.timer.interval = setInterval(function () {
            $('.wpstg-backup-process-elapsed-time').text(prettify(WPStagingBackup.timer.totalSeconds));
            if (wpstgAuthCheck.isAuthenticated) {
              WPStagingBackup.timer.totalSeconds++;
            }
          }, 1000);
        },
        stop: function stop() {
          WPStagingBackup.timer.totalSeconds = 0;
          if (WPStagingBackup.timer.interval) {
            clearInterval(WPStagingBackup.timer.interval);
            WPStagingBackup.timer.interval = null;
          }
        }
      },
      status: {
        hasResponse: null,
        reTryAfter: 5000
      },
      fetchListing: function fetchListing(isResetErrors) {
        if (isResetErrors === void 0) {
          isResetErrors = true;
        }
        WPStagingCommon.isLoading(true);
        $('#backup-messages').text('');
        if (isResetErrors) {
          WPStagingCommon.resetErrors();
        }
        return fetch(ajaxurl + "?action=wpstg--backups--listing&_=" + Math.random(), {
          method: 'POST',
          credentials: 'same-origin',
          body: new URLSearchParams({
            action: 'wpstg--backups--listing',
            accessToken: wpstg.accessToken,
            nonce: wpstg.nonce
          }),
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          }
        }).then(WPStagingCommon.handleFetchErrors).then(function (res) {
          return res.json();
        }).then(function (res) {
          var backupTab = qs('#wpstg--tab--backup');
          backupTab.style.minHeight = backupTab.offsetHeight + 'px';
          $('#wpstg--tab--backup').empty();
          WPStagingBackup.modal.create.html = null;
          WPStagingCommon.cache.get('#wpstg--tab--backup').html(res);
          if (res.success !== undefined && res.success === false) {
            WPStagingCommon.showError('Error: ' + res.data);
            loadingPlaceholder('hidden');
            return;
          }
          WPStagingCommon.showAjaxFatalError(res, '', 'Submit an error report.');
          WPStagingCommon.isLoading(false);
          window.dispatchEvent(new Event('backupListingFinished'));
          return res;
        })["catch"](function (e) {
          return WPStagingCommon.showAjaxFatalError(e, '', 'Submit an error report.');
        });
      },
      /**
       * The cancel & cleanup process when we cancel a backup job or when a backup job is stopped due to an error.
       *
       * @param {Object} extraParams Extra parameter to send during cancel process
       * @param {CallableFunction} callback This function is called when a backup cancel/cleanup process response is returned. This callback is always called even if cancel process fails.
       */
      cancel: function cancel(extraParams, callback) {
        if (extraParams === void 0) {
          extraParams = {};
        }
        if (callback === void 0) {
          callback = null;
        }
        WPStagingBackup.timer.stop();
        clearInterval(WPStagingBackup.processInfo.interval);
        WPStagingBackup.isCancelled = true;
        WPStagingBackup.processInfo.interval = null;
        window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
        WPStagingCommon.closeSwalModal();
        WPStagingCommon.getSwalModal(true).fire({
          title: 'Cancelling & Cleaning up',
          text: 'This modal will close automatically when done...',
          icon: 'info',
          showConfirmButton: false,
          showCloseButton: false,
          showLoaderOnConfirm: false,
          showCancelButton: false,
          allowEscapeKey: false,
          allowOutsideClick: false,
          width: 650,
          onRender: function onRender() {
            WPStagingBackup.sendCancelRequest(Object.assign({
              isInit: 'yes'
            }, extraParams), callback);
          }
        });
      },
      sendCancelRequest: function sendCancelRequest(extraParams, callback) {
        if (WPStagingBackup.performingCancelRequest) {
          return;
        }
        WPStagingBackup.performingCancelRequest = true;
        WPStagingCommon.ajax(Object.assign({
          action: 'wpstg--backups--cancel',
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce,
          jobIdBeingCancelled: WPStagingCommon.getJobId()
        }, extraParams), function (response) {
          WPStagingBackup.performingCancelRequest = false;
          WPStagingBackup.isCancelled = false;
          WPStagingCommon.showAjaxFatalError(response, '', 'Submit an error report.');
          if (!response.hasOwnProperty('isRunning')) {
            WPStagingCommon.showErrorModal('Cancel process did not finish gracefully. Some temporary files might not have been cleaned up.');
          }
          if (response.isRunning === false) {
            wpstgAuthCheck.stop();
            WPStagingCommon.closeSwalModal();
            if (callback !== undefined && callback !== null) {
              callback();
            }
          } else {
            extraParams.isInit = 'no';
            WPStagingBackup.sendCancelRequest(extraParams, callback);
          }
        }, 'json', false, 1,
        // Don't retry upon failure
        1.25, function (xhr, textStatus, errorThrown) {
          WPStagingBackup.performingCancelRequest = false;

          // Todo: Why do we need this?
          WPStagingCommon.continueErrorHandle = false;

          // Resource is busy, wait for request to finish and try again
          if (xhr.status === 423) {
            setTimeout(function () {
              WPStagingBackup.sendCancelRequest(extraParams, callback);
            }, 1000);
            return;
          }
          WPStagingCommon.closeSwalModal();
          WPStagingCommon.showErrorModal('Cancel process did not finish gracefully. Some temporary files might not have been cleaned up.');
          if (callback !== undefined && callback !== null) {
            callback();
          }
        });
      },
      /**
      * If process.execute exists, process.data and process.onResponse is not used
      * process = { data: {}, onResponse: (resp) => {}, onAfterClose: () => {}, execute: () => {}, isShowCancelButton: bool }
      * @param {object} process
      */
      process: function process(_process) {
        if (typeof _process.execute !== 'function' && (!_process.data || !_process.onResponse)) {
          WPStagingCommon.closeSwalModal();
          WPStagingCommon.showError('process.data and / or process.onResponse is not set');
          return;
        }

        // TODO move to backend and get the contents as xhr response?
        if (!WPStagingBackup.modal.process.html || !WPStagingBackup.modal.process.cancelBtnTxt) {
          var $modal = $('#wpstg-backup-process-modal');
          var html = $modal.html();
          var btnTxt = $modal.attr('data-cancelButtonText');
          WPStagingBackup.modal.process.html = html || null;
          WPStagingBackup.modal.process.cancelBtnTxt = btnTxt || null;
          $modal.remove();
        }
        $('body').off('click', '.wpstg-backup-process-logs-button').on('click', '.wpstg-backup-process-logs-button', function (e) {
          WPStagingBackup.showLogsInModal(e);
        }).off('click', '.wpstg-backup-success-logs-button').on('click', '.wpstg-backup-success-logs-button', function (e) {
          WPStagingBackup.showLogsInModal(e, 'success');
        });
        _process.isShowCancelButton = false !== _process.isShowCancelButton;
        WPStagingBackup.modal.process.modal = WPStagingCommon.getSwalModal(true, {
          content: 'wpstg--process--content'
        }).fire({
          html: WPStagingBackup.modal.process.html,
          cancelButtonText: WPStagingBackup.modal.process.cancelBtnTxt,
          showCancelButton: _process.isShowCancelButton,
          showConfirmButton: false,
          allowOutsideClick: false,
          allowEscapeKey: false,
          width: 600,
          onRender: function onRender() {
            var _btnCancel = WPStagingCommon.getSwalContainer().getElementsByClassName('wpstg--swal2-cancel wpstg--btn--cancel')[0];
            var btnCancel = _btnCancel.cloneNode(true);
            _btnCancel.parentNode.replaceChild(btnCancel, _btnCancel);
            btnCancel.addEventListener('click', function (e) {
              if (confirm('Do you want to cancel the process?')) {
                WPStagingBackup.cancel();
              }
            });
            if (typeof _process.execute === 'function') {
              _process.execute();
              return;
            }
            if (!_process.data || !_process.onResponse) {
              WPStagingCommon.closeSwalModal();
              WPStagingCommon.showError('process.data and / or process.onResponse is not set');
              return;
            }
            WPStagingCommon.ajax(_process.data, _process.onResponse);
          },
          onAfterClose: function onAfterClose() {
            return typeof _process.onAfterClose === 'function' && _process.onAfterClose();
          }
        });
      },
      processResponse: function processResponse(response) {
        if (response === null) {
          WPStagingCommon.closeSwalModal();
          WPStagingCommon.showError('Invalid Response; null');
          throw new Error("Invalid Response; " + response);
        }
        var $container = $(WPStagingCommon.getSwalContainer());
        var title = function title() {
          if (response.title || response.statusTitle) {
            $container.find('.wpstg-backup-process-title').text(response.title || response.statusTitle);
          }
        };
        var percentage = function percentage() {
          if (response.percentage) {
            $container.find('.wpstg-backup-process-percent').text(response.percentage);
          }
        };
        var logs = function logs() {
          if (!response.messages) {
            return;
          }
          var $logsContainer = $container.find('.wpstg-backup-process-logs');
          var stoppingTypes = [WPStagingBackup.messages.ERROR, WPStagingBackup.messages.CRITICAL];
          var appendMessage = function appendMessage(message) {
            if (Array.isArray(message)) {
              for (var _iterator = _createForOfIteratorHelperLoose(message), _step; !(_step = _iterator()).done;) {
                var item = _step.value;
                appendMessage(item);
              }
              return;
            }
            var msgClass = "wpstg--modal--process--msg--" + message.type.toLowerCase();
            $logsContainer.append("<p class=\"" + msgClass + "\">[" + message.type + "] - [" + message.date + "] - " + message.message + "</p>");
            if (stoppingTypes.includes(message.type.toLowerCase())) {
              window.dispatchEvent(new CustomEvent('finishedProcessWithError', {
                detail: {
                  error: message.message
                }
              }));
              // Callback approach is used to make sure the logs modal is always shown,
              // after the completion of cancel/cleanup process.
              // Makes sure cancel/cleanup process doesn't close the logs modal.
              // Any other approach would have required a lot of refactoring.
              WPStagingBackup.cancel({}, function () {
                setTimeout(WPStagingBackup.logsModal, 500);
              });
            }
          };
          for (var _iterator2 = _createForOfIteratorHelperLoose(response.messages), _step2; !(_step2 = _iterator2()).done;) {
            var message = _step2.value;
            if (!message) {
              continue;
            }
            WPStagingBackup.messages.addMessage(message);
            appendMessage(message);
          }
          if ($logsContainer.is(':visible')) {
            $logsContainer.scrollTop($logsContainer[0].scrollHeight);
          }
          if (!WPStagingBackup.messages.shouldWarn()) {
            return;
          }
          var $btnShowLogs = $container.find('.wpstg-backup-process-logs-button');
          $btnShowLogs.html($btnShowLogs.attr('data-txt-bad'));
          $btnShowLogs.find('.wpstg--modal--logs--critical-count').text(WPStagingBackup.messages.countByType(WPStagingBackup.messages.CRITICAL));
          $btnShowLogs.find('.wpstg--modal--logs--error-count').text(WPStagingBackup.messages.countByType(WPStagingBackup.messages.ERROR));
          $btnShowLogs.find('.wpstg--modal--logs--warning-count').text(WPStagingBackup.messages.countByType(WPStagingBackup.messages.WARNING));
        };
        title();
        percentage();
        logs();
        if (response.jobId) {
          WPStagingCommon.setJobId(response.jobId);
        }
        if (response.isRunning === false && response.job_done === true) {
          if (response.job === 'Backup') {
            WPStagingBackup.calculateBackupSpeedIndex(response.backupSize, WPStagingBackup.timer.totalSeconds);
          }
          WPStagingBackup.timer.stop();
          WPStagingBackup.isCancelled = true;
          // For other classes that require 'status'
          response.status = !response.isRunning;
          window.dispatchEvent(new CustomEvent('finishedProcess', {
            response: response
          }));
        }
      },
      logsModal: function logsModal() {
        WPStagingCommon.getSwalModal(true, {
          popup: 'wpstg-swal-popup wpstg-centered-modal'
        }).fire({
          html: "<div class=\"wpstg--modal--error--logs\" style=\"display:block\"></div><div class=\"wpstg--modal--process--logs\" style=\"display:block\"></div>",
          width: '97%',
          onRender: function onRender() {
            var $container = $(WPStagingCommon.getSwalContainer());
            $container[0].style['z-index'] = 9999;
            var $logsContainer = $container.find('.wpstg-backup-process-logs');
            var $errorContainer = $container.find('.wpstg--modal--error--logs');
            var $translations = $('#wpstg--js--translations');
            var messages = WPStagingBackup.messages;
            var title = $translations.attr('data-modal-logs-title').replace('{critical}', messages.countByType(messages.CRITICAL)).replace('{errors}', messages.countByType(messages.ERROR)).replace('{warnings}', messages.countByType(messages.WARNING));
            $errorContainer.before("<h3>" + title + "</h3>");
            var warnings = [WPStagingBackup.messages.CRITICAL, WPStagingBackup.messages.ERROR, WPStagingBackup.messages.WARNING];
            if (!WPStagingBackup.messages.shouldWarn()) {
              $errorContainer.hide();
            }
            for (var _iterator3 = _createForOfIteratorHelperLoose(messages.data.all), _step3; !(_step3 = _iterator3()).done;) {
              var message = _step3.value;
              var msgClass = "wpstg--modal--process--msg--" + message.type.toLowerCase();
              if (warnings.includes(message.type)) {
                $errorContainer.append("<p class=\"" + msgClass + "\">[" + message.type + "] - [" + message.date + "] - " + message.message + "</p>");
              }
              $logsContainer.append("<p class=\"" + msgClass + "\">[" + message.type + "] - [" + message.date + "] - " + message.message + "</p>");
            }
          },
          onOpen: function onOpen(container) {
            var $logsContainer = $(container).find('.wpstg-backup-process-logs');
            $logsContainer.scrollTop($logsContainer[0].scrollHeight);
          }
        });
      },
      downloadModal: function downloadModal(_ref) {
        var _ref$title = _ref.title,
          title = _ref$title === void 0 ? null : _ref$title,
          _ref$bodyText = _ref.bodyText,
          bodyText = _ref$bodyText === void 0 ? null : _ref$bodyText;
        if (WPStagingBackup.isBackupSlowerThanUsual && WPStagingBackup.isBackupSpeedModalDisplayed === false) {
          return;
        }
        if (WPStagingBackup.modal.download.html === null) {
          var $el = $('#wpstg-backup-success-modal');
          WPStagingBackup.modal.download.html = $el.html();
          $el.remove();
        }
        WPStagingCommon.getSwalModal(true).fire({
          'icon': 'success',
          'html': WPStagingBackup.modal.download.html.replace('{title}', title).replace('{btnTxtLog}', 'Show Logs').replace('{text}', bodyText !== null ? bodyText : 'You can restore this backup anytime or upload it to another website and restore it there.'),
          'confirmButtonText': 'Close',
          'showCancelButton': false,
          'showConfirmButton': true
        });
        if (title === 'Backup Complete') {
          var wpstgRateUsElement = WPStagingCommon.getSwalContainer().querySelector('.wpstg-rate-us');
          if (wpstgRateUsElement) {
            wpstgRateUsElement.classList.add('show');
          }
        }
      },
      checkMemoryExhaustion: function checkMemoryExhaustion(response, requestType) {
        return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
          var result, helpContent;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return WPStagingCommon.checkMemoryExhaustion(requestType);
              case 2:
                result = _context.sent;
                if (!(result === false)) {
                  _context.next = 5;
                  break;
                }
                return _context.abrupt("return");
              case 5:
                helpContent = ' <button class="wpstg-btn wpstg-primary-btn wpstg-report-issue-button" type="button">CONTACT US</button> for help in solving this issue.';
                if (wpstg.isPro) {
                  helpContent = ' Read <a target="_blank" href="' + WPStagingCommon.memoryExhaustArticleLink + '">this article</a> for solving this issue. Please contact WP Staging support if you need further assistance.';
                }
                response.messages = [{
                  'type': 'critical',
                  'date': result.data['time'],
                  'message': result.message + '.' + helpContent
                }];
                WPStagingBackup.processResponse(response);
              case 9:
              case "end":
                return _context.stop();
            }
          }, _callee);
        }))();
      },
      statusStop: function statusStop() {
        clearInterval(WPStagingBackup.processInfo.interval);
        WPStagingBackup.processInfo.interval = null;
        window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
      },
      statusStart: function statusStart(process) {
        if (WPStagingBackup.processInfo.interval !== null) {
          return;
        }
        WPStagingBackup.processInfo.interval = setInterval(function () {
          if (true === WPStagingBackup.isCancelled) {
            WPStagingBackup.statusStop();
            return;
          }
          if (WPStagingBackup.status.hasResponse === false) {
            return;
          }
          WPStagingBackup.status.hasResponse = false;
          fetch(ajaxurl + "?action=wpstg--backups--status&" + process + "=restore", {
            method: 'POST',
            credentials: 'same-origin',
            body: new URLSearchParams({
              action: 'wpstg--backups--status',
              accessToken: wpstg.accessToken,
              nonce: wpstg.nonce
            }),
            headers: {
              'Content-Type': 'application/x-www-form-urlencoded'
            }
          }).then(function (res) {
            return res.json();
          }).then(function (res) {
            WPStagingBackup.status.hasResponse = true;
            if (typeof res === 'undefined') {
              WPStagingBackup.statusStop();
            }
            if (WPStagingBackup.processInfo.title === res.currentStatusTitle) {
              return;
            }
            WPStagingBackup.processInfo.title = res.currentStatusTitle;
            var $container = $(WPStagingCommon.getSwalContainer());
            $container.find('.wpstg-backup-process-title').text(res.currentStatusTitle);
            $container.find('.wpstg-backup-process-percent').text('0');
          })["catch"](function (e) {
            WPStagingBackup.status.hasResponse = true;
            WPStagingCommon.showAjaxFatalError(e, '', 'Submit an error report.');
          });
        }, 5000);
      },
      showLogsInModal: function showLogsInModal(e, modal) {
        if (modal === void 0) {
          modal = 'process';
        }
        if (WPStagingBackup.messages.data.all) {
          var _container = WPStagingCommon.getSwalContainer();
          var logsContainer = _container.querySelector('.wpstg-backup-' + modal + '-logs');
          logsContainer.innerHTML = '';
          WPStagingBackup.messages.data.all.forEach(function (message) {
            var msgClass = "wpstg--modal--process--msg--" + message.type.toLowerCase();
            var pElement = document.createElement('p');
            pElement.className = msgClass;
            pElement.textContent = "[" + message.type + "] - [" + message.date + "] - " + message.message;
            logsContainer.appendChild(pElement);
          });
        }
        var logBtn = $(this);
        e.preventDefault();
        var container = WPStagingCommon.getSwalContainer();
        var $logs = $(container).find('.wpstg-backup-' + modal + '-logs');
        $logs.toggle();
        if ($logs.is(':visible')) {
          logBtn.text(wpstg.i18n.hideLogs);
          container.childNodes[0].style.width = '97%';
          container.style['z-index'] = 9999;
        } else {
          logBtn.text(wpstg.i18n.showLogs);
          container.childNodes[0].style.width = '600px';
        }
      },
      calculateBackupSpeedIndex: function calculateBackupSpeedIndex(size, totalTime) {
        fetch(ajaxurl, {
          method: 'POST',
          credentials: 'same-origin',
          body: new URLSearchParams({
            action: 'wpstg_calculate_backup_speed_index',
            accessToken: wpstg.accessToken,
            nonce: wpstg.nonce,
            size: size,
            time: totalTime
          }),
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          }
        }).then(function (response) {
          if (response.ok) {
            return response.json();
          }
        }).then(function (data) {
          WPStagingBackup.isBackupSlowerThanUsual = data.isBackupSlowerThanUsual;
          WPStagingBackup.isBackupSpeedModalDisplayed = data.isBackupSpeedModalDisplayed;
          if (data.isBackupSlowerThanUsual && data.isBackupSpeedModalDisplayed === false) {
            var reportModal = document.querySelector('#wpstg-general-error-modal');
            if (reportModal != null && reportModal != undefined) {
              show('#wpstg-general-error-modal');
              new WpstgContactUs('general-error');
            }
          }
        })["catch"](function (error) {
          console.log(error);
        });
      }
    };
  })(jQuery);
  var WPStagingBackup$1 = WPStagingBackup;

  var WPStagingBackupEditSchedules;
  (function ($) {
    WPStagingBackupEditSchedules = {
      listen: function listen() {
        $('body').on('click', '.wpstg--edit-schedule', WPStagingBackupEditSchedules.updateSchedule);
      },
      updateSchedule: function updateSchedule(e) {
        WPStagingCommon.resetErrors();
        e.preventDefault();
        var scheduleId = e.target.dataset.scheduleId;
        WPStagingCommon.ajax({
          action: 'wpstg--backups-edit-schedule-modal',
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce,
          scheduleId: scheduleId
        }, function (response) {
          WPStagingCommon.getSwalModal(false).fire({
            html: document.getElementById('wpstg--modal--edit--backup--schedules').innerHTML,
            showConfirmButton: true,
            showCloseButton: true,
            showLoaderOnConfirm: false,
            showCancelButton: true,
            confirmButtonText: 'Save',
            cancelButtonText: 'Cancel',
            width: 500,
            allowEscapeKey: true,
            allowOutsideClick: true
          }).then(function (res) {
            if (res.isConfirmed !== true) {
              return;
            }
            var container = WPStagingCommon.getSwalContainer();
            var formValues = {
              scheduleRecurrence: container.querySelector('#wpstgEditBackupScheduleRecurrence').value || null,
              scheduleTime: container.querySelector('#wpstgEditBackupScheduleTime').value || null,
              scheduleRotation: container.querySelector('#wpstgEditBackupScheduleRotation').value || null
            };
            WPStagingCommon.ajax({
              action: 'wpstg--backups-edit-schedule',
              accessToken: wpstg.accessToken,
              nonce: wpstg.nonce,
              scheduleId: scheduleId,
              formValues: formValues
            }, function (response) {
              if (response.success) {
                setLoadingPlaceholder().then(function () {
                  return loadingPlaceholder();
                });
                WPStagingBackup$1.fetchListing();
              } else if (response.data) {
                WPStagingCommon.showErrorModal(response.data);
              }
            });
            return;
          });
          qs('.wpstg--swal2-container #wpstg--modal--edit--backup--schedules--content').innerHTML = response.data;
        });
      }
    };
  })(jQuery);
  var WPStagingBackupEditSchedules$1 = WPStagingBackupEditSchedules;

  var WPStagingBackupRemoteUpload;
  (function ($) {
    window.addEventListener('backups-tab', function () {
      WPStagingBackupRemoteUpload.listen();
    });
    WPStagingBackupRemoteUpload = {
      listen: function listen() {
        $('body').off('click', '.wpstg--backup--remote-upload', WPStagingBackupRemoteUpload.clickedRemoteUpload).on('click', '.wpstg--backup--remote-upload', WPStagingBackupRemoteUpload.clickedRemoteUpload);
      },
      clickedRemoteUpload: function clickedRemoteUpload(e) {
        var _this = this;
        return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
          var currentObj, $uploadModal, html, btnTxt, _yield$WPStagingCommo, formValues;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                currentObj = _this;
                WPStagingCommon.resetErrors();
                e.preventDefault();
                WPStagingBackup$1.isCancelled = false;
                WPStagingBackup$1.modal.upload.data.file = currentObj.getAttribute('data-filePath');
                if (!WPStagingBackup$1.modal.upload.html || !WPStagingBackup$1.modal.upload.confirmBtnTxt || document.getElementById('wpstg--modal--remote-upload')) {
                  $uploadModal = $('#wpstg--modal--remote-upload');
                  html = $uploadModal.html();
                  btnTxt = $uploadModal.attr('data-confirmButtonText');
                  WPStagingBackup$1.modal.upload.html = html || null;
                  WPStagingBackup$1.modal.upload.confirmBtnTxt = btnTxt || null;
                  $uploadModal.remove();
                }
                _context.next = 8;
                return WPStagingCommon.getSwalModal(false, {
                  confirmButton: 'wpstg--btn--confirm wpstg-blue-primary wpstg-button wpstg-link-btn'
                }).fire({
                  title: '',
                  html: WPStagingBackup$1.modal.upload.html,
                  focusConfirm: false,
                  confirmButtonText: WPStagingBackup$1.modal.upload.confirmBtnTxt,
                  showCancelButton: true,
                  preConfirm: function preConfirm() {
                    var container = WPStagingCommon.getSwalContainer();
                    var selectedStorages = container.querySelectorAll('input[name="storages"]:checked');
                    var storages = [];
                    for (var _iterator = _createForOfIteratorHelperLoose(selectedStorages), _step; !(_step = _iterator()).done;) {
                      var storage = _step.value;
                      storages.push(storage.value);
                    }
                    return {
                      file: WPStagingBackup$1.modal.upload.data.file,
                      isDeleteLocalBackup: container.querySelector('#deleteLocalBackup:checked') !== null,
                      storages: storages
                    };
                  },
                  onRender: function onRender() {
                    // this is for remote upload feature PR: 2611
                    var container = WPStagingCommon.getSwalContainer();
                    var checkboxesStorages = Array.from(container.querySelectorAll('[type="checkbox"][name="storages"]:checked'));
                    var isStorageSelected = checkboxesStorages.length > 0;
                    container.querySelector('.wpstg--swal2-confirm').disabled = !isStorageSelected;
                  }
                });
              case 8:
                _yield$WPStagingCommo = _context.sent;
                formValues = _yield$WPStagingCommo.value;
                if (formValues) {
                  _context.next = 12;
                  break;
                }
                return _context.abrupt("return");
              case 12:
                WPStagingBackup$1.process({
                  execute: function execute() {
                    WPStagingBackup$1.messages.reset();
                    WPStagingBackupRemoteUpload.prepareRemoteUpload(formValues);
                  }
                });
              case 13:
              case "end":
                return _context.stop();
            }
          }, _callee);
        }))();
      },
      prepareRemoteUpload: function prepareRemoteUpload(data) {
        WPStagingCommon.ajax({
          action: 'wpstg--backups--prepare-remote-upload',
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce,
          wpstgRemoteUploadData: data
        }, function (response) {
          if (response.success) {
            window.dispatchEvent(new Event('startedRemoteUploadingBackup'));
            WPStagingBackup$1.timer.start();
            WPStagingBackupRemoteUpload.remoteUploadBackup();
          } else {
            WPStagingCommon.showAjaxFatalError(response.data, '', 'Submit an error report.');
          }
        }, 'json', false, 10, 1.25, function (xhr, textStatus, errorThrown) {
          if (xhr.status === 423) {
            WPStagingCommon.continueErrorHandle = false;
            WPStagingBackup$1.shouldCleanUp = false;
            WPStagingCommon.closeSwalModal();
            setTimeout(function () {
              WPStagingBackup$1.shouldCleanUp = true;
            }, 1000);
            WPStagingCommon.showErrorModal(xhr.responseJSON.data);
          } else {
            WPStagingCommon.continueErrorHandle = true;
          }
        });
      },
      remoteUploadBackup: function remoteUploadBackup() {
        var maxBackupSequentialReturnError = 10;
        var backupReturnedError = 0;
        WPStagingCommon.resetErrors();
        if (WPStagingBackup$1.isCancelled) {
          WPStagingBackup$1.statusStop();
          return;
        }
        WPStagingCommon.ajax({
          action: 'wpstg--backups--remote-upload',
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce
        }, /*#__PURE__*/function () {
          var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(response) {
            var logEntries, html, issueFound, $logsContainer;
            return _regeneratorRuntime().wrap(function _callee2$(_context2) {
              while (1) switch (_context2.prev = _context2.next) {
                case 0:
                  backupReturnedError = 0;
                  if (!WPStagingBackup$1.isCancelled) {
                    _context2.next = 3;
                    break;
                  }
                  return _context2.abrupt("return");
                case 3:
                  if (!(typeof response === 'undefined')) {
                    _context2.next = 6;
                    break;
                  }
                  setTimeout(function () {
                    WPStagingBackupRemoteUpload.remoteUploadBackup();
                  }, wpstg.delayReq);
                  return _context2.abrupt("return");
                case 6:
                  WPStagingBackup$1.processResponse(response);
                  if (!WPStagingBackup$1.processInfo.interval) {
                    WPStagingBackup$1.statusStart('create');
                  }
                  if (!(response.isRunning === true)) {
                    _context2.next = 12;
                    break;
                  }
                  WPStagingBackupRemoteUpload.remoteUploadBackup();
                  _context2.next = 30;
                  break;
                case 12:
                  if (!(response.jobStatus === 'JOB_FAIL')) {
                    _context2.next = 18;
                    break;
                  }
                  _context2.next = 15;
                  return WPStagingBackup$1.checkMemoryExhaustion(response, 'wpstg_remote_upload');
                case 15:
                  setTimeout(function () {
                    WPStagingBackupRemoteUpload.remoteUploadBackup();
                  }, wpstg.delayReq);
                  _context2.next = 30;
                  break;
                case 18:
                  $('#wpstg--progress--status').text('Backup successfully uploaded!');
                  if (!WPStagingBackup$1.messages.shouldWarn()) {
                    _context2.next = 22;
                    break;
                  }
                  // noinspection JSIgnoredPromiseFromCall
                  WPStagingBackup$1.logsModal();
                  return _context2.abrupt("return");
                case 22:
                  WPStagingBackup$1.statusStop();
                  logEntries = document.querySelector('.wpstg-backup-process-logs').innerHTML;
                  html = '<div class="wpstg-backup-process-logs">' + logEntries + '</div>';
                  issueFound = html.includes('wpstg--modal--process--msg--warning') || html.includes('wpstg--modal--process--msg--error') ? 'Issues(s) found!<br> ' : '';
                  WPStagingBackup$1.downloadModal({
                    title: 'Backup Upload Complete',
                    bodyText: '' + issueFound
                  });
                  $('.wpstg-backup-success-logs-wrapper').show();
                  $logsContainer = $('.wpstg-backup-success-logs');
                  WPStagingBackup$1.messages.data.all.forEach(function (message) {
                    var msgClass = "wpstg--modal--process--msg--" + message.type.toLowerCase();
                    $logsContainer.append("<p class=\"" + msgClass + "\">[" + message.type + "] - [" + message.date + "] - " + message.message + "</p>");
                  });
                case 30:
                case "end":
                  return _context2.stop();
              }
            }, _callee2);
          }));
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }(), 'json', false, 0,
        // Don't retry upon failure
        1.25, function (xhr, textStatus, errorThrown) {
          WPStagingCommon.continueErrorHandle = false;
          console.log(xhr);
          var response = {
            'messages': []
          };
          backupReturnedError++;

          // Prevents loop in case PHP crashes constantly before being able to respond
          if (backupReturnedError <= maxBackupSequentialReturnError) {
            WPStagingBackupRemoteUpload.remoteUploadBackup();
          } else {
            response.messages.push({
              'type': 'critical',
              'message': 'There was a PHP fatal error while processing the backup. You might need to check your PHP error log to find out the reason. Please contact WPSTAGING support if you need help.'
            });
            WPStagingBackup$1.processResponse(response);
            WPStagingBackup$1.cancel();
            setTimeout(WPStagingBackup$1.logsModal, 500);
          }
        });
      }
    };
  })(jQuery);

  /**
   * Represents a class for managing and displaying process and success modals in WPStaging.
   * This class provides methods to start, open, initialize, update, and stop process modals.
   *
   * @class
   */
  var WpstgProcessModal = /*#__PURE__*/function () {
    function WpstgProcessModal(wpstgObject) {
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.wpstgObject = wpstgObject;
      this.action = '';
      this.isProcessCancelled = false;
      this.isProcessFinished = false;
      this.processTime = 0;
      this.processInterval = '';
      this.modal = null;
      this.disableCancelButton = false;
      this.title = '';
      this.showCancelButton = false;
      this.percentage = 0;
      this.cloneId = '';
      this.successModal = '';
      this.showProcessLogs = true;
      this.stagingSiteUrl = '';
      this.modalType = 'clone';
    }

    /**
     * Starts the process, initializes intervals, and modifies UI elements as needed.
     *
     * @return {void}
     */
    var _proto = WpstgProcessModal.prototype;
    _proto.start = function start() {
      var _this = this;
      this.showCancelButton = true;
      this.processInterval = setInterval(function () {
        if (wpstgAuthCheck.isAuthenticated || _this.action === 'wpstg_push_processing') {
          _this.processTime++;
          _this.updateElapsedTime();
        }
      }, 1000);
      if (this.action === 'wpstg_delete_clone') {
        hide('.wpstg-' + this.modalType + '-process-logs-button');
        this.showCancelButton = false;
        var container = WPStagingCommon.getSwalContainer();
        var processPercentageElement = container.querySelector('.wpstg-' + this.modalType + '-process-percent');
        processPercentageElement.textContent = 100;
      }
      if (this.action === 'wpstg_cloning' || this.action === 'wpstg_push_processing') {
        wpstgAuthCheck.status = true;
        wpstgAuthCheck.start();
      }
      hide('.wpstg-prev-step-link, #wpstg-start-updating, .wpstg-loader, #wpstg-cancel-cloning, .wpstg-log-details, .wpstg-progress-bar, #wpstg-processing-header');
      hide('.wpstg-processing-timer, #wpstg-cancel-pushing, .wpstg-progress-bar-wrapper, #wpstg-cancel-cloning-update, #wpstg-removing-clone');
    }

    /**
     * Stops the ongoing process, resets values, and clears intervals.
     *
     * @return {void}
     */;
    _proto.stop = function stop() {
      this.processTime = 0;
      this.modal = null;
      this.percentage = '';
      this.resetCancelChecks();
      clearInterval(this.processInterval);
      WPStagingCommon.closeSwalModal();
      loadingBar();
      hide('#wpstg-try-again, #wpstg-home-link, #wpstg-show-log-button, .wpstg-loader');
      if (this.action === 'wpstg_cloning' || this.action === 'wpstg_push_processing') {
        wpstgAuthCheck.stop();
      }
    };
    _proto.resetCancelChecks = function resetCancelChecks() {
      var _this2 = this;
      var element = document.getElementById('wpstg-new-clone');
      if (element === null) {
        setTimeout(function () {
          _this2.resetCancelChecks();
        }, 1000);
        return;
      }
      setTimeout(function () {
        _this2.isProcessCancelled = false;
        WPStaging.isCancelled = false;
      }, 2000);
      loadingBar('hidden');
    }

    /**
     * Cancels the ongoing process if confirmed by the user.
     *
     * @return {void}
     */;
    _proto.cancelProcess = function cancelProcess() {
      if (confirm('Are you sure you want to cancel cloning process?')) {
        WPStaging.isCancelled = true;
        this.isProcessCancelled = true;
        if (this.action === 'wpstg_push_processing') {
          var container = WPStagingCommon.getSwalContainer();
          var processTitleElement = container.querySelector('.wpstg-' + this.modalType + '-process-title');
          processTitleElement.textContent = 'Canceling Please wait....';
          this.stop();
          show('#wpstg-workflow');
          WPStaging.messages = [];
        } else {
          this.cancelCloneAction();
        }
      }
    }

    /**
     * Sets the title and cancellation status based on the response job or status.
     *
     * @param {Object} response - The response object containing information about the process job and status.
     * @return {void}
     */;
    _proto.setTitle = function setTitle(response) {
      this.title = response.job;
      if (response.job === 'database' || response.job === 'jobCopyDatabaseTmp') {
        this.title = 'Copying Database';
        this.disableCancelButton = false;
      } else if (response.job === 'SearchReplace') {
        this.title = 'Processing Data';
        this.disableCancelButton = false;
      } else if (response.job === 'PreserveDataSecondStep' || response.job === 'PreserveDataFirstStep') {
        this.title = 'Preserve Data';
        this.disableCancelButton = false;
      } else if (response.job === 'directories' || response.job === 'jobFileScanning') {
        this.title = 'Scanning Files';
        this.disableCancelButton = false;
      } else if (response.job === 'files' || response.job === 'data' || response.job === 'jobCopy' || response.job === 'jobSearchReplace') {
        this.title = 'Copying Files';
        this.disableCancelButton = false;
      } else if (response.job === 'Backup') {
        this.title = 'Backup Files Scanning';
        this.disableCancelButton = false;
      } else if (response.job === 'finish' || response.status === 'finished') {
        this.title = 'Process Finished';
        this.disableCancelButton = false;
      } else if (response.job === 'jobDatabaseRename') {
        this.title = 'Renaming Database';
        this.disableCancelButton = true;
      } else if (response.job === 'jobData') {
        this.title = 'Updating Database Data';
        this.disableCancelButton = true;
      }
    }

    /**
     * Sets the stored percentage value if the provided parameter is not null.
     *
     * @param {Object} params - Parameters containing the percentage value.
     * @return {void}
     */;
    _proto.setPercentage = function setPercentage(params) {
      if (params.percentage !== null) {
        this.percentage = params.percentage;
      }
    }

    /**
     * Initializes the process modal with specific behavior and appearance configurations.
     *
     * @return {void}
     */;
    _proto.initializeProcessModal = function initializeProcessModal() {
      var _this3 = this;
      var modal = document.getElementById('wpstg-' + this.modalType + '-process-modal');
      var html = modal.innerHTML;
      modal.parentNode.removeChild(modal);
      this.modal = {
        html: null,
        cancelBtnTxt: null,
        processTime: 0,
        instance: WPStagingCommon.getSwalModal(true, {
          content: 'wpstg--process--content'
        }).fire({
          html: html,
          cancelButtonText: 'Cancel',
          showCancelButton: this.showCancelButton,
          showConfirmButton: false,
          showCloseButton: false,
          showLoaderOnConfirm: false,
          allowEscapeKey: false,
          allowOutsideClick: false,
          onRender: function onRender() {
            var cancelButton = WPStagingCommon.getSwalContainer().getElementsByClassName('wpstg--swal2-cancel wpstg--btn--cancel')[0];
            var btnCancel = cancelButton.cloneNode(true);
            cancelButton.parentNode.replaceChild(btnCancel, cancelButton);
            btnCancel.addEventListener('click', function () {
              _this3.cancelProcess();
            });
            var showLogsButton = WPStagingCommon.getSwalContainer().getElementsByClassName('wpstg-' + _this3.modalType + '-process-logs-button')[0];
            var showLogs = showLogsButton.cloneNode(true);
            showLogsButton.parentNode.replaceChild(showLogs, showLogsButton);
            showLogs.addEventListener('click', function (e) {
              _this3.renderProcessLogs('process', e);
            });
          }
        })
      };
      this.start();
    }

    /**
     * Sets the content of the process modal based on the stored title, percentage, and cancellation status.
     *
     * @return {void}
     */;
    _proto.setProcessModal = function setProcessModal() {
      var container = WPStagingCommon.getSwalContainer();
      var cancelButton = container.getElementsByClassName('wpstg--swal2-cancel wpstg--btn--cancel')[0];
      var processTitleElement = container.querySelector('.wpstg-' + this.modalType + '-process-title');
      var processPercentageElement = container.querySelector('.wpstg-' + this.modalType + '-process-percent');
      processTitleElement.textContent = this.title;
      processPercentageElement.textContent = this.percentage;
      cancelButton.disabled = this.disableCancelButton;
    }

    /**
     * Opens and initializes a process modal with the provided data and parameters.
     *
     * @param {Object|undefined} data - Data related to the process.
     * @param {Object} params - Parameters for configuring the process modal.
     * @param {boolean} [showLogs=false] - Whether to display logs in the modal.
     * @param {boolean} [showCancelButton=true] - Whether to show the cancel button in the modal.
     * @return {void}
     */;
    _proto.openProcessModal = function openProcessModal(data, params, showLogs, showCancelButton) {
      if (showLogs === void 0) {
        showLogs = false;
      }
      if (showCancelButton === void 0) {
        showCancelButton = true;
      }
      if (!this.isProcessCancelled && !WPStaging.isCancelled) {
        if (data !== undefined) {
          this.action = data.action;
          this.cloneId = data.cloneID;
        }
        this.showCancelButton = showCancelButton;
        this.showLogs = showLogs;
        if (!this.modal) {
          WPStagingCommon.resetErrors();
          this.initializeProcessModal();
        } else {
          if (params.job) {
            this.setTitle(params);
            this.setPercentage(params);
            this.setProcessModal();
            if (params.job === 'finish') {
              this.stop();
            }
          } else {
            if (params.status === 'finished') {
              this.stop();
            }
          }
        }
      }
    };
    /**
     * Formats the given time duration (in seconds) into a string representation (HH:mm:ss).
     *
     * @return {string} The formatted time duration string.
     */
    _proto.formatTimeDuration = function formatTimeDuration() {
      return new Date(this.processTime * 1000).toISOString().slice(11, 19) + 's';
    }

    /**
     * Updates the displayed elapsed time in the modal if a process interval is set.
     *
     * @return {void}
     */;
    _proto.updateElapsedTime = function updateElapsedTime() {
      if (this.processInterval !== null) {
        var container = WPStagingCommon.getSwalContainer();
        var elapsedTimeElement = container.querySelector('.wpstg-' + this.modalType + '-process-elapsed-time');
        elapsedTimeElement.textContent = this.formatTimeDuration();
      }
    };
    /**
     * Determines the corresponding cancellation action name based on the current action.
     *
     * @return {string|undefined} The cancellation action name or undefined if no match is found.
     */
    _proto.getCancelCloneAction = function getCancelCloneAction() {
      var _this4 = this;
      var actions = [{
        name: 'wpstg_cloning',
        cancel: 'wpstg_cancel_clone'
      }, {
        name: 'wpstg_reset',
        cancel: 'wpstg_cancel_update'
      }, {
        name: 'wpstg_update',
        cancel: 'wpstg_cancel_update'
      }, {
        name: 'wpstg_push_processing',
        cancel: 'wpstg_cancel_push_processing'
      }];
      if (this.action !== '') {
        var result = actions.find(function (action) {
          return action.name === _this4.action;
        });
        return result.cancel;
      }
    }

    /**
     * Cancels the ongoing clone action if there is one, using a fetch request.
     * If the cancellation is successful, it stops the action and optionally reloads the page.
     * If there are further actions or the cancellation is not successful, it retries the cancellation process recursively.
     *
     * @return {void}
     */;
    _proto.cancelCloneAction = function cancelCloneAction() {
      var _this5 = this;
      if (this.action) {
        fetch(this.wpstgObject.ajaxUrl, {
          method: 'POST',
          credentials: 'same-origin',
          body: new URLSearchParams({
            action: this.getCancelCloneAction(),
            accessToken: this.wpstgObject.accessToken,
            nonce: this.wpstgObject.nonce,
            clone: this.cloneId
          }),
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          }
        }).then(function (response) {
          if (response.ok) {
            return response.json();
          }
          return Promise.reject(response);
        }).then(function (response) {
          if (response && 'undefined' !== typeof response["delete"] && response["delete"] === 'finished' || response === true) {
            _this5.stop();
            WPStaging.loadOverview();
            WPStaging.messages = [];
          }
          if (response !== true) {
            _this5.cancelCloneAction();
          }
        })["catch"](function (error) {
          console.log(_this5.wpstgObject.i18n['somethingWentWrong'], error);
        });
      }
    }

    /**
     * Initializes the success modal with the provided parameters and displays it.
     *
     * @param {Object} params - The parameters for configuring the success modal content.
     * @return {void}
     */;
    _proto.initializeSuccessModal = function initializeSuccessModal(params) {
      var _this6 = this;
      this.successModal = this.setSuccessModalContent(params);
      WPStagingCommon.getSwalModal(true, {
        confirmButton: 'wpstg--btn--confirm wpstg-green-button wpstg-button wpstg-link-btn wpstg-100-width'
      }).fire({
        'icon': 'success',
        'html': this.successModal.innerHTML,
        'confirmButtonText': 'Close',
        'showCancelButton': false,
        'showConfirmButton': true,
        'allowOutsideClick': false,
        'onRender': function onRender() {
          var showLogsButton = WPStagingCommon.getSwalContainer().getElementsByClassName('wpstg-' + _this6.modalType + '-success-logs-button')[0];
          var showLogs = showLogsButton.cloneNode(true);
          showLogsButton.parentNode.replaceChild(showLogs, showLogsButton);
          showLogs.addEventListener('click', function (e) {
            _this6.renderProcessLogs('success', e);
          });
        }
      }).then(function (result) {
        if (result.value) {
          WPStagingCommon.closeSwalModal();
          hide('.wpstg-loader');
          WPStaging.messages = [];
          if (_this6.action === 'wpstg_push_processing') {
            location.reload();
          }
          _this6.action = '';
        }
      });
      if (this.showProcessLogs) {
        show('.wpstg-' + this.modalType + '-success-logs-wrapper');
      }
      hide('.wpstg-loader');
      if (this.action !== 'wpstg_delete_clone') {
        WPStaging.loadOverview();
      }
    }

    /**
     * Sets the content of the success modal based on the provided parameters.
     *
     * @param {Object} params - The parameters for configuring the modal content.
     * @param {string|null} params.title - The title to be displayed in the modal.
     * @param {string|null|undefined} params.body - The body content of the modal.
     * @returns {HTMLElement} The modified modal element.
     */;
    _proto.setSuccessModalContent = function setSuccessModalContent(params) {
      var modal = document.getElementById('wpstg-' + this.modalType + '-success-modal');
      if (params.title !== null) {
        modal.innerHTML = modal.innerHTML.replace('{title}', params.title);
      }
      if (this.showProcessLogs) {
        modal.innerHTML = modal.innerHTML.replace('{btnTxtLog}', '<span style="text-decoration: underline">Show Logs</span>');
      }
      if (params.body !== null && typeof params.body !== 'undefined') {
        var messageBody = params.body;
        if (this.stagingSiteUrl !== null) {
          messageBody += '<br><strong><a href="' + this.stagingSiteUrl + '" target="_blank" id="wpstg-clone-url">' + this.stagingSiteUrl + '</a></strong>';
        }
        if (this.action === 'wpstg_push_processing') {
          messageBody += '<a href="https://wp-staging.com/refresh-and-clear-cache/" target="_blank">How to delete the cache.</a>';
          var downloadModalTextElement = modal.querySelector('.wpstg-clone-success-modal-text');
          if (downloadModalTextElement) {
            downloadModalTextElement.classList.add('wpstg--red');
          }
        }
        if (this.action === 'wpstg_cloning') {
          var wpstgRateUsElement = modal.querySelector('.wpstg-rate-us');
          if (wpstgRateUsElement) {
            wpstgRateUsElement.classList.add('show');
          }
        }
        modal.innerHTML = modal.innerHTML.replace('{text}', messageBody);
      } else {
        modal.innerHTML = modal.innerHTML.replace('{text}', '');
      }
      return modal;
    }

    /**
     * Opens a success modal after successfully cloning process.
     *
     * @param {Object} params - The parameters for initializing the success modal.
     * @param {boolean} [showLogs=false] - Whether to display process logs in the modal.
     * @param {string|null} [siteUrl=null] - The URL of the staging site, if applicable.
     * @return {void}
     */;
    _proto.openSuccessModal = function openSuccessModal(params, showLogs, siteUrl) {
      if (showLogs === void 0) {
        showLogs = false;
      }
      if (siteUrl === void 0) {
        siteUrl = null;
      }
      this.stagingSiteUrl = siteUrl;
      this.showProcessLogs = showLogs;
      this.initializeSuccessModal(params);
    }

    /**
     * @return {string}
     */;
    _proto.getModalType = function getModalType() {
      return this.modalType;
    }

    /**
     * Display logs in a modal.
     * and avoid mixing of different processes logs
     * @return {void}
     */;
    _proto.renderProcessLogs = function renderProcessLogs(processType, event) {
      if (processType === void 0) {
        processType = 'process';
      }
      var container = WPStagingCommon.getSwalContainer();
      if (window.WPStaging.messages.length !== 0) {
        var logsContainer = container.querySelector('.wpstg-' + this.modalType + '-' + processType + '-logs');
        logsContainer.innerHTML = '';
        window.WPStaging.messages.forEach(function (message) {
          var msgClass = "wpstg--modal--process--msg--" + message.type.toLowerCase();
          var pElement = document.createElement('p');
          pElement.className = msgClass;
          pElement.textContent = "[" + message.type + "] - [" + message.date + "] - " + message.message;
          logsContainer.appendChild(pElement);
        });
      }
      var logs = container.querySelector('.wpstg-' + this.modalType + '-' + processType + '-logs');
      var logBtn = event.target;
      event.preventDefault();
      if (logs.style.display === 'none' || logs.style.display === '') {
        logs.style.display = 'block';
        logBtn.textContent = wpstg.i18n.hideLogs;
        container.childNodes[0].style.width = '97%';
        container.style.zIndex = 9999;
      } else {
        logs.style.display = 'none';
        logBtn.textContent = wpstg.i18n.showLogs;
        container.childNodes[0].style.width = '600px';
      }
    };
    return WpstgProcessModal;
  }();

  function wpstgGetAdvancedCloningOptions(cloneData) {
    if (cloneData === undefined) {
      return;
    }

    // new admin account
    cloneData.useNewAdminAccount = isElementChecked('#wpstg-new-admin-user');
    cloneData.adminEmail = getInputValue('#wpstg-new-admin-email');
    cloneData.adminPassword = getInputValue('#wpstg-new-admin-password');

    // external database
    cloneData.databaseServer = getInputValue('#wpstg-db-server');
    cloneData.databaseUser = getInputValue('#wpstg-db-user');
    cloneData.databasePassword = getInputValue('#wpstg-db-pass');
    cloneData.databaseDatabase = getInputValue('#wpstg-db-database');
    cloneData.databasePrefix = getInputValue('#wpstg-db-prefix');
    cloneData.databaseSsl = isElementChecked('#wpstg-db-ssl');

    // custom host
    var cloneDir = getInputValue('#wpstg_clone_dir');
    cloneData.cloneDir = encodeURIComponent(cloneDir.trim());
    cloneData.cloneHostname = getInputValue('#wpstg_clone_hostname');

    // custom behavior
    cloneData.cronDisabled = isElementChecked('#wpstg_disable_cron');
    cloneData.emailsAllowed = isElementChecked('#wpstg_allow_emails');
    cloneData.networkClone = isElementChecked('#wpstg_network_clone');
    cloneData.uploadsSymlinked = isElementChecked('#wpstg_symlink_upload');

    // clean up during clone update
    cloneData.cleanPluginsThemes = isElementChecked('#wpstg-clean-plugins-themes');
    cloneData.cleanUploadsDir = isElementChecked('#wpstg-clean-uploads');
    return cloneData;
  }

  /**
   * Manage Refreshing License
   */
  var Licensing = /*#__PURE__*/function () {
    function Licensing(wpstgObject) {
      if (wpstgObject === void 0) {
        wpstgObject = wpstg;
      }
      this.wpstgObject = wpstgObject;
      this.wpstgRefreshLicenseLink = document.querySelector('#wpstg-refresh-license-link');
      this.wpstgRefreshLicenseLoader = '#wpstg-refresh-license-loader';
      this.init();
      this.addEvent();
    }

    /**
     * Adds an event listener to refresh license status.
     *
     * @return {void}
     */
    var _proto = Licensing.prototype;
    _proto.addEvent = function addEvent() {
      var _this = this;
      if (this.wpstgRefreshLicenseLink !== null) {
        this.wpstgRefreshLicenseLink.addEventListener('click', function () {
          show(_this.wpstgRefreshLicenseLoader);
          _this.refreshLicenseStatus();
        });
      }
    }

    /**
     *
     * @return {void}
     */;
    _proto.init = function init() {
      this.notyf = new Notyf({
        duration: 6000,
        position: {
          x: 'center',
          y: 'bottom'
        },
        dismissible: true,
        types: [{
          type: 'warning',
          background: 'orange',
          icon: true
        }]
      });
    }

    /**
     * Refreshes the license status.
     *
     * @return {void}
     */;
    _proto.refreshLicenseStatus = function refreshLicenseStatus() {
      var _this2 = this;
      fetch(this.wpstgObject.ajaxUrl, {
        method: 'POST',
        credentials: 'same-origin',
        body: new URLSearchParams({
          action: 'wpstg-refresh-license-status',
          accessToken: this.wpstgObject.accessToken,
          nonce: this.wpstgObject.nonce
        }),
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(function (response) {
        if (response.ok) {
          return response.json();
        }
        return Promise.reject(response);
      }).then(function (data) {
        hide(_this2.wpstgRefreshLicenseLoader);
        if (!data.success) {
          _this2.notyf.error('Please check your license key and try again');
          return;
        }
        _this2.notyf.success('License refreshed successfully');
      })["catch"](function (error) {
        _this2.notyf.error(error);
      });
    };
    return Licensing;
  }();

  var WPStagingPro = function ($) {
    var that = {
      isCancelled: false,
      isFinished: false,
      getLogs: false,
      tableSelector: null,
      fileSelector: null,
      directoryNavigator: null,
      notyf: null
    };
    that.wpstgProcessModal = new WpstgProcessModal();
    // Cache Elements
    var cache = {
      elements: []
    };

    /**
       * Get / Set Cache for Selector
       * @param {String} selector
       * @return {*}
       */
    cache.get = function (selector) {
      // It is already cached!
      if ($.inArray(selector, cache.elements) !== -1) {
        return cache.elements[selector];
      }

      // Create cache and return
      cache.elements[selector] = jQuery(selector);
      return cache.elements[selector];
    };

    /**
       * Refreshes given cache
       * @param {String} selector
       */
    cache.refresh = function (selector) {
      selector.elements[selector] = jQuery(selector);
    };

    /**
       * Ajax Scanning before starting push process
       */
    var startScanning = function startScanning() {
      // Scan db and file system
      var $workFlow = cache.get('#wpstg-workflow');
      $workFlow
      // Load scanning data
      .on('click', '.wpstg-push-changes', function (e) {
        var currentObj = this;
        WPStaging.checkUserDbPermissions('push').then(function (data) {
          e.preventDefault();
          var $this = $(currentObj);

          // Disable button
          if ($this.attr('disabled')) {
            return false;
          }

          // Add loading overlay
          $workFlow.addClass('loading');

          // Get clone id
          var cloneID = $(currentObj).data('clone');

          // Prepare data
          that.data = {
            action: 'wpstg_scan',
            clone: cloneID,
            accessToken: wpstg.accessToken,
            nonce: wpstg.nonce
          };

          // Send ajax request
          WPStaging.ajax(that.data, function (response) {
            if (response.length < 1) {
              showError('Something went wrong! No response.  Go to WP Staging > Settings and lower \'File Copy Limit\' and \'DB Query Limit\'. Also set \'CPU Load Priority to low \'' + 'and try again. If that does not help, ' + '<a href=\'https://wp-staging.com/support/\' target=\'_blank\'>open a support ticket</a> ');
            }

            // Styling of elements
            $workFlow.removeClass('loading').html(response);
            WPStaging.switchStep(2);
            cache.get('.wpstg-step3-cloning').hide();
            cache.get('.wpstg-step3-pushing').show();
            cache.get('.wpstg-loader').hide();
            that.directoryNavigator = new WpstgDirectoryNavigation('#wpstg-scanning-files', wpstg, that.notyf);
            that.directoryNavigator.countSelectedFiles();
            that.tableSelector = new WpstgPushTableSelection();
            that.fileSelector = new WpstgPushFileSelection();
            that.tableSelector.countSelectedTables();
            that.fileSelector.countSelectedFiles();
          }, 'HTML');
        });
      })
      // Back Button
      .on('click', '.wpstg-prev-step-link', function (e) {
        e.preventDefault();
        WPStaging.loadOverview();
      }).on('click', '#wpstg-use-target-dir', function (e) {
        e.preventDefault();
        $('#wpstg_clone_dir').val(this.getAttribute('data-path'));
      }).on('click', '#wpstg-use-target-hostname', function (e) {
        e.preventDefault();
        $('#wpstg_clone_hostname').val(this.getAttribute('data-uri'));
      }).on('change', '#wpstg-delete-upload-before-pushing', function (e) {
        if (e.currentTarget.checked) {
          $('#wpstg-backup-upload-container').show();
        } else {
          $('#wpstg-backup-upload-container').hide();
          $('#wpstg-backup-upload-before-pushing').removeAttr('checked');
        }
      });
    };

    // Start the whole pushing process
    var startProcess = function startProcess() {
      var $workFlow = cache.get('#wpstg-workflow');

      // Click push changes button
      $workFlow.on('click', '#wpstg-push-changes', function (e) {
        e.preventDefault();

        // Hide db tables and folder selection
        cache.get('.wpstg-tabs-wrapper').hide();
        cache.get('#wpstg-push-changes').hide();
        cache.get('.wpstg-prev-step-link').hide();
        cache.get('#wpstg-push-changes-details').hide();

        // Show confirmation modal
        var cloneName = cache.get('#wpstg-push-changes').data('clone-name');
        var html = '<p class=\'wpstg-push-confirmation-message\'>This will overwrite the production/live site and its plugins, themes and media assets with data from the staging site: "' + cloneName + '".  <br/><br/>Database data will be overwritten for each selected table. Take care if you use a shop system like WooCommerce and read the <a href="https://wp-staging.com/docs/skip-woocommerce-orders-and-products/" target="_blank">FAQ</a>. <br/><br/><b>Important:</b> Before you proceed make sure that you have a full site backup. If the pushing process is not successful contact us at <a href=\'mailto:support@wp-staging.com\'>support@wp-staging.com</a> or use the Contact Us button.</p>';
        confirmModal('Do you want to push the staging site?', html, 'Push', 'wpstg-confirm-push').then(function (result) {
          if (result.value) {
            cache.get('#wpstg-push-changes').attr('disabled', true);
            cache.get('.wpstg-prev-step-link').attr('disabled', true);
            cache.get('#wpstg-scanning-files').hide();
            cache.get('.wpstg-progress-bar-wrapper').hide();
            cache.get('#wpstg-cancel-pushing').hide(); // show cancel button
            WPStaging.switchStep(3);
            window.addEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
            processing();
            return;
          }

          // Show db tables and folder selection
          cache.get('.wpstg-tabs-wrapper').show();
          cache.get('#wpstg-push-changes').show();
          cache.get('.wpstg-prev-step-link').show();
        });
      });
    };
    var cancelPushingProcess = function cancelPushingProcess() {
      WPStaging.ajax({
        action: 'wpstg_cancel_push_processing',
        accessToken: wpstg.accessToken,
        nonce: wpstg.nonce
      }, function (response) {
        if (response.success) {
          that.isCancelled = true;
          cache.get('.wpstg-loader').hide();
          cache.get('#wpstg-cancel-pushing').hide();
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          WPStaging.loadOverview();
          return;
        }
      }, 'json', false);
    };

    /**
       * Start ajax processing
       * @return string
       */
    var processing = function processing() {
      // Get clone id
      var cloneID = cache.get('#wpstg-push-changes').data('clone');
      var deleteUploadsBeforePush = cache.get('#wpstg-delete-upload-before-pushing')[0].checked;
      var backupUploadsBeforePush = false;
      if (deleteUploadsBeforePush) {
        backupUploadsBeforePush = cache.get('#wpstg-backup-upload-before-pushing')[0].checked;
      }
      var includedTables = getSelectedTablesToPush();
      var excludedTables = getExcludedTables();
      var allTablesExcluded = false;
      that.isCancelled = false;
      if (includedTables.length > excludedTables.length) {
        includedTables = '';
      } else if (excludedTables.length > includedTables.length) {
        excludedTables = '';
        allTablesExcluded = includedTables === '';
      }
      WPStaging.ajax({
        action: 'wpstg_push_processing',
        accessToken: wpstg.accessToken,
        nonce: wpstg.nonce,
        clone: cloneID,
        includedTables: includedTables,
        excludedTables: excludedTables,
        allTablesExcluded: allTablesExcluded,
        selectedTablesWithoutPrefix: getSelectedTablesWithoutPrefix(),
        includedDirectories: getIncludedDirectories(),
        excludedDirectories: getExcludedDirectories(),
        extraDirectories: getIncludedExtraDirectories(),
        createBackupBeforePushing: cache.get('#wpstg-create-backup-before-pushing')[0].checked,
        deletePluginsAndThemes: cache.get('#wpstg-remove-uninstalled-plugins-themes')[0].checked,
        deleteUploadsBeforePushing: deleteUploadsBeforePush,
        backupUploadsBeforePushing: backupUploadsBeforePush
      }, function (response) {
        if (that.isCancelled) {
          cancelPushingProcess();
          cache.get('.wpstg-loader').hide();
          cache.get('#wpstg-cancel-pushing').hide();
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          return;
        }
        // Undefined Error
        if (false === response) {
          showError('Something went wrong! Error: No response.  Go to WP Staging > Settings and lower \'File Copy Limit\' and \'DB Query Limit\'. Also set \'CPU Load Priority to low \'' + 'and try again. If that does not help, ' + '<a href=\'https://wp-staging.com/support/\' target=\'_blank\'>open a support ticket</a> ');
          cache.get('.wpstg-loader').hide();
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          return;
        }

        // Throw Error
        if ('undefined' !== typeof response.error && response.error) {
          WPStaging.showError('Something went wrong! Error: ' + response.message + '.  Go to WP Staging > Settings and lower \'File Copy Limit\' and \'DB Query Limit\'. Also set \'CPU Load Priority to low \'' + 'and try again. If that does not help, ' + '<a href=\'https://wp-staging.com/support/\' target=\'_blank\'>open a support ticket</a> ');
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          return;
        }

        // Add Log messages
        if ('undefined' !== typeof response.last_msg && response.last_msg) {
          if (typeof WPStaging.getLogs === 'function') {
            WPStaging.getLogs(response.last_msg);
          }
        }

        // Continue processing
        if (false === response.status) {
          progressBar(response);
          setTimeout(function () {
            cache.get('.wpstg-loader').show();
            processing();
          }, wpstg.delayReq);
        } else if (true === response.status) {
          progressBar(response);
          processing();
        } else if ('finished' === response.status || 'undefined' !== typeof response.job_done && response.job_done) {
          window.removeEventListener('beforeunload', WPStaging.warnIfClosingDuringProcess);
          isFinished(response);
        }
      }, 'json', false);
    };

    /**
       * Test database connection
       * @return object
       */
    var connectDatabase = function connectDatabase() {
      var $workFlow = cache.get('#wpstg-workflow');
      $workFlow.on('click', '#wpstg-db-connect', function (e) {
        e.preventDefault();
        cache.get('.wpstg-loader').show();
        cache.get('#wpstg-db-status').hide();
        WPStaging.ajax({
          action: 'wpstg_database_connect',
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce,
          databaseUser: cache.get('#wpstg-db-user').val(),
          databasePassword: cache.get('#wpstg-db-pass').val(),
          databaseServer: cache.get('#wpstg-db-server').val(),
          databaseDatabase: cache.get('#wpstg-db-database').val(),
          databasePrefix: cache.get('#wpstg-db-prefix').val(),
          databaseSsl: cache.get('#wpstg-db-ssl').is(':checked')
        }, function (response) {
          // Undefined Error
          if (false === response) {
            showError('Something went wrong! Error: No response.' + 'Please try again. If that does not help, ' + '<a href=\'https://wp-staging.com/support/\' target=\'_blank\'>open a support ticket</a> ');
            cache.get('.wpstg-loader').hide();
            cache.get('#wpstg-db-status').remove();
            cache.get('#wpstg-error-details').hide();
            cache.get('#wpstg-db-connect').after('<span id="wpstg-db-status" class="wpstg-failed"> Failed</span>');
            return;
          }
          if ('undefined' !== typeof response.success && response.success) {
            cache.get('.wpstg-loader').hide();
            cache.get('#wpstg-db-status').hide();
            cache.get('#wpstg-error-details').hide();
            cache.get('#wpstg-db-error').hide();
            notify('success', 'Database connection successful');
            return;
          }
          var connectError = 'Failed response';
          // Throw Error
          if ('undefined' !== typeof response.data && 'undefined' !== typeof response.data.message && response.data.message) {
            connectError = response.data.message;
          }
          WPStaging.showError('Something went wrong! Error: ' + connectError + ' Please try again. If it still fails, ' + '<a href=\'https://wp-staging.com/support/\' target=\'_blank\'>open a support ticket</a> ');
          cache.get('.wpstg-loader').hide();
          cache.get('#wpstg-db-status').hide();
          cache.get('#wpstg-db-error').remove();
          notify('error', 'Error: ' + connectError);
          return;
        }, 'json', false);
      });

      // Make form fields editable
      $workFlow.on('click', '#wpstg-ext-db', function () {
        if (this.checked) {
          cache.get('#wpstg-db-server').removeAttr('readonly');
          cache.get('#wpstg-db-user').removeAttr('readonly');
          cache.get('#wpstg-db-pass').removeAttr('readonly');
          cache.get('#wpstg-db-database').removeAttr('readonly');
          cache.get('#wpstg-db-prefix').removeAttr('readonly');
          cache.get('#wpstg-db-ssl').removeAttr('readonly');
        } else {
          cache.get('#wpstg-db-server').attr('readonly', true).val('');
          cache.get('#wpstg-db-user').attr('readonly', true).val('');
          cache.get('#wpstg-db-pass').attr('readonly', true).val('');
          cache.get('#wpstg-db-database').attr('readonly', true).val('');
          cache.get('#wpstg-db-prefix').attr('readonly', true).val('');
          cache.get('#wpstg-db-ssl').attr('readonly', true).prop('checked', false);
        }
      });
    };
    var editCloneData = function editCloneData() {
      // Scan db and file system
      var $workFlow = cache.get('#wpstg-workflow');
      $workFlow
      // Load scanning data
      .on('click', '.wpstg-edit-clone-data', function (e) {
        e.preventDefault();
        that.wpstgCloneEdit = new WpstgCloneEdit();
        var $this = $(this);

        // Disable button
        if ($this.attr('disabled')) {
          return false;
        }

        // Get clone id
        var cloneID = $(this).data('clone');

        // Prepare data
        that.data = {
          action: 'wpstg_edit_clone_data',
          clone: cloneID,
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce
        };

        // Send ajax request
        WPStaging.ajax(that.data, function (response) {
          $workFlow.html(response);
        }, 'HTML');
      })
      // Back button on 'edit' page
      .on('click', '.wpstg-prev-step-link', function (e) {
        e.preventDefault();
        WPStaging.loadOverview();
      }).on('click', '#wpstg-save-clone-data', function (e) {
        e.preventDefault();
        var idPrefix = '#wpstg-edit-clone-data-';
        var cloneID = cache.get(idPrefix + 'clone-id').val();
        var cloneName = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'clone-name').val());
        var directoryName = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'directory-name').val());
        var path = cache.get(idPrefix + 'path').val();
        var url = cache.get(idPrefix + 'url').val();
        var prefix = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'prefix').val());
        var externalDBUser = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'database-user').val());
        var externalDBPassword = cache.get(idPrefix + 'database-password').val();
        var externalDBDatabase = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'database-database').val());
        var externalDBHost = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'database-server').val());
        var externalDBPrefix = WPStagingCommon.sanitizeEventAttribute(cache.get(idPrefix + 'database-prefix').val());
        var externalDBSsl = cache.get(idPrefix + 'database-ssl').is(':checked');

        // Prepare data
        that.data = {
          action: 'wpstg_save_clone_data',
          clone: cloneID,
          cloneName: cloneName,
          directoryName: directoryName,
          path: path,
          url: url,
          prefix: prefix,
          externalDBUser: externalDBUser,
          externalDBPassword: externalDBPassword,
          externalDBDatabase: externalDBDatabase,
          externalDBHost: externalDBHost,
          externalDBPrefix: externalDBPrefix,
          externalDBSsl: externalDBSsl,
          accessToken: wpstg.accessToken,
          nonce: wpstg.nonce
        };
        Promise.any([new Promise(function (resolve) {
          return that.wpstgCloneEdit.checkDatabase(resolve);
        })]).then(function () {
          if (that.wpstgCloneEdit.isDbConnected) {
            WPStaging.ajax(that.data, function (response) {
              if (response === 'Success') {
                WPStaging.loadOverview();
                notify('success', 'Clone data saved successfully');
              } else {
                alert(response);
              }
            }, 'HTML');
          } else {
            notify('error', 'Could not save clone data <br/> Error: ' + wpstg.i18n['dbConnectionFailed']);
          }
        })["catch"](function (error) {
          console.error('Error:', error);
          notify('error', 'Error:' + error);
        });
      });
    };

    /**
       * All jobs are finished
       * @param {object} response
       * @return object
       */
    var isFinished = function isFinished(response) {
      progressBar(response);
      cache.get('.wpstg-loader').hide();
      cache.get('.wpstg-prev-step-link').attr('disabled', false);
      cache.get('#wpstg-cancel-pushing').hide();
      if (wpstg.i18n.wpstg_push_processing !== null) {
        that.wpstgProcessModal.openSuccessModal(wpstg.i18n.wpstg_push_processing, true);
      }
    };

    /**
       * Get Included (Selected) Prefixed Database Tables
       * @return {Array}
       */
    var getSelectedTablesToPush = function getSelectedTablesToPush() {
      if (that.tableSelector === null) {
        return '';
      }
      return that.tableSelector.getIncludedTables();
    };

    /**
       * Get Excluded (Unchecked) Prefixed Database Tables
       * @return {Array}
       */
    var getExcludedTables = function getExcludedTables() {
      if (that.tableSelector === null) {
        return '';
      }
      return that.tableSelector.getExcludedTables();
    };

    /**
       * Get Non prefixed selected Database Tables
       * @return {Array}
       */
    var getSelectedTablesWithoutPrefix = function getSelectedTablesWithoutPrefix() {
      if (that.tableSelector === null) {
        return '';
      }
      return that.tableSelector.getSelectedTablesWithoutPrefix();
    };

    /**
       * A confirmation modal
       *
       * @param html
       * @param confirmText
       * @param confirmButtonClass
       * @return Promise
       */
    var confirmModal = function confirmModal(title, html, confirmText, confirmButtonClass) {
      return WPStagingCommon.getSwalModal(false, {
        container: 'wpstg-swal-push-container',
        confirmButton: confirmButtonClass + ' wpstg--btn--confirm wpstg-blue-primary wpstg-button wpstg-link-btn'
      }).fire({
        title: title,
        icon: 'warning',
        html: html,
        width: '750px',
        focusConfirm: false,
        confirmButtonText: confirmText,
        showCancelButton: true
      });
    };

    /**
       * Get Included Directories
       * @return {Array}
       */
    var getIncludedDirectories = function getIncludedDirectories() {
      var includedDirectories = [];
      $('.wpstg-dir input:checked').each(function () {
        var $this = $(this);
        if (!$this.parent('.wpstg-dir').parents('.wpstg-dir').children('.wpstg-expand-dirs').hasClass('disabled')) {
          includedDirectories.push($this.val());
        }
      });
      return includedDirectories;
    };

    /**
       * Get Excluded Directories
       * @return {Array}
       */
    var getExcludedDirectories = function getExcludedDirectories() {
      var excludedDirectories = [];
      $('.wpstg-dir input:not(:checked)').each(function () {
        var $this = $(this);
        excludedDirectories.push($this.val());
      });
      return excludedDirectories;
    };

    /**
       * Get Included Extra Directories
       * @return {Array}
       */
    var getIncludedExtraDirectories = function getIncludedExtraDirectories() {
      var extraDirectories = [];
      if (!$('#wpstg_extraDirectories').val()) {
        return extraDirectories;
      }
      var extraDirectories = $('#wpstg_extraDirectories').val().split(/\r?\n/);
      return extraDirectories;
    };
    var progressBar = function progressBar(response, restart) {
      if ('undefined' === typeof response.percentage) {
        return false;
      }
      if (response !== null) {
        if ('undefined' === typeof WPStaging.data) {
          WPStaging.data = {
            action: 'wpstg_push_processing'
          };
        }
        WPStaging.data.action = 'wpstg_push_processing';
        WPStaging.data.cloneID = cache.get('#wpstg-push-changes').data('clone');
        that.wpstgProcessModal.openProcessModal(WPStaging.data, response, true);
        var WpstagingProPushProccess = new Proxy(that.wpstgProcessModal, {
          set: function set(target, prop, value) {
            if (prop === 'isCancelled' && value === true) {
              that.isCancelled = true;
              cancelPushingProcess();
            }
            target[prop] = value;
            return true;
          }
        });
        WpstagingProPushProccess.isCancelled = that.wpstgProcessModal.isProcessCancelled;
      }
    };
    that.init = function () {
      startProcess();
      startScanning();
      connectDatabase();
      editCloneData();
      new WpstgCloneEdit();
      new WpstgRemoteStorage();
      new WpstgCloneGenerateLoginLink();
      new WpstgSyncAccount();
      WPStagingBackupEditSchedules$1.listen();
      new WpstgProcessModal();
      new Licensing();
    };
    return that;
  }(jQuery);
  jQuery(document).ready(function ($) {
    WPStagingPro.init();
    window.wpstgPro = {
      getAdvancedCloningOptions: wpstgGetAdvancedCloningOptions
    };
    jQuery(document).on('click', '#wpstg-update-mail-settings', function (e) {
      e.preventDefault();
      $('#wpstg-update-mail-settings').attr('disabled', 'disabled');
      var data = {
        action: 'wpstg_update_staging_mail_settings',
        emailsAllowed: $('#wpstg_allow_emails').is(':checked'),
        accessToken: wpstg.accessToken,
        nonce: wpstg.nonce
      };
      jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: data,
        error: function error(xhr, textStatus, errorThrown) {
          WPStagingCommon.getSwalModal().fire('Unknown error', 'Please get in contact with us to solve it support@wp-staging.com', 'error');
        },
        success: function success(response) {
          var alertType = 'error';
          if (response.success) {
            alertType = 'success';
          }
          WPStagingCommon.getSwalModal().fire('', response.message, alertType).then(function () {
            jQuery('.wpstg-mails-notice').slideUp('fast');
          });
          $('#wpstg-update-mail-settings').removeAttr('disabled');
          return true;
        },
        statusCode: {
          404: function _() {
            WPStagingCommon.getSwalModal().fire('404', 'Something went wrong; can\'t find ajax request URL! Please get in contact with us to solve it support@wp-staging.com', 'error');
          },
          500: function _() {
            WPStagingCommon.getSwalModal().fire('500', 'Something went wrong; internal server error while processing the request! Please get in contact with us to solve it support@wp-staging.com', 'error');
          }
        }
      });
    });
  });

  // export default {}

})();
//# sourceMappingURL=wpstg-admin-pro.js.map
