<?php

namespace WPStaging\Pro\Backup\Task\Tasks\JobRestore;

use WPStaging\Backup\Entity\BackupMetadata;
use WPStaging\Backup\Task\Tasks\JobRestore\RestoreDatabaseTask as BasicRestoreDatabaseTask;
use WPStaging\Pro\Backup\Dto\Task\Restore\RestoreDatabaseTaskDto;
use WPStaging\Pro\Backup\Service\Database\Importer\DatabaseSearchReplacer;

class RestoreDatabaseTask extends BasicRestoreDatabaseTask
{
    /** @var RestoreDatabaseTaskDto */
    protected $currentTaskDto;

    /** @return string */
    protected function getCurrentTaskType(): string
    {
        return RestoreDatabaseTaskDto::class;
    }

    /**
     * @return void
     */
    protected function setupSearchReplace()
    {
        // Early bail if SearchReplacerInterface is of wrong type
        if (!$this->databaseSearchReplacer instanceof DatabaseSearchReplacer) {
            return;
        }

        $backupMetadata = $this->jobDataDto->getBackupMetadata();

        $this->databaseSearchReplacer->setSourceAbsPath($backupMetadata->getAbsPath());
        $this->databaseSearchReplacer->setSourcePlugins($backupMetadata->getPlugins());
        $this->databaseSearchReplacer->setSourceUrls($backupMetadata->getSiteUrl(), $backupMetadata->getHomeUrl(), $backupMetadata->getUploadsUrl());
        $this->databaseSearchReplacer->setIsWpBakeryActive($backupMetadata->getWpBakeryActive());

        if (is_multisite() && $backupMetadata->getBackupType() === BackupMetadata::BACKUP_TYPE_MULTISITE) {
            $currentSubsiteId = $this->currentTaskDto->currentSubsiteId ?? 1;
            $this->databaseSearchReplacer->setupSubsitesSearchReplacer($backupMetadata, $currentSubsiteId);
        }

        $this->databaseImporter->setSearchReplace($this->databaseSearchReplacer->getSearchAndReplace(get_site_url(), get_home_url()));
    }
}
