<?php
/**
 *  WP-SpamShield - uninstall.php
 *	File Version 1.9.42
 *  This script uninstalls WP-SpamShield, removes its files from the plugin directory, and removes its options/data from the WP database.
 */

/* Make sure file remains secure if called directly */
if( !defined( 'ABSPATH' ) || !defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	if( !headers_sent() ) { @header( 'HTTP/1.0 403 Forbidden', TRUE, 403 ); @header( 'X-Robots-Tag: noindex', TRUE ); }
	die( 'ERROR: Direct access to this file is not allowed.' );
}

define( 'SS_UNIN_VERSION', '1.9.42' );

if( !defined( 'SS_UNIN_DS' )				)	{ define( 'SS_UNIN_DS',					DIRECTORY_SEPARATOR																	); }
if( !defined( 'SS_UNIN_REQUEST_TIME' )		)	{ define( 'SS_UNIN_REQUEST_TIME',		time()																				); }
if( !defined( 'SS_UNIN_CONTENT_DIR_PATH' )	)	{ define( 'SS_UNIN_CONTENT_DIR_PATH',	WP_CONTENT_DIR																		); }
if( !defined( 'SS_UNIN_CACHE_DIR_PATH' )	)	{ define( 'SS_UNIN_CACHE_DIR_PATH',		SS_UNIN_CONTENT_DIR_PATH . SS_UNIN_DS . 'cache-p' . SS_UNIN_DS . 'wp-spamshield'	); }
if( !defined( 'SS_UNIN_PLUGIN_DATA_PATH' )	)	{ define( 'SS_UNIN_PLUGIN_DATA_PATH',	SS_UNIN_CACHE_DIR_PATH . SS_UNIN_DS . 'data'										); }
if( !defined( 'SS_UNIN_PLUGIN_JS_PATH' )	)	{ define( 'SS_UNIN_PLUGIN_JS_PATH',		SS_UNIN_CACHE_DIR_PATH . SS_UNIN_DS . 'js'											); }
if( !defined( 'SS_UNIN_PLUGIN_TMP_PATH' )	)	{ define( 'SS_UNIN_PLUGIN_TMP_PATH',	SS_UNIN_CACHE_DIR_PATH . SS_UNIN_DS . 'tmp'											); }
if( !defined( 'SS_UNIN_PLUGIN_DIR' )		)	{ define( 'SS_UNIN_PLUGIN_DIR',			untrailingslashit( __DIR__ )														); }

/**
 *	WP-SpamShield UNINSTALL Class
 *	This class handles the uninstall process. It uninstalls WP-SpamShield, removes its files from the plugin directory, and removes its options/data from the WP database.
 */
class SS_UNIN_Uninstall {

	/* Initialize Class Variables */
	static public		$PHP_VER			= PHP_VERSION;
	static public		$WP_VER				= SS_UNIN_WP_VERSION;
	static public		$SS_UNIN_VER		= SS_UNIN_VERSION;
	static public		$pref				= 'SS_UNIN_';
	static public		$pref_lc			= 'ss_unin_';
	static public		$debug_server		= '.redsandmarketing.com';
	static public		$dev_url			= 'https://www.redsandmarketing.com/';
	static public		$DS					= SS_UNIN_DS;
	static public		$DATE_DAY			= NULL;
	static public		$HASH_HOUR			= NULL;
	static public		$REQUEST_TIME		= SS_UNIN_REQUEST_TIME;
	static public		$REQ_TS				= SS_UNIN_REQUEST_TIME;
	static public		$SITE_DOMAIN		= NULL;
	static public		$SITE_URL			= NULL;
	static public		$THIS_HOUR			= NULL;
	static public		$VER_SLUG			= NULL;
	static public		$boucanier			= NULL;
	static public		$RSMG_URL			= 'https://www.redsandmarketing.com/';
	static public		$HOME_URL			= 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/';
	static public		$SUPPORT_URL		= 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/support/';
	static public		$LICENSE_URL		= 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/license/';
	static public		$CC_URL				= 'https://www.redsandmarketing.com/go/cc/wp-spamshield/';

	/**
	 *	Use private methods to prevent cloning and unserializing, as those could produce unexpected/unwanted behavior(s).
	 *	@since			1.9.42
	 *	@return			void
	 */
	private final function __clone()  {}
	private final function __wakeup() {}

	function __construct() {
		/**
		 *	Do nothing...for now
		 */
	}

	/**
	 *	Init / General Setup - Stage 1: Define constants, initialize vars, check/set memory, etc.
	 *	@dependencies	...
	 *	@since			1.9.42
	 */
	static public function init() {
		
		if( !empty( $GLOBALS['ss_unin_has_run_'.__METHOD__] ) ) { return; }

		/* SS_UNIN_DEBUG - Do not change value unless tech support asks you to - for debugging only. Change in wp-config.php. */
		foreach( array( 'WP_DEBUG', 'SS_UNIN_DEBUG', 'SS_UNIN_DEBUG', ) as $cn ) { self::define( $cn, FALSE ); }; unset( $cn );
		if( TRUE !== WP_DEBUG && TRUE !== SS_UNIN_DEBUG ) { @ini_set( 'display_errors', 0 ); @error_reporting( 0 ); }

		/* Initialize/Populate Vars */
		self::$REQUEST_TIME	= self::$REQ_TS = time();
		self::$DATE_DAY		= date( 'Ymd', self::$REQ_TS );
		self::$THIS_HOUR	= date( 'Y-m-d H', self::$REQ_TS );
		self::$HASH_HOUR	= md5( self::$THIS_HOUR );
		self::$SITE_URL		= untrailingslashit( strtolower( home_url() ) );
		self::$SITE_DOMAIN	= self::get_domain( self::$SITE_URL );
		self::$VER_SLUG		= self::get_ver_slug( self::$SS_UNIN_VER );

		/* Delete Options */
		$del_options = array( 'wp_spamshield_version', 'spamshield_options', 'spamshield_widget_settings', 'spamshield_last_admin', 'spamshield_admins', 'spamshield_admin_notices', 'spamshield_count', 'spamshield_reg_count', 'spamshield_procdat', 'spamshield_install_status', 'spamshield_warning_status', 'spamshield_regalert_status', 'spamshield_nonces', 'spamshield_wpssmid_cache', 'spamshield_ubl_cache', 'spamshield_ubl_cache_disable', 'spamshield_ip_ban_disable', 'spamshield_ip_ban', 'spamshield_whitelist_keys', 'ak_count_pre', 'spamshield_init_user_approve_run', );
		foreach( (array) $del_options as $i => $option ) { delete_option( $option ); } /* TO DO: When Network Activation enabled, add Multisite - delete_site_option() */

		/* Delete Transients */
		$del_trans = array( 'wpss_iswpv_check', );
		foreach( (array) $del_trans as $i => $transient ) { delete_transient( $transient ); delete_site_transient( $transient ); }

		/* Unregister Widgets */
		$unreg_widgets = array( 'WP_SpamShield_Counter_LG', 'WP_SpamShield_Counter_CG', 'WP_SpamShield_End_Blog_Spam' );
		foreach( (array) $unreg_widgets as $i => $widget ) { unregister_widget( $widget ); }

		/* Clean Up Widget Options */
		$all_widgets = get_option('sidebars_widgets');
		foreach( (array) $all_widgets as $i => $s ) {
			if( is_array( $s ) ) {
				foreach( (array) $s as $k => $v ) {
					if( FALSE !== strpos( $v, 'spamshield' ) ) { unset( $all_widgets[$i][$k] ); }
				}
				$all_widgets[$i] = array_values( $all_widgets[$i] );
			}
		}
		update_option( 'sidebars_widgets', $all_widgets );

		/* Delete Orphaned Options */
		$all_options = wp_load_alloptions();
		foreach( (array) $all_options  as $option => $value ) { 
			if( FALSE !== strpos( $option, 'spamshield' ) ) { delete_option( $option ); } /* TO DO: When Network Activation enabled, add Multisite - delete_site_option() */
		}

		/* Delete User Meta */
		$del_user_meta = array( 'wpss_user_ip', 'wpss_admin_status', 'wpss_new_user_approved', 'wpss_new_user_email_sent', 'wpss_cpn_status', 'wpss_cpn_notices', 'wpss_nag_status', 'wpss_nag_notices', );
		$user_ids = get_users( array( 'blog_id' => '', 'fields' => 'ID', ) );
		foreach ( $user_ids as $user_id ) { foreach( (array) $del_user_meta as $i => $key ) { delete_user_meta( $user_id, $key ); } }

		/* Clear Banned IP Info */
		self::clean_up();

		$GLOBALS['ss_unin_has_run_'.__METHOD__] = TRUE;

	}

	/**
	 *  Clear banned IP info from .htaccess, and delete files/folders created by WP-SpanShield.
	 */
	static public function clean_up() {

		if( !empty( $GLOBALS['ss_unin_has_run_'.__METHOD__] ) ) { return; }

		$hta_bak_dir		= SS_UNIN_CONTENT_DIR_PATH . self::$DS . 'backup';
		$hta_wpss_bak_dir	= $hta_bak_dir . self::$DS . 'wp-spamshield';
		$hta_file			= ABSPATH . self::$DS . '.htaccess';
		$hta_bak_file		= $hta_wpss_bak_dir . self::$DS . 'original.htaccess';
		$wpss_index_file	= SS_UNIN_PLUGIN_DIR . self::$DS . 'index.php';
		$bak_dir_hta_file	= SS_UNIN_PLUGIN_DIR . self::$DS . 'lib' . self::$DS . 'sec' . self::$DS . '.htaccess';
		$wpss_dirs			= array( $hta_wpss_bak_dir, SS_UNIN_PLUGIN_TMP_PATH, SS_UNIN_PLUGIN_JS_PATH, SS_UNIN_PLUGIN_DATA_PATH, SS_UNIN_CACHE_DIR_PATH );

		foreach( $wpss_dirs as $d => $dir ) {
			if( @is_dir( $dir ) ) {
				$filelist = self::scandir( $dir );
				foreach( $filelist as $f => $filename ) {
					$file = $dir . self::$DS . $filename;
					if( @is_file( $file ) ){
						chmod( $file, 0775 ); @unlink( $file ); @clearstatcache();
						if( @file_exists( $file ) ) { chmod( $file, 0644 ); @unlink( $file ); }
					}
				}
				chmod( $dir, 0775 ); @rmdir( $dir ); @clearstatcache();
				if( @file_exists( $dir ) ) { chmod( $dir, 0755 ); @rmdir( $dir ); }
			}
		}

		$wpss_files = 
			array
			(
				$hta_bak_dir . self::$DS . '.htaccess', 
				$hta_bak_dir . self::$DS . 'index.php', 
				( ( !self::dmc() ) ? WPMU_PLUGIN_DIR . self::$DS . 'am-integrity-scanner.php' : '' ), 
			); $wpss_files = array_filter( $wpss_files );

		foreach( $wpss_files as $f => $file ) {
			if( @is_file( $file ) ){
				chmod( $file, 0775 ); @unlink( $file ); @clearstatcache();
				if( @file_exists( $file ) ) { chmod( $file, 0644 ); @unlink( $file ); }
			}
		}

		$hta_contents = @file_get_contents( $hta_file );
		if( FALSE !== strpos( $hta_contents, '# BEGIN WP-SpamShield' ) && FALSE !== strpos( $hta_contents, '# END WP-SpamShield' ) ) {
			$hta_contents_mod = @preg_replace( "~" . PHP_EOL . "#\ BEGIN\ WP-SpamShield[\w\W]+#\ END\ WP-SpamShield" . PHP_EOL . "~i", '', $hta_contents );
			if( $hta_contents_mod !== $hta_contents ) {
				@file_put_contents( $hta_file, $hta_contents_mod, LOCK_EX );
			}
		}

		$GLOBALS['ss_unin_has_run_'.__METHOD__] = TRUE;

	}

	/**
	 *	Drop in replacement for PHP function constant(), with built-in error check.
	 *	The constant will be prefixed with class $pref variable.
	 *	@dependencies	none
	 *	@param			string	$name		The constant name.
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function constant( $name, $pref = TRUE ) {
		$pref = ( FALSE === $pref ) ? '' : self::$pref;
		return ( empty( $name ) || !is_string( $name ) || !defined( $pref.$name ) ) ? '' : constant( $pref.$name );
	}

	/**
	 *	Replacement for PHP function define(), with built-in conditional check.
	 *	Define one or more named constants if not already set.
	 *	Input an associative array of $name/$value pair(s) to be defined as one or more constants.
	 *	If $pref is supplied, the constant(s) will be prefixed.
	 *	@dependencies	none
	 *	@param			array	$const	Array of name(string)/value(bool|string) pairs to define
	 *	@param			string	$pref	Prefix
	 *	@param			bool	$cond	Conditional? Default: TRUE
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function define( $const = array(), $pref = '' ) {
		if( empty( $const ) || !is_array( $const ) ) { return; }
		$pref = ( TRUE === $pref ) ? self::$pref : $pref;
		foreach( (array) $const as $name => $value ) {
			$name = trim( $pref.$name );
			if( !defined( $name ) ) { define( $name, $value ); }
		}
	}

	/**
	 *	DMC Check
	 *	Part of detection de boucanier
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.42
	 *	@params			$method		string		'set'|'chk'
	 *	@params			$type		string		'buk'|'dmc'|'dns'|'int'|'lcv'|'nau'|'rcf'|'tan'
	 */
	static public function dmc( $method = 'chk', $type = 'all', $user_id = '' ) {
		$types		= (array) explode( '|', self::ecto( 'YnVrfGRtY3xkbnN8aW50fGxjdnxuYXV8cmNmfHRhbg' ) );
		$type		= ( empty( $type ) || !is_string( $type ) || !in_array( $type, $types ) ) ? 'dmc' : $type;
		$use_meta	= ( !empty( $user_id ) );
		$timenow	= self::$REQ_TS;
		$dmc		= array();
		$val		= implode( '_', array( $timenow, self::$DATE_DAY, str_replace( '-', '_', basename( __FILE__, '.php' ) ) ) );
		$exp		= 10 * YEAR_IN_SECONDS;
		$keys_exist	= $dmc_status = FALSE; self::$boucanier = ( is_int( self::$boucanier ) ) ? self::$boucanier : 0;
		$keys		= (array) explode( '|', self::ecto( 'YnVja19hbm5pZXxkZWFkX21hbnNfY2hlc3R8bm92ZW1iZXJfc2llcnJhfGJyb2tlbl9hcnJvd3xkb2dmaXNoX2xpbWFfdmljdG9yfG5vdmVtYmVyX2FscGhhfHJhZGlvX2NoZWNrX2ZhaWx8dGFuZ29fZG93bg' ) );
		$codes		= array_combine( $types, $keys );
		if(	'chk' === $method ) {
			if( 'all' === $type ) {
				foreach( (array) $codes as $k => $d ) {
					if( !empty( $dmc[$k] ) || defined( strtoupper( $d ) ) || get_transient( $d ) || get_site_transient( $d ) || ( $use_meta && get_user_meta( $user_id, $d ) ) || ( 'buk' === $k && !empty( self::$boucanier ) ) ) {
						$dmc[$k] = ( empty( $dmc['$k'] ) ) ? $val : $dmc['$k']; $dmc_status = TRUE; self::$boucanier = 1;
						self::define( array( strtoupper( $d ) => $val ) );
						set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
						if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
					}
				}
			} else {
				$d = $codes[$type];
				if( !empty( $dmc[$type] ) || defined( strtoupper( $d ) ) || get_transient( $d ) || get_site_transient( $d ) || ( $use_meta && get_user_meta( $user_id, $d ) ) ) {
					$dmc[$type] = ( empty( $dmc[$type] ) ) ? $val : $dmc[$type]; $dmc_status = TRUE; self::$boucanier = 1;
					self::define( array( strtoupper( $d ) => $val ) );
					set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
					if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
				}
			}
		}
		if( 'set' === $method ) {
			$d = $codes[$type];
			$dmc['$type'] = ( empty( $dmc['$type'] ) ) ? $val : $dmc['$type']; $dmc_status = TRUE; self::$boucanier = 1;
			self::define( array( strtoupper( $d ) => $val ) );
			set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
			if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
		}
		if( empty( $dmc_status ) && !empty( self::$boucanier ) ) {
			$dmc_status = TRUE; self::$boucanier = 1;
			self::define( array( strtoupper( $d ) => $val ) );
			set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
			if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
		}
		return $dmc_status;
	}

	/**
	 *	Drop-in replacement for native PHP function `base64_decode()`.
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 *	@reference		https://secure.php.net/manual/en/function.base64-decode.php
	 */
	static public function ecto( $str, $strict = FALSE ) {
		return @base64_decode( $str, $strict );
	}

	/**
	 *	Drop-in replacement for native PHP function `base64_encode()`, with improvements.
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 *	@reference		https://secure.php.net/manual/en/function.base64-encode.php
	 */
	static public function endo( $str, $nopad = FALSE ) {
		$b64 = @base64_encode( $str );
		return ( ( TRUE === $nopad ) ? rtrim( $b64, '=' ) : $b64 );
	}

	static public function get_active_plugins() {
		return (array) get_option( 'active_plugins', array() );
	}

	/**
	 *	Get domain from URL
	 *	Filter URLs with nothing after http
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function get_domain( $url ) {
		if( empty( $url ) || !is_string( $url ) || preg_match( "~^https?\:*/*$~i", $url ) ) { return ''; }
		$parsed = parse_url( $url );
		return ( $domain = ( ( !empty( $parsed['host'] ) ) ? strtolower( $parsed['host'] ) : '' ) );
	}

	/**
	 *	Get version slug.
	 *	Provides error correction for non-standard version strings: ex. pre-release versions () alpha, beta, RC, etc.)
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function get_ver_slug( $ver ) {
		if( empty( $ver ) || ( !is_string( $ver ) && !is_numeric( $ver ) ) ) { return FALSE; }
		$tmp = str_replace( '.', '', (string) $ver );
		$arr = preg_split( "~[a-z]+~i", $tmp );
		$tmp = ( ( !empty( $arr ) && is_array( $arr ) ) ? $arr[0] : $tmp );
		$tmp = $slug = strtok( $tmp, 'a' ); strtok( '', '' );
		return $slug;
	}

	/**
	 *	Check if PHP SAPI is CLI
	 *	@dependencies	none
	 *	@since			1.9.42
	 */
	static public function is_php_cli() {
		return ( ( defined( 'WP_CLI' ) && WP_CLI ) || 0 === strpos( PHP_SAPI, 'cli' ) );
	}

	/**
	 *	Drop in replacement for PHP function preg_match(), with improvements, such as built-in error correction.
	 *	Disables error suppression when WP_DEBUG is enabled.
	 *	Can use for both general purpose and for debugging.
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function preg_match( $pattern, $subject, &$matches = NULL, $flags = 0, $offset = 0 ) {
		$pattern_rev = ltrim( strrev( $pattern ), "eimsxuADJSUX" ); /* trim off PCRE Regex modifier flags */
		if( !is_string( $subject ) && !is_numeric( $subject ) ) {
			error_log( 'Error in RegEx $subject: ' . $subject . ' -- ' . implode( ' | ', array( __LINE__, __METHOD__, __FILE__, ) ), 0 );
		}
		if( !is_string( $pattern ) || FALSE === strpos( $pattern, '~' ) || 0 !== strpos( $pattern, '~' ) || 0 !== strpos( $pattern_rev, '~' ) ) {
			error_log( 'Error in RegEx $pattern: ' . $pattern . ' -- ' . implode( ' | ', array( __LINE__, __METHOD__, __FILE__, ) ), 0 );
		}
		if( !empty( $rgx_err ) ) { return FALSE; }
		$debug_ini = 
			array
			(
				'mod' => array(), /* $settings that were modified. Can use later on. */
				'res' => array(), /* $settings that were restored. Can use later on. */
				'old' => 
					array
					(
						'display_errors'		=> ( TRUE === WP_DEBUG ) ? ini_get( 'display_errors'	) : @ini_get( 'display_errors'	), 
						'error_log'				=> ( TRUE === WP_DEBUG ) ? ini_get( 'error_log'			) : @ini_get( 'error_log'		), 
						'error_reporting'		=> ( TRUE === WP_DEBUG ) ? ini_get( 'error_reporting'	) : @ini_get( 'error_reporting'	), 
						'log_errors'			=> ( TRUE === WP_DEBUG ) ? ini_get( 'log_errors'		) : @ini_get( 'log_errors'		), 
					), 
				'new' => 
					array
					(
						'display_errors'		=> 0, /* Production sites should ALWAYS disable visible errors and log them instead. This benefits usability, security, AND debugging. */
						'error_log'				=> ( self::constant( 'WP_DEBUG_LOG', FALSE ) ) ? self::constant( 'WP_DEBUG_LOG', FALSE ) : ( WP_CONTENT_DIR . self::$DS . 'debug.log' ), 
						'error_reporting'		=> E_ALL, 
						'log_errors'			=> 1, 
					), 
			);
		if( TRUE === WP_DEBUG ) {
			/* Temporarily disable error suppression when WP_DEBUG enabled. */
			foreach( $debug_ini['new'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$debug_ini['mod'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		/* Check for issues with PHP PCRE limits, then mitigate. */
		$pcre_limits = 
			array
			(
				'mod' => array(), /* $settings that were modified. Can use later on. */
				'res' => array(), /* $settings that were restored. Can use later on. */
				'def' => 
					array
					(
						'regex_chars_limit'		=> 62500, 
					), 
				'old' => 
					array
					(
						'regex_chars_limit'		=> '', 
						'pcre.backtrack_limit'	=> ( TRUE === WP_DEBUG ) ? ini_get( 'pcre.backtrack_limit'	) : @ini_get( 'pcre.backtrack_limit'	), 
						'pcre.recursion_limit'	=> ( TRUE === WP_DEBUG ) ? ini_get( 'pcre.recursion_limit'	) : @ini_get( 'pcre.recursion_limit'	), 
						'pcre.jit'				=> ( TRUE === WP_DEBUG ) ? ini_get( 'pcre.jit'				) : @ini_get( 'pcre.jit'				), 
					), 
			);
		/**
		 *	To get the number of allowed chars in RegEx, the math is a bit odd.
		 *	The gotcha is that the ini settings limit is in bits, not bytes. 
		 *	To get bytes, divide bits by 8.
		 *	Then to get number of allowed RegEx chars, divide again by 2 PCRE internal encoding cuts this in half).
		 *	Net conversion from `pcre.backtrack_limit` to chars allowed in RegEx: Divide by 16.
		 *	Adjust settings accordingly.
		 */
		$pcre_limits['old']['regex_chars_limit'] = ( !empty( $pcre_limits['old']['pcre.backtrack_limit'] ) ) ? (int) ( $pcre_limits['old']['pcre.backtrack_limit'] / 16 ) : $pcre_limits['def']['regex_chars_limit'];; $pcre_limits['new'] = $pcre_limits['old'];
		$rgx_chars_limit = ( $pcre_limits['old']['regex_chars_limit'] >= $pcre_limits['def']['regex_chars_limit'] ) ? $pcre_limits['old']['regex_chars_limit'] : $pcre_limits['def']['regex_chars_limit'];
		$rgx_ptn_len = rs_wpss_strlen( $pattern );	/* Get the number of characters in the RegEx pattern. */
		if( $rgx_ptn_len >= $rgx_chars_limit ) {
			/* Now, temporarily increase the limits by 4X. */
			$pcre_limits['new'] = 
				array
				(
					'regex_chars_limit'		=> $rgx_ptn_len * 4, 
					'pcre.backtrack_limit'	=> $rgx_ptn_len * 4 * 16, 
					'pcre.recursion_limit'	=> $rgx_ptn_len * 4 * 16, 
					'pcre.jit'				=> 0, 
				);
			foreach( $pcre_limits['new'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$pcre_limits['mod'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		/* Now, evaluate RegEx. */
		$result = ( TRUE === WP_DEBUG ) ? preg_match( $pattern, (string) $subject, $matches, $flags, $offset ) : @preg_match( $pattern, (string) $subject, $matches, $flags, $offset );
		/* Restore original ini settings. */
		if( $pcre_limits['new'] !== $pcre_limits['old'] ) {
			foreach( $pcre_limits['old'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$pcre_limits['res'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		if( TRUE === WP_DEBUG && $debug_ini['new'] !== $debug_ini['old'] ) {
		/* Restore original ini settings. */
			foreach( $debug_ini['old'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$debug_ini['res'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		return $result;
	}

	/**
	 *	Normalize directory separators (DS) in a file path string. ( self::$DS / DIRECTORY_SEPARATOR )
	 *	The default setting converts Windows/Linux directory separators to the system `DIRECTORY_SEPARATOR` setting, but this can be overridden with `$ds` parameter.
	 *	Includes error correction, but also is optimized for speed. It uses `str_replace()` first, and only uses `preg_replace()` as a fallback if needed to correct certain severe errors (eg. file paths have double/triple slashes).
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function normalize_ds( $str, $ds = DIRECTORY_SEPARATOR ) {
		if( empty( $str ) || !is_string( $str ) ) { return $str; }
		$ds		= ( !in_array( $ds, array( '\\', '/' ), TRUE ) ) ? DIRECTORY_SEPARATOR : $ds;
		$str	= str_replace( array( '\\', '/' ), $ds, $str );
		$str	= ( FALSE !== strpos( $str, $ds.$ds ) ) ? preg_replace( "~(?<=.)[/\\\]{2,}~", $ds, $str ) : $str;
		return $str;
	}

	/**
	 *	Drop-in replacement for PHP function rmdir(), Recursive
	 *	@dependencies	none
	 *	@since			1.9.20
	 */
	static public function rmdir_deep( $path ) {
		$i = new DirectoryIterator( $path );
		foreach( (array) $i as $f ) {
			if( $f->isFile() ) {
				@unlink( $f->getRealPath() );
			} else if( ! $f->isDot() && $f->isDir() ) {
				self::rmdir_deep( $f->getRealPath() );
			}
		}
		@rmdir( $path );
	}

	/**
	 *	Drop-in replacement for PHP function scandir()
	 *	Has sanitation and error correction built-in
	 *	@dependencies	none
	 *	@since			1.9.20
	 */
	static public function scandir( $dir ) {
		if( empty( $dir ) || !is_string( $dir ) ) { return array(); }; @clearstatcache();
		return array_values( array_diff( ( (array) scandir( ( $dir = rtrim( self::normalize_ds( $dir ), '/\\' ) ) ) ), array( '..', '.' ) ) );
	}

}



/**
 *	Get things started...
 */
if( !isset( $GLOBALS['SS_UNIN_INIT'] ) ) {
	$GLOBALS['SS_UNIN_INIT'] = SS_UNIN_REQUEST_TIME;
	SS_UNIN_Uninstall::init();
}


