<?php
/**
 *	Plugin Name:	WP-SpamShield Anti-Malware & Functional Integrity Scanner Module
 *	Plugin URI:		https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/
 *	Description:	A module of WP-SpamShield that checks for malicious plugin files and ensures plugin functional integrity. (Required for WP-SpamShield functionality.)
 *	Version:		1.9.42
 *	Author:			Red Sand Media Group and Blackhawk Cybersecurity
 *	Author URI:		https://www.redsandmarketing.com/
 *	Text Domain:	wp-spamshield
 *	Domain Path:	/lang
 */

/* Make sure file remains secure if called directly */
if( !defined( 'ABSPATH' ) ) {
	if( !headers_sent() ) { @header( 'HTTP/1.0 403 Forbidden', TRUE, 403 ); @header( 'X-Robots-Tag: noindex', TRUE ); }
	die( 'ERROR: Direct access to this file is not allowed.' );
}

define( 'SS_AMIS_VERSION',			'1.9.42'		);
define( 'SS_AMIS_VERSION_DATE',		'2019-10-07'	);
define( 'SS_AMIS_REQ_WP_VER',		'4.4' );
define( 'SS_AMIS_REQ_PHP_VER',		'5.6' );
define( 'SS_AMIS_PHP_TEST_MAX',		'7.3' );	/* MAX PHP VERSION TESTED */
define( 'SS_AMIS_PHP_UPDATE_REQ',	'7.4' );	/* PHP VERSION REQUIRES PLUGIN UPDATE */
define( 'SS_AMIS_WP_UPDATE_REQ',	'5.4' );	/* WP VERSION REQUIRES PLUGIN UPDATE */
define( 'SS_AMIS_WP_VERSION',		$GLOBALS['wp_version'] );
define( 'SS_AMIS_REQUEST_TIME',		time() );

/**
 *	Returns 1.
 *	Useful for returning 1 to filters easily. Like `__return_zero()`, `__return_true()`, `__return_false()`, etc.
 *	@dependencies	...
 *	@used by		...
 *	@since			1.9.35
 */
if( !function_exists( '__return_one' ) ) {
	function __return_one() {
		return 1;
	}
}

/**
 *	WP-SpamShield AMIS Class
 *	Anti-Malware & Functional Integrity Scanner Module
 *	Packaged with WP-SpamShield plugin
 *	This module of WP-SpamShield checks for malicious plugin files, ensures plugin functional integrity, and prevents security issues.
 *	This MU plugin is required for full functionality of WP-SpamShield. Do not disable or delete, as WP-SpamShield manages this as needed.
 *	This will be automatically removed during WP-SpamShield uninstall process as needed.
 *	@since	1.9.20
 *	@mod	1.9.42 converted to class object
 */
class WPSS_AMIS {

	/* Initialize Class Variables */
	static public		$PHP_VER			= PHP_VERSION;
	static public		$WP_VER				= SS_AMIS_WP_VERSION;
	static public		$WPSS_VER			= SS_AMIS_VERSION;
	static public		$AMIS_VER			= SS_AMIS_VERSION;
	static public		$AMIS_TITLE			= NULL;
	static public		$pref				= 'SS_AMIS_';
	static public		$pref_lc			= 'ss_amis_';
	static public		$debug_server		= '.redsandmarketing.com';
	static public		$dev_url			= 'https://www.redsandmarketing.com/';
	static public		$api_servers		= array( 'accessible_hosts' => 'wpspamshield.com,wpspamshield.net,redsandmarketing.com,redsandmarketing.net,blackhawkcybersec.com,blackhawkcybersec.net', 'primary' => 'wpspamshield.com,wpspamshield.net', 'secondary' => 'redsandmarketing.com,redsandmarketing.net', 'tertiary' => 'blackhawkcybersec.com,blackhawkcybersec.net' );
	static public		$api				= 'api';
	static public		$api_ver			= 'v2';
	static public		$api_url			= NULL;
	static public		$DS					= DIRECTORY_SEPARATOR;
	static public		$_ENV				= array();
	static public		$ip_dns_params		= array();
	static public		$spamshield_options	= array();		/* Memory cache of WP-SpamShield options - Use instead of `global $spamshield_options` */
	static public		$default_options	= array();		/* Memory cache of WP-SpamShield default options	*/
	static public		$stored_options		= array();		/* Memory cache of options stored to DB				*/
	static public		$session			= array();		/* Memory cache of current $_SESSION vars			*/
	static public		$http_cache			= array();
	static public		$all_plugin_data	= array();		/* Memory cache of all plugin data					*/
	static public		$active_plugins		= array();
	static public		$BUFFER_ID			= NULL;
	static public		$DATE_DAY			= NULL;
	static public		$HASH_HOUR			= NULL;
	static public		$REQUEST_TIME		= SS_AMIS_REQUEST_TIME;
	static public		$REQ_TS				= SS_AMIS_REQUEST_TIME;
	static public		$SITE_DOMAIN		= NULL;
	static public		$SITE_ID			= NULL;
	static public		$SITE_URL			= NULL;
	static public		$SS_BASENAME		= NULL;
	static public		$THIS_HOUR			= NULL;
	static public		$VER_SLUG			= NULL;
	static public		$WP_UA				= NULL;
	static public		$boucanier			= NULL;
	static public		$fwd_dns_cache		= NULL;
	static public		$ip_addr			= NULL;
	static public		$multisite			= NULL;
	static public		$plugin_name		= NULL;
	static public		$rev_dns_cache		= NULL;
	static public		$rgx_tld			= NULL;
	static public		$web_host			= NULL;
	static public		$web_host_proxy		= NULL;
	static public		$ADMIN_URL			= NULL;
	static public		$PLUGIN_ADMIN		= NULL;
	static public		$RSMG_URL			= 'https://www.redsandmarketing.com/';
	static public		$HOME_URL			= 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/';
	static public		$SUPPORT_URL		= 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/support/';
	static public		$LICENSE_URL		= 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/license/';
	static public		$CC_URL				= 'https://www.redsandmarketing.com/go/cc/wp-spamshield/';
	static public		$rambaldi			= '<?php exit(0); ?>';

	/**
	 *	Use private methods to prevent cloning and unserializing, as those could produce unexpected/unwanted behavior(s).
	 *	@since			1.9.42
	 *	@return			void
	 */
	private final function __clone()  {}
	private final function __wakeup() {}

	function __construct() {
		/**
		 *	Do nothing...for now
		 */
	}

	/**
	 *	Init / General Setup - Stage 1: Define constants, initialize vars, check/set memory, etc.
	 *	@dependencies	...
	 *	@since			1.9.42
	 */
	static public function init() {
		
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) ) { return; }

		/* WPSS_DEBUG - Do not change value unless tech support asks you to - for debugging only. Change in wp-config.php. */
		foreach( array( 'WP_DEBUG', 'WPSS_DEBUG', 'SS_AMIS_DEBUG', ) as $cn ) { self::define( $cn, FALSE ); }; unset( $cn );
		if( TRUE !== WP_DEBUG && TRUE !== WPSS_DEBUG ) { @ini_set( 'display_errors', 0 ); @error_reporting( 0 ); }

		/* Initialize/Populate Vars */
		self::$REQUEST_TIME	= self::$REQ_TS = time();
		self::$DATE_DAY		= date( 'Ymd', self::$REQ_TS );
		self::$THIS_HOUR	= date( 'Y-m-d H', self::$REQ_TS );
		self::$HASH_HOUR	= md5( self::$THIS_HOUR );
		self::$BUFFER_ID	= self::$pref . 'BUFFER_' . self::$REQ_TS;
		self::$SITE_URL		= untrailingslashit( strtolower( home_url() ) );
		self::$SITE_DOMAIN	= self::get_domain( self::$SITE_URL );
		self::$SS_BASENAME	= self::ecto( 'd3Atc3BhbXNoaWVsZC93cC1zcGFtc2hpZWxkLnBocA' );
		self::$AMIS_TITLE	= self::ecto( 'V1AtU3BhbVNoaWVsZCBBbnRpLU1hbHdhcmUgJiBGdW5jdGlvbmFsIEludGVncml0eSBTY2FubmVyIE1vZHVsZQ' );
		self::$VER_SLUG		= self::get_ver_slug( self::$WPSS_VER );
		self::$ADMIN_URL	= untrailingslashit( admin_url() );
		self::$PLUGIN_ADMIN	= ( isset( $GLOBALS['pagenow'], $_GET['page'] ) && 'options-general.php' === $GLOBALS['pagenow'] && 'wp-spamshield' === $_GET['page'] );

		/**
		 *  Load Hooks:
		 *  - Fix settings, translations, etc. - SECURITY, FUNCTIONALITY, PERFORMANCE, MAINTENANCE, etc.
		 */
		$hooks = 
			array(
				array( 't' => 'type',	'h' => 'hook',											'c' => 'callback',									'p' => 'priority',		'n' => 'num_args',	),
				/**
				 *  Hooks: 'Action' type
				 */
				array( 't' => 'action',	'h' => 'activated_plugin',								'c' => array( __CLASS__, 'fix_options'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'action',	'h' => 'activated_plugin',								'c' => array( __CLASS__, 'scan_mal_sig'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'action',	'h' => 'admin_notices',									'c' => array( __CLASS__, 'admin_notices'		),	'p' => -PHP_INT_MAX,	'n' => 1,			),
				array( 't' => 'action',	'h' => 'deactivated_plugin',							'c' => array( __CLASS__, 'fix_options'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'action',	'h' => 'deactivated_plugin',							'c' => array( __CLASS__, 'scan_mal_sig'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'action',	'h' => 'muplugins_loaded',								'c' => array( __CLASS__, 'admin_sec'			),	'p' => -PHP_INT_MAX,	'n' => 1,			),
				array( 't' => 'action',	'h' => 'muplugins_loaded',								'c' => array( __CLASS__, 'fix_options'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				/**
				 *  Hooks: 'Filter' type
				 */
				array( 't' => 'filter',	'h' => 'all_plugins',									'c' => array( __CLASS__, 'filter_plugin_data'	),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'filter',	'h' => 'debug_information',								'c' => array( __CLASS__, 'filter_debug_data'	),	'p' => PHP_INT_MAX,		'n' => 3,			),
				array( 't' => 'filter',	'h' => 'gettext',										'c' => array( __CLASS__, 'fix_translations'		),	'p' => PHP_INT_MAX,		'n' => 3,			),
				array( 't' => 'filter',	'h' => 'plugin_action_links_' . self::$SS_BASENAME,		'c' => array( __CLASS__, 'action_links'			),	'p' => PHP_INT_MAX,		'n' => 4,			),
				array( 't' => 'filter',	'h' => 'show_advanced_plugins',							'c' => '__return_false',							'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'filter',	'h' => 'validate_username',								'c' => array( __CLASS__, 'username_no_spaces'	),	'p' => 100,				'n' => 2,			),
				array( 't' => 'filter',	'h' => 'wp_fatal_error_handler_enabled',				'c' => '__return_false',							'p' => PHP_INT_MAX,		'n' => 1,			),
				/**
				 *	HTML Content Fixes via PHP Output Buffer
				 */
				array( 't' => 'action',	'h' => 'wp_loaded',										'c' => array( __CLASS__, 'buffer_start'			),	'p' => 1000,			'n' => 1,			),
				array( 't' => 'action',	'h' => 'wp_footer',										'c' => array( __CLASS__, 'buffer_end'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'action',	'h' => 'login_footer',									'c' => array( __CLASS__, 'buffer_end'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
				array( 't' => 'action',	'h' => 'admin_print_footer_scripts',					'c' => array( __CLASS__, 'buffer_end'			),	'p' => PHP_INT_MAX,		'n' => 1,			),
			);
		self::load_hooks( $hooks );

		/* Fix for WP Engine Incorrectly Caching Plugin JS URLs */
		if( defined( 'WPE_APIKEY' ) || defined( 'WPE_PLUGIN_VERSION' ) ) {
			if( !isset( $GLOBALS['wpengine_platform_config'] ) || !is_array( $GLOBALS['wpengine_platform_config'] ) ) {
				$GLOBALS['wpengine_platform_config'] = array( 'no_cdn_uris' => array(), );
			}
			if( !isset( $GLOBALS['wpe_no_cdn_uris'] ) || !is_array( $GLOBALS['wpe_no_cdn_uris'] ) ) {
				$GLOBALS['wpe_no_cdn_uris'] = array();
			}
			if( !isset( $GLOBALS['wpengine_platform_config']['no_cdn_uris'] ) || !is_array( $GLOBALS['wpengine_platform_config']['no_cdn_uris'] ) ) {
				$GLOBALS['wpengine_platform_config']['no_cdn_uris'] = array();
			}
			$GLOBALS['wpengine_platform_config']['no_cdn_uris'][] = $GLOBALS['wpe_no_cdn_uris'][] = 'spamshield';
		}

		self::define( array( 'LOADED' => TRUE, 'REQ_TS' => self::$REQ_TS, ) );

		/**
		 *	Allow manual override by admins
		 *	Usage -- add one of the following to `wp-config.php`
		 *	- Enabled (Default):	"define( 'WPSS_AMIS_SCAN_DISABLE', FALSE	);"
		 *	- Disabled:				"define( 'WPSS_AMIS_SCAN_DISABLE', TRUE		);"
		 */
		if( self::constant( 'WPSS_AMIS_SCAN_DISABLE', FALSE ) ) { self::define( array( 'OVERRIDE' => TRUE, ) ); }

		if( ( !self::constant( 'OVERRIDE' ) ) && ( is_admin() || self::constant( 'DOING_CRON', FALSE ) || self::is_php_cli() || ( !empty( $_SERVER['REQUEST_METHOD'] ) && 'POST' === $_SERVER['REQUEST_METHOD'] ) ) ) {
			self::scan_mal_sig();
		}

		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;

	}

	/**
	 *	Filters plugin action links
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.35
	 */
	static public function action_links( $actions, $file, $plugin_data, $status ) {
		if( self::dmc() ) {
			/* $wl_keys = array( 'deactivate', 'delete', ); $wl_actions = $actions; */
			$wl_keys = array( 'deactivate', ); $wl_actions = $actions;
			foreach( (array) $actions as $k => $v ) { if( !in_array( $k, $wl_keys, TRUE ) ) { unset( $wl_actions[$k] ); } }
			$wl_actions['piracy']	= '<a href="' . self::append_url( 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/#wordpress_security_note' ) . '" title="Software Piracy Warning" style="font-weight:bold;color:#FF0000;" ping="' . self::append_url( 'https://www.redsandmarketing.com/plugins/wp-spamshield-anti-spam/#wordpress_security_note' ) . '">' . __( 'Software Piracy Warning', 'wp-spamshield' ) . '</a>';
			$wl_actions['purchase'] = '<a href="' . self::append_url( 'https://www.redsandmarketing.com/go/cc/wp-spamshield/' ) . '" title="Buy the Plugin" style="font-weight:bold;color:#FF0000;" ping="' . self::append_url( 'https://www.redsandmarketing.com/go/cc/wp-spamshield/' ) . '">' . __( 'Buy the Plugin', 'wp-spamshield' ) . '</a>';
			$wl_actions['get_help'] = '<a href="' . self::append_url( self::$SUPPORT_URL ) . '" title="Contact Technical Support for help resolving this issue." style="font-weight:bold;color:#FF0000;" ping="' . self::append_url( self::$SUPPORT_URL ) . '">' . __( 'Get Help', 'wp-spamshield' ) . '</a>'; /* TO DO: TRANSLATE */
			$actions = $wl_actions;
		}; return $actions;
	}

	/**
	 *	SECURITY - Checks admin notices.
	 */
	static public function admin_notices() {
		$po = self::ecto( 'UGx1Z2luT3JnYW5pemVy' );
		$rem_notices = array( array( 'h' => 'admin_notices', 'cb' => array( $po, 'add_ajax_notices' ), 'p' => 10 ), array( 'h' => 'admin_notices', 'cb' => array( $po, 'compatibility_notices' ), 'p' => 1 ), array( 'h' => 'admin_notices', 'cb' => array( $po, 'display_admin_debug' ), 'p' => 10 ), );
		foreach( (array) $rem_notices as $i => $a ) {
			remove_action( $a['h'], $a['cb'], $a['p'] );
		}
	}

	/**
	 *	SECURITY - Admin areas (WordPress Dashboard)
	 *	- Require JavaScript on WP dashboard pages
	 */
	static public function admin_sec() {
		add_action( 'admin_enqueue_scripts', function( $hook_suffix ) { echo '<noscript><meta http-equiv="refresh" content="0; url=' . wp_logout_url() . '"></noscript>'; }, -PHP_INT_MAX );
		add_action( 'admin_print_footer_scripts', function() { echo '<script>jQuery(document).ready(function($){$("input#submit.button.button-primary, input[type=\'submit\']").attr("disabled",false);});</script>'; }, PHP_INT_MAX );
	}

	static public function append_url( $url = NULL ) {
		if( empty( $url ) ) { return ''; }
		self::$active_plugins = self::get_active_plugins();
		self::$boucanier = ( !is_int( self::$boucanier ) ) ? ( ( self::dmc() ) ? 1 : 0 ) : self::$boucanier;
		self::$multisite = ( !is_int( self::$multisite ) ) ? ( ( is_multisite() ) ? 1 : 0 )	: self::$multisite;
		$query_args = array( 'wpssv' => self::$WPSS_VER, 'wpv' => self::$WP_VER, 'phv' => PHP_VERSION, 'npl' => count( self::$active_plugins ), 'wpm' => self::$multisite, 'wpd' => self::endo( self::$SITE_DOMAIN ), );
		$query_args = ( !empty( self::$boucanier ) ) ? array_merge( $query_args, array( 'wpssb' => self::$boucanier, ) ) : $query_args;
		return add_query_arg( $query_args, $url );
	}

	/**
	 *	Drop in replacement for PHP function constant(), with built-in error check.
	 *	The constant will be prefixed with class $pref variable.
	 *	@dependencies	none
	 *	@param			string	$name		The constant name.
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function constant( $name, $pref = TRUE ) {
		$pref = ( FALSE === $pref ) ? '' : self::$pref;
		return ( empty( $name ) || !is_string( $name ) || !defined( $pref.$name ) ) ? '' : constant( $pref.$name );
	}

	/**
	 *	Replacement for PHP function define(), with built-in conditional check.
	 *	Define one or more named constants if not already set.
	 *	Input an associative array of $name/$value pair(s) to be defined as one or more constants.
	 *	If $pref is supplied, the constant(s) will be prefixed.
	 *	@dependencies	none
	 *	@param			array	$const	Array of name(string)/value(bool|string) pairs to define
	 *	@param			string	$pref	Prefix
	 *	@param			bool	$cond	Conditional? Default: TRUE
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function define( $const = array(), $pref = '' ) {
		if( empty( $const ) || !is_array( $const ) ) { return; }
		$pref = ( TRUE === $pref ) ? self::$pref : $pref;
		foreach( (array) $const as $name => $value ) {
			$name = trim( $pref.$name );
			if( !defined( $name ) ) { define( $name, $value ); }
		}
	}

	/**
	 *	DMC Check
	 *	Part of detection de boucanier
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.35
	 *	@params			$method		string		'set'|'chk'
	 *	@params			$type		string		'buk'|'dmc'|'dns'|'int'|'lcv'|'nau'|'rcf'|'tan'
	 */
	static public function dmc( $method = 'chk', $type = 'all', $user_id = '' ) {
		$types		= (array) explode( '|', self::ecto( 'YnVrfGRtY3xkbnN8aW50fGxjdnxuYXV8cmNmfHRhbg' ) );
		$type		= ( empty( $type ) || !is_string( $type ) || !in_array( $type, $types ) ) ? 'dmc' : $type;
		$use_meta	= ( !empty( $user_id ) );
		$timenow	= self::$REQ_TS;
		$dmc		= array();
		$val		= implode( '_', array( $timenow, self::$DATE_DAY, str_replace( '-', '_', basename( __FILE__, '.php' ) ) ) );
		$exp		= 10 * YEAR_IN_SECONDS;
		$keys_exist	= $dmc_status = FALSE; self::$boucanier = ( is_int( self::$boucanier ) ) ? self::$boucanier : 0;
		$keys		= (array) explode( '|', self::ecto( 'YnVja19hbm5pZXxkZWFkX21hbnNfY2hlc3R8bm92ZW1iZXJfc2llcnJhfGJyb2tlbl9hcnJvd3xkb2dmaXNoX2xpbWFfdmljdG9yfG5vdmVtYmVyX2FscGhhfHJhZGlvX2NoZWNrX2ZhaWx8dGFuZ29fZG93bg' ) );
		$codes		= array_combine( $types, $keys );
		if(	'chk' === $method ) {
			if( 'all' === $type ) {
				foreach( (array) $codes as $k => $d ) {
					if( !empty( $dmc[$k] ) || defined( strtoupper( $d ) ) || get_transient( $d ) || get_site_transient( $d ) || ( $use_meta && get_user_meta( $user_id, $d ) ) || ( 'buk' === $k && !empty( self::$boucanier ) ) ) {
						$dmc[$k] = ( empty( $dmc['$k'] ) ) ? $val : $dmc['$k']; $dmc_status = TRUE; self::$boucanier = 1;
						self::define( array( strtoupper( $d ) => $val ) );
						set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
						if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
					}
				}
			} else {
				$d = $codes[$type];
				if( !empty( $dmc[$type] ) || defined( strtoupper( $d ) ) || get_transient( $d ) || get_site_transient( $d ) || ( $use_meta && get_user_meta( $user_id, $d ) ) ) {
					$dmc[$type] = ( empty( $dmc[$type] ) ) ? $val : $dmc[$type]; $dmc_status = TRUE; self::$boucanier = 1;
					self::define( array( strtoupper( $d ) => $val ) );
					set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
					if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
				}
			}
		}
		if( 'set' === $method ) {
			$d = $codes[$type];
			$dmc['$type'] = ( empty( $dmc['$type'] ) ) ? $val : $dmc['$type']; $dmc_status = TRUE; self::$boucanier = 1;
			self::define( array( strtoupper( $d ) => $val ) );
			set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
			if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
		}
		if( empty( $dmc_status ) && !empty( self::$boucanier ) ) {
			$dmc_status = TRUE; self::$boucanier = 1;
			self::define( array( strtoupper( $d ) => $val ) );
			set_transient( $d, $val, $exp ); set_site_transient( $d, $val, $exp );
			if( TRUE === $use_meta ) { update_user_meta( $user_id, $d, $val ); }
		}
		return $dmc_status;
	}

	/**
	 *	Drop-in replacement for native PHP function `base64_decode()`.
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 *	@reference		https://secure.php.net/manual/en/function.base64-decode.php
	 */
	static public function ecto( $str, $strict = FALSE ) {
		return @base64_decode( $str, $strict );
	}

	/**
	 *	Drop-in replacement for native PHP function `base64_encode()`, with improvements.
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 *	@reference		https://secure.php.net/manual/en/function.base64-encode.php
	 */
	static public function endo( $str, $nopad = FALSE ) {
		$b64 = @base64_encode( $str );
		return ( ( TRUE === $nopad ) ? rtrim( $b64, '=' ) : $b64 );
	}

	/**
	 *	Filter debug data.
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.41
	 *	@param			array	$data	Debug data.
	 */
	static public function filter_debug_data( $data ) {
		$db_keys = (array) explode( '|', self::ecto( 'bXUtcGx1Z2luc3xkcm9waW5z' ) );
		foreach( (array) $db_keys as $k ) { $db_k = self::ecto( 'd3At' ) . $k; unset( $data[$db_k] ); }
		unset( $data[self::ecto( 'd3AtbXUtcGx1Z2lucw' )] );
		return $data;
	}

	/**
	 *	Filter the plugin data array in preparation for output to the plugins table.
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.35
	 */
	static public function filter_plugin_data( $all_plugins ) {
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) ) { return $all_plugins; }
		if( !is_admin() || empty( $GLOBALS['pagenow'] ) || 'plugins.php' !== $GLOBALS['pagenow'] ) { return $all_plugins; }
		/**
		 *	$plug_bn = 'folder/filename.php'; // Plugin Basename
		 *	$all_plugins = array( $plug_bn => array( 'Name', 'PluginURI', 'Version', 'Description', 'Author', 'AuthorURI', 'TextDomain', 'DomainPath', 'Network', 'Title', 'AuthorName', ) );
		 */
		$prob_tag = '[PROBLEM DETECTED]'; $prob_str = 'Problem Detected: There may be an issue with your license or site configuration, or this may be an illegal pirated and/or hacked copy of this software.';
		$desc =
			array(
				self::$SS_BASENAME => '<strong style="font-weight:bold;color:#FF0000;" >' . $prob_str . '</strong>' . ' &mdash; ' . '<strong style="font-weight:bold;color:#FF0000;" >' . 'You should contact <a href="' . self::append_url( self::$SUPPORT_URL . '?err=noauth' ) . '" >technical support</a> immediately for help resolving this issue.' . '</strong>' . ' &mdash; ' . 'Per the software license terms, you are only allowed one (1) web domain/install per license, and each software install requires a valid license. The unauthorized reproduction or distribution of a copyrighted work ("Software Piracy") is illegal in all countries. This includes installing software on more websites than you have licenses for. Make sure that you have a valid license for each website/install.' . 'Criminal copyright infringement, including infringement without monetary gain, is investigated by the FBI and other international law enforcement agencies and is punishable by fines and imprisonment. "Free" versions of premium software ("nulled", "warez", "shared", etc.) distributed from unauthorized websites are extremely dangerous to use, and almost always contain malware that will compromise your website to hackers. These sites claim to be benevolent, but they exist solely to distribute malware-laden software and hack your website. You should only install software purchased from authorized sellers.' . 'To get a legitimate, legally licensed, and safe copy of this software, you can <a href="' . self::append_url( self::$CC_URL . '?err=noauth' ) . '" >purchase it here</a> if you have not done so already.', 
			);
		self::$boucanier = ( !empty( self::$boucanier ) && is_int( self::$boucanier ) ) ? self::$boucanier : ( ( self::dmc() ) ? 1 : 0 );
		$ssh_rgx = "~(wp\-*)?[s5]p[a4]m\-*[s5]h([i1][e3]|[e3]*[i1]+)ld~i"; $mod_plugins = array(); $deac_pl = FALSE;
		foreach( (array) $all_plugins as $plug_bn => $plugin_data ) {
			$file = trim( basename( __FILE__ ), self::$DS );
			if( empty( $plugin_data ) || !preg_match( $ssh_rgx, $plug_bn ) ) { continue; }
			if(
				self::$AMIS_TITLE !== $plugin_data['Name']
				&&
				(
					preg_match( "~^WP\-SpamShield.+~i", $plugin_data['Name'] )
					||
					(
						'WP-SpamShield' === $plugin_data['Name']
						&&
						(
							empty( $plugin_data['PluginURI'] ) || empty( $plugin_data['AuthorURI'] )
						)
					)
				)
			) {
				self::$boucanier = 1;
			}
			if( FALSE !== strpos( $plug_bn, '/wp-spamshield.php' ) || preg_match( $ssh_rgx, $plug_bn ) ) {
				$plugin_data['Name']		= ( !empty( self::$boucanier ) ) ? ( 'WP-SpamShield ' . $prob_tag )	: $plugin_data['Name'];
				$plugin_data['Description']	= ( !empty( self::$boucanier ) ) ? $desc[self::$SS_BASENAME]		: $plugin_data['Description'];
				if( self::$boucanier ) {
					deactivate_plugins( $plug_bn ); self::dmc();
				}
			}
			$mod_plugins[$plug_bn] = $plugin_data;
		}
		$all_plugins = array_merge( $all_plugins, $mod_plugins ); unset( $plug_bn, $plugin_data, $mod_plugins );
		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
		return $all_plugins;
	}

	/**
	 *	Fixes erroneous text translations.
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.35
	 *	@param			string	$translation	Translated text.
	 *	@param			string	$text			Text to translate.
	 *	@param			string	$domain			Text domain. Unique identifier for retrieving translated strings.
	 */
	static public function fix_translations( $translation, $text, $domain ) {
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) || 'wp-spamshield' === $domain ) { return $translation; }

		$s = 'antispam'; $t = 'turing'; $h = 'honeypot'; $c = str_replace( array( 'uring', '-r', '-', 'k', ), array( 'cha', '-', '', 'c', ), 'k-rap-' . $t ); $a = str_replace( array( 'untie', 'y', 'me' ), array( '', 'i', 'met' ), self::ecto( 'YXVudGlla3lzbWU' ) ); $r = 're' . $c;
		$txt_keys	= (array) explode( '|', self::ecto( 'd3Agc3BhbXNoaWVsZHxzcGFtIHNoaWVsZHx5b3UgYXJlIG5vdCBhIHJvYm90' ) );
		$dom_keys	= array( 'printful', 'wordpress-seo', $a, );
		$rep_keys	= array();
		$pre_keys	= array();
		$app_keys	= 
			array
			( 
				'Comment author must fill out name and email' => '(' . 'Required for anti-spam' . ')', 
				'Enter the address here if you <a href="%s">want your site home page to be different from your WordPress installation directory</a>.' => '<strong>' . 'Not recommended.' . '</strong>' . ' ' . 'This can lead to unexpected behavior.' . ' ' . '<br />' . 'For most websites, these should match.', 
			);
		$dom_wl		= array( 'wp-spamshield', );
		$pl_keys	= array( "wp[\-\ ]*spamshield", "rs[\-\ ]*feedburner", "rs[\-\ ]*head[\-\ ]*cleaner", "rs[\-\ ]*system[\-\ ]*diagnostic", "scrapebreaker", );
		$pl_rgx		= "~(" . ( implode( '|', $pl_keys ) ) . ")~i";
		if( in_array( $domain, $dom_wl, TRUE ) ) { return $translation; } /* Skip Whitelisted Text Domains */
		foreach( (array) $rep_keys as $s => $r ) {
			if( $text === $r ) { continue; }
			if( $text === $s && $translation === $s ) { return $r; }
		} /* Search & Replace */
		foreach( (array) $pre_keys as $s => $p ) {
			if( $text === $p ) { continue; }
			if( $text === $s && $translation === $s ) { return $p.' '.$s; }
		} /* Search & Prepend */
		foreach( (array) $app_keys as $s => $a ) {
			if( $text === $a ) { continue; }
			if( $text === $s && $translation === $s ) { return $s.' '.$a; }
		} /* Search & Append */
		foreach( (array) $txt_keys as $i => $k ) {
			if( FALSE !== stripos( $translation, $k ) || FALSE !== stripos( $text, $k ) ) { return ''; }
		} /* Text String Keys */
		foreach( (array) $dom_keys as $i => $k ) {
			if( FALSE !== stripos( $domain, $k ) ) {
				if( preg_match( $pl_rgx, $translation ) || preg_match( $pl_rgx, $text ) ) { return ''; }
			}
		} /* Text Domain Keys */
		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
		return $translation;
	}

	/**
	 *	Fix erroneous/problematic raw option values.
	 *	@dependencies	none
	 *	@since			1.9.35
	 */
	static public function fix_options() {
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) ) { return; }
		$d_cb = (array) explode( '|', self::ecto( 'dHJ1ZXxmYWxzZXx6ZXJvfG9uZXxudWxsfGVtcHR5X2FycmF5fGVtcHR5X3N0cmluZw' ) );
		$s = 'antispam'; $t = 'turing'; $h = 'honeypot'; $c = str_replace( array( 'uring', '-r', '-', 'k', ), array( 'cha', '-', '', 'c', ), 'k-rap-' . $t ); $a = str_replace( array( 'untie', 'y', 'me' ), array( '', 'i', 'met' ), self::ecto( 'YXVudGlla3lzbWU' ) ); $r = 're' . $c; $d = 'disable';
		$fix_opts = array( 'PO_' => array( $d.'_compat_notices' => 'one', $d.'_admin_warning' => 'one', $d.'_admin_notices' => 'one', 'display_debug_msg' => 'zero', ), 'gwolle_gb-' => array( $a.'-active' => 'false', $s.'-answer' => '', $s.'-question' => '', 'form_ajax' => 'false', $h => 'false', 'moderate-entries' => 'true', 'nonce' => 'false', ), $a.'_' => array( 'comment_nonce' => 'false', 'spam_count' => 'zero', 'ssl_'.$d.'d' => 'false', ), 'no_pref' => array( $a => '', $c => '', $h => '', $r => '', ), );
		foreach( (array) $fix_opts as $pref => $a ) {
			$pref = ( 'no_pref' === $pref ) ? '' : $pref;
			foreach( (array) $a as $k => $v ) {
				$cb = ( '' === $v || NULL === $v ) ? self::ecto( 'X19yZXR1cm5fZW1wdHlfc3RyaW5n' ) : self::ecto( 'X19yZXR1cm5f' ) . $v;
				add_filter( 'pre_option_' . $pref . $k, $cb, PHP_INT_MAX, 1 ); 
				add_filter( 'option_' . $pref . $k, $cb, PHP_INT_MAX, 1 );
				add_filter( 'pre_update_option_' . $pref . $k, $cb, PHP_INT_MAX, 1 );
			}
		}
		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
	}

	static public function get_active_plugins() {
		return (array) get_option( 'active_plugins', array() );
	}

	/**
	 *	Get domain from URL
	 *	Filter URLs with nothing after http
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function get_domain( $url ) {
		if( empty( $url ) || !is_string( $url ) || preg_match( "~^https?\:*/*$~i", $url ) ) { return ''; }
		$parsed = parse_url( $url );
		return ( $domain = ( ( !empty( $parsed['host'] ) ) ? strtolower( $parsed['host'] ) : '' ) );
	}

	/**
	 *	Get domain from URL
	 *	Filter URLs with nothing after http
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function get_plugin_data( $plug_bn ) {
		if( empty( $plug_bn ) || !is_string( $plug_bn ) ) { return array(); }
		if( !function_exists( 'get_plugin_data' ) ) { require_once ABSPATH.'wp-admin/includes/plugin.php'; }
		return array_filter( (array) get_plugin_data( WP_PLUGIN_DIR . self::$DS . $plug_bn ) );
	}

	/**
	 *	Get version slug.
	 *	Provides error correction for non-standard version strings: ex. pre-release versions () alpha, beta, RC, etc.)
	 *	@dependencies	none
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function get_ver_slug( $ver ) {
		if( empty( $ver ) || ( !is_string( $ver ) && !is_numeric( $ver ) ) ) { return FALSE; }
		$tmp = str_replace( '.', '', (string) $ver );
		$arr = preg_split( "~[a-z]+~i", $tmp );
		$tmp = ( ( !empty( $arr ) && is_array( $arr ) ) ? $arr[0] : $tmp );
		$tmp = $slug = strtok( $tmp, 'a' ); strtok( '', '' );
		return $slug;
	}

	/**
	 *	Check if PHP SAPI is CLI
	 *	@dependencies	none
	 *	@since			1.9.42
	 */
	static public function is_php_cli() {
		return ( ( defined( 'WP_CLI' ) && WP_CLI ) || 0 === strpos( PHP_SAPI, 'cli' ) );
	}

	/**
	 *	Load hooks dynamically and efficiently.
	 *	@dependencies	none
	 *	@param			array	$hooks	Array of hook data to load
	 *	@used by		WPSS_AMIS::init()
	 *	@since			1.9.42
	 */
	static public function load_hooks( $hooks ) {
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) ) { return; }
		if( empty( $hooks ) || !is_array( $hooks ) ) { return; }
		foreach( (array) $hooks as $i => $v ) {
			extract( $v );
			if( 'action' !== $t && 'filter' !== $t ) { continue; }
			add_filter( $h, $c, $p, $n );
		}
		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
	}

	/**
	 *	Drop in replacement for PHP function preg_match(), with improvements, such as built-in error correction.
	 *	Disables error suppression when WP_DEBUG is enabled.
	 *	Can use for both general purpose and for debugging.
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function preg_match( $pattern, $subject, &$matches = NULL, $flags = 0, $offset = 0 ) {
		$pattern_rev = ltrim( strrev( $pattern ), "eimsxuADJSUX" ); /* trim off PCRE Regex modifier flags */
		if( !is_string( $subject ) && !is_numeric( $subject ) ) {
			error_log( 'Error in RegEx $subject: ' . $subject . ' -- ' . implode( ' | ', array( __LINE__, __METHOD__, __FILE__, ) ), 0 );
		}
		if( !is_string( $pattern ) || FALSE === strpos( $pattern, '~' ) || 0 !== strpos( $pattern, '~' ) || 0 !== strpos( $pattern_rev, '~' ) ) {
			error_log( 'Error in RegEx $pattern: ' . $pattern . ' -- ' . implode( ' | ', array( __LINE__, __METHOD__, __FILE__, ) ), 0 );
		}
		if( !empty( $rgx_err ) ) { return FALSE; }
		$debug_ini = 
			array
			(
				'mod' => array(), /* $settings that were modified. Can use later on. */
				'res' => array(), /* $settings that were restored. Can use later on. */
				'old' => 
					array
					(
						'display_errors'		=> ( TRUE === WP_DEBUG ) ? ini_get( 'display_errors'	) : @ini_get( 'display_errors'	), 
						'error_log'				=> ( TRUE === WP_DEBUG ) ? ini_get( 'error_log'			) : @ini_get( 'error_log'		), 
						'error_reporting'		=> ( TRUE === WP_DEBUG ) ? ini_get( 'error_reporting'	) : @ini_get( 'error_reporting'	), 
						'log_errors'			=> ( TRUE === WP_DEBUG ) ? ini_get( 'log_errors'		) : @ini_get( 'log_errors'		), 
					), 
				'new' => 
					array
					(
						'display_errors'		=> 0, /* Production sites should ALWAYS disable visible errors and log them instead. This benefits usability, security, AND debugging. */
						'error_log'				=> ( self::constant( 'WP_DEBUG_LOG', FALSE ) ) ? self::constant( 'WP_DEBUG_LOG', FALSE ) : ( WP_CONTENT_DIR . WPSS_DS . 'debug.log' ), 
						'error_reporting'		=> E_ALL, 
						'log_errors'			=> 1, 
					), 
			);
		if( TRUE === WP_DEBUG ) {
			/* Temporarily disable error suppression when WP_DEBUG enabled. */
			foreach( $debug_ini['new'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$debug_ini['mod'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		/* Check for issues with PHP PCRE limits, then mitigate. */
		$pcre_limits = 
			array
			(
				'mod' => array(), /* $settings that were modified. Can use later on. */
				'res' => array(), /* $settings that were restored. Can use later on. */
				'def' => 
					array
					(
						'regex_chars_limit'		=> 62500, 
					), 
				'old' => 
					array
					(
						'regex_chars_limit'		=> '', 
						'pcre.backtrack_limit'	=> ( TRUE === WP_DEBUG ) ? ini_get( 'pcre.backtrack_limit'	) : @ini_get( 'pcre.backtrack_limit'	), 
						'pcre.recursion_limit'	=> ( TRUE === WP_DEBUG ) ? ini_get( 'pcre.recursion_limit'	) : @ini_get( 'pcre.recursion_limit'	), 
						'pcre.jit'				=> ( TRUE === WP_DEBUG ) ? ini_get( 'pcre.jit'				) : @ini_get( 'pcre.jit'				), 
					), 
			);
		/**
		 *	To get the number of allowed chars in RegEx, the math is a bit odd.
		 *	The gotcha is that the ini settings limit is in bits, not bytes. 
		 *	To get bytes, divide bits by 8.
		 *	Then to get number of allowed RegEx chars, divide again by 2 PCRE internal encoding cuts this in half).
		 *	Net conversion from `pcre.backtrack_limit` to chars allowed in RegEx: Divide by 16.
		 *	Adjust settings accordingly.
		 */
		$pcre_limits['old']['regex_chars_limit'] = ( !empty( $pcre_limits['old']['pcre.backtrack_limit'] ) ) ? (int) ( $pcre_limits['old']['pcre.backtrack_limit'] / 16 ) : $pcre_limits['def']['regex_chars_limit'];; $pcre_limits['new'] = $pcre_limits['old'];
		$rgx_chars_limit = ( $pcre_limits['old']['regex_chars_limit'] >= $pcre_limits['def']['regex_chars_limit'] ) ? $pcre_limits['old']['regex_chars_limit'] : $pcre_limits['def']['regex_chars_limit'];
		$rgx_ptn_len = rs_wpss_strlen( $pattern );	/* Get the number of characters in the RegEx pattern. */
		if( $rgx_ptn_len >= $rgx_chars_limit ) {
			/* Now, temporarily increase the limits by 4X. */
			$pcre_limits['new'] = 
				array
				(
					'regex_chars_limit'		=> $rgx_ptn_len * 4, 
					'pcre.backtrack_limit'	=> $rgx_ptn_len * 4 * 16, 
					'pcre.recursion_limit'	=> $rgx_ptn_len * 4 * 16, 
					'pcre.jit'				=> 0, 
				);
			foreach( $pcre_limits['new'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$pcre_limits['mod'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		/* Now, evaluate RegEx. */
		$result = ( TRUE === WP_DEBUG ) ? preg_match( $pattern, (string) $subject, $matches, $flags, $offset ) : @preg_match( $pattern, (string) $subject, $matches, $flags, $offset );
		/* Restore original ini settings. */
		if( $pcre_limits['new'] !== $pcre_limits['old'] ) {
			foreach( $pcre_limits['old'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$pcre_limits['res'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		if( TRUE === WP_DEBUG && $debug_ini['new'] !== $debug_ini['old'] ) {
		/* Restore original ini settings. */
			foreach( $debug_ini['old'] as $k => $n ) {
				if( 0 !== strpos( $k, 'pcre.' ) ) { continue; }
				$debug_ini['res'][$k]	= ( TRUE === WP_DEBUG ) ? ini_set( $k, $n ) : @ini_set( $k, $n ); /* bool success or failure */
			}
		}
		return $result;
	}

	/**
	 *	Normalize directory separators (DS) in a file path string. ( self::$DS / DIRECTORY_SEPARATOR )
	 *	The default setting converts Windows/Linux directory separators to the system `DIRECTORY_SEPARATOR` setting, but this can be overridden with `$ds` parameter.
	 *	Includes error correction, but also is optimized for speed. It uses `str_replace()` first, and only uses `preg_replace()` as a fallback if needed to correct certain severe errors (eg. file paths have double/triple slashes).
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function normalize_ds( $str, $ds = DIRECTORY_SEPARATOR ) {
		if( empty( $str ) || !is_string( $str ) ) { return $str; }
		$ds		= ( !in_array( $ds, array( '\\', '/' ), TRUE ) ) ? DIRECTORY_SEPARATOR : $ds;
		$str	= str_replace( array( '\\', '/' ), $ds, $str );
		$str	= ( FALSE !== strpos( $str, $ds.$ds ) ) ? preg_replace( "~(?<=.)[/\\\]{2,}~", $ds, $str ) : $str;
		return $str;
	}

	/**
	 *	Drop-in replacement for PHP function rmdir(), Recursive
	 *	@dependencies	none
	 *	@since			1.9.20
	 */
	static public function rmdir_deep( $path ) {
		$i = new DirectoryIterator( $path );
		foreach( (array) $i as $f ) {
			if( $f->isFile() ) {
				@unlink( $f->getRealPath() );
			} else if( ! $f->isDot() && $f->isDir() ) {
				self::rmdir_deep( $f->getRealPath() );
			}
		}
		@rmdir( $path );
	}

	/**
	 *	Drop-in replacement for PHP function scandir()
	 *	Has sanitation and error correction built-in
	 *	@dependencies	none
	 *	@since			1.9.20
	 */
	static public function scandir( $dir ) {
		if( empty( $dir ) || !is_string( $dir ) ) { return array(); }; @clearstatcache();
		return array_values( array_diff( ( (array) scandir( ( $dir = rtrim( self::normalize_ds( $dir ), '/\\' ) ) ) ), array( '..', '.' ) ) );
	}

	/**
	 *	Scan for Malicious Signatures
	 *	Scans for fake malware plugin "X-WP-SPAM-SHIELD-PRO" (which is in no way associated with the real WP-SpamShield).
	 *	More Info: https://www.redsandmarketing.com/blog/malware-alert-x-wp-spam-shield-pro-fake-plugin/
	 */
	static public function scan_mal_sig() {
		if( ( !self::constant( 'OVERRIDE' ) ) && ( is_admin() || self::constant( 'DOING_CRON', FALSE ) || self::is_php_cli() || ( !empty( $_SERVER['REQUEST_METHOD'] ) && 'POST' === $_SERVER['REQUEST_METHOD'] ) ) ) {
			if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) || self::constant( 'SCAN_MAL_SIG_HAS_RUN' ) || get_transient( 'SCAN_MAL_SIG_HAS_RUN' ) || get_site_transient( 'SCAN_MAL_SIG_HAS_RUN' ) ) { return; }
			$max_age	= 2 * MINUTE_IN_SECONDS;
			$mal_keys	= (array) explode( '|', self::ecto( 'c3BhbS1zaGllbGQtcHJvfHgtd3Atc3BhbS1zaGllbGQ' ) );
			$mal_dmc	= "~/.*(wp\-*)?[s5]p[a4]m\-*[s5]h([i1][e3]|[e3]*[i1]+)ld.*/(.*/)*cl[a4][s5]+\.plug[i1]n\-m[o0]dul[e3][s5]?\.php~i";
			$mal_rgx	= "~(((x\-*)?wp\-*)?[s5]p[a4]m\-*[s5]h([i1][e3]|[e3]*[i1]+)ld\-*pr[o0]|/(wp\-*)?[s5]p[a4]m\-*[s5]h([i1][e3]|[e3]*[i1]+)ld\-*\d+/)~i";
			$ssh_rgx	= "~(wp\-*)?[s5]p[a4]m\-*[s5]h([i1][e3]|[e3]*[i1]+)ld~i";
			$req_fil	= array( implode( self::$DS, array( 'wp-spamshield', 'includes', 'class.geo.php', ) ), implode( self::$DS, array( 'wp-spamshield', 'js', 'jscripts-ftr-' . self::$VER_SLUG . '.min.js' ) ), implode( self::$DS, array( 'wp-spamshield', 'js', 'jscripts-ftr2-' . self::$VER_SLUG . '.min.js' ) ), );

			/**
			 *	Directories
			 */
			$mu_files = self::scandir( __DIR__ );
			$pl_files = self::scandir( WP_PLUGIN_DIR );
			$rq_files = TRUE;
			foreach( (array) $req_fil as $i => $file ) {
				$path = WP_PLUGIN_DIR . self::$DS . $file;
				if( ! @is_file( $path ) ) { $rq_files = FALSE; self::dmc( 'set', 'dmc' ); break; }
			}
			foreach( (array) $mu_files as $i => $file ) {
				if( $file === basename( __FILE__ ) ) { continue; }
				$path = __DIR__ . self::$DS . $file;
				foreach( (array) $mal_keys as $i => $k ) {
					if( FALSE !== stripos( $path, $k ) ) {
						if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue 2; }
					}
				}
				if( preg_match( $mal_rgx, $path ) ) {
					if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
				}
				$file_contents = trim( @file_get_contents( $path ) );
				if( !empty( $file_contents ) && FALSE !== strpos( $file_contents, 'wp-spamshield' ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
			}
			foreach( (array) $pl_files as $i => $file ) {
				$path = WP_PLUGIN_DIR . self::$DS . $file;
				$sshf = ( preg_match( $ssh_rgx, $file ) );
				if( TRUE === $sshf && TRUE !== $rq_files ) {
					if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
					if( @is_dir( $path ) ) { self::rmdir_deep( $path ); continue; }
				}
				foreach( (array) $mal_keys as $i => $k ) {
					if( FALSE !== stripos( $path, $k ) || preg_match( $mal_rgx, $path ) ) {
						if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue 2; }
						if( @is_dir( $path ) ) { self::rmdir_deep( $path ); continue 2; }
					}
				}
				if( preg_match( $mal_dmc, $path ) ) {
					self::dmc( 'set', 'dmc' );
					if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
					if( @is_dir( $path ) ) { self::rmdir_deep( $path ); continue; }
				}
				if( preg_match( $mal_rgx, $path ) ) {
					if( @is_file( $path ) ) { @chmod( $path, 0310 ); @unlink( $path ); continue; }
					if( @is_dir( $path ) ) { self::rmdir_deep( $path ); continue; }
				}
			}
			self::define( array( 'SCAN_MAL_SIG_HAS_RUN' => self::$REQ_TS, ), TRUE );
			set_transient( 'SCAN_MAL_SIG_HAS_RUN', self::$REQ_TS, $max_age );
			set_site_transient( 'SCAN_MAL_SIG_HAS_RUN', self::$REQ_TS, $max_age );
			$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
		}
	}

	/**
	 *  Prevent Spaces in WordPress Usernames During Registration
	 *  Spaces in Usernames can cause numerous problems and unwanted behaviors.
	 *	@dependencies	...
	 *	@used by		...
	 *	@since			1.9.42
	 */
	static public function username_no_spaces( $valid, $username ) {
		return ( preg_match( "~\s+~", $username ) ) ? FALSE : $valid;
	}



	/**
	 *	HTML Content Fixes via PHP Output Buffer
	 */
	static public function buffer_start() {
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) || !empty( $GLOBALS['ss_amis_has_run_buffer_end'] ) ) { return; }
		ob_start( array( __CLASS__, 'html_content_filter' ) );
		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
	}
	static public function buffer_end() {
		if( empty( $GLOBALS['ss_amis_has_run_buffer_start'] ) || !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) ) { return; }
		ob_end_flush(); $GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
	}

	static public function html_content_filter( $buffer ) {
		if( !empty( $GLOBALS['ss_amis_has_run_'.__METHOD__] ) ) { return $buffer; }
		if( is_array( $buffer ) ) { list( $buffer ) = $buffer; }
		$filters = array	/* RegEx Search and Replace (patterns/replacements) */
			(
				's'	=> array
					(
						"~<input\ +(?:(type\=[\"']submit[\"'][^<>/]+[\"'])\ *(?<!disabled\ ))/>~", 
						"~((?:WP\-SpamShield.*)?\[PROBLEM\s+DETECTED\]|Problem\s+Detected\:\s+There\s+may\s+be\s+an\s+issue\s+with\s+your\s+license\s+or\s+site\s+configuration,\s+or\s+this\s+may\s+be\s+an\s+illegal\s+pirated\s+and/or\s+hacked\s+copy\s+of\s+this\s+software\.)~", 
					),
				'r'	=> array
					(
						'<input ' . "$1" . ' disabled />', 
						'<strong style="font-weight:bold;color:#FF0000;" >' . "$1" . '</strong>', 
					),
			);
		extract( $filters );	/* Creates variables $s, $r */
		$buffer	= preg_replace( $s, $r, $buffer );
		$GLOBALS['ss_amis_has_run_'.__METHOD__] = TRUE;
		return trim( $buffer );
	}

}



/**
 *	Get things started...
 */
if( !isset( $GLOBALS['SS_AMIS_INIT'] ) ) {
	$GLOBALS['SS_AMIS_INIT'] = SS_AMIS_REQUEST_TIME;
	WPSS_AMIS::init();
}


/* PLUGIN - END */
