<?php

if (!defined('ABSPATH'))
    exit;

class SFM_Core {

    /**
     * The single instance
     * @var    object
     * @access  private
     * @since    1.0.0
     */
    private static $_instance = null;

    /**
     * Settings class object
     * @var     object
     * @access  public
     * @since   1.0.0
     */
    public $settings = null;

    /**
     * The version number.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $_version;

    /**
     * The token.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $_token;

    /**
     * The main plugin file.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $file;

    /**
     * The main plugin directory.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $dir;

    /**
     * The plugin assets directory.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $assets_dir;

    /**
     * The plugin assets URL.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $assets_url;

    /**
     * Suffix for Javascripts.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $templates_url;

    /**
     * Suffix for Javascripts.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $script_suffix;

    /**
     * For menu instance
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $menu;

    /**
     * For template
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $plugin_slug;


    /**
     * Constructor function.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    public function __construct($file = '', $version = '1.0.0') {
        $this->_version = $version;
        $this->_token = 'sfm';
        $this->plugin_slug = 'sfm';

        $this->file = $file;
        $this->dir = dirname($this->file);
        $this->assets_dir = trailingslashit($this->dir) . 'assets';
        $this->assets_url = esc_url(trailingslashit(plugins_url('/assets/', $this->file)));

        add_action('wp_enqueue_scripts', array($this, 'frontend_enqueue_scripts'), 10, 1);
        add_action('wp_enqueue_scripts', array($this, 'frontend_enqueue_styles'), 10, 1);
        add_action('plugins_loaded', array($this, 'init_localization'));
        add_action('wp_head', array($this, 'options_custom_styles'));
        add_action('wp_ajax_nopriv_sfm_sendContact', array($this, 'sendContact'));
        add_action('wp_ajax_sfm_sendContact', array($this, 'sendContact'));
        add_filter( 'the_content', array($this,'sfm_content_filter'), 20 );
    }
    
    function sfm_content_filter($content) {
        global $wpdb;
        $settings = $this->getSettings();
        if ($settings->enabled || (isset($_GET['sfm_action']) && $_GET['sfm_action'] == 'preview')) {
            $table_name = $wpdb->prefix . "sfm_items";
            $richTexts = $wpdb->get_results("SELECT * FROM $table_name WHERE type='richtext' OR type='shortcode'");
            $richTextContent = '';
            if(count($richTexts)>0){
                $richTextContent = '<div id="sfm_richTextsContent" style="display:none;">';
            }
            foreach ($richTexts as $richText) {
                if($richText->shortcode != ""){
                    $richTextContent .= '<div class="sfm_shortcodeContent" data-originalitemid="'.$richText->id.'">'.do_shortcode($richText->shortcode).'</div>';                      
                }else {
                    $richTextContent .= '<div class="sfm_richTextContent" data-originalitemid="'.$richText->id.'">'.($richText->richtext).'</div>';                        
                }            
            }
            if(count($richTexts)>0){
                $richTextContent .= '</div>';                
            }
            $content .= $richTextContent;
        }
        return $content;
    }

    public function options_custom_styles() {
        global $post;
        $settings = $this->getSettings();

        if ($settings->enabled || (isset($_GET['sfm_action']) && $_GET['sfm_action'] == 'preview')) {
            $output = '';
            if ($settings->googleFont != "") {
                $fontFamilyTextFormated = str_replace(" ", "+", $settings->googleFont);
                $output .= '@import url(https://fonts.googleapis.com/css?family=' . $fontFamilyTextFormated . ');';
            }

            $output .= '#sfm_menu {';
            $output .= ' background-color: ' . $settings->color_bg . ';';
            $output .= ' color: ' . $settings->color_txts . ';';
            $output .= ' font-family: "' . $settings->googleFont . '";';
            $output .= '}';
            $output .= "\n";

            $output .= '#sfm_menu  .sfm_itemTitle{';
            $output .= ' color: ' . $settings->color_txts . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '.ui-tooltip.ui-widget, #sfm_menu .ui-tooltip, #sfm_menu .tooltip > .tooltip-inner{';
            $output .= ' background-color: ' . $settings->color_tooltipsBg . ';';
            $output .= ' color: ' . $settings->color_tooltipsTxt . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '.ui-tooltip.ui-widget:before, #sfm_menu .ui-tooltip:before{';
            $output .= ' border-color: transparent transparent ' . $settings->color_tooltipsBg . ' transparent;';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .tooltip.bottom > .tooltip-arrow {';
            $output .= '  border-bottom-color: ' . $settings->color_tooltipsBg . ' !important;';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu #sfm_btnCloseMenu .fa{';
            $output .= ' color: ' . $settings->color_closeBtn . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .sexy-select-menu .select-toggle,#sfm_menu .sexy-select-menu .select-toggle.open{';
            $output .= ' background-color: ' . $settings->color_dropdownBg . ';';
            $output .= ' color: ' . $settings->color_dropdownTxt . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .sfm_control{';
            $output .= ' background-color: ' . $settings->color_dropdownBg . ';';
            $output .= ' color: ' . $settings->color_dropdownTxt . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .sexy-select-menu ul li span,#sfm_menu .sexy-select-menu ul li span.active,#sfm_menu .sexy-select-menu ul li span.selected{';
            $output .= ' background-color: ' . $settings->color_dropdownOptionsBg . ';';
            $output .= ' color: ' . $settings->color_dropdownOptionsTxt . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .sexy-select-menu .select-toggle:after {';
            $output .= '  border-color: ' . $settings->color_dropdownTxt . ' transparent transparent transparent;';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .sexy-select-menu .select-toggle.open:after {';
            $output .= '  border-color: transparent transparent ' . $settings->color_dropdownTxt . ' transparent;';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu  .sfm_item .sfm_checkIcon {';
            $output .= ' color: ' . $settings->color_checkedicon . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .ui-slider  {';
            $output .= ' background-color: ' . $settings->color_sliderBg . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menu .ui-slider .sfm_sliderFill,#sfm_menu .ui-slider .ui-slider-handle,#sfm_menu .ui-slider .ui-slider-range {';
            $output .= ' background-color: ' . $settings->color_sliderCircle . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menuBtn {';
            $output .= ' background-color: ' . $settings->color_menuBtn_bg . ';';
            $output .= '}';
            $output .= "\n";
            $output .= '#sfm_menuBtn > span {';
            $output .= ' color: ' . $settings->color_menuBtn_icon . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#sfm_menu .sfm_item .sfm_field {';
            $output .= ' color: ' . $settings->color_fields_txt . ';';
            $output .= ' background-color: ' . $settings->color_fields_bg . ';';
            $output .= ' -webkit-text-fill-color: ' . $settings->color_fields_txt . ';'; 
            $output .= '}';
            $output .= "\n";
            
            $output .= '#sfm_menu .sfm_item .sfm_field::-webkit-input-placeholder,'
                    . '#sfm_menu .sfm_item .sfm_field:-moz-input-placeholder,'
                    . '#sfm_menu .sfm_item .sfm_field::-moz-input-placeholder,'
                    . '#sfm_menu .sfm_item .sfm_field:-ms-input-placeholder,'
                    . '#sfm_menu .sfm_item .sfm_field::placeholder {';
            $output .= ' color: ' . $settings->color_fields_txt . ';';           
            $output .= '}';
            $output .= "\n";                        

            $output .= '#sfm_menu .sfm_item .sfm_field:focus {';
            $output .= ' border-color: ' . $settings->color_fields_borderColorFocus . ';';
            $output .= '}';
            $output .= "\n";

            $output .= '#sfm_menu .sexy-select-menu .select-toggle.open {';
            $output .= ' border-color: ' . $settings->color_dropdown_borderColorFocus . ';';
            $output .= '}';
            $output .= "\n";

            $output .= $settings->customCSS;

            $output .= "\n";
            if ($output != '') {
                $output = "\n<style id=\"sfm_frontend_styles\" >\n" . $output . "</style>\n";
                echo $output;
            }
        }
    }

    /*
     * Plugin init localization
     */

    public function init_localization() {
         $moFiles = scandir(trailingslashit($this->dir) . 'languages/');
         if (get_locale() == "") {
            load_textdomain( 'sfm', trailingslashit( $this->dir ) . 'languages/WP_SmartFullscreenMenu.mo' );
            return;
        }
    }
    
    

    public function frontend_enqueue_styles($hook = '') {
        global $wp_styles;
        $settings = $this->getSettings();
        wp_register_style($this->_token . '-frontendSelect', esc_url($this->assets_url) . 'css/frontendSelect.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '-frontendSelect');
        
        if ($settings->enabled || (isset($_GET['sfm_action']) && $_GET['sfm_action'] == 'preview')) {
        wp_register_style($this->_token . '-fontawesome', esc_url($this->assets_url) . 'css/font-awesome.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '-fontawesome');
        wp_register_style($this->_token . '-jqueryui', esc_url($this->assets_url) . 'css/jquery-ui-theme/jquery-ui.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '-jqueryui');
        wp_register_style($this->_token . 'sexySelect', esc_url($this->assets_url) . 'css/sexySelect.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . 'sexySelect');

        wp_register_style($this->_token . '-resetFrontend', esc_url($this->assets_url) . 'css/resetFrontend.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '-resetFrontend');
        wp_register_style($this->_token . '-frontend', esc_url($this->assets_url) . 'css/frontend.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '-frontend');
        }
    }

    public function frontend_enqueue_scripts($hook = '') {
        global $wpdb;
        global $post;

        $settings = $this->getSettings();
        wp_register_script($this->_token . '-frontendSelect', esc_url($this->assets_url) . 'js/frontendSelect.min.js', array('jquery'), $this->_version);
        wp_enqueue_script($this->_token . '-frontendSelect');

        if ($settings->enabled || (isset($_GET['sfm_action']) && $_GET['sfm_action'] == 'preview')) {
            $reqJsLibs = array('jquery', 'jquery-ui-core');
            if ($settings->showLinksTitlesAsTooltips) {
                $reqJsLibs[] = 'jquery-ui-tooltip';
            }
            $table_name = $wpdb->prefix . "sfm_items";
            $sliders = $wpdb->get_results("SELECT * FROM $table_name WHERE type='slider' LIMIT 1");
            if (count($sliders) > 0) {
                $reqJsLibs[] = 'jquery-ui-slider';
            }

            wp_register_script($this->_token . 'sexySelect', esc_url($this->assets_url) . 'js/jquery.sexySelect.min.js', array('jquery'), $this->_version);
            wp_enqueue_script($this->_token . 'sexySelect');

            wp_register_script($this->_token . '-touchpunch', esc_url($this->assets_url) . 'js/jquery.ui.touch-punch.min.js', $reqJsLibs, $this->_version);
            wp_enqueue_script($this->_token . '-touchpunch');

            wp_register_script($this->_token . '-frontend', esc_url($this->assets_url) . 'js/frontend.min.js', $reqJsLibs, $this->_version);
            wp_enqueue_script($this->_token . '-frontend');


            $table_name = $wpdb->prefix . "sfm_steps";
            $steps = $wpdb->get_results("SELECT * FROM $table_name");
            foreach ($steps as $step) {
                $step->items = array();
                $table_name = $wpdb->prefix . "sfm_items";
                $items = $wpdb->get_results("SELECT * FROM $table_name WHERE stepID=" . $step->id . " ORDER BY ordersort ASC");
                foreach ($items as $item) {
                    if ($item->optionsValues != "") {
                        $item->optionsValues = explode('|', $item->optionsValues);
                    }
                    if ($item->image == '') {
                        $item->image = esc_url($this->assets_url) + 'img/monitor.svg';
                    }
                    $step->items[] = $item;
                }
            }


            $table_name = $wpdb->prefix . "sfm_links";
            $links = $wpdb->get_results("SELECT * FROM $table_name");

            $js_data[] = array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'assetsUrl' => esc_url($this->assets_url),
                'steps' => $steps,
                'links' => $links,
                'settings' => $settings
            );
            wp_localize_script($this->_token . '-frontend', 'sfm_data', $js_data);
        }
    }

    public function getSettings() {
        global $wpdb;
        $table_name = $wpdb->prefix . "sfm_settings";
        $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE id=1 LIMIT 1");
        $settings = $settings[0];
        $settings->purchaseCode = "";
        return $settings;
    }

    public function sendContact() {
        $settings = $this->getSettings();
        $fname = sanitize_text_field($_POST['fname']);
        $lname = sanitize_text_field($_POST['lname']);
        $email = sanitize_text_field($_POST['email']);
        $phone = sanitize_text_field($_POST['phone']);
        $city = sanitize_text_field($_POST['city']);
        $zip = sanitize_text_field($_POST['zip']);
        $state = sanitize_text_field($_POST['state']);
        $address = sanitize_text_field($_POST['address']);
        $country = sanitize_text_field($_POST['country']);

        if ($email != "") {
            if ($settings->sendContactToMailChimp && $settings->mailchimpList != "") {
                try {
                    $MailChimp = new Mailchimp($settings->mailchimpKey);
                    $merge_vars = array('FNAME' => $fname, 'LNAME' => $lname, 'phone' => $phone,
                        'address1' => array('addr1' => $address, 'city' => $city, 'state' => $state, 'zip' => $zip, 'country' => $country));

                    $MailChimp->lists->subscribe($settings->mailchimpList, array('email' => $email), $merge_vars, 'html', $settings->mailchimpOptin);
                } catch (Throwable $t) {
                } catch (Exception $e) {                    
                }
            }
            if ($settings->sendContactToGetResponse) {               
                     $GetResponse = new GetResponse($settings->getResponseKey);
                     $merge_vars = array('phone'=>$phone, 'city'=>$city,'state'=>$state,'postal_code'=>$zip,'country'=>$country);
                     $GetResponse->addContact($settings->getResponseList, $fname.' '.$lname, $email,'standard',0,$merge_vars);
            }
        }
        die();
    }

    private function is_enqueued_script($script) {
        return isset($GLOBALS['wp_scripts']->registered[$script]);
    }

    /**
     * Main SFM_Core Instance
     *
     *
     * @since 1.0.0
     * @static
     * @see SFM_Core()
     * @return Main SFM_Core instance
     */
    public static function instance($file = '', $version = '1.0.0') {
        if (is_null(self::$_instance)) {
            self::$_instance = new self($file, $version);
        }
        return self::$_instance;
    }

// End instance()

    /**
     * Cloning is forbidden.
     *
     * @since 1.0.0
     */
    public function __clone() {
        
    }

// End __clone()

    /**
     * Unserializing instances of this class is forbidden.
     *
     * @since 1.0.0
     */
    public function __wakeup() {
    }

// End __wakeup()

    /**
     * Log the plugin version number.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    private function _log_version_number() {
        update_option($this->_token . '_version', $this->_version);
    }

}
