<?php

if (!defined('ABSPATH'))
    exit;

class SFM_admin {

    /**
     * The single instance
     * @var    object
     * @access  private
     * @since    1.0.0
     */
    private static $_instance = null;

    /**
     * The main plugin object.
     * @var    object
     * @access  public
     * @since    1.0.0
     */
    public $parent = null;

    /**
     * Prefix for plugin settings.
     * @var     string
     * @access  publicexport
     * Delete
     * @since   1.0.0
     */
    public $base = '';

    /**
     * Available settings for plugin.
     * @var     array
     * @access  public
     * @since   1.0.0
     */
    public $settings = array();

    public function __construct($parent) {
        $this->parent = $parent;
        $this->base = 'sfm_';
        $this->dir = dirname($this->parent->file);
        add_action('admin_menu', array($this, 'add_menu_item'));
        add_action('admin_print_scripts', array($this, 'admin_scripts'));
        add_action('admin_print_styles', array($this, 'admin_styles'));
        add_action('wp_ajax_nopriv_sfm_saveSettings', array($this, 'saveSettings'));
        add_action('wp_ajax_sfm_saveSettings', array($this, 'saveSettings'));
        add_action('wp_ajax_nopriv_sfm_loadSettings', array($this, 'loadSettings'));
        add_action('wp_ajax_sfm_loadSettings', array($this, 'loadSettings'));
        add_action('wp_ajax_nopriv_sfm_saveStep', array($this, 'saveStep'));
        add_action('wp_ajax_sfm_saveStep', array($this, 'saveStep'));
        add_action('wp_ajax_nopriv_sfm_addStep', array($this, 'addStep'));
        add_action('wp_ajax_sfm_addStep', array($this, 'addStep'));
        add_action('wp_ajax_nopriv_sfm_loadStep', array($this, 'loadStep'));
        add_action('wp_ajax_sfm_loadStep', array($this, 'loadStep'));
        add_action('wp_ajax_nopriv_sfm_removeStep', array($this, 'removeStep'));
        add_action('wp_ajax_sfm_removeStep', array($this, 'removeStep'));
        add_action('wp_ajax_nopriv_sfm_saveStepPosition', array($this, 'saveStepPosition'));
        add_action('wp_ajax_sfm_saveStepPosition', array($this, 'saveStepPosition'));
        add_action('wp_ajax_nopriv_sfm_newLink', array($this, 'newLink'));
        add_action('wp_ajax_sfm_newLink', array($this, 'newLink'));
        add_action('wp_ajax_nopriv_sfm_saveLinks', array($this, 'saveLinks'));
        add_action('wp_ajax_sfm_saveLinks', array($this, 'saveLinks'));
        add_action('wp_ajax_nopriv_sfm_removeAllSteps', array($this, 'removeAllSteps'));
        add_action('wp_ajax_sfm_removeAllSteps', array($this, 'removeAllSteps'));
        add_action('wp_ajax_nopriv_sfm_saveItem', array($this, 'saveItem'));
        add_action('wp_ajax_sfm_saveItem', array($this, 'saveItem'));
        add_action('wp_ajax_nopriv_sfm_removeItem', array($this, 'removeItem'));
        add_action('wp_ajax_sfm_removeItem', array($this, 'removeItem'));
        add_action('wp_ajax_nopriv_sfm_exportMenu', array($this, 'exportMenu'));
        add_action('wp_ajax_sfm_exportMenu', array($this, 'exportMenu'));
        add_action('wp_ajax_nopriv_sfm_importMenu', array($this, 'importMenu'));
        add_action('wp_ajax_sfm_importMenu', array($this, 'importMenu'));
        add_action('wp_ajax_nopriv_sfm_checkLicense', array($this, 'checkLicense'));
        add_action('wp_ajax_sfm_checkLicense', array($this, 'checkLicense'));
        add_action('wp_ajax_nopriv_sfm_duplicateItem', array($this, 'duplicateItem'));
        add_action('wp_ajax_sfm_duplicateItem', array($this, 'duplicateItem'));
        add_action('wp_ajax_nopriv_sfm_duplicateStep', array($this, 'duplicateStep'));
        add_action('wp_ajax_sfm_duplicateStep', array($this, 'duplicateStep'));
        add_action('wp_ajax_nopriv_sfm_changeItemsOrders', array($this, 'changeItemsOrders'));
        add_action('wp_ajax_sfm_changeItemsOrders', array($this, 'changeItemsOrders'));
        add_action('wp_ajax_nopriv_sfm_getMailchimpLists', array($this, 'getMailchimpLists'));
        add_action('wp_ajax_sfm_getMailchimpLists', array($this, 'getMailchimpLists'));
        add_action('wp_ajax_nopriv_sfm_getMailpoetLists', array($this, 'getMailpoetLists'));
        add_action('wp_ajax_sfm_getMailpoetLists', array($this, 'getMailpoetLists'));
        add_action('wp_ajax_nopriv_sfm_getGetResponseLists', array($this, 'getGetResponseLists'));
        add_action('wp_ajax_sfm_getGetResponseLists', array($this, 'getGetResponseLists'));
        add_filter('wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
            global $wp_version;
            if ($wp_version == '4.7' || ( (float) $wp_version < 4.7 )) {
                return $data;
            }
            $filetype = wp_check_filetype($filename, $mimes);
            return array('ext' => $filetype['ext'], 'type' => $filetype['type'], 'proper_filename' => $data['proper_filename']);
        }, 10, 4);
        add_filter('upload_mimes', array($this, 'cc_mime_types'));
    }

    public function cc_mime_types($mimes) {
        $mimes['svg'] = 'image/svg+xml';
        return $mimes;
    }

    /**
     * Add menu to admin
     * @return void
     */
    public function add_menu_item() {
        add_menu_page('WP Smart Fullscreen Menu', __("Smart Menu", 'sfm'), 'manage_options', 'sfm_menu', array($this, 'view_sfm'), 'dashicons-menu');
        $menuSlag = 'sfm_menu';
    }

    public function getSettings() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $table_name = $wpdb->prefix . "sfm_settings";
            $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE id=1 LIMIT 1");
            $settings = $settings[0];
            return $settings;
        }
    }

    public function loadSettings() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $settings = $this->getSettings();
            $settings->purchaseCode = "";
            $table_name = $wpdb->prefix . "sfm_steps";
            $settings->steps = $wpdb->get_results("SELECT * FROM $table_name");
            foreach ($settings->steps as $step) {
                $table_name = $wpdb->prefix . "sfm_items";
                $step->items = $wpdb->get_results("SELECT * FROM $table_name WHERE stepID=" . $step->id);
            }
            $table_name = $wpdb->prefix . "sfm_links";
            $settings->links = $wpdb->get_results("SELECT * FROM $table_name");
            echo(json_encode($settings));
        }
        die();
    }

    /*
     * Load admin styles
     */

    function admin_styles() {
        $url = '';
        if (isset($_SERVER['HTTP_REFERER'])) {
            $url = $_SERVER['HTTP_REFERER'];
        }
        $settings = $this->getSettings();
        if (isset($_GET['page']) && strpos($_GET['page'], 'sfm') !== false) {
            wp_register_style($this->parent->_token . '-reset', esc_url($this->parent->assets_url) . 'css/reset.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-reset');
            wp_register_style($this->parent->_token . '-bootstrap', esc_url($this->parent->assets_url) . 'css/bootstrap.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-bootstrap');
            wp_register_style($this->parent->_token . '-fontawesome', esc_url($this->parent->assets_url) . 'css/font-awesome.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-fontawesome');
            wp_register_style($this->parent->_token . '-flat-ui', esc_url($this->parent->assets_url) . 'css/flat-ui-pro.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-flat-ui');
            wp_register_style($this->parent->_token . '-colpick', esc_url($this->parent->assets_url) . 'css/colpick.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-colpick');
            wp_register_style($this->parent->_token . '-editor', esc_url($this->parent->assets_url) . 'css/summernote.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-editor');
            wp_register_style($this->parent->_token . '-editorB3', esc_url($this->parent->assets_url) . 'css/summernote-bs3.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-editorB3');
            wp_register_style($this->parent->_token . '-codemirror', esc_url($this->parent->assets_url) . 'css/codemirror.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-codemirror');
            wp_register_style($this->parent->_token . '-codemirrorTheme', esc_url($this->parent->assets_url) . 'css/codemirror-xq-light.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-codemirrorTheme');
            wp_register_style($this->parent->_token . '-admin', esc_url($this->parent->assets_url) . 'css/admin.min.css', array(), $this->parent->_version);
            wp_enqueue_style($this->parent->_token . '-admin');
        }
    }

    /*
     * Load admin scripts
     */

    function admin_scripts() {
        global $wpdb;
        $url = '';
        if (isset($_SERVER['HTTP_REFERER'])) {
            $url = $_SERVER['HTTP_REFERER'];
        }
        $settings = $this->getSettings();
        if (isset($_GET['page']) && strpos($_GET['page'], 'sfm') !== false) {
            wp_register_script($this->parent->_token . '-flatui', esc_url($this->parent->assets_url) . 'js/flat-ui-pro.min.js', array('jquery',
                'jquery-ui-core',
                'jquery-ui-mouse',
                'jquery-ui-position',
                'jquery-ui-droppable',
                'jquery-ui-draggable',
                'jquery-ui-resizable',
                'jquery-ui-sortable',
                'jquery-effects-core',
                'jquery-effects-drop',
                'jquery-effects-fade',
                'jquery-effects-bounce'), $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-flatui');
            wp_register_script($this->parent->_token . '-colpick', esc_url($this->parent->assets_url) . 'js/colpick.min.js', array($this->parent->_token . '-flatui'), $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-colpick');
            wp_register_script($this->parent->_token . '-editor', esc_url($this->parent->assets_url) . 'js/summernote.min.js', array($this->parent->_token . '-flatui'), $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-editor');

            wp_register_script($this->parent->_token . '-codemirror', esc_url($this->parent->assets_url) . 'js/codemirror.min.js', array(), $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-codemirror');
            wp_register_script($this->parent->_token . '-codemirrorJS', esc_url($this->parent->assets_url) . 'js/codemirror-javascript.min.js', array(), $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-codemirrorJS');
            wp_register_script($this->parent->_token . '-codemirrorCSS', esc_url($this->parent->assets_url) . 'js/codemirror-css.min.js', array(), $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-codemirrorCSS');

            wp_register_script($this->parent->_token . '-admin', esc_url($this->parent->assets_url) . 'js/admin.min.js', $this->parent->_token . '-flatui', $this->parent->_version);
            wp_enqueue_script($this->parent->_token . '-admin');

            $js_data[] = array(
                'assetsUrl' => esc_url($this->parent->assets_url),
                'websiteUrl' => esc_url(get_home_url()),
                'texts' => array(
                    'tip_flagStep' => __('Click the flag icon to set this step at first step', 'sfm'),
                    'tip_linkStep' => __('Start a link to another step', 'sfm'),
                    'tip_delStep' => __('Remove this step', 'sfm'),
                    'tip_duplicateStep' => __('Duplicate this step', 'sfm'),
                    'tip_editStep' => __('Edit this step', 'sfm'),
                    'tip_editLink' => __('Edit a link', 'sfm'),
                    'isSelected' => __('Is selected', 'sfm'),
                    'isUnselected' => __('Is unselected', 'sfm'),
                    'isEqual' => __('Is equal to', 'sfm'),
                    'isDifferent' => __('Is different than', 'sfm'),
                    'contains' => __('Contains the text', 'sfm'),
                    'isSuperior' => __('Is superior to', 'sfm'),
                    'isInferior' => __('Is inferior to', 'sfm'),
                    'errorExport' => __('An error occurred during the transfer. Using an FTP software, please verify that the tmp/ folder has rights set to 0747', 'sfm'),
                    'errorImport' => __('An error occurred during the transfer. Using an FTP software, please verify that the tmp/ folder has rights set to 0747', 'sfm'),
                    'Yes' => __('Yes', 'sfm'),
                    'No' => __('No', 'sfm'),
                    'newStepTitle' => __('My Step', 'sfm'),
                    'currentPageIs' => __('If the current page', 'sfm'),
                    'txt_selectStart' => __('Navigate to the desired page and click on the button "Select an element"', 'sfm'),
                    'txt_selectSelection' => __('Click on the desired element', 'sfm'),
                    'txt_selectConfirm' => __('Do you want to show the element that shines ?', 'sfm'),
                    'txt_selectBtn' => __('Select an element', 'sfm'),
                    'txt_yes' => __('Yes', 'sfm'),
                    'txt_no' => __('No', 'sfm'),
                    'txt_cancel' => __('Cancel', 'sfm'),
                )
            );
            wp_localize_script($this->parent->_token . '-admin', 'sfm_data', $js_data);
        }
        wp_register_style($this->parent->_token . '-adminGlobal', esc_url($this->parent->assets_url) . 'css/admin_global.css', array(), $this->parent->_version);
        wp_enqueue_style($this->parent->_token . '-adminGlobal');
    }

    public function saveSettings() {
        global $wpdb;
        $settings = $this->getSettings();
        $currentCode = $settings->purchaseCode;
        if (current_user_can('manage_options')) {
            $table_name = $wpdb->prefix . "sfm_settings";
            $sqlDatas = array();
            foreach ($_POST as $key => $value) {
                if ($key != 'action' && $key != 'id' && $key != 'pll_ajax_backend' && $key != "undefined" && $key != "files") {
                    $sqlDatas[$key] = (stripslashes($value));
                }
            }
            $wpdb->update($table_name, $sqlDatas, array('id' => 1));
        }

        die();
    }

    public function getMailchimpLists() {
        if (isset($_POST['apiKey'])) {
            $apiKey = sanitize_text_field($_POST['apiKey']);
            if ($apiKey != "") {
                $MailChimp = new Mailchimp($apiKey);
                $result = $MailChimp->lists->getList();
                foreach ($result['data'] as $list) {
                    echo '<option value="' . $list['id'] . '">' . $list['name'] . '</option>';
                }
            }
        }
        die();
    }

    public function getGetResponseLists() {
        if (isset($_POST['apiKey'])) {
            $apiKey = sanitize_text_field($_POST['apiKey']);
            if ($apiKey != "") {
                $GetResponse = new GetResponse($apiKey);
                $result = $GetResponse->getCampaigns();
                foreach ($result as $list => $value) {
                    echo '<option value="' . $list . '">' . $value->name . '</option>';
                }
            }
        }
        die();
    }

    public function view_sfm() {
        global $wpdb;
        $settings = $this->getSettings();

        wp_enqueue_style('thickbox');
        wp_enqueue_script('thickbox');

        echo '<div id="sfm_loader"></div>';
        echo '<div id="sfm_bootstraped" class="sfm_bootstraped sfm_panel">';

        echo '<div class="sfm_winHeader col-md-12 palette palette-turquoise">
               <div class="dashicons-before dashicons-menu" style="float: left;margin-right: 8px;"><br></div>WP Smart Fullscreen Menu';
        echo '<div class="btn-toolbar">';
        echo '<div class="btn-group">';
        echo '</div>';
        echo '</div>'; // eof toolbar
        echo '</div>'; // eof sfm_winHeader
        echo '<div class="clearfix"></div>';

        echo '<div id="sfm_winStep" class="sfm_window container-fluid">';
        echo '<div class="sfm_winHeader col-md-12 palette palette-turquoise"><span class="glyphicon glyphicon-pencil"></span>' . __('Edit a step', 'sfm');

        echo '<div class="btn-toolbar">';
        echo '<div class="btn-group">';
        echo '<a class="btn btn-primary" href="javascript:"><span class="glyphicon glyphicon-remove sfm_btnWinClose"></span></a>';
        echo '</div>';
        echo '</div>'; // eof toolbar
        echo '</div>'; // eof header
        echo '<div class="clearfix"></div>';
        echo '<div class="container-fluid  sfm_container"  style="max-width: 90%;margin: 0 auto;margin-top: 18px;">';
        echo '<div role="tabpanel">';
        echo '<ul class="nav nav-tabs" role="tablist" >
                <li role="presentation" class="active" ><a href="#sfm_stepTabGeneral" aria-controls="general" role="tab" data-toggle="tab" ><span class="glyphicon glyphicon-cog" ></span > ' . __('Step', 'sfm') . ' </a ></li >
                </ul >';
        echo '<div class="tab-content" >';
        echo '<div role="tabpanel" class="tab-pane active" id="sfm_stepTabGeneral" >';
        echo '<div class="col-md-6">';
        echo '<div class="form-group" >
                    <label> ' . __('Title', 'sfm') . ' </label >
                    <input type="text" name="title" class="form-control" />
                    <small> ' . __('The title will be displayed at top of the step', 'sfm') . ' </small>
                </div>';
        echo '</div>'; // eof col-md-6  
        echo '<div class="col-md-6">';
        echo '<div class="form-group">
                <label style="display: block; margin-top:10px;">' . __('Show the step title ?', 'sfm') . '</label>
                <input type="checkbox"  name="showTitle" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
            </div>';
        echo '</div>'; // eof col-md-6  
        echo '<div class="clearfix"></div>';
        echo '<p style="text-align:center; margin-bottom: 0px;"><a href="javascript:" class="btn btn-primary" onclick="sfm_saveStep();"><span class="glyphicon glyphicon-floppy-disk"></span>' . __('Save', 'sfm') . '</a></p>';

        echo '<div class="clearfix"></div>';
        echo '<div role="tabpanel" id="sfm_itemsList" style="margin-top: 24px;">';
        echo '<h4 style="margin-bottom: 0px;">' . __('Items List', 'sfm') . ' </h4>';
        echo '<div id="sfm_itemTab" >';
        echo '<div class="col-md-12">';
        echo '<p style="padding-top: 24px;"><a href="javascript:" onclick="sfm_editItem(0);" class="btn btn-default"><span class="glyphicon glyphicon-plus"></span>' . __('Add a new Item', 'sfm') . '</a></p>';
        echo '<table id="sfm_itemsTable" class="table" style="margin-bottom: 4px;">';
        echo '<thead>
                <th>' . __('Title', 'sfm') . '</th>
                <th style="width: 180px;">' . __('Actions', 'sfm') . '</th>
            </thead>';
        echo '<tbody>';
        echo '</tbody>';
        echo '</table>';
        echo '</div>'; // eof col-md-12
        echo '<div class="clearfix"></div>';
        echo '</div>'; // eof sfm_itemTab
        echo '</div>'; // eof tabpanel

        echo '</div>'; // eof tabpanel
        echo '<div class="clearfix"></div>';


        echo '</div>'; // eof sfm_stepTabGeneral
        echo '</div>'; // eof tab-content
        echo '</div>'; // eof tabpanel

        echo '</div>'; // eof win step


        echo '<div id="sfm_winItem" class="sfm_window container-fluid">';
        echo '<div class="sfm_winHeader col-md-12 palette palette-turquoise"><span class="glyphicon glyphicon-pencil"></span>' . __('Edit an item', 'sfm');

        echo '<div class="btn-toolbar">';
        echo '<div class="btn-group">';
        echo '<a class="btn btn-primary" href="javascript:"><span class="glyphicon glyphicon-remove sfm_btnWinClose"></span></a>';
        echo '</div>';
        echo '</div>'; // eof toolbar
        echo '</div>'; // eof header
        echo '<div class="clearfix"></div>';
        echo '<div class="container-fluid  sfm_container"  style="max-width: 90%;margin: 0 auto;margin-top: 18px;">';
        echo '<div role="tabpanel">';
        echo '<ul class="nav nav-tabs" role="tablist" >
                <li role="presentation" class="active" ><a href="#sfm_itemTabGeneral" aria-controls="general" role="tab" data-toggle="tab" ><span class="glyphicon glyphicon-cog" ></span > ' . __('Item options', 'sfm') . ' </a ></li >
                </ul >';
        echo '<div class="tab-content" >';
        echo '<div role="tabpanel" class="tab-pane active" id="sfm_itemTabGeneral" >';
        echo '<div class="col-md-6">';
        echo '<div class="form-group" >
                    <label> ' . __('Title', 'sfm') . ' </label >
                    <input type="text" name="title" class="form-control" />
                    <small> ' . __('This is the item name', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('Type', 'sfm') . ' </label >
                     <select name="type" class="form-control">
                        <option value="image">' . __('Image', 'sfm') . '</option>
                        <option value="dropdown">' . __('Dropdown', 'sfm') . '</option>
                        <option value="slider">' . __('Slider', 'sfm') . '</option>
                        <option value="textfield">' . __('Text field', 'sfm') . '</option>
                        <option value="numberfield">' . __('Number field', 'sfm') . '</option>
                        <option value="title">' . __('Title', 'sfm') . '</option>
                        <option value="richtext">' . __('Rich text', 'sfm') . '</option>
                        <option value="shortcode">' . __('Shortcode', 'sfm') . '</option>
                    </select>
                    <small> ' . __('Select the type of this item', 'sfm') . ' </small>
                </div>';

        echo '<div class="form-group" >
                    <label> ' . __('Image', 'sfm') . ' </label>
                    <input type="text" name="image" class="form-control " style="max-width: 140px; margin-right: 10px;display: inline-block;" />
                    <a class="btn btn-default imageBtn" style=" display: inline-block;">' . __('Upload Image', 'sfm') . '</a>
                    <small display: block;> ' . __('Select a picture', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('Placeholder', 'sfm') . ' </label >
                    <input type="text" name="placeholder" class="form-control" />
                    <small> ' . __('This text will be show by default in the field', 'sfm') . ' </small>
                </div>';

        echo '<div class="form-group" >
                    <label> ' . __('Type of information', 'sfm') . ' </label >
                     <select name="informationType" class="form-control">
                        <option value="">' . __('Any', 'sfm') . '</option>
                        <option value="email">' . __('Email', 'sfm') . '</option>
                        <option value="phone">' . __('Phone', 'sfm') . '</option>
                        <option value="firstname">' . __('First name', 'sfm') . '</option>
                        <option value="lastname">' . __('Last name', 'sfm') . '</option>
                        <option value="address">' . __('Address', 'sfm') . '</option>
                        <option value="city">' . __('City', 'sfm') . '</option>
                        <option value="country">' . __('Country', 'sfm') . '</option>
                        <option value="zip">' . __('Zip code', 'sfm') . '</option>
                    </select>
                    <small> ' . __('Fill this field to allow the plugin to send a new contact to your Mailchimp list', 'sfm') . ' </small>
                </div>';


        echo '<div class="form-group" >
                    <label> ' . __('Minimum value', 'sfm') . ' </label >
                    <input type="number" name="valueMin" class="form-control" min="0" />
                    <small> ' . __('It will be the minimum selectable value', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('Maximum value', 'sfm') . ' </label >
                    <input type="number" name="valueMax" class="form-control" min="1" />
                    <small> ' . __('It will be the maximum selectable value ', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('Layout', 'sfm') . ' </label >
                     <select name="layout" class="form-control">
                        <option value="inline">' . __('Inline', 'sfm') . '</option>
                        <option value="fullRow">' . __('Full row', 'sfm') . '</option>
                    </select>
                    <small> ' . __('Select the layout of this item', 'sfm') . ' </small>
                </div>';


        echo '<div id="sfm_itemOptionsValuesPanel"><table id="sfm_itemOptionsValues" class="table">';
        echo '<thead>';
        echo '<tr>';
        echo '<th colspan="3">' . __('Options of the dropdown', 'sfm') . '</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';
        echo '<tr class="static">';
        echo '<td><div class="form-group" style="top: 10px;"><input type="text" id="option_new_value" style="max-width:100%;" class="form-control" value="" placeholder="' . __('Option value', 'sfm') . '"></div></td>';
        echo '<td style="width: 200px;"><a href="javascript:" onclick="sfm_add_option();" class="btn btn-default"><span class="glyphicon glyphicon-plus" style="margin-right:8px;"></span>' . __('Add this new option', 'sfm') . '</a></td>';
        echo '</tr>';
        echo '</tbody>';
        echo '</table></div>';


        echo '</div>'; // eof col-md-6
        echo '<div class="col-md-6">';

        echo '<div class="form-group" >
                    <label> ' . __('Action on click/change', 'sfm') . ' </label >
                    <select name="actionType" class="form-control">
                        <option value="">' . __('Nothing', 'sfm') . '</option>
                        <option value="nextStep">' . __('Go to the next step', 'sfm') . '</option>
                        <option value="openURL">' . __('Open a page', 'sfm') . '</option>
                        <option value="showElement">' . __('Show an element of the website', 'sfm') . '</option>
                        <option value="executeJS">' . __('Execute JS code', 'sfm') . '</option>
                    </select>
                    <small> ' . __('Select the action executed when the user interact with this item', 'sfm') . ' </small>
                </div>';


        echo'<div class="form-group">
                    <label>' . __('Show the title ?', 'sfm') . '</label>
                    <input type="checkbox"  name="showTitle" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" /> 
                    <small> ' . __('Disable it to hide the title of this item in the menu', 'sfm') . ' </small>  
                </div>';
        echo'<div class="form-group">
                    <label>' . __('Is required ?', 'sfm') . '</label>
                    <input type="checkbox"  name="isRequired" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" /> 
                    <small> ' . __('If enabled, the next step will not be open if this field is empty', 'sfm') . ' </small>  
                </div>';
        echo'<div class="form-group">
                    <label>' . __('Send contact on change ?', 'sfm') . '</label>
                    <input type="checkbox"  name="sendContactOnChange" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" /> 
                    <small> ' . __('If enabled, the contact will be sent to MailChimp/GetResponse if at least the email field is filled', 'sfm') . ' </small>  
                </div>';

        echo '<div class="form-group" >
                    <label> ' . __('URL', 'sfm') . ' </label >
                    <input type="text" name="url" placeholder="http://..." class="form-control" />
                    <small> ' . __('Fill the target URL', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('Target element', 'sfm') . ' </label >
                    <input type="text" name="domElement" placeholder="' . __('Select an element', 'sfm') . ' " class="form-control" />
                    <a href="javascript:" class="btn btn-primary btn-circle" onclick="sfm_startSelectElement();"><span class="glyphicon glyphicon-hand-up"></span></a>
                    <small>' . __('Select an element', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('JS code to execute', 'sfm') . ' </label >
                    <textarea type="text" name="executedJS"  class="form-control" ></textarea>
                    <small> ' . __('Fill you custom Javascript code here', 'sfm') . ' </small>
                </div>';
        echo '<div class="form-group" >
                    <label> ' . __('Shortcode', 'sfm') . ' </label >
                    <input type="text" name="shortcode" placeholder="[your-shorcode-here]" class="form-control" />
                    <small> ' . __('Enter your shortcode here', 'sfm') . ' </small>
                </div>';



        echo '</div>'; // eof col-md-6
        echo '<div class="col-md-12"><div id="sfm_itemRichText"></div></div>';
        echo '<div class="clearfix"></div>';
        echo '<p style="text-align: center;"><a href="javascript:" class="btn btn-primary" onclick="sfm_saveItem();"><span class="glyphicon glyphicon-floppy-disk"></span>' . __('Save', 'sfm') . '</a></p>';
        echo '<div class="clearfix"></div>';

        echo '</div>'; // eof sfm_stepTabGeneral
        echo '</div>'; // eof tab-content
        echo '</div>'; // eof tabpanel

        echo '</div>'; // eof sfm_container
        echo '</div>'; // eof sfm_winItem


        echo '<div id="sfm_winLink" class="sfm_window container-fluid"> ';
        echo '<div class="sfm_winHeader col-md-12 palette palette-turquoise" ><span class="glyphicon glyphicon-pencil" ></span > ' . __('Edit a link', 'sfm');

        echo ' <div class="btn-toolbar"> ';
        echo '<div class="btn-group" > ';
        echo '<a class="btn btn-primary" href="javascript:" ><span class="glyphicon glyphicon-remove sfm_btnWinClose" ></span ></a > ';
        echo '</div> ';
        echo '</div> '; // eof toolbar
        echo '</div> '; // eof header

        echo '<div class="clearfix"></div><div class="container-fluid sfm_container"   style="max-width: 90%;margin: 0 auto;margin-top: 18px;"> ';
        echo '<div role="tabpanel">';
        echo '<ul class="nav nav-tabs" role="tablist" >
                <li role="presentation" class="active" ><a href="#sfm_linkTabGeneral" aria-controls="general" role="tab" data-toggle="tab" ><span class="glyphicon glyphicon-cog" ></span > ' . __('Link conditions', 'sfm') . ' </a ></li >
                </ul >';
        echo '<div class="tab-content" >';
        echo '<div role="tabpanel" class="tab-pane active" id="sfm_linkTabGeneral" >';

        echo '<div id="sfm_linkInteractions" > ';
        echo '<div id="sfm_linkStepsPreview">
                <div id="sfm_linkOriginStep" class="sfm_stepBloc "><div class="sfm_stepBlocWrapper"><h4 id="sfm_linkOriginTitle"></h4></div> </div>
                <div id="sfm_linkStepArrow"></div>
                <div id="sfm_linkDestinationStep" class="sfm_stepBloc  "><div class="sfm_stepBlocWrapper"><h4 id="sfm_linkDestinationTitle"></h4></div></div>
              </div>';
        echo '<p>'
        . '<select id="sfm_linkOperator" class="form-control">'
        . '<option value="">' . __('All conditions must be filled', 'sfm') . '</option>'
        . '<option value="OR">' . __('One of the conditions must be filled', 'sfm') . '</option>'
        . '</select>'
        . '<a href="javascript:" class="btn btn-primary" onclick="sfm_addLinkInteraction();" ><span class="glyphicon glyphicon-plus" ></span > ' . __('Add a condition', 'sfm') . ' </a></p> ';
        echo '<table id="sfm_conditionsTable" class="table">
                <thead>
                    <tr>
                        <th>' . __('Element', 'sfm') . '</th>
                        <th>' . __('Condition', 'sfm') . '</th>
                        <th>' . __('Value', 'sfm') . '</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody></tbody>
              </table>';

        echo '<div class="row" ><div class="col-md-12" ><p style="padding-left: 16px;padding-right: 16px; text-align: center;">'
        . '   <a href="javascript:" onclick="sfm_linkSave();" class="btn btn-primary" style="margin-top: 24px; margin-right: 8px;" ><span class="glyphicon glyphicon-ok" ></span > ' . __('Save', 'sfm') . ' </a >
              <a href="javascript:" onclick="sfm_linkDel();" class="btn btn-danger" style="margin-top: 24px;" ><span class="glyphicon glyphicon-trash" ></span > ' . __('Delete', 'sfm') . ' </a ></p ></div></div> ';

        echo '<div class="clearfix"></div>';
        echo '</div> '; // eof row
        echo '</div> '; // eof sfm_linkInteractions
        echo '</div> '; // eof tabpanel
        echo '</div> '; // eof tab-content
        echo '</div> '; // eof sfm_container

        echo '</div> '; //eof sfm_winLink

        echo '<div id="sfm_panelPreview">';
        echo '<div class="clearfix"></div>';
        echo '<div style="max-width: 90%;margin: 0 auto;margin-top: 18px;" id="sfm_formTopbtns">
                <p class="text-right" style="float:right;margin-bottom: 4px;">
                 <a href="javascript:" onclick="sfm_addStep( \'' . __('My Step', 'sfm') . '\');" class="btn btn-primary"><span class="glyphicon glyphicon-plus"></span>' . __("Add a step", 'sfm') . '</a>
                <a href="' . get_home_url() . '?sfm_action=preview" id="sfm_btnPreview" target="_blank" class="btn btn-default"><span class="glyphicon glyphicon-eye-open"></span>' . __("Preview", 'sfm') . '</a>
                <a href="javascript:" data-toggle="modal" data-target="#modal_removeAllSteps" class="btn btn-danger"><span class="glyphicon glyphicon-trash"></span>' . __("Remove all steps", 'sfm') . '</a>
                <a href="javascript:" data-toggle="modal" data-target="#sfm_winImport" class="btn btn-warning"><span class="glyphicon glyphicon-cloud-upload"></span>' . __("Import a menu", 'sfm') . '</a>
                <a href="javascript:" onclick="sfm_exportMenu();"  class="btn btn-default"><span class="glyphicon glyphicon-cloud-download"></span>' . __("Export the menu", 'sfm') . '</a>

                </p>
                <h3 id="sfm_stepsManagerTitle">' . __('Steps manager', 'sfm') . '</h3>

                <div class="clearfix"></div>
            </div>
        ';

        echo '
        <!-- Modal -->
        <div class="modal fade" id="modal_removeAllSteps" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-body">
                ' . __('Are you sure you want to delete all steps ?', 'sfm') . '
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal"  onclick="sfm_removeAllSteps();" >' . __('Yes', 'sfm') . '</button>
                <button type="button" class="btn btn-default" data-dismiss="modal" style="margin-left: 5px;" >' . __('No', 'sfm') . '</button>
              </div>
            </div>
          </div>
        </div>';

        echo '<div id="sfm_stepsOverflow">';
        echo '<div id="sfm_stepsContainer">';
        echo '<canvas id="sfm_stepsCanvas"></canvas>';
        echo '</div>';
        echo '</div>';

        echo '<div id="sfm_settingsPanel" style="max-width: 90%;margin: 0 auto;margin-top: 18px;" >
                <h3>' . __('Menu settings', 'sfm') . '</h3>
            <div role="tabpanel" >

              <!--Nav tabs-->
              <ul class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#sfm_tabGeneral" aria-controls="general" role="tab" data-toggle="tab" ><span class="glyphicon glyphicon-cog" ></span > ' . __('Settings', 'sfm') . ' </a ></li>
                <li role="presentation" class=""><a href="#sfm_tabDesign" onclick="setTimeout(function () { sfm_editorCustomCSS.refresh();}, 100);" aria-controls="design" role="tab" data-toggle="tab" ><span class="glyphicon glyphicon-tint" ></span > ' . __('Design', 'sfm') . ' </a ></li>
            
                </ul >

              <!--Tab panes-->
              <div class="tab-content" >
                <div role="tabpanel" class="tab-pane active" id="sfm_tabGeneral" >
                    <div class="row-fluid">
                        <div class="col-md-6">
                        
                            <div class="form-group">
                                <label>' . __('Activate the Menu', 'sfm') . '</label>
                                <input type="checkbox"  name="enabled" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
                            </div>
                            <div class="form-group" >
                                <label> ' . __('Integration method', 'sfm') . ' </label>
                                <select name="integrationType" class="form-control">
                                    <option value="fixedButton">' . __('Fixed button', 'sfm') . '</option>
                                    <option value="onClick">' . __('On click on an existing element', 'sfm') . '</option>
                                </select>
                                <small> ' . __('Select a method to show the menu', 'sfm') . ' </small>
                            </div> 
                            <div class="form-group" >
                                   <label> ' . __('Menu button position', 'sfm') . ' </label>
                                   <select name="fixedBtnPosition" class="form-control">
                                       <option value="topRight">' . __('Top right corner', 'sfm') . '</option>
                                       <option value="topLeft">' . __('Top left corner', 'sfm') . '</option>
                                       <option value="bottomRight">' . __('Bottom right corner', 'sfm') . '</option>
                                       <option value="bottomLeft">' . __('Bottom left corner', 'sfm') . '</option>
                                   </select>
                                   <small> ' . __('Select the position of the menu button', 'sfm') . ' </small>
                            </div>                    
                           <div class="form-group" >
                               <label> ' . __('Existing button', 'sfm') . ' </label >
                               <input type="text" name="domElement" placeholder="' . __('Select an element', 'sfm') . ' " class="form-control" />
                               <a href="javascript:" class="btn btn-primary btn-circle" onclick="sfm_startSelectElement();"><span class="glyphicon glyphicon-hand-up"></span></a>
                               <small>' . __('Select an element', 'sfm') . ' </small>
                           </div> 
                           <div class="form-group">
                                <label>' . __('Send a contact to Mailchimp', 'sfm') . '</label>
                                <input type="checkbox"  name="sendContactToMailChimp" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
                                   <small> ' . __('The filled informations will be sent to your list', 'sfm') . ' </small>
                            </div>                               
                            <div class="form-group">
                            <label>' . __('Mailchimp API key', 'sfm') . ' :</label>
                            <input type="text" class="form-control" name="mailchimpKey"/>
                            <a href="http://kb.mailchimp.com/accounts/management/about-api-keys" target="_blank" style="margin-left: 8px;" class="btn btn-info btn-circle"><span class="glyphicon glyphicon-info-sign"></span></a>
                            </div>
                            <div class="form-group">
                            <label>' . __('Mailchimp list', 'sfm') . ':</label>
                            <select class="form-control" name="mailchimpList"></select>
                            </div>
                            <div class="form-group">
                            <label>' . __('Confirmation by email required?', 'sfm') . ' </label>
                            <input type="checkbox" data-toggle="switch"  name="mailchimpOptin"/>
                            </div>
                        </div>                        
                        <div class="col-md-6">   
                             <div class="form-group" >
                              <label>&nbsp;</label>
                             </div>
                             <div class="form-group" >
                                <label> ' . __('Animation of the menu', 'sfm') . ' </label>
                                <select name="animationMenu" class="form-control">
                                    <option value="slideUp">' . __('Slide from top', 'sfm') . '</option>
                                    <option value="slideLeft">' . __('Slide from left', 'sfm') . '</option>
                                    <option value="slideRight">' . __('Slide from right', 'sfm') . '</option>
                                    <option value="fade">' . __('Fade', 'sfm') . '</option>
                                </select>
                                <small> ' . __('Choose the desired effect', 'sfm') . ' </small>
                            </div>         
                            <div class="form-group">
                                <label>' . __('Automatically show the menu', 'sfm') . '</label>
                                <input type="checkbox"  name="autoShow" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
                            
                                <small> ' . __('The menu will open automatically during the first visit (by session)', 'sfm') . ' </small>
                            </div>                            
                            <div class="form-group">
                                <label>' . __('Send a contact to GetResponse', 'sfm') . '</label>
                                <input type="checkbox"  name="sendContactToGetResponse" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
                                   <small> ' . __('The filled informations will be sent to your list', 'sfm') . ' </small>
                            </div>   
                            
                            
                            <div class="form-group">
                            <label>' . __('GetResponse API key', 'sfm') . ' :</label>
                            <input type="text" class="form-control" name="getResponseKey"/>
                            <a href="https://support.getresponse.com/faq/where-i-find-api-key" target="_blank" style="margin-left: 8px;" class="btn btn-info btn-circle"><span class="glyphicon glyphicon-info-sign"></span></a>
                            </div>
                            <div class="form-group">
                            <label>' . __('GetResponse list', 'sfm') . ' :</label>
                            <select class="form-control" name="getResponseList"></select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="alert alert-info" id="sfm_alertInfosGetResponse" style="text-align:center; display:none;">
                                    <p>' . __('You need to use textfields in your menu and fill their option "Type of information" to send the contact.', 'sfm') . '</p>
                                </div>
                          </div>
                        <div class="clearfix"></div>   
                        <p style="text-align:center;"><a href="javascript:" class="btn btn-primary" onclick="sfm_saveSettings();"><span class="glyphicon glyphicon-floppy-disk"></span>' . __('Save', 'sfm') . '</a>
                                   
                    <div class="clearfix"></div>  
                </div>
                </div>
                               
                 <div role="tabpanel" class="tab-pane" id="sfm_tabDesign" >
                 <div class="col-md-4">
                    <div class="form-group" >
                        <label > ' . __('Background color', 'sfm') . ' </label >
                        <input type="text" name="color_bg" class="form-control colorpick" />
                        <small> ' . __('ex : #1abc9c', 'sfm') . '</small>
                    </div>             
                    <div class="form-group" >
                        <label > ' . __('Texts color', 'sfm') . ' </label >
                        <input type="text" name="color_txts" class="form-control colorpick" />
                        <small> ' . __('ex : #ffffff', 'sfm') . '</small>
                    </div>    
                    <div class="form-group" >
                         <label > ' . __('Tooltips background color', 'sfm') . ' </label >
                         <input type="text" name="color_tooltipsBg" class="form-control colorpick" />
                         <small> ' . __('ex : #2c3e50', 'sfm') . '</small>
                     </div>     
                    <div class="form-group" >
                         <label > ' . __('Tooltips texts color', 'sfm') . ' </label >
                         <input type="text" name="color_tooltipsTxt" class="form-control colorpick" />
                         <small> ' . __('ex : #ffffff', 'sfm') . '</small>
                     </div> 
                  <div class="form-group" >
                         <label > ' . __('Selection icon color', 'sfm') . ' </label >
                         <input type="text" name="color_checkedicon" class="form-control colorpick" />
                         <small> ' . __('ex : #34495e', 'sfm') . '</small>
                     </div> 
                    <div class="form-group" >
                         <label > ' . __('Menu button background color', 'sfm') . ' </label >
                         <input type="text" name="color_menuBtn_bg" class="form-control colorpick" />
                         <small> ' . __('ex : #1abc9c', 'sfm') . '</small>
                     </div> 
                    <div class="form-group" >
                         <label > ' . __('Menu button icon color', 'sfm') . ' </label >
                         <input type="text" name="color_menuBtn_icon" class="form-control colorpick" />
                         <small> ' . __('ex : #ffffff', 'sfm') . '</small>
                     </div> 
                 </div>
                 <div class="col-md-4">
                    <div class="form-group" >
                         <label > ' . __('Close button color', 'sfm') . ' </label >
                         <input type="text" name="color_closeBtn" class="form-control colorpick" />
                         <small> ' . __('ex : #ffffff', 'sfm') . '</small>
                     </div>        
                 
                      <div class="form-group" >
                         <label > ' . __('Dropdowns background color', 'sfm') . ' </label >
                         <input type="text" name="color_dropdownBg" class="form-control colorpick" />
                         <small> ' . __('ex : #ecf0f1', 'sfm') . '</small>
                     </div>  
                    <div class="form-group" >
                         <label > ' . __('Dropdowns text color', 'sfm') . ' </label >
                         <input type="text" name="color_dropdownTxt" class="form-control colorpick" />
                         <small> ' . __('ex : #1abc9c', 'sfm') . '</small>
                     </div>    
                     
                    <div class="form-group" >
                         <label > ' . __('Dropdowns border color', 'sfm') . ' </label >
                         <input type="text" name="color_dropdown_borderColor" class="form-control colorpick" />
                         <small> ' . __('ex : #bdc3c7', 'sfm') . '</small>
                     </div>    
                    <div class="form-group" >
                         <label > ' . __('Dropdowns border color on focus', 'sfm') . ' </label >
                         <input type="text" name="color_dropdown_borderColorFocus" class="form-control colorpick" />
                         <small> ' . __('ex : #16a085', 'sfm') . '</small>
                     </div>    

                    <div class="form-group" >
                         <label > ' . __('Dropdowns options background color', 'sfm') . ' </label >
                         <input type="text" name="color_dropdownOptionsBg" class="form-control colorpick" />
                         <small> ' . __('ex : #2c3e50', 'sfm') . '</small>
                     </div>  
                    <div class="form-group" >
                         <label > ' . __('Dropdowns options text color', 'sfm') . ' </label >
                         <input type="text" name="color_dropdownOptionsTxt" class="form-control colorpick" />
                         <small> ' . __('ex : #1abc9c', 'sfm') . '</small>
                     </div> 
                 </div>
                 <div class="col-md-4">
                      <div class="form-group" >
                         <label > ' . __('Slider background color', 'sfm') . ' </label >
                         <input type="text" name="color_sliderBg" class="form-control colorpick" />
                         <small> ' . __('ex : #ecf0f1', 'sfm') . '</small>
                     </div> 
                    <div class="form-group" >
                         <label > ' . __('Slider main color', 'sfm') . ' </label >
                         <input type="text" name="color_sliderCircle" class="form-control colorpick" />
                         <small> ' . __('ex : #34495e', 'sfm') . '</small>
                     </div>  
                     
                    <div class="form-group" >
                         <label > ' . __('Fields background color', 'sfm') . ' </label >
                         <input type="text" name="color_fields_bg" class="form-control colorpick" />
                         <small> ' . __('ex : #ecf0f1', 'sfm') . '</small>
                     </div> 
                    <div class="form-group" >
                         <label > ' . __('Fields text color', 'sfm') . ' </label >
                         <input type="text" name="color_fields_txt" class="form-control colorpick" />
                         <small> ' . __('ex : #bdc3c7', 'sfm') . '</small>
                     </div> 
                    <div class="form-group" >
                         <label > ' . __('Fields border color', 'sfm') . ' </label >
                         <input type="text" name="color_fields_borderColor" class="form-control colorpick" />
                         <small> ' . __('ex : #bdc3c7', 'sfm') . '</small>
                     </div>    
                    <div class="form-group" >
                         <label > ' . __('Fields border color on focus', 'sfm') . ' </label >
                         <input type="text" name="color_fields_borderColorFocus" class="form-control colorpick" />
                         <small> ' . __('ex : #34495e', 'sfm') . '</small>
                     </div> 
                    <div class="form-group" >
                         <label > ' . __('Fields border color on focus', 'sfm') . ' </label >
                         <input type="text" name="color_fields_borderColorFocus" class="form-control colorpick" />
                         <small> ' . __('ex : #16a085', 'sfm') . '</small>
                     </div>    
                        
                        
                 </div>
                 <div class="col-md-6">
                             
                   
                        <div class="form-group" >
                           <label > ' . __('Google font name', 'sfm') . ' </label >
                           <input type="text" name="googleFont" class="form-control" />
                           <a href="https://www.google.com/fonts" style="margin-left: 14px; display: inline-block;" target="_blank" class="btn btn-default"><span class="glyphicon glyphicon-list"></span>' . __('See available Google fonts', 'sfm') . '</a>        

                           <small> ' . __('ex : Lato', 'sfm') . '</small>
                    </div>    
                     
                     <div class="form-group">
                        <label>' . __('Inverse the gray fx on selected images', 'sfm') . '</label>
                        <input type="checkbox"  name="inverseGrayFx" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
                    </div>
                    
                            <div class="form-group">
                                <label>' . __('Show the titles of images as tooltip', 'sfm') . '</label>
                                <input type="checkbox"  name="showLinksTitlesAsTooltips" data-toggle="switch" data-on-label="' . __('Yes', 'sfm') . '" data-off-label="' . __('No', 'sfm') . '" />   
                            </div>         
                    <div class="form-group" >
                    <label> ' . __('Introduction button icon', 'sfm') . ' </label>
                    <input type="hidden" class="form-control sfm_iconField" name="checkedItemicon"  />
                    <div class="btn-group">
                    <button class="btn btn-default dropdown-toggle" type="button" data-toggle="dropdown">
                    <span class="sfm_name">' . $settings->checkedItemicon . '</span><span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu sfm_iconslist" role="menu" >';
        echo $this->getIconsOptionsList();
        echo '</ul></div>                    
                    </div>    
                    
                    <div class="form-group" >
                    <label> ' . __('Menu button icon', 'sfm') . ' </label>
                    <input type="hidden" class="form-control sfm_iconField" name="menuBtn_icon"  />
                    <div class="btn-group">
                    <button class="btn btn-default dropdown-toggle" type="button" data-toggle="dropdown">
                    <span class="sfm_name">' . $settings->menuBtn_icon . '</span><span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu sfm_iconslist" role="menu" >';
        echo $this->getIconsOptionsList();
        echo '</ul></div>                    
                    </div>    
                 </div>
                 <div class="col-md-6">   
                     
                     <div class="form-group">
                            <label style="width:100%;">' . __('Custom CSS', 'sfm') . '</label>
                            <textarea  class="form-control" name="customCSS" style="height: 152px;max-width: 100%; width: 100%;"></textarea>   
                            <small>' . __('You can paste your custom CSS rules here', 'sfm') . '</small>
                        </div>    
                </div>
                 <div class="clearfix"></div>  
                             <p style="text-align:center;"><a href="javascript:" class="btn btn-primary" onclick="sfm_saveSettings();"><span class="glyphicon glyphicon-floppy-disk"></span>' . __('Save', 'sfm') . '</a>
                        <div class="clearfix"></div>  
                </div>

              </div>
            </div>
        </div>';

        echo '</div>'; // eof sfm_panelPreview

        echo '<div id="sfm_winImport" class="modal fade">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <a href="javascript:" class="close" data-dismiss="modal" aria-label="Close"><span class="glyphicon glyphicon-remove"></span></a>
                      <h4 class="modal-title">' . __('Import a menu', 'sfm') . '</h4>
                    </div>
                    <div class="modal-body">
                     <div class="alert alert-danger"><p style="text-align: center;">' . __('Be carreful : all existing settings, steps and items will be replaced by the imported menu.', 'sfm') . '</p></div>
                         <form id="sfm_winImportMenu" method="post" enctype="multipart/form-data">
                             <div class="form-group">
                              <input type="hidden" name="action" value="sfm_importMenu"/>
                              <label>' . __('Select the .zip data file', 'sfm') . '</label><input name="importFile" type="file" class="" />
                             </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                      <a href="javascript:" class="btn btn-primary" onclick="sfm_importMenu();"><span class="glyphicon glyphicon-floppy-disk"></span>' . __('Import', 'sfm') . '</a>
                      <a href="javascript:" class="btn btn-default" data-dismiss="modal"><span class="glyphicon glyphicon-remove"></span>' . __('Cancel', 'sfm') . '</a>
                    </div>
                  </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
              </div><!-- /.modal -->';


        echo '<div id="sfm_winExport" class="modal fade">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <a href="javascript:" class="close" data-dismiss="modal" aria-label="Close"><span class="glyphicon glyphicon-remove"></span></a>
                        <h4 class="modal-title">' . __('Export the menu', 'sfm') . '</h4>
                      </div>
                      <div class="modal-body">
                        <p style="text-align: center;"><a href="' . $this->parent->assets_url . '../tmp/export_smartmenu.zip" download  onclick="jQuery(\'#sfm_winExport\').modal(\'hide\');" class="btn btn-primary btn-lg" id="sfm_exportLink"><span class="glyphicon glyphicon-floppy-disk"></span>' . __('Download the exported file', 'sfm') . '</a></p>
                      </div>
                    </div><!-- /.modal-content -->
                  </div><!-- /.modal-dialog -->
                </div><!-- /.modal -->';
        echo '</div>'; // eof #sfm_bootstraped
    }

    private function jsonRemoveUnicodeSequences($struct) {
        return json_encode($struct);
    }

    private function getIconsOptionsList() {
        return '<li><a href="javascript:" data-icon=""><i style="width: 22px; height: 22px;"></i></a><li><a href="javascript:" data-icon="fa-adjust"> <i class="fa fa-adjust"></i></a></li><li><a href="javascript:" data-icon="fa-asterisk"> <i class="fa fa-asterisk"></i></a></li><li><a href="javascript:" data-icon="fa-bar-chart"> <i class="fa fa-bar-chart"></i></a></li><li><a href="javascript:" data-icon="fa-barcode"> <i class="fa fa-barcode"></i></a></li><li><a href="javascript:" data-icon="fa-beer"> <i class="fa fa-beer"></i></a></li><li><a href="javascript:" data-icon="fa-bell"> <i class="fa fa-bell"></i></a></li><li><a href="javascript:" data-icon="fa-bolt"> <i class="fa fa-bolt"></i></a></li><li><a href="javascript:" data-icon="fa-book"> <i class="fa fa-book"></i></a></li><li><a href="javascript:" data-icon="fa-bookmark"> <i class="fa fa-bookmark"></i></a></li><li><a href="javascript:" data-icon="fa-briefcase"> <i class="fa fa-briefcase"></i></a></li><li><a href="javascript:" data-icon="fa-bullhorn"> <i class="fa fa-bullhorn"></i></a></li><li><a href="javascript:" data-icon="fa-calendar"> <i class="fa fa-calendar"></i></a></li><li><a href="javascript:" data-icon="fa-camera"> <i class="fa fa-camera"></i></a></li><li><a href="javascript:" data-icon="fa-camera-retro"> <i class="fa fa-camera-retro"></i></a></li><li><a href="javascript:" data-icon="fa-certificate"> <i class="fa fa-certificate"></i></a></li><li><a href="javascript:" data-icon="fa-check"> <i class="fa fa-check"></i></a></li><li><a href="javascript:" data-icon="fa-circle"> <i class="fa fa-circle"></i></a></li><li><a href="javascript:" data-icon="fa-cloud"> <i class="fa fa-cloud"></i></a></li><li><a href="javascript:" data-icon="fa-cloud-download"> <i class="fa fa-cloud-download"></i></a></li><li><a href="javascript:" data-icon="fa-cloud-upload"> <i class="fa fa-cloud-upload"></i></a></li><li><a href="javascript:" data-icon="fa-coffee"> <i class="fa fa-coffee"></i></a></li><li><a href="javascript:" data-icon="fa-cog"> <i class="fa fa-cog"></i></a></li><li><a href="javascript:" data-icon="fa-cogs"> <i class="fa fa-cogs"></i></a></li><li><a href="javascript:" data-icon="fa-comment"> <i class="fa fa-comment"></i></a></li><li><a href="javascript:" data-icon="fa-comments"> <i class="fa fa-comments"></i></a></li><li><a href="javascript:" data-icon="fa-credit-card"> <i class="fa fa-credit-card"></i></a></li><li><a href="javascript:" data-icon="fa-dashboard"> <i class="fa fa-dashboard"></i></a></li><li><a href="javascript:" data-icon="fa-desktop"> <i class="fa fa-desktop"></i></a></li><li><a href="javascript:" data-icon="fa-download"> <i class="fa fa-download"></i></a></li><li><a href="javascript:" data-icon="fa-edit"> <i class="fa fa-edit"></i></a></li><li><a href="javascript:" data-icon="fa-envelope"> <i class="fa fa-envelope"></i></a></li><li><a href="javascript:" data-icon="fa-exchange"> <i class="fa fa-exchange"></i></a></li><li><a href="javascript:" data-icon="fa-external-link"> <i class="fa fa-external-link"></i></a></li><li><a href="javascript:" data-icon="fa-fighter-jet"> <i class="fa fa-fighter-jet"></i></a></li><li><a href="javascript:" data-icon="fa-film"> <i class="fa fa-film"></i></a></li><li><a href="javascript:" data-icon="fa-filter"> <i class="fa fa-filter"></i></a></li><li><a href="javascript:" data-icon="fa-fire"> <i class="fa fa-fire"></i></a></li><li><a href="javascript:" data-icon="fa-flag"> <i class="fa fa-flag"></i></a></li><li><a href="javascript:" data-icon="fa-folder-open"> <i class="fa fa-folder-open"></i></a></li><li><a href="javascript:" data-icon="fa-gift"> <i class="fa fa-gift"></i></a></li><li><a href="javascript:" data-icon="fa-glass"> <i class="fa fa-glass"></i></a></li><li><a href="javascript:" data-icon="fa-globe"> <i class="fa fa-globe"></i></a></li><li><a href="javascript:" data-icon="fa-group"> <i class="fa fa-group"></i></a></li><li><a href="javascript:" data-icon="fa-headphones"> <i class="fa fa-headphones"></i></a></li><li><a href="javascript:" data-icon="fa-heart"> <i class="fa fa-heart"></i></a></li><li><a href="javascript:" data-icon="fa-home"> <i class="fa fa-home"></i></a></li><li><a href="javascript:" data-icon="fa-inbox"> <i class="fa fa-inbox"></i></a></li><li><a href="javascript:" data-icon="fa-key"> <i class="fa fa-key"></i></a></li><li><a href="javascript:" data-icon="fa-leaf"> <i class="fa fa-leaf"></i></a></li><li><a href="javascript:" data-icon="fa-laptop"> <i class="fa fa-laptop"></i></a></li><li><a href="javascript:" data-icon="fa-legal"> <i class="fa fa-legal"></i></a></li><li><a href="javascript:" data-icon="fa-lock"> <i class="fa fa-lock"></i></a></li><li><a href="javascript:" data-icon="fa-unlock"> <i class="fa fa-unlock"></i></a></li><li><a href="javascript:" data-icon="fa-magic"> <i class="fa fa-magic"></i></a></li><li><a href="javascript:" data-icon="fa-magnet"> <i class="fa fa-magnet"></i></a></li><li><a href="javascript:" data-icon="fa-map-marker"> <i class="fa fa-map-marker"></i></a></li><li><a href="javascript:" data-icon="fa-minus"> <i class="fa fa-minus"></i></a></li><li><a href="javascript:" data-icon="fa-mobile-phone"> <i class="fa fa-mobile-phone"></i></a></li><li><a href="javascript:" data-icon="fa-money"> <i class="fa fa-money"></i></a></li><li><a href="javascript:" data-icon="fa-music"> <i class="fa fa-music"></i></a></li><li><a href="javascript:" data-icon="fa-pencil"> <i class="fa fa-pencil"></i></a></li><li><a href="javascript:" data-icon="fa-plane"> <i class="fa fa-plane"></i></a></li><li><a href="javascript:" data-icon="fa-plus"> <i class="fa fa-plus"></i></a></li><li><a href="javascript:" data-icon="fa-print"> <i class="fa fa-print"></i></a></li><li><a href="javascript:" data-icon="fa-qrcode"> <i class="fa fa-qrcode"></i></a></li><li><a href="javascript:" data-icon="fa-quote-left"> <i class="fa fa-quote-left"></i></a></li><li><a href="javascript:" data-icon="fa-quote-right"> <i class="fa fa-quote-right"></i></a></li><li><a href="javascript:" data-icon="fa-random"> <i class="fa fa-random"></i></a></li><li><a href="javascript:" data-icon="fa-refresh"> <i class="fa fa-refresh"></i></a></li><li><a href="javascript:" data-icon="fa-remove"> <i class="fa fa-remove"></i></a></li><li><a href="javascript:" data-icon="fa-reorder"> <i class="fa fa-reorder"></i></a></li><li><a href="javascript:" data-icon="fa-reply"> <i class="fa fa-reply"></i></a></li><li><a href="javascript:" data-icon="fa-retweet"> <i class="fa fa-retweet"></i></a></li><li><a href="javascript:" data-icon="fa-road"> <i class="fa fa-road"></i></a></li><li><a href="javascript:" data-icon="fa-rss"> <i class="fa fa-rss"></i></a></li><li><a href="javascript:" data-icon="fa-search"> <i class="fa fa-search"></i></a></li><li><a href="javascript:" data-icon="fa-share"> <i class="fa fa-share"></i></a></li><li><a href="javascript:" data-icon="fa-share-alt"> <i class="fa fa-share-alt"></i></a></li><li><a href="javascript:" data-icon="fa-shopping-cart"> <i class="fa fa-shopping-cart"></i></a></li><li><a href="javascript:" data-icon="fa-signal"> <i class="fa fa-signal"></i></a></li><li><a href="javascript:" data-icon="fa-sitemap"> <i class="fa fa-sitemap"></i></a></li><li><a href="javascript:" data-icon="fa-sort"> <i class="fa fa-sort"></i></a></li><li><a href="javascript:" data-icon="fa-sort-down"> <i class="fa fa-sort-down"></i></a></li><li><a href="javascript:" data-icon="fa-sort-up"> <i class="fa fa-sort-up"></i></a></li><li><a href="javascript:" data-icon="fa-spinner"> <i class="fa fa-spinner"></i></a></li><li><a href="javascript:" data-icon="fa-star"> <i class="fa fa-star"></i></a></li><li><a href="javascript:" data-icon="fa-star-half"> <i class="fa fa-star-half"></i></a></li><li><a href="javascript:" data-icon="fa-tablet"> <i class="fa fa-tablet"></i></a></li><li><a href="javascript:" data-icon="fa-tag"> <i class="fa fa-tag"></i></a></li><li><a href="javascript:" data-icon="fa-tags"> <i class="fa fa-tags"></i></a></li><li><a href="javascript:" data-icon="fa-tasks"> <i class="fa fa-tasks"></i></a></li><li><a href="javascript:" data-icon="fa-thumbs-down"> <i class="fa fa-thumbs-down"></i></a></li><li><a href="javascript:" data-icon="fa-thumbs-up"> <i class="fa fa-thumbs-up"></i></a></li><li><a href="javascript:" data-icon="fa-tint"> <i class="fa fa-tint"></i></a></li><li><a href="javascript:" data-icon="fa-trash"> <i class="fa fa-trash"></i></a></li><li><a href="javascript:" data-icon="fa-trophy"> <i class="fa fa-trophy"></i></a></li><li><a href="javascript:" data-icon="fa-truck"> <i class="fa fa-truck"></i></a></li><li><a href="javascript:" data-icon="fa-umbrella"> <i class="fa fa-umbrella"></i></a></li><li><a href="javascript:" data-icon="fa-upload"> <i class="fa fa-upload"></i></a></li><li><a href="javascript:" data-icon="fa-user"> <i class="fa fa-user"></i></a></li><li><a href="javascript:" data-icon="fa-user-md"> <i class="fa fa-user-md"></i></a></li><li><a href="javascript:" data-icon="fa-volume-off"> <i class="fa fa-volume-off"></i></a></li><li><a href="javascript:" data-icon="fa-volume-down"> <i class="fa fa-volume-down"></i></a></li><li><a href="javascript:" data-icon="fa-volume-up"> <i class="fa fa-volume-up"></i></a></li><li><a href="javascript:" data-icon="fa-wrench"> <i class="fa fa-wrench"></i></a></li><li><a href="javascript:" data-icon="fa-file"> <i class="fa fa-file"></i></a></li><li><a href="javascript:" data-icon="fa-cut"> <i class="fa fa-cut"></i></a></li><li><a href="javascript:" data-icon="fa-copy"> <i class="fa fa-copy"></i></a></li><li><a href="javascript:" data-icon="fa-paste"> <i class="fa fa-paste"></i></a></li><li><a href="javascript:" data-icon="fa-save"> <i class="fa fa-save"></i></a></li><li><a href="javascript:" data-icon="fa-undo"> <i class="fa fa-undo"></i></a></li><li><a href="javascript:" data-icon="fa-repeat"> <i class="fa fa-repeat"></i></a></li><li><a href="javascript:" data-icon="fa-text-height"> <i class="fa fa-text-height"></i></a></li><li><a href="javascript:" data-icon="fa-text-width"> <i class="fa fa-text-width"></i></a></li><li><a href="javascript:" data-icon="fa-align-left"> <i class="fa fa-align-left"></i></a></li><li><a href="javascript:" data-icon="fa-align-center"> <i class="fa fa-align-center"></i></a></li><li><a href="javascript:" data-icon="fa-align-right"> <i class="fa fa-align-right"></i></a></li><li><a href="javascript:" data-icon="fa-align-justify"> <i class="fa fa-align-justify"></i></a></li><li><a href="javascript:" data-icon="fa-font"> <i class="fa fa-font"></i></a></li><li><a href="javascript:" data-icon="fa-bold"> <i class="fa fa-bold"></i></a></li><li><a href="javascript:" data-icon="fa-italic"> <i class="fa fa-italic"></i></a></li><li><a href="javascript:" data-icon="fa-strikethrough"> <i class="fa fa-strikethrough"></i></a></li><li><a href="javascript:" data-icon="fa-underline"> <i class="fa fa-underline"></i></a></li><li><a href="javascript:" data-icon="fa-link"> <i class="fa fa-link"></i></a></li><li><a href="javascript:" data-icon="fa-columns"> <i class="fa fa-columns"></i></a></li><li><a href="javascript:" data-icon="fa-table"> <i class="fa fa-table"></i></a></li><li><a href="javascript:" data-icon="fa-th-large"> <i class="fa fa-th-large"></i></a></li><li><a href="javascript:" data-icon="fa-th"> <i class="fa fa-th"></i></a></li><li><a href="javascript:" data-icon="fa-th-list"> <i class="fa fa-th-list"></i></a></li><li><a href="javascript:" data-icon="fa-list"> <i class="fa fa-list"></i></a></li><li><a href="javascript:" data-icon="fa-list-ol"> <i class="fa fa-list-ol"></i></a></li><li><a href="javascript:" data-icon="fa-list-ul"> <i class="fa fa-list-ul"></i></a></li><li><a href="javascript:" data-icon="fa-list-alt"> <i class="fa fa-list-alt"></i></a></li><li><a href="javascript:" data-icon="fa-angle-up"> <i class="fa fa-angle-up"></i></a></li><li><a href="javascript:" data-icon="fa-angle-down"> <i class="fa fa-angle-down"></i></a></li><li><a href="javascript:" data-icon="fa-arrow-down"> <i class="fa fa-arrow-down"></i></a></li><li><a href="javascript:" data-icon="fa-arrow-left"> <i class="fa fa-arrow-left"></i></a></li><li><a href="javascript:" data-icon="fa-arrow-right"> <i class="fa fa-arrow-right"></i></a></li><li><a href="javascript:" data-icon="fa-arrow-up"> <i class="fa fa-arrow-up"></i></a></li><li><a href="javascript:" data-icon="fa-caret-down"> <i class="fa fa-caret-down"></i></a></li><li><a href="javascript:" data-icon="fa-caret-up"> <i class="fa fa-caret-up"></i></a></li><li><a href="javascript:" data-icon="fa-chevron-down"> <i class="fa fa-chevron-down"></i></a></li><li><a href="javascript:" data-icon="fa-chevron-left"> <i class="fa fa-chevron-left"></i></a></li><li><a href="javascript:" data-icon="fa-chevron-right"> <i class="fa fa-chevron-right"></i></a></li><li><a href="javascript:" data-icon="fa-chevron-up"> <i class="fa fa-chevron-up"></i></a></li><li><a href="javascript:" data-icon="fa-circle"> <i class="fa fa-circle"></i></a></li><li><a href="javascript:" data-icon="fa-play-circle"> <i class="fa fa-play-circle"></i></a></li><li><a href="javascript:" data-icon="fa-play"> <i class="fa fa-play"></i></a></li><li><a href="javascript:" data-icon="fa-pause"> <i class="fa fa-pause"></i></a></li><li><a href="javascript:" data-icon="fa-stop"> <i class="fa fa-stop"></i></a></li><li><a href="javascript:" data-icon="fa-step-backward"> <i class="fa fa-step-backward"></i></a></li><li><a href="javascript:" data-icon="fa-fast-backward"> <i class="fa fa-fast-backward"></i></a></li><li><a href="javascript:" data-icon="fa-backward"> <i class="fa fa-backward"></i></a></li><li><a href="javascript:" data-icon="fa-forward"> <i class="fa fa-forward"></i></a></li><li><a href="javascript:" data-icon="fa-fast-forward"> <i class="fa fa-fast-forward"></i></a></li><li><a href="javascript:" data-icon="fa-step-forward"> <i class="fa fa-step-forward"></i></a></li><li><a href="javascript:" data-icon="fa-eject"> <i class="fa fa-eject"></i></a></li><li><a href="javascript:" data-icon="fa-phone"> <i class="fa fa-phone"></i></a></li><li><a href="javascript:" data-icon="fa-facebook"> <i class="fa fa-facebook"></i></a></li><li><a href="javascript:" data-icon="fa-twitter"> <i class="fa fa-twitter"></i></a></li><li><a href="javascript:" data-icon="fa-github"> <i class="fa fa-github"></i></a></li><li><a href="javascript:" data-icon="fa-github-alt"> <i class="fa fa-github-alt"></i></a></li><li><a href="javascript:" data-icon="fa-linkedin"> <i class="fa fa-linkedin"></i></a></li><li><a href="javascript:" data-icon="fa-pinterest"> <i class="fa fa-pinterest"></i></a></li><li><a href="javascript:" data-icon="fa-google-plus"> <i class="fa fa-google-plus"></i></a></li><li><a href="javascript:" data-icon="fa-ambulance"> <i class="fa fa-ambulance"></i></a></li><li><a href="javascript:" data-icon="fa-medkit"> <i class="fa fa-medkit"></i></a></li><li><a href="javascript:" data-icon="fa-stethoscope"> <i class="fa fa-stethoscope"></i></a></li><li><a href="javascript:" data-icon="fa-user-md"> <i class="fa fa-user-md"></i></a></li>';
    }

    public function saveStepPosition() {
        global $wpdb;
        $stepID = sanitize_text_field($_POST['stepID']);
        $posX = sanitize_text_field($_POST['posX']);
        $posY = sanitize_text_field($_POST['posY']);
        $table_name = $wpdb->prefix . "sfm_steps";
        $step = $wpdb->get_results("SELECT * FROM $table_name WHERE id=" . $stepID . ' LIMIT 1');
        $step = $step[0];
        $content = json_decode($step->content);
        $content->previewPosX = $posX;
        $content->previewPosY = $posY;

        $wpdb->update($table_name, array('content' => stripslashes($this->jsonRemoveUnicodeSequences($content))), array('id' => $stepID));
        die();
    }

    public function newLink() {
        global $wpdb;
        $originID = sanitize_text_field($_POST['originStepID']);
        $destinationID = sanitize_text_field($_POST['destinationStepID']);
        $table_name = $wpdb->prefix . "sfm_links";
        $wpdb->insert($table_name, array('originID' => $originID, 'destinationID' => $destinationID, 'conditions' => '[]'));
        echo $wpdb->insert_id;
        die();
    }

    public function loadMenu() {
        global $wpdb;
        $rep = new stdClass();
        $rep->steps = array();

        $table_name = $wpdb->prefix . "sfm_settings";
        $params = $wpdb->get_results("SELECT * FROM $table_name");
        $rep->params = $params[0];

        $table_name = $wpdb->prefix . "sfm_steps";
        $steps = $wpdb->get_results("SELECT * FROM $table_name");
        foreach ($steps as $step) {
            $table_name = $wpdb->prefix . "sfm_items";
            $items = $wpdb->get_results("SELECT * FROM $table_name WHERE stepID=" . $step->id . " ORDER BY ordersort ASC");
            $step->items = $items;
            $rep->steps[] = $step;
        }

        $table_name = $wpdb->prefix . "sfm_links";
        $links = $wpdb->get_results("SELECT * FROM $table_name ");
        $rep->links = $links;


        $table_name = $wpdb->prefix . "sfm_settings";
        $params = $wpdb->get_results("SELECT * FROM $table_name");
        $rep->params = $params[0];

        echo($this->jsonRemoveUnicodeSequences($rep));
        die();
    }

    public function removeAllSteps() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $table_name = $wpdb->prefix . "sfm_steps";
            $steps = $wpdb->get_results("SELECT * FROM $table_name");
            foreach ($steps as $step) {
                $table_nameL = $wpdb->prefix . "sfm_links";
                $wpdb->delete($table_nameL, array('originID' => $step->id));
                $wpdb->delete($table_nameL, array('destinationID' => $step->id));
            }

            $delete = $wpdb->query("TRUNCATE TABLE `$table_name`");
            $table_name = $wpdb->prefix . "sfm_items";
            $delete = $wpdb->query("TRUNCATE TABLE `$table_name`");
        }
        die();
    }

    public function removeItem() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $stepID = sanitize_text_field($_POST['stepID']);
            $itemID = sanitize_text_field($_POST['itemID']);

            $table_name = $wpdb->prefix . "sfm_items";
            $wpdb->delete($table_name, array('id' => $itemID));


            $table_links = $wpdb->prefix . "sfm_links";
            $links = $wpdb->get_results("SELECT * FROM $table_links");
            foreach ($links as $link) {
                $conditions = json_decode($link->conditions);
                $newConditions = array();

                foreach ($conditions as $condition) {
                    $oldStep = substr($condition->interaction, 0, strpos($condition->interaction, '_'));
                    $oldItem = substr($condition->interaction, strpos($condition->interaction, '_') + 1);
                    if ($oldStep == $stepID && $oldItem == $itemID) {
                        
                    } else {
                        $newConditions[] = $condition;
                    }
                }
                $wpdb->update($table_links, array('conditions' => $this->jsonRemoveUnicodeSequences($newConditions)), array('id' => $link->id));
            }
        }
        die();
    }

    public function removeStep() {
        global $wpdb;
        if (current_user_can('manage_options')) {
            $table_name = $wpdb->prefix . "sfm_steps";

            $wpdb->delete($table_name, array('id' => sanitize_text_field($_POST['stepID'])));
            $table_name = $wpdb->prefix . "sfm_links";
            $wpdb->delete($table_name, array('originID' => sanitize_text_field($_POST['stepID'])));
            $wpdb->delete($table_name, array('destinationID' => sanitize_text_field($_POST['stepID'])));
        }
        die();
    }

    public function addStep() {
        global $wpdb;
        if (current_user_can('manage_options')) {
            $table_name = $wpdb->prefix . "sfm_steps";

            $data = new stdClass();
            $data->start = sanitize_text_field($_POST['start']);

            $stepsStart = $wpdb->get_results("SELECT * FROM $table_name WHERE start=1");
            if (count($stepsStart) == 0) {
                $data->start = 1;
            }

            if ($data->start == 1) {
                $steps = $wpdb->get_results("SELECT * FROM $table_name WHERE start=1");
                foreach ($steps as $step) {
                    $dataContent = json_decode($step->content);
                    $dataContent->start = 0;
                    $wpdb->update($table_name, array('content' => $this->jsonRemoveUnicodeSequences($dataContent), 'start' => 0), array('id' => $data->id));
                }
            }
            $data->previewPosX = sanitize_text_field($_POST['previewPosX']);
            $data->previewPosY = sanitize_text_field($_POST['previewPosY']);
            $data->actions = array();

            $title = __('My Step', 'sfm');

            if (isset($_POST['title']) && $_POST['title'] != "") {
                $title = sanitize_text_field($_POST['title']);
            }

            $wpdb->insert($table_name, array('content' => $this->jsonRemoveUnicodeSequences($data), 'title' => $title, 'start' => $data->start));
            $data->id = $wpdb->insert_id;
            echo json_encode((array) $data);
        }
        die();
    }

    public function loadStep() {
        global $wpdb;
        if (current_user_can('manage_options')) {
            $rep = new stdClass();
            $table_name = $wpdb->prefix . "sfm_steps";
            $step = $wpdb->get_results("SELECT * FROM $table_name WHERE id='" . sanitize_text_field($_POST['stepID']) . "' LIMIT 1");
            $rep->step = $step[0];
            $table_name = $wpdb->prefix . "sfm_items";
            $items = $wpdb->get_results("SELECT * FROM $table_name WHERE stepID='" . sanitize_text_field($_POST['stepID']) . "' ORDER BY ordersort ASC");
            $rep->items = $items;
            echo $this->jsonRemoveUnicodeSequences((array) $rep);
        }
        die();
    }

    public function saveItem() {
        global $wpdb;
        if (current_user_can('manage_options')) {
            $stepID = sanitize_text_field($_POST['stepID']);
            $itemID = sanitize_text_field($_POST['id']);

            $table_name = $wpdb->prefix . "sfm_items";

            $sqlDatas = array();
            foreach ($_POST as $key => $value) {
                if ($key != 'action' && $key != 'id' && $key != 'pll_ajax_backend' && $key != "undefined" && $key != 'files') {
                    $sqlDatas[$key] = stripslashes($value);
                }
            }
            if ($itemID > 0) {
                $wpdb->update($table_name, $sqlDatas, array('id' => $itemID));
                $response = $_POST['id'];
            } else {
                $sqlDatas['stepID'] = $stepID;

                $lastItem = $wpdb->get_results("SELECT * FROM $table_name WHERE stepID=$stepID ORDER BY ordersort DESC LIMIT 1");
                $sqlDatas['ordersort'] = $lastItem[0]->ordersort + 1;

                $wpdb->insert($table_name, $sqlDatas);
                $itemID = $wpdb->insert_id;
            }
            echo $itemID;
        }
        die();
    }

    public function saveStep() {
        global $wpdb;
        if (current_user_can('manage_options')) {
            $stepID = sanitize_text_field($_POST['id']);
            $itemsList = sanitize_text_field($_POST['itemsList']);

            $itemsListArray = explode('|', $itemsList);
            foreach ($itemsListArray as $value) {
                $itemArray = explode('°', $value);

                $table_name = $wpdb->prefix . "sfm_items";
                $wpdb->update($table_name, array('title' => stripslashes($itemArray[0]), 'stepID' => $stepID), array('id' => $itemArray[1]));
            }

            $table_name = $wpdb->prefix . "sfm_steps";
            $sqlDatas = array();
            foreach ($_POST as $key => $value) {
                if ($key != 'action' && $key != 'id' && $key != 'pll_ajax_backend' && $key != 'itemsList' && $key != "files" && $key != "undefined") {
                    $sqlDatas[$key] = (stripslashes($value));
                }
            }

            if ($stepID > 0) {
                $wpdb->update($table_name, $sqlDatas, array('id' => $stepID));
                $response = sanitize_text_field($_POST['id']);
            } else {
                $wpdb->insert($table_name, $sqlDatas);
                $stepID = $wpdb->insert_id;
            }
            echo $stepID;
        }
        die();
    }

    public function saveLinks() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $table_name = $wpdb->prefix . "sfm_links";
            if (substr(sanitize_text_field($_POST['links']), 0, 1) == '[') {
                $links = json_decode(stripslashes($_POST['links']));

                $existingLinks = $wpdb->get_results("SELECT * FROM $table_name");
                if (count($existingLinks) > 1 && count($links) < 1) {
                    
                } else {
                    $chkOk = false;
                    foreach ($links as $link) {
                        if (isset($link->destinationID) && $link->destinationID > 0) {
                            $chkOk = true;
                        }
                    }
                    if($chkOk){
                        $wpdb->query("DELETE FROM $table_name WHERE id>0");
                        foreach ($links as $link) {
                            if (isset($link->destinationID) && $link->destinationID > 0) {
                                $wpdb->insert($table_name, array('operator' => $link->operator, 'originID' => $link->originID, 'destinationID' => $link->destinationID, 'conditions' => $this->jsonRemoveUnicodeSequences($link->conditions)));
                            }
                        }
                    }
                }
            }
            echo '1';
            die();
        }
    }

    public function duplicateStep() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $table_name = $wpdb->prefix . "sfm_steps";
            $stepID = sanitize_text_field($_POST['stepID']);
            $steps = $wpdb->get_results("SELECT * FROM $table_name WHERE id=" . $stepID);
            $step = $steps[0];
            $step->title = $step->title . ' (1)';
            $step->start = 0;
            unset($step->id);

            $content = json_decode($step->content);
            $content->previewPosX += 40;
            $content->previewPosY += 40;
            $content->start = 0;
            $step->content = stripslashes($this->jsonRemoveUnicodeSequences($content));

            //$wpdb->insert($table_name, array('content' => $this->jsonRemoveUnicodeSequences($content), 'start' => 0,'title'=>$step->title,'itemRequired'=>$step->itemRequired ));
            $wpdb->insert($table_name, (array) $step);
            $newID = $wpdb->insert_id;

            $table_name = $wpdb->prefix . "sfm_items";
            $items = $wpdb->get_results("SELECT * FROM $table_name WHERE stepID=$stepID");
            foreach ($items as $item) {
                $item->stepID = $newID;
                unset($item->id);
                $wpdb->insert($table_name, (array) $item);
            }
            die();
        }
    }

    public function duplicateItem() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $table_name = $wpdb->prefix . "sfm_items";
            $itemID = sanitize_text_field($_POST['itemID']);
            $items = $wpdb->get_results("SELECT * FROM $table_name WHERE id=" . $itemID);
            $item = $items[0];
            $item->title = $item->title . ' (1)';
            unset($item->id);
            $wpdb->insert($table_name, (array) $item);
        }
        die();
    }

    public function changeItemsOrders() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $items = sanitize_text_field($_POST['items']);
            $items = explode(',', $items);
            $table_name = $wpdb->prefix . "sfm_items";
            foreach ($items as $key => $value) {
                $wpdb->update($table_name, array('ordersort' => $key), array('id' => $value));
            }
        }
        die();
    }

    public function importMenu() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            $displayMenu = true;
            $settings = $this->getSettings();
            $code = $settings->purchaseCode;
            if (isset($_FILES['importFile'])) {
                $error = false;
                if (!is_dir(plugin_dir_path(__FILE__) . '../tmp')) {
                    mkdir(plugin_dir_path(__FILE__) . '../tmp');
                    chmod(plugin_dir_path(__FILE__) . '../tmp', 0747);
                }
                $target_path = plugin_dir_path(__FILE__) . '../tmp/export_smartmenu.zip';
                if (@move_uploaded_file($_FILES['importFile']['tmp_name'], $target_path)) {


                    $upload_dir = wp_upload_dir();
                    if (!is_dir($upload_dir['path'])) {
                        mkdir($upload_dir['path']);
                    }

                    $zip = new ZipArchive;
                    $res = $zip->open($target_path);
                    if ($res === TRUE) {
                        $zip->extractTo(plugin_dir_path(__FILE__) . '../tmp/');
                        $zip->close();

                        $formsData = array();

                        $jsonfilename = 'export_smartmenu.json';
                        if (!file_exists(plugin_dir_path(__FILE__) . '../tmp/export_smartmenu.json')) {
                            $jsonfilename = 'export_smartmenu';
                        }

                        $file = file_get_contents(plugin_dir_path(__FILE__) . '../tmp/' . $jsonfilename);
                        $dataJson = json_decode($file, true);

                        $table_name = $wpdb->prefix . "sfm_settings";
                        $settingsData = $dataJson['settings'][0];
                        unset($settingsData['purchaseCode']);
                        $wpdb->update($table_name, $settingsData,array('id'=>1));                        

                        $table_name = $wpdb->prefix . "sfm_steps";
                        $wpdb->query("TRUNCATE TABLE $table_name");
                        $prevPosX = 40;
                        $firstStep = false;
                        foreach ($dataJson['steps'] as $key => $value) {
                            $wpdb->insert($table_name, $value);
                        }

                        $table_name = $wpdb->prefix . "sfm_links";
                        $wpdb->query("TRUNCATE TABLE $table_name");
                        if (array_key_exists('links', $dataJson)) {
                            foreach ($dataJson['links'] as $key => $value) {
                                $wpdb->insert($table_name, $value);
                            }
                        }

                        $table_name = $wpdb->prefix . "sfm_items";
                        $wpdb->query("TRUNCATE TABLE $table_name");
                        foreach ($dataJson['items'] as $key => $value) {

                            if ($value['image'] && $value['image'] != "") {
                                $img_name = substr($value['image'], strrpos($value['image'], '/') + 1);
                                $imagePath = substr($value['image'], 0, strrpos($value['image'], '/'));
                                if (!file_exists(site_url() . '/' . $value['image'])) {
                                    if (!is_dir($imagePath)) {
                                        $imagePath = wp_upload_dir();
                                    }
                                    if (strrpos($value['image'], "uploads") === false) {
                                        $value['image'] = 'uploads' . $value['image'];
                                    }
                                    if (is_file(plugin_dir_path(__FILE__) . '../tmp/' . $img_name)) {
                                        copy(plugin_dir_path(__FILE__) . '../tmp/' . $img_name, $imagePath['basedir'] . $imagePath['subdir'] . '/' . $img_name);
                                    }
                                }
                                $value['image'] = $imagePath['url'] . '/' . $img_name;
                            }
                            $wpdb->insert($table_name, $value);
                        }

                        $files = glob(plugin_dir_path(__FILE__) . '../tmp/*');
                        foreach ($files as $file) {
                            if (is_file($file))
                                unlink($file);
                        }
                    } else {
                        $error = true;
                    }
                } else {
                    $error = true;
                }
                if ($error) {
                    echo __('An error occurred during the transfer', 'sfm');
                    die();
                } else {
                    $displayMenu = false;
                    echo 1;
                    die();
                }
            }
        }
    }

    public function exportMenu() {
        if (current_user_can('manage_options')) {
            global $wpdb;
            if (!is_dir(plugin_dir_path(__FILE__) . '../tmp')) {
                mkdir(plugin_dir_path(__FILE__) . '../tmp');
                chmod(plugin_dir_path(__FILE__) . '../tmp', 0747);
            }

            $destination = plugin_dir_path(__FILE__) . '../tmp/export_smartmenu.zip';
            if (file_exists($destination)) {
                unlink($destination);
            }
            $zip = new ZipArchive();
            if ($zip->open($destination, ZipArchive::CREATE) !== true) {
                return false;
            }

            $jsonExport = array();
            $table_name = $wpdb->prefix . "sfm_settings";
            $settings = $this->getSettings();
            $settings->purchaseCode = "";

            $jsonExport['settings'] = array();
            $jsonExport['settings'][] = $settings;
                
            $table_name = $wpdb->prefix . "sfm_steps";
            $steps = array();
            foreach ($wpdb->get_results("SELECT * FROM $table_name") as $key => $row) {
                $steps[] = $row;
            }
            $jsonExport['steps'] = $steps;

            $table_name = $wpdb->prefix . "sfm_links";
            $steps = array();
            foreach ($wpdb->get_results("SELECT * FROM $table_name") as $key => $row) {
                $steps[] = $row;
            }
            $jsonExport['links'] = $steps;


            $table_name = $wpdb->prefix . "sfm_items";
            $items = array();
            foreach ($wpdb->get_results("SELECT * FROM $table_name") as $key => $row) {
                $items[] = $row;
                if ($row->image != "") {
                    $original_image = $row->image;
                    $upload_dir = wp_upload_dir();
                    $pos1 = strrpos($original_image, '/');
                    $pos2 = strrpos($row->image, '/', 0 - (strlen($row->image) - $pos1) - 1);
                    $pos3 = strrpos($row->image, '/', 0 - (strlen($row->image) - $pos2) - 1);
                    $row->image = substr($row->image, strlen(site_url()) + 1);
                    if (strrpos($row->image, "wp-content") > -1) {
                        $row->image = substr($row->image, strrpos($row->image, "wp-content") + 11);
                    }
                    if (substr($row->image, 0, 17) == '/uploads/uploads/') {
                        $row->image = substr($row->image, 9);
                    }
                    $zip->addfile($this->dir . "/../../" . $row->image, substr($original_image, $pos1 + 1));
                }
            }

            $jsonExport['items'] = $items;
            $fp = fopen(plugin_dir_path(__FILE__) . '../tmp/export_smartmenu.json', 'w');
            fwrite($fp, json_encode($jsonExport));
            fclose($fp);

            $zip->addfile(plugin_dir_path(__FILE__) . '../tmp/export_smartmenu.json', 'export_smartmenu.json');
            $zip->close();
            echo '1';
            die();
        }
    }

    /**
     * Main Instance
     *
     *
     * @since 1.0.0
     * @static
     * @return Main instance
     */
    public static function instance($parent) {
        if (is_null(self::$_instance)) {
            self::$_instance = new self($parent);
        }
        return self::$_instance;
    }

    // End instance()

    /**
     * Cloning is forbidden.
     *
     * @since 1.0.0
     */
    public function __clone() {
        _doing_it_wrong(__FUNCTION__, '', $this->parent->_version);
    }

// End __clone()

    /**
     * Unserializing instances of this class is forbidden.
     *
     * @since 1.0.0
     */
    public function __wakeup() {
        _doing_it_wrong(__FUNCTION__, '', $this->parent->_version);
    }

// End __wakeup()
}
