/*!
 * jQuery Custom Select Plugin
 * https://github.com/kvlsrg/custom-select
 *
 * Copyright (c) 2016 Sergey Kovalenko
 * Released under the MIT license
 */

(function ($) {

  $.fn.customSelect = function () {

    var $select = $(this);
    
    $select.hide();
    
    $select.after(
      '<div class="custom-select">' +
          '<a class="custom-select__option custom-select__option--value"></a>' +
          '<div class="custom-select__dropdown"></div>' +
      '</div>'
    );
    
    var $body = $('body');
    var $selectOptions = $select.find('option');
    var customSelect = '.custom-select';
    var $customSelect = $(customSelect);
    var customSelectActiveClass = customSelect.substring(1) + '--active';
    var $customSelectValue = $(customSelect + '__option--value');
    var $dropdown = $(customSelect + '__dropdown');
    var dropdownOptions = customSelect + '__option--dropdown';
    var dropdownOptionHtml = '<a class="custom-select__option custom-select__option--dropdown"></a>';
    
    var optionsArray = [];

      createOptionsArray();

      $dropdown.html('');

      $.each(optionsArray, function (i, el) {
        if (i == 0) {
          $customSelectValue.text(el);
        } else {
          $dropdown.append(dropdownOptionHtml);
          var current = $(dropdownOptions)[i - 1];
          $(current).text(el);
        }
      });

      setDropdownToggle();

      var $dropdownOptions = $(dropdownOptions);

      $dropdownOptions.on('click', function () {
        var choice = $(this).text().trim();
        $customSelectValue.text(choice);
        $selectOptions.prop('selected', false);
        $.each(optionsArray, function (i, el) {
          if (el == choice) {
            optionsArray.splice(i, 1);
          }
          $.each($selectOptions, function (i, option) {
            if ($(option).text() == choice) {
              $(option).prop('selected', true);
            }
          });
        });
        $.each($dropdownOptions, function (i, option) {
          $(option).text(optionsArray[i]);
        });
        createOptionsArray();
      });

      function createOptionsArray() {
        optionsArray = [];
        $.each($selectOptions, function (i, option) {
          var el = $(option).text();
          optionsArray.push(el);
        });
      }

      function setDropdownToggle() {
        $customSelectValue.on('click', function () {
          $customSelect.addClass(customSelectActiveClass);
          $dropdown.slideDown('fast', function () {
            $customSelectValue.off();
            $body.on('click', function () {
              $customSelect.removeClass(customSelectActiveClass);
              $dropdown.slideUp('fast', function () {
                $body.off();
                setDropdownToggle();
              });
            });
          });
        });
      }

  };

})(jQuery);
