var sfm_fixedelements = new Array();
var sfm_initialBodyOverflowX;
var sfm_initialHtmlOverflowX;
var sfm_initialBodyOverflowY;
var sfm_endScrollEnable = false;
var sfm_panelShown = false;
var sfm_currentStepID = 0;
var sfm_canClick = true;
var sfm_noStep = false;
var sfm_startStepID = 0;
var sfm_modeMobile = false;
var sfm_lastStep = 0;

sfm_data = sfm_data[0];
jQuery(document).ready(function () {    
    if (jQuery(window).width() <= 480) {
        sfm_modeMobile = true;
    }
    sfm_initMenu();
    if (sfm_data.settings.integrationType == "fixedButton") {
            sfm_initButton();      
    } else {
        jQuery(sfm_data.settings.domElement).click(sfm_showMenu);
    }
    sfm_onResize();
    jQuery(window).scroll(sfm_onScroll);
    jQuery(window).resize(sfm_onResize);
});
jQuery(window).load(function(){
    setTimeout(sfm_onScroll,500);
    if (sfm_startStepID != 0 && sfm_startStepID != 'final') {
        if (document.location.href.indexOf('sfm_action=preview') > -1) {
            sessionStorage.setItem("sfm_visit",0);
            setTimeout(sfm_showMenu, 500);
        } else if(sfm_data.settings.autoShow == '1' && sessionStorage.getItem("sfm_visit") === null || sessionStorage.getItem("sfm_visit") == 0){
            setTimeout(sfm_showMenu, 500);      
            sessionStorage.setItem("sfm_visit",1);
        }
    } else {
     //   sfm_noStep = true;
        jQuery('#sfm_menuBtn').hide();
    }
});
function sfm_initButton() {
    if (!sfm_noStep) {
        if (sfm_data.settings.menuBtn_icon == "") {
            sfm_data.settings.menuBtn_icon = "fa-bars";
        }
        var btn = jQuery('<a href="javascript:" id="sfm_menuBtn"><span class="fa ' + sfm_data.settings.menuBtn_icon + '"></span></a>');
        btn.addClass(sfm_data.settings.fixedBtnPosition);
        btn.click(sfm_showMenu);
        btn.css('opacity','0');
        jQuery('body').append(btn);
        
        setTimeout(function(){  
            btn.animate({opacity:1},300);
        },1000);
    }
}
function sfm_initMenu() {
    var $menu = jQuery('<div id="sfm_menu"></div>');
    var $bootstraped = jQuery('<div id="sfm_bootstraped" class="sfm_bootstraped"></div>');
    $bootstraped.append('<a href="javascript:" id="sfm_btnCloseMenu" onclick="sfm_hideMenu(false);"><span class="fa fa-times"></span></a>');
    $menu.append($bootstraped);
    jQuery('body').append($menu);
    if (sfm_data.settings.animationMenu == 'fade') {
        $menu.addClass('sfm_fadeFx');
        sfm_initialBodyOverflowY = jQuery('html').css('overflow-y');

    }

    $wrapper = jQuery('<div id="sfm_wrapper"></div>');
    sfm_initialBodyOverflowX = jQuery('body').css('overflow-x');
    sfm_initialHtmlOverflowX = jQuery('html').css('overflow-x');
    if (sfm_data.settings.animationMenu == 'slideRight') {
        $wrapper.css({
            left: 'auto'
        });
        $menu.find('.sfm_arrowScroll').addClass('sfm_right');
        jQuery('html,body').css('overflow-x', 'hidden');
    } else if (sfm_data.settings.animationMenu == 'slideLeft') {
        $menu.find('.sfm_arrowScroll').addClass('sfm_left');
    } else if (sfm_data.settings.animationMenu == 'fade') {
        $menu.hide();
    }
    jQuery('body').prepend($wrapper);

    jQuery.each(sfm_data.steps, function () {
        var step = this;
        var dataStart = '';
        var $step = jQuery('<div class="sfm_step ' + dataStart + '" data-stepid="' + this.id + '"></div>');
        $menu.append($step);
        if (step.showTitle == '1') {
            $step.append('<div class="sfm_stepTitle">' + step.title + '</div>');
        }
        jQuery.each(this.items, function () {
            var item = this;
            var $item;
            if (item.type == "image") {
                if (!item.image || item.image == "" || item.image == 0) {
                    item.image = sfm_data.assetsUrl + 'img/monitor.svg';
                }
                var inverseFxClass = '';
                if (sfm_data.settings.inverseGrayFx == '1') {
                    inverseFxClass = 'sfm_inversedFx';
                }
                $item = jQuery('<a href="javascript:" class="sfm_item ' + inverseFxClass + '"></a>');
                $step.append($item);
                var $img;
                $img = jQuery('<img class="sfm_image" src="' + item.image + '" alt="' + item.title + '"/>');
                $item.append($img);
                $item.append('<span class="sfm_checkIcon fa ' + sfm_data.settings.checkedItemicon + '"></span>');
                
                if (item.showTitle == '1') {
                        if (sfm_data.settings.showLinksTitlesAsTooltips == '0') {
                            $item.append('<div class="sfm_itemTitle">' + item.title + '</div>');
                        } else {
                            if (sfm_modeMobile) {
                                var tooltip = jQuery('<div class="ui-tooltip ui-widget ui-corner-all ui-widget-content" role="tooltip">' + item.title + '</div>').css({
                                    position: 'relative',
                                    opacity: 1
                                });
                                $item.append(tooltip);
                            } else {
                                $item.attr('title', item.title);
                                $item.attr('data-toggle', 'tooltip');
                                $item.attr('data-placement', 'bottom');
                            }
                        }
                    }
                $item.click(function () {
                    sfm_itemClicked(this);
                });
            } else if (item.type == "dropdown") {
                $item = jQuery('<div class="sfm_item"></div>');
                if (item.showTitle == '1') {
                $item.append('<div class="sfm_itemTitle">' + item.title + '</div>');
            }
                var $select = jQuery('<select class="sfm_field"></select>');
                $item.append($select);
                if (item.placeholder != "") {
                    $select.append('<option value="' + item.placeholder + '" disabled selected>' + item.placeholder + '</option>');
                }
                jQuery.each(item.optionsValues, function () {
                    if (this != "") {
                        $select.append('<option value="' + this + '">' + this + '</option>');
                    }
                });
                $step.append($item);
                $select.sexySelect();
                $select.on('change', function () {
                    sfm_itemClicked($item.get(0));
                });
            } else if (item.type == "slider") {
                $item = jQuery('<div class="sfm_item"></div>');
                if (item.showTitle == '1') {
                $item.append('<div class="sfm_itemTitle">' + item.title + '</div>');
            }
                $step.append($item);
                var $slider = jQuery('<div class="sfm_slider"></div>');
                $item.append($slider);

                var tooltip = jQuery('<div class="ui-tooltip ui-widget ui-corner-all ui-widget-content" role="tooltip">' + item.minValue + '</div>').css({
                    position: 'absolute',
                    bottom: -50,
                    left: -6,
                    opacity: 1
                }).hide();
                var step = 1;
                $slider.slider({
                    range: "min",
                    value: parseInt(item.valueMin),
                    min: parseInt(item.valueMin),
                    max: parseInt(item.valueMax),
                    slide: function (event, ui) {
                        var _this = this;

                        tooltip.html(ui.value);
                        tooltip.show();
                    },
                    change: function (event, ui) {
                        var _this = this;
                        tooltip.html(ui.value);
                    },
                    start: function (event, ui) {
                        tooltip.html(ui.value);
                        tooltip.show();
                    },
                    stop: function (event, ui) {
                        sfm_itemClicked($item.get(0));

                    }
                }).find(".ui-slider-handle").append(tooltip).hover(function () {
                    tooltip.show();
                }, function () {
                    tooltip.hide();
                });
                tooltip.hide();
                setTimeout(function () {
                    $slider.slider('value', parseInt(item.valueMin));
                    tooltip.hide();
                }, 300);
            } else if (item.type == "textfield") {
                $item = jQuery('<div class="sfm_item"></div>');
                if (item.showTitle == '1') {
                $item.append('<div class="sfm_itemTitle">' + item.title + '</div>');
            }
                $step.append($item);
                var field = jQuery('<input class="sfm_field" />');
                $item.append(field);
                field.attr('placeholder', item.placeholder);
                field.on('change', function () {
                    sfm_itemClicked($item.get(0));
                });
                field.on('focusout', function () {
                    sfm_itemClicked($item.get(0));
                });
            } else if (item.type == "numberfield") {
                $item = jQuery('<div class="sfm_item"></div>');
                if (item.showTitle == '1') {
                $item.append('<div class="sfm_itemTitle">' + item.title + '</div>');
            }
                $step.append($item);
                if (item.valueMax == 0) {
                    item.valueMax = 99999999999;
                }
                var field = jQuery('<input class="sfm_field" type="number" min="' + item.valueMin + '" max="' + item.valueMax + '"  />');
                $item.append(field);
                field.focusout(function () {
                    if (jQuery(this).val().indexOf('-') > -1 && (!jQuery(this).is('[min]') || jQuery(this).attr('min').indexOf('-') < 0)) {
                        jQuery(this).val(parseInt(jQuery(this).attr('min')));
                    }
                    if (parseFloat(jQuery(this).val()) < parseFloat(jQuery(this).attr('min'))) {
                        jQuery(this).val(jQuery(this).attr('min'));
                    }
                    if (parseFloat(jQuery(this).val()) > parseFloat(jQuery(this).attr('max'))) {
                        jQuery(this).val(jQuery(this).attr('max'));
                    }
                    sfm_itemClicked($item.get(0));
                });
            } else if (item.type == "title") {
                $item = jQuery('<div class="sfm_item sfm_elementTitle">' + item.title + '</div>');
                $step.append($item);

            } else if (item.type == "richtext") {
                $item = jQuery('<div></div>');
                if (jQuery('.sfm_richTextContent[data-originalitemid="' + item.id + '"]').length > 0) {
                    $item = jQuery('<div class="sfm_item sfm_richText"></div>');
                    jQuery('.sfm_richTextContent[data-originalitemid="' + item.id + '"]').detach().appendTo($item);
                }
                $step.append($item);
            } else if (item.type == "shortcode") {
                $item = jQuery('<div></div>');
                if (jQuery('.sfm_shortcodeContent[data-originalitemid="' + item.id + '"]').length > 0) {
                    $item = jQuery('<div class="sfm_item sfm_shortcode"></div>');
                    jQuery('.sfm_shortcodeContent[data-originalitemid="' + item.id + '"]').detach().appendTo($item);
                }
                $step.append($item);
            }


            var layoutClass = "sfm_inline";
            if (item.layout == "fullRow") {
                layoutClass = "sfm_fullRow";
            }
            $item.addClass(layoutClass);
            $item.attr('data-type', item.type);
            $item.attr('data-placeholder', item.placeholder);
            $item.attr('data-actiontype', item.actionType);
            $item.attr('data-url', item.url);
            $item.attr('data-domelement', item.domElement);
            $item.attr('data-executedjs', item.executedJS);
            $item.attr('data-isrequired', item.isRequired);
            $item.attr('data-informationtype', item.informationType);
            $item.attr('data-sendcontact', item.sendContactOnChange);
            $item.attr('data-itemid', item.id);
        });

    });
    if (jQuery('#sfm_menu [data-toggle="tooltip"]').length > 0) {
        jQuery('#sfm_menu [data-toggle="tooltip"]').tooltip({
            position: {my: "center top+35", at: "center bottom"},
            open: function (event, ui) {
                if (!jQuery(this).is('.sfm_show')) {
                    event.preventDefault();
                }
            }
        });
    }

    jQuery.each(sfm_data.steps, function () {
        if (this.start == '1') {
            if (this.items.length == 0) {
                sfm_startStepID = sfm_findPotentialsSteps(this.id);
                 if(sfm_startStepID.length > 0){
                    sfm_startStepID = sfm_startStepID[0];
                }else {
                    sfm_startStepIDs = 0;
                }
                sfm_currentStepID = sfm_startStepID;
            } else {
                sfm_startStepID = this.id;
                sfm_currentStepID = sfm_startStepID;
            }
        }
    });
    jQuery('#sfm_menu .sfm_step[data-stepid="' + sfm_startStepID + '"]').addClass('sfm_currentStep').addClass('sfm_startStep');

    sfm_onResize();
    if (sfm_startStepID != 0 && sfm_startStepID != 'final') {
       /* if (document.location.href.indexOf('sfm_action=preview') > -1) {
            setTimeout(sfm_showMenu, 400);
        } else if(sfm_data.settings.autoShow == '1' && sessionStorage.getItem("sfm_visit") === null || sessionStorage.getItem("sfm_visit") == 0){
            setTimeout(sfm_showMenu, 400);      
            sessionStorage.setItem("sfm_visit",1);
        }*/
    } else {
        sfm_noStep = true;
        //jQuery('#sfm_menuBtn').hide();
    }
}
function sfm_hideMenu(callback) {
    sfm_panelShown = false;
    if (!sfm_modeMobile) {
        jQuery('.ui-tooltip').fadeOut();
        setTimeout(function () {
            jQuery('.ui-tooltip').remove();
        }, 300);
    }
    sfm_currentStepID = sfm_startStepID;
    sfm_endScrollEnable = false;
    jQuery('html,body').scrollTop(0);
    sfm_panelShown = false;
    var posTop = 0 - jQuery('#sfm_menu').height();
    var posLeft = 0;
    var posRight = 'auto';
    var wrapPosLeft = 0;
    var wrapPosRight = 'auto';
    var opacity = 1;
    if (sfm_data.settings.animationMenu == 'slideLeft') {
        posTop = 0;
        posLeft = 0 - jQuery(window).width();
    } else if (sfm_data.settings.animationMenu == 'slideRight') {
        posTop = 0;
        posRight = 0 - jQuery(window).width();
        posLeft = 'auto';
        wrapPosLeft = 'auto';
        wrapPosRight = 0;
    } else if (sfm_data.settings.animationMenu == 'fade') {
        posTop = 0;
        opacity = 0;
    }
    jQuery("#sfm_menu").animate({
        top: posTop,
        left: posLeft,
        right: posRight,
        opacity: opacity
    }, 800);

    jQuery("#sfm_wrapper").animate({
        top: 0,
        left: wrapPosLeft,
        right: wrapPosRight
    }, 800);
    setTimeout(function () {
        if (sfm_data.settings.animationMenu == 'fade') {
            jQuery('#sfm_menu').hide();
            jQuery('html').css({overflowY: sfm_initialBodyOverflowY});
        } else {
            jQuery.each(sfm_fixedelements, function () {
                jQuery(this).fadeIn();
            });
            jQuery('#sfm_wrapper>*').detach().appendTo('body');
        }
        if (sfm_data.settings.animationMenu == 'slideRight') {
            jQuery('html').css('overflow-x', sfm_initialHtmlOverflowX);
            jQuery('body').css('overflow-x', sfm_initialBodyOverflowX);
        }
        if (callback) {
            callback();
        }
        if (sfm_data.settings.animationMenu == "slideUp") {
            jQuery('html,body').animate({
                scrollTop: 0
            }, 300);
        }
        
        jQuery("#sfm_menu .sfm_currentStep:not(.sfm_startStep)").removeClass('sfm_currentStep');
        jQuery("#sfm_menu .sfm_currentStep:not(.sfm_startStep)").hide();
        jQuery("#sfm_menu").hide();
        
    }, 800);
}
function sfm_isTactil() {
    var check = false;
    (function (a) {
        if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4)))
            check = true
    })(navigator.userAgent || navigator.vendor || window.opera);
    return check;
}
function sfm_showMenu() {
    if (jQuery('#sfm_menu [data-toggle="tooltip"]').length > 0) {
        jQuery('#sfm_menu [data-toggle="tooltip"]').tooltip();
    }
    var delay = 500;
    if (!sfm_panelShown) {
        sfm_panelShown = true;
        sfm_fixedelements = new Array();
        if (sfm_data.settings.animationMenu != 'fade') {
            jQuery('body *').each(function () {
                if (jQuery(this).css('position') == 'fixed') {
                    if (parseFloat(jQuery(this).css('opacity')) > 0 && jQuery(this).css('display') != 'none') {
                        sfm_fixedelements.push(jQuery(this));
                        jQuery(this).fadeOut();
                    }
                }
            });
            jQuery('#sfm_menu .sfm_stepTitle').css({opacity: 0});
            jQuery('#sfm_menu .sfm_item').removeClass('sfm_show');
            jQuery('#sfm_menu .sfm_checked').removeClass('sfm_checked');
            sfm_currentStepID = sfm_startStepID;
            jQuery('body>*:not(#sfm_wrapper):not(#sfm_menu)').detach().appendTo('#sfm_wrapper');
            jQuery('#sfm_menu').show();
            jQuery('html,body').animate({
                scrollTop: 0
            }, 500);
        } else {
            delay = 0;
            jQuery('#sfm_menu').css('opacity', 1);
            jQuery('html').css({overflowY: 'hidden'});
        }
        setTimeout(function () {
            if (sfm_data.settings.animationMenu == 'slideLeft') {
                jQuery('#sfm_wrapper').animate({
                    left: jQuery(window).width()
                }, 500);
                jQuery("#sfm_menu").animate({
                    left: 0
                }, 500);
            } else if (sfm_data.settings.animationMenu == 'slideRight') {
                jQuery('#sfm_wrapper').animate({
                    right: jQuery(window).width()
                }, 500);
                jQuery("#sfm_menu").animate({
                    right: 0
                }, 500);
            } else if (sfm_data.settings.animationMenu == 'fade') {
                jQuery('#sfm_wrapper').animate({
                    opacity: 0
                }, 500);
                jQuery("#sfm_menu").fadeIn();
            } else {
                jQuery('#sfm_wrapper').animate({
                    top: jQuery(window).height()
                }, 500);
                jQuery("#sfm_menu").animate({
                    top: 0
                }, 500);
            }
            setTimeout(function () {
                sfm_endScrollEnable = true;
                sfm_updateMenuHeight();
            }, 500);
            if (sfm_data.previewMode != '1') {
                localStorage.setItem("sfm_done", "1");
            } else {
                localStorage.removeItem("sfm_done");
            }
        }, delay);
    }

    var delay = 0;
    setTimeout(function () {
        jQuery('#sfm_menu .sfm_currentStep').removeClass('sfm_currentStep');
        jQuery('#sfm_menu .sfm_step.sfm_startStep').addClass('sfm_currentStep');
        jQuery('#sfm_menu .sfm_currentStep .sfm_stepTitle').animate({opacity: 1}, 800);

        jQuery('#sfm_menu .sfm_currentStep .sfm_item').each(function () {
            var _this = this;
            setTimeout(function () {
                jQuery(_this).addClass('sfm_show');
            }, delay);
            delay += 300;
        });

    }, 300);

}
function sfm_onResize() {

    if (!sfm_modeMobile) {
        jQuery('*:not(.ui-slider-handle)>.ui-tooltip').remove();
    }
    var height = (window.innerHeight ? window.innerHeight : document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight);
    jQuery("#sfm_menu").css({
        width: jQuery(window).width(),
        height: height
    });

    if (sfm_data.settings.animationMenu == 'slideRight' || sfm_data.settings.animationMenu == 'slideLeft') {
        jQuery('#sfm_wrapper').css({
            maxHeight: height,
            overflow: 'hidden',
            maxWidth: 9999
        });
    }

    var posTop = 0;
    var posLeft = 0;
    var posRight = 'auto';
    if (sfm_data.settings.animationMenu == 'slideRight') {
        posLeft = 'auto';
        posRight = 0;
    }
    if (sfm_panelShown) {

        jQuery("#sfm_menu").css({
            top: posTop,
            left: posLeft,
            right: posRight
        });

    } else {

        jQuery('#sfm_menu').css({
            opacity: 0,
            display: 'block'
        });

        posTop = 0 - jQuery(window).height();
        if (sfm_data.settings.animationMenu == 'slideLeft') {
            posLeft = 0 - jQuery(window).width();
            posRight = 'auto';
            posTop = 0;
        } else if (sfm_data.settings.animationMenu == 'slideRight') {
            posLeft = 'auto';
            posRight = 0 - jQuery(window).width();
            posTop = 0;
        } else if (sfm_data.settings.animationMenu == 'fade') {
            posTop = 0;
        }
        jQuery("#sfm_menu").css({
            top: posTop,
            left: posLeft,
            right: posRight
        });

    }

    jQuery('#sfm_menu .sfm_step').each(function () {
        jQuery(this).show();
        jQuery(this).find('.sfm_items').css('transition', 'none');
        jQuery(this).find('.sfm_items').css('-webkit-transition', 'none');
        jQuery(this).find('.sfm_items').addClass('sfm_prepare');
        var _self = this;
        jQuery.each(sfm_data.steps, function () {
            if (this.id == jQuery(_self).attr('data-stepid')) {
                this.height = jQuery(_self).height();
            }
        });
        if (jQuery(this).height() < jQuery(window).height()) {
            jQuery(this).css({
                top: (jQuery(window).height() / 2) - jQuery(this).height() / 2
            });
        } else {
            jQuery(this).css({
                top: 38
            });
        }
        if (!jQuery(this).is('.sfm_currentStep')) {
            jQuery(this).hide();
        }
        jQuery(this).find('.sfm_items').removeClass('sfm_prepare');

        jQuery(this).find('.sfm_items').css('transition', 'all 0.3s');
        jQuery(this).find('.sfm_items').css('-webkit-transition', 'all 0.3s');
    });
    if (!sfm_panelShown) {
        setTimeout(function () {
            jQuery('#sfm_menu').css({
                opacity: 1
            });
            jQuery('#sfm_menu').hide();
        }, 200);
    } else {
        setTimeout(function () {
            sfm_updateMenuHeight();
            sfm_onScroll();
        }, 200);

    }

}
function sfm_getStepByID(stepID) {
    var rep = false;
    jQuery.each(sfm_data.steps, function () {
        if (this.id == stepID) {
            rep = this;
        }
    });
    return rep;
}
function sfm_hasScroll() {
    if(jQuery('#sfm_menuBtn').length > 0  && sfm_data.settings.fixedBtnPosition == "topLeft" ||sfm_data.settings.fixedBtnPosition == "topRight"){
        if (jQuery('#wpadminbar').length > 0 ) {
             if(jQuery(window).width()<782){
                if (jQuery(window).scrollTop() <= 0) {
                    jQuery('#sfm_menuBtn').css('top', jQuery('#wpadminbar').height());
                } else {
                    jQuery('#sfm_menuBtn').css('top', 0);
                }
             } else {
                    jQuery('#sfm_menuBtn').css('top', jQuery('#wpadminbar').height());             
             }
        } else {
            jQuery('#sfm_menuBtn').css('top', 0);        
        }
    }
}
function sfm_onScroll(e) {
     
    if (sfm_panelShown && sfm_endScrollEnable && jQuery("#sfm_menu").length > 0) {
        if (sfm_data.settings.animationMenu == '' || sfm_data.settings.animationMenu == 'slideUp') {
            var height = (window.innerHeight ? window.innerHeight : document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight);
            var posY = 140;
            if (sfm_isTactil()) {
                posY = 382;
            }
            if(e){
                e.preventDefault();
                e.stopPropagation();
            }
            if (window.pageYOffset + height > jQuery("#sfm_menu").height() + posY) {
                sfm_hideMenu();

            }
        } else if (sfm_data.settings.animationMenu == 'slideLeft') {
            if (jQuery("#sfm_menu").width() + 80 < window.pageXOffset + jQuery(window).width()) {
                sfm_hideMenu();
            }
        }

    }
        sfm_hasScroll();
}
function sfm_sendContact() {
    var fname = '';
    var lname = '';
    var email = '';
    var phone = '';
    var city = '';
    var zip = '';
    var state = '';
    var address = '';
    var country = '';

    if (jQuery('#sfm_menu .sfm_item[data-informationtype="firstname"]').length > 0) {
        fname = jQuery('#sfm_menu .sfm_item[data-informationtype="firstname"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="lastname"]').length > 0) {
        lname = jQuery('#sfm_menu .sfm_item[data-informationtype="lastname"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="email"]').length > 0) {
        email = jQuery('#sfm_menu .sfm_item[data-informationtype="email"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="phone"]').length > 0) {
        phone = jQuery('#sfm_menu .sfm_item[data-informationtype="phone"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="city"]').length > 0) {
        city = jQuery('#sfm_menu .sfm_item[data-informationtype="city"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="zip"]').length > 0) {
        zip = jQuery('#sfm_menu .sfm_item[data-informationtype="zip"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="state"]').length > 0) {
        state = jQuery('#sfm_menu .sfm_item[data-informationtype="state"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="address"]').length > 0) {
        address = jQuery('#sfm_menu .sfm_item[data-informationtype="address"] .sfm_field').val();
    }
    if (jQuery('#sfm_menu .sfm_item[data-informationtype="country"]').length > 0) {
        country = jQuery('#sfm_menu .sfm_item[data-informationtype="country"] .sfm_field').val();
    }
    if (sfm_checkEmail(email)) {
        jQuery.ajax({
            url: sfm_data.ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_sendContact',
                fname: fname,
                lname: lname,
                email: email,
                phone: phone,
                city: city,
                zip: zip,
                state: state,
                address: address,
                country: country
            },
            success: function (rep) {

            }
        });
    }
}
function sfm_itemClicked(item) {
    jQuery('#sfm_menu .tooltip').remove();
    if (sfm_canClick) {
        var $item = jQuery(item);
        if ($item.is('[data-sendcontact="1"]')) {
            sfm_sendContact();
        }

        if ($item.is('.sfm_checked')) {
            $item.removeClass('sfm_checked');
        } else {
            $item.addClass('sfm_checked');
        }
        if ($item.attr('data-actiontype') == 'openURL') {
            sfm_hideMenu(function () {
                document.location.href = $item.attr('data-url');
            });
            
        } else if ($item.attr('data-actiontype') == 'previousStep') {  
            if(sfm_lastStep != 0){
                sfm_changeStep(sfm_lastStep);                
            } else {
                sfm_hideMenu();
            }
        } else if ($item.attr('data-actiontype') == 'nextStep') {            
            var nextStepID = sfm_findPotentialsSteps(sfm_currentStepID);
            if(nextStepID.length > 0){
                nextStepID = nextStepID[0];
            }else {
                nextStepID = 0;
            }
            sfm_changeStep(nextStepID);
            
        } else if ($item.attr('data-actiontype') == 'showElement') {
            if (document.location.href != $item.attr('data-url') && $item.attr('data-url') != "") {
                sessionStorage.sfm_showElement = $item.attr('data-domelement');
                sfm_hideMenu(function () {
                    var url = $item.attr('data-url');
                    url = url.replace('?sfm_action=selectElement','');
                    url = url.replace('&sfm_action=selectElement','');                    
                    document.location.href = url;
                });
            } else {
                sfm_hideMenu(function () {
                    sfm_showElement($item.attr('data-domelement'));
                });
            }

        } else if ($item.attr('data-actiontype') == 'executeJS') {
            if (document.location.href != $item.attr('data-url') && $item.attr('data-url') != "") {
                sessionStorage.sfm_executejs = $item.attr('data-executedjs');
                sfm_hideMenu(function () {
                    document.location.href = $item.attr('data-url');
                });
            } else {
            //    sfm_hideMenu(function () {
                    try {
                        eval($item.attr('data-executedjs') + ';');
                    } catch (e) {
                    }
             //   });
            }
        }
    }
}

function sfm_checkEmail(email) {
    if (email.indexOf("@") != "-1" && email.indexOf(".") != "-1" && email != "")
        return true;
    return false;
}
function sfm_checkPhone(phone) {
    if (phone.length < 5 || /^(?:(?:\(?(?:00|\+)([1-4]\d\d|[1-9]\d?)\)?)?[\-\.\ \\\/]?)?((?:\(?\d{1,}\)?[\-\.\ \\\/]?){0,})(?:[\-\.\ \\\/]?(?:#|ext\.?|extension|x)[\-\.\ \\\/]?(\d+))?$/i.test(phone) == false) {
        return false;
    } else {
        return true;
    }
}

function sfm_checkIfCanChange() {
    var error = false;
    jQuery('#sfm_menu .sfm_currentStep .sfm_item').removeClass('sfm_error');
    jQuery('#sfm_menu .sfm_currentStep .sfm_item').each(function () {
        if (jQuery(this).attr('data-isrequired') == '1') {
            if (jQuery(this).attr('data-informationtype') == 'email' && sfm_checkEmail(jQuery(this).find('.sfm_field').val())) {
                error = true;
                jQuery(this).addClass('sfm_error');
            } else if (jQuery(this).attr('data-informationtype') == 'phone' && sfm_checkPhone(jQuery(this).find('.sfm_field').val())) {
                error = true;
                jQuery(this).addClass('sfm_error');

            } else if (jQuery(this).find('.sfm_field').val() == "") {
                error = true;
                jQuery(this).addClass('sfm_error');
            }
            if (jQuery(this).is('[data-type="dropdown"]') && jQuery(this).find('select option:selected').is('[disabled]')) {
                error = true;
                jQuery(this).addClass('sfm_error');
            }
        }
    });
    error = !error;
    return error;
}
function sfm_changeStep(stepID) {
    if (sfm_checkIfCanChange()) {
        sfm_lastStep = sfm_currentStepID;
        if (stepID == 'final') {
            sfm_hideMenu();
        } else {
            jQuery('body,html').animate({
                scrollTop: 0
            }, 100);
            sfm_canClick = false;

            if (!sfm_modeMobile) {
                jQuery('*:not(.ui-slider-handle)> .ui-tooltip').fadeOut();
                setTimeout(function () {
                    jQuery('*:not(.ui-slider-handle)>.ui-tooltip').remove();
                }, 300);
            }
            var delay = 0;

            jQuery('#sfm_menu .sfm_currentStep  .sfm_stepTitle').animate({opacity: 0}, 800);
            var timeMax = jQuery('#sfm_menu .sfm_currentStep .sfm_item').length * 300;
            jQuery('#sfm_menu .sfm_currentStep .sfm_item').each(function () {
                var item = this;
                setTimeout(function () {
                    jQuery(item).removeClass('sfm_show');
                }, delay);
                delay += 300;
            });
            setTimeout(function () {
                sfm_currentStepID = stepID;
                setTimeout(sfm_updateMenuHeight, 500);
                jQuery('#sfm_menu .sfm_currentStep').removeClass('sfm_currentStep');
                jQuery('#sfm_menu .sfm_checked').removeClass('sfm_checked');
                jQuery('#sfm_menu .sfm_step[data-stepid="' + stepID + '"]').addClass('sfm_currentStep');
                jQuery('#sfm_menu .sfm_currentStep .sfm_item').removeClass('sfm_show');
                jQuery('#sfm_menu .sfm_currentStep').show();
                delay = 0;
                jQuery('#sfm_menu .sfm_currentStep  .sfm_stepTitle').animate({opacity: 1}, 800);
                jQuery('#sfm_menu .sfm_currentStep .sfm_item').each(function () {
                    var item = this;
                    setTimeout(function () {
                        jQuery(item).addClass('sfm_show');
                    }, delay);
                    delay += 300;
                });
                sfm_canClick = true;

            }, timeMax);
        }
    }
}
function sfm_updateMenuHeight() {
    var step = sfm_getStepByID(sfm_currentStepID);
    if (step.height > jQuery(window).height()) {
        jQuery('#sfm_menu').animate({
            height: step.height + 340
        }, 300);
        if (sfm_data.settings.animationMenu == 'slideUp') {
            jQuery('#sfm_wrapper').animate({
                top: step.height + 340
            }, 300);
        }
    } else {
        jQuery('#sfm_menu').animate({
            height: jQuery(window).height()
        }, 300);

        if (sfm_data.settings.animationMenu == 'slideUp') {
            jQuery('#sfm_wrapper').animate({
                top: jQuery(window).height()
            }, 300);
        }
    }
}


function sfm_findPotentialsSteps(originStepID) {
    var potentialSteps = new Array();
    var conditionsArray = new Array();
    var noConditionsSteps = new Array();
    var maxConditions = 0;
    jQuery.each(sfm_data.links, function () {
        var link = this;
        if (link.originID == originStepID) {
            var error = false;
            var errorOR = true;
            if (link.conditions && link.conditions != "[]") {
                link.conditionsO = JSON.parse(link.conditions);
                var errors = sfm_checkConditions(link.conditionsO);
                error = errors.error;
                errorOR = errors.errorOR;
            } else {
                noConditionsSteps.push(link.destinationID);
            }
            if ((link.operator == 'OR' && !errorOR) || (link.operator != 'OR' && !error)) {
                link.conditionsO = JSON.parse(link.conditions);
                conditionsArray.push({
                    stepID: parseInt(link.destinationID), nbConditions: link.conditionsO.length
                });
                if (link.conditionsO.length > maxConditions) {
                    maxConditions = link.conditionsO.length;
                }
                potentialSteps.push(parseInt(link.destinationID));

            }
        }
    });
    if (originStepID == 0) {
        potentialSteps.push(parseInt(jQuery('#sfm_menu .sfm_step.sfm_startStep').attr('data-stepid')));
    }
    if (potentialSteps.length == 0) {
        potentialSteps.push('final');
    } else if (noConditionsSteps.length > 0 && noConditionsSteps.length < potentialSteps.length) {
        jQuery.each(noConditionsSteps, function () {
            var removeItem = this;
            potentialSteps = jQuery.grep(potentialSteps, function (value) {
                return value != removeItem;
            });
        });
        if (maxConditions > 0) {
            jQuery.each(potentialSteps, function (stepID) {
                jQuery.each(conditionsArray, function (condition) {
                    if (condition.stepID == stepID && condition.nbConditions < maxConditions) {
                        potentialSteps = jQuery.grep(potentialSteps, function (value) {
                            return value != stepID;
                        });
                    }
                });
            });
        }
    }
    if (potentialSteps.length > 1) {
        var stepPanel = jQuery('#sfm_menu .sfm_step[data-stepid="' + potentialSteps[0] + '"]');
        if (stepPanel.length > 0 && stepPanel.find('.sfm_item').length == 0) {
            potentialSteps = sfm_findPotentialsSteps(potentialSteps[0]);
        }
    }

    return potentialSteps;
}
function sfm_dropdownChanged($item) {
    sfm_itemClicked($item.get(0));
}
function sfm_checkConditions(conditions) {
    var error = false;
    var errorOR = true;

    jQuery.each(conditions, function () {
        var condition = this;
        var $item = false;
        if (condition.interaction.substr(0, 1) != '_') {
            var stepID = condition.interaction.substr(0, condition.interaction.indexOf('_'));
            var itemID = condition.interaction.substr(condition.interaction.indexOf('_') + 1, condition.interaction.length);
            $item = jQuery('#sfm_menu [data-itemid="' + itemID + '"]');
        }
        switch (condition.action) {
            case "clicked":
                if (!$item.is('.sfm_checked')) {
                    error = true;
                }
                if ($item.is('.sfm_checked')) {
                    errorOR = false;
                }

                break;
            case "unclicked":
                if ($item.is('.sfm_checked')) {
                    error = true;
                }
                if (!$item.is('.sfm_checked')) {
                    errorOR = false;
                }
                break;
            case "isEqual":
                var value = "";
                if ($item) {
                    if ($item.is('[data-type="slider"]')) {
                        value = $item.find('.sfm_slider').slider('value');
                    } else {
                        value = $item.find('input,select').val();
                    }
                } else if (condition.interaction == "_url") {
                    value = document.location.href;
                    value = value.replace('?sfm_action=preview', '');
                    value = value.replace('&sfm_action=preview', '');
                }
                if (value != condition.value) {
                    error = true;
                } else {
                    errorOR = false;
                }
                break;
            case "isDifferent":
                var value = "";
                if ($item) {
                    if ($item.is('[data-type="slider"]')) {
                        value = $item.find('.sfm_slider').slider('value');
                    } else {
                        value = $item.find('input,select').val();
                    }
                } else if (condition.interaction == "_url") {
                    value = document.location.href;
                    value = value.replace('?sfm_action=preview', '');
                    value = value.replace('&sfm_action=preview', '');
                }
                if (value == condition.value) {
                    error = true;
                } else {
                    errorOR = false;
                }
                break;

            case "contains":
                var value = "";
                if ($item) {
                    value = $item.find('input,select').val();
                }else if (condition.interaction == "_url") {
                    value = document.location.href;
                    value = value.replace('?sfm_action=preview', '');
                    value = value.replace('&sfm_action=preview', '');
                }
                if (value.indexOf(condition.value) == -1) {
                    error = true;
                } else {
                    errorOR = false;
                }
                break;
            case "isSuperior":
                var value = "";
                if ($item) {
                    if ($item.is('[data-type="slider"]')) {
                        value = $item.find('.sfm_slider').slider('value');
                    } else {
                        value = $item.find('input,select').val();
                    }
                }
                if (value <= parseInt(condition.value)) {
                    error = true;
                }
                if (value > parseInt(condition.value)) {
                    errorOR = false;
                }
                break;
            case "isInferior":
                var value = "";
                if ($item) {
                    if ($item.is('[data-type="slider"]')) {
                        value = $item.find('.sfm_slider').slider('value');
                    } else {
                        value = $item.find('input,select').val();
                    }
                }
                if (value >= parseInt(condition.value)) {
                    error = true;
                }
                if (value < parseInt(condition.value)) {
                    errorOR = false;
                }
                break;
        }
    });

    return {
        error: error,
        errorOR: errorOR
    };
}