var sfm_isLinking = false;
var sfm_links = new Array();
var sfm_linkCurrentIndex = -1;
var sfm_canvasTimer;
var sfm_mouseX, sfm_mouseY;
var sfm_linkGradientIndex = 1;
var sfm_itemWinTimer;
var sfm_currentDomElement = false;
var sfm_currentStep = false;
var sfm_currentStepID = 0;
var sfm_lock = false;
var sfm_defaultStep = false;
var sfm_steps = false;
var sfm_params;
var sfm_currentLinkIndex = 0;
var sfm_settings;
var sfm_formfield;
var sfm_actTimer;
var sfm_currentItemID = 0;
var sfm_canSaveLink = true;
var sfm_editorItemJS;
var sfm_editorCustomCSS;

sfm_data = sfm_data[0];
jQuery(document).ready(function () {
    jQuery('#sfm_loader').remove();
    jQuery('#wpcontent').append('<div id="sfm_loader"><div class="sfm_spinner"><div class="double-bounce1"></div><div class="double-bounce2"></div></div></div>');
    jQuery('#sfm_loader .sfm_spinner').css({
        top: jQuery(window).height() / 2 - jQuery('#wpadminbar').height() / 2
    });
    jQuery(window).resize(function () {
        jQuery('#sfm_loader .sfm_spinner').css({
            top: jQuery(window).height() / 2 - jQuery('#wpadminbar').height() / 2
        });
        jQuery('#sfm_bootstraped').css({
            minHeight: jQuery('#wpcontent').height()
        });

    });
    jQuery('#sfm_bootstraped').css({
        minHeight: jQuery('#wpcontent').height()
    });
    jQuery('#sfm_stepsContainer').droppable({
        drop: function (event, ui) {
            var $object = jQuery(ui.draggable[0]);
            jQuery.ajax({
                url: ajaxurl,
                type: 'post',
                data: {
                    action: 'sfm_saveStepPosition',
                    stepID: $object.attr('data-stepid'),
                    posX: parseInt($object.css('left')),
                    posY: parseInt($object.css('top'))
                }
            });
        }
    });
   // jQuery("#sfm_bootstraped [data-toggle='switch']").bootstrapSwitch();
    jQuery('.imageBtn').click(function () {
        sfm_formfield = jQuery(this).prev('input');
        tb_show('', 'media-upload.php?TB_iframe=true');
        return false;
    });
    window.old_tb_remove = window.tb_remove;
    window.tb_remove = function () {
        window.old_tb_remove();
        sfm_formfield = null;
    };
    window.original_send_to_editor = window.send_to_editor;
    window.send_to_editor = function (html) {
        if (sfm_formfield) {
            var alt = jQuery('img', html).attr('alt');
            var fileurl = jQuery('img', html).attr('src');
            if (jQuery('img', html).length == 0) {
                fileurl = jQuery(html).attr('src');
                alt = jQuery(html).attr('alt');
            }
            sfm_formfield.val(fileurl);
            sfm_formfield.trigger('keyup');
            tb_remove();
        } else {
            window.original_send_to_editor(html);
        }
    };

    sfm_canvasTimer = setInterval(sfm_updateStepCanvas, 30);
    jQuery(document).mousemove(function (e) {
        if (sfm_isLinking) {
            sfm_mouseX = e.pageX - jQuery('#sfm_stepsContainer').offset().left;
            sfm_mouseY = e.pageY - jQuery('#sfm_stepsContainer').offset().top;
        }
    });
    jQuery(window).resize(sfm_updateStepsDesign);
    sfm_itemWinTimer = setInterval(sfm_updateWinItemPosition, 30);

    if (jQuery('#sfm_winActivation').is('[data-show="true"]') && document.referrer.indexOf('admin.php?page=sfm_menu') < 0) {
        jQuery('#sfm_winActivation .modal-dialog').hover(function () {
            jQuery(this).addClass('sfm_hover');
        }, function () {
            jQuery(this).removeClass('sfm_hover');
        });
        sfm_lock = true;
        jQuery('#sfm_closeWinActivationBtn').click(function () {
            if (!sfm_lock) {
                jQuery('#sfm_winActivation').modal('hide');
            }
        });
        jQuery('#sfm_closeWinActivationBtn .sfm_text').data('num', 10).html('Wait 10 seconds');
        sfm_actTimer = setInterval(function () {
            var num = jQuery('#sfm_closeWinActivationBtn .sfm_text').data('num');
            num--;
            if (num > 0) {
                jQuery('#sfm_closeWinActivationBtn .sfm_text').data('num', num).html('Wait ' + num + ' seconds');
            } else {
                jQuery('#sfm_closeWinActivationBtn').removeClass('disabled');
                sfm_lock = false;
                jQuery('#sfm_closeWinActivationBtn .sfm_text').data('num', '').html('Close');
            }
        }, 1000);
    } else {
        jQuery('#sfm_winActivation').attr('data-show', 'false');
    }
    jQuery('#sfm_winActivation').on('hide.bs.modal', function (e) {
        if (sfm_lock && !jQuery('#sfm_winActivation .modal-dialog').is('.sfm_hover')) {
            e.preventDefault();
        }
    });
    jQuery(document).mousedown(function (e) {
        if (e.button == 2 && sfm_isLinking) {
            sfm_isLinking = false;
        }
    });
    jQuery('.form-group').each(function () {
        var self = this;
        if (jQuery(self).find('small').length > 0 && jQuery(self).find('.form-control').length > 0) {
            jQuery(this).find('.form-control').tooltip({
                title: jQuery(self).find('small').html()
            });
        }
    });
    jQuery("#sfm_bootstraped [data-toggle='switch']").bootstrapSwitch();
    jQuery('#sfm_bootstraped').find('input[type="checkbox"]').each(function () {
        if (jQuery(this).is('[data-toggle="switch"]')) {
            if (jQuery(this).closest('.form-group').find('small').length > 0) {
                jQuery(this).closest('.bootstrap-switch-wrapper').tooltip({
                    title: jQuery(this).closest('.form-group').find('small').html()
                });
            }
        }
    });
    jQuery('.imageBtn').click(function () {
        sfm_formfield = jQuery(this).prev('input');
        tb_show('', 'media-upload.php?TB_iframe=true');
        return false;
    });
    jQuery('#sfm_winItem [name="actionType"]').on('change', function () {
        if (jQuery('#sfm_winItem [name="actionType"]').val() == 'openURL') {
            jQuery('#sfm_winItem [name="url"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="domElement"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="executedJS"]').closest('.form-group').slideUp();
        } else if (jQuery('#sfm_winItem [name="actionType"]').val() == 'showElement') {
            jQuery('#sfm_winItem [name="domElement"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="url"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="executedJS"]').closest('.form-group').slideUp();

        } else if (jQuery('#sfm_winItem [name="actionType"]').val() == 'executeJS') {
            jQuery('#sfm_winItem [name="url"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="domElement"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="executedJS"]').closest('.form-group').slideDown();

        } else {
            jQuery('#sfm_winItem [name="url"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="domElement"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="executedJS"]').closest('.form-group').slideUp();
        }
    });
    jQuery('#sfm_winItem [name="type"]').on('change', function () {
        if (jQuery('#sfm_winItem [name="type"]').val() == 'image') {
            jQuery('#sfm_winItem [name="image"]').closest('.form-group').slideDown();
        } else {
            jQuery('#sfm_winItem [name="image"]').closest('.form-group').slideUp();
        }
        if (jQuery('#sfm_winItem [name="type"]').val() == 'dropdown') {
            jQuery('#sfm_winItem #sfm_itemOptionsValuesPanel').slideDown();
        } else {
            jQuery('#sfm_winItem #sfm_itemOptionsValuesPanel').slideUp();
        }
        if (jQuery('#sfm_winItem [name="type"]').val() == 'slider' || jQuery('#sfm_winItem [name="type"]').val() == 'numberfield') {
            jQuery('#sfm_winItem [name="valueMin"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="valueMax"]').closest('.form-group').slideDown();
        } else {
            jQuery('#sfm_winItem [name="valueMin"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="valueMax"]').closest('.form-group').slideUp();
        }
        if (jQuery('#sfm_winItem [name="type"]').val() == 'textfield') {
            jQuery('#sfm_winItem [name="informationType"]').closest('.form-group').slideDown();
        } else {
            jQuery('#sfm_winItem [name="informationType"]').closest('.form-group').slideUp();
        }

        if (jQuery('#sfm_winItem [name="type"]').val() == 'dropdown' || jQuery('#sfm_winItem [name="type"]').val() == 'textfield') {
            jQuery('#sfm_winItem [name="placeholder"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="isRequired"]').closest('.form-group').slideDown();
        } else {
            jQuery('#sfm_winItem [name="placeholder"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="isRequired"]').closest('.form-group').slideUp();
        }
        if (jQuery('#sfm_winItem [name="type"]').val() == 'richtext') {
            jQuery('#sfm_itemRichText').closest('.col-md-12').slideDown();
        } else {
            jQuery('#sfm_itemRichText').closest('.col-md-12').slideUp();
        }
        if (jQuery('#sfm_winItem [name="type"]').val() == 'shortcode') {
            jQuery('#sfm_winItem [name="shortcode"]').closest('.form-group').slideDown();
        } else {
            jQuery('#sfm_winItem [name="shortcode"]').closest('.form-group').slideUp();
        }
        if (jQuery('#sfm_winItem [name="type"]').val() == 'title' || jQuery('#sfm_winItem [name="type"]').val() == 'richtext' || jQuery('#sfm_winItem [name="type"]').val() == 'shortcode') {
            jQuery('#sfm_winItem [name="layout"]').val('fullRow');
            jQuery('#sfm_winItem [name="layout"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="actionType"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideUp();
            jQuery('#sfm_winItem [name="showTitle"]').closest('.form-group').slideUp();  

        } else {
            jQuery('#sfm_winItem [name="layout"]').closest('.form-group').slideDown();
            jQuery('#sfm_winItem [name="showTitle"]').closest('.form-group').slideDown();  
            jQuery('#sfm_winItem [name="actionType"]').closest('.form-group').slideDown();
            if (jQuery('#sfm_winItem [name="sendContactToMailChimp"]').bootstrapSwitch('state') || jQuery('#sfm_settingsPanel [name="sendContactToGetResponse"]').bootstrapSwitch('state')) {
                jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideDown();
            } else {
                jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideUp();
            }
        }
    });
    jQuery('#sfm_settingsPanel [name="integrationType"]').on('change', function () {
        if (jQuery('#sfm_settingsPanel [name="integrationType"]').val() == 'fixedButton') {
            jQuery('#sfm_settingsPanel [name="fixedBtnPosition"]').closest('.form-group').slideDown();
            jQuery('#sfm_settingsPanel [name="domElement"]').closest('.form-group').slideUp();
            jQuery('#sfm_settingsPanel [name="color_menuBtn_bg"]').closest('.form-group').slideDown();
            jQuery('#sfm_settingsPanel [name="color_menuBtn_icon"]').closest('.form-group').slideDown();
        } else {
            jQuery('#sfm_settingsPanel [name="fixedBtnPosition"]').closest('.form-group').slideUp();
            jQuery('#sfm_settingsPanel [name="domElement"]').closest('.form-group').slideDown();
            jQuery('#sfm_settingsPanel [name="color_menuBtn_bg"]').closest('.form-group').slideUp();
            jQuery('#sfm_settingsPanel [name="color_menuBtn_icon"]').closest('.form-group').slideUp();
        }
    });

    jQuery('#sfm_settingsPanel input[name="sendContactToMailChimp"]').bootstrapSwitch('onSwitchChange', sfm_changeMailchimp);

    jQuery('#sfm_settingsPanel input[name="sendContactToGetResponse"]').bootstrapSwitch('onSwitchChange', sfm_changeGetResponse);

    jQuery('.sfm_iconslist li a').click(function () {
        jQuery(this).closest('.form-group').find('.btn.dropdown-toggle>span.sfm_name').html(jQuery(this).attr('data-icon'));
        jQuery(this).closest('.form-group').find('input.sfm_iconField').val(jQuery(this).attr('data-icon'));
        jQuery(this).closest('ul').find('li.sfm_active').removeClass('sfm_active');
        jQuery(this).closest('li').addClass('sfm_active');
    });
    jQuery('input.sfm_iconField').on('change', function () {
        if (jQuery(this).closest('.form-group').find('.btn.dropdown-toggle>span.sfm_name').html() != jQuery(this).val()) {
            jQuery(this).closest('.form-group').find('.btn.dropdown-toggle>span.sfm_name').html(jQuery(this).val());
        }
    });

    sfm_editorItemJS = CodeMirror.fromTextArea(jQuery('#sfm_winItem textarea[name="executedJS"]').get(0), {
        mode: "javascript"
    });
    sfm_editorCustomCSS = CodeMirror.fromTextArea(jQuery('#sfm_settingsPanel textarea[name="customCSS"]').get(0), {
        mode: "css"
    });


    jQuery('#sfm_itemRichText').summernote({
        height: 300,
        minHeight: null,
        maxHeight: null,
    });

    jQuery('#sfm_settingsPanel [name="getResponseKey"]').focusout(sfm_changeGetResponseList);
    jQuery('#sfm_settingsPanel [name="mailchimpKey"]').focusout(sfm_changeMailchimpList);
    sfm_changeGetResponseList();
    sfm_changeMailchimpList();

    jQuery('[data-toggle="tooltip"]').tooltip();
    sfm_loadSettings();
});


function sfm_changeMailchimp() {
    if (jQuery('#sfm_settingsPanel [name="sendContactToMailChimp"]').bootstrapSwitch('state')) {
        jQuery('#sfm_settingsPanel [name="mailchimpKey"]').closest('.form-group').slideDown();
        jQuery('#sfm_settingsPanel [name="mailchimpList"]').closest('.form-group').slideDown();
        jQuery('#sfm_settingsPanel [name="mailchimpOptin"]').closest('.form-group').slideDown();
        jQuery('#sfm_settingsPanel [name="mailchimpOptin"]').closest('.form-group').slideDown();

        sfm_changeMailchimpList();
    } else {
        jQuery('#sfm_settingsPanel [name="mailchimpKey"]').closest('.form-group').slideUp();
        jQuery('#sfm_settingsPanel [name="mailchimpList"]').closest('.form-group').slideUp();
        jQuery('#sfm_settingsPanel [name="mailchimpOptin"]').closest('.form-group').slideUp();
    }

    if (jQuery('#sfm_settingsPanel [name="sendContactToMailChimp"]').bootstrapSwitch('state') || jQuery('#sfm_settingsPanel [name="sendContactToGetResponse"]').bootstrapSwitch('state')) {

        jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideDown();
        jQuery('#sfm_alertInfosGetResponse').slideDown();
    } else {
        jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideUp();
        jQuery('#sfm_alertInfosGetResponse').slideUp();
    }
}
function sfm_changeGetResponse() {
    if (jQuery('#sfm_settingsPanel [name="sendContactToGetResponse"]').bootstrapSwitch('state')) {
        jQuery('#sfm_settingsPanel [name="getResponseKey"]').closest('.form-group').slideDown();
        jQuery('#sfm_settingsPanel [name="getResponseList"]').closest('.form-group').slideDown();
        sfm_changeGetResponseList();
    } else {
        jQuery('#sfm_settingsPanel [name="getResponseKey"]').closest('.form-group').slideUp();
        jQuery('#sfm_settingsPanel [name="getResponseList"]').closest('.form-group').slideUp();
    }

    if (jQuery('#sfm_settingsPanel [name="sendContactToMailChimp"]').bootstrapSwitch('state') || jQuery('#sfm_settingsPanel [name="sendContactToGetResponse"]').bootstrapSwitch('state')) {

        jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideDown();
        jQuery('#sfm_alertInfosGetResponse').slideDown();
    } else {
        jQuery('#sfm_winItem [name="sendContactOnChange"]').closest('.form-group').slideUp();
        jQuery('#sfm_alertInfosGetResponse').slideUp();
    }
}
function sfm_changeMailchimpList() {
    jQuery('#sfm_settingsPanel [name="mailchimpList"] option').remove();
    var apiKey = jQuery('#sfm_settingsPanel [name="mailchimpKey"]').val();
    if (apiKey != "") {
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_getMailchimpLists',
                apiKey: apiKey
            },
            success: function (rep) {
                jQuery('#sfm_settingsPanel [name="mailchimpList"]').html(rep);
                if (jQuery('#sfm_settingsPanel [name="mailchimpList"] option[value="' + jQuery('#sfm_settingsPanel [name="mailchimpList"]').attr('data-initial') + '"]').length > 0) {
                    jQuery('#sfm_settingsPanel [name="mailchimpList"]').val(jQuery('#sfm_settingsPanel [name="mailchimpList"]').attr('data-initial'));
                }
                if (sfm_settings) {
                    jQuery('#sfm_settingsPanel [name="mailchimpList"]').val(sfm_settings.mailchimpList);
                }
            }
        });
    }
}
function sfm_changeGetResponseList() {
    jQuery('#sfm_tabSettings [name="getResponseList"] option').remove();
    var apiKey = jQuery('#sfm_settingsPanel [name="getResponseKey"]').val();
    if (apiKey != "") {
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_getGetResponseLists',
                apiKey: apiKey
            },
            success: function (rep) {
                jQuery('#sfm_settingsPanel [name="getResponseList"]').html(rep);
                if (jQuery('#sfm_settingsPanel [name="getResponseList"] option[value="' + jQuery('#sfm_settingsPanel [name="getResponseList"]').attr('data-initial') + '"]').length > 0) {
                    jQuery('#sfm_settingsPanel [name="getResponseList"]').val(jQuery('#sfm_settingsPanel [name="getResponseList"]').attr('data-initial'));
                }
                if (sfm_settings) {
                    jQuery('#sfm_settingsPanel [name="getResponseList"]').val(sfm_settings.getResponseList);
                }
            }
        });
    }
}

function sfm_getStepByID(stepID) {
    var rep = false;
    jQuery.each(sfm_steps, function (i) {
        if (this.id == stepID) {
            rep = this;
        }
    });
    return rep;
}
function sfm_showLoader() {
    jQuery('body').animate({scrollTop: 0}, 250);
    jQuery('#sfm_loader').fadeIn();
}
function sfm_checkEmail(email) {
    if (email.indexOf("@") != "-1" && email.indexOf(".") != "-1" && email != "")
        return true;
    return false;
}
function sfm_addStep(step) {
    var title = '';
    var startStep = 0;
    if (!step.content) {
        title = step;
    } else {
        title = step.title;
    }
    if (title.length > 49) {
        title = title.substr(0, 46) + '...';
    }
    var newStep = jQuery('<div class="sfm_stepBloc palette palette-clouds"><div class="sfm_stepBlocWrapper"><h4>' + title + '</h4></div>' +
            '<a href="javascript:" class="sfm_btnEdit" title="' + sfm_data.texts['tip_editStep'] + '"><span class="glyphicon glyphicon-pencil"></span></a>' +
            '<a href="javascript:" class="sfm_btnSup" title="' + sfm_data.texts['tip_delStep'] + '"><span class="glyphicon glyphicon-trash"></span></a>' +
            '<a href="javascript:" class="sfm_btnDup" title="' + sfm_data.texts['tip_duplicateStep'] + '"><span class="glyphicon glyphicon-duplicate"></span></a>' +
            '<a href="javascript:" class="sfm_btnLink" title="' + sfm_data.texts['tip_linkStep'] + '"><span class="glyphicon glyphicon-link"></span></a>' +
            '<a href="javascript:" class="sfm_btnStart" title="' + sfm_data.texts['tip_flagStep'] + '"><span class="glyphicon glyphicon-flag"></span></a></div>');
    if (step.content && step.content.start == 1) {
        newStep.find('.sfm_btnStart').addClass('sfm_selected');
        newStep.addClass('sfm_selected');
    }
    if (step.elementID) {
        newStep.attr('id', step.elementID);

    } else {
        newStep.uniqueId();
    }

    newStep.children('a.sfm_btnEdit').click(function () {
        sfm_openWinStep(jQuery(this).parent().attr('data-stepid'));
    });
    newStep.children('a.sfm_btnLink').click(function () {
        sfm_startLink(jQuery(this).parent().attr('id'));
    });
    newStep.children('a.sfm_btnSup').click(function () {
        sfm_removeStep(jQuery(this).parent().attr('data-stepid'));
    });
    newStep.children('a.sfm_btnDup').click(function () {
        sfm_duplicateStep(jQuery(this).parent().attr('data-stepid'));
    });
    newStep.children('a.sfm_btnStart').click(function () {
        sfm_showLoader();
        jQuery('.sfm_stepBloc[data-stepid]').find('.sfm_btnStart').removeClass('sfm_selected');
        jQuery('.sfm_stepBloc[data-stepid]').find('.sfm_btnStart').closest('.sfm_stepBloc').removeClass('sfm_selected');
        jQuery.each(sfm_steps, function () {
            var step = this;
            if (step.id != jQuery(this).parent().attr('data-stepid') && step.start == 1) {
                step.content.start = 0;
                jQuery.ajax({
                    url: ajaxurl,
                    type: 'post',
                    data: {
                        action: 'sfm_saveStep',
                        id: step.id,
                        start: 0,
                        content: JSON.stringify(step.content)
                    }
                });
            }
        });

        jQuery(this).addClass('sfm_selected');
        jQuery(this).closest('.sfm_stepBloc').addClass('sfm_selected');
        var currentStep = sfm_getStepByID(jQuery(this).parent().attr('data-stepid'));
        currentStep.content.start = 1;
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_saveStep',
                id: step.id,
                start: 1,
                content: JSON.stringify(currentStep.content)
            },
            success: function () {
                sfm_loadSettings();
            }
        });
    });


    newStep.draggable({
        containment: "parent",
        handle: ".sfm_stepBlocWrapper"
    });
    newStep.children('.sfm_stepBlocWrapper').click(function () {
        if (sfm_isLinking) {
            sfm_stopLink(newStep);
        }
    });
    var posX = 10, posY = 10;
    if (step.content && step.content.previewPosX) {
        posX = step.content.previewPosX;
        posY = step.content.previewPosY;
    } else {
        posX = jQuery('#sfm_stepsOverflow').scrollLeft() + jQuery('#sfm_stepsOverflow').width() / 2 - 64;
        posY = jQuery('#sfm_stepsOverflow').scrollTop() + jQuery('#sfm_stepsOverflow').height() / 2 - 64;
    }
    newStep.hide();
    jQuery('#sfm_stepsContainer').append(newStep);
    newStep.css({
        left: (posX) + 'px',
        top: posY + 'px'
    });

    newStep.fadeIn();
    setTimeout(sfm_updateStepsDesign, 250);

    jQuery('.sfm_btnWinClose').parent().click(function () {
        sfm_closeWin(jQuery(this).parents('.sfm_window'));
    });
    if (jQuery('#sfm_stepsContainer .sfm_stepBloc').length == 0) {
        startStep = 1;
    }
    if (step.id) {
        newStep.attr('data-stepid', step.id);
    } else {
        var title = '';
        if (step.content && step.content.title) {
            title = step.content.title;
        }
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_addStep',
                elementID: newStep.attr('id'),
                previewPosX: posX,
                previewPosY: posY,
                start: startStep,
                title: title
            },
            success: function (step) {
                step = jQuery.parseJSON(step);
                newStep.attr('data-stepid', step.id);
                if (step.start == 1) {
                    newStep.find('.sfm_btnStart').addClass('sfm_selected');
                    newStep.addClass('sfm_selected');
                }
                sfm_steps.push({
                    content: step
                });
            }
        });
    }
}

function sfm_showShortcodeWin() {
    jQuery('#sfm_winShortcode').modal('show');
}
function sfm_saveStep() {
    sfm_showLoader();
    var stepData = {};
    jQuery('#sfm_stepTabGeneral').find('input,select,textarea').each(function () {
        if (!jQuery(this).is('[data-toggle="switch"]')) {
            if (jQuery(this).attr('name') != "sfm_answer") {
                eval('stepData.' + jQuery(this).attr('name') + ' = jQuery(this).val();');
            }
        } else {
            var value = 0;
            if (jQuery(this).is(':checked')) {
                value = 1;
            }
            eval('stepData.' + jQuery(this).attr('name') + ' = value;');
        }
    });
    stepData.action = 'sfm_saveStep';
    stepData.id = sfm_currentStepID;
    stepData.description = jQuery('#sfm_stepDescription').code();
    var itemsList = '';
    jQuery('#sfm_itemsTable tbody tr[data-itemid] td input[name="sfm_answer"]').each(function () {
        itemsList += jQuery(this).val() + '°' + jQuery(this).closest('tr').attr('data-itemid') + '|';
    });
    if (itemsList.length > 0) {
        itemsList = itemsList.substr(0, itemsList.length - 1);
    }
    stepData.itemsList = itemsList;
    jQuery('.sfm_stepBloc[data-stepid="' + sfm_currentStepID + '"] h4').html(stepData.title);
    sfm_updateStepsDesign();

    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: stepData,
        success: function (stepID) {
            sfm_loadSettings();
          //  sfm_closeWin(jQuery('#sfm_winStep'));
        }
    });
}

function sfm_removeStep(stepID) {
    var i = 0;

    jQuery('.sfm_stepBloc[data-stepid="' + stepID + '"]').remove();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {
            action: 'sfm_removeStep',
            stepID: stepID
        },
        success: function () {
        }
    });
}
function sfm_updateStepsDesign() {
    jQuery('#sfm_stepsCanvas').attr('width', jQuery('#sfm_stepsContainer').outerWidth());
    jQuery('#sfm_stepsCanvas').attr('height', jQuery('#sfm_stepsContainer').outerHeight());
    jQuery('#sfm_stepsCanvas').css({
        width: jQuery('#sfm_stepsContainer').outerWidth(),
        height: jQuery('#sfm_stepsContainer').outerHeight()
    });
    jQuery('.sfm_stepBloc > .sfm_stepBlocWrapper > h4').each(function () {
        jQuery(this).css('margin-top', 0 - jQuery(this).height() / 2);
    });
}

function sfm_repositionLinkPoint(linkIndex) {
    var link = sfm_links[linkIndex];
    var originLeft = (jQuery('#' + link.originID).offset().left - jQuery('#sfm_stepsContainer').offset().left) + jQuery('#' + link.originID).width() / 2;
    var originTop = (jQuery('#' + link.originID).offset().top - jQuery('#sfm_stepsContainer').offset().top) + jQuery('#' + link.originID).height() / 2;
    var destinationLeft = (jQuery('#' + link.destinationID).offset().left - jQuery('#sfm_stepsContainer').offset().left) + jQuery('#' + link.destinationID).width() / 2;
    var destinationTop = (jQuery('#' + link.destinationID).offset().top - jQuery('#sfm_stepsContainer').offset().top) + jQuery('#' + link.destinationID).height() / 2;
    var posX = originLeft + (destinationLeft - originLeft) / 2;
    var posY = originTop + (destinationTop - originTop) / 2;

    jQuery.each(sfm_links, function (i) {
        if (this.originID == link.destinationID && this.destinationID == link.originID && i < linkIndex) {
            posX += 15;
            posY += 15;
        }
    });
    jQuery('.sfm_linkPoint[data-linkindex="' + linkIndex + '"]').css({
        left: posX + 'px',
        top: posY + 'px'
    });
}

function sfm_duplicateStep(stepID) {
    sfm_showLoader();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {
            action: 'sfm_duplicateStep',
            stepID: stepID
        },
        success: function (newStepID) {
            sfm_loadSettings();
        }
    });
}

function sfm_updateStepCanvas() {
    sfm_linkGradientIndex++;
    if (sfm_linkGradientIndex >= 30) {
        sfm_linkGradientIndex = 1;
    }
    var ctx = jQuery('#sfm_stepsCanvas').get(0).getContext('2d');
    ctx.clearRect(0, 0, jQuery('#sfm_stepsCanvas').attr('width'), jQuery('#sfm_stepsCanvas').attr('height'));
    jQuery.each(sfm_links, function (index) {
        var link = this;
        if (link.destinationID && jQuery('#' + link.originID).length > 0 && jQuery('#' + link.destinationID).length > 0) {
            var posX = parseInt(jQuery('#' + link.originID).css('left')) + jQuery('#' + link.originID).outerWidth() / 2 + 22;
            var posY = parseInt(jQuery('#' + link.originID).css('top')) + jQuery('#' + link.originID).outerHeight() / 2 + 22;
            var posX2 = parseInt(jQuery('#' + link.destinationID).css('left')) + jQuery('#' + link.destinationID).outerWidth() / 2 + 22;
            var posY2 = parseInt(jQuery('#' + link.destinationID).css('top')) + jQuery('#' + link.destinationID).outerHeight() / 2 + 22;
            var grd = ctx.createLinearGradient(posX, posY, posX2, posY2);

            var chkBack = false;
            var sfm_linkGradientIndexA = sfm_linkGradientIndex / 30;
            var gradPos1 = sfm_linkGradientIndexA;
            var gradPos2 = sfm_linkGradientIndexA + 0.1;
            var gradPos3 = sfm_linkGradientIndexA + 0.2;
            ctx.lineWidth = 4;
            if (gradPos2 > 1) {
                gradPos2 = 0;
                gradPos3 = 0.2;
            }
            if (gradPos3 > 1) {
                gradPos3 = 0;
            }

            grd.addColorStop(gradPos1, "#bdc3c7");
            grd.addColorStop(gradPos2, "#1ABC9C");
            grd.addColorStop(gradPos3, "#bdc3c7");
            ctx.strokeStyle = grd;
            ctx.beginPath();
            ctx.moveTo(posX, posY);
            ctx.lineTo(posX2, posY2);
            ctx.stroke();

            if (jQuery('.sfm_linkPoint[data-linkindex="' + index + '"]').length == 0) {
                var $point = jQuery('<a href="javascript:" data-linkindex="' + index + '" class="sfm_linkPoint"><span class="glyphicon glyphicon-pencil"></span></a>');
                jQuery('#sfm_stepsContainer').append($point);
                $point.click(function () {
                    sfm_openWinLink(jQuery(this));
                });
            }
            sfm_repositionLinkPoint(index);

        } else {
            jQuery('.sfm_linkPoint[data-linkindex="' + index + '"]').remove();
        }
    });
    if (sfm_isLinking) {
        var step = jQuery('#' + sfm_links[sfm_linkCurrentIndex].originID);
        var posX = step.position().left + jQuery('#sfm_stepsOverflow').scrollLeft() + step.outerWidth() / 2;
        var posY = step.position().top + jQuery('#sfm_stepsOverflow').scrollTop() + step.outerHeight() / 2;
        ctx.strokeStyle = "#bdc3c7";
        ctx.lineWidth = 4;
        ctx.beginPath();
        ctx.moveTo(posX, posY);
        ctx.lineTo(sfm_mouseX, sfm_mouseY);
        ctx.stroke();
    }
}
function sfm_removeItem(itemID) {
    jQuery('#sfm_itemsTable tbody tr[data-itemid="' + itemID + '"] td input[name="sfm_answer"]').closest('tr').remove();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {
            action: 'sfm_removeItem',
            itemID: itemID,
            stepID: sfm_currentStepID
        },
        success: function () {

        }
    });
}
function sfm_editItem(itemID) {
    sfm_currentItemID = itemID;
    jQuery('#sfm_winItem').find('input,textarea').val('');
    jQuery('#sfm_winItem').find('select option').removeAttr('selected');
    jQuery('#sfm_winItem').find('select option:eq(0)').attr('selected', 'selected');
    jQuery('#sfm_winItem').find('#sfm_itemOptionsValues tbody tr').not('.static').remove();
    if (itemID > 0) {
        jQuery.each(sfm_currentStep.items, function () {
            var item = this;
            if (item.id == itemID) {
                jQuery('#sfm_winItem').find('input,select,textarea').each(function () {
                    if (jQuery(this).is('[data-toggle="switch"]')) {
                        var value = false;
                        eval('if(item.' + jQuery(this).attr('name') + ' == 1 ){jQuery(this).bootstrapSwitch("state", true);}');
                        eval('if(item.' + jQuery(this).attr('name') + ' == 0){jQuery(this).bootstrapSwitch("state", false);}');

                    } else {
                        eval('jQuery(this).val(item.' + jQuery(this).attr('name') + ');');
                    }

                });

                var optionsV = item.optionsValues.split('|');
                jQuery.each(optionsV, function () {
                    var value = this;
                    if (this != "") {
                        jQuery('#sfm_itemOptionsValues #option_new_value').closest('tr').before('<tr><td>' + value + '</td><td><a href="javascript:" onclick="sfm_edit_option(this);" class="btn btn-default  btn-circle "><span class="glyphicon glyphicon-pencil"></span></a><a href="javascript:" onclick="sfm_del_option(this);" class="btn btn-danger  btn-circle "><span class="glyphicon glyphicon-trash"></span></a></td></tr>');
                    }
                });
                jQuery('#sfm_itemOptionsValues tbody').sortable({
                    items: "tr:not(.static)",
                    helper: function (e, tr) {
                        var $originals = tr.children();
                        var $helper = tr.clone();
                        $helper.children().each(function (index)
                        {
                            jQuery(this).width($originals.eq(index).width());
                        });
                        return $helper;
                    }
                });

                jQuery('#sfm_winItem #sfm_itemRichText').code(this.richtext);
                sfm_editorItemJS.setValue(this.executedJS);
                setTimeout(function () {
                    sfm_editorItemJS.refresh();
                }, 100);

                jQuery('#sfm_bootstraped').css({
                    minHeight: jQuery('#wpcontent').height()
                });
            }
        });
    } else {
      //  jQuery('#sfm_winItem').find('[data-toggle="switch"]').wrap('<div class="switch" data-on-label="' + sfm_data.texts['Yes'] + '" data-off-label="' + sfm_data.texts['No'] + '" />').parent().bootstrapSwitch({onLabel: sfm_data.texts['Yes'], offLabel: sfm_data.texts['No']});
        jQuery('#sfm_winItem [name="valueMin"]').val(0);
        jQuery('#sfm_winItem [name="valueMax"]').val(15);
        jQuery('#sfm_winItem [name="showTitle"]').bootstrapSwitch("state", true);
        jQuery('#sfm_winItem [name="type"]').val("image");
        jQuery('#sfm_winItem [name="actionType"]').val("");
        jQuery('#sfm_winItem [name="layout"]').val("inline");
        jQuery('#sfm_winItem [name="title"]').val("");
        
    }

    jQuery('#sfm_winItem').find('input[type="checkbox"]').each(function () {
        if (jQuery(this).is('[data-toggle="switch"]')) {
            if (jQuery(this).closest('.form-group').find('small').length > 0) {
                jQuery(this).closest('.bootstrap-switch-wrapper').tooltip({
                    title: jQuery(this).closest('.form-group').find('small').html()
                });
            }
        }
    });

    jQuery('#sfm_winItem [name="actionType"]').trigger('change');
    jQuery('#sfm_winItem [name="type"]').trigger('change');

    jQuery('#sfm_winItem').fadeIn();
    jQuery('#sfm_winStep').fadeOut();

    jQuery('html,body').scrollTop(0);
}

function sfm_saveItem() {
    var error = false;
    jQuery('#sfm_winItem').find('input[name="title"]').parent().removeClass('has-error');
    jQuery('#sfm_winItem').find('input[name="url"]').parent().removeClass('has-error');

    if (jQuery('#sfm_winItem').find('input[name="title"]').val() < 1) {
        error = true;
        jQuery('#sfm_winItem').find('input[name="title"]').parent().addClass('has-error');
    }
    if (jQuery('#sfm_winItem').find('input[name="actionType"]').val() == 'openURL' && jQuery('#sfm_winItem').find('input[name="url"]').val().indexOf('http') != 0) {
        error = true;
        jQuery('#sfm_winItem').find('input[name="url"]').parent().addClass('has-error');
    }

    var itemData = {};
    jQuery('#sfm_winItem').find('input,select,textarea').each(function () {
        if (!jQuery(this).is('[data-toggle="switch"]')) {
            eval('itemData.' + jQuery(this).attr('name') + ' = jQuery(this).val();');
        } else {
            var value = 0;
            if (jQuery(this).is(':checked')) {
                value = 1;
            }
            eval('itemData.' + jQuery(this).attr('name') + ' = value;');
        }

    });
    itemData.action = 'sfm_saveItem';
    itemData.stepID = sfm_currentStepID;
    itemData.id = sfm_currentItemID;

    if (jQuery('#sfm_itemRichText').next('.note-editor').find('.note-toolbar .note-view [data-name="codeview"]').is('.active')) {
        jQuery('#sfm_itemRichText').next('.note-editor').find('.note-toolbar .note-view [data-name="codeview"]').trigger('click');
    }
    itemData.richtext = jQuery('#sfm_itemRichText').code();
    optionsValues = '';
    var optionStab = sfm_getOptions();
    jQuery.each(optionStab, function () {
        optionsValues += this + '|';
    });
    itemData.optionsValues = optionsValues;
    itemData.executedJS = sfm_editorItemJS.getValue();

    if (!error) {

        sfm_showLoader();
        jQuery('#sfm_winItem').fadeOut();
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: itemData,
            success: function (itemID) {
                sfm_loadSettings();
                sfm_openWinStep(sfm_currentStepID);
            }
        });
    } else {
        jQuery("body,html").animate({
            scrollTop: 0
        }, 200);
    }
}

function sfm_loadSettings() {
    sfm_showLoader();
    jQuery('#sfm_stepsContainer .sfm_stepBloc,.sfm_loadSteps,.sfm_linkPoint').remove();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {
            action: 'sfm_loadSettings'
        },
        success: function (rep) {

            rep = JSON.parse(rep);
            sfm_steps = rep.steps;
            sfm_settings = rep;

            jQuery('#sfm_settingsPanel').find('input,select,textarea').each(function () {
                if (jQuery(this).is('[data-toggle="switch"]')) {
                    var value = false;

                    eval('if(rep.' + jQuery(this).attr('name') + ' == 1 ){jQuery(this).bootstrapSwitch("state", true);}');
                    eval('if(rep.' + jQuery(this).attr('name') + ' == 0){jQuery(this).bootstrapSwitch("state", false);}');
                } else {
                    eval('jQuery(this).val(rep.' + jQuery(this).attr('name') + ');');
                }
            });


            jQuery.each(rep.steps, function (index) {
                var step = this;
                step.content = JSON.parse(step.content);
                sfm_addStep(step);
            });
            jQuery.each(rep.links, function (index) {
                var link = this;
                link.originID = jQuery('.sfm_stepBloc[data-stepid="' + link.originID + '"]').attr('id');
                link.destinationID = jQuery('.sfm_stepBloc[data-stepid="' + link.destinationID + '"]').attr('id');
                link.conditions = JSON.parse(link.conditions);
                sfm_links[index] = link;
            });

            if (sfm_currentStepID == 0) {
                jQuery('#sfm_panelPreview').show();
            }
            jQuery('#sfm_loader').delay(1000).fadeOut();

            jQuery('.colorpick').each(function () {
                var $this = jQuery(this);
                if (jQuery(this).prev('.sfm_colorPreview').length == 0) {
                    jQuery(this).before('<div class="sfm_colorPreview" style="background-color:#' + $this.val().substr(1, 7) + '"></div>');
                }
                jQuery(this).prev('.sfm_colorPreview').click(function () {
                    jQuery(this).next('.colorpick').trigger('click');
                });
                jQuery(this).colpick({
                    color: $this.val().substr(1, 7),
                    onChange: function (hsb, hex, rgb, el, bySetColor) {
                        jQuery(el).val('#' + hex);
                        jQuery(el).prev('.sfm_colorPreview').css({
                            backgroundColor: '#' + hex
                        });
                    }
                });
            });
            sfm_editorCustomCSS.setValue(rep.customCSS);
            setTimeout(function () {
                sfm_editorCustomCSS.refresh();
            }, 100);

            jQuery('.imageBtn').click(function () {
                sfm_formfield = jQuery(this).prev('input');
                tb_show('', 'media-upload.php?TB_iframe=true');
                return false;
            });

            jQuery('#sfm_settingsPanel').find('input,textarea,select').trigger('change');
            sfm_updateStepsDesign();
            setTimeout(function () {
                sfm_updateStepsDesign();

            }, 250);

            sfm_changeMailchimp();
            sfm_changeGetResponse();
        }
    });
}
function sfm_returnToList() {
    sfm_showLoader();
    document.location.href = document.location.href;
}

function sfm_updateWinItemPosition() {
    if (jQuery('#sfm_winStep').css('display') != 'none') {
        var $item = jQuery('#' + jQuery('#sfm_itemWindow').attr('data-item'));
        if ($item.length > 0) {
            jQuery('#sfm_itemWindow').css({
                top: $item.offset().top - jQuery('#sfm_bootstraped.sfm_bootstraped').offset().top + $item.outerHeight() + 12,
                left: $item.offset().left - jQuery('#sfm_bootstraped.sfm_bootstraped').offset().left
            });
        } else {
            jQuery('#sfm_itemWindow').fadeOut();
        }
    } else {
        jQuery('#sfm_itemWindow').fadeOut();
    }
}

function sfm_existInDefaultStep(itemID) {
    var rep = false;
    jQuery.each(sfm_defaultStep.interactions, function () {
        var interaction = this;
        if (interaction.itemID == itemID) {
            rep = true;
        }
    });
    return rep;
}

function sfm_closeWin(win) {
    win.fadeOut();
    if (win.is('#sfm_winStep')) {
        jQuery('#sfm_stepsContainer').slideDown();
        jQuery('#sfm_panelPreview').fadeIn();
    }
    if (win.is('#sfm_winItem')) {
        jQuery('#sfm_winStep').fadeIn();
    }

    setTimeout(function () {
        sfm_updateStepsDesign();
    }, 250);
}

function sfm_startLink(stepID) {
    sfm_isLinking = true;
    sfm_linkCurrentIndex = sfm_links.length;
    sfm_links.push({
        originID: stepID,
        destinationID: null
    });

}

function sfm_stopLink(newStep) {
    sfm_isLinking = false;
    var chkLink = false;
    jQuery.each(sfm_links, function () {
        if (this.originID == sfm_links[sfm_linkCurrentIndex].originID && this.destinationID == newStep.attr('id')) {
            chkLink = this;
        }
    });
    if (!chkLink) {
        sfm_showLoader();
        sfm_links[sfm_linkCurrentIndex].destinationID = newStep.attr('id');
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_newLink',
                originStepID: jQuery('#' + sfm_links[sfm_linkCurrentIndex].originID).attr('data-stepid'),
                destinationStepID: jQuery('#' + sfm_links[sfm_linkCurrentIndex].destinationID).attr('data-stepid')
            },
            success: function (linkID) {
                sfm_links[sfm_linkCurrentIndex].id = linkID;
                sfm_loadSettings();
            }
        });
    } else {
        jQuery.grep(sfm_links, function (value) {
            return value != chkLink;
        });
    }
}

function sfm_removeAllSteps() {
    sfm_showLoader();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {
            action: 'sfm_removeAllSteps'
        },
        success: function () {
            sfm_loadSettings();
        }
    });
}
function sfm_openWinStep(stepID) {
    sfm_currentStepID = stepID;
    sfm_showLoader();


    jQuery('#sfm_panelPreview').fadeOut();
    jQuery('#sfm_itemsTable tbody').html('');
    if (sfm_currentStepID == 0) {
        jQuery('#sfm_itemsList').hide();
    } else {
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_loadStep',
                stepID: stepID
            },
            success: function (rep) {
                rep = jQuery.parseJSON(rep);
                step = rep.step;
                sfm_currentStep = rep;

                jQuery('#sfm_stepTabGeneral').find('input,select,textarea').each(function () {
                    if (jQuery(this).is('[data-toggle="switch"]')) {
                        var value = false;
                        eval('if(step.' + jQuery(this).attr('name') + ' == 1 ){jQuery(this).bootstrapSwitch("state", true);}');
                        eval('if(step.' + jQuery(this).attr('name') + ' == 0){jQuery(this).bootstrapSwitch("state", false);}');
                    } else {
                        eval('jQuery(this).val(step.' + jQuery(this).attr('name') + ');');
                    }
                });
                jQuery('#sfm_stepDescription').code(step.description);
                jQuery.each(rep.items, function () {
                    var item = this;
                    var $tr = jQuery('<tr data-itemid="' + item.id + '"></tr>');
                    $tr.append('<td><a href="javascript:"  onclick="sfm_editItem(' + item.id + ');">' + item.title + '</a><input type="text" class="form-control" value="' + item.title + '" style="display:none;" name="sfm_answer" /></td>');
                    $tr.append('<td style="min-width: 180px;"><a href="javascript:" onclick="sfm_editItem(' + item.id + ');" class="btn btn-primary btn-circle"><span class="glyphicon glyphicon-pencil"></span></a>' +
                            '<a href="javascript:" onclick="sfm_duplicateItem(' + item.id + ');" class="btn btn-default btn-circle"><span class="glyphicon glyphicon-duplicate"></span></a>' +
                            '<a href="javascript:" onclick="sfm_removeItem(' + item.id + ');" class="btn btn-danger btn-circle"><span class="glyphicon glyphicon-trash"></span></a></td>');
                    jQuery('#sfm_itemsTable tbody').append($tr);

                });
                jQuery('#sfm_itemsTable tbody').sortable({
                    helper: function (e, tr) {
                        var $originals = tr.children();
                        var $helper = tr.clone();
                        $helper.children().each(function (index)
                        {
                            jQuery(this).width($originals.eq(index).width());
                        });
                        return $helper;
                    },
                    stop: function (event, ui) {
                        var items = '';
                        jQuery('#sfm_itemsTable tbody tr[data-itemid]').each(function (i) {
                            items += jQuery(this).attr('data-itemid') + ',';
                        });
                        if (items.length > 0) {
                            items = items.substr(0, items.length - 1);
                        }
                        jQuery.ajax({
                            url: ajaxurl,
                            type: 'post',
                            data: {
                                action: 'sfm_changeItemsOrders',
                                items: items
                            }
                        });
                    }
                });
                jQuery('#sfm_itemsList').show();

                jQuery('#sfm_btns').html('');
                jQuery('#sfm_winStep').show();
                jQuery('#sfm_stepsContainer').slideUp();
                jQuery('#sfm_loader').fadeOut();

                setTimeout(function () {

                }, 400);
            }

        });
    }

}

function sfm_duplicateItem(itemID) {
    sfm_showLoader();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {action: 'sfm_duplicateItem', itemID: itemID},
        success: function (rep) {
            sfm_openWinStep(sfm_currentStepID);
        }
    });
}
function sfm_openWinLink($item) {
    sfm_currentLinkIndex = $item.attr('data-linkindex');
    jQuery('#sfm_winLink').attr('data-linkindex', $item.attr('data-linkindex'));
    jQuery('.sfm_conditionItem').remove();
    var stepID = jQuery('#' + sfm_links[$item.attr('data-linkindex')].originID).attr('data-stepid');
    var step = sfm_getStepByID(stepID);
    var destID = jQuery('#' + sfm_links[$item.attr('data-linkindex')].destinationID).attr('data-stepid');
    var destination = sfm_getStepByID(destID);

    jQuery('#sfm_linkInteractions').show();
    jQuery('#sfm_linkOriginTitle').html(step.title);
    jQuery('#sfm_linkDestinationTitle').html(destination.title);

    jQuery.each(sfm_links[sfm_currentLinkIndex].conditions, function () {
        sfm_addLinkInteraction(this);
    });
    jQuery('#sfm_linkOperator').val(sfm_links[sfm_currentLinkIndex].operator);
    jQuery('#sfm_winLink').fadeIn(250);

    setTimeout(sfm_updateStepsDesign, 255);

}

function sfm_addLinkInteraction(data) {
    var $item = jQuery('<tr class="sfm_conditionItem"></tr>');
    var $select = jQuery('<select class="sfm_conditionSelect form-control"></select>');
    jQuery.each(sfm_steps, function () {
        var step = this;
        jQuery.each(step.items, function () {
            var item = this;
            var itemID = step.id + '_' + item.id;
            if (item.type != "title" && item.type != "richtext" && item.type != "shortcode") {
                $select.append('<option value="' + itemID + '" data-type="' + item.type + '">' + step.title + ' : " ' + item.title + ' "</option>');
            }
        });
    });
    $select.append('<option value="_url" data-type="url" data-static="true">' + sfm_data.texts['currentPageIs'] + '</option>');

    var $operator = jQuery('<select class="sfm_conditionoperatorSelect form-control"></select>');
    $select.change(function () {
        var stepID = $select.val().substr(0, $select.val().indexOf('_'));
        var itemID = $select.val().substr($select.val().indexOf('_') + 1, $select.val().length);
        var item = false;
        jQuery.each(sfm_steps, function () {
            var step = this;
            if (step.id == stepID) {
                jQuery.each(step.items, function () {
                    if (this.id == itemID) {
                        item = this;
                    }
                });
            }
        });
        var operator = jQuery(this).parent().parent().find('.sfm_conditionoperatorSelect');
        operator.find('option').remove();
        if ($select.find('option:selected').is('[data-static]')) {
            var options = sfm_conditionGetOperators({
                type: $select.find('option:selected').attr('data-type')
            }, $select);
        } else {
            var options = sfm_conditionGetOperators(item, $select);
        }
        jQuery.each(options, function () {
            operator.append('<option value="' + this.value + '"  data-variable="' + this.hasVariable + '">' + this.text + '</option>');
        });
        $operator.change();
        setTimeout(function () {
            $operator.change();
        }, 300);
    });
    if (data) {
        $select.val(data.interaction);
    }
    $select.change();
    if ($select.find('option:selected').is('[data-static]')) {
        var options = sfm_conditionGetOperators({
            type: $select.find('option:selected').attr('data-type')
        }, $select);
    } else {
        var stepID = $select.val().substr(0, $select.val().indexOf('_'));
        var itemID = $select.val().substr($select.val().indexOf('_') + 1, $select.val().length);
        var item = false;
        jQuery.each(sfm_steps, function () {
            var step = this;
            if (step.id == stepID) {
                jQuery.each(step.items, function () {
                    if (this.id == itemID) {
                        item = this;
                    }
                });
            }
        });
        var options = sfm_conditionGetOperators(item, $select);
    }
    jQuery.each(options, function () {
        $operator.append('<option value="' + this.value + '" data-variable="' + this.hasVariable + '">' + this.text + '</option>');
    });

    $operator.change(function () {
        sfm_linksUpdateFields(jQuery(this));
    });
    var $col1 = jQuery('<td></td>');
    $col1.append($select);
    $item.append($col1);
    var $col2 = jQuery('<td></td>');
    $col2.append($operator);
    $item.append($col2);
    $item.append('<td></td><td><a href="javascript:" class="sfm_conditionDelBtn" onclick="sfm_conditionRemove(this);"><span class="glyphicon glyphicon-remove"></span></a> </td>');
    if (data) {
        $operator.val(data.action);
        $operator.change();
        if (data.value) {
            $operator.closest('.sfm_conditionItem').find('.sfm_conditionValue').val(data.value);
        }
        setTimeout(function () {
            sfm_linksUpdateFields($operator, data);
            if (data.value) {
                $operator.closest('.sfm_conditionItem').find('.sfm_conditionValue').val(data.value);
            }
        }, 500);
    }
    jQuery('#sfm_conditionsTable tbody').append($item);
}
function sfm_conditionGetOperators(item, $select) {
    var options = new Array();
    if (item.type == 'url' || item.type == 'textfield') {
        options.push({
            value: 'isEqual',
            text: sfm_data.texts['isEqual'],
            hasVariable: 'textfield'
        });
        options.push({
            value: 'isDifferent',
            text: sfm_data.texts['isDifferent'],
            hasVariable: 'textfield'
        });
        options.push({
            value: 'contains',
            text: sfm_data.texts['contains'],
            hasVariable: 'textfield'
        });
    } else if (item.type == 'slider' || item.type == 'numberfield') {
        options.push({
            value: 'isEqual',
            text: sfm_data.texts['isEqual'],
            hasVariable: 'numberfield'
        });
        options.push({
            value: 'isDifferent',
            text: sfm_data.texts['isDifferent'],
            hasVariable: 'numberfield'
        });
        options.push({
            value: 'isSuperior',
            text: sfm_data.texts['isSuperior'],
            hasVariable: 'numberfield'
        });
        options.push({
            value: 'isInferior',
            text: sfm_data.texts['isInferior'],
            hasVariable: 'numberfield'
        });
    } else if (item.type == 'dropdown') {
        options.push({
            value: 'isEqual',
            text: sfm_data.texts['isEqual'],
            hasVariable: 'select'
        });
        options.push({
            value: 'isDifferent',
            text: sfm_data.texts['isDifferent'],
            hasVariable: 'select'
        });
    } else {
        options.push({
            value: 'clicked',
            text: sfm_data.texts['isSelected']
        });
        options.push({
            value: 'unclicked',
            text: sfm_data.texts['isUnselected']
        });
    }
    return options;
}

function sfm_conditionRemove(btn) {
    var $btn = jQuery(btn);
    $btn.closest('.sfm_conditionItem').remove();
}

function sfm_linkSave() {
    if (sfm_canSaveLink) {
        sfm_canSaveLink = false;
        setTimeout(function () {
            sfm_canSaveLink = true;
        }, 1500);
        sfm_links[sfm_currentLinkIndex].conditions = new Array();
        jQuery('.sfm_conditionItem').each(function () {
            if (jQuery(this).find('.sfm_conditionSelect option:selected').attr('data-type') == 'url') {
                if (jQuery(this).find('.sfm_conditionValue').val().indexOf('http') != 0) {
                //    jQuery(this).find('.sfm_conditionValue').val(sfm_data.websiteUrl + '/' + jQuery(this).find('.sfm_conditionValue').val());
                }
            }

            sfm_links[sfm_currentLinkIndex].conditions.push({
                interaction: jQuery(this).find('.sfm_conditionSelect').val(),
                action: jQuery(this).find('.sfm_conditionoperatorSelect').val(),
                value: jQuery(this).find('.sfm_conditionValue').val()
            });
        });
        sfm_links[sfm_currentLinkIndex].operator = jQuery('#sfm_linkOperator').val();

        var cloneLinks = sfm_links.slice();
        jQuery.each(cloneLinks, function () {
            this.originID = jQuery('#' + this.originID).attr('data-stepid');
            this.destinationID = jQuery('#' + this.destinationID).attr('data-stepid');
        });
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_saveLinks',
                links: JSON.stringify(cloneLinks)
            },
            success: function () {
                sfm_closeWin(jQuery('#sfm_winLink'));
                sfm_loadSettings();
            }
        });
    }
}

function sfm_linkDel() {
    if (sfm_canSaveLink) {
        sfm_canSaveLink = false;
        setTimeout(function () {
            sfm_canSaveLink = true;
        }, 1500);
        sfm_links.splice(jQuery.inArray(sfm_links[sfm_currentLinkIndex], sfm_links), 1);
        var cloneLinks = sfm_links.slice();
        jQuery.each(cloneLinks, function () {
            this.originID = jQuery('#' + this.originID).attr('data-stepid');
            this.destinationID = jQuery('#' + this.destinationID).attr('data-stepid');
        });
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            data: {
                action: 'sfm_saveLinks',
                links: JSON.stringify(cloneLinks)
            },
            success: function () {
                sfm_closeWin(jQuery('#sfm_winLink'));
                sfm_loadSettings();
            }
        });
    }
}

function sfm_linksUpdateFields($operatorSelect, data) {

    $operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').parent().remove();
    if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionoperatorSelect option:selected').attr('data-variable') == "textfield") {
        if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').length == 0) {
            $operatorSelect.closest('.sfm_conditionItem').children('td:eq(2)').html('<div><input type="text" placeholder="http://..." class="sfm_conditionValue form-control" /> </div>');
        }
    }

    if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionoperatorSelect option:selected').attr('data-variable') == "numberfield") {
        if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').length == 0) {
            $operatorSelect.closest('.sfm_conditionItem').children('td:eq(2)').html('<div><input type="number" class="sfm_conditionValue form-control" /> </div>');
        }
    }
    if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionoperatorSelect option:selected').attr('data-variable') == "pricefield") {
        if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').length == 0) {
            $operatorSelect.closest('.sfm_conditionItem').children('td:eq(2)').html('<div><input type="number" step="any" class="sfm_conditionValue form-control" /> </div>');
        }
    }

    if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionoperatorSelect option:selected').attr('data-variable') == "datefield") {
        if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').length == 0) {
            $operatorSelect.closest('.sfm_conditionItem').children('td:eq(2)').html('<div><input type="text" step="any" class="sfm_conditionValue form-control"/> </div>');
            $operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').datepicker({
                dateFormat: 'yy-mm-dd'
            });
        }
    }
    if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionoperatorSelect option:selected').attr('data-variable') == "select") {
        var optionsSelect = '';
        var $select = $operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionSelect');
        var stepID = $select.val().substr(0, $select.val().indexOf('_'));
        var itemID = $select.val().substr($select.val().indexOf('_') + 1, $select.val().length);

        var optionsString = '';
        jQuery.each(sfm_steps, function () {
            if (this.id == stepID) {
                jQuery.each(this.items, function () {
                    if (this.id == itemID) {
                        optionsString = this.optionsValues;
                    }
                });
            }
        });
        var optionsArray = optionsString.split('|');
        jQuery.each(optionsArray, function () {
            var value = this;
            if (value.length > 0) {
                optionsString += '<option value="' + value + '">' + value + '</option>';
            }
        });

        if ($operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').length == 0) {
            $operatorSelect.closest('.sfm_conditionItem').children('td:eq(2)').html('<div><select class="sfm_conditionValue form-control">' + optionsString + '</select> </div>');
        }
    }

    if (data && data.value) {
        $operatorSelect.closest('.sfm_conditionItem').find('.sfm_conditionValue').val(data.value);
    }
}
function sfm_selectPre(input) {
    jQuery(input).select();
}
function sfm_saveSettings() {
    sfm_showLoader();
    var formData = {};
    jQuery('#sfm_settingsPanel').find('input,select,textarea').each(function () {
        if (!jQuery(this).is('[data-toggle="switch"]')) {
            eval('formData.' + jQuery(this).attr('name') + ' = jQuery(this).val();');
        } else {
            var value = 0;
            if (jQuery(this).is(':checked')) {
                value = 1;
            }
            eval('formData.' + jQuery(this).attr('name') + ' = value;');
        }
    });
    formData.customCSS = sfm_editorCustomCSS.getValue();

    formData.action = 'sfm_saveSettings';
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: formData,
        success: function () {
            jQuery('#sfm_loader').fadeOut();
        }
    });
}
function sfm_exportMenu() {

    sfm_showLoader();
    jQuery.ajax({
        url: ajaxurl,
        type: 'post',
        data: {
            action: 'sfm_exportMenu'
        },
        success: function (rep) {
            jQuery('#sfm_loader').fadeOut();
            if (rep == '1') {
                jQuery('#sfm_winExport').modal('show');
            } else {
                alert(sfm_data.texts['errorExport']);
            }
        }
    });

}
function sfm_importMenu() {
    if (jQuery('#sfm_winImport [name="importFile"]')[0].files.length > 0) {
        sfm_showLoader();
        jQuery('#sfm_winImport').modal('hide');
        var formData = new FormData(jQuery('#sfm_winImportMenu')[0]);
        jQuery.ajax({
            url: ajaxurl,
            type: 'post',
            xhr: function () {
                var myXhr = jQuery.ajaxSettings.xhr();
                return myXhr;
            },
            success: function (rep) {
                if (rep != '1') {
                    jQuery('#sfm_loader').fadeOut();
                    alert(sfm_data.texts['errorImport']);
                } else {
                    document.location.href = document.location.href;
                }
            },
            data: formData,
            cache: false,
            contentType: false,
            processData: false
        });
    }
}

function sfm_getOptions() {
    var optionsTab = new Array();
    jQuery('#sfm_itemOptionsValues tbody tr').not('.static').each(function () {
        if (jQuery(this).find('td:eq(0) input').length > 0) {
            optionsTab.push(jQuery(this).find('td:eq(0) input').val());
        } else {
            optionsTab.push(jQuery(this).find('td:eq(0)').html());
        }
    });
    return optionsTab;
}
function sfm_add_option() {
    var newValue = jQuery('#sfm_itemOptionsValues #option_new_value').val();
    if (newValue != "") {
        jQuery('#sfm_itemOptionsValues #option_new_value').closest('tr').before('<tr><td>' + newValue + '</td><td><a href="javascript:" onclick="sfm_edit_option(this);" class="btn btn-default  btn-circle "><span class="glyphicon glyphicon-pencil"></span></a><a href="javascript:" onclick="sfm_del_option(this);" class="btn btn-danger btn-circle "><span class="glyphicon glyphicon-trash"></span></a></td></tr>');
        jQuery('#sfm_itemOptionsValues #option_new_value').val('');
    }
    jQuery('#sfm_itemOptionsValues tbody').sortable({
        helper: function (e, tr) {
            var $originals = tr.children();
            var $helper = tr.clone();
            $helper.children().each(function (index)
            {
                jQuery(this).width($originals.eq(index).width());
            });
            return $helper;
        }
    });
}
function sfm_del_option(btn) {
    jQuery(btn).parent().parent().remove();
}

function sfm_edit_option(btn) {
    var $tr = jQuery(btn).closest('tr');
    var name = $tr.children('td:eq(0)').html();
    var price = $tr.children('td:eq(1)').html();
    $tr.children('td:eq(0)').html('<input type="text" id="option_edit_value" style="max-width: 100%;" class="form-control" value="' + name + '" placeholder="Option value">');
    jQuery(btn).hide();
    jQuery(btn).after('<a href="javascript:" onclick="sfm_edit_saveOption(this);" class="btn btn-primary btn-circle "><span class="glyphicon glyphicon-ok"></span></a>');
}
function sfm_edit_saveOption(btn) {
    var $tr = jQuery(btn).closest('tr');
    var name = $tr.children('td:eq(0)').find('input').val();
    var price = $tr.children('td:eq(1)').find('input').val();
    $tr.children('td:eq(0)').html(name);
    $tr.children('td:eq(1)').html(price);
    jQuery(btn).prev('a').show();
    jQuery(btn).remove();
}


function sfm_startSelectElement() {
    if (jQuery('#sfm_websiteFrame').length > 0) {
        jQuery('#sfm_websiteFrame').remove();
        jQuery('.sfm_selectElementPanel').remove();
    }
    jQuery('body').append('<iframe id="sfm_websiteFrame" src="' + sfm_data.websiteUrl + '?sfm_action=selectElement" onload="sfm_websiteFrameLoaded();"></iframe>');
    jQuery('#sfm_websiteFrame').hover(function () {
        jQuery('#sfm_websiteFrame').addClass('sfm_hover');
    }, function () {
        jQuery('#sfm_websiteFrame').removeClass('sfm_hover');
    });
    jQuery('body').append('<div id="sfm_bootstraped" class="sfm_bootstraped sfm_selectElementPanel"></div>');
    jQuery('.sfm_selectElementPanel').hover(function () {
        jQuery('.sfm_selectElementPanel').addClass('sfm_hover');
    }, function () {
        jQuery('.sfm_selectElementPanel').removeClass('sfm_hover');
    });
    jQuery('.sfm_selectElementPanel').html('<p>' + sfm_data.texts['txt_selectStart'] + '</p>');
    jQuery('.sfm_selectElementPanel').append('<p><a href="javascript:" class="btn btn-primary" onclick="sfm_selectionSelectElement();">' + sfm_data.texts['txt_selectBtn'] + '</a>&nbsp;&nbsp;<a href="javascript:" class="btn btn-danger" onclick="sfm_stopSelectElement();">' + sfm_data.texts['txt_cancel'] + '</a></p>');
    jQuery('#sfm_loader').fadeIn();
    jQuery('.sfm_selectElementPanel').delay(500).fadeIn();
}

function sfm_selectionSelectElement() {
    jQuery('.sfm_selectElementPanel').html('<p>' + sfm_data.texts['txt_selectSelection'] + '</p>');
    jQuery('.sfm_selectElementPanel').append('<p><a href="javascript:" class="btn btn-danger" onclick="sfm_stopSelectElement();">' + sfm_data.texts['txt_cancel'] + '</a></p>');
    var $f = jQuery("#sfm_websiteFrame")[0];
    var contentWin = $f.contentWindow || $f.contentDocument;
    contentWin.sfm_startSelection();
}

function sfm_confirmSelectElement(el) {
    sfm_currentDomElement = el;
    jQuery('.sfm_selectElementPanel').html('<p>' + sfm_data.texts['txt_selectConfirm'] + '</p>');
    jQuery('.sfm_selectElementPanel').append('<p><a href="javascript:" class="btn btn-primary" onclick="sfm_confirmedSelectElement();">' + sfm_data.texts['txt_yes'] + '</a>&nbsp;&nbsp;<a href="javascript:" onclick="sfm_startSelectElement();" class="btn btn-danger">' + sfm_data.texts['txt_no'] + '</a></p>');
}

function sfm_websiteFrameLoaded() {
    jQuery('#sfm_loader').fadeOut();
}

function sfm_stopSelectElement() {
    jQuery('#sfm_websiteFrame').fadeOut(250);
    jQuery('.sfm_selectElementPanel').fadeOut(250);
    setTimeout(function () {
        jQuery('#sfm_websiteFrame').remove();
        jQuery('.sfm_selectElementPanel').remove();
    }, 300);
}

function sfm_confirmedSelectElement() {
    var path = sfm_getPath(sfm_currentDomElement);
    if (jQuery('#sfm_winItem').css('display') != 'none') {
        jQuery('#sfm_winItem').find('input[name="domElement"]').val(path);
        var url = jQuery('#sfm_websiteFrame').contents().get(0).location.href;
        url = url.replace('?sfm_action=selectElement','');
        url = url.replace('&sfm_action=selectElement','');
        jQuery('#sfm_winItem').find('input[name="url"]').val(url);
    } else {
        jQuery('#sfm_settingsPanel').find('input[name="domElement"]').val(path);
    }
    sfm_stopSelectElement();
    jQuery('#sfm_actionElementSelected').fadeIn();
}

function sfm_getPath(el) {
    var path = '';
    if (jQuery(el).length > 0 && typeof (jQuery(el).prop('tagName')) != "undefined") {
        if (!jQuery(el).attr('id') || jQuery(el).attr('id').substr(0, 8) == 'ultimate') {
            path = '>' + jQuery(el).prop('tagName') + ':nth-child(' + (jQuery(el).index() + 1) + ')' + path;
            path = sfm_getPath(jQuery(el).parent()) + path;
        } else {
            path += '#' + jQuery(el).attr('id');
        }
    }
    return path;
}