<?php

/*
 * Plugin Name: WP Smart Fullscreen Menu
 * Version: 1.044
 * Plugin URI: http://codecanyon.net/user/loopus/portfolio
 * Description: This plugin allows you to easily create complex and powerful smart menus on your Wordpress website
 * Author: پرشین اسکریپت
 * Author URI: https://www.persianscript.ir
 * Requires at least: 3.8
 * Tested up to: 5.3
 *
 * @package WordPress
 * @author Biscay Charly (loopus)
 * @since 1.0.0
 */

if (!defined('ABSPATH'))
    exit;

register_activation_hook(__FILE__, 'sfm_install');
//register_deactivation_hook(__FILE__, 'sfm_uninstall');
register_uninstall_hook(__FILE__, 'sfm_uninstall');

global $jal_db_version;
$jal_db_version = "1.1";

require_once('includes/sfm-core.php');
require_once('includes/sfm-admin.php');

if(!class_exists("Mailchimp",false)){
    require_once('includes/Mailchimp.php');    
}
if(!class_exists("GetResponse",false)){
    require_once('includes/GetResponseAPI.class.php');    
}

function WP_SmartFullscreenMenu() {
    $version = 1.044;
    sfm_checkDBUpdates($version);
    $instance = SFM_Core::instance(__FILE__, $version);
    if (is_null($instance->menu)) {
        $instance->menu = SFM_admin::instance($instance);
    }
    return $instance;
}

/**
 * Installation. Runs on activation.
 * @access  public
 * @since   1.0.0
 * @return  void
 */
function sfm_install() {
    global $wpdb;
    global $jal_db_version;
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
    add_option("jal_db_version", $jal_db_version);

    $db_table_name = $wpdb->prefix . "sfm_settings";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
               id mediumint(9) NOT NULL AUTO_INCREMENT,
               purchaseCode VARCHAR(250) NOT NULL,   
                enabled BOOL NOT NULL,
                showLinksTitlesAsTooltips BOOL NOT NULL DEFAULT 1,
                animationsLinks VARCHAR(64) NOT NULL DEFAULT 'blind',
                animationMenu VARCHAR(64) NOT NULL DEFAULT 'slideUp',
                color_tooltipsBg VARCHAR(64) NOT NULL DEFAULT '#2c3e50',
                color_tooltipsTxt VARCHAR(64) NOT NULL DEFAULT '#ffffff',
                color_bg VARCHAR(64) NOT NULL DEFAULT '#1abc9c',
                color_txts VARCHAR(64) NOT NULL DEFAULT '#ffffff',
                color_closeBtn VARCHAR(64) NOT NULL DEFAULT '#ffffff',
                color_dropdownBg VARCHAR(64) NOT NULL DEFAULT '#ecf0f1',
                color_dropdownTxt VARCHAR(64) NOT NULL DEFAULT '#bdc3c7',
                color_dropdownOptionsBg VARCHAR(64) NOT NULL DEFAULT '#2c3e50',
                color_dropdownOptionsTxt VARCHAR(64) NOT NULL DEFAULT '#1abc9c',
                color_dropdown_borderColor VARCHAR(64) NOT NULL DEFAULT '#bdc3c7', 
                color_dropdown_borderColorFocus VARCHAR(64) NOT NULL DEFAULT '#16a085', 
                color_checkedicon VARCHAR(64) NOT NULL DEFAULT '#34495e',         
                color_sliderBg VARCHAR(64) NOT NULL DEFAULT '#ecf0f1',            
                color_sliderCircle VARCHAR(64) NOT NULL DEFAULT '#34495e',        
                color_menuBtn_bg VARCHAR(64) NOT NULL DEFAULT '#1abc9c',          
                color_menuBtn_icon VARCHAR(64) NOT NULL DEFAULT '#ffffff', 
                color_fields_bg VARCHAR(64) NOT NULL DEFAULT '#ecf0f1', 
                color_fields_txt VARCHAR(64) NOT NULL DEFAULT '#bdc3c7', 
                color_fields_borderColor VARCHAR(64) NOT NULL DEFAULT '#bdc3c7', 
                color_fields_borderColorFocus VARCHAR(64) NOT NULL DEFAULT '#16a085', 
                menuBtn_icon VARCHAR(64) NOT NULL DEFAULT 'fa-bars',
                googleFont VARCHAR(250) NOT NULL DEFAULT 'Lato',
                inverseGrayFx BOOL NOT NULL,
                checkedItemicon VARCHAR(64) NOT NULL DEFAULT 'fa-check',
                customCSS LONGTEXT NOT NULL ,
                integrationType VARCHAR(64) NOT NULL DEFAULT 'fixedButton',
                fixedBtnPosition VARCHAR(64) NOT NULL DEFAULT 'topRight',
                domElement VARCHAR(250) NOT NULL,
                sendContactToGetResponse BOOL NOT NULL,
                sendContactToMailChimp BOOL NOT NULL,                
                mailchimpKey VARCHAR(250) NOT NULL,
                mailchimpList VARCHAR(250) NOT NULL,
                mailchimpOptin BOOL NOT NULL,
                getResponseKey VARCHAR(250) NOT NULL,
                getResponseList VARCHAR(250) NOT NULL,         
                autoShow BOOL NOT NULL,
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);
        $rows_affected = $wpdb->insert($db_table_name, array('purchaseCode' => ''));        
    }
    
    $db_table_name = $wpdb->prefix . "sfm_steps";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		title VARCHAR(250) NOT NULL,  
                start BOOL NOT NULL,
                showTitle BOOL NOT NULL DEFAULT 0,
                content LONGTEXT NOT NULL,                
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);    
        $content = new stdClass();
        $content->previewPosX = 667;
        $content->previewPosY = 178;
        $content->start = 1;
        $content = json_encode($content);
        $rows_affected = $wpdb->insert($db_table_name, array('title' => 'My Start step','start'=>1,'content'=>$content,'showTitle'=>1));   
            
    }
    $db_table_name = $wpdb->prefix . "sfm_items";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
                stepID mediumint(9) NOT NULL,
                ordersort SMALLINT(5) NOT NULL, 
                actionType VARCHAR(64) NOT NULL DEFAULT '',  
                title VARCHAR(250) NOT NULL DEFAULT 'My link',      
                image VARCHAR(250) NOT NULL DEFAULT '".esc_url(trailingslashit(plugins_url('/assets/', __FILE__)))."img/monitor.svg',                
                url VARCHAR(250) NOT NULL,            
                domElement VARCHAR(250) NOT NULL,
                type VARCHAR(64) NOT NULL DEFAULT 'image',
                optionsValues TEXT NOT NULL,
                placeholder VARCHAR(128) NOT NULL DEFAULT 'My text',   
                valueMin SMALLINT(9) NOT NULL DEFAULT 0,  
                valueMax SMALLINT(9) NOT NULL DEFAULT 100,
                executedJS LONGTEXT NOT NULL,
                layout VARCHAR(64) NOT NULL DEFAULT 'inline',
                informationType VARCHAR(64) NOT NULL DEFAULT '',
                isRequired BOOL NOT NULL,
                sendContactOnChange BOOL NOT NULL,
                richtext LONGTEXT NOT NULL,
                shortcode VARCHAR(250) NOT NULL,
                showTitle BOOL NOT NULL DEFAULT 1,
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);    
        $rows_affected = $wpdb->insert($db_table_name, array('title' => 'Hello world','stepID'=>1,'actionType'=>'nextStep'));  
    }
        
    $db_table_name = $wpdb->prefix . "sfm_links";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";
        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		faqID mediumint (9) NOT NULL,
    		originID INT(9) NOT NULL,
    		destinationID INT(9) NOT NULL,
    		conditions TEXT NOT NULL,
                operator VARCHAR(8) NOT NULL,
    		UNIQUE KEY id (id)
    		) $charset_collate;";
        dbDelta($sql);
    }
        
    global $isInstalled;
    $isInstalled = true;
}
// End install()

/**
 * Update database
 * @access  public
 * @since   2.0
 * @return  void
 */
function sfm_checkDBUpdates($version) {
    global $wpdb;
    $installed_ver = get_option("sfm_version");
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');     
        
    update_option("sfm_version", $version);
}

/**
 * Uninstallation.
 * @access  public
 * @since   1.0.0
 * @return  void
 */
function sfm_uninstall() {

    global $wpdb;
    global $jal_db_version;
    $table_name = $wpdb->prefix . "sfm_settings";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    $table_name = $wpdb->prefix . "sfm_steps";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    $table_name = $wpdb->prefix . "sfm_links";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    $table_name = $wpdb->prefix . "sfm_items";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");  
}
// End uninstall()

WP_SmartFullscreenMenu();