<?php
/**
 * Options page
 *
 * @package WP_Review
 */

/**
 * Class WP_Review_Options
 */
class WP_Review_Options {

	/**
	 * Page hook.
	 *
	 * @var string
	 */
	protected $hook;


	/**
	 * Class init.
	 */
	public function init() {
		add_action( 'admin_menu', array( $this, 'register_menu' ) );
		add_action( 'admin_init', array( $this, 'register_settings' ) );
	}

	/**
	 * Registers admin menu.
	 */
	public function register_menu() {
		$this->hook = add_options_page(
			__( 'WP Review Pro', 'wp-review' ),
			__( 'WP Review Pro', 'wp-review' ),
			'administrator',
			'wp-review-pro',
			array( $this, 'render' )
		);

		add_action( "load-{$this->hook}", array( $this, 'load' ) );
	}

	/**
	 * Runs some functions on page load.
	 */
	public function load() {
		add_filter( 'admin_body_class', array( $this, 'admin_body_classes' ) );
	}

	/**
	 * Adds classes to body tag.
	 *
	 * @param  array $classes Body classes.
	 * @return array
	 */
	public function admin_body_classes( $classes ) {
		$classes .= ' wp-review-admin-options';
		return $classes;
	}

	/**
	 * Registers settings.
	 */
	public function register_settings() {
		register_setting( 'wpreview-settings-group', 'wp_review_options' );
		register_setting( 'wpreview-settings-group', 'wp_review_popup' );
		register_setting( 'wpreview-settings-group', 'wp_review_hello_bar' );
	}

	/**
	 * Gets options page tabs.
	 *
	 * @return array
	 */
	protected function get_tabs() {
		return array(
			array(
				'id'    => 'review',
				'title' => __( 'Global', 'wp-review' ),
				'icon'	=> 'fa fa-cogs',
				'view'  => WP_REVIEW_ADMIN . 'options/review.php',
			),
			array(
				'id'    => 'popup',
				'title' => __( 'Popup', 'wp-review' ),
				'icon'	=> 'fa fa-sticky-note',
				'view'  => WP_REVIEW_ADMIN . 'options/popup.php',
			),
			array(
				'id'    => 'hello-bar',
				'title' => __( 'Notification Bar', 'wp-review' ),
				'icon'	=> 'fa fa-warning',
				'view'  => WP_REVIEW_ADMIN . 'options/hello-bar.php',
			),
			array(
				'id'    => 'yelp',
				'title' => __( 'Yelp Reviews', 'wp-review' ),
				'icon'	=> 'fa fa-yelp',
				'view'  => WP_REVIEW_ADMIN . 'options/yelp.php',
			),
			array(
				'id'    => 'google',
				'title' => __( 'Google Reviews', 'wp-review' ),
				'icon'	=> 'fa fa-google',
				'view'  => WP_REVIEW_ADMIN . 'options/google.php',
			),
			array(
				'id'    => 'facebook',
				'title' => __( 'Facebook Reviews', 'wp-review' ),
				'icon'	=> 'fa fa-facebook',
				'view'  => WP_REVIEW_ADMIN . 'options/facebook.php',
			),
			array(
				'id'    => 'import',
				'title' => __( 'Import Reviews', 'wp-review' ),
				'icon'	=> 'fa fa-download',
				'view'  => WP_REVIEW_ADMIN . 'options/import.php',
			),
		);
	}

	/**
	 * Renders page content.
	 */
	public function render() {
		$tabs = $this->get_tabs();
		?>
		<div class="wrap wp-review">
			<h1><?php esc_html_e( 'WP Review Pro Settings', 'wp-review' ); ?></h1>

			<form method="post" action="options.php">
				<?php settings_fields( 'wpreview-settings-group' ); ?>

				<div id="wpr-global-options" class="wpr-vertical-tabs" data-vertical-tabs>
					<ul class="wpr-vertical-tabs__titles">
						<?php foreach ( $tabs as $tab ) : ?>
							<li class="wpr-vertical-tabs__title"><a href="#<?php echo esc_attr( $tab['id'] ); ?>" data-tab-title><i class="<?php echo esc_html( $tab['icon'] ); ?>"></i> <?php echo esc_html( $tab['title'] ); ?></a></li>
						<?php endforeach; ?>
					</ul>



					<div class="wpr-vertical-tabs__contents">
						<?php foreach ( $tabs as $tab ) : ?>
							<div id="<?php echo esc_attr( $tab['id'] ); ?>" class="wpr-vertical-tabs__content" data-tab-content>
								<h2><?php echo esc_html( $tab['title'] ); ?></h2>

								<?php include $tab['view']; ?>
							</div>
						<?php endforeach; ?>
					</div>
					<?php submit_button(); ?>
				</div>
			</form>
		</div>
		<?php
	}
}

$page = new WP_Review_Options();
$page->init();
