<?php

global	$wpdb;
require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

$create_emails = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "wp_quiz_emails` (
	`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
	`pid` bigint(20) unsigned NOT NULL,
	`username` varchar(255) NOT NULL,
	`email` varchar(255) NOT NULL,
	`date` date NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
maybe_create_table( $wpdb->prefix . 'wp_quiz_emails', $create_emails );

$create_players = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "wp_quiz_players` (
	`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
	`pid` bigint(20) unsigned NOT NULL,
	`date` date NOT NULL,
	`user_ip` varchar(50) NOT NULL,
	`username` varchar(255) NOT NULL,
	`correct_answered` smallint(5) unsigned NULL,
	`result` varchar(255) NOT NULL,
	`quiz_type` varchar(16) NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
maybe_create_table( $wpdb->prefix . 'wp_quiz_players', $create_players );

$create_fb_users = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "wp_quiz_fb_users` (
	`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
	`uid` bigint(20) unsigned NOT NULL,
	`created_at` date NOT NULL,
	`updated_at` date NOT NULL,
	`email` varchar(255) NOT NULL,
	`first_name` varchar(255) NOT NULL,
	`last_name` varchar(255) NOT NULL,
	`gender` varchar(16) NOT NULL,
	`picture` varchar(500) NOT NULL,
	`friends` longtext NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
maybe_create_table( $wpdb->prefix . 'wp_quiz_fb_users', $create_fb_users );

$create_plays = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "wp_quiz_fb_plays` (
	`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
	`user_id` bigint(20) unsigned NOT NULL,
	`pid` bigint(20) unsigned NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
maybe_create_table( $wpdb->prefix . 'wp_quiz_fb_plays', $create_plays );

$quiz_version = get_option( 'wp_quiz_pro_version' );
if ( false === $quiz_version ) {
	update_option( 'wp_quiz_pro_version' , '1.0.2' );
}

$quiz_settings = get_option( 'wp_quiz_pro_default_settings' );
// Create Settings
if ( false === $quiz_settings ) {

	$mts_username = '';
	// MTS Connect plugin username
	$mts_connect_data = get_option( 'mts_connect_data' );
	if ( false !== $mts_connect_data ) {
		$mts_username = $mts_connect_data['username'];
	}

	// Create Options
	$quiz_settings = array(
		'analytics' => array(
			'profile_name' 	=> '',
			'tracking_id' 	=> '',
		),
		'mail_service' => '0',
		'mailchimp' => array(
			'api_key' 	=> '',
			'list_id' 	=> '',
		),
		'getresponse' => array(
			'api_key' 		=> '',
			'campaign_name' => '',
		),
		'aweber' => array(
			'account_id' => '',
			'access_key' => '',
			'access_secret' => '',
			'consumer_key' => '',
			'consumer_secret' => '',
			'listid' => '',
		),
		'defaults'	=> array(
			'rand_questions' 	=> 0,
			'rand_answers' 		=> 0,
			'restart_questions' => 0,
			'promote_plugin' 	=> 0,
			'mts_username'		=> $mts_username,
			'embed_toggle'		=> 0,
			'show_ads'			=> 0,
			'repeat_ads'		=> 0,
			'fb_app_id'			=> '0',
			'ad_nth_display' 	=> '0',
			'countdown_timer' 	=> '0',
			'auto_scroll'		=> 1,
			'force_action' 		=> 0,
			'share_buttons'		=> array( 'fb', 'tw', 'g+', 'vk' ),
			'share_meta'		=> 1,
			'subscribe_box_user_consent' => __( 'I consent to having form collect my name and email!', 'wp-quiz-pro' ),
			'subscribe_box_user_consent_desc' => sprintf(__( 'The form collects name and email so that we can add you to our newsletter list for project updates. Check out our %sprivacy policy%s for the full story on how we protect and manage your submitted data!', 'wp-quiz-pro' ), '<a href="#">', '</a>'),
		),
		'ad_code' 			=> array(),
		'players_tracking' 	=> 0,
	);

	update_option( 'wp_quiz_pro_default_settings', $quiz_settings );
}

// Create Import/Export Directory
$wq_upload_dir = wp_upload_dir();
wp_mkdir_p( $wq_upload_dir['basedir'] . '/wp_quiz-import/' );
wp_mkdir_p( $wq_upload_dir['basedir'] . '/wp_quiz-result-images/' );


chmod( $wq_upload_dir['basedir'], 0755 );
chmod( $wq_upload_dir['basedir'] . '/wp_quiz-import/', 0755 );
chmod( $wq_upload_dir['basedir'] . '/wp_quiz-result-images/', 0755 );


function mts_wp_quiz_pro_after_activation() {
	// Check for Connect plugin version > 1.4
    if ( class_exists('mts_connection') && defined('MTS_CONNECT_ACTIVE') && MTS_CONNECT_ACTIVE ) {
        return;
    }
    $plugin_path = 'mythemeshop-connect/mythemeshop-connect.php';
    
    // Check if plugin exists
    $plugins = get_plugins();
    if ( ! array_key_exists( $plugin_path, $plugins ) ) {
        // auto-install it
        include_once( ABSPATH . 'wp-admin/includes/misc.php' );
        include_once( ABSPATH . 'wp-admin/includes/file.php' );
        include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
        include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
        $skin     = new Automatic_Upgrader_Skin();
        $upgrader = new Plugin_Upgrader( $skin );
        $plugin_file = 'https://mythemeshop.com/mythemeshop-connect.zip';
        $result = $upgrader->install( $plugin_file );
        // If install fails then revert to previous theme
        if ( is_null( $result ) || is_wp_error( $result ) || is_wp_error( $skin->result ) ) {
            switch_theme( $oldtheme->stylesheet );
            return false;
        }
    } else {
        // Plugin is already installed, check version
        $ver = isset( $plugins[$plugin_path]['Version'] ) ? $plugins[$plugin_path]['Version'] : '1.0';
        if ( version_compare( $ver, '1.4' ) === -1 ) {
            // Update if < 1.4
            include_once( ABSPATH . 'wp-admin/includes/misc.php' );
            include_once( ABSPATH . 'wp-admin/includes/file.php' );
            include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
            include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
            $skin     = new Automatic_Upgrader_Skin();
            $upgrader = new Plugin_Upgrader( $skin );
            
            add_filter( 'pre_site_transient_update_plugins',  'mts_wp_quiz_pro_inject_connect_repo', 10, 2 );
            $result = $upgrader->upgrade( $plugin_path );
            remove_filter( 'pre_site_transient_update_plugins', 'mts_wp_quiz_pro_inject_connect_repo' );
            
            // If update fails then revert to previous theme
            if ( is_null( $result ) || is_wp_error( $result ) || is_wp_error( $skin->result ) ) {
                switch_theme( $oldtheme->stylesheet );
                return false;
            }
        }
    }
    // auto-activate Connect
    $activate = activate_plugin( $plugin_path );
 }

 function mts_wp_quiz_pro_inject_connect_repo( $pre, $transient ) {
    $plugin_file = 'https://mythemeshop.com/mythemeshop-connect.zip';
    
    $return = new stdClass();
    $return->response = array();
    $return->response['mythemeshop-connect/mythemeshop-connect.php'] = new stdClass();
    $return->response['mythemeshop-connect/mythemeshop-connect.php']->package = $plugin_file;
    return $return;
}

mts_wp_quiz_pro_after_activation(); 