<?php
/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.8.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_edit_account_form' );

	$wppb_woosync_settings = get_option( 'wppb_woosync_settings');

	//Check if there is a specific Edit Profile form we need to display
	if ( $wppb_woosync_settings['EditProfileForm'] == 'wppb-default-edit-profile' ){

	    $redirect_url = apply_filters( 'wppb_woo_myaccount_edit_account_redirect_url', get_permalink( wc_get_page_id( 'myaccount' ) ) );

	    echo do_shortcode( '[wppb-edit-profile redirect_url="' .esc_url($redirect_url). '" ]' );
	}
	else
	    echo do_shortcode( '[wppb-edit-profile form_name="' . apply_filters('wppb_woo_edit_profile_form_name', Wordpress_Creation_Kit_PB::wck_generate_slug($wppb_woosync_settings['EditProfileForm'])) . '"]');

do_action( 'woocommerce_after_edit_account_form' ); ?>
