/**********************************
 * WPPAS VBC EDITOR 5.1.3
 * @author Tunafish
***********************************/
(function( $ ) {
	"use strict";
	
	var _W = $.fn.wppas,
		save_confirms = JSON.parse(itm_editor_save_confirms.array);

	$.extend(true, _W, {
		
		/**
		 * START SCREEN - SETTINGS
		 *
		 *
		 */
		wppas_adzone_startscreen: function(options) {
			
			var _t = $(this),
				//_wppas = _t.wppas(),
				adzone_size = $('#wppas_adzone_size').val();
			
			// Wait for page to be loaded
			_t.wppas.onReady(function (){
				$('.wppas_loading_vbc').hide();
				$('#vbc_main_area').show();
			});
			
			// switching between tabs
			$('#vbc_menu').wppas.tabs({container: '.vbc_main_tabs_container', ul: '.vbc_main_menu_toggle', screen_sizes: options.screen_sizes});
			
			_t.wppas.display_options_func();
			$('.vbc-color-field').wpColorPicker();
			
			
			// Select default banner size
			$('.wppas_home_tpl_btn').removeClass('selected');
			$(".wppas_info_btns").find("[data-type='" + adzone_size+"']").addClass('selected');
			var bsize = adzone_size.split('x');
			$('#custom_bsize_w').val(bsize[0]);
			$('#custom_bsize_h').val(bsize[1]);
			var w = (bsize[0]*100)/800,
				h = (bsize[1]*100)/800;
			$('.custom_bsize_preview').css({width: w+'%', height: h+'%'});
			
			
			
			// -- CHANGE ADZONE SIZE --
			$('#wppas_adzone_size').on('change', function(){
				
				var bsize = $(this).val().split('x');
				$('.wppas_home_tpl_btn').removeClass('selected');
				$(".wppas_info_btns").find("[data-type='" + bsize[0]+"x"+bsize[1]+"']").addClass('selected');
			});
			
			// -- BANNER SIZE BUTTONS --
			$('.bsize').on('click', function(){
				
				var bsize = $(this).data('type').split('x');
				
				$('.wppas_home_tpl_btn').removeClass('selected');
				$(this).addClass('selected');
				
				//$('#wppas_banner_size option[value="'+bsize[0]+'x'+bsize[1]+'"]').prop('selected', true);
				$('#wppas_adzone_size').val(bsize[0]+'x'+bsize[1]);
				
				$('#custom_bsize_w').val('');
				$('#custom_bsize_h').val('');
				
				//_t.wppas.update_banner_size(bsize);
			});
			
			
			// -- CUSTOM BSIZE --
			$('#custom_bsize_w').on('change', function(){
				var _s = $(this).val() != '' ? $(this).val() : 100,
					w = (_s*100)/800,
					h = $('#custom_bsize_h').val() != '' ? $('#custom_bsize_h').val() : 100,
					size = _s+'x'+h,
					bsize = size.split('x');
					
				$('.custom_bsize_preview').css({width: w+'%'});
				$('#wppas_adzone_size').val(size);
				$('.wppas_home_tpl_btn').removeClass('selected');
				
				//_t.wppas.update_banner_size(bsize);
			});
			$('#custom_bsize_h').on('change', function(){
				var _s = $(this).val() != '' ? $(this).val() : 100,
					h = (_s*100)/800,
					w = $('#custom_bsize_w').val() != '' ? $('#custom_bsize_w').val() : 100,
					size = w+'x'+_s,
					bsize = size.split('x');
					
				$('.custom_bsize_preview').css({height: h+'%'});
				$('#wppas_adzone_size').val(size);
				$('.wppas_home_tpl_btn').removeClass('selected');
				
				//_t.wppas.update_banner_size(bsize);
			});
			
			
			
			// -- SAVE ADZONE --
			$('.save_adzone').on('click', function(){
				
				var asize = $('#wppas_adzone_size').val().split('x');
				$('.vbc_loader_bg').show();
				$('.vbc_loader_duration').show();
				
				var adzone_data = {
					ID: $('#adzone_ID').val(),
					size: $('#wppas_adzone_size').val(),
					w: asize[0],
					h: asize[1],
					name: $('#wppas_adzone_name').val(),
					rotation: $('#wppas_adzone_rotation').val(),
					rotation_shuffle: $('#wppas_adzone_rotation_shuffle').val(),
					rotation_time: $('#wppas_adzone_rotation_time').val(),
					rotation_type: $('#wppas_adzone_rotation_effect').val(),
					buyandsell: $('#wppas_adzone_buyandsell').val(),
					bs_max_banners: $('#wppas_adzone_bs_max_banners').val(),
					bs_banner_id: $('#wppas_adzone_bs_banner_id').val(),
					bs_contract: $('#wppas_adzone_bs_contract').val(),
					bs_duration: $('#wppas_adzone_bs_duration').val(),
					bs_approve: $('#wppas_adzone_bs_approve').val(),
					bs_price: $('#wppas_adzone_bs_price').val(),
					bs_pos_bid: $('#wppas_adzone_bs_pos_bid').val(),
					showhide: $('#wppas_showhide').val(),
					hide_for_categories: $('#wppas_adzone_hide_categories').val(),
					hide_for_tags: $('#wppas_adzone_hide_tags').val(),
					hide_for_posts: $('#wppas_adzone_hide_posts').val(),
					hide_for_pages: $('#wppas_adzone_hide_pages').val(),
					auto_show: {
						'post_types': $('#wppas_all_post_ad').val(),
						'position': $('#wppas_all_post_ad_position').val(),
						'paragraph': $('#wppas_all_post_ad_parag').val(),
						'text_wrap': $('#wppas_all_post_ad_text_wrap').val(),
						'shortcode': $('#wppas_all_post_ad_sc').val().replace(/"/g, "'")
					},
					banners: ''
				};
				
				//console.log(adzone_data);
				
				var json_adzone_data = encodeURIComponent(JSON.stringify( adzone_data ));
				
				$.ajax({
				   type: "POST",
				   url: ajaxurl,
				   data: "action=save_vbc_adzone&data="+json_adzone_data+"&aid="+adzone_data.ID+"&return="
				}).done(function( msg ) {
			
					//console.log(msg);
					$('#adzone_ID').val(msg);
					$(this).wppas.wppas_export_adzone(options);
					
					// Save confirm message
					var conf_msg = save_confirms[Math.floor(Math.random()*save_confirms.length)];
					$('.vbc_conf_txt').html(conf_msg);
					$('.vbc_loader_duration').hide();
					$('.vbc_saved_confirm').show();
					
					setTimeout(function(){
						$('.vbc_saved_confirm').hide();
						$('.vbc_loader_bg').hide();
					}, 1000);
				});
			});
			
			
			
			$('.unlink_banner').on('click', function(){
				var bannerID = $(this).data('id'),
					adzoneID = $('#linked_banners_container').data('id');
					
				$('#linked_banners_container').find('.itm_'+bannerID).remove();
				
				var linked_banners = $('#linked_banners_container').sortable('toArray', {attribute: 'data-id'});
				_VBC.wppas.update_adzone_banners({ID: adzoneID, banners: linked_banners});
			});
			
			
			
			
			// -- TRASH ADZONE --
			$('.trash_adzone').on('click', function(){
				
				var ID = $('#adzone_ID').val();
				
				if( ID ){
					$('.vbc_loader_bg').show();
					
					$.ajax({
					   type: "POST",
					   url: ajaxurl,
					   data: "action=trash_vbc_adzone&ID="+ID
					}).done(function( msg ) {
						
						$('.vbc_loader_bg').css({opacity: .9});
						$('.vbc_loader_bg').html(msg);
					});
				}
			});
			
			// -- UNDO ADZONE REMOVAL --
			$('body').on('click', '#wppas_undo_adzone_removal', function(event){
				var ID = $(this).data('id');
				
				if( ID ){
					$('.wppas_remove_confirmation').remove();
					
					$.ajax({
					   type: "POST",
					   url: ajaxurl,
					   data: "action=undo_trash_vbc_adzone&ID="+ID
					}).done(function( msg ) {
				
						//console.log(msg);
						$('.vbc_loader_bg').hide();
					});
				}
			});
			
		},
		
		
		
		
		
		
		
		/**
		 * UPDATE ADZONE BANNERS
		 *
		 *
		 */
		update_adzone_banners:function(options){
			
			var json_adzone_banners = encodeURIComponent(JSON.stringify( options.banners ));
			
			$.ajax({
			   type: "POST",
			   url: ajaxurl,
			   data: "action=update_vbc_adzone_banners&banners="+json_adzone_banners+"&aid="+options.ID+"&return="
			}).done(function( msg ) {
		
				console.log(msg);
			});
		},
		
		
		
		
		/**
		 * EXPORT ADZONE CODE
		 *
		 *
		 */
		wppas_export_adzone: function(options){
			
			var _t = $(this),
				html = '',
				sc = '',
				ifm = '',
				ID = $('#adzone_ID').val() != 0 ? $('#adzone_ID').val() : Math.floor(Date.now() / 1000),
				bsize = $('#wppas_adzone_size').val().split('x');
			
			if( $('#adzone_ID').val() != 0 ){
				
				// SHORTCODE
				sc+= "<input type='text' id='wppas_export_code' value='[wpproads id=\""+ID+"\"]' />";
				sc+= '<span class="description bottom">A Wordpress shortcode to show the adzone on this website only.</span>';
				$('.export_sc_cont').html(sc);
				_t.wppas.focus_textarea($('#wppas_export_code'));
				// end SHORTCODE
				
				// IFRAME
				//var banner_data = JSON.parse(bdata.banner_data);
				ifm+='<textarea id="wppas_iframe_code" style="width:100%; height:100px; font-size: 11px; font-weight: normal; margin-bottom: 10px;" readonly="readonly">';
					ifm+= '<div style="max-width:'+bsize[0]+'px; width:100%; height:'+bsize[1]+'px;">';
						ifm+= '<iframe src="'+URL.url+'?wppasaid='+$('#adzone_ID').val()+'" border="0" scrolling="no" allowtransparency="true" style="width:1px;min-width:100%;*width:100%;height:100%;border:0;"></iframe>';
					ifm+= '</div>';
				ifm+='</textarea>';
				ifm+= '<span class="description bottom">Iframe code. This code can be used to place the banner anywhere you want even on other websites.</span>';
				$('.export_iframe_cont').html(ifm);
				_t.wppas.focus_textarea($('#wppas_iframe_code'));
				// end IFRAME
			}
		}
		
		
		
		
	});
	
}( jQuery ));