/*
 * AJAX UPLOADER
*/


function wppas_vbc_load_ajax_upload(ajaxurl, upload_folder){
	
jQuery(function($){
	
    var wppas_vbc_Upload = {
        init:function () {
			
            window.wppas_vbcUploadCount = typeof(window.vwppas_vbcUploadCount) == 'undefined' ? 0 : window.wppas_vbcUploadCount;
            this.maxFiles = parseInt(wppas_vbc_upload.number);

            //$('#wppas-vbc-upload-imagelist').on('click', 'a.action-delete', this.removeUploads);
			 $('body').on('click', '.wppas_img_remove', this.removeUploads);

            this.attach(upload_folder);
            this.hideUploader();
        },
        attach:function () {
            // wordpress plupload if not found
            if (typeof(plupload) === 'undefined') {
                return;
            }

            if (wppas_vbc_upload.upload_enabled !== '1') {
                return
            }

            var uploader = new plupload.Uploader(wppas_vbc_upload.plupload);
				
            $('#wppas-vbc-uploader').on('click', function(e) {
				//console.log(upload_folder);
                uploader.settings.multipart_params["upload_folder"] = upload_folder;
                uploader.start();
				
                // To prevent default behavior of a tag
                e.preventDefault();
            });

            //initilize  wp plupload
            uploader.init();

            uploader.bind('FilesAdded', function (up, files) {
                $.each(files, function (i, file) {
                    $('#wppas-vbc-upload-imagelist').append(
                        '<div id="' + file.id + '">' +
                            file.name + ' (' + plupload.formatSize(file.size) + ') <b></b>' +
                            '</div>');
                });

                up.refresh(); // Reposition Flash/Silverlight
                uploader.start();
            });

            uploader.bind('UploadProgress', function (up, file) {
                $('#' + file.id + " b").html(file.percent + "%");
            });

            // On error occur
            uploader.bind('Error', function (up, err) {
                $('#wppas-vbc-upload-imagelist').append("<div>Error: " + err.code +
                    ", Message: " + err.message +
                    (err.file ? ", File: " + err.file.name : "") +
                    "</div>"
                );

                up.refresh(); // Reposition Flash/Silverlight
            });

            uploader.bind('FileUploaded', function (up, file, response) {
                var result = $.parseJSON(response.response);
                $('#' + file.id).remove();
				
				console.log(result);
                if (result.success) {
					  window.wppas_vbcUploadCount += 1;
					  
					  if( result.type == 'image' ){
						  $(this).wppas.add_image({'attachment':{'url': result.url, 'id': result.attach_id}});
						//$('#wppas-vbc-upload-imagelist ul').append(result.html);
					  }else if( result.type == 'zip' ){
						  console.log(result.html);
						  $('#all_vbc_items').prepend(result.bnr_item);
						  $('.itm_edit_cont').hide();
					  }

                    //wppas_vbc_Upload.hideUploader();
                }
            });


        },

        hideUploader:function () {

            if (wppas_vbc_Upload.maxFiles !== 0 && window.wppas_vbcUploadCount >= wppas_vbc_Upload.maxFiles) {
                $('#wppas-vbc-uploader').hide();
            }
        },

        removeUploads:function (e) {
            e.preventDefault();

            if (confirm(wppas_vbc_upload.confirmMsg)) {

                var el = $(this),
                    data = {
                        'attach_id':el.data('upload_id'),
                        'nonce':wppas_vbc_upload.remove,
                        'action':'wppas_vbc_delete'
                    };

                $.post(wppas_vbc_upload.ajaxurl, data, function () {
                    el.parent().remove();

                    window.wppas_vbcUploadCount -= 1;
                    if (wppas_vbc_Upload.maxFiles !== 0 && window.wppas_vbcUploadCount < wppas_vbc_Upload.maxFiles) {
                        $('#wppas-vbc-uploader').show();
                    }
                });
            }
        }

    };
	
	wppas_vbc_Upload.init();
	
	
});

}