<?php
class WPPAS_Display_Options {	

	public function __construct() 
	{
		
	}
	
	
	/**
	 * OPTION EXISTS
	 */
	public static function option($options = array(), $value = '', $default = '')
	{
		if( !empty($options) && !empty($value))
		{
			return array_key_exists($value, $options) ? $options[$value] : $default;
		}
		
		return 0;
	}
	
	
	
	
	
	/**
	 * INFO TEXT wrapper
	 */
	public static function info_text($options = array())
	{
		$html = '';
		$js = '';
		
		$info_text = array_key_exists('info_text', $options) ? $options['info_text'] : '';
		$inft_padding = array_key_exists('inft_padding', $options) ? $options['inft_padding'] : 0;
		$inft_cont_bg = array_key_exists('inft_cont_bg', $options) ? ' background-color:'.$options['inft_cont_bg'].';' : '';
		$inft_pos = array_key_exists('inft_pos', $options) ? $options['inft_pos'] : '';
		$inft_font_size = array_key_exists('inft_font_size', $options) ? ' font-size:'.$options['inft_font_size'].'px;' : '';
		$cont_style = self::display_options_css($options);
		
		if(!empty($info_text) || !empty($inft_padding))
		{
			$js.= 'jQuery(".'.$options['unique'].'").wrap("<div class=\'wppas_inlinewrap wppas_inlinewrap_'.$options['unique'].'\' style=\'max-width:'.$options['width'].'; width:100%; padding:'.$inft_padding.';'.$inft_cont_bg.$cont_style.'\'></div>");';
			
			// Pre or Append the info text
			$pos = 'prepend';
			$pos = !empty($inft_pos) && $inft_pos == 'bottom' ? 'append' : $pos;

			$js.= 'jQuery(".wppas_inlinewrap_'.$options['unique'].'").'.$pos.'(\'<div style="max-width:'.$options['width'].'; width:100%; text-align:center;'.$inft_font_size.'">'.$info_text.'</div>\');';
			// Clearfix
			$js.= 'jQuery(".wppas_inlinewrap_'.$options['unique'].'").append(\'<div style="clear:both;"></div>\');';
			//$html.= '<div style="max-width:'.$options['width'].'; width:100%; text-align:center;">'.$options['info_text'].'</div>';
		}
		
		return $js;
		//return $html;
	}
	
	
	/**
	 * BANNER EFFECT
	 */
	public static function banner_effect($options = array())
	{
		$js = '';
		$effect = array_key_exists('effect', $options) ? $options['effect'] : '';	
		
		if( self::is_popup($options) )
		{
			$js.= !empty($effect) ? 'jQuery(".'.$options['unique'].'").show();' : '';
			$js.= !empty($effect) ? 'jQuery(".wppas_ppwrap_'.$options['unique'].'").hide();' : '';
			$js.= !empty($effect) ? 'jQuery(".wppas_ppwrap_'.$options['unique'].'").toggle( "'.$effect.'" );' : '';
		}
		else
		{
			if( !empty($effect) )
			{
				$js.= 'jQuery(".'.$options['unique'].'").toggle( "'.$effect.'", function(){ ';
					$js.= $options['scale'] ? 'jQuery(".'.$options['unique'].'").wppas.scale_banner(jQuery(".'.$options['unique'].'"));' : '';
				$js.= '});';
			}
		}
		
		return $js;
	}
	
	
	
	/**
	 * DISPLAY OPTIONS
	 *
	 */
	public static function display_options_css($options = array())
	{
		$css = '';
		if( !empty($options) )
		{
			// Center
			if(array_key_exists('center', $options))
			{
				$css.= ' margin:0 auto;';
			}
			// Margin
			if(array_key_exists('margin', $options))
			{
				$css.= ' margin:'.$options['margin'].';';
			}
			// Text Wrap (float)
			if(array_key_exists('text_wrap', $options))
			{
				$css.= ' float:'.$options['text_wrap'].';';
			}
			// Position - not used anymore for sticky.
			if(array_key_exists('position', $options))
			{
				$position = $options['position'];
				$css.= ' position:fixed;z-index:9999999;'.self::sticky_positions($position);
			}
			
			if(array_key_exists('display', $options))
			{
				// Popup
				if(self::is_popup($options))
				{
					$css = '';
				}
				
				// Sticky
				if(self::is_sticky($options))
				{
					$css = '';
				}
			}
		}
		
		return $css;	
	}
	
	
	public static function is_popup($options)
	{
		$is_popup = 0;
		if( array_key_exists('display', $options))	
		{
			$is_popup = $options['display'] == 'popup' ? 1 : 0;
		}
		
		return $is_popup;
	}
	
	
	public static function is_sticky($options)
	{
		$is_sticky = 0;
		if( array_key_exists('display', $options))	
		{
			$is_sticky = $options['display'] == 'sticky' ? 1 : 0;
		}
		
		return $is_sticky;
	}
	
	
	
	public static function use_trigger($options)
	{
		$trigger = 0;
		if( array_key_exists('trigger', $options))	
		{
			$trigger = !empty($options['trigger']) ? $options['trigger'] : 0;
		}
		
		return $trigger;	
	}
	
	
	
	
	public static function trigger_js($options)
	{
		$js = '';
		if($options['trigger'] == 'delay')
		{
			$sec = !empty($options['delay']) ? $options['delay']*1000 : 3000;
			$js.= 'setTimeout(function() {';
				$js.= 'window["wppasReloadBnr_'.$options['unique'].'"]();';
			$js.= '}, Number('.$sec.'));';
		}
		else if( $options['trigger'] == 'scroll_detect')	
		{
			$position = !empty($options['scroll_pos']) ? $options['scroll_pos'] : 'middle';
			$pos = $position == 'middle' ? '$("body").height() / 2' : '$("body").height() - 100'; // middle or bottom
			$scroll = $position == 'middle' ? '$(window).scrollTop()' : '$(window).scrollTop() + $(window).height()';
			
			$js.= 'var midHeight = '.$pos.',
				reached_1 = 0;
				
				$(window).scroll(function () {
					var scroll = '.$scroll.';
					
					if (scroll >= midHeight) {
						if(reached_1 == 0){
							reached_1 = 1;
							window["wppasReloadBnr_'.$options['unique'].'"]();
						}
					} /*else {
						if(reached_1 == 1){
							console.log("you reached the middle of the page while scrolling up. "+midHeight+" "+scroll);
							reached_1 = 0;
						}
					}*/
				});';
		}
		else if( $options['trigger'] == 'inactive')
		{
			$sec = !empty($options['inactive_sec']) ? $options['inactive_sec'] : 10;
			
			$js.='var IDLE_TIMEOUT = '.$sec.'; //seconds
				var _idleSecondsTimer = null;
				var _idleSecondsCounter = 0;
				document.onclick = function() {
					_idleSecondsCounter = 0;
				};
				document.onmousemove = function() {
					_idleSecondsCounter = 0;
				};
				document.onkeypress = function() {
					_idleSecondsCounter = 0;
				};
				_idleSecondsTimer = window.setInterval(CheckIdleTime, 1000);
				function CheckIdleTime() {
					 _idleSecondsCounter++;
					 var oPanel = document.getElementById("SecondsUntilExpire");
					 if (oPanel)
						 oPanel.innerHTML = (IDLE_TIMEOUT - _idleSecondsCounter) + "";
					if (_idleSecondsCounter >= IDLE_TIMEOUT) {
						window.clearInterval(_idleSecondsTimer);
						window["wppasReloadBnr_'.$options['unique'].'"]();
					}
				}';
		}
		
		return $js;
	}
	
	
	public static function sticky_positions($position)
	{
		$css = '';
		$pos = explode('_', $position);
		
		if( $pos[0] == 'center' && $pos[1] == 'center'  )
		{
			$css.= 'margin:auto;top:0;left:0;bottom:0;right:0;';
		}
		elseif( $pos[0] == 'center' && $pos[1] != 'center')
		{
			$css.= $pos[1].':0;top:0;bottom:0;margin:auto;';
		}
		elseif( $pos[1] == 'center' && $pos[0] != 'center' )
		{
			$css.= $pos[0].':0;margin:auto;left:0;right:0;';
		}
		else
		{
			$css.= $pos[0].':0;'.$pos[1].':0;';
		}
		
		return $css;
	}	
	
	
	
	
	
	/**
	 * EXTRA DISPLAY HTML
	 *
	 */
	public static function extra_display_html($options)
	{
		$html = '';
		
		if( self::is_popup($options) )
		{
			//$html.= '<div class="wppas_popup_bg" style="z-index:9999998;position:fixed;height:100%;width:100%;background:#FFF;top:0;left:0;opacity:.8;"></div>';
		}
		
		return $html;
	}
	
	
	
	
	
	
	/**
	 * EXTRA DISPLAY JAVASCRIPT
	 *
	 */
	public static function extra_display_js($options)
	{
		$js = '';
		$css = '';
		
		if( self::is_popup($options) )
		{
			$bg_color = array_key_exists('bg', $options) ? $options['bg'] : 'rgba(0,0,0,0.75)';
			
			// Popup BG.
			$js.= 'jQuery("html").css({"overflow":"hidden"});';
			$js.= 'jQuery("body").css({"overflow":"hidden"});';
			$js.= 'jQuery("body").append(\'<div class="wppas_popup_bg wppas_popup_bg_'.$options['unique'].'" style="z-index:9999998;position:fixed;height:100%;width:100%;background:'.$bg_color.';top:0;left:0;"></div>\');'; //opacity:.8;
			// Popup wrapper.
			$js.= 'jQuery(".'.$options['unique'].'").wrap("<div class=\'wppas_ppwrap wppas_ppwrap_'.$options['unique'].'\' style=\'position:fixed;margin:0 auto;top:10%;left:0;right:0;z-index:9999999;max-width:'.$options['width'].';max-height:'.$options['height'].';\'></div>");';
			// append popup wrapper to body to fix z-index issues.
			$js.= 'jQuery(".wppas_ppwrap_'.$options['unique'].'").detach().appendTo("body");';
			// Close Btn
			$js.= 'jQuery(".wppas_ppwrap").append("'.self::close_btn($options).'");';
			
			// Close btn action
			$js.= 'jQuery("#wppas_closepp").on("click", function(){';
				$js.= 'jQuery("html").css({"overflow":"auto"});';
				$js.= 'jQuery("body").css({"overflow":"auto"});';
				$js.= 'jQuery(".wppas_ppwrap_'.$options['unique'].'").remove();';
				$js.= 'jQuery(".wppas_popup_bg_'.$options['unique'].'").remove();';
			$js.= '});';
		}
		
		
		if( self::is_sticky($options) )
		{
			$position = $options['position'];
			$margin = self::margin_css($options);
			$css.= ' position:fixed;z-index:9999999;'.self::sticky_positions($position).$margin;
				
			// Popup wrapper.
			$js.= 'jQuery(".'.$options['unique'].'").wrap("<div class=\'wppas_sswrap wppas_sswrap_'.$options['unique'].'\' style=\''.$css.'max-width:'.$options['width'].';max-height:'.$options['height'].'; width:100%;\'></div>");';
			
			// append popup wrapper to body to fix z-index issues.
			$js.= 'jQuery(".wppas_sswrap_'.$options['unique'].'").detach().appendTo("body");';
		
			$js.= 'jQuery(".wppas_sswrap_'.$options['unique'].'").append("'.self::close_btn($options).'");';
			
			// Close btn action
			$js.= 'jQuery("#wppas_closess_'.$options['unique'].'").on("click", function(){';
				$js.= 'jQuery(".wppas_sswrap_'.$options['unique'].'").remove();';
			$js.= '});';
		}
		
		return $js;
	}
	
	
	
	
	
	
	/**
	 * MARGIN CSS
	 *
	 */
	public static function margin_css($options)
	{
		$margin = array_key_exists('margin', $options) ? $options['margin'] : '';
		$css = '';
		
		if(!empty($margin))
		{
			$mrg = explode(' ',$margin);
			$margins = array(
				'top' => $mrg[0],
				'right' => $mrg[1],
				'bottom' => $mrg[2],
				'left' => $mrg[3]
			);
			
			$css.= !empty($margins['top']) ? ' margin-top:'.$margins['top'].';' : '';
			$css.= !empty($margins['right']) ? ' margin-right:'.$margins['right'].';' : '';
			$css.= !empty($margins['bottom']) ? ' margin-bottom:'.$margins['bottom'].';' : '';
			$css.= !empty($margins['left']) ? ' margin-left:'.$margins['left'].';' : '';
		}
		
		return $css;
	}
	
	
	
	
	
	
	/**
	 * CLOSE BUTTON
	 *
	 */
	public static function close_btn($options)
	{
		$html = '';
		$close_btn_pos = 'right:0;';
		$close_btn_icon = 'times';
		$close_btn_ID = self::is_popup($options) ? 'wppas_closepp' : 'wppas_closess_'.$options['unique'];
		
		// Close btn position
		if( array_key_exists('close_btn_position', $options) )
		{
			 if($options['close_btn_position'] == 'top_left')
			 {
				 $close_btn_pos = 'left:0;';
			 }
		}
		
		// Close btn icon
		if( array_key_exists('close_btn_icon', $options) )
		{
			$close_btn_icon = $options['close_btn_icon'];
		}
		
		$html.= '<a id=\''.$close_btn_ID.'\' data-id=\''.$options['unique'].'\' class=\'wppas_close_bn\' style=\''.$close_btn_pos.'\'><i class=\'fa fa-'.$close_btn_icon.'\' aria-hidden=\'true\'></i></a>';
		
		return $html;
	}
	
}
?>