<?php

class HTPMPRO_Option_Page {

    // Singleton instance
    private static $_instance = null;

    /**
     * Instance
     * Initializes a singleton instance
     * @return self
     */
    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * Private constructor to prevent multiple instances
     */
    private function __construct() {
		add_action( 'admin_menu',  [ $this,'admin_menu'] );
		//add_action( 'admin_init', [$this, 'settings_init'] );
    }

	/**
	 * Adds admin menu for WP Plugin Manager
	 * @return void
	 */
	public function admin_menu () {
		global $submenu;
		
		add_menu_page(
			esc_html__( 'WP Plugin Manager', 'htpmpro' ),
			esc_html__( 'Plugin Manager', 'htpmpro' ),
			'manage_options',
			'htpmpro-options',
			[$this, 'page_render'],
			HTPMPRO_ROOT_URL.'/assets/images/icon/dashboard-menu-logo.png',
			//'dashicons-admin-plugins',
			65
		);

		// Modify the default menu item to point to the general settings
		$submenu['htpmpro-options'][0] = array(
			esc_html__('General', 'htpmpro'),
			'manage_options',
			'admin.php?page=htpmpro-options#/'
		);

		// Add Settings submenu
		add_submenu_page(
			'htpmpro-options',
			esc_html__( 'Settings', 'htpmpro' ),
			esc_html__( 'Settings', 'htpmpro' ),
			'manage_options',
			'admin.php?page=htpmpro-options#/settings'
		);

		// Add Recommended submenu
		add_submenu_page(
			'htpmpro-options',
			esc_html__( 'Recommended', 'htpmpro' ),
			esc_html__( 'Recommended', 'htpmpro' ),
			'manage_options',
			'admin.php?page=htpmpro-options#/recommended'
		);
		// Add License submenu
		add_submenu_page(
			'htpmpro-options',
			esc_html__( 'License', 'htpmpro' ),
			esc_html__( 'License', 'htpmpro' ),
			'manage_options',
			'admin.php?page=htpmpro-options#/license'
		);
		if( is_multisite() ){
			unset($submenu['htpmpro-options'][0]);
		}
	}
	/**
	 * Page Render Contents
	 * @return void
	 */
	public function page_render () {
		// check user capabilities
		if ( !current_user_can( 'manage_options' ) ) {
			return;
		}
		// Render Vue app container
		echo '<div id="htpm-app"></div>';

		return;

	}
}

HTPMPRO_Option_Page::instance();