<?php
/**
 * @var $router WPPayForm\Framework\Http\Router
 */

use WPPayForm\Framework\Request\Request;

$router->prefix('form/{id}')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    $router->get('/payment-settings', function ($formId) {
        return (new \WPPayFormPro\Classes\PaymentsController())->index($formId);
    });
    $router->post('/payment-settings', function (Request $request, $formId) {
        return (new \WPPayFormPro\Classes\PaymentsController())->store($request, $formId);
    });
    $router->prefix('/schedule')->group(function ($router) {
        $router->get('/', function ($formId) {
            return (new \WPPayFormPro\Classes\SchedulingSettings())->getSettings($formId);
        });

        $router->post('/', function (Request $request, $formId) {
            return (new WPPayFormPro\Classes\SchedulingSettings())->updateSettings($request, $formId);
        });
    });

    $router->prefix('/integrations/zapier')->group(function ($router) {
        $router->get('/', function ($formId) {
            return (new WPPayFormPro\Integrations\Zapier\Client())->getNotifications($formId);
        });
        $router->post('/', function (Request $request, $formId) {
            return (new WPPayFormPro\Integrations\Zapier\Client())->saveNotification($request, $formId);
        });
        $router->delete('/', function (Request $request, $formId) {
            return (new WPPayFormPro\Integrations\Zapier\Client())->deleteNotification($request, $formId);
        });
        $router->post('/verify', function (Request $request, $formId) {
            return (new WPPayFormPro\Integrations\Zapier\Client())->verifyEndpoint($formId);
        });
    });
    $router->prefix('/integrations/webhook')->group(function ($router) {
        $router->get('/', function ($formId) {
            return (new WPPayFormPro\Integrations\Webhook\Client())->getWebHooks($formId);
        });
        $router->post('/', function (Request $request) {
            return (new WPPayFormPro\Integrations\Webhook\Client())->saveWebHook($request);
        });
        $router->delete('/', function (Request $request, $formId) {
            return (new WPPayFormPro\Integrations\Webhook\Client())->deleteWebHook($request, $formId);
        });
    });

    $router->prefix('/scripts')->group(function ($router) {
        $router->get('/', function ($formId) {
            return (new WPPayFormPro\Classes\CustomScripts())->getSettings($formId);
        });

        $router->post('/', function (Request $request, $formId) {
            return (new WPPayFormPro\Classes\CustomScripts())->saveSettings($request, $formId);
        });
    });

    $router->prefix('/email')->group(function ($router) {
        $router->get('/', function ($formId) {
            return (new WPPayFormPro\Classes\EmailNotification\EmailAjax())->getNotifications($formId);
        });
        $router->post('/', function (Request $request, $formId) {
            return (new WPPayFormPro\Classes\EmailNotification\EmailAjax())->saveNotifications($request, $formId);
        });

        $router->get('/only', function ($formId) {
            return (new WPPayFormPro\Classes\EmailNotification\EmailAjax())->getNotificationsOnly($formId);
        });

        $router->post('/resend', function (Request $request, $formId) {
            return (new WPPayFormPro\Classes\EmailNotification\EmailAjax())->resendNotifications($request, $formId);
        });
    });
});

$router->prefix('form/{id}/export')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    $router->get('/', function (Request $request, $formId) {
        return (new WPPayFormPro\Classes\Export\Export())->exportData($request, $formId);
    });
});

$router->prefix('settings')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    $router->prefix('/coupon')->group(function ($router) {
        $router->get('/', function () {
            return (new WPPayFormPro\Classes\Coupons\Coupon())->getCoupons();
        });

        $router->post('/', function (Request $request) {
            return (new WPPayFormPro\Classes\Coupons\Coupon())->saveCoupon($request);
        });

        $router->delete('/', function (Request $request) {
            return (new WPPayFormPro\Classes\Coupons\Coupon())->deleteCoupon($request);
        });

        $router->post('/activate', function () {
            return (new WPPayFormPro\Classes\Coupons\Coupon())->enableCoupons();
        });
    });
});


$router->prefix('license')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    $controller = new WPPayFormPro\Classes\LicenseController();

    $router->get('/', function () use ($controller) {
        return $controller->getStatus();
    });
    $router->post('/', function () use ($controller) {
        return $controller->saveLicense();
    });
    $router->delete('/', function () use ($controller) {
        return $controller->deactivateLicense();
    });
});

$router->prefix('dashboard')->withPolicy('WPPayForm\App\Http\Policies\FrontendUserPolicy')->group(function ($router) {
     // check version is 4.6.0 or greater
    if (defined('WPPAYFORM_VERSION') && version_compare(WPPAYFORM_VERSION, '4.6.0', '>=')) {
        $controller = new  WPPayForm\App\Http\Controllers\ReportsController();
        $router->get('/customers/{customer_email}/engagements', function (Request $request, $customerEmail) use ($controller) {
            return $controller->customerEngagements($customerEmail);
        });
        $router->get('/customers/{customer_email}/profile', function (Request $request, $customerEmail) use ($controller) {
            return $controller->customerProfile($customerEmail);
        });
        $router->get('/customers/{customer_email}', function (Request $request, $customerEmail) use ($controller) {
            return $controller->customer($customerEmail);
        });
    }
    
});

$router->prefix('reports')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    // $controller = new WPPayFormPro\Classes\ReportsController();

    // $router->get('/', function () use ($controller) {
    //     return $controller->getReports();
    // });

    // $router->get('/todays-data', function () use ($controller) {
    //     return $controller->getCustomerAndSubmissionReports();
    // });
    // $router->get('/statistics', function () use ($controller) {
    //     return $controller->getStatistics();
    // });

    // $router->get('/recent-revenues', function () use ($controller) {
    //     return $controller->getRecentRevenue();
    // });

    // $router->post('/top-customers', function (Request $request) use ($controller) {
    //     return $controller->topCustomers($request);
    // });

    // $router->get('/customers', function (Request $request) use ($controller) {
    //     return $controller->customers($request);
    // });

    // $router->get('/customers/{customer_email}', function (Request $request, $customerEmail) use ($controller) {
    //     return $controller->customer($customerEmail);
    // });

    // $router->get('/customers/{customer_email}/profile', function (Request $request, $customerEmail) use ($controller) {
    //     return $controller->customerProfile($customerEmail);
    // });

    // $router->get('/customers/{customer_email}/engagements', function (Request $request, $customerEmail) use ($controller) {
    //     return $controller->customerEngagements($customerEmail);
    // });
});

//all payments route, except stripe and paypal
$router->prefix('settings/payments/{payMethod}')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    $router->get('/', function (Request $request, $payMethod) {
        return (new WPPayFormPro\GateWays\PaymentController())->handleEndpoint($request, $payMethod);
    });
    $router->post('/', function (Request $request, $payMethod) {
        return (new WPPayFormPro\GateWays\PaymentController())->handleEndpoint($request, $payMethod);
    });

    $router->get('/verify', function (Request $request, $payMethod) {
        return (new WPPayFormPro\GateWays\PaymentController())->verifyKeys($request, $payMethod);
    });
});

$router->prefix('settings/paypal')->withPolicy('WPPayForm\App\Http\Policies\AdminPolicy')->group(function ($router) {
    $router->get('/', function () {
        return (new WPPayFormPro\GateWays\PayPal\PayPal())->getPaymentSettings();
    });
    $router->post('/', function (Request $request) {
        return (new WPPayFormPro\GateWays\PayPal\PayPal())->savePaymentSettings($request);
    });
});

