<?php

namespace WPPayFormPro\Integrations\Zapier;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Form;

trait NotifyTrait
{

    public function notify($feed, $formData, $entry, $formId)
    {
        try {
            $values = $feed['processedValues'];
            $payload = ['body' => $formData];
            $payload = apply_filters('wpf_integration_data_zapier', $payload, $feed, $entry);
            $response = wp_remote_post($values['url'], $payload);
            if (is_wp_error($response)) {
                $code = Arr::get($response, 'response.code');
                throw new \Exception($response->get_error_message() .', with response code: '.$code, (int)$response->get_error_code());
            } else {
                return $response;
            }
        } catch (\Exception $e) {
            return new \WP_Error('broke', $e->getMessage());
        }
    }
}
