<?php

namespace WPPayFormPro\Integrations\Zapier;

use WPPayForm\App\Services\GeneralSettings;
use WPPayForm\App\Services\Integrations\IntegrationManager;
use WPPayForm\Framework\Foundation\App;
use WPPayForm\App\Models\Meta;
use WPPayForm\Framework\Support\Arr;

class Bootstrap extends IntegrationManager
{
    public $hasGlobalMenu = false;

    public $disableGlobalSettings = 'yes';
    public function __construct()
    {
        parent::__construct(
            App::getInstance(),
            'Zapier',
            'zapier',
            '_zapier_webhook_settings',
            'zapier_feeds',
            10
        );

        $this->logo = WPPAYFORM_URL . 'assets/images/integrations/zapier.png';

        $this->description = 'Get realtime notification in zapier channel when a new submission will be added.';
 
        $this->registerAdminHooks();

        $this->category = 'crm';

        add_filter('wppayform_global_notification_feeds', array($this, 'getZapierFeeds'), 20, 2);

        // add_filter('wppayform_notifying_async_zapier', '__return_false');

        add_filter('wppayform_verify_integration_endpoint_zapier', function($formId) {
           return (new Client)::verifyEndpoint($formId);
        }, 10, 2);
    }

    public function pushIntegration($integrations, $formId)
    {
        $integrations[$this->integrationKey] = [
            'title' => $this->title . ' Integration',
            'logo' => $this->logo,
            'is_active' => 'no',
            'configure_title' => __('Configuration required!', 'wp-payment-form-pro'),
            'global_configure_url' => '#',
            'configure_message' => __('Zapier is not configured yet! Please configure your Zapier api first', 'wp-payment-form-pro'),
            'configure_button_text' => __('Set Zapier', 'wp-payment-form-pro')
        ];
        return $integrations;
    }

    public function getIntegrationDefaults($settings, $formId)
    {
        return [
            'name' => '',
            'url' => '',
            'conditionals' => [
                'conditions' => [],
                'status' => false,
                'type' => 'all'
            ],
            'trigger_on_payment' => false,
            'enabled' => true
        ];
    }

    public function isConfigured()
    {
        return true;
    }

    public function getSettingsFields($settings, $formId)
    {
        return [
            'fields' => [
                [
                    'key' => 'name',
                    'label' => __('Feed Name', 'wp-payment-form-pro'),
                    'required' => true,
                    'placeholder' => __('Your Feed Name', 'wp-payment-form-pro'),
                    'component' => 'text'
                ],
                [
                    'key' => 'url',
                    'label' => __('Webhook URL', 'wp-payment-form-pro'),
                    'required' => true,
                    'placeholder' => __('Enter your Webhook URL', 'wp-payment-form-pro'),
                    'tips' => __('Enter the URL where you want to send the Paymattic submission data.', 'wp-payment-form-pro'),
                    'component' => 'text'
                ],
                [
                    'require_list' => false,
                    'key'          => 'conditionals',
                    'label'        => __('Conditional Logics', 'wp-payment-form-pro'),
                    'tips'         => __('Allow Webhook integration conditionally based on your submission values', 'wp-payment-form-pro'),
                    'component'    => 'conditional_block'
                ],
                [
                    'require_list' => false,
                    'key' => 'enabled',
                    'label' => 'Status',
                    'component' => 'checkbox-single',
                    'checkbox_label' => __('Enable This feed', 'wp-payment-form-pro')
                ],
                [
                    'key' => 'trigger_on_payment',
                    'require_list' => false,
                    'label' => 'Trigger On',
                    'checkbox_label' => __('On Payment Success', 'wp-payment-form-pro'),
                    'component' => 'checkbox-single',
                    'tips' => 'Push data to Zaiper when payment is successful, helpful for payment data tracking.'
                ],
                // [
                //     'key' => 'verify',
                //     'label' => __('Verify Endpoint', 'wp-payment-form-pro'),
                //     'component' => 'verify_button',
                //     'button_text' => __('Send Data Sample', 'wp-payment-form-pro'),
                // ]
            ],
            'button_require_list' => false,
            'integration_title' => $this->title
        ];
    }

    public function getMergeFields($list, $listId, $formId)
    {
        return [];
    }

    public function getZapierFeeds($feeds, $formId)
    {
        $webhookFeeds = Meta::where('form_id', $formId)
        ->where('meta_key', 'zapier')->get();

        if(!$webhookFeeds){
            return $feeds;
        }

        foreach ($webhookFeeds as $feed) {
            $feeds[] = $feed;
        }
        return $feeds;
    }

    public function notify($feed, $formData, $entry, $formId)
    {
        $isEnabled = GeneralSettings::isModuleEnabled('zapier');
        if (!$isEnabled) {
            return;
        }
        $response = $this->getApiClient()->notify($feed, $formData, $entry, $formId);

        if (Arr::get($response, 'response.code') === 200) {
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'success',
                'created_by' => 'Paymattic BOT',
                'title' => 'Zapier',
                'content' => "Successfully pushed data to Zapier webhook."
            ]);
        } else {
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'title' => 'Zapier',
                'content' => "Zapier feed failed (" . Arr::get($response, 'response.message') . ")"
            ]);
        }
    }

    protected function getApiClient()
    {
        return new Client();
    }
}
