<?php

namespace WPPayFormPro\Integrations\Webhook;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


trait NotifyTrait
{

    public function notify($feed, $formData, $entry, $form)
    {
        try {
            $values = $feed['processedValues'];

            $requestHeaders = $this->getWebHookRequestHeaders($values, $formData, $form, $entry->id);

            $requestFormat = Arr::get($values, 'request_format');
            $requestMethod = Arr::get($values, 'request_method');

            if (in_array($requestMethod, ['POST', 'PUT', 'PATCH']) && $requestFormat == 'JSON') {
                $requestHeaders['Content-Type'] = 'application/json';
            }

            $formData = $this->getMaybeWebhookBodyFields($values, $formData, $form, $entry->id);
            

            $formData = json_encode($formData);

            $payload = [
                'body'      => !in_array($requestMethod, ['GET', 'DELETE']) ? $formData : null,
                'method'    => $requestMethod,
                'headers'   => $requestHeaders,
                'sslverify' => apply_filters('wppayform_webhook_ssl_verify', false),
            ];

            $payload = apply_filters('wppayform_integration_data_webhook', $payload, $feed, $entry);
            // dd('payload', $payload);
            $response = wp_remote_post(Arr::get($values, 'request_url'), $payload);

            if (is_wp_error($response)) {
                $code = Arr::get($response, 'response.code');
                throw new \Exception($response->get_error_message() .', with response code: '.$code, (int)$response->get_error_code());
            } else {
                return $response;
            }
        } catch (\Exception $e) {
            return new \WP_Error('broke', $e->getMessage());
        }
    }

    public function getWebHookRequestHeaders($settings, $data, $form, $entryId)
    {
        if ($settings['with_header'] == 'nop') return [];

        $parsedHeaders = $settings['request_headers'];

        $requestHeaders = [];
        foreach ($parsedHeaders as $header) {
            $requestHeaders[$header['key']] = $header['value'];
        }

        $requestHeaders = apply_filters(
            'wppayform_webhook_request_headers',
            $requestHeaders, $settings, $data, $form, $entryId
        );

        unset($requestHeaders[null]);

        return $requestHeaders;
    }

    public function getMaybeWebhookBodyFields($settings, $data, $form, $entryId)
    {  
        if (!isset($settings['with_selected_fields']) || $settings['with_selected_fields'] == 'nop') return $data;
        
        $parsedFields = $settings['selected_request_fields'];
        $webhookFields = [];

        foreach ($parsedFields as $field) {
            $webhookFields[$field['key']] = $field['value'];
        }

        $webhookFields = apply_filters(
            'wppayform_webhook_body_fields',
            $webhookFields, $settings, $data, $form, $entryId
        );

        return $webhookFields;
    }
}

