<?php

namespace WPPayFormPro\Integrations\TutorLMS;

use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Submission;
use WPPayForm\App\Models\Meta;

class RemoveFromCourseAction
{
    public function init()
    {
        add_action('wppayform/after_payment_status_change', array($this, 'handle'), 10, 2);
    }

    public function handle($submissionId, $newStatus)
    {
        if ($newStatus !== 'refunded') {
            return;
        }

        $entry = (new Submission())->getSubmission($submissionId);

        $settings = Meta::getFormMeta($entry->form_id, 'tutorlms_feeds');
        if (!$settings) {
            return;
        }

        $userId = $entry->user_id;
        $courseId = Arr::get($settings, 'course_id');

         // If not in the course || Not enable on refund then skip
        if (!TutorLMSHelper::isInCourses([$courseId], $userId) || !Arr::get($settings, 'remove_on_refund')) {
            return;
        }

        if (!$userId || !$courseId) {
            $message = __('Remove from course Skipped because user/course could not be found -TutorLMS', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $entry->form_id,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
        }

        tutor_utils()->cancel_course_enrol($courseId, $userId, 'delete');

        do_action('wppayform_log_data', [
            'form_id' => $entry->form_id,
            'submission_id' => $entry->id,
            'type' => 'success',
            'created_by' => 'Paymattic BOT',
            'content' => __("User unenrolled from the course due to payment {$newStatus} -TutorLMS", 'wp-payment-form-pro')
        ]);
    }
}