<?php

namespace WPPayFormPro\Integrations\TutorLMS;

use WPPayForm\Framework\Support\Arr;

class AddToCourseAction
{
    public function Add($feed, $formData, $entry, $formId)
    {
        $settings = $feed['processedValues'];

        $customerEmail = Arr::get($formData, 'customer_email');

        if (!is_email($customerEmail)) {
            return;
        }

        $user  = get_user_by('email', $customerEmail);
        $userId = $user ? $user->ID : null;

        $courseId = Arr::get($settings, 'course_id');

        if (!$courseId) {
            $message = __('Data Skipped because no course found', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
            return false;
        }

        if (!$userId) {
            $formData['user_id'] = '';
            // If no user found then let's create a user
            $welcomeEmail = Arr::get($settings, 'send_welcome_email') == 'yes' || Arr::get($settings, 'send_welcome_email') == 1;

            $userId = TutorLMSHelper::createWpUserFromSubscriber($settings, $formData, $entry->id, $welcomeEmail);

            if (is_wp_error($userId)) {
                //user not created
                return false;
            }
        }

        // Autologin process start
        $do_autologin = ((Arr::get($settings, 'do_autologin') == 'yes') || (Arr::get($settings, 'do_autologin') == 1));
        
        if (true == $do_autologin)
        {
            //get the user_id of the current logged-in user (if any)
            $current_user_id = get_current_user_id(); //returns 0 if no user is currently logged-in
            
            if (0 == $current_user_id)
            {
                //$current_user_id is 0, so there is not any current logged-in user
                //execute autologin stuff
                wp_clear_auth_cookie();
                wp_set_current_user($userId);
                wp_set_auth_cookie($userId);

                do_action('wppayform_log_data', [
                    'form_id' => $formId,
                    'submission_id' => $entry->id,
                    'type' => 'failed',
                    'created_by' => 'Paymattic BOT',
                    'content' => "User automatically logged in after course purchase and registration"
                ]);
            }
        }
        // Autologin process end

        if (TutorLMSHelper::isInCourses([$courseId], $userId)) {
            $message = __('User already in the course-TutorLMS', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
            return false;
        }

        $result = tutor_utils()->do_enroll($courseId, 0, $userId);;

        if (!$result) {
            $message = __('User could not be enrolled to the selected course', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
            return false;
        } else {
            // brutforce enrol user to the course especially for the paid course, because we don't have any control over the course enrollment which depends on post_status
            $enroll_data = apply_filters(
                'tutor_enroll_data',
                array(
                    'ID' => $result,
                    'post_status'   => 'completed',
                )
            );
            wp_update_post($enroll_data);
            do_action( 'tutor_after_enrolled', $courseId, $userId, $result);
            // End of brutforce enrol user to the course
            
            $message = __('User enrolled to the selected course-TutorLMS', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'success',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
        }
    }

}
