<?php
namespace WPPayFormPro\Integrations\LifterLMS;

use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Submission;

class LifterLMSHelper
{
    public static function isInCourses($courseIds, $userId, $requireCompleted = false)
    {

        if (!$courseIds) {
            return false;
        }

        if (!$userId) {
            return false;
        }

        $student = llms_get_student($userId);

        if (!$student) {
            return false;
        }

        if ($requireCompleted) {
            $courses = $student->get_completed_courses([
                'limit'  => 10000,
                'status' => 'enrolled'
            ]);
        } else {
            $courses = $student->get_courses([
                'limit'  => 10000,
                'status' => 'enrolled'
            ]);
        }

        if (!$courses || empty($courses['results'])) {
            return false;
        }

        return !!array_intersect($courses['results'], $courseIds);
    }

    public static function createWpUserFromSubscriber($settings, $formData, $entryId, $sendWelcomeEmail = false, $password = '', $role = '', $metaData = [])
    {
        if($userId = $formData['user_id']) {
            return $userId;
        }

        if (isset($settings['password'])) {
            $password = Arr::get($settings, 'password');
        }

       if (isset($settings['username'])) {
          
            $userName = sanitize_user(Arr::get($settings, 'username'));
        }

        if(!$password) {
            if ($userName) {
                $password = $userName;
            } else { 
                $password = wp_generate_password(8);
            }
        }

        $customerEmail = Arr::get($formData, 'customer_email');

        if(!$userName) {
            $userName = sanitize_user($customerEmail);
        }

        $userId = wp_create_user($userName, $password, $customerEmail);

        if (is_wp_error($userId)) {
            return $userId;
        }

        if(!$role) {
            // get default user role of WordPress
            $role = get_option('default_role');
            if(!$role) {
                $role = 'subscriber';
            }
        }


        $user = new \WP_User($userId);
        $user->set_role($role);

        if ($fullName = Arr::get($formData, 'customer_name', false)) {
            $names = static::getSplitName($fullName);
            $metaData['first_name'] = Arr::get($names, 'first_name');
            $metaData['last_name'] = Arr::get($names, 'last_name');
        }

        $userMetas = array_filter($metaData);

        foreach ($userMetas as $metaKey => $metaValue) {
            update_user_meta($userId, $metaKey, $metaValue);
        }

        if ($sendWelcomeEmail) {
            wp_send_new_user_notifications($userId, 'user');
        }

        // save here user id in DB table where user access will added
        (new Submission())->updateSubmission($entryId, [
            'user_id' => $userId
        ]);

        return $userId;
    }


    public static function getSplitName($fullName)
    {
        $contact = [];
        if ($fullName) {
            $nameArray = explode(' ', $fullName);
            if (count($nameArray) > 1) {
                $contact['last_name'] = array_pop($nameArray);
                $contact['first_name'] = implode(' ', $nameArray);
            } else {
                $contact['first_name'] = $fullName;
            }
        }
        return $contact;
    }

}
