<?php

namespace WPPayFormPro\Integrations\LearnDash;

use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Submission;
use WPPayForm\App\Models\Meta;

class RemoveFromCourseAction
{
    public function init()
    {
        add_action('wppayform/after_payment_status_change', array($this, 'handle'), 10, 3);
    }

    public function handle($submissionId, $newStatus)
    {
        if ($newStatus !== 'refunded') {
            return;
        }

        $entry = (new Submission())->getSubmission($submissionId);

        $settings = Meta::getFormMeta($entry->form_id, 'learndash_feeds');
        if (!$settings) {
            return;
        }

        $userId = $entry->user_id;
        $courseId = Arr::get($settings, 'course_id');

        // If not in the course || Not enable on refund then skip
        if (!LearnDashHelper::isInCourses([$courseId], $userId) || !Arr::get($settings, 'remove_on_refund')) {
            return;
        }

        if (!$userId || !$courseId) {
            $message = __('Remove from course Skipped because user/course could not be found -LearnDash', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $entry->form_id,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
        }

        $result = ld_update_course_access($userId, $courseId, true);

        if (!$result) {
            $message = __('User could not be removed from the selected course -LearnDash', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $entry->form_id,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
        } else {
            $message = __("User removed from the course due to payment {$newStatus} -LearnDash", 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $entry->form_id,
                'submission_id' => $entry->id,
                'type' => 'success',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
        }

        return true;
    }
}
