<?php
namespace WPPayFormPro\GateWays\Payrexx\QueryHelper;

use WPPayFormPro\GateWays\Payrexx\QueryHelper\Base;

class Communicator
{
    const VERSION = 'v1';
    const API_URL_FORMAT = 'https://api.%s/%s/%s/%d/%s';
    const API_URL_BASE_DOMAIN = 'payrexx.com';

    public static $methods = array(
        'create'  => 'POST',
        'charge'  => 'POST',
        'refund'  => 'POST',
        'capture' => 'POST',
        'cancel'  => 'DELETE',
        'delete'  => 'DELETE',
        'update'  => 'PUT',
        'getAll'  => 'GET',
        'getOne'  => 'GET',
    );

    public $instance;

    public $apiSecret;

    public $apiBaseDomain;

    public function __construct($instance, $apiSecret, $apiBaseDomain)
    {
        $this->instance = $instance;
        $this->apiSecret = $apiSecret;
        $this->apiBaseDomain = $apiBaseDomain;
    }

    public function getVersion()
    {
        return self::VERSION;
    }

    public function performApiRequest($method, Base $model)
    {
        $params = $model->toArray($method);

        $paramsWithoutFiles = $params;
        unset($paramsWithoutFiles['headerImage'], $paramsWithoutFiles['backgroundImage'], $paramsWithoutFiles['headerBackgroundImage'], $paramsWithoutFiles['emailHeaderImage'], $paramsWithoutFiles['VPOSBackgroundImage']);

        $params['ApiSignature'] =
            base64_encode(hash_hmac('sha256', http_build_query($paramsWithoutFiles, null, '&'), $this->apiSecret, true));

        $params['instance'] = $this->instance;

        $id = isset($params['id']) ? $params['id'] : 0;
        $act = in_array($method, ['refund', 'capture']) ? $method : '';
        $apiUrl = sprintf(self::API_URL_FORMAT, $this->apiBaseDomain, self::VERSION, $params['model'], $id, $act);

        $apiUrl .= "?instance=" . $this->instance;

        $httpMethod = $this->getHttpMethod($method) === 'PUT' && $params['model'] === 'Design'
            ? 'POST'
            : $this->getHttpMethod($method);

        if ($httpMethod === 'POST') {
            $response = wp_remote_post($apiUrl, [
                'headers' => [
                    'Content-type'  => 'application/json'
                ],
                'body'    => $params
            ]);
        } else {
            $response = wp_remote_get($apiUrl, [
                'headers' => [
                    'Content-type'  => 'application/json'
                ],
                'body'    => $params
            ]);
        }

        if (is_wp_error($response)) {
            return $response;
        }

        $body = wp_remote_retrieve_body($response);
        return json_decode($body, true);
    }

    public function getHttpMethod($method)
    {
        if (!$this->methodAvailable($method)) {
            throw new \Exception('Method ' . $method . ' not implemented');
        }
        return self::$methods[$method];
    }

    public function methodAvailable($method)
    {
        return array_key_exists($method, self::$methods);
    }
}
