<?php

namespace WPPayFormPro\GateWays\Payrexx;

use WPPayFormPro\GateWays\BasePaymentMethod;
use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Services\AccessControl;

if (!defined('ABSPATH')) {
    exit;
}
/**
 * Automatically create global payment settings page
 * @param  String: key, title, routes_query, 'logo')
 */
class PayrexxSettings extends BasePaymentMethod
{
    public function __construct()
    {
        parent::__construct(
            'payrexx',
            'Payrexx',
            [],
            WPPAYFORM_URL .'assets/images/gateways/payrexx.svg'
        );
    }
    /**
     * @function mapperSettings, To map key => value before store
     * @function validateSettings, To validate before save settings
     */
    public function init()
    {
        add_filter('wppayform_payment_method_settings_mapper_'.$this->key, array($this, 'mapperSettings'));
        add_filter('wppayform_payment_method_settings_validation_'.$this->key, array($this, 'validateSettings'), 10, 2);
    }

    /**
     * @return Array of global fields
     */
    public function globalFields()
    {
        $webhook_active_url = add_query_arg([
            'wpf_payment_api_notify' => '1',
            'payment_method'=> 'payrexx'
        ], site_url('index.php'));

        return array(
            'is_active' => array(
                'value' => 'no',
                'label' => __('Enable/Disable', 'wp-payment-form'),
            ),
            'payment_mode' => array(
                'value' => 'live',
                'label' => __('Payment Mode', 'wp-payment-form'),
            ),
            'checkout_type' => array(
                'value' => 'modal',
                'label' => __('Checkout Style Type', 'wp-payment-form'),
                'options' => ['modal' => 'Modal checkout style', 'hosted' => 'Hosted payrexx.com style'],
                'type' => 'radio',
                'tooltip' => __('Modal checkout allow you to collects payments on your site,<br/> or you can choose hosted payments to redirect user to the vendor site.', 'wp-payment-form')
            ),
            'instance' => array(
                'value' => 'live',
                'label' => __('Instance Name', 'wp-payment-form'),
                'type' => 'live_pub_key',
                'placeholder' => __('Instance Name', 'wp-payment-form')
            ),
            'api_key' => array(
                'value' => '',
                'label' => __('API Key', 'wp-payment-form'),
                'type' => 'live_secret_key',
                'placeholder' => __('Live Secret Key', 'wp-payment-form')
            ),
            'webhook_desc' => array(
                'value' => "<div> <p>See our <a href='https://paymattic.com/docs/how-to-integrate-payrexx-in-wordpress-with-paymattic/' target='_blank' rel='noopener'>documentation</a> to get more information about payrexx setup.</p> </div> <div> <h3>Payrexx IPN Settings </h3> <p>In order to function completely to get instant payment notification,<br/> Please use this Webhook URL in your Payrexx account. Use the Webhook Type as 'Normal(PHP-Post)'</p> <code> $webhook_active_url </code> </div>",
                'label' => __('Payrexx IPN Settings', 'wp-payment-form'),
                'type' => 'html_attr'
            ),
            'is_pro_item' => array(
                'value' => 'yes',
                'label' => __('PayPal', 'wp-payment-form'),
            ),
        );
    }

    /**
     * @return Array of default fields
     */
    public static function settingsKeys()
    {
        return array(
            'is_active' => 'no',
            'checkout_type' => 'modal',
            'instance' => '',
            'api_key' => '',
            'webhook' => '',
        );
    }
    /**
     * @return Array of global_payments settings fields
     */
    public function getPaymentSettings()
    {
        $settings = $this->mapper(
            $this->globalFields(), 
            static::getSettings()
        );

        return array(
            'settings' => $settings,
            'is_key_defined' => ''
        );
    }

    public function mapperSettings ($settings) {
        $defaults = [
            'is_active' => 'no',
            'checkout_type' => 'modal',
            'instance' => '',
            'api_key' => '',
            'webhook' => site_url('?wpf_payrexx_listener=1')
        ];
        return $this->mapper($defaults, $settings, false);
    }
    /**
     * @return Array of settings for checkout
     * Set defaults fields
     */
    public static function getSettings()
    {
        $settings = get_option('wppayform_payment_settings_payrexx', array());
        return wp_parse_args($settings, static::settingsKeys());
    } 

    public function validateSettings($errors, $settings)
    {
        AccessControl::checkAndPresponseError('set_payment_settings', 'global');
        $mode = Arr::get($settings, 'payment_mode');

        if (empty(Arr::get($settings, 'instance'))) {
            $errors['instance'] = __('Please provide instance name', 'wp-payment-form-pro');
        }

        if (empty(Arr::get($settings, 'api_key'))) {
            $errors['api_key'] = __('Please provide API key', 'wp-payment-form-pro');
        }

        return $errors;
    }

    public static function getApiKeys($formId = false)
    {
        $settings = self::getSettings();
        return array(
            'instance' => Arr::get($settings, 'instance'),
            'api_key' => Arr::get($settings, 'api_key')
        );
    }
}