<?php

namespace WPPayFormPro\GateWays\Payrexx;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit;
}

class PayrexxElement extends BaseComponent
{
    public $gateWayName = 'payrexx';

    public function __construct()
    {
        parent::__construct('payrexx_gateway_element', 11);
        add_filter('wppayform/validate_gateway_api_' . $this->gateWayName, function ($data, $form) {
            return $this->validateApi();
        }, 2, 10);
        add_action('wppayform/payment_method_choose_element_render_payrexx', array($this, 'renderForMultiple'), 10, 3);
        add_filter('wppayform/available_payment_methods', array($this, 'pushPaymentMethod'), 2, 1);
    }

    public function pushPaymentMethod($methods)
    {
        $methods['payrexx'] = array(
            'label' => 'Payrexx',
            'isActive' => true,
            'logo' => WPPAYFORM_URL . 'assets/images/gateways/payrexx.svg',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Payment Option Label',
                    'type' => 'text',
                    'default' => 'Pay with Payrexx'
                ),
            )
        );
        return $methods;
    }


    public function component()
    {
        return array(
            'type' => 'payrexx_gateway_element',
            'editor_title' => 'Payrexx Payment',
            'editor_icon' => '',
            'conditional_hide' => true,
            'group' => 'payment_method_element',
            'method_handler' => $this->gateWayName,
            'postion_group' => 'payment_method',
            'single_only' => true,
            'is_pro' => 'yes',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text'
                )
            ),
            'field_options' => array(
                'label' => __('Payrexx Payment Gateway', 'wp-payment-form-pro')
            )
        );
    }

    public function validateApi()
    {
        $apiKeys = PayrexxSettings::getApiKeys();
        return strlen($apiKeys['instance']) > 0 || strlen($apiKeys['api_key']) > 0;
    }

    public function render($element, $form, $elements)
    {
        $this->loadCheckoutJs();

        if (!$this->validateApi()) { ?>
            <p class="wpf_payment_gateway_validation_error" style="color: red">You did not configure Payrexx payment gateway. Please configure payrexx payment
                gateway from <b>Paymattic->Payment Gateway->Payrexx Settings</b> to start accepting payments</p>
            <?php return;
        }

        echo '<input data-wpf_payment_method="payrexx" type="hidden" name="__payrexx_payment_gateway" value="payrexx" />';
    }

    public function loadCheckoutJs()
    {
        $settings = (new PayrexxSettings())->getPaymentSettings();
        if (Arr::get($settings, 'settings.checkout_type.value') === 'modal') {
            do_action('wppayform_load_checkout_js_payrexx', $settings);
        };
    }

    public function renderForMultiple($paymentSettings, $form, $elements)
    {  
        $this->loadCheckoutJs();

        $component = $this->component();
        $component['id'] = 'payrexx_gateway_element';
        $component['field_options'] = $paymentSettings;
        $this->render($component, $form, $elements);
    }
}
