<?php

namespace WPPayFormPro\GateWays\Payrexx;

use WPPayFormPro\GateWays\Payrexx\QueryHelper\Gateway;
use WPPayFormPro\GateWays\Payrexx\QueryHelper\Communicator;
use WPPayForm\App\Models\Submission;

if (!defined('ABSPATH')) {
    exit;
}


class API
{
    public $communicator;

    public function __construct($instance, $apiSecret, $apiBaseDomain = Communicator::API_URL_BASE_DOMAIN)
    {
        $this->communicator = new Communicator(
            $instance,
            $apiSecret,
            $apiBaseDomain
        );
    }

    public function getVersion()
    {
        return $this->communicator->getVersion();
    }

    public function __call($method, $args)
    {
        if (!$this->communicator->methodAvailable($method)) {
            throw new \Exception('Method ' . $method . ' not implemented');
        }
        if (empty($args)) {
            throw new \Exception('Argument model is missing');
        }
        $model = current($args);
        return $this->communicator->performApiRequest($method, $model);
    }
}
