<?php
namespace WPPayFormPro\GateWays;

use WPPayForm\Framework\Support\Arr;

class PaymentController
{
    public function handleEndpoint($request, $payMethod)
    {
        $type = $request->method();
        $validRoutes = [
            'GET'  => 'getPaymentMethodSettings',
            'POST' => 'savePaymentMethodSettings',
        ];

        if (isset($validRoutes[$type])) {
            return $this->{$validRoutes[$type]}($request, $payMethod);
        }

        die();
    }

    public function verifyKeys($request, $payMethod)
    {
      $response = apply_filters('wppayform_verify_payment_keys_' . $payMethod, [], $request->all());
      if ( isset($response['status']) && $response['status'] == false ) {
            wp_send_json_error([
                'message' => __('Failed to verify credentials', 'wp-payment-form-pro'),
                'errors'  => $response
            ], 423);
      }

      return $response;
    }

    public function getPaymentMethodSettings($request, $payMethod)
    {
        $method = sanitize_text_field($payMethod);
        $settings = apply_filters('wppayform_payment_settings_' . $method, []);
        return $settings;
    }

    public function savePaymentMethodSettings($request, $method)
    {
        $settings = $request->settings;
        $settings = apply_filters('wppayform_payment_method_settings_mapper_' . $method, $settings);
        $validationErrors = apply_filters('wppayform_payment_method_settings_validation_' . $method, [], $settings);

        if ($validationErrors) {
            wp_send_json_error([
                'message' => __('Failed to save settings', 'wp-payment-form-pro'),
                'errors'  => $validationErrors
            ], 423);
        }

        $settings = apply_filters('wppayform_payment_method_settings_save_' . $method, $settings);

        update_option('wppayform_payment_settings_' . $method, $settings, 'yes');

        do_action('wppayform/before_save_payment_settings_' . $method, $settings);

        return array(
            'message' => __('Settings successfully updated', 'wp-payment-form-pro')
        );
    }
}
