<?php

namespace WPPayFormPro\GateWays\Billplz;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Form;

if (!defined('ABSPATH')) {
    exit;
}

class BillplzElement extends BaseComponent
{
    public $gateWayName = 'billplz';

    public function __construct()
    {
        parent::__construct('billplz_gateway_element', 26);
        add_filter('wppayform/validate_gateway_api_' . $this->gateWayName, function ($data, $form) {
            return $this->validateApi();
        }, 2, 10);
        add_action('wppayform/payment_method_choose_element_render_billplz', array($this, 'renderForMultiple'), 10, 3);
        add_filter('wppayform/available_payment_methods', array($this, 'pushPaymentMethod'), 2, 1);
    }

    public function pushPaymentMethod($methods)
    {
        $methods['billplz'] = array(
            'label' => 'Billplz',
            'isActive' => true,
            'logo' => WPPAYFORM_URL . 'assets/images/gateways/billplz.svg',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Payment Option Label',
                    'type' => 'text',
                    'default' => 'Pay with Billplz'
                )
            )
        );
        return $methods;
    }


    public function component()
    {
        return array(
            'type' => 'billplz_gateway_element',
            'editor_title' => 'Billplz Payment',
            'conditional_hide' => true,
            'editor_icon' => '',
            'group' => 'payment_method_element',
            'method_handler' => $this->gateWayName,
            'postion_group' => 'payment_method',
            'single_only' => true,
            'is_pro' => 'yes',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text'
                )
            ),
            'field_options' => array(
                'label' => __('Billplz Payment Gateway', 'wp-payment-form-pro')
            )
        );
    }

    public function validateApi()
    {
        $apiKeys = BillplzSettings::getApiKeys();
        return strlen($apiKeys['collection_id']) > 0 || strlen($apiKeys['api_secret']) > 0;
    }

    public function isSupportedCurrency($formId)
    {
        $currencySetting = Form::getCurrencySettings($formId);
        return Arr::get($currencySetting, 'currency') === 'MYR';
    }

    public function render($element, $form, $elements)
    {
        if (!$this->validateApi()) { ?>
            <p  class="wpf_payment_gateway_validation_error" style="color: red">You did not configure Billplz payment gateway. Please configure billplz payment
                gateway from <b>Paymattic->Payment Gateway->Billplz Settings</b> to start accepting payments</p>
            <?php return;
        }

        if (!$this->isSupportedCurrency($form->ID)) { ?>
            <p style="color: red">Billplz doesn't support currency except MYR (Malaysian Ringgit)!<br/>
                Set currency MYR from <b>Paymattic->Settings->Currency</b> to start accepting payments !</p>
            <?php return;
        }

        echo '<input data-wpf_payment_method="billplz" type="hidden" name="__billplz_payment_gateway" value="billplz" />';
    }

    public function renderForMultiple($paymentSettings, $form, $elements)
    {
        $component = $this->component();
        $component['id'] = 'billplz_gateway_element';
        $component['field_options'] = $paymentSettings;
        $this->render($component, $form, $elements);
    }
}
